<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Integrations\Salog\ePod\AbstractXMLData;
use App\Integrations\Salog\ePod\IntegrationService;
use App\PodUploads\Constants\DocumentType;
use App\ApiRequest\SendDocumentGateOut;

class Singlestatusmodel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common','Standardbookingmodel']);
        $this->load->library(['Standard_status_execution','Altovaordercreation']);
        $this->load->library('UpdateTripOrderCloseStatus', null, 'UpdateTripOrderCloseStatus');
    }
    
    public function updateStatus(string $ordersData): string
    {
        //("error","ordersData:".json_encode($ordersData));
        $ordersInfoData = json_decode($ordersData, true);
        $message = "0";
        //log_message("error","ordersInfo:".json_encode($ordersInfoData));
        foreach ($ordersInfoData as $orders) {
            $getOrderInfo = $this->common->getjointbldata("tb_orders o", "tb_customers c", "o.customer_id = c.id", ['o.order_id' => $orders['OrderID']], "o.id,o.user_id,o.shipmentid,o.shift_id,o.trip_id,o.created_source,o.vendor_id,c.sendto_knlogin,o.company_code", 0, 0);
                $orderInfo = $getOrderInfo[0] ?? [];
            //("error","orderInfo1111:".$this->db->last_query());
            if (!empty($orderInfo)) {
                $orderId = $orderInfo['id'];
                $userId = $orderInfo['user_id'];
                $shipmentId = $orderInfo['shipmentid'];
                $createdsource = $orderInfo['sendto_knlogin'] === '1' ? "11" : $orderInfo['created_source'];
                $shiftDetails = $this->common->gettblrowdata(
                    ["shipmentid" => $shipmentId],
                    "id,startdate,enddate",
                    "tb_shifts",
                    0,
                    0
                );
                if (count($shiftDetails) > 0) {
                    $shiftRowId = $shiftDetails['id'];
                    $startTime = $shiftDetails['startdate'];
                    $endTime = $shiftDetails['enddate'];
                } else {
                    return 0;
                }
                $countryCode = "";
                $countryCodeDetails = $this->db->query("SELECT country_code FROM tb_users WHERE id = ?", [$userId]);
                if ($countryCodeDetails->num_rows() > 0) {
                    $countryCode = $countryCodeDetails->row()->country_code;
                }
                if ("" != $countryCode) {
                    $countryTimeZone = $this->db->query("SELECT cntry_timezone,cntry_hrs FROM tbl_country_master WHERE country_code =? AND status=1 LIMIT 1", [$countryCode]);
                    if ($countryTimeZone->num_rows() > 0) {
                        $curtz = $countryTimeZone->row()->cntry_timezone;
                        $hrs = $countryTimeZone->row()->cntry_hrs;
                    } else {
                        $curtz = "Asia/Singapore";
                        $hrs = "+08.00";
                    }
                } else {
                    $curtz = "Asia/Singapore";
                    $hrs = "+08.00";
                }

                $date = str_replace("T", " ", $orders['datetime']);
                $pickupDate = getdatetimebytimezone(DFLT_TZ, $date, $curtz);
                $date = $pickupDate['datetime'];
                $latitude = $orders['lat'];
                $longitude = $orders['lng'];
                $vehicleId = $driverId = "";
                $getDriverVehInfo = $this->db->query("SELECT tr.vehicle_id,ad.driver_id,ad.imei FROM tb_trips tr INNER JOIN tbl_assigned_drivers ad ON tr.vehicle_id = ad.vehicle_id WHERE tr.shift_id= ? AND ad.status=1 GROUP BY tr.shift_id ORDER BY tr.id DESC", [$shiftRowId]);
                if ($getDriverVehInfo->num_rows() > 0) {
                    $driverVehResults = $getDriverVehInfo->result_array();
                    $vehicleId = $driverVehResults[0]['vehicle_id'];
                    $driverId = $driverVehResults[0]['driver_id'];
                    $imei = $driverVehResults[0]['imei'];
                } else {
                    $DriverVehInfo = $this->db->query("SELECT sv.vehicle_id,ad.driver_id,ad.imei FROM tb_shft_veh sv INNER JOIN tbl_assigned_drivers ad ON sv.vehicle_id = ad.vehicle_id WHERE sv.shft_id= ? AND ad.status=1 GROUP BY sv.shft_id ORDER BY sv.id DESC ", [$shiftRowId]);
                    if ($DriverVehInfo->num_rows() > 0) {
                        $driverVehResults = $DriverVehInfo->result_array();
                        $vehicleId = $driverVehResults[0]['vehicle_id'];
                        $driverId = $driverVehResults[0]['driver_id'];
                        $imei = $driverVehResults[0]['imei'];
                    }
                }
                $pickup_stopId = $drop_stopid = $drop_stopDetRowId = $pickup_stopDetRowId = 0;
                $StopDetails = $this->common->gettblrowdata([
                    "order_id" => $orders['OrderID'],
                ], "id,stop_id,drop_stopid", "tb_employee", 0, 0);
                if (count($StopDetails) > 0) {
                    $pickup_stopId = $StopDetails['stop_id'];
                    $drop_stopid = $StopDetails['drop_stopid'];
                    $pickup_stopDetRowId = $drop_stopDetRowId = $StopDetails['id'];
                }
                if ($vehicleId == "") {
                    $vehicleId = $this->getCarrierVehicleid($orderInfo['vendor_id'], $shiftRowId, $userId);
                }
                if ($driverId == "") {
                    $driverId = $this->getVehicleDriversid($orderInfo['vendor_id'], $shiftRowId, $userId, $vehicleId);
                }

                $checkTrip = $this->db->select("id")->get_where(
                    "tb_trips",
                    ['shift_id' => $shiftRowId],
                    1,
                    0
                );
                if ($checkTrip->num_rows() == 0) {
                    $triparr = [
                        'shift_id' => $shiftRowId,
                        'vehicle_id' => $vehicleId,
                        'driver_id' => $driverId,
                        'stime' => $startTime,
                        'etime' => $endTime,
                        'start_imei' => $imei,
                        'splace' => "",
                        'eplace' => "",
                        'start_reading' => 0,
                        'end_reading' => 0,
                        'created_on' => $date,
                        'updated_on' => $date,
                        'status' => 1,
                        'trip_type' => 0,
                        'transit_status' => 0,
                        "plat" => $latitude,
                        "plng" => $longitude,
                    ];
                    $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                     $this->db->set(["trip_id" => $arr['trip']])->where(["shift_id" => $shiftRowId])->update("tb_orders");
                    /*if ($XBRDROrder === 1) {
                        $this->common->updatetbledata("tb_employee", ['trip_id' => $arr['trip']], ["shift_id" => $shiftRowId]);
                    } else {
                        $this->db->set(["trip_id" => $arr['trip']])->where(["shift_id" => $shiftRowId])->update("tb_orders");
                    }*/
                } else {
                    $arr['trip'] = $checkTrip->row()->id;
                }
                $result = $this->db->query('SELECT id from tb_status_master WHERE status_code = ? and status <> ?', [$orders['statuscode'], 0]);
				//log_message('error', "query:" . $this->db->last_query());
				$statusId = (int)$result->row()->id ?? 0;
                $stopStatusData = [
                    "order_id" => $orderId,
                    "shipment_id" => $shiftRowId,
                    "stop_id" => "0",
                    "stop_detail_id" => "0",
                    "stop_type" => "",
                    "trip_id" => $arr['trip'],
                    "status_id" => $statusId,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "loc_name" => $orders['location'],
                    "status" => 1,
                    "reason" => 'From EDI',
                    "comment" => $orders['referenceValue'] ?? "",
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $driverId,
                    "status_code" => $orders['statuscode'],
                    "createdon" => $date,
                ];
                $pickAndDropIds = [
                    'pickupStopId' => $pickup_stopId,
                    'pickupStopDetailRowId' => $pickup_stopDetRowId,
                    'dropStopId' => $drop_stopid,
                    'dropStopDetailRowId' => $drop_stopDetRowId
                ];
                $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
            }
            $message = "1";
        }
        return $message;
    }

    private function insertStatusCodes(array $stopStatusData, array $pickAndDropIds, bool $updateCreatedOnDate = false): void
    {
        //log_message("error","test:".json_encode($stopStatusData));
        //log_message("error","test11:".json_encode($pickAndDropIds));
        if ($stopStatusData['status_code'] == "SV220" || $stopStatusData['status_code'] == "SV230" ) {
            $this->insertIntransitStatus($stopStatusData);
        }
        //log_message("error","updateCreatedOnDate:".$updateCreatedOnDate);
        if ($updateCreatedOnDate) {
            $this->db->where([
                'order_id' => $stopStatusData['order_id'],
                'status_code' => $stopStatusData['status_code'],
                'status' => 1
            ])->update("tb_stop_status", [
                'loc_name' => $stopStatusData['loc_name'],
                'createdon' => $stopStatusData['createdon']
            ]);
        } else {
            $checkRecord = $this->db->select("id")->get_where(
                "tb_stop_status",
                ["order_id" => $stopStatusData['order_id'],"shipment_id"=>$stopStatusData['shipment_id'],"status_code" => $stopStatusData['status_code']],
                1,
                0
            );
            //log_message("error","qry111::".$this->db->last_query());
            $statusData = $this->getStatusData($stopStatusData['status_code'],  $stopStatusData['status_id'], $pickAndDropIds);
            //log_message("error","statusData['statusId']::".$stopStatusData['status_id']);
            if ($checkRecord->num_rows() > 0) {
                if (in_array($stopStatusData['status_code'], ['SV0100', 'SV0110', 'SV0130', 'SV0140','SV0310', 'SV0410', 'SV0510', 'SV0520'])) {
                    $this->db->where([
                        'order_id' => $stopStatusData['order_id'],
                        'status_code' => $stopStatusData['status_code'],
                        'status' => 1
                     ])->update("tb_stop_status", [
                        'loc_name' => $stopStatusData['loc_name'],
                        'createdon' => $stopStatusData['createdon']
                    ]);
                    //log_message("error","test111:",$this->db->last_query());
                }
                else
                {
                    $stopStatusData['stop_id'] = $statusData['stopId'];
                    $stopStatusData['stop_detail_id'] = $statusData['stopDetailId'];
                    $stopStatusData['status_id'] = $statusData['statusId'];
                    $stopStatusData['stop_type'] = $statusData['statusType'];
                    $stopStatusData['carrier_status_trigger'] = 1;
                    $this->db->insert("tb_stop_status", $stopStatusData);
                    //log_message("error","test222:",$this->db->last_query());
                }
            }
            else
            {
                $stopStatusData['stop_id'] = $statusData['stopId'];
                $stopStatusData['stop_detail_id'] = $statusData['stopDetailId'];
                $stopStatusData['status_id'] = $statusData['statusId'];
                $stopStatusData['stop_type'] = $statusData['statusType'];
                $stopStatusData['carrier_status_trigger'] = 1;
                $this->db->insert("tb_stop_status", $stopStatusData);
                //log_message("error","test333:",$this->db->last_query());
            }
            
            
            
            /*if (in_array($orders['statuscode'], ['SV0100', 'SV0110', 'SV0130', 'SV0140','SV0310', 'SV0410', 'SV0510', 'SV0520'])) {
                $stopStatusData['stop_id'] = $statusData['stopId'];
                $stopStatusData['stop_detail_id'] = $statusData['stopDetailId'];
                $stopStatusData['status_id'] = $statusData['statusId'];
                $stopStatusData['stop_type'] = $statusData['statusType'];
                $stopStatusData['carrier_status_trigger'] = 1;
                $this->db->insert("tb_stop_status", $stopStatusData);
            }
            else
            {
                 $this->db->where([
                    'order_id' => $stopStatusData['order_id'],
                    'status_code' => $stopStatusData['status_code'],
                    'status' => 1
                 ])->update("tb_stop_status", [
                    'loc_name' => $stopStatusData['loc_name'],
                    'createdon' => $stopStatusData['createdon']
                ]);
            }*/

            /*$getBookingID = $this->common->gettblrowdata(["id" => $stopStatusData['order_id']], "order_id,user_id,company_code", "tb_orders", 0, 0);
            $BookingID = $timezone = "";
            if (!empty($getBookingID)) {
                $BookingID = $getBookingID["order_id"];
                $timezone = $this->getUsersTimezone($getBookingID["user_id"]);
                $companyCode = $getBookingID["company_code"];
                $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $stopStatusData['status_code'])) {
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->sendNotificationToConsignee($stopStatusData['order_id'], $stopStatusData['status_code']);
                }
                if (checkAccessConditions('WECHAT_COUNTRY', $companyCode) && $stopStatusData['status_code'] === "0212") {
                    $this->load->library('Wechat');
                    $this->wechat->orderId = $stopStatusData['order_id'];
                    $this->wechat->sendNotificationsToWeChat();
                }
            }
            try {
                 $statusPayload = [
                    "trip" => $stopStatusData['trip_id'],
                    "ship" => $stopStatusData['shipment_id'],
                    "ord_id" => $stopStatusData['order_id'],
                    "orderid" => $BookingID,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "vehicle_id" => $stopStatusData['vehicle_id'],
                    "driver_id" => $stopStatusData['driver_id'],
                    "stop_type" => "P",
                    "timezone" => $timezone,
                    "sts_date" => $stopStatusData['createdon'],
                    "status_code" => $stopStatusData['status_code']
                ];
                $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                $this->altovaordercreation->sendOrderToAltova($stopStatusData['order_id'], $stopStatusData['status_code']);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
            }*/
        }
    }

    public function podImageDb(array $orderInfo,
        string $latitude,
        string $longitude,
        string $date,
        string $podUrl,
        int $drop_stopid): void
    {
        $imagetype = pathinfo($podUrl, PATHINFO_EXTENSION);
        $fileName = $this->podImageFolder($podUrl, $imagetype);
        if($fileName == ''){
            return;
        }
        $insarry = [
            "order_id" => $orderInfo['id'],
            "trip_id" => $orderInfo['trip_id'],
            "shipment_id" => $orderInfo['shift_id'],
            "user_id" => $orderInfo['user_id'],
            "doc_type" => 1,
            "stop_type" => "D",
            "stop_id" => $drop_stopid,
            "latitude" => $latitude,
            "longitude" => $longitude,
            "imgpath" => $fileName,
            "createdon" => $date,
        ];
        $this->db->insert("tb_pod_uploads", $insarry);
    }

    public function podImageFolder(string $podUrl, string $imagetype): string
    {
        define('UPLOAD_DIR_POD', NEW_POD_PATH);
        $image_base64 = base64_decode($podUrl, true);
        $fileName = md5(uniqid('', true).date('YmdHis')) . '.'.$imagetype;
        $file = UPLOAD_DIR_POD . $fileName;
        if (!file_exists(dirname($file))) {
            if (!mkdir($concurrentDirectory = dirname($file), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($file, $image_base64);
        $info = filesize(UPLOAD_DIR_POD .$fileName);
        $bits = $info ?? 0;
        if($bits == 0){
            unlink($file);
            $fileName = '';
        }
        return $fileName;
    }

    public function uploadOrderPod(string $ordersData,  CI_Controller $CI): string
    {
        $ordersInfo = json_decode($ordersData, true);
        $action = $ordersInfo['action'];
        $documentType = $ordersInfo['documentType'];
        $getBookingID = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT OUTER JOIN tb_order_references tr ON tr.order_id=o.id WHERE tr.reference_id IN ? AND tr.`ref_value`= ? AND tr.`status`=1 LIMIT 1", [['INN','DLR'],$ordersInfo['OrderID']]);
        $order_id = ($getBookingID->num_rows() > 0) ? $getBookingID->row()->order_id : $ordersInfo['OrderID'];
        $documentName = $ordersInfo['documentName'];
        $documentURL = $ordersInfo['documentURL'];
        $documentFile = $ordersInfo['documentFile'];
        $receiverName = $ordersInfo['receiverName'];
        if ($documentFile === "") {
            log_message("error", "there is no document for the order " . $order_id);
            return 'Document Upload failed';
        }
        $imagetype = pathinfo($documentName, PATHINFO_EXTENSION);
        $fileName = $this->podImageFolder($documentFile, $imagetype);
        if($fileName === ''){
            log_message("error", "Document File Name empty " . $order_id);
            return 'Document Upload failed';
        }
        $message ="Driver is not accepted for this order : ". $order_id;
        $orderId = $shift_id = $trip_id = $userId = $stop_id = $drop_stopid = $stop_detail_id = 0;
        $getOrderDetails = $this->db->query(
            "SELECT o.id,o.user_id,o.shift_id,o.trip_id,te.`stop_id`,te.`drop_stopid`,te.id AS stop_detail_id, o.created_source,o.company_code,o.branch_code,o.plat, o.plng  FROM tb_orders o LEFT OUTER JOIN `tb_employee` te ON o.order_id=te.order_id
 WHERE o.order_id= ? GROUP BY o.order_id",
            $order_id
        );
        if ($getOrderDetails->num_rows() > 0) {
            $OrderDetails = $getOrderDetails->result_array();
            $orderId = $OrderDetails[0]['id'];
            $userId = $OrderDetails[0]['user_id'];
            $shift_id = $OrderDetails[0]['shift_id'];
            $trip_id = $OrderDetails[0]['trip_id'];
            $stop_id = $OrderDetails[0]['stop_id'];
            $drop_stopid = $OrderDetails[0]['drop_stopid'];
            $stop_detail_id = $OrderDetails[0]['stop_detail_id'];
            $created_source = $OrderDetails[0]['created_source'];
        }
        $stop_type = ($documentType == "POD") ? "D" : "P";
        $stop_value = ($documentType == "POD") ? $drop_stopid : $stop_id;
        $orderDocumentType = $this->getDocumentType($documentType);
        $date = date('Y-m-d H:i:s');
        if ($trip_id != 0 && $shift_id != 0) {
            $insarry = [
                "order_id" => $orderId,
                "trip_id" => $trip_id,
                "shipment_id" => $shift_id,
                "user_id" => $userId,
                "doc_type" => $orderDocumentType,
                "stop_type" => $stop_type,
                "stop_id" => $stop_value,
                "stop_detail_id" => $stop_detail_id,
                "latitude" => "",
                "longitude" => "",
                "imgpath" => $fileName,
                "receiver_name" => $receiverName,
                "createdon" => $date,
            ];
            $this->db->insert("tb_pod_uploads", $insarry);
            $rlgRefVal = $this->common->gettblrowdata(['order_id' => $orderId, 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
            $created_source = (count($rlgRefVal) > 0) ? "18" : $created_source;
            if ($created_source == 18) {
                $countryCodeDetails = $this->db->query("SELECT country_code FROM tb_users WHERE id = ?", [$userId]);
                $countryCode =  ($countryCodeDetails->num_rows() > 0) ? $countryCodeDetails->row()->country_code : "";
                $data = [
                    "order_id" => $orderId,
                    "ord_id" => $order_id,
                    'country_code' => $countryCode,
                    'company_code' => $OrderDetails[0]['company_code'],
                    'branch_code' => $OrderDetails[0]['branch_code'],
                    'shipment_id' => $shift_id,
                    'trip_id' => $trip_id,
                    'stop_id' => $stop_id,
                    'doc_type' => DocumentType::DOCUMENT_NAME_MAPPING[$orderDocumentType],
                    'userid' => $userId,
                    'filename' => $fileName
                ];
                $this->pushOrderDocumentsToRoadlog($data, $CI);
            }

            if ($created_source == 5) {
                $salogXmlData = AbstractXMLData::getDataProvider($orderDocumentType);
                $salogePodIntegrationService = new IntegrationService();
                $salogePodIntegrationService->sendePod(
                    $salogXmlData->getData($shift_id, $trip_id, $stop_id, $order_id, $orderId, $OrderDetails[0]['plat'], $OrderDetails[0]['plng']),
                    $salogXmlData->getOrderType()
                );
            }
            $message = "Document Uploaded Successfully";
        }
        return $message;
    }

    public function getDocumentType(string $documentType): int
    {
        if ($documentType == "") {
            return 1;
        }
        $GetOrderdocumentType = $this->db->query("SELECT id FROM `tb_document_types` WHERE type_name=?", [$documentType]);
        return $GetOrderdocumentType->num_rows() > 0 ? $GetOrderdocumentType->row()->id : 1;
    }

    public function updateCustomStatus(string $ordersData,int $edilogid): string
    {
        $ordersInfo = json_decode($ordersData, true);
        foreach ($ordersInfo as $orders) {
            $OrderID = $orders['OrderID'];
            $status_name = $orders['statusvalue'];
            $statuscode = $orders['statuscode'];
            $datetime = $orders['datetime'];
            $actionuser = $orders['actionuser'];

            // Get order id
            $GetOrderId = $this->db->query("SELECT id, user_id,company_code,branch_code,shift_id,trip_id FROM `tb_orders` WHERE order_id=?", [$OrderID]);
            $order_id = $GetOrderId->row()->id;

            $curtz = $this->getUsersTimezone($GetOrderId->row()->user_id);
            //log_message("error", "getUsersTimezone " . $curtz);
            //log_message("error", "getUsersTimezone " . $datetime);
            $datetime = (getdatetimebytimezone(DFLT_TZ, $datetime, $curtz))['datetime'];
            //log_message("error", "getUsersTimezone " . $datetime);
            $cdate = date('Y-m-d H:i:s');
            $getstatuscode = $this->db->query("SELECT id FROM tb_status_master WHERE status_code =?", [$statuscode]);
            $statusCodes = ['1075', '0420', '0500', '0191', '1550', '0192', '2300', '3000', '0218', '0212'];
            if (!in_array($statuscode, $statusCodes)) {
                if ($getstatuscode->num_rows() == 0) {
                    $insarry = ['status_name' => $status_name, 'description' => $status_name, 'status_type' => 'yes', 'status_code' => $statuscode, 'customer_id' => '0', 'company_code' => '', 'branch_code' => '', 'status' => 1, 'createdon' => $cdate, 'updatedon' => $cdate];
                    $this->db->insert("tb_status_master", $insarry);
                    $status_id = $this->db->insert_id();

                    $getOrderdata = $this->db->query("SELECT * FROM tb_order_status WHERE order_id =? and status_id=? and status_code= ?", [$order_id, $status_id, $statuscode]);
                    if ($getOrderdata->num_rows() == 0) {
                        $inOrderarry = ['order_id' => $order_id, 'status_id' => $status_id, 'status_code' => $statuscode, 'status_date' => $datetime, 'status' => 1, 'createdon' => $cdate, 'updatedon' => $cdate, 'action_user' => $actionuser];
                        $this->db->insert("tb_order_status", $inOrderarry);
                    } else {
                        $this->orderStatusUpdate($getOrderdata->row()->id, $cdate, $datetime);
                    }
                } else {
                    $status_id = $getstatuscode->row()->id;
                    $getOrderdata = $this->db->query("SELECT id FROM tb_order_status WHERE order_id =? and status_id=? and status_code= ?", [$order_id, $status_id, $statuscode]);
                    if ($getOrderdata->num_rows() == 0) {
                        $inOrderarry = ['order_id' => $order_id, 'status_id' => $status_id, 'status_code' => $statuscode, 'status_date' => $datetime, 'status' => 1, 'createdon' => $cdate, 'updatedon' => $cdate, 'action_user' => $actionuser];
                        $this->db->insert("tb_order_status", $inOrderarry);
                    } else {
                        $this->orderStatusUpdate($getOrderdata->row()->id, $cdate, $datetime);
                    }
                }
            }
            $ordersData = [];
            $statusCodes = ['1075', '0420', '0500', '0191', '1550', '0192', '2300', '3000', '0218', '0212'];
            if (in_array($statuscode, $statusCodes)) {
                $ordersData[] = [
                    "OrderID" => $OrderID,
                    "statustype" => $statuscode,
                    "statuscode" => $statuscode,
                    "statusvalue" => $status_name,
                    "datetime" => $orders['datetime'],
                    "lat" => "",
                    "lng" => "",
                    "location" => "",
                    "actionuser" => $actionuser,
                    "PODURL" => "",
                    "timezone" => "",
                    "utc" => "",
                    "referenceCode" => "",
                    "externalreferenceid" => "",
                    "referenceValue" => ""
                ];
                $this->updateStatus(json_encode($ordersData));
            } else {
                try {
                    $statusPayload = [
                        "trip" => $GetOrderId->row()->trip_id ?? "",
                        "ship" => $GetOrderId->row()->shift_id ?? "",
                        "ord_id" => $order_id,
                        "orderid" => $OrderID,
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "vehicle_id" => 0,
                        "driver_id" => 0,
                        "stop_type" => 0,
                        "timezone" => $curtz,
                        "sts_date" => $datetime,
                        "status_code" => $statuscode
                    ];
                    $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                    $this->altovaordercreation->sendOrderToAltova($order_id, $statuscode);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                }
            }



           /*update edi log*/
            $whr = ["id" => $edilogid];
            $set = [
                "status" => 1,
                "txn_obj_id" => $order_id,
                "user_id" => $GetOrderId->row()->user_id,
                'company_code' => $GetOrderId->row()->company_code,
                'branch_code' => $GetOrderId->row()->branch_code,
                "edi_response" => "Order Status successfully"
            ];

            $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
        }
        return "Status Insert";
    }

    public function getUsersTimezone(int $userId): string
    {
        $countryCodeDetails = $this->db->query(
            "SELECT country_code FROM tb_users WHERE id = ? ",
            [ $userId ]
        );
        if (!$countryCodeDetails->num_rows()) {
            return "Asia/Singapore";
        }

        $countryTimeZone = $this->db->query(
            "SELECT cntry_timezone FROM tbl_country_master WHERE country_code = ? AND status=1 LIMIT 1",
            [  $countryCodeDetails->row()->country_code ]
        );
        if (!$countryTimeZone->num_rows()) {
            return "Asia/Singapore";
        }

        return $countryTimeZone->row()->cntry_timezone;
    }

    private function orderStatusUpdate($orderStatusId, $currentDate, $dateTime)
    {
        $this->db->query('update tb_order_status set status_date=?,updatedon=? where id=?',
            [$dateTime, $currentDate, $orderStatusId]);
    }

    private function getStatusData(string $code, int $statusId, array $pickAndDropIds): array
    {
        switch ($code) {
            case "SV0100":
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            case "SV0110":
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            case "SV0120":
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            case "SV0121":
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            case "SV0122":
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            case "SV0130":
                $statusData['stopId'] = $pickAndDropIds['pickupStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "P";
                break;
            case "SV0140":
                $statusData['stopId'] = $pickAndDropIds['pickupStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "P";
                break;
            case "SV0210":
                $statusData['stopId'] = $pickAndDropIds['pickupStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "P";
                break;
            case "SV0220":
                $statusData['stopId'] = $pickAndDropIds['pickupStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "P";
                break;
            case "SV0230":
                $statusData['stopId'] = $pickAndDropIds['pickupStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "P";
                break;
            case "SV0310":
                $statusData['stopId'] = $pickAndDropIds['dropStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['pickupStopDetailRowId'];
                $statusData['statusId'] =$statusId;
                $statusData['statusType'] = "D";
                break;
            case "SV0410":
                $statusData['stopId'] = $pickAndDropIds['dropStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['dropStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "D";
                break;
            case "SV0510":
                $statusData['stopId'] = $pickAndDropIds['dropStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['dropStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "D";
                break;
            case "SV0520":
                $statusData['stopId'] = $pickAndDropIds['dropStopId'];
                $statusData['stopDetailId'] = $pickAndDropIds['dropStopDetailRowId'];
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
            default:
                $statusData['stopId'] = 0;
                $statusData['stopDetailId'] = 0;
                $statusData['statusId'] = $statusId;
                $statusData['statusType'] = "";
                break;
        }
        return $statusData;
    }

    private function checkExistingStatuses(int $orderId, int $shiftRowId = 0): array {
        $existingStatuses = [
            'carrierAcceptance' => 0,
            'pickupGateInStatus' => 0,
            'pickupStatus' => 0,
            'pickupGateOutStatus' => 0,
            'inTransitStatus' => 0,
            'gateInDeliveryStatus' => 0,
            'dropStatus' => 0,
            'completedStatus' => 0,
            'closeStatus' => 0
        ];
        $getStatuses = $this->common->gettbldata(['order_id' => $orderId,'shipment_id' => $shiftRowId, 'status' => 1], 'status_code', 'tb_stop_status', 0, 0);
        foreach ($getStatuses as $eachStatus) {
            switch ($eachStatus['status_code']) {
                case '1075':
                    $existingStatuses['carrierAcceptance'] = 1;
                    break;
                case '0420':
                    $existingStatuses['pickupGateInStatus'] = 1;
                    break;
                case '0500':
                    $existingStatuses['pickupStatus'] = 1;
                    break;
                case '0191':
                    $existingStatuses['pickupGateOutStatus'] = 1;
                    break;
                case '1550':
                    $existingStatuses['inTransitStatus'] = 1;
                    break;
                case '0192':
                    $existingStatuses['gateInDeliveryStatus'] = 1;
                    break;
                case '2300':
                    $existingStatuses['dropStatus'] = 1;
                    break;
                case '3000':
                    $existingStatuses['completedStatus'] = 1;
                    break;
                case '0218':
                    $existingStatuses['closeStatus'] = 1;
                    break;
            }
        }
        return $existingStatuses;
    }

    private function getStageOfStatusCode(string $statusCode): int
    {
        switch ($statusCode) {
            case '1075':
                $stage = 1;
                break;
            case '0420':
                $stage = 2;
                break;
            case '0500':
                $stage = 3;
                break;
            case '0191':
                $stage = 4;
                break;
            case '1550':
                $stage = 5;
                break;
            case '0192':
                $stage = 6;
                break;
            case '2300':
                $stage = 7;
                break;
            case '3000':
                $stage = 8;
                break;
            case '0218':
                $stage = 9;
                break;
            default:
                $stage = 0;
                break;
        }
        return $stage;
    }

    public function pushOrderDocumentsToRoadlog(array $data, CI_Controller $CI): void
    {
        $orderInfoQuery = "SELECT o.user_id,o.created_source,o.physicalreceiver,o.logicalreceiver,o.physicalsender,o.logicalsender,e.assoc_id
                           FROM tb_orders o
                           LEFT JOIN  tb_employee e ON e.order_id = o.order_id
                           WHERE o.id = ?  AND e.shift_id = ?
                           AND e.order_id = ? AND e.status=1 LIMIT 1 ";
        $orderInfo = $this->db->query($orderInfoQuery, [$data['order_id'], $data['shipment_id'], $data['ord_id']]);
        $knOffice = '';
        $knOfficeRefVal = $this->common->gettblrowdata(['order_id' => $data['order_id'], 'ref_belongs_to' => 'KN OFFICE'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
        if (count($knOfficeRefVal) > 0) {
            $knOffice = $knOfficeRefVal['ref_value'];
        }
        $rlgRefVal = $this->common->gettblrowdata(['order_id' => $data['order_id'], 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
        $createdSource = (count($rlgRefVal) > 0) ? "18" : $orderInfo->row()->created_source;
        $RLGTrackingNumber =  (count($rlgRefVal) > 0) ? $rlgRefVal['ref_value'] :  $data['ord_id'];
        if (($orderInfo && $orderInfo->num_rows() > 0) && $createdSource == "18") {
            $roadlog_d3_data = [
                "physical_receiver" => $orderInfo->row()->physicalreceiver,
                "logical_receiver" => $orderInfo->row()->logicalreceiver,
                "physical_sender" => $orderInfo->row()->physicalsender,
                "logical_sender" => $orderInfo->row()->logicalsender,
                "order_id" => $RLGTrackingNumber,
                "assoc_id" => $orderInfo->row()->assoc_id,
                "ref_value_kn_office" => $knOffice,
                "upload_type" => $data['doc_type'],
                "file_path" => NEW_POD_PATH . $data['filename'],
                "branch_code" => $data['branch_code'],
                "company_code" => $data['company_code'],
                "country_code" => $data['country_code'],
                "user_id" => $data['userid'],
                "created_source" => $createdSource
            ];
            $getDocumentType = $this->common->checkDocumentSentType($RLGTrackingNumber);
            if ($getDocumentType == 1) {
                macadam_d3_dms($roadlog_d3_data);
            } else {
                $roadlogData = $this->common->getRoadlogOrderDetails($data['order_id']);
                if ($data['doc_type'] == "PUP") {
                    $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $CI);
                }
                if ($data['doc_type'] == "POD") {
                    $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $CI);
                }

            }
            if ($data['doc_type'] == "PUP") {
                $orderReferenceCount = $this->Roadlogtosalogmodel->getOrderReferenceCount($data['order_id']);
                if ($orderReferenceCount > 1) {
                    $this->roadlogsalogdocument->sendDocumentToSlog($data);
                }
            }
        }
    }
    private function getCarrierVehicleid(int $vendor_id, int $shiftRowId, int $userId): int
    {
        $getCarrierVehicles = $this->common->gettblrowdata([
            "vendor_id" => $vendor_id,
            "status" => 1
        ], "id,register_number", "tb_trucks_data", 0, 0);
        $vehicleId = $getCarrierVehicles['id'] ?? "";
        $shfitVehicles = [
            "user_id" => $userId,
            "shft_id" => $shiftRowId,
            "carrier_id" => $vendor_id,
            "vehicle_id" => $vehicleId,
            "register_number" => $getCarrierVehicles['register_number'] ?? "",
        ];
        $getshfitVehiclesInfo = $this->db->query("SELECT id FROM tb_shft_veh where shft_id=? and carrier_id=? and vehicle_id=?", [$shiftRowId, $vendor_id, $vehicleId]);
        if ($getshfitVehiclesInfo->num_rows() == 0) {
            $this->common->insertTableData('tb_shft_veh', $shfitVehicles);
        }
        return $vehicleId;
    }

    public function getVehicleDriversid(int $vendor_id, int $shiftRowId, int $userId, int $vehicleId): int
    {
        $getVehicleDrivers = $this->common->gettblrowdata([
            "vehicle_id" => $vehicleId,
            "status" => 1
        ], "driver_id", "tb_vehicles_drivers", 0, 0);
        $driverId = $getVehicleDrivers['driver_id'] ?? "";
        $shfitVehiclesDrivers = [
            "user_id" => $userId,
            "vehicle_id" => $vehicleId,
            "driver_id" => $driverId,
            "status" => 1
        ];
        $getshfitVehiclesDriversInfo = $this->common->gettblrowdata($shfitVehiclesDrivers, "id", "tbl_assigned_drivers", 0, 0);
        if (empty($getshfitVehiclesDriversInfo)) {
            $this->common->insertTableData('tbl_assigned_drivers', $shfitVehiclesDrivers);
        }
        return $driverId;
    }

    public function insertIntransitStatus(array $stopStatusData): void
    {
        if (empty($stopStatusData)) {
            return;
        }
        $checkCarrierGps = $this->checkCarrierMultiIntransitGPS($stopStatusData['order_id']);
        if (!empty($checkCarrierGps)) {
            $driverDetails = $this->common->gettblrowdata(
                ["id" => $stopStatusData['vehicle_id']],
                "`imei`,`speed`,`battery`,`fuel`,`bearing`",
                "tb_trucks_data",
                0,
                0
            );
            $mobileimei = $driverDetails['imei'];
            if ($driverDetails['imei'] == "" || $driverDetails['imei'] == null) {
                $driverContactInfo = $this->common->gettblrowdata(
                    ["id" => $stopStatusData['driver_id']],
                    "contact_num",
                    "tb_truck_drivers",
                    0,
                    0
                );
                $mobileimei = $driverContactInfo['contact_num'];
            }

            $driverLocations = [
                "driver_id" => $stopStatusData['driver_id'],
                "vehicle_id" => $stopStatusData['vehicle_id'],
                "trip_id" => $stopStatusData['trip_id'],
                "latitude" => $stopStatusData['latitude'],
                "longitude" => $stopStatusData['longitude'],
                "speed" => $driverDetails['speed'],
                "battery" => $driverDetails['battery'],
                "fuel" => $driverDetails['fuel'],
                "bearing" => $driverDetails['bearing'],
                "mobileimei" => $mobileimei,
                "timestamp" => $stopStatusData['createdon']
            ];
            $this->common->insertTableData('tb_rtdrive_locations', $driverLocations);
        }
    }

    public function checkCarrierMultiIntransitGPS(int $order_id): array
    {
        $this->db->select('o.id ');
        $this->db->from('`tb_vendors` `tc`');
        $this->db->join('`tb_orders` `o`', 'o.vendor_id =tc.id ');
        $this->db->join('`tbl_party_master` `tpm`', '`tc`.`code`=`tpm`.`code` AND `tpm`.`status`=1');
        $this->db->join('`tb_party_reference` `tpr`', '`tpm`.`id`=`tpr`.`partner_id` AND `tpr`.`status`=1');
        $this->db->where(['o.id' => $order_id, '`tpr`.`name`' => "MULTI_TRANSIT_GPS", 'tpr.`value' => "Y"]);
        $orderPatryReference = $this->db->get();
        return $orderPatryReference->num_rows() > 0 ? $orderPatryReference->result_array() : [];
    }
    
    public function updateStatus_old(string $ordersData): string
    {
        //log_message("error","ordersData:".json_encode($ordersData));
        $ordersInfo = json_decode($ordersData, true);
        $message = "0";
        //log_message("error","ordersInfo:".json_encode($ordersInfo));
        foreach ($ordersInfo as $orders) {
            //log_message("error","orders['OrderID']11:".$orders['OrderID']);
            if ($orders['OrderID'] === "NULL") {
                $referenceCode = $orders['referenceCode'];
                $referenceValue = $orders['referenceValue'];
                $orderReferences = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT OUTER JOIN tb_order_references tr ON tr.order_id=o.id WHERE tr.`reference_id`= ? AND tr.`ref_value`= ? AND tr.`status`=1 ", [$referenceCode, $referenceValue]);
                if ($orderReferences->num_rows() > 0) {
                    $order_id = $orderReferences->row()->order_id;
                }
                $orders['OrderID'] = $order_id;
            }
            $getBookingID = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT OUTER JOIN tb_order_references tr ON tr.order_id=o.id WHERE tr.`ref_value`= ? AND tr.`status`=1 LIMIT 1", [$orders['OrderID']]);
            //("error","getBookingID:".$this->db->last_query());
            //log_message("error","orders['OrderID']:".$orders['OrderID']);
            $orders['OrderID'] = ($getBookingID->num_rows() > 0) ? $getBookingID->row()->order_id : $orders['OrderID'];
            if ($orders['OrderID'] != "NULL") {
                $XBRDROrder = 0;
                $getOrderInfo = $this->common->getjointbldata("tb_orders o", "tb_customers c", "o.customer_id = c.id", ['o.order_id' => $orders['OrderID']], "o.id,o.user_id,o.shipmentid,o.shift_id,o.trip_id,o.created_source,o.vendor_id,c.sendto_knlogin,o.company_code", 0, 0);
                $orderInfo = $getOrderInfo[0] ?? [];
                if (!empty($orderInfo) && isset($orders['shipmentLegId']) && !empty($orders['shipmentLegId'])) {
                    $isXBRDR = $this->db->query("SELECT id,vendor_id,user_id FROM tb_shifts WHERE shipmentid = ? AND status = ? AND shift_leg_id > ? ",[$orders['shipmentLegId'], 1, 0])->row_array();
                    if (!empty($isXBRDR)) {
                        $XBRDROrder = 1;
                        $orderInfo['shift_id'] = $isXBRDR['id'];
                        $orderInfo['shipmentid'] = $orders['shipmentLegId'];
                        $orderInfo['vendor_id'] = $isXBRDR['vendor_id'];
                        $orderInfo['user_id'] = $isXBRDR['user_id'];
                    }
                }
                if (!empty($orderInfo)) {
                    $orderId = $orderInfo['id'];
                    $userId = $orderInfo['user_id'];
                    $shipmentId = $orderInfo['shipmentid'];
                    $createdsource = $orderInfo['sendto_knlogin'] === '1' ? "11" : $orderInfo['created_source'];
                    $shiftDetails = $this->common->gettblrowdata(
                        ["shipmentid" => $shipmentId],
                        "id,startdate,enddate",
                        "tb_shifts",
                        0,
                        0
                    );
                    if (count($shiftDetails) > 0) {
                        $shiftRowId = $shiftDetails['id'];
                        $startTime = $shiftDetails['startdate'];
                        $endTime = $shiftDetails['enddate'];
                    } else {
                        return 0;
                    }
                    $countryCode = "";
                    $countryCodeDetails = $this->db->query("SELECT country_code FROM tb_users WHERE id = ?", [$userId]);
                    if ($countryCodeDetails->num_rows() > 0) {
                        $countryCode = $countryCodeDetails->row()->country_code;
                    }
                    if ("" != $countryCode) {
                        $countryTimeZone = $this->db->query("SELECT cntry_timezone,cntry_hrs FROM tbl_country_master WHERE country_code =? AND status=1 LIMIT 1", [$countryCode]);
                        if ($countryTimeZone->num_rows() > 0) {
                            $curtz = $countryTimeZone->row()->cntry_timezone;
                            $hrs = $countryTimeZone->row()->cntry_hrs;
                        } else {
                            $curtz = "Asia/Singapore";
                            $hrs = "+08.00";
                        }
                    } else {
                        $curtz = "Asia/Singapore";
                        $hrs = "+08.00";
                    }

                    $date = str_replace("T", " ", $orders['datetime']);
                    $pickupDate = getdatetimebytimezone(DFLT_TZ, $date, $curtz);
                    $date = $pickupDate['datetime'];
                    $latitude = $orders['lat'];
                    $longitude = $orders['lng'];
                    $vehicleId = $driverId = "";
                    $getDriverVehInfo = $this->db->query("SELECT tr.vehicle_id,ad.driver_id,ad.imei FROM tb_trips tr INNER JOIN tbl_assigned_drivers ad ON tr.vehicle_id = ad.vehicle_id WHERE tr.shift_id= ? AND ad.status=1 GROUP BY tr.shift_id ORDER BY tr.id DESC", [$shiftRowId]);
                    if ($getDriverVehInfo->num_rows() > 0) {
                        $driverVehResults = $getDriverVehInfo->result_array();
                        $vehicleId = $driverVehResults[0]['vehicle_id'];
                        $driverId = $driverVehResults[0]['driver_id'];
                        $imei = $driverVehResults[0]['imei'];
                    } else {
                        $DriverVehInfo = $this->db->query("SELECT sv.vehicle_id,ad.driver_id,ad.imei FROM tb_shft_veh sv INNER JOIN tbl_assigned_drivers ad ON sv.vehicle_id = ad.vehicle_id WHERE sv.shft_id= ? AND ad.status=1 GROUP BY sv.shft_id ORDER BY sv.id DESC ", [$shiftRowId]);
                        if ($DriverVehInfo->num_rows() > 0) {
                            $driverVehResults = $DriverVehInfo->result_array();
                            $vehicleId = $driverVehResults[0]['vehicle_id'];
                            $driverId = $driverVehResults[0]['driver_id'];
                            $imei = $driverVehResults[0]['imei'];
                        }
                    }
                    $pickup_stopId = $drop_stopid = $drop_stopDetRowId = $pickup_stopDetRowId = 0;
                    $StopDetails = $this->common->gettblrowdata([
                        "order_id" => $orders['OrderID'],
                    ], "id,stop_id,drop_stopid", "tb_employee", 0, 0);
                    if (count($StopDetails) > 0) {
                        $pickup_stopId = $StopDetails['stop_id'];
                        $drop_stopid = $StopDetails['drop_stopid'];
                        $pickup_stopDetRowId = $drop_stopDetRowId = $StopDetails['id'];
                    }
                    if ($vehicleId == "") {
                        $vehicleId = $this->getCarrierVehicleid($orderInfo['vendor_id'], $shiftRowId, $userId);
                    }
                    if ($driverId == "") {
                        $driverId = $this->getVehicleDriversid($orderInfo['vendor_id'], $shiftRowId, $userId, $vehicleId);
                    }

                    $checkTrip = $this->db->select("id")->get_where(
                        "tb_trips",
                        ['shift_id' => $shiftRowId],
                        1,
                        0
                    );
                    if ($checkTrip->num_rows() == 0) {
                        $triparr = [
                            'shift_id' => $shiftRowId,
                            'vehicle_id' => $vehicleId,
                            'driver_id' => $driverId,
                            'stime' => $startTime,
                            'etime' => $endTime,
                            'start_imei' => $imei,
                            'splace' => "",
                            'eplace' => "",
                            'start_reading' => 0,
                            'end_reading' => 0,
                            'created_on' => $date,
                            'updated_on' => $date,
                            'status' => 1,
                            'trip_type' => 0,
                            'transit_status' => 0,
                            "plat" => $latitude,
                            "plng" => $longitude,
                        ];
                        $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                        if ($XBRDROrder === 1) {
                            $this->common->updatetbledata("tb_employee", ['trip_id' => $arr['trip']], ["shift_id" => $shiftRowId]);
                        } else {
                            $this->db->set(["trip_id" => $arr['trip']])->where(["shift_id" => $shiftRowId])->update("tb_orders");
                        }
                    } else {
                        $arr['trip'] = $checkTrip->row()->id;
                    }
                    $stopStatusData = [
                        "order_id" => $orderId,
                        "shipment_id" => $shiftRowId,
                        "stop_id" => "0",
                        "stop_detail_id" => "0",
                        "stop_type" => "",
                        "trip_id" => $arr['trip'],
                        "status_id" => 10,
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "loc_name" => $orders['location'],
                        "status" => 1,
                        "reason" => 'From EDI',
                        "comment" => $orders['referenceValue'] ?? "",
                        "vehicle_id" => $vehicleId,
                        "driver_id" => $driverId,
                        "status_code" => "0212",
                        "createdon" => $date,
                    ];
                    $postStatusData = [
                        "shipment_id" => $shiftRowId,
                        "trip_id" => $arr['trip'],
                        "driver_id" => $driverId,
                        "order_id" => $orders['OrderID'],
                        "inc_id" => 0,
                        "pod_type" => '',
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "vehicle_id" => $vehicleId,
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web" => str_replace("T", " ", $orders['datetime']),
                        "ord_id" => $orderId
                    ];
                    $pickAndDropIds = [
                        'pickupStopId' => $pickup_stopId,
                        'pickupStopDetailRowId' => $pickup_stopDetRowId,
                        'dropStopId' => $drop_stopid,
                        'dropStopDetailRowId' => $drop_stopDetRowId
                    ];
                    $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                    $existingStatuses = $this->checkExistingStatuses($orderId, $shiftRowId);
                    $stage = $this->getStageOfStatusCode($orders['statuscode']);
                    if (($existingStatuses['carrierAcceptance'] == 0) && ($stage >= 1)) {
                        $stopStatusData['status_code'] = "1075";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        if ($arr['trip'] > 0) {
                            $this->common->updatetbledata("tb_trips", ['actual_carrier_acceptance' => 1], ['id' => $arr['trip']]);
                        }
                        if ($createdsource == 18) {
                            $postStatusData['stop_id'] = $pickup_stopId;
                            $postStatusData['status_code'] = "0212";
                            $postStatusData['stop_type'] = "P";
                            $this->statusintigration->roadlogshipmentconfirm($postStatusData);
                        }

                    }
                    if (($existingStatuses['pickupGateInStatus'] == 0) && ($stage >= 2)) {
                        $stopStatusData['status_code'] = "0420";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "0420";
                        $postStatusData['stop_type'] = "P";
                        $postStatusData['stop_id'] = $pickup_stopId;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentpgatein($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentpgatein($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                        if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $orderInfo['company_code'])) {
                            $ins_ref = ['order_id' => $orderId, 'reference_id' => 'STS'];
                            $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                            if (count($checkSTSRef) > 0) {
                                $this->common->updatetbledata('tb_order_references', ['ref_value' => "Active"], $ins_ref);
                            }else{
                                $ins_ref['ref_value'] = "Active";
                                $this->common->insertTableData("tb_order_references", $ins_ref);
                            }
                        }

                    }
                    if (($existingStatuses['pickupStatus'] == 0) && ($stage >= 3)) {
                        $stopStatusData['status_code'] = "0500";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "0500";
                        $postStatusData['stop_type'] = "P";
                        $postStatusData['stop_id'] = $pickup_stopId;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentpicked($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentpicked($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                        if ($createdsource == 5) {
                            $this->statusintigration->salogshipmentstatus($postStatusData);
                        }
                    }
                    if (($existingStatuses['pickupGateOutStatus'] == 0) && ($stage >= 4)) {
                        $stopStatusData['status_code'] = "0191";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "0191";
                        $postStatusData['stop_type'] = "P";
                        $postStatusData['stop_id'] = $pickup_stopId;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentpgateout($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentpgateout($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                    }
                    if (($existingStatuses['inTransitStatus'] == 0) && ($stage >= 5)) {
                        $stopStatusData['status_code'] = "1550";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "1550";
                        $postStatusData['stop_type'] = "P";
                        $postStatusData['stop_id'] = $pickup_stopId;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentintransit($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentintransit($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                    }
                    if (($existingStatuses['gateInDeliveryStatus'] == 0) && ($stage >= 6)) {
                        $stopStatusData['status_code'] = "0192";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "0192";
                        $postStatusData['stop_type'] = "D";
                        $postStatusData['stop_id'] = $drop_stopid;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentdgatein($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentdgatein($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                    }
                    if (($existingStatuses['dropStatus'] == 0) && ($stage >= 7)) {
                        $stopStatusData['status_code'] = "2300";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['status_code'] = "2300";
                        $postStatusData['stop_type'] = "D";
                        $postStatusData['stop_id'] = $drop_stopid;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmentdelivered($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentdelivered($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                        if ($createdsource == 5) {
                            $this->statusintigration->salogshipmentstatus($postStatusData);
                        }
                        if (!empty($orders['PODURL'])) {
                            $this->podImageDb($orderInfo, $latitude, $longitude, $date, $orders['PODURL'], $drop_stopid);
                        }
                    }
                    if (($existingStatuses['completedStatus'] == 0 || $existingStatuses['closeStatus'] == 0) && ($stage >= 8)) {
                        $stopStatusData['status_code'] = $postStatusData['status_code'] = "3000";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $postStatusData['stop_type'] = "D";
                        $postStatusData['stop_id'] = $drop_stopid;
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                        if (!empty($orders['PODURL'])) {
                            $this->podImageDb($orderInfo, $latitude, $longitude, $date, $orders['PODURL'], $drop_stopid);
                        }
                        $stopStatusData['status_code'] = "0218";
                        $this->insertStatusCodes($stopStatusData, $pickAndDropIds);
                        $this->db->set(["status" => '0', "updated_on" => $date])->where(["id" => $shiftRowId])->update(
                            "tb_shifts"
                        );
                        $tripUpdateData = [
                            'end_reading' => '0',
                            'etime' => $date,
                            'updated_on' => $date,
                            'status' => '0',
                            'transit_status' => '1'
                        ];
                        $this->db->set($tripUpdateData)->where(["id" => $arr['trip']])->update("tb_trips");
                        $this->db->set(["status" => '0', "updated_on" => $date])->where(["id" => $shiftRowId])->update(
                            "tb_shifts"
                        );
                        $this->db->where(["shift_id" => $shiftRowId])->update("tb_orders", ["trip_sts" => '1']);
                        $postStatusData['status_code'] = "0218";
                        $postStatusData['stop_type'] = "D";
                        $postStatusData['stop_id'] = $drop_stopid;
                        if ($createdsource == 18) {
                            $this->statusintigration->roadlogshipmenttripdelivered($postStatusData);
                        }
                        if ($createdsource == 12) {
                            $this->macdamstatusintigration->macdamshipmentdelivered($postStatusData);
                        }
                        if ($createdsource == 11) {
                            $this->knlogin->knloginshipmentstatus($postStatusData);
                        }
                        if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $orderInfo['company_code'])) {
                            $ins_ref = ['order_id' => $orderId, 'reference_id' => 'STS'];
                            $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                            if (count($checkSTSRef) > 0) {
                                $this->common->updatetbledata('tb_order_references', ['ref_value' => "Closed"], $ins_ref);
                            }else{
                                $ins_ref['ref_value'] = "Closed";
                                $this->common->insertTableData("tb_order_references", $ins_ref);
                            }
                        }
                    }
                    if (in_array($orders['statuscode'], ['0200', '0220', '1065', '3400']) && $createdsource == 5) {
                        $postStatusData['status_code'] = $orders['statuscode'];
                        $postStatusData['stop_type'] = "P";
                        $postStatusData['stop_id'] = $pickup_stopId;
                        $this->statusintigration->salogshipmentstatus($postStatusData);
                    }
                    $stopStatusData['status_code'] = $orders['statuscode'];
                    $this->insertStatusCodes($stopStatusData, $pickAndDropIds, true);
                }
                $message = "1";
            }
        }
        return $message;
    }
    
    public function updateXPStatus(string $ordersData, string $carrier): int
    {
        //log_message("error","ordersData:".json_encode($ordersData));
        $ordersInfoData = json_decode($ordersData, true);
        $message = "0";
        //log_message("error","ordersInfo:".json_encode($ordersInfoData));
        $successVal = 0;	
        foreach ($ordersInfoData as $orders) {
            
            $result = $this->db->query('SELECT svk_status, stop_type, stop_seq from tb_edi_status WHERE external_type = ? and (otm_status = ? or svk_status = ?) and status <> ?', [$carrier, $orders['statuscode'], $orders['statuscode'], 0]);
    		log_message('error', "query0:" . $this->db->last_query());
    		$statusCode = $result->row()->svk_status ?? "";
    		$stopType = $result->row()->stop_type ?? "";
    		$stopSeq = $result->row()->stop_seq ?? "";
    		//log_message('error', "statusCode:" . $statusCode);
    		
    		$GetTripId = $this->db->query("SELECT id, shift_id, trip_id, shipment_id, plat, plng, dlat, dlng, pickup_datetime, drop_endtime, vendor_id, user_id  FROM `tb_orders` WHERE order_id=? and status in (1,2)", [$orders['OrderID']]);
    		log_message('error', "query1:" . $this->db->last_query());
            $tripId = $GetTripId->row()->trip_id;
            
            $shiftId = $GetTripId->row()->shift_id;
            $ordId = $GetTripId->row()->id;
            $shipmentId = $GetTripId->row()->shipment_id;
            $lat1 = $GetTripId->row()->plat;
            $lng1 = $GetTripId->row()->plng;
            $lat2 = $GetTripId->row()->dlat;
            $lng2 = $GetTripId->row()->dlng;
            $earlyquickbook_pickup = $GetTripId->row()->pickup_datetime;
            $latequickbook_delivery = $GetTripId->row()->drop_endtime;
            $vendorId = $GetTripId->row()->vendor_id;
            $user_id = $GetTripId->row()->user_id;
            
            $GetStopId = $this->db->query("SELECT id FROM `tb_shiporder_stops` WHERE shipment_id = ? and stoptype= ? and status=1", [$shiftId, $stopType]);
            log_message('error', "query2:" . $this->db->last_query());
            $stopId = $GetStopId->row()->id;
            
            $checkVehicle = $this->common->getjointbldata("tb_trucks_data td", "tb_trucktypes t", "td.truck_type = t.id", [/*'t.trucktype' => "COURIER",*/ 'td.vendor_id' => $vendorId, 'td.status' => 'Active', 't.status' => 'Active'], "td.id,td.register_number,t.trucktype", 0, 0);
           log_message("error","11:".$this->db->last_query());
           
            $vehId = $checkVehicle[0]['id'];
        
            log_message("error","vehId:".$vehId);
            $driverData = $this->db->query( "SELECT d.driver_id FROM tbl_assigned_drivers d WHERE d.vehicle_id=$vehId and d.user_id=$user_id AND d.status=1 LIMIT 1" );
            if ($driverData && $driverData->num_rows() > 0 ) {
                $driver_id   = $driverData->row()->driver_id;
            }
    				
    		$dt    = date('Y-m-d H:i:s');
    		$curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
    		$gentime    = getdatetimebytimezone(DFLT_TZ, $dt, $curtz);
    		$dt = $gentime['datetime'];
    		$orderdatetime = $orders['datetime'];
    		//log_message('error',"UserId::".$user_id); 
    		$timeZone        = $this->Standardbookingmodel->getUserTimeZone($user_id);
    		//log_message("error","111:".$this->db->last_query());
    		$getactual = getdatetimebytimezone(DFLT_TZ, $orderdatetime, $timeZone);
            $date = $getactual['datetime'];
            // Create DateTime object
            //$date = new DateTime($orderdatetime);
            // Format to desired output
            //$formatted = $date->format('Y-m-d H:i:s');
            $formatted = $date;
            
            if($statusCode == '1600'){
        		$check_array = [
        			'order_id'    => $ordId,
        			'status_id'   => $stopSeq,
        			'status_code' => $statusCode,
        			//'createdon' => $formatted,
        			//'loc_name' => $orders['location'],
        			'status'      => 1,
        		];
            }
    		else
    		{
                $check_array = [
    			'order_id'    => $ordId,
    			'status_id'   => $stopSeq,
    			'status_code' => $statusCode,
    			//'createdon' => $formatted,
    			//'loc_name' => $orders['location'],
    			'status'      => 1,
    		];
    		}
    		//log_message('error',"Formatted ins::".$formatted); 			
    		$chk_qry_stop = $this->db->select("id")->get_where('tb_stop_status', $check_array);
        	//log_message('error',"tb_order_status ins::".$this->db->last_query()); 
        	
        	$comment = '';
        	
        	if ($chk_qry_stop->num_rows() == 0) {
        	    if (in_array($statusCode, ['SV0120'])) {
        	     $tripArr = [
                    'shift_id' => $shiftId,
                    'status' => 1,
                    'created_on' => $dt,
                    'plat' => $lat1,
                    'plng' => $lng1,
                    'dlat' => $lat2,
                    'dlng' => $lng2,
                    'stime' => $earlyquickbook_pickup,
                    'etime' => $latequickbook_delivery,
                    'vehicle_id' => $vehId,
                    'driver_id' => $driver_id,
                ];
                $tripRowId = $this->common->insertTableData("tb_trips", $tripArr);
                $this->db->set(["order_status" => "2", "trip_id" => $tripRowId])->where(["id" => $ordId])->update("tb_orders");
        	    }
        	    $insertedId = $this->common->insertTableData("tb_stop_status", ['order_id' => $ordId, 'shipment_id' => $shiftId, 'stop_detail_id' => $shipmentId, 'stop_id' => $stopId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'trip_id' => $tripId , 'status_id' => $stopSeq, 'status_code' => $statusCode, 'stop_type' => $stopType, 'loc_name' => $orders['location'], 'comment' => $orders['comment'], 'status' => '1', 'reason' => '', 'createdon' => $formatted]);
            	
            	if (in_array($statusCode, ['SV0510'])) {
                    $insertedCloseId = $this->common->insertTableData("tb_stop_status", ['order_id' => $ordId, 'shipment_id' => $shiftId, 'stop_detail_id' => $shipmentId, 'stop_id' => $stopId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'trip_id' => $tripId , 'status_id' => '296', 'status_code' => 'SV0610', 'stop_type' => $stopType, 'loc_name' => $orders['location'], 'comment' => $orders['comment'], 'status' => '1', 'reason' => '', 'createdon' => $formatted]);
                    $this->db->set(["trip_sts" => 1])->where(["id" => $ordId])->update("tb_orders");
                    $this->db->set(["status" => 0])->where(["id" => $shiftId])->update("tb_shifts");
                    //log_message('error',"TripId::".$tripId); 
                    if (!empty($tripId) && (int)$tripId !== 0) {
                        $this->UpdateTripOrderCloseStatus->generateSummary($tripId, $timeZone);
                    }
        	    }
            	$successVal = $successVal + 1;
        	}
        	else
        	{
        	    /*if($statusCode == '1600'){
        	        $updatedId = $this->common->updatetbledata("tb_stop_status", ['createdon' => $formatted, 'trip_id' => $tripId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'loc_name' => $orders['location'], 'comment' => ''], ['order_id' => $ordId, 'status_id' => $stopSeq, 'status_code' => $statusCode]);
        	    }else{
        	        $updatedId = $this->common->updatetbledata("tb_stop_status", ['createdon' => $formatted, 'trip_id' => $tripId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'loc_name' => $orders['location'], 'comment' => ''], ['order_id' => $ordId, 'status_id' => $stopSeq, 'status_code' => $statusCode]);
        	    }*/
        	    $updatedId = $this->common->updatetbledata("tb_stop_status", ['createdon' => $formatted, 'trip_id' => $tripId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'loc_name' => $orders['location'], 'comment' => $orders['comment']], ['order_id' => $ordId, 'status_id' => $stopSeq, 'status_code' => $statusCode]);
                //log_message('error', "query111111:" . $this->db->last_query());
            	if (in_array($statusCode, ['SV0510'])) {
                    $insertedCloseId = $this->common->insertTableData("tb_stop_status", ['order_id' => $ordId, 'shipment_id' => $shiftId, 'stop_detail_id' => $shipmentId, 'stop_id' => $stopId, 'latitude' => $orders['lat'], 'longitude' => $orders['lng'], 'trip_id' => $tripId , 'status_id' => '296', 'status_code' => 'SV0610', 'stop_type' => $stopType, 'loc_name' => $orders['location'], 'comment' => $orders['comment'], 'status' => '1', 'reason' => '', 'createdon' => $formatted]);
                    $this->db->set(["trip_sts" => 1])->where(["id" => $ordId])->update("tb_orders");
                    $this->db->set(["status" => 0])->where(["id" => $shiftId])->update("tb_shifts");
                    //log_message('error',"TripId11::".$tripId); 
                    if (!empty($tripId) && (int)$tripId !== 0) {
                        $this->UpdateTripOrderCloseStatus->generateSummary($tripId, $timeZone);
                    }
        	    }
            	$successVal = $successVal + 1;
            }
        }
      
        return $successVal;
    }
}
