<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Standardbookingmodel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('Log');
    }

    public function getOrderCount(string $table, array $values): int
    {
        $this->db->from($table);
        foreach ($values as $key => $value) {
            $this->db->where($key, $value);
        }

        $db_results = $this->db->get();
        return $db_results->num_rows();
    }

    public function checkOrderType(array $orderInfo): int
    {
        //log_message("error","Innn:".json_encode($orderInfo));
        $orderType = $orderInfo['OrderType'];
        $companyCode = empty($orderInfo['SVKOrgDetails']['Companycode']) ? "" :$orderInfo['SVKOrgDetails']['Companycode'] ;
        $branchCode = empty($orderInfo['SVKOrgDetails']['Branchcode']) ? "" : $orderInfo['SVKOrgDetails']['Branchcode'] ;
        $logicalReceiver = empty($orderInfo['SVKOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['LogicalReceiver'] ;
        if ($logicalReceiver != "") {
            $checkBranchCompanyCodes = $this->getBranchCompanyCodes($orderInfo['SVKOrgDetails']['LogicalReceiver']);
            if (!empty($checkBranchCompanyCodes)) {
                $companyCode = $checkBranchCompanyCodes['company_code'];
                $branchCode = $checkBranchCompanyCodes['branch_code'];
            }
        }
        $orderTypeData = [
            'type_name' => $orderType,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'status' => 1,
        ];
        $getOrderType = $this->common->gettblrowdata($orderTypeData, 'id', 'tb_order_types', 0, 0);
        //log_message("error","Qry:".$this->db->last_query());
        if (!(count($getOrderType) <= 0)) {
            $orderTypeId = $getOrderType['id'];
        } else {
            $orderTypeData['description'] = $orderType;
            $orderTypeId = $this->common->insertTableData('tb_order_types', $orderTypeData);
        }
        //log_message("error","orderTypeId:".$orderTypeId);
        return $orderTypeId ?? 0;
    }

    /*public function checkOrderType(array $orderInfo): int
    {
        log_info("error","Innn:".json_encode($orderInfo));
        $orderType       = $orderInfo['OrderType'];
        $companyCode     = empty($orderInfo['SVKOrgDetails']['Companycode']) ? "" : $orderInfo['SVKOrgDetails']['Companycode'];
        $branchCode      = empty($orderInfo['SVKOrgDetails']['Branchcode']) ? "" : $orderInfo['SVKOrgDetails']['Branchcode'];
        $logicalReceiver = empty($orderInfo['SVKOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['LogicalReceiver'];
        if ($logicalReceiver != "") {
            $checkBranchCompanyCodes = $this->getBranchCompanyCodes($orderInfo['SVKOrgDetails']['LogicalReceiver']);
            if (! empty($checkBranchCompanyCodes)) {
                $companyCode = $checkBranchCompanyCodes['company_code'];
                $branchCode  = $checkBranchCompanyCodes['branch_code'];
            }
        }
        $orderTypeData = [
            'type_name'    => $orderType,
            'company_code' => $companyCode,
            'branch_code'  => $branchCode,
            'status'       => 1,
        ];
        $getOrderType = $this->common->gettblrowdata($orderTypeData, 'id', 'tb_order_types', 0, 0);
        log_info("error","Qry:".$this->db->last_query());
        if (!empty($getOrderType)) {
            $firstRow = is_array($getOrderType[0]) ? $getOrderType[0] : (array)$getOrderType[0];
            $orderTypeId = $firstRow['id'] ?? 0;
        } else {
            $orderTypeData = [
                'txr.source_order_type'    => "DEFAULT",
                'txr.organization_name' => $companyCode,
                'txr.business_entity_value'  => $branchCode,
            ];
            $select = 'tot.id';
            $getOrderType = $this->common->getjointbldata("tb_order_types tot", "tb_order_type_xref txr", "tot.type_name=txr.destination_order_type", $orderTypeData, $select, 1, 0);
            if (!empty($getOrderType)) {
                $firstRow = is_array($getOrderType[0]) ? $getOrderType[0] : (array)$getOrderType[0];
                $orderTypeId = $firstRow['id'] ?? 0;
            }
        }
        log_info("error","orderTypeId:".$orderTypeId);
        return $orderTypeId ?? 0;
    }*/

    public function checkModeOfTransport(string $modeOfTransport): string
    {
        $modeOfTransportId = "";
        $modeOfTransport   = $this->common->gettblrowdata(
            ['code' => $modeOfTransport, 'status' => 1],
            'code',
            'tb_transportmode',
            0,
            0
        );
        if (! (count($modeOfTransport) <= 0)) {
            $modeOfTransportId = $modeOfTransport['code'];
        }
        return $modeOfTransportId;
    }

    public function getModeOfTransportId(string $modeOfTransport): string
    {
        $modeOfTransportId = "";
        $modeOfTransport   = $this->common->gettblrowdata(
            ['code' => $modeOfTransport, 'status' => 1],
            'id',
            'tb_transportmode',
            0,
            0
        );
        if (! (count($modeOfTransport) <= 0)) {
            $modeOfTransportId = $modeOfTransport['id'];
        }
        return $modeOfTransportId;
    }

    public function checkProduct(string $product): string
    {
        $productId  = "";
        $productRes = $this->common->gettblrowdata(
            ['name' => $product, 'status' => 1],
            'name',
            'tb_products_master',
            0,
            0
        );
        if (! (count($productRes) <= 0)) {
            $productId = $productRes['name'];
        }
        return $productId;
    }

    public function checkServiceType(string $serviceType): string
    {
        $serviceTypeId  = "";
        $serviceTypeRes = $this->common->gettblrowdata(
            ['name' => $serviceType, 'status' => 1],
            'id',
            'tb_service_master',
            0,
            0
        );
        if (! (count($serviceTypeRes) <= 0)) {
            $serviceTypeId = $serviceTypeRes['id'];
        }
        return $serviceTypeId;
    }

    public function checkPartyType(string $partyId): array
    {
        $partyTypeId  = "";
        $search       = '%' . $partyId . '%';
        $partyTypeRes = $this->db->query("SELECT id, name, code, address, street, state, country, pincode, email, mobile, latitude, longitude, customeridentifier, location_id, company_code, branch_code, user_id FROM tbl_party_master WHERE code LIKE ? OR customeridentifier LIKE ?", [$search, $search]);
        //log_message("error", "Inn:" . $this->db->last_query());
        return $partyTypeRes->num_rows() > 0 ? $partyTypeRes->row_array() : [];
    }

    public function getPartyTypeId(
        string $company_code,
        string $branch_code,
        string $partyDataType
    ): int {
        $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", [
            "name"         => $partyDataType,
            'company_code' => $company_code,
            'branch_code'  => $branch_code,
        ], 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $party_type_id = $checkPartyType->row()->id;
        } else {
            $partyTypeInfo = [
                "name"         => $partyDataType,
                'company_code' => $company_code,
                'branch_code'  => $branch_code,
            ];
            $party_type_id = $this->common->insertTableData('tbl_party_types', $partyTypeInfo);
        }
        return $party_type_id;
    }

    public function checkUser(string $company_code, string $branch_code, string $firstTwoChars): int
    {
        $userId      = 0;
        $currentDate = date('Y-m-d H:i:s');
        $checkUser   = $this->db->query(
            "SELECT id FROM tb_users WHERE company_code=? AND branch_code=? AND status='Active' LIMIT 1", [$company_code, $branch_code]
        );
        if ($checkUser->num_rows() > 0) {
            $userId = $checkUser->row()->id;
        } else {
            $checkUserCompany = $this->db->query(
                "SELECT user_id FROM tb_user_companies WHERE company_code=? AND branch_code=? AND status=1 LIMIT 1", [$company_code, $branch_code]
            );
            if ($checkUserCompany->num_rows() > 0) {
                $userId = $checkUserCompany->row()->user_id;
            } else {
                $adminPhone    = time();
                $adminPassword = password_hash($adminPhone, PASSWORD_DEFAULT);
                $userData      = [
                    'country_code'      => $firstTwoChars,
                    'name'              => $firstTwoChars . "_Admin",
                    'company_indv_name' => $company_code,
                    'business_type'     => 'Truck_Owner',
                    'mobile_no'         => $adminPhone,
                    'password'          => $adminPassword,
                    'emailid'           => 'svkonekt@kuehne-nagel.com',
                    'domain_name'       => $branch_code,
                    'location_id'       => 1646,
                    'createdby'         => 1,
                    'status'            => 'Active',
                    'createdon'         => $currentDate,
                    'company_code'      => $company_code,
                    'branch_code'       => $branch_code,
                ];
                $userId = $this->common->insertTableData('tb_users', $userData);
            }
        }
        return $userId;
    }

    public function getUserTimeZone(int $user_id): string
    {
        $checkUser = $this->db->query("SELECT country_code FROM tb_users WHERE id=? AND status='Active' LIMIT 1", [$user_id]);
        if ($checkUser->num_rows() > 0) {
            $country_code = $checkUser->row()->country_code;
            $getqry       = $this->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE (country_code=? OR country_name=?) AND status=1 LIMIT 1", [$country_code, $country_code]);
            if ($getqry && $getqry->num_rows() > 0) {
                $timeZone = $getqry->row()->cntry_timezone;
            } else {
                log_message("error", "login user's timezone is undefined.");
                $timeZone = "Asia/Singapore";
            }
        }
        return $timeZone ?? "Asia/Singapore";
    }

    public function generateOrderBookingId(int $order_id, int $user_id): string
    {
        $get_country  = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
        $country_code = $get_country->row()->country_code;
        $company_code = $get_country->row()->company_code;
        $genord       = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
        return generatebookingid($genord);
    }

    public function insertOrder(
        array $orderData,
        array $customerInfo,
        array $sourceInfo,
        array $destinationInfo,
        int $ship_row_id,
        string $timeZone,
        string $company_code,
        string $branch_code,
        int $user_id
    ): int {

        $modeOfTransport       = $this->getModeOfTransportId($orderData['ModeOfTransport']);
        $e_delivery            = $l_delivery            = null;
        $earlyPickupDatetime   = (empty($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']);
        $e_pickup              = str_replace("T", " ", $earlyPickupDatetime);
        $latePickupDatetime    = (empty($orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']);
        $l_pickup              = str_replace("T", " ", $latePickupDatetime);
        $earlyDeliveryDatetime = (empty($orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']) ? date($earlyPickupDatetime, strtotime('+3 days')) : $orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']);
        $e_delivery            = str_replace("T", " ", $earlyDeliveryDatetime);
        $lateDeliveryDatetime  = (empty($orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']) ? date($latePickupDatetime, strtotime('+3 days')) : $orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']);
        $l_delivery            = str_replace("T", " ", $lateDeliveryDatetime);
        $getactual             = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $timeZone);
        $logdate               = $getactual['datetime'];
        $getpickup             = getdatetimebytimezone(DFLT_TZ, $e_pickup, $timeZone);
        $e_pickup              = $getpickup['datetime'];
        $getlpickup            = getdatetimebytimezone(DFLT_TZ, $l_pickup, $timeZone);
        $l_pickup              = $getlpickup['datetime'];
        if ($e_delivery != "" && $e_delivery != null) {
            $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $timeZone);
            $e_delivery  = $getdelivery['datetime'];
        }
        if ($l_delivery != "" && $l_delivery != null) {
            $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $timeZone);
            $l_delivery   = $getldelivery['datetime'];
        }
        $created_source     = '4';
        $customer_id        = $customerInfo['customer_id'];
        $customer_code      = $customerInfo['party_code'];
        $pickup_custid      = ! empty($orderData['sourceInfo']['ID']) ? $orderData['sourceInfo']['ID'] : $sourceInfo['party_id'];
        $pickup_code        = $sourceInfo['party_code'];
        $destination_custid = $destinationInfo['party_id'];
        $destination_code   = $destinationInfo['party_code'];

        $plat          = (empty($orderData['sourceInfo']['Address']['Latitude']) ? "" : $orderData['sourceInfo']['Address']['Latitude']);
        $plng          = (empty($orderData['sourceInfo']['Address']['Longitude']) ? "" : $orderData['sourceInfo']['Address']['Longitude']);
        $sourceStreet  = (empty($orderData['sourceInfo']['Address']['Street']) ? "" : $orderData['sourceInfo']['Address']['Street']);
        $sourceCity    = (empty($orderData['sourceInfo']['Address']['City']) ? "" : $orderData['sourceInfo']['Address']['City']);
        $sourceCountry = (empty($orderData['sourceInfo']['Address']['Country']) ? "" : $orderData['sourceInfo']['Address']['Country']);
        $sourcePostal  = (empty($orderData['sourceInfo']['Address']['Postal']) ? "" : $orderData['sourceInfo']['Address']['Postal']);
        if ($plat == "" && $plng == "") {
            $pickupaddress = implode(",", [$sourceStreet, $sourceCity, $sourceCountry, $sourcePostal]);
            $data          = getlatlngsbyplace($pickupaddress);
            $plat          = @$data[0];
            $plng          = @$data[1];
        }

        $dlat               = (empty($orderData['destinationInfo']['Address']['Latitude']) ? "" : $orderData['destinationInfo']['Address']['Latitude']);
        $dlng               = (empty($orderData['destinationInfo']['Address']['Longitude']) ? "" : $orderData['destinationInfo']['Address']['Longitude']);
        $destinationStreet  = (empty($orderData['destinationInfo']['Address']['Street']) ? "" : $orderData['destinationInfo']['Address']['Street']);
        $destinationCity    = (empty($orderData['destinationInfo']['Address']['City']) ? "" : $orderData['destinationInfo']['Address']['City']);
        $destinationCountry = (empty($orderData['destinationInfo']['Address']['Country']) ? "" : $orderData['destinationInfo']['Address']['Country']);
        $destinationPostal  = (empty($orderData['destinationInfo']['Address']['Postal']) ? "" : $orderData['destinationInfo']['Address']['Postal']);
        if ($dlat == "" && $dlng == "") {
            $dropaddress = implode(",", [$destinationStreet, $destinationCity, $destinationCountry, $destinationPostal]);
            $data        = getlatlngsbyplace($dropaddress);
            $dlat        = @$data[0];
            $dlng        = @$data[1];
        }
        $orderQuantity = empty($orderData['cargoSummary']['TotalQuantity']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalQuantity']['Value'];
        $orderWeight   = empty($orderData['cargoSummary']['TotalWeight']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalWeight']['Value'];
        $orderVolume   = empty($orderData['cargoSummary']['TotalVolume']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalVolume']['Value'];
        //log_message("error", "e_delivery" . $e_delivery);
        //log_message("error", "ModeOfTransport:" . $orderData['ModeOfTransport']);
        $orderinfo = [
            'customer_id'       => $customer_id,
            'product'           => $orderData['Product'],
            'pickup_datetime'   => $e_pickup,
            'delivery_datetime' => $e_delivery ?? null,
            'pickup_endtime'    => $l_pickup,
            'drop_endtime'      => $l_delivery ?? null,
            'goods_value'       => "0.00",
            'currency'          => "",
            'company_code'      => $company_code,
            'branch_code'       => $branch_code,
            'drop_custid'       => $destination_custid,
            'drop_partyid'      => $destination_custid,
            'user_id'           => $user_id,
            'sub_uid'           => 0,
            'pickup_custid'     => $pickup_custid,
            'pickup_partyid'    => $pickup_custid,
            'pickup_country'    => $sourceCountry ?? "",
            'pickup_city'       => $sourceCity ?? "",
            'pickup_pincode'    => $sourcePostal ?? "",
            'pickup_company'    => (empty($orderData['sourceInfo']['Address']['CompanyName']) ? "" : $orderData['sourceInfo']['Address']['CompanyName']),
            'pickup_address1'   => (empty($orderData['sourceInfo']['Address']['Address1']) ? "" : $orderData['sourceInfo']['Address']['Address1']),
            'pickup_address2'   => (empty($orderData['sourceInfo']['Address']['State']) ? "" : $orderData['sourceInfo']['Address']['State']),
            'delivery_country'  => $destinationCountry,
            'delivery_city'     => $destinationCity,
            'delivery_pincode'  => $destinationPostal,
            'delivery_company'  => (empty($orderData['destinationInfo']['Address']['CompanyName']) ? "" : $orderData['destinationInfo']['Address']['CompanyName']),
            'delivery_address1' => (empty($orderData['destinationInfo']['Address']['Address1']) ? "" : $orderData['destinationInfo']['Address']['Address1']),
            'delivery_address2' => (empty($orderData['destinationInfo']['Address']['State']) ? "" : $orderData['destinationInfo']['Address']['State']),
            'is_created'        => '1',
            'plat'              => $plat,
            'plng'              => $plng,
            'dlat'              => $dlat,
            'dlng'              => $dlng,
            'quantity'          => $orderQuantity,
            'weight'            => $orderWeight,
            'volume'            => $orderVolume,
            'transport_mode'    => $orderData['ModeOfTransport'],
            'modeOfTransport'   => $modeOfTransport,
            'created_source'    => $created_source,
            'createdon'         => date('Y-m-d H:i:s'),
            'shipment_id'       => $ship_row_id,
            'external_order_id' => $orderData['EXTOrderID'],
        ];
        $checketnorder = $this->checkOrderCount($orderData['EXTOrderID']);
        if ($checketnorder == 0) {
            $order_id   = $this->common->insertTableData('tb_orders', $orderinfo);
            //log_message("error","order_idorder_id:".$order_id);
            $booking_id = $this->generateOrderBookingId($order_id, $user_id);
            //log_message("error","booking_idbooking_id:".$booking_id);
            $this->db->where(['id' => $order_id])->update("tb_orders", ['order_id' => $booking_id]);
        } else {
            $order_id = $checketnorder;
            $this->common->updatetbledata("tb_orders", $orderinfo, ["id" => $order_id]);
        }
        return $order_id;
    }

    public function insertCargoInfo(array $orderCargo, int $order_id, int $user_id): int
    {
        $cargoType             = is_array($orderCargo['CargoType']) ? "" : $orderCargo['CargoType'];
        $GoodsDescription      = is_array($orderCargo['GoodsDescription']) ? "" : $orderCargo['GoodsDescription'];
        $MarksandNumbers       = is_array($orderCargo['MarksandNumbers']) ? "" : $orderCargo['MarksandNumbers'];
        $ValueOfGoods          = is_array($orderCargo['ValueOfGoods']) ? "" : $orderCargo['ValueOfGoods'];
        $HandlingUnit          = is_array($orderCargo['HandlingUnit']) ? "" : $orderCargo['HandlingUnit'];
        $ItemId                = is_array($orderCargo['ItemId']) ? "0" : $orderCargo['ItemId'];
        $LengthValue           = is_array($orderCargo['Length']['Value']) ? "" : $orderCargo['Length']['Value'];
        $LengthUom             = is_array($orderCargo['Length']['UOM']) ? "" : $orderCargo['Length']['UOM'];
        $WidthValue            = is_array($orderCargo['Width']['Value']) ? "" : $orderCargo['Width']['Value'];
        $WidthUom              = is_array($orderCargo['Width']['UOM']) ? "" : $orderCargo['Width']['UOM'];
        $HeightValue           = is_array($orderCargo['Height']['Value']) ? "" : $orderCargo['Height']['Value'];
        $HeightUom             = is_array($orderCargo['Height']['UOM']) ? "" : $orderCargo['Height']['UOM'];
        $ActualWeightValue     = is_array($orderCargo['ActualWeight']['Value']) ? "" : $orderCargo['ActualWeight']['Value'];
        $ActualWeightUom       = is_array($orderCargo['ActualWeight']['UOM']) ? "" : $orderCargo['ActualWeight']['UOM'];
        $WeightValue           = is_array($orderCargo['Weight']['Value']) ? "" : $orderCargo['Weight']['Value'];
        $WeightUom             = is_array($orderCargo['Weight']['UOM']) ? "" : $orderCargo['Weight']['UOM'];
        $VolumetricWeightValue = is_array($orderCargo['VolumetricWeight']['Value']) ? "" : $orderCargo['VolumetricWeight']['Value'];
        $VolumetricWeightUom   = is_array($orderCargo['VolumetricWeight']['UOM']) ? "" : $orderCargo['VolumetricWeight']['UOM'];
        $VolumeValue           = is_array($orderCargo['Volume']['Value']) ? "" : $orderCargo['Volume']['Value'];
        $VolumetUom            = is_array($orderCargo['Volume']['UOM']) ? "" : $orderCargo['Volume']['UOM'];
        $ActualVolumeValue     = is_array($orderCargo['ActualVolume']['Value']) ? "" : $orderCargo['ActualVolume']['Value'];
        $ActualVolumeUom       = is_array($orderCargo['ActualVolume']['UOM']) ? "" : $orderCargo['ActualVolume']['UOM'];
        $cargoQuantity         = is_array($orderCargo['Quantity']) ? "" : $orderCargo['Quantity'];
        $ScannedQuantity       = is_array($orderCargo['ScannedQuantity']) ? "" : $orderCargo['ScannedQuantity'];
        $ldm                   = is_array($orderCargo['ldm']) ? "" : $orderCargo['ldm'];
        $GroundedFlag          = is_array($orderCargo['GroundedFlag']) ? "" : $orderCargo['GroundedFlag'];
        $StackableFlag         = is_array($orderCargo['StackableFlag']) ? "" : $orderCargo['StackableFlag'];
        $SplittableFlag        = is_array($orderCargo['SplittableFlag']) ? "" : $orderCargo['SplittableFlag'];
        $DangerousGoodsFlag    = is_array($orderCargo['DangerousGoodsFlag']) ? "" : $orderCargo['DangerousGoodsFlag'];
        $DangerousGoods        = is_array($orderCargo['TotalPackagesOfDangerousGoods']) ? "" : $orderCargo['TotalPackagesOfDangerousGoods'];

        $currentDate = date('Y-m-d H:i:s');
        $sql = 'SELECT id FROM tbl_shipunit_types WHERE LOWER(unit_name) LIKE LOWER(?)';
       
        $gethandling_unit = $this->db->query($sql, [$cargoType]);
        
        if ($gethandling_unit->num_rows() > 0) {
            $HandlingUnit = $gethandling_unit->row()->id;
        } else {
            $handlingunit_ar = ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $user_id, 'created_at' => $currentDate, 'status' => '1'];
            $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
            $HandlingUnit = $this->db->insert_id();
        }
        
        $cargoData   = [
            'cargo_type'        => $cargoType,
            'handling_unit'     => $HandlingUnit,
            'length'            => $LengthValue,
            'length_unit'       => $LengthUom,
            'width'             => $WidthValue,
            'width_unit'        => $WidthUom,
            'height'            => $HeightValue,
            'height_unit'       => $HeightUom,
            'weight'            => $ActualWeightValue,
            'weight_unit'       => $ActualWeightUom,
            'volumetric_weight' => $VolumetricWeightValue,
            'volweight_uom'     => $VolumetricWeightUom,
            'ldm'               => $ldm,
            'volume'            => $ActualVolumeValue,
            'volume_unit'       => $VolumetUom,
            'second_weight'     => $ActualWeightValue,
            'secondweight_uom'  => $ActualWeightUom,
            'second_volume'     => $VolumeValue,
            'secondvolume_uom'  => $ActualVolumeUom,
            'goods_description' => $GoodsDescription,
            'stackable'         => $StackableFlag,
            'grounded'          => $GroundedFlag,
            'splittable'        => $SplittableFlag,
            'dg_goods'          => $DangerousGoodsFlag,
            //'item_id'           => $ItemId,
            'marks_numbers'     => $MarksandNumbers,
            'quantity'          => $cargoQuantity,
        ];
        
        //log_message("error","CargoData:".json_encode($cargoData));
        $cargoData['createdon'] = $currentDate;
            $cargoData['createdby'] = $user_id;
            $cargoId                = $this->common->insertTableData('tb_cargo_details', $cargoData);

        /*$checkCargoData = $this->db->select("id")->get_where("tb_cargo_details", $cargoData, 1, 0);
        if ($checkCargoData->num_rows() > 0) {
            $cargoId                = $checkCargoData->row()->id;
            $cargoData['updatedon'] = $currentDate;
            $cargoData['updatedby'] = $user_id;
            $this->db->where(["id" => $cargoId])->update("tb_cargo_details", $cargoData);
        } else {
            $cargoData['createdon'] = $currentDate;
            $cargoData['createdby'] = $user_id;
            $cargoId                = $this->common->insertTableData('tb_cargo_details', $cargoData);
        }*/
        
        $orderCargoData = [
            'order_id'          => $order_id,
            'cargo_id'          => $cargoId,
            'quantity_type'     => $cargoType,
            'cargo_content'     => $GoodsDescription,
            'handling_unit'     => $HandlingUnit,
            'length'            => $LengthValue,
            'width'             => $WidthValue,
            'height'            => $HeightValue,
            'weight'            => $ActualWeightValue,
            'second_weight'     => $ActualWeightValue,
            'volumetric_weight' => $VolumetricWeightValue,
            'volweight_uom'     => $VolumetricWeightUom,
            'ldm'               => $ldm,
            'volume'            => $ActualVolumeValue,
            'second_volume'     => $VolumeValue,
            'quantity'          => $cargoQuantity,
            //'qr_code'           => $ItemId,
            'marks_numbers'     => $MarksandNumbers,
            'goods_value'       => $ValueOfGoods,
            //'scanned_quantity'  => $ScannedQuantity,
            'external_cargo_id' => $ItemId,
        ];
        $checkOrderCargoData = $this->db->select("id,quantity,weight,volume,second_weight,volumetric_weight,volweight_uom,volume,second_volume")->get_where("tb_order_cargodetails", ['order_id' => $order_id, 'cargo_id' => $cargoId, 'external_cargo_id' => $ItemId, 'status' => 1]);
       
        /*$checkOrderCargoData = $this->db->select("id,quantity,weight,volume,second_weight,volumetric_weight,volweight_uom,volume,second_volume")->get_where("tb_order_cargodetails", ['order_id' => $order_id, 'cargo_id' => $cargoId, 'weight' => $ActualWeightValue, 'volume' => $ActualVolumeValue, 'quantity' => $cargoQuantity, 'length' => $LengthValue, 'width' => $WidthValue, 'height' => $HeightValue, 'status' => 1]);*/
        if ($checkOrderCargoData->num_rows() > 0) {
            $orderCargoId                = $checkOrderCargoData->row()->id;
            $orderCargoQuantity          = $checkOrderCargoData->row()->quantity;
            $orderCargoData['updatedon'] = $currentDate;
            $orderCargoData['quantity']  = ((int) $orderCargoQuantity + (int) $cargoQuantity);
            $this->db->where(["id" => $orderCargoId])->update("tb_order_cargodetails", $orderCargoData);
        } else {
            $cargoData['createdon'] = $currentDate;
            $orderCargoId           = $this->common->insertTableData('tb_order_cargodetails', $orderCargoData);
        }
        
        if (!empty($orderCargo['PackagingUnit'])) {
            if (is_array($orderCargo['PackagingUnit']) && array_key_exists(0, $orderCargo['PackagingUnit'])) {
        
                foreach ($orderCargo['PackagingUnit'] as $packagingunit) {
                    $this->insertInnerCargoInfo($packagingunit, $cargoId);
                }
        
            } else {
                
                $this->insertInnerCargoInfo($orderCargo['PackagingUnit'], $cargoId);
            }
        
        }

       
        /*if (isset($orderCargo['PackagingUnit'])) {
            if (array_key_exists("0", $orderCargo['PackagingUnit'])) {
                foreach ($orderCargo['PackagingUnit'] as $packagingunit) {
                   
                    $this->insertInnerCargoInfo($packagingunit, $cargoId);
                }
            } else {
                 
                $this->insertInnerCargoInfo($orderCargo['PackagingUnit'], $cargoId);
            }
        }*/
        return $orderCargoId;
    }

    private function insertInnerCargoInfo(array $packagingunit, int $orderCargoId): void
    {
        //log_message("error","Innnccccccccccccc:".json_encode($packagingunit));
        $currentDate = date('Y-m-d H:i:s');
        $innerCargo  = [
            'cargo_type'        => is_array($packagingunit['PackageType']) ? "" : $packagingunit['PackageType'],
            'cargo_id'          => $orderCargoId,
            'goods_description' => is_array($packagingunit['PackageDescription']) ? "" : $packagingunit['PackageDescription'],
            'quantity'          => is_array($packagingunit['Quantity']) ? "" : $packagingunit['Quantity'],
            //'scanned_quantity'  => is_array($packagingunit['Quantity']) ? "" : $packagingunit['Quantity'],
            'length'            => is_array($packagingunit['Length']['Value']) ? "" : $packagingunit['Length']['Value'],
            'length_unit'       => is_array($packagingunit['Length']['UOM']) ? "" : $packagingunit['Length']['UOM'],
            'width'             => is_array($packagingunit['Width']['Value']) ? "" : $packagingunit['Width']['Value'],
            'width_unit'        => is_array($packagingunit['Width']['UOM']) ? "" : $packagingunit['Width']['UOM'],
            'height'            => is_array($packagingunit['Height']['Value']) ? "" : $packagingunit['Height']['Value'],
            'height_unit'       => is_array($packagingunit['Height']['UOM']) ? "" : $packagingunit['Height']['UOM'],
            'weight'            => is_array($packagingunit['Weight']['Value']) ? "" : $packagingunit['Weight']['Value'],
            'weight_unit'       => is_array($packagingunit['Weight']['UOM']) ? "" : $packagingunit['Weight']['UOM'],
            'volume'            => is_array($packagingunit['Volume']['Value']) ? "" : $packagingunit['Volume']['Value'],
            'volume_unit'       => is_array($packagingunit['Volume']['UOM']) ? "" : $packagingunit['Volume']['UOM'],
            'external_cargo_id'     => is_array($packagingunit['ItemId']) ? "" : $packagingunit['ItemId'],
        ];
        /*$checkOrderinnerCargoData = $this->db->select("id")->get_where("tb_inner_cargo", $innerCargo);*/
        $checkOrderinnerCargoData = $this->db->select("id")->get_where("tb_inner_cargo", ['cargo_id' => $orderCargoId, 'external_cargo_id' => $ItemId, 'status' => 1]);
        
        if ($checkOrderinnerCargoData->num_rows() > 0) {
            $orderInnerCargoId       = $checkOrderinnerCargoData->row()->id;
            $innerCargo['updatedon'] = $currentDate;
            $this->db->where(["id" => $orderInnerCargoId])->update("tb_inner_cargo", $innerCargo);
        } else {
            $innerCargo['createdon'] = $currentDate;
            $orderCargoId            = $this->common->insertTableData('tb_inner_cargo', $innerCargo);
        }
    }

    public function insertValueAddedServices(array $ordervas, int $order_id, int $user_id): void
    {
        //log_message("error", "insertValueAddedServices" . json_encode($ordervas));
        $addonName     = is_array($ordervas['AddonName']) ? "" : $ordervas['AddonName'];
        $addonCode     = is_array($ordervas['AddonCode']) ? "" : $ordervas['AddonCode'];
        $addonCurrency = is_array($ordervas['Currency']) ? "" : $ordervas['Currency'];
        $addonRateUnit = is_array($ordervas['RateUnit']) ? "" : $ordervas['RateUnit'];
        $addonAmount   = is_array($ordervas['AddonAmount']) ? "" : $ordervas['AddonAmount'];
        $addonQuantity = is_array($ordervas['AddonQuantity']) ? "" : $ordervas['AddonQuantity'];

        $checkVasMasterData = $this->db->select("id")->get_where("tb_vas_master", ['vas_id' => $addonCode, 'vas_name' => $addonName, 'status' => 1], 1, 0);
        if ($checkVasMasterData->num_rows() > 0) {
            $vasMasterId = $checkVasMasterData->row()->id;
        } else {
            $vasMasterData = [
                'vas_id'   => $addonCode,
                'vas_name' => $addonName,
                'status'   => 1,
            ];
            $vasMasterId = $this->common->insertTableData('tb_vas_master', $vasMasterData);
        }

        $vasData      = ['order_id' => $order_id, 'vas_id' => $vasMasterId, 'quantity' => $addonQuantity, 'user_id' => $user_id, 'status' => 1];
        $checkVasData = $this->db->select("id")->get_where("tb_order_vas", ['order_id' => $order_id, 'vas_id' => $vasMasterId, 'user_id' => $user_id, 'status' => 1], 1, 0);
        if ($checkVasData->num_rows() > 0) {
            $vasId = $checkVasData->row()->id;
            $this->common->updatetbledata("tb_order_vas", $vasData, ["id" => $vasId]);
        } else {
            $vasId = $this->common->insertTableData('tb_order_vas', $vasData);
        }
    }

    public function insertOrderReferences(int $ord_id, array $orderRef): void
    {
        //log_message("error", "insertValueAddedServices" . json_encode($orderRef));
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'order_id'     => $ord_id,
            'reference_id' => $orderRef['RefType']['Code'],
            'ref_value'    => $orderRef['RefType']['Value'],
        ];
        $chkref = $this->db->select("id")->get_where("tb_order_references", $chkdt);
         //log_message("error", "Qry:" . $this->db->last_query());
        if ($chkref->num_rows() == 0) {
            $srefqry = [
                'order_id'     => $ord_id,
                'reference_id' => $orderRef['RefType']['Code'],
                'ref_value'    => $orderRef['RefType']['Value'],
                'status'       => 1,
                'createdon'    => $curdt,
            ];
            $this->common->insertTableData('tb_order_references', $srefqry);
        }
    }

    public function checkOrderCount(string $orderID): int
    {
        $checkEtnOrder = $this->db->select("id")->get_where("tb_orders", ['external_order_id' => $orderID, 'status <>' => 0], 1, 0);
        return $checkEtnOrder->num_rows() > 0 ? $checkEtnOrder->row()->id : 0;
    }

    public function getOrderShipment(string $orderID): array
    {
        $checkEtnOrder = $this->db->select("shift_id, shipmentid")->get_where("tb_orders", ['external_order_id' => $orderID, 'status <>' => 0], 1, 0);
        return $checkEtnOrder->num_rows() > 0 ? $checkEtnOrder->row_array() : [];
    }

    public function checkOrderDetails(int $orderId, int $bookingId): int
    {
        $checkOrderDetails = $this->db->select("id")->get_where("tb_order_details", ["order_row_id" => $orderId, "order_id" => $bookingId, "status" => 1], 1, 0);
        return $checkOrderDetails->num_rows() ?? 0;
    }

    public function getBookingId(int $orderId): int
    {
        $getBookingId = $this->db->select("order_id")->get_where("tb_orders", ["id" => $orderId], 1, 0);
        return $getBookingId->num_rows() > 0 ? $getBookingId->row()->order_id : 0;
    }

    public function insertOrderParties(array $orderParty): void
    {
        $currentDate = date('Y-m-d H:i:s');
        if (! empty($orderParty)) {
            $orderPartyData = [
                'order_id'     => $orderParty['order_id'],
                'order_number' => $orderParty['order_number'],
                'party_type'   => $orderParty['party_type'],
                'status'       => 1,
            ];
            $checkOrderParty = $this->db->select("id")->get_where("tb_order_parties", $orderPartyData, 1, 0);
            if ($checkOrderParty->num_rows() == 0) {
                $orderParty['createdon'] = $currentDate;
                $this->common->insertTableData('tb_order_parties', $orderParty);
            } else {
                $orderParty['updatedon'] = $currentDate;
                $id                      = $checkOrderParty->row()->id;
                $this->common->updatetbledata("tb_order_parties", $orderParty, ["id" => $id]);
            }
        }
    }

    public function getTransportModeName(string $modeOfTransport): array
    {
        $modeOfTransportName = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE  ?", [$modeOfTransport]);
        return $modeOfTransportName->num_rows() > 0 ? $modeOfTransportName->row_array() : [];
    }

    public function getBranchCompanyCodes(string $logicalReceiver): array
    {
        $checkBranchCompanyCodes = $this->db->select("branch_code,company_code")->get_where(
            "tb_branch_master",
            [
                "logical_sender" => $logicalReceiver,
                "status"         => 1,
            ],
            1,
            0
        );
        return $checkBranchCompanyCodes->num_rows() > 0 ? $checkBranchCompanyCodes->row_array() : [];
    }
    
    public function getOtmPartyTypeId(string $company_code, string $branch_code, string $partyDataType): int
    {
        $partyTypeInfo = [
            'name' => $partyDataType,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
        ];
    
        // Check if record exists
        $this->db->select('id');
        $this->db->where($partyTypeInfo);
        $query = $this->db->get('tbl_party_types');
        $checkPartyType = $query->row_array() ?? [];
    
        if (!empty($checkPartyType)) {
            return (int)$checkPartyType['id'];
        }
    
        // Insert new record
        $this->db->insert('tbl_party_types', $partyTypeInfo);
        return $this->db->insert_id() ?: 0;
    }
    
    public function getOrderUserTimeZone(int $user_id): array
    {
        $sql = "SELECT 
                    tc.country_name,
                    tc.country_code,
                    tc.cntry_timezone,
                    tc.cntry_hrs,
                    tc.currency,
                    tc.phone_code
                FROM tb_users u
                JOIN tbl_country_master tc ON u.country_code = tc.country_code
                WHERE u.id = ?";
                
        $query = $this->db->query($sql, [$user_id]);
        
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
    
    public function deleteExistingInnerCargosForOrder(int $orderId = 0): void
    {
        if ($orderId > 0) {
            // Fetch cargo IDs linked to the order
            $this->db->select('cargo_id');
            $this->db->where('order_id', $orderId);
            $query = $this->db->get('tb_order_cargodetails');
    
            if ($query->num_rows() > 0) {
                $cargoIds = [];
                foreach ($query->result_array() as $eachLine) {
                    $cargoIds[] = $eachLine['cargo_id'];
                }
    
                // Delete inner cargo entries for those cargo IDs
                if (!empty($cargoIds)) {
                    $this->db->where_in('cargo_id', $cargoIds);
                    $this->db->delete('tb_inner_cargo');
    
                    // Optional debug logging
                    // log_message('error', 'Deleted inner cargos for cargo_ids: ' . implode(',', $cargoIds));
                }
            }
        }
    }
    
    public function insertOtmOrderParties(array $orderParty): void
    {
        if (!empty($orderParty)) {
            // Check if record already exists
            $this->db->select('id');
            $this->db->where($orderParty);
            $this->db->limit(1);
            $query = $this->db->get('tb_order_parties');
    
            // If not found, insert it
            if ($query->num_rows() == 0) {
                $this->db->insert('tb_order_parties', $orderParty);
            }
        }
    }
    
    public function otmInsertOrder(
        array $orderData,
        array $customerInfo,
        array $sourceInfo,
        array $destinationInfo,
        int $ship_row_id,
        string $timeZone,
        string $company_code,
        string $branch_code,
        int $user_id
    ): int {

        $e_pickup = is_array($orderData["sourceInfo"]["EstimatedDateTime"]["From"]["DateTime"]) ? "" : str_replace(
            "T",
            " ",
            $orderData["sourceInfo"]["EstimatedDateTime"]["From"]["DateTime"]);
        $l_pickup = is_array($orderData["sourceInfo"]["EstimatedDateTime"]["To"]["DateTime"]) ? "" : str_replace(
            "T",
            " ",
            $orderData["sourceInfo"]["EstimatedDateTime"]["To"]["DateTime"]);
        $e_delivery = is_array(
            $orderData["destinationInfo"]["EstimatedDateTime"]["From"][
                "DateTime"
            ]
        )
            ? "" : str_replace(
                "T",
                " ",
                $orderData["destinationInfo"]["EstimatedDateTime"]["From"][
                    "DateTime"
                ]
            );
        $l_delivery = is_array(
            $orderData["destinationInfo"]["EstimatedDateTime"]["To"]["DateTime"]
        )
            ? "" : str_replace(
                "T",
                " ",
                $orderData["destinationInfo"]["EstimatedDateTime"]["To"][
                    "DateTime"
                ]
            );
        if($e_pickup){
             $e_pickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $timeZone)[
            "datetime"
        ];
        }
       if($l_pickup){
           $l_pickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $timeZone)[
            "datetime"
        ];
       }
       if ($e_delivery) {
            $e_delivery = getdatetimebytimezone(
                DFLT_TZ,
                $e_delivery,
                $timeZone
            )["datetime"];
        }
        if ($l_delivery) {
            $l_delivery = getdatetimebytimezone(
                DFLT_TZ,
                $l_delivery,
                $timeZone
            )["datetime"];
        }
        /*$created_source     = '4';
        $customer_id        = $customerInfo['customer_id'];
        $customer_code      = $customerInfo['party_code'];
        $pickup_custid      = ! empty($orderData['sourceInfo']['ID']) ? $orderData['sourceInfo']['ID'] : $sourceInfo['party_id'];
        $pickup_code        = $sourceInfo['party_code'];
        $destination_custid = $destinationInfo['party_id'];
        $destination_code   = $destinationInfo['party_code'];*/

        $plat          = (empty($orderData['sourceInfo']['Address']['Latitude']) ? "" : $orderData['sourceInfo']['Address']['Latitude']);
        $plng          = (empty($orderData['sourceInfo']['Address']['Longitude']) ? "" : $orderData['sourceInfo']['Address']['Longitude']);
        $sourceStreet  = (empty($orderData['sourceInfo']['Address']['Street']) ? "" : $orderData['sourceInfo']['Address']['Street']);
        $sourceCity    = (empty($orderData['sourceInfo']['Address']['City']) ? "" : $orderData['sourceInfo']['Address']['City']);
        $sourceState = empty(
                $orderData["sourceInfo"]["Address"]["Province"]
            )
                ? ""
                : $orderData["sourceInfo"]["Address"]["Province"];
        if(empty($sourceState)){
            $sourceState = empty(
                $orderData["sourceInfo"]["Address"]["State"]
            )
                ? ""
                : $orderData["sourceInfo"]["Address"]["State"];
        }
        $sourceCountry = (empty($orderData['sourceInfo']['Address']['Country']) ? "" : $orderData['sourceInfo']['Address']['Country']);
        $sourcePostal  = (empty($orderData['sourceInfo']['Address']['Postal']) ? "" : $orderData['sourceInfo']['Address']['Postal']);
        if ($plat == "" && $plng == "") {
            $pickupaddress = implode(",", [$sourceStreet, $sourceCity, $sourceCountry, $sourcePostal]);
            $data          = getlatlngsbyplace($pickupaddress);
            $plat          = @$data[0];
            $plng          = @$data[1];
        }

        $dlat               = (empty($orderData['destinationInfo']['Address']['Latitude']) ? "" : $orderData['destinationInfo']['Address']['Latitude']);
        $dlng               = (empty($orderData['destinationInfo']['Address']['Longitude']) ? "" : $orderData['destinationInfo']['Address']['Longitude']);
        $destinationStreet  = (empty($orderData['destinationInfo']['Address']['Street']) ? "" : $orderData['destinationInfo']['Address']['Street']);
        $destinationCity    = (empty($orderData['destinationInfo']['Address']['City']) ? "" : $orderData['destinationInfo']['Address']['City']);
        $destinationCountry = (empty($orderData['destinationInfo']['Address']['Country']) ? "" : $orderData['destinationInfo']['Address']['Country']);
        $destinationState = empty(
                $orderData["destinationInfo"]["Address"]["Province"]
            )
                ? ""
                : $orderData["destinationInfo"]["Address"]["Province"];
        if(empty($destinationState)){
            $destinationState = empty(
                $orderData["destinationInfo"]["Address"]["State"]
            )
                ? ""
                : $orderData["destinationInfo"]["Address"]["State"];
        }
        $destinationPostal  = (empty($orderData['destinationInfo']['Address']['Postal']) ? "" : $orderData['destinationInfo']['Address']['Postal']);
        if ($dlat == "" && $dlng == "") {
            $dropaddress = implode(",", [$destinationStreet, $destinationCity, $destinationCountry, $destinationPostal]);
            $data        = getlatlngsbyplace($dropaddress);
            $dlat        = @$data[0];
            $dlng        = @$data[1];
        }
        $orderQuantity = empty($orderData['cargoSummary']['TotalQuantity']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalQuantity']['Value'];
        $orderWeight   = empty($orderData['cargoSummary']['TotalWeight']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalWeight']['Value'];
        $orderVolume   = empty($orderData['cargoSummary']['TotalVolume']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalVolume']['Value'];
        //log_message("error", "e_delivery" . $e_delivery);
        //log_message("error", "ModeOfTransport:" . $orderData['ModeOfTransport']);
        
        $vendorId = "";
        $sql = 'SELECT id FROM tb_vendors WHERE code LIKE ? AND status =1';
       
        $getvendordetails = $this->db->query($sql, [$orderData['carrierDetails']['ID']]);
       
        if ($getvendordetails->num_rows() > 0) {
            $vendorId =  $getvendordetails->row()->id;
        }
        
        $orderinfo = [
            'customer_id'       => $customerInfo["customer_id"],
            'product'           => $orderData['Product'],
            'pickup_datetime'   => $e_pickup,
            'delivery_datetime' => $e_delivery ?? null,
            'pickup_endtime'    => $l_pickup,
            'drop_endtime'      => $l_delivery ?? null,
            'goods_value'       => "0.00",
            'currency'          => "",
            'company_code'      => $company_code,
            'branch_code'       => $branch_code,
            'drop_custid'       => $destinationInfo["party_id"] ?? null,
            'drop_partyid'      => $destinationInfo["party_id"] ?? null,
            'user_id'           => $user_id,
            'pickup_custid'     => $sourceInfo["party_id"] ?? null,
            'pickup_partyid'    => $sourceInfo["party_id"] ?? null,
            'sub_uid'           => 0,
            'pickup_country'    => $sourceCountry ?? "",
            'pickup_city'       => $sourceCity ?? "",
            'pickup_pincode'    => $sourcePostal ?? "",
            'pickup_company'    => (empty($orderData['sourceInfo']["Company"]["Name"]) ? "" : $orderData['sourceInfo']["Company"]["Name"]),
            'pickup_address1'   => (empty($orderData['sourceInfo']['Address']['Street']) ? "" : $orderData['sourceInfo']['Address']['Street']),
            'pickup_address2'   => (empty($orderData['sourceInfo']['Address']['State']) ? "" : $orderData['sourceInfo']['Address']['State']),
            'delivery_country'  => $destinationCountry,
            'delivery_city'     => $destinationCity,
            'delivery_pincode'  => $destinationPostal,
            'delivery_company'  => (empty($orderData['destinationInfo']["Company"]["Name"]) ? "" : $orderData['destinationInfo']["Company"]["Name"]),
            'delivery_address1' => (empty($orderData['destinationInfo']['Address']['Street']) ? "" : $orderData['destinationInfo']['Address']['Street']),
            'delivery_address2' => (empty($orderData['destinationInfo']['Address']['State']) ? "" : $orderData['destinationInfo']['Address']['State']),
            'is_created'        => '1',
            'plat'              => $plat,
            'plng'              => $plng,
            'dlat'              => $dlat,
            'dlng'              => $dlng,
            'vendor_id'         => $vendorId,
            'vehicle_type'      => $orderData['vehicleType'],
            'quantity'          => $orderQuantity,
            'weight'            => $orderWeight,
            'volume'            => $orderVolume,
            'transport_mode'    => $orderData['ModeOfTransport'],
            'modeOfTransport'   => $orderData["modeOfTransportId"],
            'created_source'    => $orderData['createdSource'] ?: 23,
            'createdon'         => date('Y-m-d H:i:s'),
            'shipment_id'       => $ship_row_id,
            'external_order_id' => $orderData['EXTOrderID'],
        ];
        $checketnorder = $this->checkOrderCount($orderData['EXTOrderID']);
        if ($checketnorder == 0) {
            $order_id   = $this->common->insertTableData('tb_orders', $orderinfo);
            $booking_id = $this->generateOrderBookingId($order_id, $user_id);
            $this->db->where(['id' => $order_id])->update("tb_orders", ['order_id' => $booking_id]);
        } else {
            $order_id = $checketnorder;
            $this->common->updatetbledata("tb_orders", $orderinfo, ["id" => $order_id]);
        }
        return $order_id;
    }
    
    public function checkOtmModeOfTransport(array $orderInfo): string
    {
        $modeOfTransport       = $orderInfo['ModeOfTransport'];
        $companyCode     = empty($orderInfo['SVKOrgDetails']['Companycode']) ? "" : $orderInfo['SVKOrgDetails']['Companycode'];
        $branchCode      = empty($orderInfo['SVKOrgDetails']['Branchcode']) ? "" : $orderInfo['SVKOrgDetails']['Branchcode'];
        $logicalReceiver = empty($orderInfo['SVKOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['LogicalReceiver'];
        if ($logicalReceiver != "") {
            $checkBranchCompanyCodes = $this->getBranchCompanyCodes($orderInfo['SVKOrgDetails']['LogicalReceiver']);
            if (! empty($checkBranchCompanyCodes)) {
                $companyCode = $checkBranchCompanyCodes['company_code'];
                $branchCode  = $checkBranchCompanyCodes['branch_code'];
            }
        }
        $modeOfTransportData = [
            'code'    => $modeOfTransport,
            'company_code' => $companyCode,
            'branch_code'  => $branchCode,
            'status'       => 1,
        ];
        $getMod = $this->common->gettblrowdata($modeOfTransportData, 'id', 'tb_transportmode', 0, 0);
        if (!empty($getMod)) {
            $firstRow = is_array($getMod[0]) ? $getMod[0] : (array)$getMod[0];
            $modeofTransportId = $firstRow['id'] ?? 0;
        } else {
            $modeOfTransportData = [
                'tmt.source_mode_of_transport'    => "DEFAULT",
                'tmt.organization_name' => $companyCode,
                'tmt.business_entity_value'  => $branchCode,
            ];
            $select = 'ttm.id';
            $getMod = $this->common->getjointbldata("tb_transportmode ttm", "tb_mode_of_transport_xref tmt", "ttm.code=tmt.destination_mode_of_transport", $modeOfTransportData, $select, 1, 0);
            if (!empty($getMod)) {
                $firstRow = is_array($getMod[0]) ? $getMod[0] : (array)$getMod[0];
                $modeofTransportId = $firstRow['id'] ?? 0;
            }
        }
        return $modeofTransportId ?? "";
    }
    
    public function checkOtmModeOfTransportNew(string $companyCode, string $branchCode, string $modeOfTransport): array
    {
        $whereArray = [
            'code'         => $modeOfTransport,
            'company_code' => $companyCode,
            'branch_code'  => $branchCode,
            'status'       => 1
        ];
        
        $getMod = $this->common->gettblrowdata($whereArray, 'id, code', 'tb_transportmode', 0, 0);
        /*log_message("error", "MOTQRy" . $this->db->last_query());
        log_message("error", "getMod" . json_encode($modData));*/
        if (!empty($getMod)) {
            $modeofTransportId = $getMod['id'];
            $modeofTransport   = $getMod['code'];
            $modData = [
                'ModeofTransportId' => $modeofTransportId,
                'ModeofTransport'  => $modeofTransport,
            ];
            //log_message("error", "getMod111" . json_encode($modData));
        } else {
            $modeOfTransportData = [
                'tmt.source_mode_of_transport'    => "DEFAULT",
                'tmt.organization_name' => $companyCode,
                'tmt.business_entity_value'  => $branchCode,
            ];
            $select = 'ttm.id, ttm.code';
            $getMod = $this->common->getjointbldata("tb_transportmode ttm", "tb_mode_of_transport_xref tmt", "ttm.code=tmt.destination_mode_of_transport", $modeOfTransportData, $select, 1, 0);
            
            if (!empty($getMod)) {
                $firstRow = is_array($getMod[0]) ? $getMod[0] : (array)$getMod[0];
                $modeofTransportId = $firstRow['id'] ?? 0;
                $modeofTransport = $firstRow['code'] ?? 0;
                
                $modData = [
                    'ModeofTransportId' => $modeofTransportId,
                    'ModeofTransport'  => $modeofTransport,
                ];
            }
            //log_message("error", "getMod222" . json_encode($modData));
        }
        //log_message("error", "modData" . json_encode($modData));
        return $modData ?? [];
    }
    
    function checkOtmOrderType(string $companyCode, string $branchCode, string $orderType): int
    {
        $orderTypeData = [
            'type_name'    => $orderType,
            'company_code' => $companyCode,
            'branch_code'  => $branchCode,
            'status'       => 1,
        ];
        $getOrderType = $this->common->gettblrowdata($orderTypeData, 'id', 'tb_order_types', 0, 0);
       //log_message("error", "Qry:" . $this->db->last_query());
        if (!empty($getOrderType)) {
            $orderTypeId = $getOrderType['id'] ?? 0;
           
        } else {
            $orderTypeData = [
                'txr.source_order_type'    => "DEFAULT",
                'txr.organization_name' => $companyCode,
                'txr.business_entity_value'  => $branchCode,
            ];
            $select = 'tot.id';
            $getOrderType = $this->common->getjointbldata("tb_order_types tot", "tb_order_type_xref txr", "tot.type_name=txr.destination_order_type", $orderTypeData, $select, 1, 0);
            //("error", "Qry1:" . $this->db->last_query());
            if (!empty($getOrderType)) {
                $firstRow = is_array($getOrderType[0]) ? $getOrderType[0] : (array)$getOrderType[0];
                $orderTypeId = $firstRow['id'] ?? 0;
               
            }
        }
        
        
       
        return $orderTypeId ?? 0;
    }

}
