<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property Common $common
 */
class TrailerMasterModel extends Common
{
    const TABLE_NAME = 'trailer_master';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @throws RuntimeException
     */
    public function add(string $trailerName): int
    {
        if (empty($trailerName)) {
            throw new RuntimeException('Trailer name should not be empty.');
        }

        $result = $this->gettblrowdata(['trailer_name' => $trailerName], ['id'], self::TABLE_NAME, 0, 0);
        if (empty($result) || empty($result['id'])) {
            return (int) $this->common->insertTableData(self::TABLE_NAME, ['trailer_name' => $trailerName]);
        }
        return (int) $result['id'];
    }
}
