<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class TripOrderCloseModel extends CI_Model
{
	public function getTripInfo(int $tripId, string $timeZone) : array {
		$getData = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(etime, ?) AS etime,etime AS tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id = ? AND status=? LIMIT ?", [$timeZone, $tripId, 1, 0]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}

	public function getShiftInfo(int $shiftId, string $timeZone) : array {
		$getData = $this->db->query("SELECT user_id,stime AS setime,convertToClientTZ(startdate,?) AS startdate, convertToClientTZ(enddate,?) AS enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id = ? LIMIT ?", [$timeZone, $timeZone, $shiftId, 1]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}

	public function getEmployeeInfo(int $tripId, string $timeZone) {
		return $this->db->query("SELECT e.name,convertToClientTZ(te.stime, ? ) AS in_time,te.status AS emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id FROM tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id = ? ", [$timeZone, $tripId]);
	}

	public function getTripEmployee(int $tripId) : array {
		$getData = $this->db->query("SELECT IFNULL(SUM(IF(e.status=?,?,?)),?) AS attcnt, count(e.employee_id) AS totcnt FROM tb_trip_employee e WHERE e.trip_id=?", ['1',1,0,0,$tripId]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}

	public function getVehicleInfo(int $vehicleId) : array {
		$getData = $this->db->query("SELECT truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude FROM tb_trucks_data WHERE id=? LIMIT ?", [$vehicleId, 1]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}

	public function getDriverInfo(int $driverId) : array {
		$getData = $this->db->query("SELECT name, contact_num, vendor_id FROM tb_truck_drivers WHERE id = ? LIMIT ?", [$driverId, 1]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}

	public function getDriverLocations(int $tripId) : array {
		$getData = $this->db->query("SELECT latitude, longitude FROM tb_rtdrive_locations WHERE trip_id =? ORDER BY `timestamp` DESC", [$tripId]);
		return $getData->num_rows() > 0 ? $getData->result_array() : [];
	}

	public function getUserInfo(int $userId) : array {
		$getData = $this->db->query("SELECT name, emailid, cc_mails, address FROM tb_users WHERE emailid !='' AND id = ? ORDER BY `timestamp` DESC LIMIT ?", [$userId, 1]);
		return $getData->num_rows() > 0 ? $getData->row_array() : [];
	}
}