<?php

defined('BASEPATH') or exit('No direct script access allowed');
use App\Models\Table;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Trips_model extends Table
{
    const TABLE = "tb_shifts";

    const ADDITIONAL_CONDITIONS_COL          = "additional_conditions";
    const BORDER_TYPE_COL                    = "border_type";
    const BRANCH_CODE_COL                    = "branch_code";
    const CARRIER_INSTRUCTIONS_COL           = "carrier_instructions";
    const CARRIER_TYPE_COL                   = "carrier_type"; // DEFAULT '1' COMMENT '0=single,1=multiple'
    const COMPANY_CODE_COL                   = "company_code";
    const CREATED_ON_COL                     = "created_on";
    const CUSTOMER_ID_COL                    = "customer_id";
    const DCITY_COL                          = "dcity";
    const DEPARTMENT_CODE_COL                = "department_code";
    const DESTINATION_ID_COL                 = "destination_id";
    const DOMAINNAME_COL                     = "domainname";
    const ELAT_COL                           = "elat";
    const ELNG_COL                           = "elng";
    const EMPSHIFT_END_COL                   = "empshift_end";
    const EMPSHIFT_START_COL                 = "empshift_start";
    const ENDDATE_COL                        = "enddate";
    const EPLACE_COL                         = "eplace";
    const ETIME_COL                          = "etime";
    const ID_COL                             = "id";
    const INTERCHANGE_CONTROL_REFERENCE_COL  = "interchange_control_reference";
    const ORIGIN_ID_COL                      = "origin_id";
    const SCHEDULE_DATE_COL                  = "schedule_date";
    const SCITY_COL                          = "scity";
    const SHIFT_LEG_ID_COL                   = "shift_leg_id";
    const SHIPMENT_ID_COL                    = "shipment_id";
    const SHIPMENT_NAME_COL                  = "shipment_name";
    const SHIPMENTID_COL                     = "shipmentid";
    const SLAT_COL                           = "slat";
    const SLNG_COL                           = "slng";
    const SPLACE_COL                         = "splace";
    const STARTDATE_COL                      = "startdate";
    const STATUS_COL                         = "status";
    const STIME_COL                          = "stime";
    const TEMPERATURE_REGIME_COL             = "temperature_regime";
    const TIME_FOR_LOADING_PENALITY_RATE_COL = "time_for_loading_penality_rate";
    const TRANSPORT_MODE_COL                 = "transport_mode";
    const TRIP_TYPE_COL                      = "trip_type"; // tinyint(1) DEFAULT '0' COMMENT '''0->regular trip,1->return trip,2->empty_trip'''
    const TXNID_COL                          = "txnid";
    const UNITS_COL                          = "units";
    const UPDATED_ON_COL                     = "updated_on";
    const USER_ID_COL                        = "user_id";
    const VEHICLE_TYPE_COL                   = "vehicle_type";
    const VENDOR_ID_COL                      = "vendor_id";
    const VOLUME_COL                         = "volume";
    const VOLUME_CAPACITY_COL                = "volume_capacity";
    const WEIGHT_COL                         = "weight";
    const WEIGHT_CAPACITY_COL                = "weight_capacity";
    const ZONE_ID_COL                        = "zone_id";

    /**
     * Class Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['stop_detail', 'common']);
    }

    const API_TRIP_TYPE_MAP = [
        'REGULAR'    => 0,
        'RETURN'     => 1,
        'EMPTY_TRIP' => 2,
    ];

    /**
     * This method fetches the Legs data from the shift values
     * @param int shiftid  where conditon elements.
     * @return array
     */
    public function getshiftlegsdata($shiftId)
    {
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $legInfo         = $shiftLegIds         = $finalQueryResult         = [];
        $shiftlegsData   = $this->common->gettbldata(["shift_leg_id" => $shiftId], "id", "tb_shifts", 0, 0);
        $shiftIds     = [];
        foreach ($shiftlegsData as $eachLegId) {
            $shiftIds[] = $eachLegId['id'];
        }
        $checkLegs = count($shiftIds) > 1 ? 1 : 0;
        $this->db->select("s.id, s.scity, s.dcity,convertToClientTZ(s.startdate, '" . $currentTimeZone . "') as startdate,convertToClientTZ(s.enddate,'" . $currentTimeZone . "') as enddate ,s.shipmentid,s.transport_mode,s.vendor_id,s.shift_leg_id, s.origin_id,s.destination_id,d.truck_type AS vehicletype,sv.vehicle_id,a.driver_id");
        $this->db->from("tb_shifts s");
        $this->db->join('tb_shft_veh sv', 's.id=sv.shft_id', 'LEFT');
        $this->db->join('tbl_assigned_drivers a', 'sv.vehicle_id=a.vehicle_id', 'LEFT');
        $this->db->join('tb_trucks_data d', 'd.id=sv.vehicle_id', 'LEFT');
        $this->db->where_in('s.id', $shiftIds);
        $this->db->group_by('s.id');
        $finalQuery = $this->db->get();
        if ($finalQuery && $finalQuery->num_rows() > 0) {
            foreach ($finalQuery->result_array() as $eachRow) {
                $finalQueryResult[$eachRow['id']] = $eachRow;
            }
            if ($checkLegs == 1) {
                foreach ($finalQueryResult as $eachRow) {
                    $shiftLegId = $eachRow['shift_leg_id'];
                    if ($shiftLegId > 0) {
                        $legId                   = $eachRow['id'];
                        $legNumber               = $eachRow['shipmentid'];
                        $shiftLegIds[]           = $eachRow['id'];
                        $legInfo[$eachRow['id']] = [
                            'vendorId'          => $eachRow['vendor_id'],
                            'truckType'         => $eachRow['vehicletype'],
                            'vehicleId'         => $eachRow['vehicle_id'],
                            'driverId'          => $eachRow['driver_id'],
                            'fromCity'          => $eachRow['scity'],
                            'toCity'            => $eachRow['dcity'],
                            'startDate'         => $eachRow['startdate'],
                            'endDate'           => $eachRow['enddate'],
                            'legId'             => $legId,
                            'legNumber'         => $legNumber,
                            'pickupStopPartyId' => "",
                            'dropStopPartyId'   => "",
                            'transportMode'     => $eachRow['transport_mode'],
                        ];
                    }
                }
            } else {
                $checkShiftId = $finalQueryResult[$shiftId]['id'] ?? 0;
                if ($checkShiftId > 0) {
                    $pickupStopPartyId                          = $finalQueryResult[$shiftId]['origin_id'];
                    $dropStopPartyId                            = $finalQueryResult[$shiftId]['destination_id'];
                    $legInfo[$finalQueryResult[$shiftId]['id']] = [
                        'vendorId'          => $finalQueryResult[$shiftId]['vendor_id'],
                        'truckType'         => $finalQueryResult[$shiftId]['vehicletype'],
                        'vehicleId'         => $finalQueryResult[$shiftId]['vehicle_id'],
                        'driverId'          => $finalQueryResult[$shiftId]['driver_id'],
                        'fromCity'          => $finalQueryResult[$shiftId]['scity'],
                        'toCity'            => $finalQueryResult[$shiftId]['dcity'],
                        'startDate'         => $finalQueryResult[$shiftId]['startdate'],
                        'endDate'           => $finalQueryResult[$shiftId]['enddate'],
                        'legId'             => 0,
                        'legNumber'         => 0,
                        'pickupStopPartyId' => $pickupStopPartyId,
                        'dropStopPartyId'   => $dropStopPartyId,
                        'transportMode'     => $finalQueryResult[$shiftId]['transport_mode'],
                    ];
                }
            }
        }
        if (! empty($shiftLegIds)) {
            $checkStops = $this->common->gettbldata("shipment_id IN (" . implode(',', $shiftLegIds) . ") AND status ='1'", "stoptype,shipment_id,stop_party_id", "tb_shiporder_stops", 0, 0);
            foreach ($checkStops as $eachRow) {
                $shiftId                                                                                              = $eachRow['shipment_id'];
                $legInfo[$shiftId][strtoupper($eachRow['stoptype']) == "P" ? 'pickupStopPartyId' : 'dropStopPartyId'] = $eachRow['stop_party_id'];
            }
        }
        return $legInfo;
    }

    public function getShiftById($shiftId, $userId)
    {
        try {
            $query = $this->db->query("SELECT * FROM `tb_shifts` WHERE  status='1' AND id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getShiftVehicles($shiftId, $userId)
    {
        try {
            $query = $this->db->query("SELECT * FROM `tb_shft_veh` WHERE `user_id` = '" . $userId . "' AND status='1' AND shft_id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches Shift details by Shift Id
     * @param $shiftId Integer
     * @param $userId Integer
     * @return array
     */
    public function getShiftDetailsById($shiftId, $userId)
    {
        try {
            $query = $this->db->query("SELECT s.*,sv.* FROM `tb_shifts` s JOIN tb_shft_veh sv ON s.id = sv.shft_id WHERE s.`user_id` = '" . $userId . "' AND s.status='1' AND s.id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all vendors
     * @param $userId Integer
     * @return array
     */
    public function getVendors($userId)
    {
        try {
            $query = $this->db->query("SELECT * FROM `tb_vendors` WHERE `user_id` = '" . $userId . "' AND status='1'");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all vehicles from master table
     * @param $userId Integer
     * @return array
     */
    public function getVehicleTypes($userId)
    {
        try {
            $query = $this->db->query("SELECT * FROM `tb_trucktypes` WHERE `user_id` = '" . $userId . "' AND status='Active'");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all trucks from master table
     * @param $userId Integer
     * @return array
     */
    public function getTrucksData($userId)
    {
        try {
            $query = $this->db->query("SELECT * FROM `tb_trucks_data` WHERE `user_id` = '" . $userId . "' AND status='Active' ORDER BY truck_type");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all drivers per shift
     * @param $userId Integer
     * @param $vehicleId Integer
     * @return array
     */
    public function getShiftAssignedDrivers($userId, $vehicleId)
    {
        try {
            $driverIds = [];
            $query     = $this->db->query("SELECT DISTINCT(driver_id) FROM tbl_assigned_drivers WHERE vehicle_id = " . $vehicleId . " AND status='1' AND user_id = '" . $userId . "'");
            $results   = $query->result_array();
            foreach ($results as $result) {
                $driverIds[] = $result['driver_id'];
            }

            return $driverIds;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all truck drivers
     * @param $userId Integer
     * @return array
     */
    public function getTruckDrivers($userId)
    {
        try {
            $query = $this->db->query("SELECT td.name,td.id FROM tb_truck_drivers td JOIN tb_vehicles_drivers vd ON vd.driver_id = td.id WHERE td.user_id = '" . $userId . "' AND td.status = 'Active' GROUP BY td.id");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches the department codes based on company code and branch code
     * @return array
     */
    public function getDepartmentsnew($companyCode, $branchCode)
    {
        try {
            $query = $this->db->query("SELECT * FROM tb_department_master WHERE company_code='$companyCode' AND branch_code='$branchCode' AND status='1' ORDER BY department_code");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all department codes
     * @return array
     */
    public function getDepartments()
    {
        try {
            $query = $this->db->query("SELECT * FROM tb_department_master WHERE status='1' ORDER BY department_code");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method lists orders per shift
     * @param int $shiftId
     * @return array
     */
    public function getShiftOrders(int $shiftId): array
    {
        $result          = $orderRowIds          = [];
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $getOrderDetails = $this->db->query("SELECT o.id,o.order_id,o.pickup_company,o.delivery_company,o.quantity,o.weight,o.volume,o.transport_mode,o.trip_sts,o.shift_id,o.trip_id,convertToClientTZ(o.createdon,?) as createdon,o.shipmentid,o.branch_code,d.department_code,d.service,o.product FROM tb_orders o LEFT JOIN tb_order_details d on d.order_row_id = o.id WHERE o.shift_id = ? AND o.status > ? AND d.status > ?", [$currentTimeZone, $shiftId, 0, 0]);
        log_message("error", "shiftLegsdataQuery:" . $this->db->last_query());
        $orderData = $getOrderDetails->num_rows() > 0 ? $getOrderDetails->result_array() : [];
        foreach ($orderData as $eachRow) {
            $orderRowIds[] = $eachRow['id'];
            $orderStatus   = 'PENDING';
            if ($eachRow['trip_id'] > 0 && $eachRow['trip_sts'] == 0) {
                $orderStatus = 'ACTIVE';
            }
            if ($eachRow['trip_id'] && $eachRow['trip_sts'] == 1) {
                $orderStatus = 'CLOSED';
            }
            $result[$eachRow['id']] = [
                'orderRowId'      => $eachRow['id'],
                'bookingId'       => $eachRow['order_id'],
                'pickupCompany'   => $eachRow['pickup_company'],
                'deliveryCompany' => $eachRow['delivery_company'],
                'quantity'        => $eachRow['quantity'],
                'weight'          => $eachRow['weight'],
                'volume'          => $eachRow['volume'],
                'tranportMode'    => $eachRow['transport_mode'],
                'tripStatus'      => $eachRow['trip_sts'],
                'shiftId'         => $eachRow['shift_id'],
                'tripId'          => $eachRow['trip_id'],
                'createdOn'       => $eachRow['createdon'],
                'shipmentId'      => $eachRow['shipmentid'],
                'orderStatus'     => $orderStatus,
                'departmentCode'  => $eachRow['department_code'],
                'branchCode'      => $eachRow['branch_code'],
                'service'         => $eachRow['service'],
                'product'         => $eachRow['product'],
            ];
        }
        if (! empty($orderRowIds)) {
            $getDqREf = $this->common->gettbldata("reference_id ='DQ' AND order_id IN (" . implode(',', $orderRowIds) . ") AND status ='1'", "order_id,ref_value", "tb_order_references", 0, 0);
            foreach ($getDqREf as $eachRow) {
                $orderId                     = $eachRow['order_id'];
                $result[$orderId]['dqValue'] = $eachRow['ref_value'];
            }
        }
        return $result;
    }

    /* Get Trip Legs */
    public function gettripLegsOrder($shiftId, $trip_id)
    {
        try {
            $query        = $this->db->query("SELECT * FROM tb_trips_legs WHERE shift_id = " . $shiftId . " AND trip_id = " . $trip_id . " AND status=0 ");
            $orderLegdata = $query->result_array();

            return $orderLegdata;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method updates shift
     */
    public function updateShift($shiftId, $update)
    {
        try {
            $this->db->where('id', $shiftId);
            $this->db->update('tb_shifts', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method updates shift vehicle
     */
    public function updateShiftVeh($shiftId, $update)
    {
        try {
            $this->db->where('shft_id', $shiftId);
            $this->db->update('tb_shft_veh', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updatedata($table, $id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update($table, $data);
    }

    public function addOrder($orderIds, $shiftId)
    {
        try {
            // Loop over Orders
            foreach ($orderIds as $orderId) {
                //$details = $this->getOrderDetailsById($orderId);
                $update = $this->updateShiftId($orderId, $shiftId);
                // $insert=$this->insertShipOrderStops($details, $shiftId);
            }
            return true;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }
/* Add Trip legs */
    public function addtriplegs($triplegId, $OrderId, $shipment_id)
    {
        try {

            foreach ($triplegId as $triplegsId) {
                $orderLegNdata = $this->common->gettblrowdata(['order_id' => $OrderId, 'leg_id' => $triplegsId, 'shipment_id' => $shipment_id], "id", 'tb_order_legs', 0, 0);
                if (count($orderLegNdata) == 0) {
                    $curdt      = date('Y-m-d H:i:s');
                    $userId     = $this->session->userdata('user_id');
                    $tripemparr = ['order_id' => $OrderId, 'leg_id' => $triplegsId, 'shipment_id' => $shipment_id, 'createdon' => $curdt, 'created_by' => $userId];
                    $data       = $this->common->insertTableData('tb_order_legs', $tripemparr);
                }

                $legorderdetails = $this->common->gettblrowdata(['id' => $triplegsId], "order_id", 'tb_employee', 0, 0);
                $orderno         = $legorderdetails['order_id'];
                if ($orderno == '') {
                    $selectdata      = "CONCAT(`pickup_address1`,',',`pickup_address2`,',',`pickup_city`,',',`pickup_country`,',',`pickup_pincode`) AS pickupaddress,CONCAT(`delivery_address1`,',',`delivery_address2`,',',`delivery_city`,',',`delivery_country`,',',`delivery_pincode`) AS deliveryaddress,`plat`,`plng`,`dlat`,`dlng`";
                    $orderdetails    = $this->common->gettblrowdata(['id' => $OrderId], $selectdata, 'tb_orders', 0, 0);
                    $pickupaddress   = $orderdetails['pickupaddress'];
                    $deliveryaddress = $orderdetails['deliveryaddress'];
                    $plat            = $orderdetails['plat'];
                    $plng            = $orderdetails['plng'];
                    $dlat            = $orderdetails['dlat'];
                    $dlng            = $orderdetails['dlng'];

                    /**
                     * FIXME this is creating redundant data on the tb_employee
                     * table that already exists on the order.
                     */
                    $tripemparr1 = ['pickup' => $pickupaddress, 'plat' => $plat, 'plng' => $plng, 'drop' => $deliveryaddress, 'dlat' => $dlat, 'dlng' => $dlng, "order_id" => $OrderId];
                    $this->updatedata('tb_employee', $triplegsId, $tripemparr1);

                }

            }
            return true;

        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

/* End Trip legs */
    public function updateShiftId($orderId, $shiftId)
    {
        try {

            $sid         = $orderId;
            $userid      = $this->session->userdata('user_id');
            $curdt       = date('Y-m-d H:i:s');
            $stops_units = $this->db->query("SELECT oc.id,oc.length,oc.width,oc.height,oc.weight,oc.quantity,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND (oc.stop_detail_id is NULL OR oc.stop_detail_id=0) AND oc.status='1'");
            /* if($stops_units->num_rows()>1){
                echo $this->load->view("shipments/orderLines",array("lines"=>$stops_units),TRUE);
                exit;
            }*/

            $where  = ["id" => $orderId];
            $select = "*";
            $table  = "tb_orders";
            $order  = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                $shift_idchk = $order['shift_id'];
                if ($shift_idchk == 0) {
                    $associd = time();
                    $pickup  = $order['pickup_address1'];
                    if ($pickup == "") {$pickup = $order['pickup_city'];}
                    $delivery = $order['delivery_address1'];
                    if ($delivery == "") {$delivery = $order['delivery_city'];}
                    $address = $dropaddr = "";
                    if ($order['pickup_address1'] != "") {
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ($order['pickup_company'] != "") {
                        $address .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ($order['pickup_country'] != "") {
                        $address .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ($order['pickup_city'] != "") {
                        $address .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ($order['pickup_pincode'] != "") {
                        $address .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    $plat         = $order['plat'];
                    $plng         = $order['plng'];
                    $dlat         = $order['dlat'];
                    $dlng         = $order['dlng'];
                    $vendor_id    = $order['vendor_id'];
                    $vehicle_type = $order['vehicle_type'];
                    $where        = ["id" => $shiftId];
                    $select       = "id,splace,slat,slng,eplace,elat,elng,vendor_id,shipmentid,weight,volume,units,vehicle_type";
                    $table        = "tb_shifts";
                    $shipment     = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if ($vendor_id == 0) {
                        if (count($shipment) > 0) {
                            $vendor_id             = $shipment['vendor_id'];
                            $setwhr1['vendor_id']  = $vendor_id;
                            $setwhr1['shift_id']   = $shiftId;
                            $setwhr1['shipmentid'] = $shipment['shipmentid'];
                            if ($shipment['vehicle_type'] != "") {
                                $vehicle_type            = $shipment['vehicle_type'];
                                $setwhr1['vehicle_type'] = $vehicle_type;
                            }
                            $updwhr1 = ['id' => $orderId];
                            $ins     = $this->db->where($updwhr1)->update("tb_orders", $setwhr1);

                        }
                    } else {
                        $updwhr1             = ['id' => $orderId];
                        $setwhr1['shift_id'] = $shiftId;
                        if (count($shipment) > 0) {
                            $setwhr1['shipmentid'] = $shipment['shipmentid'];
                        }
                        $ins = $this->db->where($updwhr1)->update("tb_orders", $setwhr1);
                    }

                    /*update orders table*/
                    $updwhr = ['id' => $orderId];
                    $setwhr = ['status' => 2];
                    $ins    = $this->db->where($updwhr)->update("tb_orders", $setwhr);

                    /*insert stops records */
                    $where   = ["shipment_id" => $shiftId, "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr        = ['stopname' => $order['pickup_city'], 'plat' => $plat, 'plng' => $plng, 'stopcity' => $order['pickup_city'], 'address' => $address, 'stoptype' => 'P', 'stopstatus' => 0, 'shipment_id' => $shiftId, 'ordernumber' => 1, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['pickup_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                        $ins           = $this->db->insert("tb_shiporder_stops", $insarr);
                        $pickupstop_id = $this->db->insert_id();
                    } else {
                        $pickupstop_id     = $chkstop['id'];
                        $update_pickupstop = $this->db->where(["id" => $pickupstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                    }
                    $where   = ["shipment_id" => $shiftId, "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr      = ['stopname' => $order['delivery_city'], 'plat' => $dlat, 'plng' => $dlng, 'stopcity' => $order['delivery_city'], 'address' => $dropaddr, 'stoptype' => 'D', 'stopstatus' => 0, 'shipment_id' => $shiftId, 'ordernumber' => 2, 'startdate' => $order['delivery_datetime'], 'enddate' => $order['drop_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                        $ins         = $this->db->insert("tb_shiporder_stops", $insarr);
                        $dropstop_id = $this->db->insert_id();
                    } else {
                        $dropstop_id     = $chkstop['id'];
                        $update_dropstop = $this->db->where(["id" => $dropstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                    }

                    /*insert or update in tb_employee table*/
                    $whr_emp = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $shiftId];
                    $chkemp  = $this->common->gettblrowdata($whr_emp, "id", "tb_employee", 0, 0);
                    if (! empty($chkemp)) {
                        $detail_id  = $chkemp['id'];
                        $update_emp = $this->db->where(["id" => $detail_id])->update("tb_employee", ["status" => "1"]);
                    } else {
                        $insarr = ['assoc_id' => $associd, 'pickup' => $pickup, 'plat' => $plat, 'plng' => $plng, 'drop' => $delivery, 'dlat' => $dlat, 'dlng' => $dlng, 'pickup_city' => $order['pickup_city'], 'drop_city' => $order['delivery_city'], 'pickup_datetime' => $order['pickup_datetime'], 'drop_datetime' => $order['delivery_datetime'], 'name' => 'Boxes', 'phone' => $order['customer_phone'], 'address' => $address, 'emailid' => $order['customer_email'], 'user_id' => $userid, 'status' => 1, 'createdon' => $curdt, 'material_id' => 0, 'capacity' => $order['weight'], 'information' => $order['customer_comments'], 'shipment_weight' => $order['weight'], 'shipment_volume' => $order['volume'], 'ship_type' => 'P', 'customer_id' => $order['customer_id'], 'vendor_id' => $vendor_id, 'shipment_id' => 0, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['delivery_datetime'], 'shift_id' => $shiftId, 'stop_order' => 1, 'drop_order' => 0, 'basic_stop' => 0, 'stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'pkgitemid' => 'BOXES', 'no_of_pkgs' => $order['quantity'], 'domainname' => 'INFD'];

                        $ins       = $this->db->insert("tb_employee", $insarr);
                        $detail_id = $this->db->insert_id();
                    }

                    if ($detail_id > 0) {
                        if ($stops_units->num_rows() > 1) {
                            $odata = $stops_units->row();
                            $upd   = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                        }

                        /*check shipment pickup and drop*/
                        if (count($shipment) > 0) {
                            $updarr = [];
                            if ($shipment['splace'] == "") {
                                $updarr['splace'] = $order['pickup_city'];
                                $updarr['scity']  = $order['pickup_city'];
                            }
                            if ($shipment['eplace'] == "") {
                                $updarr['eplace'] = $order['delivery_city'];
                                $updarr['dcity']  = $order['delivery_city'];
                            }
                            if ($shipment['slat'] == "") {$updarr['slat'] = $plat;}
                            if ($shipment['slng'] == "") {$updarr['slng'] = $plng;}
                            if ($shipment['elat'] == "") {$updarr['elat'] = $dlat;}
                            if ($shipment['elng'] == "") {$updarr['elng'] = $dlng;}
                            $updarr['weight']      = ($shipment['weight'] + $order['weight']);
                            $updarr['volume']      = ($shipment['volume'] + $order['volume']);
                            $updarr['units']       = ($shipment['units'] + $order['quantity']);
                            $updarr['customer_id'] = $order['customer_id'];
                            $updarr['customer_id'] = $order['customer_id'];
                            $updarr['customer_id'] = $order['customer_id'];

                            if (! empty($updarr)) {
                                $setwhr = ['id' => $shiftId];
                                $ins    = $this->db->where($setwhr)->update("tb_shifts", $updarr);
                            }
                            $shipid = $shiftId;
                            $chk1   = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $shipid], 1, 0);
                            if ($chk1->num_rows() > 0) {
                                $shftvehid = $chk1->row()->id;
                                $chk       = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                                if ($chk->num_rows() == 0) {
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $shipid]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                    if ($chkemp->num_rows() == 0) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                        $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            }

                            /* update status */
                            $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $shipid, "status_id" => 9], 1, 0);
                            if ($chk->num_rows() == 0) {
                                $curtz     = $this->session->userdata("usr_tzone")['timezone'];
                                $logdate   = date('Y-m-d H:i:s');
                                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                                $curdt1    = $getactual['datetime'];
                                $ins       = ["shipment_id" => $shipid, "stop_id" => 0, "order_id" => $orderId, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                                $insqry    = $this->db->insert("tb_stop_status", $ins);
                            }
                        }
                    }

                }

            }

        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     *
     * @param type $orderId
     * @return type
     */
    public function getOrderDetailsById($orderId)
    {
        try {
            $result = [];

            $this->db->select('*');
            $this->db->from('tb_orders');
            $this->db->where('id', $orderId);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     *
     * @param type $details
     * @param type $shiftId
     * @return integer
     */
    public function insertShipOrderStops($details, $shiftId)
    {
        try {
            // Stop ID
            $result = $this->getStopId($details, 'P');
            if (count($result)) {
                $details['stop_id'] = $result['id'];
                $this->updateShipOrderStop($details['stop_id'], $shiftId);
            } else {
                $details['stop_id'] = $this->insertShipOrderPickupStop($details, $shiftId);
            }

            // Drop ID
            $result = $this->getStopId($details, 'D');
            if (count($result)) {
                $details['drop_id'] = $result['id'];
                $this->updateShipOrderStop($details['drop_id'], $shiftId);
            } else {
                $details['drop_id'] = $this->insertShipOrderDropStop($details, $shiftId);
            }

            // Check Employee Record
            $result = $this->checkEmployeeId($details['stop_id'], $details['drop_id']);
            if (count($result)) {
                $employee['employee_id'] = $result['id'];
                $this->updateEmployee($employee['employee_id'], $shiftId, $details['order_id']);
            } else {
                $this->insertEmployee($details, $shiftId);
            }
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateShipOrderStop($id, $shiftId)
    {
        try {
            $update['shipment_id'] = $shiftId;
            $update['status']      = 1;
            $update['updated_on']  = date('Y-m-d H:i:s');
            $this->db->where('id', $id);
            return $this->db->update('tb_shiporder_stops', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateEmployee($id, $shiftId, $order_id)
    {
        try {
            $update['shift_id']  = $shiftId;
            $update['order_id']  = $order_id;
            $update['status']    = 1;
            $update['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $id);
            return $this->db->update('tb_employee', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function checkEmployeeId($stop_id, $drop_id)
    {
        try {
            $result = [];

            $this->db->select('id');
            $this->db->from('tb_employee');
            $this->db->where('stop_id', $stop_id);
            $this->db->where('drop_stopid', $drop_id);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getEmployeeDetails($order_id)
    {
        try {
            $result = [];

            $this->db->select('*');
            $this->db->from('tb_employee');
            $this->db->where('order_id', $order_id);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateOrder($orderId, $shiftId)
    {
        try {
            // Get Order Details
            $order = $this->getOrderDetailsById($orderId);

            // Get Employee Details
            $employee = $this->getEmployeeDetails($order['order_id']);

            // Update Employee
            $eupdate['status']    = 0;
            $eupdate['shift_id']  = 0;
            $eupdate['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $employee['id']);
            $this->db->update('tb_employee', $eupdate);

            // Update Ship Order Stops
            $supdate['status']      = 0;
            $supdate['shipment_id'] = 0;
            $supdate['updated_on']  = date('Y-m-d H:i:s');
            $this->db->where_in('id', [$employee['stop_id'], $employee['drop_stopid']]);
            $this->db->update('tb_shiporder_stops', $supdate);

            // Update Order
            $oupdate['shift_id']  = 0;
            $oupdate['trip_id']   = 0;
            $oupdate['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $orderId);
            return $this->db->update('tb_orders', $oupdate);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getStopId($details, $stoptype)
    {
        try {
            $result = [];

            $this->db->select('id');
            $this->db->from('tb_shiporder_stops');
            $this->db->where('stoptype', $stoptype);
            $this->db->where('plat', $details['plat']);
            $this->db->where('plng', $details['plng']);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertShipOrderPickupStop($details, $shiftId)
    {
        try {
            $insert['plat']           = $details['plat'];
            $insert['plng']           = $details['plng'];
            $insert['address']        = $details['pickup_address1'] . ', ' . $details['pickup_company'] . ', ' . $details['pickup_country'] . ', ' . $details['pickup_pincode'];
            $insert['stoptype']       = 'P';
            $insert['stopstatus']     = 0;
            $insert['shipment_id']    = $shiftId;
            $insert['ordernumber']    = 1;
            $insert['startdate']      = $details['pickup_datetime'];
            $insert['enddate']        = $details['pickup_endtime'];
            $insert['weight']         = $details['weight'];
            $insert['volume']         = $details['volume'];
            $insert['shipmentstopid'] = 0;
            $insert['ship_units']     = $details['quantity'];
            $insert['txncode']        = 'NP';
            $insert['status']         = 1;
            $insert['created_on']     = date('Y-m-d H:i:s');
            $insert['updated_on']     = date('Y-m-d H:i:s');

            $this->db->insert('tb_shiporder_stops', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertShipOrderDropStop($details, $shiftId)
    {
        try {
            $insert['stopname']       = $details['delivery_city'];
            $insert['plat']           = $details['plat'];
            $insert['plng']           = $details['plng'];
            $insert['stopcity']       = $details['delivery_city'];
            $insert['address']        = $details['delivery_address1'] . ', ' . $details['delivery_company'] . ', ' . $details['delivery_country'] . ', ' . $details['delivery_pincode'];
            $insert['stoptype']       = 'D';
            $insert['stopstatus']     = 0;
            $insert['shipment_id']    = $shiftId;
            $insert['ordernumber']    = 2;
            $insert['startdate']      = $details['delivery_datetime'];
            $insert['enddate']        = $details['drop_endtime'];
            $insert['weight']         = $details['weight'];
            $insert['volume']         = $details['volume'];
            $insert['shipmentstopid'] = 0;
            $insert['ship_units']     = $details['quantity'];
            $insert['txncode']        = 'NP';
            $insert['status']         = 1;
            $insert['created_on']     = date('Y-m-d H:i:s');
            $insert['updated_on']     = date('Y-m-d H:i:s');

            $this->db->insert('tb_shiporder_stops', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertEmployee($details, $shiftId)
    {
        try {
            $insert['pickup']          = getLocationName($details['plat'], $details['plng']);
            $insert['plat']            = $details['plat'];
            $insert['plat']            = $details['plng'];
            $insert['drop']            = getLocationName($details['dlat'], $details['dlng']);
            $insert['dlat']            = $details['dlat'];
            $insert['dlng']            = $details['dlng'];
            $insert['pickup_city']     = $details['pickup_city'];
            $insert['drop_city']       = $details['delivery_city'];
            $insert['pickup_datetime'] = $details['pickup_datetime'];
            $insert['drop_datetime']   = $details['delivery_datetime'];
            $insert['address']         = $details['pickup_address1'] . ', ' . $details['pickup_company'] . ', ' . $details['pickup_country'] . ', ' . $details['pickup_pincode'];
            $insert['user_id']         = $this->session->userdata('user_id');
            $insert['status']          = 1;
            $insert['createdon']       = date('Y-m-d H:i:s');
            $insert['updatedon']       = date('Y-m-d H:i:s');
            $insert['material_id']     = 0;
            $insert['capacity']        = $details['quantity'];
            $insert['shipment_weight'] = $details['weight'];
            $insert['shipment_volume'] = $details['volume'];
            $insert['ship_type']       = 'P';
            $insert['customer_id']     = $details['customer_id'];
            $insert['vendor_id']       = $details['vendor_id'];
            $insert['shipment_id']     = 0;
            $insert['startdate']       = $details['pickup_datetime'];
            $insert['enddate']         = $details['delivery_datetime'];
            $insert['shift_id']        = $shiftId;
            $insert['stop_order']      = 1;
            $insert['drop_order']      = 0;
            $insert['basic_stop']      = 0;
            $insert['stop_id']         = $details['stop_id'];
            $insert['drop_stopid']     = $details['drop_id'];
            $insert['order_id']        = $details['order_id'];

            $this->db->insert('tb_employee', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches Shift Order Documents
     * @param int $userId
     * @param int $shiftId
     * @return array
     */
    public function getShiftOrderDocs($userId, $shiftId)
    {
        try {
            $result   = [];
            $orderIds = $this->getShiftOrders($shiftId);
            $curtz    = $this->session->userdata("usr_tzone")['timezone'];
            if ($orderIds > 0) {
                $query = $this->db->query("SELECT p.shipment_id, p.stop_id, p.latitude, p.longitude, d.type_name, p.imgpath, p.pdfpath,
							td.name, s.stopname, convertToClientTZ(ts.createdon,'" . $curtz . "') as p.createdon
							FROM tb_pod_uploads p
							JOIN tb_document_types d ON d.id = p.doc_type
							JOIN tb_truck_drivers td ON p.createdby = td.id
							JOIN tb_shiporder_stops s ON s.id = p.stop_id
							WHERE p.user_id = " . $userId . "
							AND p.shipment_id = " . $shiftId . "
							AND p.order_id IN (" . implode(',', $orderIds) . ")");
                return $query->result_array();
            } else {
                return 0;
            }
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * This method fetches Shift Orders
     * @param int $userId
     * @param int $shiftId
     * @return array
     */
    public function getOrdersByShiftId($shiftId)
    {
        try {
            $result = [];

            $this->db->select('*');
            $this->db->from('tb_orders');
            // $this->db->where('user_id', $userId);
            $this->db->where('shift_id', $shiftId);
            $query = $this->db->get();

            if ($query->num_rows()) {
                foreach ($query->result_array() as $value) {
                    $result[] = $value['id'];
                }
            }

            return $result;
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }
    
    public function getOrdersDetailsByShiftId($shiftId)
    {
        try {
            $result = [];

            $this->db->select('*');
            $this->db->from('tb_orders');
            // $this->db->where('user_id', $userId);
            $this->db->where('shift_id', $shiftId);
            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->result_array();
                return $result;
            } else {
                return [];
            }
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * This method fetches rate service id,name,service id
     * @param int $shiftId
     * @return array
     */
    public function getRateService($shiftId)
    {
        try {

            $getServiceqry = $this->db->query("SELECT trs.`service_id`,trs.`service_name`,trs.`id` FROM `tb_shifts` ts LEFT JOIN tb_vendors tv ON tv.id=ts.`vendor_id` LEFT JOIN tb_rate_offerings tro ON tro.offering_type= tv.offering_type LEFT JOIN tb_rate_services trs ON trs.id=tro.rate_service_id WHERE ts.`id`='$shiftId' GROUP BY trs.id  ORDER BY trs.`service_id` ASC");
            return $getServiceqry->result_array();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * This method fetches  costs and units data from the revuneue table
     * @param int where conditon elements.
     * @return array
     */
    public function getratesbytrips($whr)
    {
        try {
            $this->db->select("trev.*");
            $this->db->from("tb_reveneus trev");
            $this->db->join('tb_orders tor', 'trev.order_id=tor.id', 'LEFT');
            $this->db->join('tb_shifts ts', 'ts.id=tor.shift_id', 'LEFT');
            $this->db->join('tb_vendors tv', 'tv.id=ts.vendor_id', 'LEFT');
            $this->db->join('tb_rate_offerings tro', 'tro.offering_type= tv.offering_type', 'LEFT');
            $this->db->join('tb_rate_services trs', 'trs.id=tro.rate_service_id', 'LEFT');
            $this->db->join('tb_rate_records trr', 'trr.offering_id=tro.offering_id', 'LEFT');
            $this->db->where($whr);
            $this->db->group_by('trev.order_id');
            $query = $this->db->get();
            return $query->result();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * This method fetches the data from the orders values
     * @param int where conditon elements.
     * @return array
     */
    public function getorderdetails($where, $select, $table, $limit, $start)
    {
        try {
            $this->db->select($select);
            $this->db->from($table . " tor");
            $this->db->join('tb_order_details tod', 'tod.order_row_id=tor.id', 'LEFT');
            $this->db->join('tb_order_references torf', 'torf.order_id=tor.id', 'LEFT');
            $this->db->where($where);
            $this->db->group_by('tor.order_id');
            $query = $this->db->get();
            return $query->result();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

    }
    /**
     * This method fetches the data from the orders values
     * @param int where conditon elements.
     * @return array
     */
    public function getVehicleTypedta(int $carrierid): array
    {
        $this->db->select("ttd.`id` as vehicle_id,ttd.register_number AS truck_number,ttd.truck_type,ttt.trucktype,ttrr.id AS driverid,ttrr.name AS drivername");
        $this->db->from('tb_trucks_data ttd');
        $this->db->join('tb_trucktypes ttt', 'ttt.id=ttd.truck_type', 'LEFT');
        $this->db->join('tb_vehicles_drivers tvd', '`ttd`.`id`=`tvd`.`vehicle_id`', 'LEFT');
        $this->db->join('tb_truck_drivers ttrr', '`tvd`.`driver_id`=`ttrr`.`id`', 'LEFT');
        $this->db->where('ttd.vendor_id', $carrierid);
        $this->db->where("ttd.status='Active' AND ttrr.status='Active' AND tvd.status ='1'");
        $this->db->group_by('ttd.id');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result() : [];
    }

    /**
     * Determine if a given trip/shipment is as multi-leg shipment (also
     * referred to as X-Dock)
     *
     * @param integer $id
     * @param boolean $active_only
     * @return int
     */
    public function is_multi_leg_trip(int $id, bool $active_only = true)
    {
        $where = ["shift_leg_id" => $id];
        if ($active_only) {$where['status'] = 1;}

        $this->db->where($where);
        $this->db->from(self::TABLE);
        return $this->db->count_all_results();
    }

    /**
     * If the given id is for the parent shift a multi leg trip, get the ID's of
     * the legs/shifts that reference the parent.
     *
     * @param integer $id
     * @param boolean $active_only
     * @return CI_DB_result
     */
    public function get_multi_leg_trip_ids(int $id, bool $active_only = true)
    {
        if (! $this->is_multi_leg_trip($id, $active_only)) {
            return null;
        }

        $where = ["shift_leg_id" => $id];
        if ($active_only) {$where['status'] = 1;}

        $this->db->select("id, shipmentid, shipment_id");
        $this->db->from(self::TABLE);
        $this->db->where($where);
        return $this->db->get();
    }

    /**
     * Given a DB ID, get the public facing shipmentid.
     *
     * @param integer $id
     * @param boolean $active_only
     * @return string
     */
    public function get_shipmentid_from_id(int $id, bool $active_only = true)
    {
        $where = ["id" => $id];
        if ($active_only) {$where['status'] = 1;}

        $this->db->select("shipmentid");
        $this->db->from(self::TABLE);
        $this->db->where($where);
        $this->db->limit(1);

        $query = $this->db->get();
        if (! $query->num_rows()) {
            throw new Exception('shift not found for id ' . $id);
        }

        return $query->result()[0]->shipmentid;
    }

    /**
     * Given the public facing shipmentid, get the row id.
     *
     * @param string $shipmentid
     * @param boolean $active_only
     * @return int
     */
    public function get_id_from_shipmentid(string $shipmentid,
        bool $active_only = true) {
        $this->db->reset_query();
        $where = ["shipmentid" => $shipmentid];
        if ($active_only) {$where['status'] = 1;}

        $this->db->select("id");
        $this->db->from(self::TABLE);
        $this->db->where($where);
        $this->db->order_by("id", "DESC");
        $this->db->limit(1);
        $query = $this->db->get();

        if (! $query->num_rows()) {
            throw new Exception('shift not found for shipmentid ' . $shipmentid);
        }

        return $query->result()[0]->id;
    }

    /**
     * Check that order and stops are linked correctly to shift. Will throw if
     * not.
     *
     * Check that there is a stop matching the order to the shift.
     * Check that there is an employee row matching the order to the shift.
     *
     * @param integer $id column `id` on tb_shifts
     * @param string $order_id the customer facing order id
     * @param integer $order_row_id id of the row in tb_orders
     * @param boolean $active_only
     * @return boolean
     */
    public function is_order_on_shift(int $id,
        string $order_id,
        int $order_row_id,
        bool $active_only = true) {
        $stop_ids = $this->stop_detail->get_stop_ids_for_order_on_shift(
            $order_id,
            $id,
            $active_only
        );

        foreach ($stop_ids as $stop_id) {
            if ($stop_id) {
                // if we find even a single valid stop id, it means our tb_employee query was a success
                return true;
            }
        }

        return false;
    }

    public function getAllVendorBasedCrossBorderShiftIds(string $userWhereCondition): array
    {
        $shiftIds     = [];
        $getShiftLegs = $this->db->query("SELECT id from tb_shifts WHERE shift_leg_id >0 AND status = 1 AND " . $userWhereCondition);
        if ($getShiftLegs->num_rows() > 0) {
            foreach ($getShiftLegs->result_array() as $eachLine) {
                $shiftIds[] = $eachLine['id'];
            }
        }
        return $shiftIds;
    }

    public function getAllAdminBasedCrossBorderShiftIds(string $companyCode, string $searchWhere = ''): array
    {
        $shiftIds = [];
        if ($companyCode != "") {
            $getCrossBorderShiftLegIds = $this->db->query("SELECT id from tb_shifts WHERE origin_id IS NOT NULL AND destination_id IS NOT NULL AND status =? AND company_code =? AND shift_leg_id = ?", ['1', $companyCode, '0']);
            if ($getCrossBorderShiftLegIds->num_rows() > 0) {
                foreach ($getCrossBorderShiftLegIds->result_array() as $eachShift) {
                    $shiftLegIds[] = $eachShift['id'];
                }
            }
            if (! empty($shiftLegIds)) {
                $getCountryShiftIds = $this->db->query("SELECT id from tb_shifts WHERE shift_leg_id IN ? AND status = ? " . $searchWhere . " GROUP BY shipmentid", [$shiftLegIds, '1']);
                if ($getCountryShiftIds->num_rows() > 0) {
                    foreach ($getCountryShiftIds->result_array() as $eachLine) {
                        $shiftIds[] = $eachLine['id'];
                    }
                }
                $getOtherCountryShiftLegs = $this->db->query("SELECT id from tb_shifts WHERE shift_leg_id NOT IN ? AND shift_leg_id > ? " . $searchWhere . " AND status = ? AND company_code =? GROUP BY shipmentid", [$shiftLegIds, '0', '1', $companyCode]);
                if ($getOtherCountryShiftLegs->num_rows() > 0) {
                    foreach ($getOtherCountryShiftLegs->result_array() as $eachLine) {
                        $shiftIds[] = $eachLine['id'];
                    }
                }
            } else {
                $getOtherCountryShiftLegs = $this->db->query("SELECT id from tb_shifts WHERE shift_leg_id > ? AND status = ? " . $searchWhere . " AND company_code =? GROUP BY shipmentid", ['0', '1', $companyCode]);
                if ($getOtherCountryShiftLegs->num_rows() > 0) {
                    foreach ($getOtherCountryShiftLegs->result_array() as $eachLine) {
                        $shiftIds[] = $eachLine['id'];
                    }
                }
            }

        }
        return $shiftIds;
    }

    public function checkCbTripsWithVehicleDriver(array $allCrossCorderShiftids, string $searchWhereCondition): array
    {
        $result = [];
        $this->db->select(
            "s.id,s.shift_leg_id,s.shipmentid,e.id as employee_id,o.id as orderrowid,o.order_id,o.trip_id,v.vehicle_id,a.driver_id,a.imei,
                           d.contact_num,d.track_type,d.track_vendor,d.sim_carrier"
        );
        $this->db->from("tb_shifts s");
        $this->db->join('tb_vendors c', 'c.id=s.vendor_id', 'INNER');
        $this->db->join('tb_employee e', 'e.shift_id=s.id', 'INNER');
        $this->db->join('tb_orders o', 'o.order_id=e.order_id', 'INNER');
        $this->db->join('tb_shft_veh v', 's.id=v.shft_id', 'INNER');
        $this->db->join('tbl_assigned_drivers a', 'v.vehicle_id=a.vehicle_id', 'INNER');
        $this->db->join('tb_truck_drivers d', 'd.id=a.driver_id AND a.status =1', 'INNER');
        $this->db->where_in('e.shift_id', $allCrossCorderShiftids);
        if ($searchWhereCondition != "") {
            $this->db->where($searchWhereCondition);
        }
        $this->db->group_by('e.id');
        $this->db->order_by('s.id', 'ASC');
        $getCrossBorderTrips = $this->db->get();
        if ($getCrossBorderTrips->num_rows() > 0) {
            $result = $getCrossBorderTrips->result_array();
        }
        return $result;
    }

    public function getTripsBasedOnId(array $shiftIds, int $start, int $limit): array
    {
        $result = [];
        if (! empty($shiftIds)) {
            $this->db->select("s.id,e.id as employee_id");
            $this->db->from("tb_shifts s");
            $this->db->join('tb_employee e', 'e.shift_id=s.id', 'INNER');
            $this->db->where_in('s.id', $shiftIds);
            $this->db->group_by('e.id');
            $this->db->order_by('s.id', 'DESC');
            $this->db->limit($start, $limit);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                $result = $query->result_array();
            }
        }
        return $result;
    }

    public function getReferencesForOrders(array $orderIds, array $codes): array
    {
        $references = [];
        $sql        = $this->db->query(
            "select  order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
                SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                         FROM tb_order_references ar where
                         reference_id IN ? and status= ? and order_id in ?
                         group by order_id,reference_id
                 ) AS final_ref group by order_id ", [$codes, '1', $orderIds]);
        if ($sql->num_rows() > 0) {
            foreach ($sql->result_array() as $eachLine) {
                $references[$eachLine['order_id']] = ['order_id' => $eachLine['order_id'], 'referenceValue' => $eachLine['reference_value']];
            }
        }
        return $references;
    }

    public function getPodForCrossBorderTrips(string $currentTimeZone, int $orderRowId)
    {
        $sql = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath from tb_pod_uploads ts
                    LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type
                    WHERE ts.order_id = ? AND ts.status = ?
                    GROUP BY ts.id", [$currentTimeZone, $orderRowId, 1]);
        return $sql;
    }

    public function loadAllTripsDataByUser(string $where, $timeZone = ''): array
    {
        $queryResult = [];
        if ($timeZone != "") {
            $dates = "convertToClientTZ(s.startdate, '" . $timeZone . "') as startdate,convertToClientTZ(s.enddate, '" . $timeZone . "') as enddate,";
        } else {
            $dates = "s.startdate,s.enddate";
        }
        $this->db->select('s.id,s.splace,s.eplace,' . $dates . ',s.shipmentid,s.transport_mode,s.weight,s.volume,s.units,s.vehicle_type,v.name as vendor_name,d.name as driver_name,t.register_number');
        $this->db->from("tb_shifts s");
        $this->db->join('tb_shft_veh sv', 's.id=sv.shft_id', 'LEFT');
        $this->db->join('tb_vendors v', 's.vendor_id=v.id', 'INNER');
        $this->db->join('tbl_assigned_drivers a', 'sv.vehicle_id=a.vehicle_id AND a.status =1', 'LEFT');
        $this->db->join('tb_truck_drivers d', 'd.id=a.driver_id AND a.status =1', 'LEFT');
        $this->db->join('tb_trucks_data t', 't.id=a.vehicle_id AND a.status=1', 'LEFT');
        $this->db->where($where);
        $this->db->group_by('s.shipmentid');
        $this->db->order_by('s.id', 'DESC');
        $query = $this->db->get();
        if ($query && $query->num_rows() > 0) {
            $queryResult = $query->result_array();
        }
        return $queryResult;
    }

    public function getVehicleDataFromCarriers(array $carrierIds): array
    {
        $truckTypes = $trucksData = $truckDrivers = [];
        $this->db->select("td.id as vehicle_id,td.truck_type,td.register_number as truck_number,td.vendor_id,tt.trucktype,d.id as driverid,d.name as drivername");
        $this->db->from('tb_trucks_data td');
        $this->db->join('tb_trucktypes tt', 'tt.id=td.truck_type', 'LEFT');
        $this->db->join('tb_vehicles_drivers vd', 'td.id=vd.vehicle_id', 'LEFT');
        $this->db->join('tb_truck_drivers d', 'vd.driver_id=d.id', 'LEFT');
        $this->db->where_in('td.vendor_id', $carrierIds);
        $this->db->where("td.status='Active' AND d.status='Active' AND vd.status ='1'");
        $this->db->group_by('td.id');
        $query = $this->db->get();
        foreach ($query->result_array() as $eachRow) {
            $truckTypes[$eachRow['vendor_id']][]    = ['id' => $eachRow['truck_type'], 'truckType' => $eachRow['trucktype']];
            $trucksData[$eachRow['truck_type']][]   = ['id' => $eachRow['vehicle_id'], 'truck_number' => $eachRow['truck_number']];
            $truckDrivers[$eachRow['vehicle_id']][] = ['id' => $eachRow['driverid'], 'name' => $eachRow['drivername']];
        }
        $data = ['truckTypes' => $truckTypes, 'trucksData' => $trucksData, 'truckDrivers' => $truckDrivers];
        return $data;
    }

    public function checkLegsForMainShipment(int $shiftId): array
    {
        $query = $this->db->query("SELECT id FROM tb_shifts WHERE shift_leg_id = ? LIMIT 1", [$shiftId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getOrderPickupDropDetails(array $data): array
    {
        if (checkAccessConditions('RELATED_2_SG_MY', $data['companyCode'])) {
            $pickupType = "Pickup";
            $dropType   = "Delivery";
        } else {
            $pickupType = "Shipper";
            $dropType   = "Consignee";
        }
        $query       = $this->db->query("SELECT o.party_id,t.name FROM tb_order_parties o,tbl_party_types t WHERE o.order_id IN ? AND o.party_type = t.id AND t.name IN ? AND o.status = ?", [[$data['pickup'], $data['drop']], [$pickupType, $dropType], 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if (empty($queryResult)) {
            return [];
        }
        $pickupId = $dropId = 0;
        foreach ($queryResult as $eachLine) {
            $partyType = $eachLine['name'];
            if (strtolower($partyType) === strtolower($pickupType)) {
                $pickupId = $eachLine['party_id'];
            } else {
                $dropId = $eachLine['party_id'];
            }
        }
        if ($pickupId === 0 && $dropId === 0) {
            return [];
        }
        $getCodesQuery = $this->db->query("SELECT id,code,country,pincode,state,user_id FROM tbl_party_master where id IN ?", [[$pickupId, $dropId]]);
        $getcodes      = $getCodesQuery->num_rows() > 0 ? $getCodesQuery->result_array() : [];
        if (empty($getcodes)) {
            return [];
        }
        foreach ($getcodes as $eachLine) {
            if ($eachLine['id'] === $pickupId) {
                $data['origin_id']      = $eachLine['code'];
                $data['origin_row_id']  = $eachLine['id'];
                $data['origin_country'] = $eachLine['country'];
                $data['origin_state']   = $eachLine['state'];
                $data['origin_pincode'] = $eachLine['pincode'];
                $data['origin_user_id'] = $eachLine['user_id'];
            } else {
                $data['destination_id']      = $eachLine['code'];
                $data['destination_row_id']  = $eachLine['id'];
                $data['destination_country'] = $eachLine['country'];
                $data['destination_state']   = $eachLine['state'];
                $data['destination_pincode'] = $eachLine['pincode'];
                $data['destination_user_id'] = $eachLine['user_id'];
            }
        }
        return $data ?? [];
    }

    public function deallocateOrderFromMultiLegs(int $orderId, array $shiftIds): void
    {
        $checkShifts = $this->db->query("SELECT e.id FROM tb_employee e,tb_orders o WHERE e.order_id = o.order_id AND o.id = ? AND e.shift_id IN ? AND e.status =?", [$orderId, $shiftIds, 1]);
        $shiftIds    = $checkShifts->num_rows() > 0 ? $checkShifts->result_array() : [];
        $employeeIds = [];
        foreach ($shiftIds as $eachId) {
            $employeeIds[] = $eachId['id'];
        }
        if (! empty($employeeIds)) {
            $this->load->model('common');
            $updateEmployeeTable = $this->common->updatetbledata_where_in('tb_employee', ['status' => 0], ['col' => 'id', 'arr' => $employeeIds], []);
        }
    }

    public function getOrderLegsByOrderRowId(int $rowId): array
    {
        $query = $this->db->query("SELECT e.shift_id FROM tb_employee e,tb_orders o WHERE e.order_id= o.order_id AND o.id = ? AND e.status = ? ", [$rowId, '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsForKNOps(array $data, int $shiftId = 0): array
    {
        if ($shiftId > 0) {
            $query = $this->db->query("SELECT o.id,o.order_id,o.pickup_company,o.delivery_company,o.quantity,o.weight,o.volume,o.transport_mode,o.company_code,o.branch_code,o.shift_id,o.trip_id,d.department_code FROM tb_orders o LEFT JOIN tb_order_details d on d.order_row_id = o.id WHERE o.shift_id = ? AND o.status > ? AND d.status > ?", [$shiftId, 0, 0]);
        } else {
            $query = $this->db->query("SELECT o.id,o.order_id,o.pickup_company,o.delivery_company,o.quantity,o.weight,o.volume,o.transport_mode,d.department_code FROM tb_orders o LEFT JOIN tb_order_details d on d.order_row_id = o.id WHERE o.company_code = ? AND o.branch_code = ? AND o.status > ? AND d.department_code = ? AND d.status > ?", [$data['companyCode'], $data['branchCode'], 0, $data['departmentCode'], 0]);
        }
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
}
