<?php defined('BASEPATH') or exit('No direct script access allowed');
class Truckwaybillmodel extends CI_Model
{

	public function getvehicledetails($ordernum)
	{
		$departuredate = '';
		$getsupdetails = $this->db->query("select tps.createdon,tps.driver_id, te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = 11 AND
	ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
		if ($getsupdetails->num_rows() > 0) {
			$departuredate = $getsupdetails->row()->createdon;
		}
		return $departuredate;
	}
	public function orderrefernce($tracnum)
	{
		$result = array();
		$getrefer = $this->db->query("SELECT r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE o.id='" . $tracnum . "' AND r.order_id=o.id AND r.status=1  AND reference_id in('DQ','PO') GROUP BY r.id");
		if ($getrefer->num_rows() > 0) {
			$result = $getrefer->result_array();
		}
		return $result;
	}

	public function notify_party($orderid)
	{
		//$orderid='50001922272';
		$getrefer = $this->db->query("select m.name,m.location_id,m.address,m.country,m.state,m.street,m.pincode from `tbl_party_master` m,`tbl_party_types` t, `tb_order_parties` o where o.order_id= '" . $orderid . "' and o.party_id = m.id and m.party_type_id = t.id and t.name = 'NOTIFY_PARTY' and m.status=1 order by m.id desc");
		return $getrefer;
	}
	public function branch_info($branchcode)
	{

		$getbrachinfo = $this->db->query("select * from `tb_branch_details` where status =1 and branch_code= '" . $branchcode . "'");
		return $getbrachinfo;
	}
	public function driverinfo($trip_id)
	{
		$getbrachinfo = $this->db->query("SELECT d.id,d.name,d.contact_num,d.driving_licence_num from tb_trips td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.id =" . $trip_id . " AND td.status ='1' GROUP BY d.id ORDER BY td.created_on desc");
		return $getbrachinfo;
	}
	public function shiftdriverinfo($shift_id)
	{
		$driver_name = '';
		$trip = $this->db->query("SELECT id,start_imei from tb_trips where shift_id = '$shift_id'   ORDER BY ID DESC");
		if ($trip->num_rows() > 0) {
			$trip_id = $trip->row()->id;
			$getbrachinfo = $this->db->query("SELECT d.id,d.name,d.contact_num from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id=" . $trip_id . " AND td.status='1' GROUP BY d.id ORDER BY td.createdon desc");
			if ($getbrachinfo->num_rows() > 0) {
				$driver_name = $getbrachinfo->row()->name;
			}
		}
		return $driver_name;
	}
	public function vehicelinfo($shift_id)
	{
		$result = array();
		$result['truck_number'] = $result['register_number'] = $result['trucktype'] = "";
		$mastvehicelinfo = $this->db->query("SELECT vehicle_id from tb_trips where shift_id='" . $shift_id . "' order by id desc");

		if ($mastvehicelinfo->num_rows() > 0) {
			$vehicleid = $mastvehicelinfo->row()->vehicle_id;
			if ($vehicleid > 0) {
				$vehicelinfo = $this->db->query("SELECT v.truck_number,v.register_number,t.trucktype from tb_trucks_data v, tb_trucktypes t where t.id=v.truck_type AND v.id='" . $vehicleid . "' order by v.id desc");
				if ($vehicelinfo->num_rows() > 0) {
					$result['register_number'] = $vehicelinfo->row()->register_number;
					$result['truck_number'] = $vehicelinfo->row()->truck_number;
					$result['trucktype'] = $vehicelinfo->row()->trucktype;
				}
			}
		}
		return $result;
	}
	public function getdeptdetails($ordernum)
	{
		$getdeptdetails = $this->db->query("select tps.createdon, te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = 11 AND
        ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
		return $getdeptdetails;
	}
	public function getshipper($ord_row_id, $type)
	{
		$result = array();
		$shipper_info = $this->db->query("select pm.order_id,pm.party_master_id,pm.location_id,pm.street,pm.address,pm.pincode,pm.country,pm.state from `tbl_party_types` pt,`tb_order_parties` po, `tbl_orderparty_address` pm where po.party_type=pt.id and pt.name='" . $type . "' and po.order_id='" . $ord_row_id . "' and pm.order_id ='" . $ord_row_id . "' and po.party_id=pm.party_master_id");
		if ($shipper_info->num_rows() > 0) {
			$result = $shipper_info->row_array();
			$party_master_id = $shipper_info->row()->party_master_id;
			$getname = $this->db->query("select name,email,mobile from tbl_party_master where id ='$party_master_id'");
			if ($getname->num_rows() > 0) {
				$result['name'] = $getname->row()->name;
				$result['email'] = $getname->row()->email;
				$result['mobile'] = $getname->row()->mobile;
			}
		} else {
			$shipper_info = $this->db->query("select pm.id as party_master_id, pm.name,pm.email,pm.mobile,pm.location_id,pm.address,pm.street,pm.pincode,po.order_id,pm.state from `tbl_party_types` pt,`tb_order_parties` po, `tbl_party_master` pm where po.party_type=pt.id and pt.name='" . $type . "' and po.order_id='" . $ord_row_id . "' and po.party_id=pm.id");
			if ($shipper_info->num_rows() > 0) {
				$result = $shipper_info->row_array();
			}
		}
		return $result;
	}
	function getcharges($order_ids)
	{
		$result = array();
		$this->db->select("r.id,r.recipient_code,r.debtor_jfr,r.amount as rev_amount,r.currency as rev_currency,r.invoice_status,c.amount as charge_amount,c.currency as charge_currency,c.local_amount,c.local_currency");
		$this->db->from('tb_reveneus r', 'tb_charges c', 'tb_charge_codes cc');
		$this->db->join("tb_charges c", "r.id=c.revenue_id", "LEFT");
		$this->db->join("tb_charge_codes cc", "c.charge_code=cc.id", "LEFT");
		/* $this->db->where("r.invoice_status", 1); */
		$this->db->where("r.type", 1);
		$this->db->where_in("r.order_id", $order_ids);
		$this->db->where("r.status", 1);
		$this->db->where("c.status", 1);
		$this->db->group_by("r.id");
		$revenues = $this->db->get();
		if ($revenues->num_rows() > 0) {
			$result = $revenues->result_array();
		}
		return $result;
	}
	function getchargesbyrevid($revenueid)
	{
		$result = array();
		$this->db->select("c.*,cc.charge_code as chargecode,cc.name as chargecodename");
		$this->db->from("tb_charges c");
		$this->db->join("tb_charge_codes cc", "c.charge_code=cc.id", "LEFT");
		$this->db->where("c.revenue_id", $revenueid);
		$this->db->where("c.status", 1);
		$getcharges = $this->db->get();
		if ($getcharges->num_rows() > 0) {
			$result = $getcharges->result_array();
		}
		return $result;
	}

	function getcustomerdetails($customer_id)
	{
		$result = array();
		$this->db->select("p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.customeridentifier,p.fax,p.location_id,p.country,p.state,p.street,p.pincode,p.house_number,p.acon_debitor_code,p.kn_login_account,p.vat_reg_no,p.tax_payer_no,p.contract_no,p.contract_date");
		$this->db->from("tbl_party_master p");
		$this->db->join("tb_customers c", "p.id=c.partner_id", "INNER");
		$this->db->where("c.id", $customer_id);
		$this->db->where("p.status", 1);
		$this->db->where("c.status", 1);
		$this->db->limit(1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->row_array();
		}
		return $result;
	}
	function getpartydetails($order_id)
	{
		$result = array();
		$this->db->select("p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.customeridentifier,p.house_number,p.fax,p.acon_debitor_code,p.kn_login_account,p.vat_reg_no,p.tax_payer_no,p.contract_no,p.contract_date,o.party_type");
		$this->db->from("tbl_party_master p");
		$this->db->join("tb_order_parties o", "p.id=o.party_id", "INNER");
		$this->db->where("o.order_id", $order_id);
		$this->db->where("p.status", 1);
		$this->db->where("o.status", 1);
		$this->db->group_by('o.party_type');
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getvasdetails($orderid)
	{
		$result = array();
		$this->db->select("vm.vas_id,vm.vas_name,v.quantity");
		$this->db->from("tb_order_vas v");
		$this->db->join("tb_orders o", "v.order_id=o.id", "LEFT");
		$this->db->join("tb_vas_master vm", "v.vas_id=vm.id", "LEFT");
		$this->db->where("v.order_id", $orderid);
		$this->db->where("v.status", 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getorderreferences($orderid)
	{
		$result = array();
		$this->db->select("o.reference_id ,r.description,o.ref_value");
		$this->db->from("tb_order_references o");
		$this->db->join("tb_reference_master r", "o.reference_id=r.name", "LEFT");
		$this->db->where("o.order_id", $orderid);
		$this->db->where("o.status", 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getpicanddeldates($order_num)
	{
		$result = array();
		$this->db->select("tps.stop_type,tps.createdon");
		$this->db->from("tb_stop_status tps");
		$this->db->join("tb_shifts ts", "tps.shipment_id=ts.id", "LEFT");
		$this->db->join("tb_employee te", "ts.id=te.shift_id", "LEFT");
		$this->db->where_in("tps.stop_type", ['P', 'D']);
		$this->db->where_in("tps.status_code", ['0500', '3000']);
		$this->db->where("te.order_id", $order_num);
		$this->db->where("tps.status", 1);
		$this->db->where("te.status", 1);
		$this->db->where("ts.status", 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getcargodetails($order_id)
	{
		$result = array();
		$this->db->select('cd.*');
		$this->db->from("tb_cargo_details cd");
		$this->db->join('tb_order_cargodetails ocd', 'cd.id= ocd.cargo_id', 'LEFT');
		$this->db->where('ocd.order_id', $order_id);
		$this->db->where('ocd.status', 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getpickupdaterange($billid)
	{
		/*select MIN(o.pickup_datetime) as earliestpickup, MAX(o.pickup_datetime) as latestpickup from tb_orders o,tbl_bills b, tb_reveneus r where r.bill_id=b.id and r.order_id=o.id and b.id=151*/
		$result = array();
		$this->db->select('MIN(o.pickup_datetime) as earliestpickup, MAX(o.pickup_datetime) as latestpickup');
		$this->db->from("tb_orders o");
		$this->db->join('tb_reveneus r', 'o.id= r.order_id', 'INNER');
		$this->db->join('tbl_bills b', 'r.bill_id= b.id', 'INNER');
		$this->db->where('b.id', $billid);
		$this->db->where('r.status', 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->row_array();
		}
		return $result;
	}
	
	public function get_driver_info($shiftid)
	{
		$result = array();
		$this->db->select("s.shipmentid,dr.name");
		$this->db->from("tb_shifts s");
		$this->db->join("tb_shft_veh sv", "sv.shft_id=s.id", "LEFT");
		$this->db->join("tbl_assigned_drivers ad", "ad.vehicle_id=sv.vehicle_id", "LEFT");
		$this->db->join("tb_truck_drivers dr", "ad.driver_id=dr.id", "LEFT");
		$this->db->where("s.id", $shiftid);
		$this->db->where("ad.status", 1);
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->row_array();
		}
		return $result;
	}
	
	public function get_cargos($shiftid,$customerid = 0)
	{
		$result = array();
		$this->db->select("c.cargo_content,o.id");
		$this->db->from("tb_shifts s");
		$this->db->join("tb_orders o", "o.shift_id=s.id", "LEFT");
		$this->db->join("tb_order_cargodetails c", "c.order_id=o.id", "LEFT");
		if($customerid > 0){
			$this->db->where("o.customer_id", $customerid);
		}
		$this->db->where("s.id", $shiftid);
		$this->db->where("o.status !=", '0');
		$this->db->where("c.status", '1');
		$this->db->order_by("o.id", 'ASC');
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->result_array();
		}
		return $result;
	}
	
	public function orderdetails_forbilling($orders)
	{
		$result = array();
		$this->db->select("o.id,o.order_id,o.pickup_datetime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.customer_id,o.shift_id");
		$this->db->from("tb_orders o");
		$this->db->where_in('o.id', $orders);
		$this->db->where("o.status!=", '0');
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->result_array();
		}
		return $result;
	}
	
	public function get_trip_info($shiftid,$select)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from("tb_shifts s");
		$this->db->join("tb_shft_veh sv", "sv.shft_id=s.id", "LEFT");
		$this->db->join("tb_trucks_data td", "td.id=sv.vehicle_id", "LEFT");
		$this->db->join("tbl_assigned_drivers ad", "ad.vehicle_id=sv.vehicle_id", "LEFT");
		$this->db->join("tb_truck_drivers dr", "ad.driver_id=dr.id", "LEFT");
		$this->db->where("s.id", $shiftid);
		$this->db->where("ad.status", 1);
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->row_array();
		}
		return $result;
	}
	
	public function getcost_charges($order_id,$invoice)
	{
		$result = array();
		$this->db->select("c.*,cc.charge_code as chargecode,cc.name as chargecodename,r.debtor_jfr,r.bu_jfr,r.exchange_rate,r.foreign_currency");
		$this->db->from("tb_charges c");
		$this->db->join("tb_reveneus r", "c.revenue_id=r.id", "LEFT");
		$this->db->join("tb_charge_codes cc", "c.charge_code=cc.id", "LEFT");
		$this->db->where("r.type", 1);
		$this->db->where("r.order_id", $order_id);
		$this->db->where("r.bill_id", $invoice);
		$this->db->where("r.status", 1);
		$this->db->where("c.status", 1);
		$getcharges = $this->db->get();
		if ($getcharges->num_rows() > 0) {
			$result = $getcharges->result_array();
		}
		return $result;
	}
	
	function get_order_partydetails($order_row_ids)
	{
		$result = array();
		$this->db->select("p.name,p.mobile,p.location_id,p.country,p.state,p.street,p.pincode,p.building,p.house_number,p.fax,p.contract_no,pt.name as partytype");
		$this->db->from("tbl_party_master p");
		$this->db->join("tb_order_parties o", "p.id=o.party_id", "INNER");
		$this->db->join("tbl_party_types pt", "pt.id=o.party_type", "INNER");
		$this->db->where_in("pt.name", ['Shipper','Consignee','Carrier']);
		$this->db->where_in("o.order_id", $order_row_ids);
		$this->db->where("p.status", 1);
		$this->db->where("o.status", 1);
		$this->db->group_by('p.id');
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	
	function get_driver_instructions($order_row_ids)
	{
		$result = array();
		$this->db->select("reference_id,ref_value");
		$this->db->from("tb_order_references");
		$this->db->where_in("order_id", $order_row_ids);
		$this->db->where_in("reference_id", ['ORD_PIKINST','ORD_DLVINST']);
		$this->db->where("status", 1);
		$this->db->group_by('ref_value');
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$result = $getresult->result_array();
		}
		return $result;
	}
	
	public function get_cargo_details($order_row_ids)
	{
		$result = array();
		$this->db->select("weight,volume,quantity,quantity_type,cargo_content");
		$this->db->from("tb_order_cargodetails");
		$this->db->where_in("order_id", $order_row_ids);
		$this->db->where("status", '1');
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->result_array();
		}
		return $result;
	}

	public function get_costs_sum(array $orderIds): float
	{
		$this->db->select("SUM(amount) as totalcost");
		$this->db->from("tb_reveneus");
		$this->db->where_in("order_id", $orderIds);
		$this->db->where("type", '1');
		$this->db->where("status", '1');
		$query = $this->db->get();
		return $query->num_rows() > 0 ? round($query->row()->totalcost, 2) : 0;
	}

	public function check_vas_ins($order_row_ids)
	{
		$vas_count = 0;
		$this->db->select("COUNT(v.id) as inscount");
		$this->db->from("tb_order_vas v");
		$this->db->join("tb_vas_master vm", "v.vas_id=vm.id", "LEFT");
		$this->db->where_in("v.order_id", $order_row_ids);
		$this->db->where("vm.vas_id", 'INS');
		$this->db->where("v.status", 1);
		$getresult = $this->db->get();
		if ($getresult->num_rows() > 0) {
			$vas_count = $getresult->row()->inscount;
		}
		return $vas_count;
	}
	
	public function get_shift_rank($data)
	{
		$rank = 0;
		$getresult = $this->db->query("select rank from (SELECT id,@curRank := @curRank + 1 AS rank
		FROM tb_shifts, (SELECT @curRank := 0) r
		where DATE_FORMAT(created_on,'%y%m')>'" . $data['from_date_range'] . "' and DATE_FORMAT(created_on,'%y%m')<'" . $data['to_date_range'] . "' and company_code='" . $data['company_code'] . "' ORDER BY  created_on ASC) as shft_table where id='" . $data['shift_id'] . "'");
		if ($getresult->num_rows() > 0) {
			$rank = $getresult->row()->rank;
		}
		return $rank;
	}

	public function getcustomers_by_shiftid($shift_id)
	{
		$result = array();
		$this->db->select("o.customer_id,c.name,c.code,c.email_id,c.company_code");
		$this->db->from("tb_orders o");
		$this->db->join('tb_customers c', 'o.customer_id= c.id', 'INNER');
		$this->db->where_in('o.shift_id', $shift_id);
		$this->db->where("o.status!=", '0');
		$this->db->group_by('o.customer_id');
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->result_array();
		}
		return $result;
	}
	
	public function getcarrier_by_shiftid($shift_id)
	{
		$result = array();
		$this->db->select("v.name,v.mobile,p.fax,p.contract_no");
		$this->db->from("tb_shifts s");
		$this->db->join('tb_vendors v', 's.vendor_id= v.id', 'INNER');
		$this->db->join('tbl_party_master p', 'v.code= p.code', 'INNER');
		$this->db->where_in('s.id', $shift_id);
		$this->db->where("p.company_code", $this->session->userdata('company_code'));
		$this->db->where("p.status!=", '0');
		$qry = $this->db->get();
		if ($qry->num_rows() > 0) {
			$result = $qry->row_array();
		}
		return $result;
	}
	
	public function checksinglecurrencyexists_inallcharges($rev_ids){
		$currency = array();
		if(!empty($rev_ids)){
			$this->db->select("currency");
			$this->db->from("tb_charges");
			$this->db->where_in('revenue_id',$rev_ids);
			$this->db->where('status','1');
			$qry = $this->db->get();
			if($qry->num_rows() >0){
				foreach ($qry->result() as $res) {
					if(empty($currency)){
						$currency[] = $res->currency;
					}else{
						if(!in_array($res->currency, $currency)){
							$currency[] = $res->currency;
						}
					}
				}
			}
		}
		return $currency;
	}
	
    public function getOrderIdsByShiftId(int $shiftId): array
    {
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $checkCrossBorderMainTrip = $this->db->query("SELECT id FROM tb_shifts WHERE shift_leg_id = ?", [$shiftId]);
        if ($checkCrossBorderMainTrip->num_rows() > 0) {
            return ['crossBorderMainTrip' => '1'];
        }
        $checkNormalTrips = $this->db->query(
            "SELECT id,order_id,convertToClientTZ(pickup_datetime, ?) as pickup_datetime,convertToClientTZ(drop_endtime,?) as drop_endtime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,customer_id,branch_code,created_source,shipmentid FROM tb_orders WHERE shift_id  = ? AND status > ?",
            [$timeZone, $timeZone, $shiftId, 0]
        );
        if ($checkNormalTrips->num_rows() > 0) {
            return $checkNormalTrips->result_array();
        }
        $checkCrossBorderLegs = $this->db->query("SELECT id FROM tb_shifts WHERE id = ? AND shift_leg_id > ?", [$shiftId, 0]);
        if ($checkCrossBorderLegs->num_rows() == 0) {
            return [];
        }
        $getOrderDetails = $this->db->query(
            "SELECT o.id,o.order_id,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,convertToClientTZ(o.drop_endtime,?) as drop_endtime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.customer_id,o.branch_code,o.created_source,o.shipmentid FROM tb_orders o,tb_employee e WHERE e.shift_id = ? AND e.status = ? AND e.order_id = o.order_id AND o.status > ?",
            [$timeZone, $timeZone, $shiftId, 1, 0]
        );
        return $getOrderDetails->num_rows() > 0 ? $getOrderDetails->result_array() : [];
    }

    public function getOrderPartyTypes(array $orderIds, array $partyTypes): array
    {
        $query = $this->db->query("select m.name,m.location_id,m.address,m.country,m.state,m.street,m.pincode,o.order_id as order_row_id,t.name as party_type_name from tbl_party_master m,tbl_party_types t, tb_order_parties o where o.order_id IN ? and o.party_id = m.id and o.party_type = t.id and t.name IN ? and m.status= ? order by m.id desc", [$orderIds, $partyTypes, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderReferencesWithCodes(array $orderIds, array $codes): array
    {
        $query = $this->db->query("SELECT order_id,reference_id,ref_value FROM tb_order_references WHERE order_id IN ? AND reference_id IN ? AND status = ?", [$orderIds, $codes, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomerMasterDetails(array $ids): array
    {
        $query = $this->db->query("SELECT id,name,phone,code,email_id,location,street,state,country,pincode FROM tb_customers WHERE id IN ?", [$ids]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsTableData(array $orderIds): array
    {
        $query = $this->db->query("SELECT order_row_id,delivery_term,incoterm,delivery_note,notify_party,customs_required,lane_reference FROM tb_order_details WHERE order_row_id IN ? ", [$orderIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderCargoDetails(array $orderIds): array
    {
        $query = $this->db->query("SELECT cargo_id,order_id,handling_unit,quantity_type,length,width,height,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers FROM tb_order_cargodetails WHERE order_id IN ? AND status = ?", [$orderIds, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getDebtorJfrFromOrder(array $orderIds): array
    {
        $query = $this->db->query("SELECT order_id,debtor_jfr FROM tb_reveneus WHERE order_id IN ? AND status = ? AND invoice_status > ?  AND debtor_jfr IS NOT NULL GROUP BY debtor_jfr", [$orderIds, 1, 0]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getUserAndBranchAddressDetails(): array
    {
        $branchCode = $this->session->userdata('branch_code');
        $userId = $this->session->userdata('user_id');
        $childId = $this->session->userdata('childid') ?: 0;
        $vendorId = $this->session->userdata('id') ?: 0;
        if ($vendorId > 0) {
            $userQuery = $this->db->query("SELECT name FROM tb_vendors WHERE id = ? ", [$vendorId]);
        } elseif ($childId > 0) {
            $userQuery = $this->db->query("SELECT name FROM tb_user_logins WHERE id = ? ", [$childId]);
        } else {
            $userQuery = $this->db->query("SELECT name FROM tb_users WHERE id = ? ", [$userId]);
        }
        $name = $userQuery->num_rows() > 0 ? $userQuery->row()->name : "";
        $branchQuery = $this->db->query("SELECT branch_officeno FROM tb_branch_master WHERE branch_code = ? ", [$branchCode]);
        $branchOfficeNumber = $branchQuery->num_rows() > 0 ? $branchQuery->row()->branch_officeno : "";
        return ['userName' => $name, 'BranchOfficeNumber' => $branchOfficeNumber];
    }

    public function getTripsDetailsByshiftId(int $shiftId): array
    {
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $getDetails = $this->db->query("SELECT vehicle_id,driver_id FROM tb_trips WHERE shift_id = ? LIMIT 1", [$shiftId]);
        $getTruckType = $this->db->query("SELECT shipmentid,vehicle_type FROM tb_shifts WHERE id = ? LIMIT 1", [$shiftId]);
        $vehicleType = $getTruckType->num_rows() > 0 ? $getTruckType->row()->vehicle_type : "";
        $shipmentId = $getTruckType->num_rows() > 0 ? $getTruckType->row()->shipmentid : date('Ymd');
        $driverId = $getDetails->num_rows() > 0 ? $getDetails->row()->driver_id : 0;
        $vehicleId = $getDetails->num_rows() > 0 ? $getDetails->row()->vehicle_id : 0;
        if (in_array('0', [$driverId, $vehicleId])) {
            $checkShiftVehTable = $this->db->query("SELECT vehicle_id FROM tb_shft_veh WHERE shft_id = ? AND status = ? ORDER BY id DESC LIMIT 1", [$shiftId, 1]);
            if ($checkShiftVehTable->num_rows() > 0) {
                $vehicleId = $checkShiftVehTable->row()->vehicle_id;
                if ($vehicleId > 0) {
                    $checkAssignedDrivers = $this->db->query("SELECT driver_id FROM tbl_assigned_drivers WHERE vehicle_id = ? AND status = ? ORDER BY id DESC LIMIT 1", [$vehicleId, 1]);
                    $driverId = $checkAssignedDrivers->num_rows() > 0 ? $checkAssignedDrivers->row()->driver_id : 0;
                }
            }
        }
        if ($driverId > 0) {
            $getDriverName = $this->db->query("SELECT name FROM tb_truck_drivers WHERE id = ?", [$driverId]);
            $driverName = $getDriverName->num_rows() > 0 ? $getDriverName->row()->name : "";
        }
        if ($vehicleId > 0) {
            $getVehicleNumber = $this->db->query("SELECT truck_number,register_number FROM tb_trucks_data WHERE id = ?", [$vehicleId]);
            $vehicleNumber = $getVehicleNumber->num_rows() > 0 ? $getVehicleNumber->row()->register_number : "";
            $tailerNumber = $getVehicleNumber->num_rows() > 0 ? $getVehicleNumber->row()->truck_number : "";
        }
        $stopsQuery = $this->db->query("SELECT convertToClientTZ(createdon,?) as createdon FROM tb_stop_status WHERE shipment_id = ? AND status = ? AND status_id = ? ORDER BY id DESC LIMIT 1", [$timeZone, $shiftId, 1, '11']);
        $departureDate = $stopsQuery->num_rows() > 0 ? $stopsQuery->row()->createdon : "";
        return ['vehicleNumber' => $vehicleNumber ?? "", 'tailerNumber' => $tailerNumber ?? "", 'driverName' => $driverName ?? "", 'vehicleType' => $vehicleType, 'departureDate' => $departureDate, 'shipmentId' => $shipmentId];
    }

    public function checkDebtorJfrForOrders(array $orderIds): int
    {
        $revOrderIds = [];
        $checkquery = $this->db->query("SELECT id,order_id FROM tb_reveneus WHERE order_id IN ? AND status = ? GROUP BY order_id", [$orderIds, 1]);
        if ($checkquery->num_rows() === 0) {
            return 1;
        }
        foreach ($checkquery->result_array() as $eachRow) {
            $revOrderIds[] = $eachRow['order_id'];
        }
        $revOrderIds = array_unique($revOrderIds);
        if (count($revOrderIds) !== count($orderIds)) {
            return 1;
        }
        $query = $this->db->query("SELECT id FROM tb_reveneus WHERE order_id IN ? AND status = ? AND (debtor_jfr IS NULL OR debtor_jfr = ?) LIMIT 1", [$orderIds, 1, '']);
        return $query->num_rows();
    }

    public function getChargesForRevenueByASCOrder(int $revenueId): array
    {
        $query = $this->db->query("SELECT charge_code,amount,description FROM tb_charges WHERE revenue_id = ? AND status = ? ORDER BY id ASC", [$revenueId, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
}
