<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_DB_mysqli_driver $db
 */
class UniqloOrder extends CI_Model
{
    public function getUnAllocatedCarrierOrders(): array
    {
        $this->db->select(
            'o.id, o.order_id, o.pickup_pincode, o.delivery_pincode, o.delivery_city, o.pickup_city, o.uniqid_of_package, ' .
            'o.pickup_address2, o.delivery_address2, o.user_id, o.createdon, o.created_source, o.shipmentid, ' .
            't.ordtype_code, if(o.created_source = 16, o.pickup_pincode, o.delivery_pincode) as dpincode'
        );
        $this->db->from('tb_orders AS o');
        $this->db->join('tb_order_details AS d', 'o.id = d.order_row_id', 'INNER');
        $this->db->join('tb_order_types AS t', 'd.order_type = t.id', 'LEFT');
        $this->db->join('tb_failed_order_allocations AS foa', 'o.id = foa.order_id', 'LEFT');
        $this->db->where('o.company_code', 'INKN');
        $this->db->where('o.branch_code', 'INCL');
        $this->db->where('o.trip_sts', 0);
        $this->db->where('o.shift_id', 0);
        $this->db->where('o.status !=', 0);
        $this->db->where('foa.order_id IS NULL', null, false);
        $this->db->group_by('o.id');

        return $this->db->get()->result_array();
    }

    public function markAllocationAsFailed(int $orderId, array $triedVendors): void
    {
        $this->db->insert("tb_failed_order_allocations", [
            'order_id' => $orderId,
            'tried_vendor_ids' => json_encode($triedVendors, JSON_THROW_ON_ERROR)
        ]);
    }
}