<?php

use App\Models\Table;

class User_model extends Table
{
    const TABLE = "tb_users";

    const ID_COL = "id";
    const COUNTRY_CODE_COL = "country_code";
    const NAME_COL = "name";
    const BUSINESS_TYPE_COL = "business_type";
    const MOBILE_NO_COL = "mobile_no";
    const PASSWORD_COL = "password";
    const EMAILID_COL = "emailid";
    const DOMAIN_NAME_COL = "domain_name";
    const MAP_TYPE_COL = "map_type";
    const STATUS_DATETIME_TYPE_COL = "status_datetime_type";
    const LOCATION_ID_COL = "location_id";
    const COMPANY_INDV_NAME_COL = "company_indv_name";
    const GCM_ID_COL = "gcm_id";
    const ADDRESS_COL = "address";
    const HEAD_OFFICE_COL = "head_office";
    const GSTIN_COL = "gstin";
    const USR_COUNTRY_COL = "usr_country";
    const CRM_ID_COL = "crm_id";
    const PARENT_ID_COL = "parent_id";
    const COMPANY_CODE_COL = "company_code";
    const BRANCH_CODE_COL = "branch_code";
    const ALTERNATE_NUMBER_COL = "alternate_number";
    const CARRIER_MAIL_TEMPLATE_COL = "carrier_mail_template";
    const CUSTOMER_MAIL_TEMPLATE_COL = "customer_mail_template";
    const DEFAULT_CURRENCY_COL = "default_currency";
    const ONLINE_COL = "online";
    const ALTERNATE_MAILS_COL = "alternate_mails";
    const CC_MAILS_COL = "cc_mails";
    const CREATEDBY_COL = "createdby";
    const LAT_COL = "lat";
    const LNG_COL = "lng";
    const ATTORNEY_NUMBER_COL = "attorney_number";
    const ATTORNEY_DATE_COL = "attorney_date";
    const SIGNPATH_COL = "signpath";
    const QUOTE_MODULE_ID_COL = "quote_module_id";
    const JOB_PROFILE_COL = "job_profile";
    const STATUS_COL = "status";
    const CREATEDON_COL = "createdon";
    const UPDATEDON_COL = "updatedon";

    public function getvehicleslist()
    {
        return true;
    }

    /**  Get the Carrier name based on the assigned  vehicle
     * @param: array (carrier name based on vehicle id and driver id)
     *  return  (Carrier name)
     */
    public function getcarriername(int $vehicle_id, int $driver_id, int $user_id, string $where2): array
    {
        $this->db->select("tv.name");
        $this->db->from("tb_truck_drivers d");
        $this->db->join('tb_vehicles_drivers ad', 'ad.driver_id = d.id ', 'LEFT');
        $this->db->join('tb_trucks_data v', 'v.id=ad.vehicle_id', 'LEFT');
        $this->db->join('tb_vendor_vehicles c', 'c.vehicle_id = v.id AND c.status=1 ', 'LEFT');
        $this->db->join('tb_vendors tv', 'tv.id = c.vendor_id', 'LEFT');
        $where = "d.user_id IN ($user_id) AND v.user_id IN ($user_id) AND ad.status=1 AND v.id='" . $vehicle_id . "' AND d.id ='" . $driver_id . "' $where2";
        $this->db->where($where);
        $this->db->group_by('d.id');
        $res = $this->db->get();
        return $res->num_rows() > 0 ? $res->result_array() : [];
    }

    public function checkDriverMobileExistsOrNot(array $data): int
    {
        $query = $this->db->query("SELECT id FROM tb_truck_drivers WHERE id <> ? AND contact_num = ? AND status = ?", [$data['id'], $data['number'], 'Active']);
        return $query->num_rows();
    }
}
