<?php
defined('BASEPATH') or exit('No direct script access allowed');
use App\Models\Table;

class Vehicle extends Table
{
    const TABLE = "tb_vehicle_master";

    const ID_COL = "id";
    const VEHICLE_TYPE_CODE_COL = "vehicle_type_code";
    const VEHICLE_MODEL_CODE_COL = "vehicle_model_code";
    const MODE_OF_TRANSPORT_COL = "mode_of_transport";
    const VEHICLE_NAME_COL = "vehicle_name";
    const STATUS_COL = "status";
    const CREATEDON_COL = 'createdon';
    const UPDATEDON_COL = "updateon";

    public function getVendorIdsByName(string $vendorName, string $companyCode, array $permissions, int $userId): array
    {
        $sql = "select id from tb_vendors where name = ?";
        $params[] = $vendorName;

        $businessType = $this->session->userdata('business_type') ?? '';
        $sql .= $this->getSqlForVehiclePermissions($permissions, $params, $companyCode, $userId, $businessType);
        $sql .= " AND status = 1";

        $query = $this->db->query($sql, $params);

        return !$query ? [] : array_map('current', $query->result_array());
    }

    public function getVendors(array $vendorIds, string $companyCode, array $permissions, int $userId, string $businessType): array
    {
        $sql = "SELECT id, name, code FROM tb_vendors WHERE status = 1";
        $params = [];

        $sql .= $this->getSqlForVehiclePermissions($permissions, $params, $companyCode, $userId, $businessType);

        if ($businessType == "Carrier" && !empty($vendorIds)) {
            $sql .= " AND (id IN ? OR parent_id in ?) ";
            $params[] = $vendorIds;
            $params[] = $vendorIds;
        }

        $sql .= " GROUP BY name";
        $query = $this->db->query($sql, $params);

        return !$query ? [] : $query->result();
    }

    public function getVehicleList(
        array $vendorIds,
        string $companyCode,
        array $permissions,
        int $userId,
        string $businessType,
        string $vehicleId,
        string $contact,
        string $vendorName): array
    {
        $params = [];

        $fields = "t.id,
                        t.register_number,
                        t.truck_capacity,
                        t.phone,
                        t.createdon,
                        t.description,
                        t.insuredby,
                        t.insurestart,
                        t.insureexp,
                        t.contact_name,
                        t.status,
                        u.name,
                        v.name as vendor_name,
                        u.mobile_no,
                        t.vendor_id,
                        t.length_unit,
                        t.breadth_unit,
                        t.weight_unit,
                        t.height_unit,
                        t.volume_unit,
                        t.truck_volume,
                        t.truck_weight";

        $sql = "SELECT " . $fields ." FROM tb_users u INNER JOIN tb_trucks_data t ON t.user_id=u.id";

        if ($businessType == "Carrier") {
            $sql .=  " INNER JOIN tb_vendors v ON v.id=t.vendor_id
                WHERE ( t.vendor_id IN ?
                    OR t.vendor_id IN ( SELECT id from tb_vendors WHERE parent_id IN ? )
                ) ";
            $params[] = $vendorIds;
            $params[] = $vendorIds;
        } else {
            $sql .= " LEFT JOIN tb_vendors v ON v.id=t.vendor_id WHERE 1";
        }

        $sql .= $this->getSqlForVehicleList($permissions, $params, $companyCode, $userId, $businessType);

        if ($vehicleId) {
            $sql .=  " AND t.register_number LIKE ?";
            $params[] = '%' . $vehicleId . '%';
        }

        if ($contact) {
            $sql .=  " AND (t.contact_name LIKE ? OR t.phone LIKE ?)";
            $params[] = '%' . $contact . '%';
            $params[] = '%' . $contact . '%';
        }

        if ($vendorName != '') {
            $vendors = $this->Vehicle->getVendorIdsByName($vendorName, $companyCode, $permissions, $userId);

            if (!empty($vendors)) {
                $sql .=  " AND t.vendor_id IN ?";
                $params[] = $vendors;
            }
        }

        $sql .=  " AND t.status='Active'";
        $sql .= " ORDER by id desc";

        $query = $this->db->query($sql, $params);

        return !$query ? [] : $query->result();
    }

    public function getVehicleRegistrationNumbers(array $vehicleIds):array
    {
        if (empty($vehicleIds)) {
            return [];
        }

        $query = $this->db->query("SELECT id, register_number
            FROM tb_trucks_data
         WHERE id IN ?", [ $vehicleIds ]);
        if (!$query) {
            return [];
        }

        $result = [];
        foreach($query->result() as $row) {
            $result [$row->id] = $row->register_number;
        }
        return $result;
    }

    private function getSqlForVehiclePermissions(array $permissions, array &$params, string $companyCode, int $userId, string $businessType) : string
    {
        $sql = "";

        if (in_array("vehicles", $permissions)) {
            if ($companyCode == "KNAU") {
                $sql .= " AND company_code IN ?";
                $params[] = ['KNAU', 'AUKN'];
            } else {
                $sql .= " AND company_code = ?";
                $params[] = $companyCode;
            }
        } elseif ($businessType !== 'Carrier') {
            $sql .= " AND company_code = ?";
            $params[] = $companyCode;
        }

        return $sql;
    }

    private function getSqlForVehicleList(array $permissions, array &$params, string $companyCode, int $userId, string $businessType) : string
    {
        $sql = "";

        if (in_array("vehicles", $permissions)) {
            if ($companyCode == "KNAU") {
                $sql .= " AND u.company_code IN ?";
                $params[] = ['KNAU', 'AUKN'];
            } else {
                $sql .= " AND u.company_code = ?";
                $params[] = $companyCode;
            }

            $sql .= " AND t.user_id = u.id";
        } elseif ($businessType !== 'Carrier') {
            if (checkAccessConditions('COMPANY_CODE_WISE_GROUP_MASTERS', $companyCode)) {
                $sql .= " AND t.user_id IN (SELECT u.id FROM tb_users u WHERE u.company_indv_name = ? AND u.status = ?)";
                $params[] = $companyCode;
                $params[] = 'Active';
            } else {
                $sql .= " AND t.user_id = ?";
                $params[] = $userId;
            }
        }

        return $sql;
    }
    public function getVehicleData($id)
    {
        $query = $this->db->query("SELECT t.*,u.name,u.mobile_no,tt.trucktype,tv.vendor_name
            FROM `tb_trucks_data` t
                LEFT JOIN tb_users u ON t.user_id=u.id
                LEFT JOIN tb_trucktypes tt ON tt.id = t.truck_type
                LEFT JOIN tb_tracking_vendors tv ON tv.id = t.track_vendor_id
            WHERE t.`id` =  ? ", [ $id ]);
        return $query ?? '';

    }
}
