<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Vehicleprofilemodel extends CI_Model
{
    
    function getvehicleprofiledata($whr, $where){
        $this->db->select('id,veh_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vehicle_profile');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('id desc');
        $vendor_profile_instance = $this->db->get();
        $result = $vendor_profile_instance ->result_array();
        return $result;
    }
    
    function getsearchdata($whr, $where)
    {
        $this->db->select('tt.*, c.name as uname');
        $this->db->from('tb_order_types as tt');
        $this->db->join('tb_customers c', 'tt.customer_id=c.id');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('tt.id', 'DESC');
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }
    
    function userlist()
    {
        $user = array();
        $this->db->select('name,id');
        $this->db->group_by('name');
        $user = $this->db->get('tb_users')->result_array();
        return $user;
    }

    function editdata($id,$company_code,$branch_code)
    {
        $edit = array();
        $this->db->select('id,veh_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vehicle_profile'); 
        $this->db->where('id', $id);
        $this->db->where('company_code', $company_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $edit = $this->db->get()->row_array();
        return $edit;
    }

    function viewdata($id,$company_code,$branch_code)
    {
        $edit = array();
        $this->db->select('id,veh_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vehicle_profile'); 
        $this->db->where('id', $id);
        $this->db->where('branch_code', $branch_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $edit = $this->db->get()->row_array();
        return $edit;
    }

    function selectlist($select, $table, $whr, $group_by)
    {
        $result = array();
        $this->db->select($select);
        $this->db->like($whr);
        $this->db->from($table);
        $this->db->group_by($group_by);
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }

    function getprofilelist($wherein){
        $this->db->select('t.trucktype,t.description,t.iconimg,vp.id as vehicle_id,t.id as truck_id')->from('tb_vehicle_profile_list vp');
        $this->db->join('tb_trucktypes t','t.id = vp.profile_id','LEFT');
        $this->db->where_in('vp.id',$wherein);
        $this->db->where('vp.status',1);
        $this->db->order_by('vp.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function updatelistmodule($tbl,$data,$wherein){
        $this->db->where_in('id',$wherein);
        $this->db->update($tbl,$data);
        return true;
    }

    public function profilelistbyid($id)
    {
        $this->db->select('vpl.id as vpl_id,t.trucktype,t.description,t.iconimg,t.id as truck_id')->from('tb_vehicle_profile_list vpl');
        $this->db->join('tb_trucktypes t','t.id = vpl.profile_id','LEFT');
        $this->db->where('vpl.veh_p_id',$id);
        $this->db->where('vpl.status',1);
        $this->db->order_by('vpl.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }
}