<?php
defined('BASEPATH') or exit('No direct script access allowed');
use App\Models\Table;

class Vehicles_drivers extends Table
{
    const TABLE = 'tb_vehicles_drivers';

    const ID_COL = 'id';
    const VEHICLE_ID_COL = 'vehicle_id';
    const DRIVER_ID_COL = 'driver_id';
    const IMEI_COL = 'imei';
    const STATUS_COL = 'status';
    const CREATEDON_COL = 'createdon';
    const UPDATEDON_COL = 'updatedon';


    public function getDriverNames(array $driverIds): array
    {
        if (empty($driverIds)) {
            return [];
        }

        $query = $this->db->query("SELECT id, name
            FROM tb_truck_drivers
         WHERE id IN ?", [ $driverIds ]);
        if (!$query) {
            return [];
        }

        $result = [];
        foreach($query->result() as $row) {
            $result [$row->id] = $row->name;
        }
        return $result;
    }

    public function getDriverIdsFromVehicleHistory(array $shiftIds): array
    {
        if (empty($shiftIds)) {
            return [];
        }

        $query = $this->db->query("SELECT id, driver_id, shft_id
            FROM tb_shft_veh_history
         WHERE shft_id IN ?
         ORDER BY id", [ $shiftIds ]);
        if (!$query) {
            return [];
        }

        $result = [];
        foreach($query->result() as $row) {
            $result [$row->shft_id] = $row->driver_id;
        }
        return $result;
    }
}
