<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Vendorprofilemodel extends CI_Model
{
    
    function getvendorprofiledata($whr, $where){
        $this->db->select('id,vend_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vendor_profile');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('id desc');
        $vendor_profile_instance = $this->db->get();
        $result = $vendor_profile_instance ->result_array(); 
        return $result;
    }
    
    function getsearchdata($whr, $where)
    {
        $this->db->select('tt.*, c.name as uname');
        $this->db->from('tb_order_types as tt');
        $this->db->join('tb_customers c', 'tt.customer_id=c.id');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('tt.id', 'DESC');
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }
    function userlist()
    {
        $user = array();
        $this->db->select('name,id');
        $this->db->group_by('name');
        $user = $this->db->get('tb_users')->result_array();
        return $user;
    }

    function editdata($id,$company_code,$branch_code)
    {
        $edit = array();
        $this->db->select('id,vend_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vendor_profile'); 
        $this->db->where('id', $id);
        $this->db->where('company_code', $company_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $edit = $this->db->get()->row_array();
        return $edit;
    }

    function viewdata($id,$company_code,$branch_code)
    {
        $edit = array();
        $this->db->select('id,vend_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_vendor_profile'); 
        $this->db->where('id', $id);
        $this->db->where('company_code', $company_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $edit = $this->db->get()->row_array();
        return $edit;
    }

    function selectlist($select, $table, $whr, $group_by)
    {
        $result = array();
        $this->db->select($select);
        $this->db->like($whr);
        $this->db->from($table);
        $this->db->group_by($group_by);
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }

    function getprofilelist($wherein){
        $this->db->select('v.name,v.mobile,v.code,v.address,v.pincode,vp.id as vendor_profile_list_id,v.id as party_id')->from('tb_vendor_profile_list vp');
        $this->db->join('tb_vendors v','v.id = vp.party_id','LEFT');
        $this->db->where_in('vp.id',$wherein);
        $this->db->where('vp.status',1);
        $this->db->group_by('vp.id');
        $this->db->order_by('vp.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function updatelistmodule($tbl,$data,$wherein){
        $this->db->where_in('id',$wherein);
        $this->db->update($tbl,$data);
        return true;
    }

    function profilelistbyid($id, $company_code, $branch_code)
    {
        $result = array();
        $this->db->select('v.name,v.mobile,v.code,v.address,v.pincode,vpl.id as vendor_profile_list_id,v.id as party_id')->from('tb_vendor_profile_list vpl');
        $this->db->join('tb_vendors v','v.id = vpl.party_id','LEFT');
        $this->db->join('tb_vendor_profile vp','vpl.vp_id=vp.id','LEFT');
        $this->db->where('vpl.vp_id',$id);
        if($company_code == 'RUKN') {
            $this->db->where('vp.company_code',$company_code);
        } else {
            $this->db->where('vp.company_code',$company_code);
            $this->db->where('vp.branch_code',$branch_code);
        }
        $this->db->where('vpl.status',1);
        $this->db->group_by('vpl.id');
        $this->db->order_by('vpl.id','DESC');
        $query = $this->db->get();
        if($query->num_rows() > 0) {
            $result = $query->result_array();
        }
        return $result;
    }
}