<?php defined('BASEPATH') or exit('No direct script access allowed');
class WheelseyeModel extends CI_Model
{
    private const OVERLAND_MUMBAI_USER_ID = 3;

    public function getOrders(array $registerNumbers): array
    {
        $wheelseyeCountriesSQL = $this->db->select('condition')->where(['title' => 'WHEELS_EYE_COUNTRIES'])->get('access_conditions')->row();
        if (empty($wheelseyeCountriesSQL)) {
            return [];
        }
        $wheelseyeCountries = explode(',', $wheelseyeCountriesSQL->condition);
        $SQL = 'SELECT o.trip_id, o.shift_id, t.vehicle_id, t.driver_id, v.register_number
        FROM  tb_orders o
        INNER JOIN tb_trips t ON (t.id = o.trip_id)
        INNER JOIN tb_shft_veh v ON (o.shift_id = v.shft_id)
        INNER JOIN tb_trucks_data trucks ON (trucks.id = v.vehicle_id AND trucks.gpsstatus = ? AND trucks.track_vendor_id > ?)
        INNER JOIN tb_tracking_vendors tvendors ON (tvendors.id = trucks.track_vendor_id AND tvendors.vendor_name = ?)
        WHERE o.company_code IN ?
          AND v.register_number IN ?
          AND o.user_id = ?
          AND o.status > 0
          AND o.trip_sts = 0
          AND o.trip_id > 0
        ORDER BY o.id DESC';
        $result = $this->db->query($SQL, [1, 0, 'WHEELSEYE', $wheelseyeCountries, $registerNumbers, self::OVERLAND_MUMBAI_USER_ID]);
        return $result ? $result->result_array() : [];
    }

    public function getStatusResult(int $shipmentId, int $tripID): array
    {
        $SQL = "SELECT SUM(CASE WHEN (stop_type='P' AND status_id = 2) THEN 1 ELSE 0 END) AS gatein,
            SUM(CASE WHEN (stop_type='D' AND status_id = 3) THEN 1 ELSE 0 END) AS gateout
            FROM `tb_stop_status`
            WHERE shipment_id = ?
              AND trip_id = ?
              AND status > 0";
        $result = $this->db->query($SQL, [$shipmentId, $tripID]);
        return $result ? $result->row_array() : [];
    }
}