<?php

class WorkbenchModel extends CI_Model
{
    public function getBookingIdsCount(array $where): array
    {
        $this->db->select("order_status_category,COUNT(*) as orders_count");
        $this->db->from("tb_orders");
        $this->db->where_in("order_status_category", [1, 2, 3]);
        $this->db->where("company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("vendor_id", $where['vendorId']);
        }
        $this->db->where("status !=", 0);
        $this->db->group_by("order_status_category");
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachRow) {
                if ($eachRow['order_status_category'] == 1) {
                    $count['pending_count'] = $eachRow['orders_count'];
                } elseif ($eachRow['order_status_category'] == 2) {
                    $count['active_count'] = $eachRow['orders_count'];
                } elseif ($eachRow['order_status_category'] == 3) {
                    $count['completed_count'] = $eachRow['orders_count'];
                }
            }
        }
        return $count ?? [];
    }

    public function getRecentBookings(array $data): array
    {
        if (in_array($data['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($data['userIds'])) {
            $sql = "(SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND user_id IN ? AND status !=0 AND order_status_category = ? ORDER BY id DESC LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND user_id IN ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND user_id IN ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)";
            $where = [$data['companyCode'], $data['userIds'], 1, $data['companyCode'], $data['userIds'], 2, $data['companyCode'], $data['userIds'], 3];
        }
        if ($data['businessType'] == "Customer" && $data['customerId'] > 0) {
            $sql = "(SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND customer_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND customer_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND customer_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)";
            $where = [$data['companyCode'], $data['customerId'], 1, $data['companyCode'], $data['customerId'], 2, $data['companyCode'], $data['customerId'], 3];
        }
        if ($data['businessType'] == "Carrier" && $data['vendorId'] > 0) {
            $sql = "(SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND vendor_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND vendor_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)
        UNION ALL
        (SELECT id,order_id,order_status_category FROM tb_orders WHERE company_code = ? AND vendor_id = ? AND status !=0 AND order_status_category = ? ORDER BY id DESC  LIMIT 5)";
            $where = [$data['companyCode'], $data['vendorId'], 1, $data['companyCode'], $data['vendorId'], 2, $data['companyCode'], $data['vendorId'], 3];
        }
        if (!isset($where)) {
            return [];
        }
        $getResult = $this->db->query($sql, $where);
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

}
