<?php

defined('BASEPATH') or exit('No direct script access allowed');

class CarrierInboundModel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }
    
    public function checkPartyRoleExists(string $name, string $state, string $pinCode, string $partyRole): array
    {
        $name = str_replace(["'", '"', '%'], '', $name);
        $this->db->select('tpm.id, tpm.company_code, tpm.branch_code, tpm.department_code, tpm.user_id, tpm.country, tpm.code');
        $this->db->from('tbl_party_master tpm');
        $this->db->join('tbl_party_types tpt', 'FIND_IN_SET(tpt.id, tpm.party_types)', '', false);
    
        if (str_contains(strtoupper($name), 'EATON')) {
            $this->db->like('tpm.name', 'EATON');
            $this->db->where('tpm.status', 1);
            $this->db->where('tpm.state', $state);
            $this->db->where_in('tpm.pincode', ['605111', '600067', '412210']);
        } else if (str_contains(strtoupper($name), 'SIEMENS')) {
            $this->db->like('tpm.name', 'SIEMENS');
            $this->db->where([
                'tpm.state'   => $state,
                'tpm.pincode' => $pinCode,
                'tpm.status'  => 1,
            ]);
        } else if (str_contains(strtoupper($name), 'KUEHNE')) {
            $this->db->like('tpm.name', 'KUEHNE');
            $this->db->where('tpm.status', 1);
            $this->db->where('tpm.state', $state);
            $this->db->where_in('tpm.pincode', ['605111', '600067']);
        } else {
            $searchName = strtoupper($name);
            $this->db->where([
                'tpm.state'   => $state,
                'tpm.pincode' => $pinCode,
                'tpm.status'  => 1
            ]);
            $this->db->where("UPPER(tpm.name) LIKE '%{$searchName}%'", null, false);
        }
    
        $roleArray = array_map('trim', explode(',', strtoupper($partyRole)));
        $this->db->where_in('UPPER(tpt.name)', $roleArray);
        $query = $this->db->get();
        log_message('error', 'SQL Query: ' . $this->db->last_query()); // for debugging
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
    
    /*public function checkPartyRoleExists(string $name, string $state, string $pinCode, string $partyRole): array
    {
        $this->db->select('tpm.id, tpm.company_code, tpm.branch_code, tpm.department_code, tpm.user_id, tpm.country,tpm.code');
        $this->db->from('`tbl_party_master` `tpm`');
        $this->db->join('`tbl_party_types` `tpt`', '`tpt`.`id` in (`tpm`.`party_types`) ');
        //if(strtoupper($name) == "EATON POWER QUALITY PRIVATE LIMITED"){
        if (str_contains(strtoupper($name), 'EATON')) {
            $this->db->where(['`tpm.name`' => $name, 'tpm.`status' => 1]);
            $this->db->where_in('tpm.pincode', ['605001', '605111']);
        }
        else
        {
            $this->db->where(['`tpm.name`' => $name, '`tpm`.`state`' => $state, 'tpm.`pincode' => $pinCode, 'tpm.`status' => 1]);
        }
        $this->db->where("UPPER(tpt.name) IN ('SHIPPER')", null, false); // false disables escaping
        $partyRoleExists = $this->db->get();
        //log_message("error", "Innn:" . $this->db->last_query());
        return $partyRoleExists->num_rows() > 0 ? $partyRoleExists->result_array() : [];
    }*/

    public function getPartyData(array $consignmentData, string $partyRole, string $companyCode, string $clientCode, string $userId, string $country): string
    {
        if (strtoupper($partyRole) == 'SHIPPER') {
            $consigneeName     = $consignmentData['ConsignorName'] ?? "";
            $consigneeEmail    = $consignmentData['ConsignorEmail'] ?? "";
            $consigneePOC      = $consignmentData['ConsignorPOC'] ?? "";
            $consigneeState    = $consignmentData['ConsignorState'] ?? "";
            $consigneeDistrict = $consignmentData['ConsignorDistrict'] ?? "";
            $consigneeLocation = $consignmentData['ConsignorLocation'] ?? "";
            $consigneePostCode = $consignmentData['ConsignorPostcode'] ?? "";
            $consigneeAddress  = $consignmentData['ConsignorAddress'] ?? "";
        } else {
            $consigneeName     = $consignmentData['ConsigneeName'] ?? "";
            $consigneeEmail    = $consignmentData['ConsigneeEmail'] ?? "";
            $consigneePOC      = $consignmentData['ConsigneePOC'] ?? "";
            $consigneeState    = $consignmentData['ConsigneeState'] ?? "";
            $consigneeDistrict = $consignmentData['ConsigneeDistrict'] ?? "";
            $consigneeLocation = $consignmentData['ConsigneeLocation'] ?? "";
            $consigneePostCode = $consignmentData['ConsigneePostcode'] ?? "";
            $consigneeAddress  = $consignmentData['ConsigneeAddress'] ?? "";
        }
        
        $this->db->select('tpt.id');
        $this->db->from('`tbl_party_types` `tpt`');
        $this->db->where(['`tpt.company_code`' => $companyCode, '`tpt`.`branch_code`' => $clientCode, '`tpt`.`user_id`' => $userId, 'UPPER(tpt.name)' => strtoupper($partyRole), 'tpt.`status' => 1]);
        $getPartyTypeId = $this->db->get();

        if ($getPartyTypeId->num_rows() == 0) {
            $curdt = date("Y-m-d H:i:s");
            $party = [
                'name'         => $partyRole,
                'description'  => $partyRole,
                'user_id'      => $userId,
                'company_code' => $companyCode,
                'branch_code'  => $clientCode,
                'created_on'   => $curdt,
                'updated_on'   => $curdt,
            ];
            $cpartyId = $this->common->insertTableData("tbl_party_types", $party);
        } else {
            $row      = $getPartyTypeId->row_array();
            $cpartyId = $row['id'];
        }
        $masterCheck = [
            'UPPER(name)'    => strtoupper($consigneeName),
            'UPPER(state)'   => strtoupper($consigneeState),
            'UPPER(pincode)' => strtoupper($consigneePostCode),
            'user_id'        => $userId,
            'company_code'   => $companyCode,
            'branch_code'    => $clientCode,
            'status'         => '1',
        ];
        $checkconsignee = $this->common->gettblrowdata($masterCheck, "code", "tbl_party_master", 1, 0);
        
        if(isset($checkconsignee['code']) && $checkconsignee['code'] != ''){
            $consigneeCode = $checkconsignee['code'];
        } else {
            $masterInsert = [
                'party_type_id' => $cpartyId,
                'name'          => $consigneeName,
                'state'         => $consigneeState,
                'pincode'       => $consignorPostCode,
                'country'       => $country,
                'user_id'       => $userId,
                'company_code'  => $companyCode,
                'branch_code'   => $clientCode,
                'status'        => '1',
                'address'       => $consigneeAddress,
                'location_id'   => $consigneeLocation,
                'email'         => $consigneeEmail ?? "",
                'mobile'        => $consigneePOC ?? "",
            ];
            $consigneeId   = $this->common->insertTableData("tbl_party_master", $masterInsert);
            $consigneeId = str_pad($consigneeId, 4, '0', STR_PAD_LEFT);
            $year          = date('y');
            $week          = date('W');
            $countryCode   = substr($companyCode, 0, 2);
            $get_country_master = $this->common->gettblrowdata(array('status'=>1,'country_code'=>$countryCode),"phone_code","tbl_country_master",0,0);
            if(isset($get_country_master['phone_code']) && $get_country_master['phone_code']!=''){
                $countryCode = $get_country_master['phone_code'];
            }
            $consigneeCode = $countryCode . $year . $week . $consigneeId;
            
            $mobile        = ! empty($consigneePOC) ? $consigneePOC : $consigneeCode;
            $upd           = $this->common->updatetbledata("tbl_party_master", ['code' => $consigneeCode, 'mobile' => $mobile, 'customeridentifier' => $consigneeCode], ['id' => $consigneeId]);
        }

        return $consigneeCode;
    }
    
    public function getOrderId(string $tkn, string $ref): array
    {
        $this->db->select('tos.id, tos.order_id, tos.company_code, tos.branch_code, tos.user_id');
        $this->db->from('tb_orders as tos');
        $this->db->join('tb_order_references as tor', 'tos.id = tor.order_id');
        $this->db->where([
            'tor.reference_id' => $ref,
            'tor.ref_value' => $tkn,
            'tor.status' => 1
        ]);
    
        $query = $this->db->get();

        /*if ($query === false) {
            log_message("error", "DB Query failed: " . $this->db->last_query());
            return [];
        }*/
    
        return $query && $query->num_rows() > 0 ? $query->result_array() : [];
    }
    
    public function checkDepartment(string $companyCode, string $clientCode, string $specialRemarks): array
    {
        $this->db->select('tdm.department_code');
        $this->db->from('tb_department_master as tdm');
        $this->db->where([
            'tdm.company_code' => $companyCode,
            'tdm.branch_code' => $clientCode,
            'tdm.status' => 1
        ]);
        $this->db->like('LEFT(tdm.department_code, 1)', $specialRemarks);
    
        $query = $this->db->get();

        return $query && $query->num_rows() > 0 ? $query->result_array() : [];
    }
    
    public function checkCustomerData(string $companyCode, string $clientCode): array
    {
        $codes = [XP_INDIA_EATON, XP_INDIA_SIEMENS, '1001403696'];
        $this->db->select("code, name, street, address, state, pincode, country, mobile, email");
        $this->db->from("tbl_party_master");
        $this->db->where_in("code", $codes);
        $this->db->where("status", 1);
        $this->db->where("company_code", $companyCode);
        $this->db->where("branch_code", $clientCode);
        $query = $this->db->get();
        //log_message('error', 'SQL Query: ' . $this->db->last_query());
        return $query && $query->num_rows() > 0 ? $query->result_array() : [];
    }
}
