<?php
defined('BASEPATH') or exit('No direct script access allowed');

class CustomerOrder extends CI_Model
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model(['common', 'Order', 'smtcorder', 'svkCustomer/CustomerOrder']);
        $this->load->library(['StatusRemappingService','calculateDistanceByOrderId']);
    }

    private function formatReferenceParameters($referenceData): array
    {
        $response = [];
        if (empty($referenceData)) {
            return [];
        }
        foreach ($referenceData as $eachRefData) {
            $key = isset($eachRefData['reference_id']) ? trim($eachRefData['reference_id']) : '';
            $value = isset($eachRefData['ref_value']) ? trim($eachRefData['ref_value']) : '';
            $response[$key] = $value;
        }
        return $response;
    }

    public function searchOrders(array $post): array
    {
        $where = [];
        $createdDate = date('Y-m-d H:i:s');
        $sessionCompanyCode = $this->session->userdata('company_code');
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate = date('Y-m-d', strtotime($post['fromdate']));
            $where["date(o.createdon) >="] = $fromdate;
            if (isset($post['toDate'])) {
                if ($post['toDate'] == "") {
                    $todate = date('Y-m-d', strtotime($createdDate));
                    $where["date(o.createdon) <="] = $todate;
                }
            } else {
                $todate = date('Y-m-d', strtotime($createdDate));
                $where["date(o.createdon) <="] = $todate;
            }
        }
        if (isset($post['toDate']) && $post['toDate'] != "") {
            $todate = date('Y-m-d', strtotime($post['toDate']));
            $where["date(o.createdon) <="] = $todate;
        }
        if (isset($post['order_id']) && $post['order_id'] != "") {
            $where['o.order_id'] = $post['order_id'];
        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $cust_id = $post['scust_id'];
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", ['code' => $post['searchcustomer_id'],'id' => $cust_id ]);
            if ($getcustomer_id->num_rows() > 0) {
                $where['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }
        if (isset($post['service']) && $post['service'] != "") {
            $where['d.service'] = $post['service'];
        }
        if (isset($post['order_type']) && $post['order_type'] != "") {
            $where['d.order_type'] = $post['order_type'];
        }
        if (isset($post['product']) && $post['product'] != "") {
            $where['o.product'] = $post['product'];
        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $where['o.transport_mode'] = $post['modeof_trasnport'];
        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $where['o.pickup_custid'] = $post['searchshipper_id'];
        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $where['o.drop_custid'] = $post['searchconsignee_id'];
        }
        if (isset($post['trip_id']) && $post['trip_id'] != "") {
            $where['o.shipmentid'] = $post['trip_id'];
        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $getDeliveryNoteId = $this->db->select("order_id")->get_where(
                "tb_order_references",
                ['ref_value' => $post['delivery_note'], 'status' => '1', 'reference_id' => 'DQ']
            );
            if ($getDeliveryNoteId->num_rows() > 0) {
                $orderId = $getDeliveryNoteId->row()->order_id;
                $where['o.id'] = $orderId;
            }
        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $getPurchaseOrder = $this->db->query(
                "SELECT o.id FROM tb_orders o,tb_order_references r
            WHERE o.id = r.order_id AND o.company_code LIKE ?
            AND o.status !=0 AND r.reference_id LIKE ? AND r.ref_value = ?
            AND r.status ='1'",
                [sprintf('%s%%', $sessionCompanyCode), sprintf('%s%%', 'PO'), $post['purchase_order']]
            );
            if ($getPurchaseOrder->num_rows() > 0) {
                $where['o.id'] = $getPurchaseOrder->row()->id;
            } else {
                $where['o.id'] = '0';
            }
        }
        if (isset($post['load_plan_connote']) && $post['load_plan_connote'] != "") {
            $getPurchaseOrder = $this->db->query(
                "SELECT o.id FROM tb_orders o,tb_order_references r
            WHERE o.id = r.order_id AND o.company_code LIKE ?
            AND o.status != ? AND r.reference_id LIKE ? AND r.ref_value = ?",
                [sprintf('%s%%', $sessionCompanyCode), 0, sprintf('%s%%', 'LPC'), $post['load_plan_connote']]
            );
            if ($getPurchaseOrder->num_rows() > 0) {
                $where['o.id'] = $getPurchaseOrder->row()->id;
            } else {
                $where['o.id'] = '0';
            }
        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $where['o.company_code'] = $post['company_code'];
        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $where['o.branch_code'] = $post['branch_code'];
        }
        if (isset($post['from_date']) && $post['from_date'] != "") {
            $where["date(o.createdon) >="] = date('Y-m-d', strtotime($post['from_date']));
        }
        if (isset($post['toDate']) && $post['toDate'] != "") {
            $where["date(o.createdon) <="] = date('Y-m-d', strtotime($post['toDate']));
        }
        return $where;
    }

    public function orderList(string $id): array
    {
        $this->load->model('Datatables_model');
        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title'] = $this->lang->line('menu_orders');
        $order = $countryUserIds = [];
        $userId = $this->session->userdata("user_id");
        $customerId = $this->session->userdata("cust_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        $where = $searchIds = [];
        $post = [];
        $sessionCompanyCode = $this->session->userdata('company_code');
        $data['list_type'] = "";
        if ($id != "") {
            $listType = 0;
            $excelUploadData = [];
            if ($id == 1 && $sessionCompanyCode == "KNAU") {
                $filedata = @file_get_contents("assets/ordertemplate/excelauuploaddata.txt");
                $excelUploadData = @json_decode($filedata);
                if (!empty($excelUploadData)) {
                    $listType = 1;
                    @file_put_contents("assets/ordertemplate/excelauuploaddata.txt", "");
                    $logs = addordertologs($filedata);
                }
                $data['list_type'] = $listType;
                $data['excel_uploaddata'] = $excelUploadData;
            } else {
                $searchIds = [$id];
                $post['bookingid'] = [];
                $getBookingId = $this->common->gettblrowdata(['id' => $id], "order_id", "tb_orders", 0, 0);
                if (!empty($getBookingId)) {
                    $post['bookingid'] = [$getBookingId['order_id']];
                }
                $data['getbookingid'] = $post['bookingid'];
            }
        }
        $statusSearch = "";
        if (!empty($post)) {
            $where = $this->searchOrders($post);
            $orderStatus = isset($post['status']) ? $post['status'] : "";
            $statusSearch = $orderStatus;
            if ($statusSearch == "") {
                $adOrderStatus = isset($post['order_status']) ? $post['order_status'] : "";
                $statusSearch = $adOrderStatus;
            }
            $searchIds = isset($post['bookingid']) ? $post['bookingid'] : [];
            if (empty($searchIds) && isset($post['container_no']) && !empty($post['container_no'])) {
                $searchIds = $this->GetContainernum();
            } elseif (!empty($searchIds) && isset($post['container_no']) && !empty($post['container_no'])) {
                $containerNumArr = $this->GetContainernum();
                $searchIds = array_intersect($containerNumArr, $searchIds);
            }
            $subCustomers = [];
            if ($this->session->userdata('sub_cust')) {
                $subCustomers = $this->session->userdata('sub_cust');
                if (!empty($subCustomers)) {
                    array_push($subCustomers, $customerId);
                } else {
                    $subCustomers = [$customerId];
                }
            } else {
                $subCustomers = [$customerId];
            }
            $orderData = $this->Order->getorderdata('0', $searchIds, $statusSearch, $customerId, $countryUserIds, $where, $subCustomers);
            foreach ($orderData as $result) {
                $deliveryNote = $containerNo = "";
                $shipmentId = $result['shipment_id'];
                $tripNo = $result['shipmentid'];
                if ($tripNo == '0') {
                    $tripNo = "";
                }
                $shiftId = $result['shift_id'];
                $tripStatus = $result['trip_sts'];
                $otherStatus = $result['order_status'];
                $tripId = $result['trip_id'];
                $createdSource = $result['created_source'];
                $orderStatus = 'PENDING';
                if ($tripId != 0 && $tripStatus == 0) {
                    $orderStatus = 'ACTIVE';
                }
                if ($tripId != 0 && $tripStatus == 1) {
                    $orderStatus = 'CLOSED';
                }
                $orderProperties = new Properties($this->db);
                $otherStatus = $orderProperties->getOtherStatus($result);
                $manifestNo = $deliveryNote = $containerNo = $loadPlanConnote = "";
                $referenceDataArray = [];
                if (isset($result['reference_value'])) {
                    $referenceDataArray = json_decode('[' . $result['reference_value'] . ']', true);
                }
                foreach ($referenceDataArray as $type => $value) {
                    if ($type == "CTR") {
                        $containerNo = $value;
                    } elseif ($type == "DQ") {
                        $deliveryNote = $value;
                    } elseif ($type == "MN") {
                        $manifestNo = $value;
                    } elseif ($type == "LPC") {
                        $loadPlanConnote = $value;
                    }
                }
                $checkDate = '2020-07-01 00:00:00';
                $createdOn = $result['createdon'];
                $orderString = strtotime($createdOn);
                $checkDateString = strtotime($checkDate);
                $earlyPickup = $result['pickup_datetime'] ?? "";
                $earlyDelivery = $result['delivery_datetime'] ?? "";
                $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                if ($orderString > $checkDateString) {
                    if ($earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00") {
                        $ePickup = getdatetimebytimezone($timeZone, $earlyPickup, DFLT_TZ);
                        $earlyPickup = $ePickup['datetime'];
                    }
                    else
                    {
                        $earlyPickup = "";
                    }
                    if ($earlyDelivery != "" && $earlyDelivery != "0000-00-00 00:00:00") {
                        $eDelivery = getdatetimebytimezone($timeZone, $earlyDelivery, DFLT_TZ);
                        $earlyDelivery = $eDelivery['datetime'];
                    }
                    else {
                        $earlyDelivery = "";
                    }
                }
                $order[] = [
                    'order_row_id' => $result['id'],
                    'order_id' => $result['order_id'],
                    'delivery_note' => $deliveryNote,
                    'pickup' => $result['pickup'],
                    'delivery' => $result['delivery'],
                    'trip_no' => $tripNo,
                    'order_status' => $orderStatus,
                    'transport_mode' => $result['transport_mode'],
                    'createdon' => $result['createdon'],
                    'total_packages' => round(floatval($result['totqty'])),
                    'weight' => $result['totwg'],
                    'volume' => $result['totvol'],
                    'company_code' => $result['company_code'],
                    'branch_code' => $result['branch_code'],
                    'department_code' => $result['department_code'],
                    'otherstatus' => $otherStatus,
                    'delivery_date' => $earlyDelivery,
                    'pickup_date' => $earlyPickup,
                    'container_no' => $containerNo,
                    'loadplanconnote' => $loadPlanConnote,
                    'created_source' => $createdSource,
                    'num_of_pallets' => $result['num_of_pallets'],
                    'vendor_id' => $result['vendor_id']
                ];
            }
        }
        return $order;
    }

    public function ajaxListing(): array
    {
        $this->load->model('Datatables_model');
        $draw = $this->input->get('draw', true);
        $start = $this->input->get('start', true);
        $post = $this->input->get();
        $postSearch = "";
        $mainData = [];
        if (isset($post['search'])) {
            $postSearch = $post['search'];
        }
        $recordsFiltered = 0;
        $finalData = '[]';
        $order = $countryUserIds = [];
        $customerId = $this->session->userdata("cust_id");
        $userId = (!empty($customerId)) ? 0 :  $this->session->userdata("user_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        $where = $searchIds = [];
        $statusSearch = "";
        if (!empty($post) && $post['data'] == 1) {
            if ($postSearch != "") {
                $where = $this->searchOrders($postSearch);
            }
            $orderStatus = isset($postSearch['status']) ? $postSearch['status'] : "";
            $statusSearch = $orderStatus;
            $adOrderStatus = isset($postSearch['order_status']) ? $postSearch['order_status'] : "";
            if ($statusSearch == "") {
                $statusSearch = $adOrderStatus;
            }
            $companyCode = $this->session->userdata('company_code');
            $subCustomers = [];
            if ($this->session->userdata('sub_cust')) {
                $subCustomers = $this->session->userdata('sub_cust');
                if (!empty($subCustomers)) {
                    array_push($subCustomers, $customerId);
                } else {
                    $subCustomers = [$customerId];
                }
            } else {
                $subCustomers = [$customerId];
            }
            $shipperOrders = [];
            $searchIds = isset($postSearch['bookingid']) ? $postSearch['bookingid'] : [];
            $searchShipperId = isset($postSearch['searchshipper_id']) ? $postSearch['searchshipper_id'] : "";
            if ($searchShipperId != "") {
                $shipperOrders = $this->Order->getorders_bypartymaster('Shipper', $searchShipperId, $userId, $countryUserIds, $subCustomers, $customerId);
                if (empty($searchIds) && !empty($shipperOrders)) {
                    $searchIds = $shipperOrders;
                } elseif (!empty($searchIds) && !empty($shipperOrders)) {
                    $searchIds = array_intersect($shipperOrders, $searchIds);
                }
            }
            $consigneeOrders = [];
            $searchConsigneeId = isset($postSearch['searchconsignee_id']) ? $postSearch['searchconsignee_id'] : "";
            if ($searchConsigneeId != "") {
                $consigneeOrders = $this->Order->getorders_bypartymaster('Consignee', $searchConsigneeId, $userId, $countryUserIds, $subCustomers, $customerId);
                if (empty($searchIds) && !empty($consigneeOrders)) {
                    $searchIds = $consigneeOrders;
                } elseif (!empty($searchIds) && !empty($consigneeOrders)) {
                    $searchIds = array_intersect($consigneeOrders, $searchIds);
                }
            }
            $excludeCompanyCode = 'Yes';
            if (isset($postSearch['customer_order_references']) && !empty($postSearch['customer_order_references'])) {
                $searchIds = $this->Order->getOrderIdsByReferenceValues($postSearch['customer_order_references']);
            }
            if (empty($searchIds) && isset($postSearch['container_no']) && !empty($postSearch['container_no'])) {
                $searchIds = $this->GetContainernum($postSearch['container_no'], $excludeCompanyCode);
            } elseif (!empty($searchIds) && isset($postSearch['container_no']) && !empty($postSearch['container_no'])) {
                $containerNumArr = $this->GetContainernum($postSearch['container_no'], $excludeCompanyCode);
                $searchIds = array_intersect($containerNumArr, $searchIds);
            }
            $orderIds = $orderNumbers = '';
            if (!empty($searchIds)) {
               // $orderIds = implode(',', $searchIds);
               if(is_array($searchIds)){
                 $tempOrderIdArray = $searchIds;
               }else{
                $tempOrderIdArray[] = $searchIds;
               }
               //print_r($tempOrderIdArray);exit;
                $orderNumbers = $this->getIdByOrderId($tempOrderIdArray);
            }
            $orderTableCondition = [];
            if (!empty($where)) {
                foreach ($where as $key => $value) {
                    $value = "'$value'";
                    if ($key == "date(o.createdon) >=" || $key == "date(o.createdon) <=" || $key == "date(o.pickup_datetime) >=" || $key == "date(o.pickup_datetime) <=") {
                        $orderTableCondition[] = $key . $value;
                    } else {
                        $orderTableCondition[] = $key . ' = ' . $value;
                    }
                }
            }
            $orderTableCondition[] = ' o.status!=0';
            /*if (!empty($searchIds)) {   
                if(is_array($searchIds)){
                $orderSearchIds = implode(',', $searchIds);
                } else{
                    $orderSearchIds = $searchIds;
                }   
               
                if ($orderSearchIds != '') {
                    $orderSearchIds = trim($orderSearchIds, ',');
                    $orderTableCondition[] = " o.order_id in ($orderSearchIds)";
                }
            }*/
            if (!empty($searchIds)) {
                $idsArray = is_array($searchIds) ? $searchIds : explode(',', $searchIds);
            
                $quotedIds = array_map(function($id) {
                    $cleanId = trim($id, " \t\n\r\0\x0B'\""); // Remove surrounding whitespace/quotes
                    return "'" . addslashes($cleanId) . "'";
                }, $idsArray);
            
                $orderSearchIds = implode(',', $quotedIds);
            
                if ($orderSearchIds !== '') {
                    $orderSearchIds = trim($orderSearchIds, ',');
                    $orderTableCondition[] = " o.order_id IN ($orderSearchIds)";
                }
            }
            if ($userId != '0' && $userId != '') {
                if (!empty($countryUserIds)) {
                    $orderSearchCountryIds = (is_array($countryUserIds)) ? implode(',', $countryUserIds) : $countryUserIds ;
                    if ($orderSearchCountryIds != '') {
                        $orderSearchCountryIds = trim($orderSearchCountryIds, ',');
                        $orderTableCondition[] = " o.user_id in ($orderSearchCountryIds)";
                    }
                } else {
                    $orderTableCondition[] = "o.user_id = $userId";
                }
                if (isset($postSearch['searchcustomer_id']) && $postSearch['searchcustomer_id'] != "" && $postSearch['scust_id'] == 0 ) {
                    $get_all_customer_ids = $this->getcustomeridsForCid($postSearch['searchcustomer_id']);
                    if(count($get_all_customer_ids) > 0) {
                        $asd = array_column($get_all_customer_ids, 'id');
                        $cids = join("','", $asd);
                        $orderTableCondition[] = " o.customer_id in ('$cids')";
                    }
                }
            }
            if ($statusSearch == 'PENDING' || $statusSearch == 'SALOG PENDING') {
                $orderTableCondition[] = "o.trip_id = 0 and  o.trip_sts=0";
            } elseif ($statusSearch == 'ACTIVE' || $statusSearch == 'SALOG ACTIVE') {
                $orderTableCondition[] = "  o.trip_id != 0  and  o.trip_sts=0";
            } elseif ($statusSearch == 'CLOSED' || $statusSearch == 'SALOG CLOSED') {
                $orderTableCondition[] = " o.trip_sts = 1 ";
            }
            if ($statusSearch == 'SALOG PENDING' || $statusSearch == 'SALOG ACTIVE' || $statusSearch == 'SALOG CLOSED' || $statusSearch == 'SALOG TO BE BILLED') {
                $orderTableCondition[] = "  o.created_source = '5' ";
            }
            $noordercondition = 0;
            if ($statusSearch == 'SALOG TO BE BILLED') {
                $salogorders = $this->Order->getsalogtobebilled($countryUserIds, $userId, $subCustomers, $customerId);
                if (!empty($salogorders)) {
                    $orderTableCondition[] = " o.order_id in ('" . implode("','", $salogorders) . "') ";
                } else {
                    $noordercondition = 1;
                }
            }
            if ($noordercondition == '1') {
                $orderTableCondition[] = "o.id = 0";
            }
            if (!empty($subCustomers)) {
                $orderSearchSubCusts = implode(',', $subCustomers);
                if ($orderSearchSubCusts != '') {
                    $orderTableCondition[] = "o.customer_id in ($orderSearchSubCusts)";
                }
            } else {
                if ($customerId != "") {
                    $orderTableCondition[] = "o.customer_id = $customerId";
                }
            }
            $ordeIdCondition = '';
            if ($orderNumbers != '') {
                $orderNumbers = trim($orderNumbers, ',');
                $ordeIdCondition = " and order_id in ($orderNumbers) ";
            }
            $wherecondition = $countWherecondition = '';
            if (!empty($orderTableCondition) && sizeof($orderTableCondition) > 0) {
                $implodedConditions = implode(' and ', $orderTableCondition);
                if ($implodedConditions != '') {
                    $wherecondition .= $implodedConditions;
                    $countWherecondition = ' and ' . $implodedConditions;
                }
            }
            $countAndOrderIdQuery = "select group_concat(o.id) as orderIds,count(o.id) as count from tb_orders o
            left join tb_order_details d on o.id=d.order_row_id
            where o.id!=0  $countWherecondition ";
            $compiledOrderIds = $compiledCount = '';
            $resultSet = $this->db->query($countAndOrderIdQuery);
            if ($resultSet->num_rows() > 0) {
                $resdata = $resultSet->result_array();
                if (isset($resdata[0]['count'])) {
                    $compiledCount = $resdata[0]['count'];
                }
                if (isset($resdata[0]['orderIds'])) {
                    $compiledOrderIds = $resdata[0]['orderIds'];
                }
            } else {
                $compiledCount = 0;
            }
            $subQueryOrderCondition = '';
            if ($compiledOrderIds != '') {
                $compiledOrderIds = trim($compiledOrderIds, ',');
                $subQueryOrderCondition = " and order_id in ($compiledOrderIds) ";
            }
            $selectColumns = [
                'o.id',
                'o.order_id',
                'o.pickup_company as pickup',
                'o.delivery_company as delivery',
                'o.pickup_address1',
                'o.delivery_address1',
                'o.shipmentid',
                'o.shipment_id',
                'o.status',
                'o.order_status',
                'o.shift_id',
                'o.trip_sts',
                'o.trip_id',
                'd.order_status as order_detail_status',
                'o.createdon',
                'o.pickup_datetime',
                'o.delivery_datetime',
                'o.transport_mode',
                'sum(c.quantity) as totqty',
                'sum(c.weight) as totwg',
                'sum( c.volume) as totvol',
                'o.company_code',
                'o.branch_code',
                'o.created_source',
                'd.num_of_pallets',
                'o.updatedon',
                'o.user_id',
                'o.drop_endtime',
                'o.pickup_city',
                'o.delivery_city',
                'o.plat',
                'o.plng',
                'pm.house_number as pickUpHouNo',
                'tpm.house_number as dropHouNo',
                'o.vendor_id'
            ];
            //log_message("error","222:".$selectColumns);
            if ($this->session->userdata('company_code') == "AUKN" || $this->session->userdata('company_code') == "KNAU") {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'reference_value',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.pickup_datetime',
                    'o.delivery_datetime',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source',
                    'd.num_of_pallets',
                    'o.vendor_id'
                ];
            } elseif ($this->session->userdata('company_code') == "UKKN") {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source',
                    'o.vendor_id'
                ];
            } else {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source',
                    'o.vendor_id'
                ];
            }
            $tableName = 'tb_orders as o';
            $indexColumn = 'o.id';
            $joinsArray[] = ['table_name' => 'tb_order_details as d', 'condition' => "o.id=d.order_row_id", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_order_cargodetails as c', 'condition' => "o.id=c.order_id AND c.status = 1 ", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tbl_party_master as pm', 'condition' => "o.pickup_partyid=pm.code", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tbl_party_master as tpm', 'condition' => "o.drop_partyid=tpm.code", 'join_type' => 'left'];
            $groupBy = 'o.id';
            $excludeCountQuery = 'Yes';
            $orderbycol = 'o.order_id';
            $sortorder =  $postSearch['sort_type'];
            $getRecordListing = $this->Datatables_model->customerordersdataQuery($selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, '', $groupBy, $excludeCountQuery,'', $orderbycol ,$sortorder);
            if ($excludeCountQuery == 'Yes') {
                $totalRecords = $compiledCount;
                $recordsFiltered = $compiledCount;
            } else {
                $totalRecords = $getRecordListing['recordsTotal'];
                $recordsFiltered = $getRecordListing['recordsFiltered'];
            }
            $recordListing = [];
            $content = '[';
            $i = 0;
            $srNumber = $start;
            if (!empty($getRecordListing)) {
                foreach ($getRecordListing['data'] as $result) {
                    $deliveryNote = $containerNo = $loadPlanConnote = '';
                    $shipmentId = $result->shipment_id;
                    $tripNo = $result->shipmentid;
                    if ($tripNo == '0') {
                        $tripNo = "";
                    }
                    $shiftId = $result->shift_id;
                    $tripStatus = $result->trip_sts;
                    $otherStatus = $result->order_status;
                    $tripId = $result->trip_id;
                    $uid = $result->user_id;
                    $user = $this->db->select("id,country_code")->get_where("tb_users", ["id" => $uid], 1, 0)->row_array();
                    $tz = $this->getUserTimeZone($user['id'], $user['country_code']);
                    $curtz = $tz['timezone'];
                    if($shiftId > 0 && !empty($result->order_id)){
                        $allstopsdistance = $this->getDistanceofallStops($shiftId,$result->order_id,$curtz);
                        $distance = $this->calculatedistancebyorderid->findActualDistanceByOrderId($result->order_id);
                        if($distance == '0 km'){
                            if(!empty($allstopsdistance) && $allstopsdistance != "" ) {
                                $distance = number_format($allstopsdistance) . " km";
                            }else{
                                $dist     =  $this->calculatedistancebyorderid->findPlannedDistanceByOrderId($result->order_id);
                                $distance =  ($dist == 'Route') ? " - " : $dist;
                            }
                        }
                        $border_type = $this->getOrderbordertype($shiftId);
                    }else {
                        if( !empty($result->order_id)){
                            $dist =  $this->calculatedistancebyorderid->findPlannedDistanceByOrderId($result->order_id);
                            $distance =  ($dist == 'Route') ? " - " : $dist;
                            $border_type = "";
                        }                       
                    }

                    $drop_time = ($result->drop_endtime == null) ? '' : $result->drop_endtime;
                    $eta_date = $this->getOrderwiseETA($tripId, $tripStatus, $drop_time, $shiftId, $result->id);
                    if ($eta_date != "") {
                        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                        $getUserTime = getdatetimebytimezone($timeZone, $eta_date, DFLT_TZ);
                        $eta_date = $getUserTime['datetime'];
                    }
                    if( $shiftId != '' && $shiftId != 0 ){
                        $vehicleinfo = $this->getVehicleinfoByShiftid($shiftId);
                        $vehicle_id = !empty($vehicleinfo[0]['registerno']) ? $vehicleinfo[0]['registerno'] : "";
                        $vehicle_type = !empty($vehicleinfo[0]['trucktype']) ? $vehicleinfo[0]['trucktype'] : "";
                    }
                    else{
                        $vehicle_id = "";
                        $vehicle_type = "";
                    }
                    $co2query = $this->db->select("co2kg_ttw")->get_where("tb_co2_orders", array("order_id" => $result->id), 1, 0);
                    if ($co2query->num_rows() > 0) {
                        $co2 = $co2query->row()->co2kg_ttw;
                    }
                    else{
                        $co2 = "";
                    }
                    $dg_goods = $this->checkOrderwiseDggoods($result->id);
                    $otherStatus = strtoupper($result->order_status);

                    if ($otherStatus == "") {
                        $otherStatus = $result->order_detail_status;
                    }
                    if ($otherStatus != 'READY' && $otherStatus != 'INVOICE') {
                        $otherStatus = '';
                    }
                    $deliveryNote = $containerNo = "";
                    $referenceDataArray = [];
                    if (!empty($result->id)) {
                        $referenceQuery = $this->db->query(
                            "SELECT reference_id,ref_value
                            FROM tb_order_references ar where
                            reference_id IN ('DQ','PO') AND status=1 and order_id = ? ",
                            [$result->id]
                        );
                        $newdq = $newpo = [];
                        foreach ($referenceQuery->result_array() as $rdq){
                            if($rdq['reference_id'] == 'DQ'){
                                $newdq[] = $rdq['ref_value'];
                            }
                            else{
                                $newpo[] = $rdq['ref_value'];
                            }
                        }
                        $fimplodedq = implode(",",$newdq);
                        $fimplodepo = implode(",",$newpo);
                        $getReferenceValuedq = explode(",",$fimplodedq);
                        $getReferenceValuepo = explode(",",$fimplodepo);
                        // For Last Known Status Of a order
                        $order_last_status = $this->getOrderLastStatus($result->id,$shiftId);
                        if(is_array($order_last_status) && !empty($order_last_status)){
                            $orderStatus = $order_last_status[0]['status_name'];
                            $status_icons = $order_last_status[0]['status_icon'];
                            $stop_type    = $order_last_status[0]['stop_type'];
                            if(!empty($status_icons)){
                                $status_icon = $order_last_status[0]['status_icon'];
                            }else{
                                $status_icon = "order-pending.svg";
                            }
                        }else {
                            $orderStatus = "-";
                            $status_icon = "order-pending.svg";
                            $stop_type = "";
                        }
                    }
                    if (!empty($referenceDataArray['DQ'])) {
                        $deliveryNote = $referenceDataArray['DQ'];
                    }
                    if (!empty($referenceDataArray['CTR'])) {
                        $containerNo = $referenceDataArray['CTR'];
                    }
                    if (!empty($referenceDataArray['LPC'])) {
                        $orderRowId = $result->id;
                        $bookingId = $result->order_id;
                        $span = '<i class="icon tru-icon-info" style="cursor: pointer;"
                        onmouseover="getallloadplanconnote(' . $orderRowId . ',' . $bookingId . ')"></i>';
                        $loadPlanConnote = $referenceDataArray['LPC'] . " " . $span;
                    }
                    if ($companyCode == "KNAU" && empty($deliveryNote)) {
                        $referencesData = $this->common->gettblrowdata(['order_id' => $result->id, 'reference_id' => 'DQ', 'status' => 1], 'ref_value', 'tb_order_references', 0, 0);
                        if (!empty($referencesData)) {
                            $deliveryNote = $referencesData['ref_value'] ?? "";
                        }
                    }
                    $checkDate = '2020-07-01 00:00:00';
                    $createdOn = $result->createdon;
                    $orderString = strtotime($createdOn);
                    $checkDateString = strtotime($checkDate);
                    $earlyPickup = $result->pickup_datetime;
                    $earlyDelivery = $result->delivery_datetime;
                    $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                    if ($orderString > $checkDateString) {
                        if ($earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00") {
                            $ePickup = getdatetimebytimezone($timeZone, $earlyPickup, DFLT_TZ);
                            $earlyPickup = $ePickup['datetime'];
                            $earlyPickup = date('Y-m-d h:i A', strtotime($earlyPickup));
                        }
                        else {
                            $earlyPickup = "";
                        }
                        if ($earlyDelivery != "" && $earlyDelivery != "0000-00-00 00:00:00") {
                            $eDelivery = getdatetimebytimezone($timeZone, $earlyDelivery, DFLT_TZ);
                            $earlyDelivery = $eDelivery['datetime'];
                            $earlyDelivery = date('Y-m-d h:i A', strtotime($earlyDelivery));
                        }
                        else
                        {
                            $earlyDelivery = "";
                        }
                    }
                    $recordListing[$i]['id'] = $result->id;
                    $recordListing[$i]['order_id'] = $result->order_id;
                    $recordListing[$i]['delivery_note'] = $getReferenceValuedq;
                    $recordListing[$i]['delivery_notepo'] = $getReferenceValuepo;
                    if ($this->session->userdata('company_code') == 'UKKN' || $this->session->userdata('company_code') == 'AUKN') {
                        $recordListing[$i]['container_no'] = $containerNo;
                    }
                    if ($this->session->userdata('company_code') == 'AUKN') {
                        $recordListing[$i]['loadplanconnote'] = $loadPlanConnote;
                    }
                    $recordListing[$i]['pickup'] = $result->pickup;
                    $recordListing[$i]['delivery'] = $result->delivery;
                    $recordListing[$i]['pickUpHouNo'] = $result->pickUpHouNo;
                    $recordListing[$i]['dropHouNo'] = $result->dropHouNo;
                    $recordListing[$i]['pickup_city'] = $result->pickup_city;
                    $recordListing[$i]['delivery_city'] = $result->delivery_city;
                    $recordListing[$i]['pickup_address'] = $result->pickup_address1;
                    $recordListing[$i]['delivery_address'] = $result->delivery_address1;
                    $recordListing[$i]['trip_no'] = $tripNo;
                    $recordListing[$i]['order_status'] = $orderStatus;
                    $recordListing[$i]['status_icon'] = $status_icon;
                    $recordListing[$i]['stop_type'] = $stop_type;
                    $recordListing[$i]['createdon'] = date('Y-m-d', strtotime($result->createdon));
                    //log_message("error","111:".$recordListing);
                    $updatedDate = "";
                    if ($result->updatedon != "" && $result->updatedon != null) {
                        $updatedOn = strtotime($result->updatedon);
                        $days_difference = time() - $updatedOn;
                        $updatedDate = floor($days_difference / (60 * 60 * 24));
                    }
                    $recordListing[$i]['updatedon'] = $updatedDate;


                    if ($companyCode != "AUKN" && $companyCode != "KNAU") {
                        $recordListing[$i]['early_pickup'] = $earlyPickup;
                        $recordListing[$i]['early_delivery'] = $earlyDelivery;
                    }
                    $recordListing[$i]['transport_mode'] = $result->transport_mode;
                    $recordListing[$i]['totqty'] = $result->totqty;
                    if ($companyCode == "AUKN" || $companyCode == "KNAU") {
                        $recordListing[$i]['num_of_pallets'] = $result->num_of_pallets;
                    }
                    $recordListing[$i]['otherstatus'] = $otherStatus;
                    $weight = $volume = '';
                    if ($result->totwg > 0) {
                        if ($companyCode === 'AUKN' || $companyCode === 'KNAU') {
                            $weight = round($result->totwg, 2);
                        } else {
                            $weight = round($result->totwg, 2) . " Kgs";
                        }
                    }
                    if ($result->totvol > 0) {
                        if ($companyCode === 'AUKN' || $companyCode === 'KNAU') {
                            $volume = round($result->totvol, 2);
                        } else {
                            $volume = round($result->totvol, 2) . " Cbm";
                        }
                    }
                    $recordListing[$i]['weight'] = $weight;
                    $recordListing[$i]['volume'] = $volume;
                    $recordListing[$i]['company_code'] = $result->company_code;
                    $recordListing[$i]['vehicle_id'] =   $vehicle_id ;
                    $recordListing[$i]['vehicle_type'] = $vehicle_type;
                    $recordListing[$i]['distance']  = $distance;
                    $recordListing[$i]['eta'] = $eta_date;
                    $recordListing[$i]['plat'] = $result->plat;
                    $recordListing[$i]['plng'] = $result->plng;
                    $recordListing[$i]['co2'] = $co2;
                    $recordListing[$i]['is_dggoods'] = $dg_goods;
                    $recordListing[$i]['border_type']= $border_type;
                    $recordListing[$i]['branch_code'] = $result->branch_code;
                    $recordListing[$i]['status'] = $result->status;
                    $recordListing[$i]['tripId'] = $result->trip_id;
                    $recordListing[$i]['tripStatus'] = $result->trip_sts;
                    $recordListing[$i]['shift_id'] = $result->shift_id;
                    //$recordListing[$i]['vendor_id'] = $result->vendor_id;
                    //$cust_id
                    //log_message("error","aaaa:".$info['customerRowId']);
                    $recordListing[$i]['vendor_name'] = $this->getVendor($result->vendor_id);
                    $recordListing[$i]['show_map'] = $this->getCustomermapStatus($customerId);
                    // log_message("error","4444:");
                    $recordListing[$i]['show_carrier'] = $this->getCustomercarrierStatus($customerId);
                    
                    //log_message("error","12121:".json_encode($recordListing[$i]));
                    $createdSource = $result->created_source;
                    $recordListing[$i]['created_source'] = (new \App\Libraries\OrderCreationSourceHelper())->getOrderSourceName($createdSource);
                    $i++;
                    $srNumber++;
                }
                $finalData = $recordListing;
            } else {
                $finalData = '[]';
            }
            $mainData['draw'] = $draw;
            $mainData['start'] = $start;
            $mainData['recordsTotal'] = $recordsFiltered;
            $mainData['recordsFiltered'] = $recordsFiltered;
            $mainData['data'] = $finalData;
        }
        return $mainData;
    }

    public function ajaxListing2(): array
    {
        $this->load->model('Datatables_model');
        $post = $this->input->post();
        $start = 1;
        $postSearch = "";
        $mainData = [];
        if (isset($post['search'])) {
            $postSearch = $post['search'];
        }
        $recordsFiltered = 0;
        $finalData = [];
        $customerId = $this->session->userdata("cust_id");
        $userId = (!empty($customerId)) ? 0 :  $this->session->userdata("user_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        $where = $searchIds = [];
        $statusSearch = "";
        if (!empty($post)) {
            if ($postSearch != "") {
                $where = $this->searchOrders($postSearch);
            }
            $orderStatus = isset($postSearch['status']) ? $postSearch['status'] : "";
            $statusSearch = $orderStatus;
            $adOrderStatus = isset($postSearch['order_status']) ? $postSearch['order_status'] : "";
            if ($statusSearch == "") {
                $statusSearch = $adOrderStatus;
            }
            $companyCode = $this->session->userdata('company_code');
            $subCustomers = [];
            if ($this->session->userdata('sub_cust')) {
                $subCustomers = $this->session->userdata('sub_cust');
                if (!empty($subCustomers)) {
                    array_push($subCustomers, $customerId);
                } else {
                    $subCustomers = [$customerId];
                }
            } else {
                $subCustomers = [$customerId];
            }
            $shipperOrders = [];
            $searchIds = isset($postSearch['bookingid']) ? $postSearch['bookingid'] : [];
            $searchShipperId = isset($postSearch['searchshipper_id']) ? $postSearch['searchshipper_id'] : "";
            if ($searchShipperId != "") {
                $shipperOrders = $this->Order->getorders_bypartymaster('Shipper', $searchShipperId, $userId, $countryUserIds, $subCustomers, $customerId);
                if (empty($searchIds) && !empty($shipperOrders)) {
                    $searchIds = $shipperOrders;
                } elseif (!empty($searchIds) && !empty($shipperOrders)) {
                    $searchIds = array_intersect($shipperOrders, $searchIds);
                }
            }
            $consigneeOrders = [];
            $searchConsigneeId = isset($postSearch['searchconsignee_id']) ? $postSearch['searchconsignee_id'] : "";
            if ($searchConsigneeId != "") {
                $consigneeOrders = $this->Order->getorders_bypartymaster('Consignee', $searchConsigneeId, $userId, $countryUserIds, $subCustomers, $customerId);
                if (empty($searchIds) && !empty($consigneeOrders)) {
                    $searchIds = $consigneeOrders;
                } elseif (!empty($searchIds) && !empty($consigneeOrders)) {
                    $searchIds = array_intersect($consigneeOrders, $searchIds);
                }
            }
            $excludeCompanyCode = 'Yes';
            if (empty($searchIds) && isset($postSearch['container_no']) && !empty($postSearch['container_no'])) {
                $searchIds = $this->GetContainernum($postSearch['container_no'], $excludeCompanyCode);
            } elseif (!empty($searchIds) && isset($postSearch['container_no']) && !empty($postSearch['container_no'])) {
                $containerNumArr = $this->GetContainernum($postSearch['container_no'], $excludeCompanyCode);
                $searchIds = array_intersect($containerNumArr, $searchIds);
            }
            $orderIds = $orderNumbers = '';
            if (!empty($searchIds) && sizeof($searchIds) > 0) {
                $orderIds = implode(',', $searchIds);
                $orderNumbers = $this->getIdByOrderId($searchIds);
            }
            $orderTableCondition = [];
            if (!empty($where)) {
                foreach ($where as $key => $value) {
                    $value = "'$value'";
                    if ($key == "date(o.createdon) >=" || $key == "date(o.createdon) <=" || $key == "date(o.pickup_datetime) >=" || $key == "date(o.pickup_datetime) <=") {
                        $orderTableCondition[] = $key . $value;
                    } else {
                        $orderTableCondition[] = $key . ' = ' . $value;
                    }
                }
            }
            $orderTableCondition[] = ' o.status!=0';
            if (!empty($searchIds) && sizeof($searchIds) > 0) {
                $orderSearchIds = implode(',', $searchIds);
                if ($orderSearchIds != '') {
                    $orderSearchIds = trim($orderSearchIds, ',');
                    $orderTableCondition[] = " o.order_id in ($orderSearchIds)";
                }
            }
            if ($userId != '0' && $userId != '') {
                if (!empty($countryUserIds)) {
                    $orderSearchCountryIds = (is_array($countryUserIds)) ? implode(',', $countryUserIds) : $countryUserIds ;
                    if ($orderSearchCountryIds != '') {
                        $orderSearchCountryIds = trim($orderSearchCountryIds, ',');
                        $orderTableCondition[] = " o.user_id in ($orderSearchCountryIds)";
                    }
                } else {
                    $orderTableCondition[] = "o.user_id = $userId";
                }
            }
            if ($statusSearch == 'PENDING' || $statusSearch == 'SALOG PENDING') {
                $orderTableCondition[] = "o.trip_id = 0 and  o.trip_sts=0";
            } elseif ($statusSearch == 'ACTIVE' || $statusSearch == 'SALOG ACTIVE') {
                $orderTableCondition[] = "  o.trip_id != 0  and  o.trip_sts=0";
            } elseif ($statusSearch == 'CLOSED' || $statusSearch == 'SALOG CLOSED') {
                $orderTableCondition[] = " o.trip_sts = 1 ";
            }
            if ($statusSearch == 'SALOG PENDING' || $statusSearch == 'SALOG ACTIVE' || $statusSearch == 'SALOG CLOSED' || $statusSearch == 'SALOG TO BE BILLED') {
                $orderTableCondition[] = "  o.created_source = '5' ";
            }
            $noordercondition = 0;
            if ($statusSearch == 'SALOG TO BE BILLED') {
                $salogorders = $this->Order->getsalogtobebilled($countryUserIds, $userId, $subCustomers, $customerId);
                if (!empty($salogorders)) {
                    $orderTableCondition[] = " o.order_id in ('" . implode("','", $salogorders) . "') ";
                } else {
                    $noordercondition = 1;
                }
            }
            if ($noordercondition == '1') {
                $orderTableCondition[] = "o.id = 0";
            }
            if (!empty($subCustomers)) {
                $orderSearchSubCusts = implode(',', $subCustomers);
                if ($orderSearchSubCusts != '') {
                    $orderTableCondition[] = "o.customer_id in ($orderSearchSubCusts)";
                }
            } else {
                if ($customerId != "") {
                    $orderTableCondition[] = "o.customer_id = $customerId";
                }
            }
            $ordeIdCondition = '';
            if ($orderNumbers != '') {
                $orderNumbers = trim($orderNumbers, ',');
                $ordeIdCondition = " and order_id in ($orderNumbers) ";
            }
            $wherecondition = $countWherecondition = '';
            if (!empty($orderTableCondition) && sizeof($orderTableCondition) > 0) {
                $implodedConditions = implode(' and ', $orderTableCondition);
                if ($implodedConditions != '') {
                    $wherecondition .= $implodedConditions;
                    $countWherecondition = ' and ' . $implodedConditions;
                }
            }
            $countAndOrderIdQuery = "select group_concat(o.id) as orderIds,count(o.id) as count from tb_orders o
                left join tb_order_details d on o.id=d.order_row_id
                where o.id!=0  $countWherecondition ";
            $compiledOrderIds = $compiledCount = '';
            $resultSet = $this->db->query($countAndOrderIdQuery);
            if ($resultSet->num_rows() > 0) {
                $resdata = $resultSet->result_array();
                if (isset($resdata[0]['count'])) {
                    $compiledCount = $resdata[0]['count'];
                }
                if (isset($resdata[0]['orderIds'])) {
                    $compiledOrderIds = $resdata[0]['orderIds'];
                }
            } else {
                $compiledCount = 0;
            }
            $subQueryOrderCondition = '';
            if ($compiledOrderIds != '') {
                $compiledOrderIds = trim($compiledOrderIds, ',');
                $subQueryOrderCondition = " and order_id in ($compiledOrderIds) ";
            }
            $selectColumns = [
                'o.id',
                'o.order_id',
                'o.pickup_company as pickup',
                'o.delivery_company as delivery',
                'o.pickup_address1',
                'o.delivery_address1',
                'o.shipmentid',
                'o.shipment_id',
                'o.order_status',
                'o.shift_id',
                'o.trip_sts',
                'o.trip_id',
                'd.order_status as order_detail_status',
                'o.createdon',
                'o.pickup_datetime',
                'o.delivery_datetime',
                'o.transport_mode',
                'sum(c.quantity) as totqty',
                'sum(c.weight) as totwg',
                'sum( c.volume) as totvol',
                'o.company_code',
                'o.branch_code',
                'o.created_source',
                'd.num_of_pallets',
                'o.updatedon'
            ];
            if ($this->session->userdata('company_code') == "AUKN" || $this->session->userdata('company_code') == "KNAU") {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'reference_value',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.pickup_datetime',
                    'o.delivery_datetime',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source',
                    'd.num_of_pallets'
                ];
            } elseif ($this->session->userdata('company_code') == "UKKN") {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source'
                ];
            } else {
                $dataTableSortOrdering = [
                    'o.id',
                    'o.id',
                    'o.order_id',
                    'reference_value',
                    'o.pickup_company',
                    'o.delivery_company',
                    'o.shipmentid',
                    'o.order_status',
                    'd.order_status',
                    'o.createdon',
                    'o.transport_mode',
                    'sum(c.quantity)',
                    'sum(c.weight)',
                    'sum( c.volume)',
                    'o.company_code',
                    'o.branch_code',
                    'o.created_source'
                ];
            }
            $tableName = 'tb_orders as o';
            $indexColumn = 'o.id';
            $joinsArray[] = ['table_name' => 'tb_order_details as d', 'condition' => "o.id=d.order_row_id", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_order_cargodetails as c', 'condition' => "o.id=c.order_id", 'join_type' => 'left'];
            $groupBy = 'o.id';
            $excludeCountQuery = 'Yes';
            $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, '', $groupBy, $excludeCountQuery);
            if ($excludeCountQuery == 'Yes') {
                $totalRecords = $compiledCount;
                $recordsFiltered = $compiledCount;
            } else {
                $totalRecords = $getRecordListing['recordsTotal'];
                $recordsFiltered = $getRecordListing['recordsFiltered'];
            }
            $recordListing = [];
            $i = 0;
            $srNumber = $start;
            if (!empty($getRecordListing)) {
                foreach ($getRecordListing['data'] as $result) {
                    $deliveryNote = $containerNo = $loadPlanConnote = '';
                    $shipmentId = $result->shipment_id;
                    $tripNo = $result->shipmentid;
                    if ($tripNo == '0') {
                        $tripNo = "";
                    }
                    $shiftId = $result->shift_id;
                    $tripStatus = $result->trip_sts;
                    $otherStatus = $result->order_status;
                    $tripId = $result->trip_id;
                    $orderStatus = 'PENDING';
                    if ($tripId != 0 && $tripStatus == 0) {
                        $orderStatus = 'ACTIVE';
                    }
                    if ($tripId != 0 && $tripStatus == 1) {
                        $orderStatus = 'CLOSED';
                    }
                    $otherStatus = strtoupper($result->order_status);
                    if ($otherStatus == "") {
                        $otherStatus = $result->order_detail_status;
                    }
                    if ($otherStatus != 'READY' && $otherStatus != 'INVOICE') {
                        $otherStatus = '';
                    }
                    $deliveryNote = $containerNo = "";
                    $referenceDataArray = [];
                    if (!empty($result->id)) {
                        $referenceQuery = $this->db->query(
                            "SELECT reference_id,ref_value
                            FROM tb_order_references ar where
                            reference_id IN ('DQ','CTR','LPC') AND status=1 and order_id = ?
                            group by order_id,reference_id ",
                            [$result->id]
                        );
                        $getReferenceValue = ($referenceQuery->num_rows() > 0) ? $referenceQuery->result_array() : [];
                        $referenceDataArray = $this->formatReferenceParameters($getReferenceValue);
                    }
                    if (!empty($referenceDataArray['DQ'])) {
                        $deliveryNote = $referenceDataArray['DQ'];
                    }
                    if (!empty($referenceDataArray['CTR'])) {
                        $containerNo = $referenceDataArray['CTR'];
                    }
                    if (!empty($referenceDataArray['LPC'])) {
                        $orderRowId = $result->id;
                        $bookingId = $result->order_id;
                        $span = '<i class="icon tru-icon-info" style="cursor: pointer;"
                        onmouseover="getallloadplanconnote(' . $orderRowId . ',' . $bookingId . ')"></i>';
                        $loadPlanConnote = $referenceDataArray['LPC'] . " " . $span;
                    }
                    if ($companyCode == "KNAU" && empty($deliveryNote)) {
                        $referencesData = $this->common->gettblrowdata(['order_id' => $result->id, 'reference_id' => 'DQ', 'status' => 1], 'ref_value', 'tb_order_references', 0, 0);
                        if (!empty($referencesData)) {
                            $deliveryNote = $referencesData['ref_value'] ?? "";
                        }
                    }
                    $checkDate = '2020-07-01 00:00:00';
                    $createdOn = $result->createdon;
                    $orderString = strtotime($createdOn);
                    $checkDateString = strtotime($checkDate);
                    $earlyPickup = $result->pickup_datetime;
                    $earlyDelivery = $result->delivery_datetime;
                    $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                    if ($orderString > $checkDateString) {
                        if ($earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00") {
                            $ePickup = getdatetimebytimezone($timeZone, $earlyPickup, DFLT_TZ);
                            $earlyPickup = $ePickup['datetime'];
                        }
                        else {
                            $earlyPickup = "";
                        }
                        if ($earlyDelivery != "" && $earlyDelivery != "0000-00-00 00:00:00") {
                            $eDelivery = getdatetimebytimezone($timeZone, $earlyDelivery, DFLT_TZ);
                            $earlyDelivery = $eDelivery['datetime'];
                        }
                        else {
                            $earlyDelivery = "";
                        }
                    }
                    $recordListing[$i]['order_id'] = $result->order_id;
                    $recordListing[$i]['delivery_note'] = $deliveryNote;
                    $recordListing[$i]['pickup'] = $result->pickup;
                    $recordListing[$i]['delivery'] = $result->delivery;
                    $recordListing[$i]['trip_no'] = $tripNo;
                    $recordListing[$i]['order_status'] = $orderStatus;
                    $recordListing[$i]['transport_mode'] = $result->transport_mode;
                    $recordListing[$i]['createdon'] = date('Y-m-d', strtotime($result->createdon));
                    $updatedDate = "";
                    if ($result->updatedon != "" && $result->updatedon != null) {
                        $updatedOn = strtotime($result->updatedon);
                        $days_difference = time() - $updatedOn;
                        $updatedDate = floor($days_difference / (60 * 60 * 24));
                    }
                    $recordListing[$i]['updatedon'] = $updatedDate;
                    $recordListing[$i]['totqty'] = $result->totqty;
                    if ($companyCode == "AUKN" || $companyCode == "KNAU") {
                        $recordListing[$i]['num_of_pallets'] = $result->num_of_pallets;
                    }
                    $weight = $volume = '';
                    if ($result->totwg > 0) {
                        if ($companyCode === 'AUKN' || $companyCode === 'KNAU') {
                            $weight = round($result->totwg, 2);
                        } else {
                            $weight = round($result->totwg, 2) . " Kgs";
                        }
                    }
                    if ($result->totvol > 0) {
                        if ($companyCode === 'AUKN' || $companyCode === 'KNAU') {
                            $volume = round($result->totvol, 2);
                        } else {
                            $volume = round($result->totvol, 2) . " Cbm";
                        }
                    }
                    $recordListing[$i]['weight'] = $weight;
                    $recordListing[$i]['volume'] = $volume;
                    $recordListing[$i]['company_code'] = $result->company_code;
                    $recordListing[$i]['branch_code'] = $result->branch_code;
                    $recordListing[$i]['otherstatus'] = $otherStatus;
                    $recordListing[$i]['delivery_datetime'] = $result->delivery_datetime;
                    $recordListing[$i]['delivery_address'] = $result->delivery_address1;
                    $recordListing[$i]['pickup_datetime'] = $result->pickup_datetime;
                    $recordListing[$i]['pickup_address'] = $result->pickup_address1;
                    if ($this->session->userdata('company_code') == 'UKKN' || $this->session->userdata('company_code') == 'AUKN') {
                        $recordListing[$i]['container_no'] = $containerNo;
                    }
                    if ($this->session->userdata('company_code') == 'AUKN') {
                        $recordListing[$i]['loadplanconnote'] = $loadPlanConnote;
                    }
                    if ($companyCode != "AUKN" && $companyCode != "KNAU") {
                        $recordListing[$i]['early_pickup'] = date('Y-m-d h:i A', strtotime($earlyPickup));
                        $recordListing[$i]['early_delivery'] = date('Y-m-d h:i A', strtotime($earlyDelivery));
                    }
                    $createdSource = $result->created_source;
                    $recordListing[$i]['created_source'] = (new \App\Libraries\OrderCreationSourceHelper())->getOrderSourceName($createdSource);
                    $i++;
                    $srNumber++;
                }
                $finalData = $recordListing;
            } else {
                $finalData = '[]';
            }
            $mainData['start'] = $start;
            $mainData['recordsTotal'] = $recordsFiltered;
            $mainData['recordsFiltered'] = $recordsFiltered;
            $mainData['orderdata'] = $finalData;
        }
        return $mainData;
    }

    private function GetContainernum(string $containerNumber = '', string $excludeCompanyCode = 'No'): array
    {
        $result = [];
        $post = [];
        $post = $this->input->post(null, true);
        if ($containerNumber != '') {
            $post['container_no'] = $containerNumber;
        }
        if (isset($post['container_no']) && $post['container_no'] != "") {
            $userId = $this->session->userdata('user_id');
            $companyCode = $this->session->userdata('company_code');
            $customerId = $this->session->userdata("cust_id");
            $referenceValue = trim($post['container_no']);
            $whereLike = ['r.ref_value' => $referenceValue];
            if ($excludeCompanyCode == 'Yes') {
                $where = ['o.status!=' => '0', 'r.reference_id' => 'CTR', 'r.status' => 1, 'o.customer_id' => $customerId];
            } else {
                $where = ['o.status!=' => '0', 'r.reference_id' => 'CTR', 'r.status' => 1, 'o.company_code' => $companyCode, 'o.customer_id' => $customerId];
            }
            $result = $this->Order->getorderbookingids($where, $whereLike);
            if (!empty($result)) {
                $result = array_column($result, "order_id");
            }
        }
        return $result;
    }

    public function getOrderCargoDetails(): array
    {
        $cargos = [];
        $orderId = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        if ($orderId != "") {
            $query = $this->db->query(
                "SELECT c.id,c.cargo_type,c.length_unit,c.width_unit,c.height_unit,
                c.weight_unit,c.volume_unit,c.secondweight_uom,c.secondvolume_uom,c.goods_description,c.stackable,
                c.grounded,c.splittable,c.dg_goods,o.id as ordcargoid,o.length,o.width,o.height,o.weight,o.second_weight,
                o.volume,o.second_volume,o.volumetric_weight,o.volweight_uom,c.ldm,o.quantity,o.scanned_quantity,
                o.qr_code,o.reference_order_num FROM tb_cargo_details c,tb_order_cargodetails o
                WHERE o.order_id = ? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC",
                [$orderId]
            );
            if ($query->num_rows() > 0) {
                $totalQuantity = count($query->result());
                $i = 0;
                foreach ($query->result() as $result) {
                    $i++;
                    $stackable = 'Off';
                    if ($result->stackable == 0) {
                        $stackable = 'Off';
                    } elseif ($result->stackable == 1) {
                        $stackable = 'On';
                    }
                    $grounded = 'Off';
                    if ($result->grounded == 0) {
                        $grounded = 'Off';
                    } elseif ($result->grounded == 1) {
                        $grounded = 'On';
                    }
                    $splittable = 'Off';
                    if ($result->splittable == 0) {
                        $splittable = 'Off';
                    } elseif ($result->splittable == 1) {
                        $splittable = 'On';
                    }
                    $cargoType = '"' . $result->cargo_type . '"';
                    $goodsDescription = '"' . $result->goods_description . '"';
                    $lengthUnit = '"' . $result->length_unit . '"';
                    $widthUnit = '"' . $result->width_unit . '"';
                    $heightUnit = '"' . $result->height_unit . '"';
                    $weightUnit = '"' . $result->weight_unit . '"';
                    $volumeUnit = '"' . $result->volume_unit . '"';
                    $volweightUom = '"' . $result->volweight_uom . '"';
                    $secondweightUom = '"' . $result->secondweight_uom . '"';
                    $secondvolumeUom = '"' . $result->secondvolume_uom . '"';
                    $scannedQuantity = $result->scanned_quantity;
                    $secondWeight = $result->second_weight;
                    $secondVolume = $result->second_volume;
                    if ($scannedQuantity == "") {
                        $scannedQuantity = 0;
                    }
                    if ($secondVolume == "") {
                        $secondVolume = 0;
                    }
                    if ($secondWeight == "") {
                        $secondWeight = 0;
                    }
                    if ($scannedQuantity == 0) {
                        $alertMessage = "'There is no Labels Scanned for this cargo..!'";
                        $label = '<a href="#" onclick="alert(' . $alertMessage . ')"><span class="icon tru-icon-pdf"></span></a>';
                    } else {
                        $label = '<a href="' . base_url("aulabel/index?order_car_id=" . $result->ordcargoid . "&tot=" . $totalQuantity . "&cargo_row_id=" . $i) . '" target="_blank" title="' . $this->lang->line('print_label') . '"><span class="icon tru-icon-pdf"></span></a>';
                    }
                    $volumetricWeight = $result->volumetric_weight;
                    if ($volumetricWeight == "") {
                        $volumetricWeight = 0;
                    }
                    $ldm = $result->ldm;
                    if ($ldm == "") {
                        $ldm = 0;
                    }
                    $qrCode = $result->qr_code;
                    if (($this->session->userdata('company_code') == "NZKN" || $this->session->userdata('company_code') == "NZPG") && $this->session->userdata('cust_id') != "") {
                        $cargos[] = [
                            'id' => $result->id,
                            'cargo_type' => $result->cargo_type,
                            'quantity' => $result->quantity,
                            'weight' => $result->weight . " " . $result->weight_unit,
                            'volume' => $result->volume . " " . $result->volume_unit,
                        ];
                    } else {
                        $cargos[] = [
                            'cargo_type' => $result->cargo_type,
                            'quantity' => $result->quantity,
                            'weight' => $result->weight . " " . $result->weight_unit,
                            'volume' => $result->volume . " " . $result->volume_unit,
                        ];
                    }
                }
            }
        }
        return $cargos;
    }

    public function getOrderRouteDetails(string $bookingId): array
    {
        $this->db->select("o.id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,v.name");
        $this->db->from("tb_orders o");
        $this->db->join("tb_vendors v", "v.id=o.vendor_id", "LEFT");
        $this->db->where("o.order_id", $bookingId);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }
    public function getOrderStatuses(string $timeZone, string $bookingId, int $shiftId, int $orderRowId = 0, string $companyCode = ''): array
    {
        if($orderRowId >0){
            if($companyCode == ""){
                $companyCode = $this->session->userdata("company_code");
            }
            $result = $this->getStopStatusForOrder(['orderId' => $orderRowId, 'timeZone' => $timeZone, 'orderCompanyCode' => $companyCode]);
        }else{
            $sql = "SELECT
          ts.id,
          ts.shipment_id as shipmentId,
          ts.latitude,
          ts.longitude,
          ts.loc_name,
          ts.stop_id,
          ts.stop_type,
          ts.status_code,
          convertToClientTZ(ts.createdon, ?) as createdon,
          sm.id as status_master_id,
          sm.status_name,
          ts.comment,
          sm.status_icon
        from
          tb_stop_status ts,
          tb_status_master sm,
          tb_employee e
        WHERE
          sm.id = ts.status_id
          AND ts.shipment_id = e.shift_id
          AND e.order_id = ?
          AND ts.shipment_id = ? 
          AND ts.status=1 
          AND (
            ts.stop_detail_id = 0
            OR ts.stop_detail_id = e.id
          )
        GROUP BY
          ts.id
        ORDER BY
          ts.id ASC";
            $getResult = $this->db->query($sql, [$timeZone, $bookingId, $shiftId]);
            $result = $getResult->num_rows() > 0 ? $getResult->result_array() : [];
        }
        return $result;
    }

    public function getOrderStatusDetails(int $orderId): array
    {
        if($orderId != ""){
            $orderData = $this->Order->getordertoedit($orderId);
            $oid = $orderData->row()->order_id;
            $tripinfo = $this->getOrderRouteDetails($oid);
            if(!empty($tripinfo)) {
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $shift_id = $tripinfo['shift_id'];
                $order_row_id = $tripinfo['id'];
                $getLegIds = $this->common->gettbldata(['shift_leg_id' => $shift_id], "id", "tb_shifts", 0, 0);
                if (count($getLegIds) > 1) {
                    foreach ($getLegIds as $eachLine) {
                        $legIds[] = $eachLine['id'];
                    }
                    sort($legIds);
                    for ($i = 0, $iMax = count($legIds); $i < $iMax; $i++) {
                        if ($i == 0) {
                            $status['fistLegId'] = $legIds[$i];
                        } elseif ($i == ($iMax - 1)) {
                            $status['lastLegId'] = $legIds[$i];
                        } else {
                            $status['middleLegIds'][] = $legIds[$i];
                        }
                    }
                }
                $history = [];
                /*$history = $this->statusremappingservice->getnewOrderStatuses([
                    'timeZone' => $curtz,
                    'bookingId' => $oid,
                    'shiftId' => $shift_id,
                    'carrierName' => $tripinfo['name'],
                    'companyCode' => $this->session->userdata('company_code'),
                    'orderRowId' => $order_row_id
                ]);*/

                    $order_query = $this->db->select("o.id,o.latitude,o.longitude,o.status_code,convertToClientTZ(o.createdon, '" . $curtz . "') as status_date,s.status_name,s.status_icon,o.stop_type,o.loc_name")
                    ->join('tb_status_master AS s', 's.id = o.status_id') 
                    ->order_by('o.id','DESC') 
                    ->get_where('tb_stop_status AS o', array('o.order_id' => $orderId,'o.status'=>1));
                    //log_message("error","Q1:".$this->db->last_query());
                    foreach ($order_query->result_array() as $eachStatus) {
                        if($eachStatus['loc_name'] != "") {
                            $locationName = $eachStatus['loc_name'];
                        }
                        else if(!empty($eachStatus['latitude']) && !empty($eachStatus['longitude']) ) {
                            $locationName = getLocationName($eachStatus['latitude'], $eachStatus['longitude']);
                        }
                        else {
                            $locationName = "";
                        }
                    $createdOn = $eachStatus['status_date'];
                    $history[] = [
                        'id' => $eachStatus['id'],
                        'latitude'=>$eachStatus['latitude'],
                        'longitude'=>$eachStatus['longitude'],
                        'loc_name' => $locationName,
                        'stop_id' => "",
                        'stop_type' => $eachStatus['status_type'],
                        'status_code' => $eachStatus['status_code'],
                        'createdon' => $createdOn,
                        'reason' => "",
                        'status_name' => $eachStatus['status_name'],
                        'comment' => "",
                        'status_icon' => $eachStatus['status_icon'],
                    ];
                  }
                  $status["history"] = $history;
                   // log_message("error","history:".json_encode($history));
                /*if (!checkAccessConditions('RELATED_2_NZPG', $this->session->userdata('company_code'))) {
                    $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "D", "doc_type" => 3, "order_id" => $order_row_id, "status" => 1], 1, 0);
                    if ($docs->num_rows() > 0) {
                        $icon_master = $this->db->select("id,status_icon,status_code")->get_where("tb_status_master", ["status_code" => "3060", "status" => 1], 1, 0);
                        $icon = ($icon_master->num_rows() > 0) ? $icon_master->row()->status_icon :  "";
                        $history[] = [
                            'id' => $docs->row()->id,
                            'latitude' =>$docs->row()->latitude,
                            'longitude'=>$docs->row()->longitude,
                            'loc_name' => getLocationName($docs->row()->latitude, $docs->row()->longitude),
                            'stop_id' => $docs->row()->stop_id,
                            'stop_type' => $docs->row()->stop_type,
                            'status_code' => "3060",
                            'createdon' => $docs->row()->createdon,
                            'reason' => "",
                            'status_name' => "ePOD Available",
                            'comment' => "",
                            'status_icon' => $icon
                        ];
                    }
                    $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "P", "doc_type" => 3, "order_id" => $order_row_id, "status" => 1], 1, 0);
                    if ($docs->num_rows() > 0) {
                        $icon_master = $this->db->select("id,status_icon,status_code")->get_where("tb_status_master", ["status_code" => "2490", "status" => 1], 1, 0);
                        $icon = ($icon_master->num_rows() > 0) ? $icon_master->row()->status_icon :  "";
                        $history[] = [
                            'id' => $docs->row()->id,
                            'latitude' =>$docs->row()->latitude,
                            'longitude'=>$docs->row()->longitude,
                            'loc_name' => getLocationName($docs->row()->latitude, $docs->row()->longitude),
                            'stop_id' => $docs->row()->stop_id,
                            'stop_type' => $docs->row()->stop_type,
                            'status_code' => "2490",
                            'createdon' => $docs->row()->createdon,
                            'reason' => "",
                            'status_name' => "Goods Loaded for Delivery",
                            'comment' => "",
                            'status_icon' => $icon
                        ];
                   }
                }
                $status["history"] = $this->sortAssociativeArrayByKey($history, "createdon", "DESC");*/
                
               // log_message("error","Result:".json_encode($status["history"]));
            }
            return $status ?? [];
        }
        else{
            return [];
        }

    }
    function sortAssociativeArrayByKey($array, $key, $direction){
        switch ($direction){
            case "ASC":
                usort($array, function ($first, $second) use ($key) {
                    return $first[$key] <=> $second[$key];
                });
                break;
            case "DESC":
                usort($array, function ($first, $second) use ($key) {
                    return $second[$key] <=> $first[$key];
                });
                break;
            default:
                break;
        }
        return $array;
    }
    public function getStopStatusForOrder(array $info): array
    {
        $intransitAllowedSecurelinkCountries = ['CNKN', 'TWKN', 'SGKN', 'MYKN', 'THKN', 'VNKN', 'IDKN', 'IDNKN', 'PHKN', 'HKKN'];
        $groupByCondition = " ";
        if (!in_array($info['orderCompanyCode'], $intransitAllowedSecurelinkCountries)) {
            $groupByCondition = " GROUP BY ts.status_code ";
        }
        $result = [];
        $checkBookedBySupplier = $this->db->query("SELECT ts.id,ts.shipment_id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,convertToClientTZ(ts.createdon,?) as createdon,ts.reason,sm.status_name,ts.comment,sm.status_icon from tb_stop_status ts,tb_status_master sm WHERE sm.id=ts.status_id AND ts.order_id =? AND ts.status =? AND ts.status_id = ? ORDER BY ts.id ASC LIMIT 1", [$info['timeZone'], $info['orderId'], 1,'9']);
        if($checkBookedBySupplier->num_rows() >0){
            $result[] = [
                'id' => $checkBookedBySupplier->row()->id,
                'latitude' => $checkBookedBySupplier->row()->latitude,
                'longitude' => $checkBookedBySupplier->row()->longitude,
                'loc_name' => $checkBookedBySupplier->row()->loc_name,
                'stop_id' => $checkBookedBySupplier->row()->stop_id,
                'stop_type' => $checkBookedBySupplier->row()->stop_type,
                'status_code' => $checkBookedBySupplier->row()->status_code,
                'createdon' => $checkBookedBySupplier->row()->createdon,
                'reason' => $checkBookedBySupplier->row()->reason,
                'status_name' => $checkBookedBySupplier->row()->status_name,
                'status_icon' => $checkBookedBySupplier->row()->status_icon,
                'comment' => $checkBookedBySupplier->row()->comment,
                'shipmentId' => $checkBookedBySupplier->row()->shipment_id
            ];

        }
        $getStopStatus = $this->db->query("SELECT ts.id,ts.shipment_id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,convertToClientTZ(ts.createdon,?) as createdon,ts.reason,sm.status_name,ts.comment,sm.status_icon from tb_stop_status ts,tb_status_master sm WHERE sm.id=ts.status_id AND ts.order_id =? AND ts.status =? AND ts.status_id != ?" . $groupByCondition . "ORDER BY ts.id ASC", [$info['timeZone'], $info['orderId'], 1,'9']);
        if($getStopStatus->num_rows() >0){
            foreach ($getStopStatus->result_array() as $eachLine) {
                $result[] = [
                    'id' => $eachLine['id'],
                    'latitude' => $eachLine['latitude'],
                    'longitude' => $eachLine['longitude'],
                    'loc_name' => $eachLine['loc_name'],
                    'stop_id' => $eachLine['stop_id'],
                    'stop_type' => $eachLine['stop_type'],
                    'status_code' => $eachLine['status_code'],
                    'createdon' => $eachLine['createdon'],
                    'reason' => $eachLine['reason'],
                    'status_name' => $eachLine['status_name'],
                    'comment' => $eachLine['comment'],
                    'status_icon' => $eachLine['status_icon'],
                    'shipmentId' => $eachLine['shipment_id']
                ];
            }
        }
        return  $result;
    }

    public function getTripLocation(int $tripId, string $receivedOn): array
    {
        $response = [];
        $timeZone = isset($_REQUEST["timezone"]) ? $_REQUEST["timezone"] : "";
        if ($timeZone == "") {
            $timeZone = "Asia/Singapore";
        }
        if ($tripId != null) {
            $speedVal = 1.60934;
            if ($receivedOn == 0 || $receivedOn == "") {
                $query = $this->db->query(
                    "SELECT * FROM (SELECT latitude,longitude,round(speed* ?,2) as speed,
                      battery,bearing as course,convertToClientTZ(`timestamp`, ?) as `timestamp`
                      from tb_rtdrive_locations where trip_id = ?  ORDER BY `timestamp` DESC limit 3) T
                      ORDER BY `timestamp` ASC",
                    [$speedVal, $timeZone, $tripId]
                );
            } else {
                $receivedOn = date("Y-m-d H:i:s", ($receivedOn));
                $query = $this->db->query(
                    "SELECT * FROM (SELECT latitude,longitude,round(speed* ?,2) as speed,
                      battery,bearing as course, convertToClientTZ(`timestamp`, ?) as `timestamp`
                      from tb_rtdrive_locations where trip_id = ? AND `timestamp`> ?
                    ORDER BY `timestamp` DESC limit 3) T ORDER BY `timestamp` ASC",
                    [$speedVal, $timeZone, $tripId, $receivedOn]
                );
            }
            foreach ($query->result() as $row) {
                $response[] = [
                    "lat" => $row->latitude,
                    "lng" => $row->longitude,
                    "speed" => uom_string($row->speed, 'km'),
                    "course" => $row->course,
                    "battery" => $row->battery,
                    "receivedon" => date("Y m,d h:i:s", strtotime($row->timestamp)),
                    "timestamp" => strtotime($row->timestamp)
                ];
            }
            if (count($response) > 0) {
                return [
                    "status" => "1",
                    "data" => $response,
                    "message" => ""
                ];
            } else {
                return [
                    "status" => "0",
                    "data" => $response,
                    "message" => "No data Found!"
                ];
            }
        } else {
            return [
                "status" => "0",
                "data" => $response,
                "message" => "Vehicle sent empty!"
            ];
        }
    }

    public function getCrossBorderStopDetails(int $shiftId, string $currentTimeZone): array
    {
        $shiftIds = $finalTripsArray = [];
        $trips = 0;
        $tripId = [];
        if ($shiftId > 0) {
            $trips = 1;
            $getLegIds = $this->common->gettbldata(['shift_leg_id' => $shiftId], "id", "tb_shifts", 0, 0);
            foreach ($getLegIds as $eachId) {
                $shiftIds[] = $eachId['id'];
            }
            if (!empty($shiftIds)) {
                $getTripIds = $this->common->gettbldata(
                    "shift_id IN (" . implode(",", $shiftIds) . ")
                ",
                    "trip_id,shift_id",
                    "tb_employee",
                    0,
                    0
                );
                if (count($getTripIds) > 0) {
                    for ($i = 0; $i < count($getTripIds); $i++) {
                        if ($getTripIds[$i]['trip_id'] != "") {
                            $tripId[] = $getTripIds[$i]['trip_id'];
                        }
                    }
                }
            }
        }
        if (!empty($tripId)) {
            $tripDetails = $this->db->query(
                "SELECT '' as mode_of_transport ,id,shift_id,driver_id,vehicle_id,
                convertToClientTZ(stime,'" . $currentTimeZone . "') as stime,
                convertToClientTZ(etime,'" . $currentTimeZone . "') as etime,status,
                plat as latitude,plng as longitude from tb_trips where
                id IN ? ",
                [$tripId]
            );
            if ($tripDetails->num_rows() > 0) {
                $result = $tripDetails->result_array();
                return $result;
            }
        }
        return [];
    }

    public function getCrossBorderShipmentlegs(int $shiftId, string $ord_id, string $currentTimeZone): array{
        $shiftIds = [];
        $shfId = [];
        if ($shiftId > 0) {
            $getLegIds = $this->common->gettbldata(['shift_leg_id' => $shiftId], "id", "tb_shifts", 0, 0);

            foreach ($getLegIds as $eachId) {
                $shiftIds[] = $eachId['id'];
            }
            if (!empty($shiftIds)) {
                $getTripIds = $this->common->gettbldata(
                    "shift_id IN (" . implode(",", $shiftIds) . ") and status=1 and order_id = '$ord_id'
                ",
                    "shift_id",
                    "tb_employee",
                    0,
                    0
                );
                if (count($getTripIds) > 0) {
                    foreach ($getTripIds as $eachId) {
                        $shfId[] = $eachId['shift_id'];
                    }
                }
                return $shfId;
            }
        }
        return [];
    }
    public function orderDocumentDetails(): array
    {
        $orderId = $this->input->post("order_id");
        $id = $this->input->post("id");
        $data['ord_type'] = "done";
        $where = "";
        if ($id > 0) {
            $where = " AND ts.order_id=$id ";
        }
        $data['ord_type'] = "done";
        $tripInfo = $this->common->gettblrowdata(["order_id" => $orderId],
            "id,order_id,company_code,
            branch_code,shift_id,trip_id",
            "tb_orders",
            0,
            0);
        if (count($tripInfo) > 0) {
            $timeZone = $_REQUEST["timezone"];
            $data['ord_type'] = $this->input->post("type");
            $shiftId = $tripInfo['shift_id'];
            $data['ship_id'] = $tripInfo['shift_id'];
            $data['trip_id'] = $tripInfo['trip_id'];
            $uploadQuery = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,
                dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $timeZone . "') as createdon,
                ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type
                WHERE ts.shipment_id = ? GROUP BY ts.id",
                [$shiftId]
            );
            $data["pod"] = $uploadQuery;
            $data['order_id'] = $orderId;
            $data['document_types'] = $this->db->select("id,type_name")
                ->get_where("tb_document_types", ["status" => 1])->result_array();
            $data['stops'] = [];
            $stops = $this->db->query(
                "SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e
                       WHERE o.shipment_id=e.shift_id AND e.order_id=?
                       AND o.status=1 AND e.status=1 ORDER BY o.ordernumber ASC",
                [$orderId]
            );

            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
            }
            $data['order'] = (object)$tripInfo;
        }
        return $data;
    }

    function chkTripinfoByOrdertrip(int $order, string $timeZone): array
    {
        $result = [];
        if ($order != "") {
            $query = $this->db->query(
                "SELECT tb_trips.id AS id,shift_id,driver_id,
            vehicle_id,convertToClientTZ(stime,'" . $timeZone . "') AS stime,
            convertToClientTZ(etime,'" . $timeZone . "') AS etime,tb_trips.status AS status,
            dlat AS latitude,dlng AS longitude ,
            mode_of_transport
            FROM tb_trips
            LEFT JOIN `tb_vehicle_master`  ON tb_vehicle_master.id = vehicle_id
            WHERE tb_trips.id= ?  ORDER BY tb_trips.id DESC LIMIT 1",
                [$order]
            );
            if ($query->num_rows() > 0) {
                $result = $query->row_array();
            }
        }
        return $result;
    }

    public function newOrder(): array
    {
        $data = $transport = [];
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        if ($companyCode == 'RUKN') {
            $getTrasnportMode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($getTrasnportMode->num_rows() > 0) {
                foreach ($getTrasnportMode->result() as $result) {
                    $transport[] = ['code' => $result->code, 'name' => $result->name];
                }
            }
        } else {
            $getTrasnportMode = $this->db->select("code,name")->get_where("tb_transportmode", ['status' => 1]);
            if ($getTrasnportMode->num_rows() > 0) {
                foreach ($getTrasnportMode->result() as $result) {
                    $transport[] = ['code' => $result->code, 'name' => $result->name];
                }
            }
        }
        $data['transport'] = $transport;
        $data['company_code'] = $companyCode;
        $data['branch_code'] = $branchCode;
        $pickupDetails = [];
        $customerId = $this->session->userdata('cust_id');
        $orderTypes = [];
        if ($customerId != "") {
            $getPickupDetails = $this->Order->getpickupdetails($customerId);
            if ($getPickupDetails->num_rows() > 0) {
                $pickupDetails = ['id' => $getPickupDetails->row()->id, 'name' => $getPickupDetails->row()->name, 'party_id' => $getPickupDetails->row()->code, 'address' => $getPickupDetails->row()->address, 'pincode' => $getPickupDetails->row()->pincode, 'country' => $getPickupDetails->row()->country];
            }
            $getOrders = $this->db->select("id,type_name")->get_where("tb_order_types", ['customer_id' => $customerId, 'company_code' => $companyCode, 'status' => '1']);
            if ($getOrders->num_rows() > 0) {
                foreach ($getOrders->result() as $result) {
                    $orderTypes[] = ['type_id' => $result->id, 'type_name' => $result->type_name];
                }
            } else {
                $getOrders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $companyCode, "status" => 1]);
                if ($getOrders->num_rows() > 0) {
                    foreach ($getOrders->result() as $result) {
                        $orderTypes[] = ['type_id' => $result->id, 'type_name' => $result->type_name];
                    }
                } else {
                    $getOrders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => 1]);
                    if ($getOrders->num_rows() > 0) {
                        foreach ($getOrders->result() as $result) {
                            $orderTypes[] = ['type_id' => $result->id, 'type_name' => $result->type_name];
                        }
                    }
                }
            }
        } else {
            $getOrders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $companyCode, "status" => 1]);
            if ($getOrders->num_rows() > 0) {
                foreach ($getOrders->result() as $result) {
                    $orderTypes[] = ['type_id' => $result->id, 'type_name' => $result->type_name];
                }
            } else {
                $getOrders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => 1]);
                if ($getOrders->num_rows() > 0) {
                    foreach ($getOrders->result() as $result) {
                        $orderTypes[] = ['type_id' => $result->id, 'type_name' => $result->type_name];
                    }
                }
            }
        }
        $roles = [];
        $query = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $userId . "' AND status=1 GROUP BY name");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $result) {
                $roles[] = ['id' => $result->id, 'name' => $result->name];
            }
        }
        $data['pickup_details'] = $pickupDetails;
        $data['ordertypes'] = $orderTypes;
        $data['roles'] = $roles;
        return $data;
    }

    public function viewOrder($post): array
    {
        $data = [];
        $orderDetails = $shipperDetails = $dropDetails = $pickupDetails = $referenceDetails = [];
        $id = $post['id'];
        $this->load->helper('home');
        if ($post['selected_tab'] == "a_info") {
            if ($id != "") {
                $checkOrder = $this->Order->getordertoedit($id);
                if ($checkOrder->num_rows() > 0) {
                    $transport = $checkOrder->row()->transport_mode;
                    $transportMode = "";
                    if ($transport != "") {
                        $getTranportMode = $this->db->select("name")->get_where("tb_transportmode", ['code' => $transport]);
                        if ($getTranportMode->num_rows() > 0) {
                            $transportMode = $getTranportMode->row()->name;
                        }
                    }
                    $shipmentId = $pickupInst = $deliveryInst = $containerNo = $purchaseOrder = "";
                    $getDeliveryNotes = $this->db->query(
                        "SELECT reference_id,ref_value FROM tb_order_references
                              WHERE order_id = ? AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR','PO')",
                        [$id]
                    );
                    if ($getDeliveryNotes->num_rows() > 0) {
                        foreach ($getDeliveryNotes->result() as $ref) {
                            $referenceId = $ref->reference_id;
                            if ($referenceId == 'DQ') {
                                $shipmentId = $ref->ref_value;
                            }
                            if ($referenceId == 'ORD_DLVINST') {
                                $deliveryInst = $ref->ref_value;
                            }
                            if ($referenceId == 'ORD_PIKINST') {
                                $pickupInst = $ref->ref_value;
                            }
                            if ($referenceId == 'CTR') {
                                $containerNo = $ref->ref_value;
                            }
                            if ($referenceId == 'PO') {
                                $purchaseOrder = $ref->ref_value;
                            }
                        }
                    }
                    $pickupCustomerId = $checkOrder->row()->pickup_custid;
                    $tripId = $checkOrder->row()->trip_id;
                    $tripStatus = $checkOrder->row()->trip_sts;
                    $orderStatus = "PENDING";
                    if ($tripId != 0 && $tripStatus == 0) {
                        $orderStatus = 'ACTIVE';
                    }
                    if ($tripId != 0 && $tripStatus == 1) {
                        $orderStatus = 'CLOSED';
                    }
                    $checkDate = '2020-07-01 00:00:00';
                    $createdOn = $checkOrder->row()->createdon;
                    $orderString = strtotime($createdOn);
                    $checkDateString = strtotime($checkDate);
                    $earlyPickup = $checkOrder->row()->pickup_datetime;

                    $earlyDelivery = $checkOrder->row()->delivery_datetime;
                    $latePickUp = $checkOrder->row()->pickup_endtime;
                    $lateDelivery = $checkOrder->row()->drop_endtime;
                    $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                    if ($orderString > $checkDateString) {
                        if ($earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00") {
                            $ePickup = getdatetimebytimezone($timeZone, $earlyPickup, DFLT_TZ);
                            $earlyPickup = $ePickup['datetime'];
                        }
                        else {
                            $earlyPickup = "";
                        }
                        if ($earlyDelivery != "" && $earlyDelivery != "0000-00-00 00:00:00") {
                            $eDelivery = getdatetimebytimezone($timeZone, $earlyDelivery, DFLT_TZ);
                            $earlyDelivery = $eDelivery['datetime'];
                        }
                        else {
                            $earlyDelivery = "";
                        }
                        if ($latePickUp != "" && $latePickUp != "0000-00-00 00:00:00") {
                            $lpickup = getdatetimebytimezone($timeZone, $latePickUp, DFLT_TZ);
                            $latePickUp = $lpickup['datetime'];
                        }
                        else {
                            $latePickUp = "";
                        }
                        if ($lateDelivery != "" && $lateDelivery != "0000-00-00 00:00:00") {
                            $ldelivery = getdatetimebytimezone($timeZone, $lateDelivery, DFLT_TZ);
                            $lateDelivery = $ldelivery['datetime'];
                        }
                        else {
                            $lateDelivery = "";
                        }
                    }
                    $orderDetails = [
                        'id' => $checkOrder->row()->id,
                        'order_id' => $checkOrder->row()->order_id,
                        'shipment_id' => $shipmentId,
                        'order_status' => $orderStatus,
                        'early_pickup' => $earlyPickup,
                        'early_delivery' => $earlyDelivery,
                        'late_pickup' => $latePickUp,
                        'late_delivery' => $lateDelivery,
                        'product' => $checkOrder->row()->product,
                        'incoterm' => $checkOrder->row()->incoterm,
                        'delivery_note' => $checkOrder->row()->delivery_note,
                        'purchase_order' => $purchaseOrder,
                        'notify_party' => $checkOrder->row()->notify_party,
                        'goods_value' => $checkOrder->row()->goods_value,
                        'lane_reference' => $checkOrder->row()->lane_reference,
                        'distance' => $checkOrder->row()->distance,
                        'customs_required' => $checkOrder->row()->customs_required,
                        'high_cargo_value' => $checkOrder->row()->high_cargo_value,
                        'valorance_insurance' => $checkOrder->row()->valorance_insurance,
                        'temperature_control' => $checkOrder->row()->temperature_control,
                        'company_code' => $checkOrder->row()->company_code,
                        'branch_code' => $checkOrder->row()->branch_code,
                        'department_code' => $checkOrder->row()->department_code,
                        'createdon' => $checkOrder->row()->createdon,
                        'transport_mode' => $transportMode,
                        'container_no' => $containerNo
                    ];
                    $deliveryTerm = "";
                    $pickupId = $checkOrder->row()->customer_id;
                    $orderType = $checkOrder->row()->order_type;
                    $orderDetails['order_type'] = "";

                    $getOrderType = $this->db->select("type_name")->get_where("tb_order_types", ['id' => $orderType, 'status' => '1', 'company_code' => $checkOrder->row()->company_code]);
                    if ($getOrderType->num_rows() > 0) {
                        $orderDetails['order_type'] = $getOrderType->row()->type_name;
                    }
                    $deliveryTermId = $checkOrder->row()->delivery_term;
                    if ($deliveryTermId != "") {
                        $getDeliveryTerm = $this->db->select("term_id,name")->get_where("tb_delivery_terms", ['term_id' => $deliveryTermId]);
                        if ($getDeliveryTerm->num_rows() > 0) {
                            $deliveryTerm = $getDeliveryTerm->row()->term_id . "-" . $getDeliveryTerm->row()->name;
                        }
                    }
                    $service = "";
                    $serviceId = $checkOrder->row()->service;
                    if ($serviceId != "") {
                        $getService = $this->db->select("service_id,name")->get_where("tb_service_master", ['id' => $serviceId]);
                        if ($getService->num_rows() > 0) {
                            $service = $getService->row()->service_id . "-" . $getService->row()->name;
                        }
                    }
                    $orderDetails['service'] = $service;
                    $orderDetails['delivery_term'] = $deliveryTerm;
                    $getPickupDetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", ['status' => 1, 'id' => $pickupId]);
                    if ($getPickupDetails->num_rows() > 0) {
                        $pickupDetails = ['id' => $getPickupDetails->row()->id, 'name' => $getPickupDetails->row()->name, 'party_id' => $getPickupDetails->row()->code, 'address' => $getPickupDetails->row()->address, 'pincode' => $getPickupDetails->row()->pincode, 'country' => $getPickupDetails->row()->country];
                    }
                    $dropId = $checkOrder->row()->drop_custid;
                    $chekParty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.house_number,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
                    if ($chekParty->num_rows() > 0) {
                        foreach ($chekParty->result() as $rr) {
                            $partyType = $rr->party_type;
                            $checkType = $this->db->select("name")->get_where("tbl_party_types", ["id" => $partyType], 1, 0);
                            if ($checkType->num_rows() > 0) {
                                $rowData = $checkType->row();
                                if ($rowData->name == "Consignee") {
                                    $dropDetails = ['name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'houseNO' =>$rr->house_number,'fax' => $rr->fax, 'party_id' => $rr->code];
                                } else {
                                    if ($rowData->name == "Shipper") {
                                        $shipperDetails = ['name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'houseNO' =>$rr->house_number, 'fax' => $rr->fax, 'party_id' => $rr->code];
                                    }
                                }
                            }
                        }
                    }
                    $shipperDetails['name'] = $checkOrder->row()->pickup;
                    $shipperDetails['street'] = $checkOrder->row()->pickup_address1;
                    $shipperDetails['state'] = $checkOrder->row()->pickup_address2;
                    $shipperDetails['city'] = $checkOrder->row()->pickup_city;
                    $shipperDetails['country'] = $checkOrder->row()->pickup_country;
                    $shipperDetails['pincode'] = $checkOrder->row()->pickup_pincode;

                    $dropDetails['name'] = $checkOrder->row()->delivery;
                    $dropDetails['street'] = $checkOrder->row()->delivery_address1;
                    $dropDetails['state'] = $checkOrder->row()->delivery_address2;
                    $dropDetails['city'] = $checkOrder->row()->delivery_city;
                    $dropDetails['country'] = $checkOrder->row()->delivery_country;
                    $dropDetails['pincode'] = $checkOrder->row()->delivery_pincode;

                    $dropId = $checkOrder->row()->drop_custid;
                }
            }
            $data['order_details'] = $orderDetails;
            $data['pickup_details'] = $pickupDetails;
            $data['drop_details'] = $dropDetails;
            $data['reference_details'] = $referenceDetails;
            $data['shipper_details'] = $shipperDetails;
            $data['selected_tab'] = $post['selected_tab'];
        }
        if ($post['selected_tab'] == "a_finance"){
             $data['finance'] = "";
        }
        if ($post['selected_tab'] == "a_status") {
            $data['orderstatus'] = $this->getOrderStatusDetails($id);
        }
        if ($post['selected_tab'] == "a_visualization") {
            $cust_id = $this->session->userdata('cust_id');
            $data['result'][0]["isSimBased"] = "false";
            if ($id != "") {
                $timeZone = isset($_REQUEST["timezone"]) ? $_REQUEST["timezone"] : "";
                if ($timeZone == "") {
                    $timeZone = "Asia/Singapore";
                }
                $order = $this->getOrderId($id);
                $cnt = 0;
                if ($order) {
                    $ordchkqry = $this->db->query(
                        "SELECT id,pickup_city,user_id,order_id,shift_id,
                    trip_id,plat,plng,dlat,dlng,delivery_datetime,trip_sts
                     FROM tb_orders where id = ? LIMIT 1",
                        [$order]
                    );
                    if ($ordchkqry->num_rows() > 0) {
                        $tripid = $ordchkqry->row()->trip_id;
                        $data['result'][$cnt]['id'] = $id;
                        $data['result'][$cnt]['user_id'] = $ordchkqry->row()->user_id;
                        $data['result'][$cnt]['pickup_city'] = $ordchkqry->row()->pickup_city;
                        $data['result'][$cnt]['order_id'] = $ordchkqry->row()->order_id;
                        $data['result'][$cnt]['plat'] = $ordchkqry->row()->plat;
                        $data['result'][$cnt]['plng'] = $ordchkqry->row()->plng;
                        $data['result'][$cnt]['dlat'] = $ordchkqry->row()->dlat;
                        $data['result'][$cnt]['dlng'] = $ordchkqry->row()->dlng;
                        $data['result'][$cnt]['trip_sts'] = $ordchkqry->row()->trip_sts;
                        $data['result'][$cnt]['trip_id'] = $tripid;
                        $data['result'][$cnt]['delivery_datetime'] = $ordchkqry->row()->delivery_datetime;
                        $gateout = $this->db->query("SELECT id,createdon from tb_stop_status  where order_id= ? and status_code= '3000'", [$order]);
                        if($gateout->num_rows() > 0 ){
                            $data['result'][$cnt]['gate_out'] = $gateout->row()->createdon;
                        }
                        else{
                            $data['result'][$cnt]['gate_out'] = '-';
                        }

                        $shipId = $ordchkqry->row()->shift_id;
                        $user_id = $ordchkqry->row()->user_id;
                        $user = $this->db->select("id,country_code")->get_where(
                            "tb_users",
                            ["id" => $user_id],
                            1,
                            0
                        )->row_array();
                        $getTimeZone = $this->getUserTimeZone($user['country_code']);
                        $timeZone = $getTimeZone['timezone'];
                        $data['result'][$cnt]["timezone"] = $timeZone;
                        $data['result'][$cnt]["trip"] = [];
                        $currentDate = date("Y-m-d");
                        if ($tripid > 0) {
                            $tripArray[] = $this->chkTripinfoByOrdertrip($tripid, $timeZone);
                        } else {
                            $tripArray = $this->getCrossBorderStopDetails($shipId, $timeZone);
                        }
                        if(!empty($shipId)) {
                            $shfArray = $this->getCrossBorderShipmentlegs($shipId, $ordchkqry->row()->order_id, $timeZone);
                            $query_legs = false;
                            if (!empty($shfArray) && $shfArray != '') {
                                $query_legs = $this->db->query(
                                    "SELECT tbs.id AS shipment_id,tbs.slat as plat,tbs.slng as plng,tbs.elat as dlat,tbs.elng as dlng,tbs.shipmentid as leg_id,tbs.scity AS source,
                                tbs.dcity AS desitination ,tbs.units AS units,tbs.weight AS weight,
                                tss.status_code,tsm.status_name,
                                CASE WHEN tss.status_code = 0218 THEN 'CLOSED'
                                WHEN (tss.status_code = 2300 OR tss.status_code = 3000) THEN 'COMPLETED'
                                WHEN tss.status_code = 1550 THEN 'IN TRANSIT'
                                ELSE 'ACTIVE' END AS progress,tbs.transport_mode as transport_mode,
                                tbs.startdate,tbs.enddate
                                FROM tb_shifts AS tbs
                                JOIN tb_stop_status AS tss ON tss.shipment_id = tbs.id
                                JOIN tb_status_master AS tsm on tsm.id = tss.status_id
                                WHERE tbs.id IN ? and tss.id IN ( SELECT max(tsss.id) from tb_stop_status as tsss where tsss.shipment_id = tbs.id)
                                group by tss.id
                                ORDER BY tbs.id  ASC ", [$shfArray]
                                );
                            }
                            if ($query_legs!= FALSE && $query_legs->num_rows() > 0) {
                                $data['result'][$cnt]["shipment_data_count"] = $query_legs->num_rows();
                                $data['result'][$cnt]["shipment_data"] = $query_legs->result();
                                $data['result'][$cnt]['show_map'] = $this->getCustomermapStatus($cust_id);
                                 //log_message("error","3333:");
                                $data['result'][$cnt]["show_carrier"] = $this->getCustomercarrierStatus($cust_id);
                               /* $raw_stops = $this->db->select("id,stopname,plat,plng,stopcity,address,stoptype,convertToClientTZ(startdate,'" . $timeZone . "') as startdate,
                                 convertToClientTZ(enddate,'" . $timeZone . "') as enddate,shipment_id,weight,volume,ship_units,status,ordernumber")
                                    ->from('tb_shiporder_stops AS o')
                                    ->where_in('shipment_id',$shfArray)->where('status',1)->order_by('id','ASC')->get();*/
                                $raw_stops = $this->db->select("
                                    o.id,
                                    o.stopname,
                                    o.plat,
                                    o.plng,
                                    o.stopcity,
                                    o.address,
                                    o.stoptype,
                                    convertToClientTZ(o.startdate,'Asia/Kolkata') as startdate,
                                    convertToClientTZ(o.enddate,'Asia/Kolkata') as enddate,
                                    o.shipment_id,
                                    o.weight,
                                    o.volume,
                                    o.ship_units,
                                    o.status,
                                    o.ordernumber,
                                    ts.transport_mode")
                                    ->from('tb_shiporder_stops as o')
                                    ->join('tb_shifts as ts', 'ts.id = o.shipment_id', 'left')
                                    ->where_in('o.shipment_id', $shfArray)
                                    ->where('o.status', 1)
                                    ->order_by('o.id', 'asc')
                                    ->get();
                                $stopsarray = [];
                                foreach($raw_stops->result_array() as $stops){
                                    $stoparray[] = array(
                                        "id"=>$stops['id'],
                                        "stopname"=>$stops['stopname'],
                                        "plat"=>$stops['plat'],
                                        "plng"=>$stops['plng'],
                                        "stopcity" => $stops['stopcity'],
                                        "address" =>$stops['address'],
                                        "stoptype" => $stops['stoptype'],
                                        "startdate"=> $stops['startdate'],
                                        "enddate" => $stops['enddate'],
                                        "shipment_id"=> $stops['shipment_id'],
                                        "weight"=> $stops['weight'],
                                        "volume"=> $stops['volume'],
                                        "ship_units"=> $stops['ship_units'],
                                        "status"=> $stops['status'],
                                        "ordernumber" => $stops['ordernumber'],
                                        "transport_mode" => $stops['transport_mode']
                                    );
                                }
                                $sort_array = $this->super_unique($stoparray,'plat');
                                $data['result'][$cnt]["records"] = $sort_array;

                            } else {
                                $query_trip = $this->db->query(
                                    "SELECT tbs.id AS shipment_id,tbs.slat as plat,tbs.slng as plng,tbs.elat as dlat,tbs.elng as dlng,tbs.shipmentid as leg_id,tbs.scity AS source,
                            tbs.dcity AS desitination ,tbs.units AS units,tbs.weight AS weight,
                            tss.status_code,tsm.status_name,
                            CASE WHEN tss.status_code = 0218 THEN 'CLOSED'
                            WHEN (tss.status_code = 2300 OR tss.status_code = 3000) THEN 'COMPLETED'
                            WHEN tss.status_code = 1550 THEN 'IN TRANSIT'
                            ELSE 'ACTIVE' END AS progress,tbs.transport_mode as transport_mode,
                            tbs.startdate,tbs.enddate
                            FROM tb_shifts AS tbs
                            JOIN tb_stop_status AS tss ON tss.shipment_id = tbs.id
                            JOIN tb_status_master AS tsm on tsm.id = tss.status_id
                            WHERE tbs.id = ? and tss.order_id = ?
                            group by tss.id
                            ORDER BY tss.id  DESC LIMIT 1 ", [$shipId,$order]
                                );
                                if($query_trip->num_rows() > 0) {
                                    $data['result'][$cnt]["shipment_data_count"] = $query_trip->num_rows();
                                    $data['result'][$cnt]["shipment_data"] = $query_trip->result();
                                    $data['result'][$cnt]["show_map"] = $this->getCustomermapStatus($cust_id);
                                     //log_message("error","2222:");
                                    $data['result'][$cnt]["show_carrier"] = $this->getCustomercarrierStatus($cust_id);
                                }else{
                                    $query_trip_ind_order = $this->db->query(
                                        "SELECT tbs.id AS shipment_id,tbs.slat as plat,tbs.slng as plng,tbs.elat as dlat,tbs.elng as dlng,tbs.shipmentid as leg_id,tbs.scity AS source,
                            tbs.dcity AS desitination ,tbs.units AS units,tbs.weight AS weight,
                            tss.status_code,tsm.status_name,
                            CASE WHEN tss.status_code = 0218 THEN 'CLOSED'
                            WHEN (tss.status_code = 2300 OR tss.status_code = 3000) THEN 'COMPLETED'
                            WHEN tss.status_code = 1550 THEN 'IN TRANSIT'
                            ELSE 'ACTIVE' END AS progress,tbs.transport_mode as transport_mode,
                            tbs.startdate,tbs.enddate
                            FROM tb_shifts AS tbs
                            JOIN tb_stop_status AS tss ON tss.shipment_id = tbs.id
                            JOIN tb_status_master AS tsm on tsm.id = tss.status_id
                            WHERE tbs.id = ? and tss.shipment_id = ? and tss.status_code = ?
                            group by tss.id
                            ORDER BY tss.id  DESC LIMIT 1 ", [$shipId,$shipId,'0212']
                                    );
                                    $data['result'][$cnt]["shipment_data_count"] = $query_trip_ind_order->num_rows();
                                    $data['result'][$cnt]["shipment_data"] = $query_trip_ind_order->result();
                                    $data['result'][$cnt]["show_map"] = $this->getCustomermapStatus($cust_id);
                                    // log_message("error","1111:");
                                    $data['result'][$cnt]["show_carrier"] = $this->getCustomercarrierStatus($cust_id);
                                }
                                /*$raw_stops = $this->db->select("id,stopname,plat,plng,stopcity,address,stoptype,convertToClientTZ(startdate,'" . $timeZone . "') as startdate,
                                 convertToClientTZ(enddate,'" . $timeZone . "') as enddate,shipment_id,weight,volume,ship_units,status,ordernumber")
                                 ->order_by('id','ASC')
                                 ->get_where('tb_shiporder_stops AS o', array('shipment_id' => $shipId,'status'=>1));*/
                                $raw_stops = $this->db->select("
                                    o.id,
                                    o.stopname,
                                    o.plat,
                                    o.plng,
                                    o.stopcity,
                                    o.address,
                                    o.stoptype,
                                    convertToClientTZ(o.startdate,'Asia/Kolkata') as startdate,
                                    convertToClientTZ(o.enddate,'Asia/Kolkata') as enddate,
                                    o.shipment_id,
                                    o.weight,
                                    o.volume,
                                    o.ship_units,
                                    o.status,
                                    o.ordernumber,
                                    to.transport_mode")
                                    ->from('tb_shiporder_stops as o')
                                    ->join('tb_orders as to', 'to.shift_id = o.shipment_id', 'left')
                                    ->where_in('o.shipment_id', $shipId)
                                    ->where('o.status', 1)
                                    ->order_by('o.id', 'asc')
                                    ->get();
                                $stopsarray = [];
                                foreach($raw_stops->result_array() as $stops){
                                    $stoparray[] = array(
                                        "id"=>$stops['id'],
                                        "stopname"=>$stops['stopname'],
                                        "plat"=>$stops['plat'],
                                        "plng"=>$stops['plng'],
                                        "stopcity" => $stops['stopcity'],
                                        "address" =>$stops['address'],
                                        "stoptype" => $stops['stoptype'],
                                        "startdate"=> $stops['startdate'],
                                        "enddate" => $stops['enddate'],
                                        "shipment_id"=> $stops['shipment_id'],
                                        "weight"=> $stops['weight'],
                                        "volume"=> $stops['volume'],
                                        "ship_units"=> $stops['ship_units'],
                                        "status"=> $stops['status'],
                                        "ordernumber" => $stops['ordernumber'],
                                        "transport_mode" => $stops['transport_mode']
                                    );
                                }
                                $sort_array = $this->super_unique($stoparray,'plat');
                                $data['result'][$cnt]["records"] = $sort_array;

                            }
                        }
                        else{
                            $data['result'][$cnt]["shipment_data_count"] = '';
                            $data['result'][$cnt]["shipment_data"] = [];
                            $data['result'][$cnt]["show_carrier"] = "";
                        }
                        /*for Actual Paths*/
                        $tripinfo_gateoutdate = $this->common->chkOrderinfoBygateoutdate($ordchkqry->row()->id, $timeZone);
                        $locationsWhereCondition = "";
                        if($tripinfo_gateoutdate != ""){
                            $locationsWhereCondition = " and timestamp <='".$tripinfo_gateoutdate."' ";
                        }

                        /*end here*/
                        if (!empty($tripArray) && count($tripArray[0])) {
                            /*for actual Path*/
                            $getPickupGateIn = $this->common->gettblrowdata(['order_id'=>$ordchkqry->row()->id,'status_code'=>'0420','status'=>'1'], "createdon", "tb_stop_status", 0, 0);
                            if(!empty($getPickupGateIn)){
                                $locationsWhereCondition .= " and timestamp >='".$getPickupGateIn['createdon']."' ";
                            }
                            /*end*/
                            foreach ($tripArray as $tripInfo) {
                                $data['result'][$cnt]["trip_id"] = $tripId = $tripInfo['id'];
                                $data['result'][$cnt]["trip"] = $trip = $tripInfo;
                                $data['result'][$cnt]['mode_of_transport'] = $tripInfo['mode_of_transport'];
                                $driverId = $tripInfo['driver_id'];
                                $shipId = $tripInfo['shift_id'];
                                $data['result'][$cnt]["actual_records"] = $this->db->query("SELECT latitude,longitude,`timestamp` from tb_rtdrive_locations where trip_id = ? ".$locationsWhereCondition." ORDER BY `timestamp` ASC",[$tripId]);
                                //$data['result'][$cnt]["actual_records"] = $this->db->query("SELECT latitude,longitude,`timestamp` from tb_rtdrive_locations where trip_id = '579128' and timestamp <='2022-01-23 05:50:28' and timestamp >='2022-01-17 04:40:36' ORDER BY `timestamp` ASC");
                                 $data['result'][$cnt]["status"]  = $this->getOrderStatusDetailsForMaps($id);
                                $data['result'][$cnt]["pings"] = $data['result'][$cnt]["actual_records"]->num_rows();

                                $data['result'][$cnt]["drivers"] = [];
                                $drivers = $this->db->query(
                                    "SELECT d.id,d.name,d.contact_num,
                                convertToClientTZ(td.createdon,'" . $timeZone . "') as createdon,
                                d.track_type,td.travelled_km from tb_trip_drivers td
                                LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE
                                td.trip_id = ? AND td.status =? GROUP BY d.id ORDER
                                BY td.createdon ASC",
                                    [$tripId, '1']
                                );
                                if ($drivers != FALSE && $drivers->num_rows() > 0) {
                                    $data['result'][$cnt]["drivers"] = $drivers->result_array();
                                    if ($drivers->num_rows() > 0) {
                                        if (isset($data['result'][$cnt]["drivers"][count($data['result'][$cnt]["drivers"]) - 1]["track_type"])) {
                                            if ($data['result'][$cnt]["drivers"][count($data['result'][$cnt]["drivers"]) - 1]["track_type"] == "1") {
                                                $data['result'][$cnt]["isSimBased"] = "true";
                                            }
                                        }
                                    }
                                } else {
                                    $stime = $tripInfo['stime'];
                                    $drivers1 = $this->db->query(
                                        "SELECT id,name,contact_num,
                                    ? as createdon,track_type,'0' as travelled_km
                                    FROM tb_truck_drivers WHERE id = ? LIMIT 1",
                                        [$stime, $driverId]
                                    );
                                    if ($drivers1->num_rows() > 0) {
                                        $data['result'][$cnt]["drivers"] = $drivers1->result_array();
                                        if (isset($data['result'][$cnt]["drivers"][count($data['result'][$cnt]["drivers"]) - 1]["track_type"])) {
                                            if ($data['result'][$cnt]["drivers"][count($data['result'][$cnt]["drivers"]) - 1]["track_type"] == "1") {
                                                $data['result'][$cnt]["isSimBased"] = "true";
                                            }
                                        }
                                    }
                                }
                                $select = "td.register_number,td.latitude,td.longitude,td.speed,td.battery,td.receivedon as timestamp, o.shipmentid as shipmentid";
                                $table = "tb_trips tr";
                                $where = "td.id='" . $tripInfo['vehicle_id'] . "' AND tr.id='" . $tripInfo["id"] . "' AND o.order_id='" . $ordchkqry->row()->order_id . "'";
                                $vehicle = $this->common->getvehicledata($select, $table, $where);
                                $data["vehicles"] = [];
                                if (!empty($vehicle)) {
                                    $data["vehicle"] = $data['result'][$cnt]["triprecord"] = $vehicle;
                                }
                                $cnt++;
                            }
                        }else{
                            $data['result'][$cnt]["pings"] = [];
                            $data['result'][$cnt]["actual_records"] = [];
                        }
                    }
                }
            }
        }
        return $data;
    }
    public function super_unique($array,$key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;

    }

    private function getUserTimeZone(string $companyCode): array
    {
        $getQuery = $this->db->query(
            "SELECT country_code,cntry_timezone,cntry_hrs,currency
                FROM tbl_country_master WHERE (country_code=? OR country_name=?)
                AND status=? LIMIT 1", [$companyCode, $companyCode, 1]
        );
        $result = ["currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG"];
        if ($getQuery->num_rows() > 0) {
            $rowData = $getQuery->row();
            $result = [
                "currency" => $rowData->currency,
                "timezone" => $rowData->cntry_timezone,
                "hrs" => $rowData->cntry_hrs,
                'country' => $rowData->country_code
            ];
        }
        return $result;
    }

    private function getIdByOrderId(array $ids): string
    {
        if (empty($ids)) {
            return '';
        }
        try {
            $query = "SELECT group_concat(id) as order_numbers FROM tb_orders WHERE order_id in ?";
            $result = $this->db->query($query, [$ids])->row();
           // echo $this->db->last_query();exit;
            return isset($result->order_numbers) ? $result->order_numbers : '';
        } catch (Exception $e) {
            return '';
        }
    }

    private function getOrderId(string $orderId): string
    {
        $orderIdCount = $this->db->select("id")->get_where("tb_orders", ["id" => $orderId], 1, 0)->num_rows();
        if ($orderIdCount > 0) {
            return $orderId;
        } else {
            $orderIdQuery = $this->db->select("id")->get_where("tb_orders", ["order_id" => $orderId], 1, 0);
            if ($orderIdQuery->num_rows() > 0) {
                return $orderIdQuery->row()->id;
            } else {
                $orderIdQuery = $this->db->query(
                    "SELECT order_id from tb_order_references
                    where ref_value= ? AND status=1",
                    [$orderId]
                );
                if ($orderIdQuery->num_rows() > 0) {
                    return $orderIdQuery->row()->order_id;
                } else {
                    return '';
                }
            }
        }
    }

    public function getOtherReferenceDetails() : array {
        $post = $this->input->post(NULL,TRUE);
        $orderId = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "";
        $type = isset($post['type']) ? $this->db->escape_str($post['type']) : "";
        $referenceIds = isset($post['ref_ids']) ? $this->db->escape_str($post['ref_ids']) : array();
        $getReferenceRows = 0;
        $referencesArray = $referenceIdArray = [];
        $whr = "";
        $action = "";
        if ($orderId != "") {
            $getReferenceQuery = $this->db->query("SELECT r.id,r.name,r.description,o.order_shortNo,
                o.id as order_ref_id,o.reference_id,o.ref_value as order_value FROM tb_reference_master r,
                tb_order_references o WHERE o.order_id = ? AND o.reference_id =r.name
                AND r.status= ? AND o.status= ? GROUP BY o.id ORDER BY r.createdon DESC",[$orderId,1,1]);
            $getReferenceRows = $getReferenceQuery->num_rows();
        } else {
            $whr = "";
            if ($referenceIds != "") {
                $referenceIdArray = implode(',', $referenceIds);
                if (!empty($referenceIdArray)) {
                    $whr .= " AND r.id IN (" . $referenceIdArray . ") ";
                }
            }
            if (!empty($referenceIdArray)) {
                $getReferenceQuery = $this->db->query("SELECT r.id,r.name,r.description,o.order_shortNo,
                    o.id as order_ref_id,o.ref_value as order_value FROM tb_reference_master r,
                    tb_order_references o WHERE r.name=o.reference_id
                    AND  o.status=? AND r.status = ? $whr GROUP BY r.id ORDER BY r.createdon DESC",[1,1]);
                $getReferenceRows = $getReferenceQuery->num_rows();
            }
        }
        if ($getReferenceRows > 0) {
            foreach ($getReferenceQuery->result() as $res) {
                $orderShortNo = $res->order_shortNo;
                if ($type == 'popup') {
                    $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs' onclick='editpopupreferencedetails(" . $res->id . "," . $res->order_ref_id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs' onclick='deletepopupreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                } else {
                    if ($orderId != "") {
                        $info = array('id' => $res->id, 'name' => htmlentities($res->name,ENT_QUOTES), 'desc' => htmlentities($res->description,ENT_QUOTES), 'value' => htmlentities($res->order_value, ENT_QUOTES));
                        $info = htmlentities(json_encode($info));
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='editreferencedetails(this," . $info . ")'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletereferencedetailsbyorder(" . $res->id . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRefAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Reference</a></li>";
                    } else {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    }
                }
                $resultValue = $res->order_value;
                if ($resultValue != "") {
                    if (DateTime::createFromFormat('Y-m-d H:i:s', $resultValue) !== FALSE) {
                        $chkrtime = getdatetimebytimezone($this->session->userdata('usr_tzone')['timezone'], $resultValue, DFLT_TZ);
                        $resultValue = $chkrtime['datetime'];
                    } else {
                        $resultValue = $resultValue;
                    }
                }
                $referencesArray[] = array(
                    'id' => $res->name,
                    'name' => $res->description,
                    'value' => $resultValue,
                    'order_shortNo' => $orderShortNo,
                    'action' => $action
                );
            }
        }
        return $referencesArray;
    }

    public function getOrderLastStatus($orderId,$shiftId)
    {
        if ($orderId != '') {
            $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
            $result = [];
            $sql = "SELECT tsr.id,sm.status_name, tsr.status_code,sm.status_icon,
            convertToClientTZ(tsr.createdon, '" . $currentTimeZone . "') as status_date,tsr.stop_type
            FROM tb_stop_status tsr
            inner join tb_status_master sm on sm.id=tsr.status_id
            WHERE tsr.order_id in
            (?) ORDER by tsr.id DESC  LIMIT 1";
            $res = $this->db->query($sql, $orderId);
            if ($res->num_rows() > 0) {
                foreach ($res->result_array() as $eachStatus) {
                   $result[] = [
                       "status_name"=> $eachStatus['status_name'],
                       "status_icon"=> $eachStatus['status_icon'],
                       "status_date"=> $eachStatus['status_date'],
                       "stop_type" =>  $eachStatus['stop_type']
                ];
                }
            }
            else{
                if(!empty($shiftId) && $shiftId != 0 ) {
                $sql = "SELECT tsr.id,sm.status_name, tsr.status_code,sm.status_icon,
                convertToClientTZ(tsr.createdon, '" . $currentTimeZone . "') as status_date,tsr.stop_type
                FROM tb_stop_status tsr
                inner join tb_status_master sm on sm.id=tsr.status_id
                WHERE tsr.shipment_id in
                (?)  and tsr.status_code = ? ORDER by tsr.id DESC  LIMIT 1";
                    $res2 = $this->db->query($sql, [$shiftId,'0212']);
                    if ($res2->num_rows() > 0) {
                        foreach ($res2->result_array() as $eachStatus) {
                            $result[] = [
                                "status_name"=> $eachStatus['status_name'],
                                "status_icon"=> $eachStatus['status_icon'],
                                "status_date"=> $eachStatus['status_date'],
                                "stop_type" =>  $eachStatus['stop_type']
                            ];
                        }
                    }
                }
            }

            $sql1 = "SELECT tsr.id,sm.status_name, tsr.status_code,sm.status_icon,
                convertToClientTZ(tsr.status_date, '" . $currentTimeZone . "') as status_date,tsr.status_type
                FROM tb_order_status tsr
                inner join tb_status_master sm on sm.id=tsr.status_id
                WHERE tsr.order_id in
                (?) ORDER by tsr.id DESC  LIMIT 1";
            $res1 = $this->db->query($sql1, $orderId);
            foreach ($res1->result_array() as $eachStatus) {
                $result[] = [
                    "status_name"=> $eachStatus['status_name'],
                    "status_icon"=> $eachStatus['status_icon'],
                    "status_date"=> $eachStatus['status_date'],
                    "stop_type" =>  $eachStatus['status_type']
                ];
            }

            if (!checkAccessConditions('RELATED_2_NZPG', $this->session->userdata('company_code'))) {
                $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $currentTimeZone . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "D", "doc_type" => 3, "order_id" => $orderId, "status" => 1], 1, 0);
                if ($docs->num_rows() > 0) {
                    $icon_master = $this->db->select("id,status_icon,status_code")->get_where("tb_status_master", ["status_code" => "3060", "status" => 1], 1, 0);
                    $icon = ($icon_master->num_rows() > 0) ? $icon_master->row()->status_icon :  "";
                    $result[] = [
                        "status_name"=> "ePOD Available",
                        "status_icon"=> $icon,
                        "status_date"=> $docs->row()->createdon,
                        "stop_type" =>  $docs->row()->stop_type
                    ];
                }
                $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $currentTimeZone . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "P", "doc_type" => 3, "order_id" => $orderId, "status" => 1], 1, 0);
                if ($docs->num_rows() > 0) {
                    $icon_master = $this->db->select("id,status_icon,status_code")->get_where("tb_status_master", ["status_code" => "2490", "status" => 1], 1, 0);
                    $icon = ($icon_master->num_rows() > 0) ? $icon_master->row()->status_icon :  "";
                    $result[] = [
                        "status_name"=> "Goods Loaded for Delivery",
                        "status_icon"=> $icon,
                        "status_date"=> $docs->row()->createdon,
                        "stop_type" =>  $docs->row()->stop_type
                    ];
                }
            }
            $result = $this->sortAssociativeArrayByKey($result, "status_date", "DESC");

            return $result;
        }else {
            return [];
        }
    }
    public function getCustomerebookingStatus($customerId){
        if ($customerId != '') {
            $sql = "SELECT count(tpr.id) as ecount FROM `tb_customers` tc left JOIN
            tbl_party_master tpm on tpm.code = tc.code and tpm.company_code = tc.company_code and tpm.branch_code= tc.branch_code left JOIN
            tb_party_reference tpr on tpr.partner_id = tpm.id
            WHERE tc.id= ? and tpr.name = 'eBooking' and tpr.value like 'y%' and tpr.status='1'";
            $res = $this->db->query($sql, $customerId);
            if($res) {
                $count_array = $res->row_array();
                $count = $count_array['ecount'];
                if ($count == 0) {
                    return 0;
                } else {
                    return 1;
                }
            }else{
                return 0;
            }
        }
        else{
            return 0;
        }
    }

    private function getOrderStatusDetailsForMaps(int $id): array
    {
        if (checkAccessConditions('RELATED_2_TW_CN', $this->session->userdata('company_code'))) {
            $this->load->model('Order');
            $orderStatusCodes = $this->getOrderStatusCodes($id);
            $statusCodes = [];
            $isPickUpDone = 'No';
            $isOrderDelivered = 'No';
            $isOrderHasIntransitPoint = 'No';
            if (!empty($orderStatusCodes)) {
                foreach ($orderStatusCodes as $code) {
                    $statusCodes[] = $code['status_code'];
                }
                if (in_array('0500', $statusCodes)) {
                    $isPickUpDone = 'Yes';
                }
                if (in_array('3000', $statusCodes)) {
                    $isOrderDelivered = 'Yes';
                }
                if (in_array('1550', $statusCodes)) {
                    $isOrderHasIntransitPoint = 'Yes';
                }
            }
            $data['isPickUpDone'] = $isPickUpDone;
            $data['isOrderDelivered'] = $isOrderDelivered;
            $data['isOrderHasIntransitPoint'] = $isOrderHasIntransitPoint;
        }
        else{
            $data = [];
        }
        return $data;
    }
    public function getOrderStatusCodes(int $orderId): array
    {
        $where = "status=1 and order_id=".$orderId." and status_code!=''";
        $this->db->select("distinct(status_code)");
        $this->db->from("tb_stop_status");
        $this->db->where($where);
        $this->db->order_by('createdon');
        $qry = $this->db->get();
        return $qry->num_rows() > 0 ? $qry->result_array() : [];
    }

    public function getCustomerfinanceStatus($customerId){
        if ($customerId != '') {
            $sql = "SELECT count(tpr.id)  as ecount FROM `tb_customers` tc left JOIN
            tbl_party_master tpm on tpm.code = tc.code and tpm.company_code = tc.company_code and tpm.branch_code= tc.branch_code left JOIN
            tb_party_reference tpr on tpr.partner_id = tpm.id
            WHERE tc.id= ? and tpr.name = 'show Finance' and tpr.value like 'y%' and tpr.status='1'";
            $res = $this->db->query($sql, $customerId);
            if($res) {
                $count_array = $res->row_array();
                $count = $count_array['ecount'];
                if ($count == 0) {
                    return 0;
                } else {
                    return 1;
                }
            }else {
                return 0;
            }
        }
        else{
            return 0;
        }
    }
    public function getCustomermapStatus($customerId){
        if ($customerId != '') {
            $sql = "SELECT count(tpr.id)  as ecount FROM `tb_customers` tc left JOIN
            tbl_party_master tpm on tpm.code = tc.code and tpm.company_code = tc.company_code and tpm.branch_code= tc.branch_code left JOIN
            tb_party_reference tpr on tpr.partner_id = tpm.id
            WHERE tc.id= ? and tpr.name = 'Show Map' and tpr.value like 'y%' and tpr.status='1'";
            $res = $this->db->query($sql, $customerId);
            //log_message("error","query222:".$this->db->last_query());
            if($res) {
                $count_array = $res->row_array();
                $count = $count_array['ecount'];
                if ($count == 0) {
                    return 0;
                } else {
                    return 1;
                }
            }else {
                return 0;
            }
        }
        else{
            return 0;
        }
    }

    public function getCustomercarrierStatus($customerId){
        if ($customerId != '') {
            $sql = "SELECT count(tpr.id)  as ecount FROM `tb_customers` tc left JOIN
            tbl_party_master tpm on tpm.code = tc.code and tpm.company_code = tc.company_code and tpm.branch_code= tc.branch_code left JOIN
            tb_party_reference tpr on tpr.partner_id = tpm.id
            WHERE tc.id= ? and tpr.name = 'Show Carrier' and tpr.value like 'y%' and tpr.status='1'";
            $res = $this->db->query($sql, $customerId);
            //log_message("error","query111:".$this->db->last_query());
            if($res) {
                $count_array = $res->row_array();
                $count = $count_array['ecount'];
                if ($count == 0) {
                    return 0;
                } else {
                    return 1;
                }
            }else {
                return 0;
            }
        }
        else{
            return 0;
        }
    }

    public function enableTabsBySwitches(array $info): array
    {
        $getPartnerId = $this->db->query("SELECT m.id FROM tbl_party_master m,tb_customers c WHERE c.code =m.code AND m.company_code = c.company_code AND m.branch_code = c.branch_code AND c.id =? AND c.company_code = ? AND m.status = ?", [$info['customerRowId'], $info['companyCode'], 1]);
        $partnerData = $getPartnerId->num_rows() > 0 ? $getPartnerId->row_array() : [];
        if (empty($partnerData)) {
            return [];
        }
        $noRates = [];
        $partnerId = $partnerData['id'];
        $checkSwitches = $this->db->query("SELECT p.value,t.name FROM tb_party_reference p,tb_reference_types t WHERE p.partner_id = ? AND p.reference_type =t.id AND t.name IN ? AND p.status = ? AND t.status = ? ", [$partnerId, ['Show Quotes', 'Show Services', 'DG Cargo Allowed', 'Show All Rates','Show Map'], 1, 1]);
        $switchesData = $checkSwitches->num_rows() > 0 ? $checkSwitches->result_array() : [];
        foreach ($switchesData as $eachLine) {
            if ($eachLine['name'] == "Show All Rates") {
                if (in_array($eachLine['value'], ['NO', 'N', 'n', 'No', 'no'])) {
                    $noRates[] = $eachLine['name'];
                }
            } elseif (in_array($eachLine['value'], ['Yes', 'Y', 'y', 'yes', 'YES'])) {
                $response[] = $eachLine['name'];
            }
        }
        if (empty($noRates)) {
            $response[] = 'Show All Rates';
        }
        return $response ?? [];
    }

    public function getXborderCountries(string $companyCode): array
    {
        $xborderCode = "";
        $dbXborderCountries = [];
        if (checkAccessConditions('RELATED_2_CROSSBORDER', $companyCode)) {
            $this->db->select("xborder_code");
            $this->db->from("tb_xborder_country");
            $this->db->where("company_code", $companyCode);
            $getxborder_cntry = $this->db->get();
            if ($getxborder_cntry->num_rows() > 0) {
                $xborderCode = $getxborder_cntry->row()->xborder_code;
            }
            if (strlen($xborderCode) > 0) {
                $dbXborderCountries = explode(",", $xborderCode);
            }
        }
        $dbXborderCountries[] = $companyCode;
        return $dbXborderCountries;
    }

    public function getPartyTypesByGivenPostData(array $customerCodes, array $postData, string $companyCode): array
    {
        $partyTypes = $postData['type'] ?? [];
        $shipperCode = $postData['shipperCode'] ?? "";
        if (empty($customerCodes) || empty($partyTypes)) {
            return [];
        }
        $partyName = $queryArray = $masterIds = [];
        $dbXborderCountries = $this->getXborderCountries($companyCode);
        $queryString = "SELECT
       m.id,m.name,m.email,m.mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.address,m.country,m.state,m.street,m.pincode,m.party_types,m.latitude,m.longitude,m.fax,t.id as partytype_id,t.name as role,m.house_number FROM tbl_party_master m LEFT JOIN tbl_party_types t ON t.id=m.party_type_id WHERE t.name IN ? AND ";
        $queryParams = [$partyTypes];
        if ($shipperCode != "") {
            $queryString .= "m.code LIKE ? AND ";
            $queryParams[] = "%" . $shipperCode . "%";
        }
        $queryString .= "m.customer_code IN ? AND m.company_code IN ? AND m.status =? ";
        $queryParams[] = $customerCodes;
        $queryParams[] = $dbXborderCountries;
        $queryParams[] = "1";

        $getDataByPartyTypeId = $this->db->query($queryString, $queryParams);
        $masterResultData = $getDataByPartyTypeId->num_rows() > 0 ? $getDataByPartyTypeId->result_array() : [];
        foreach ($masterResultData as $eachLine) {
            $masterIds[] = $eachLine['id'];
            $inputField = "<input type='radio' name='partylist' id='partylist_" . $eachLine['id'] . "' class='partylistclass' onchange='selectpartylist(" . $eachLine['id'] . ")' data-name='" . $eachLine['name'] . "' data-email='" . $eachLine['email'] . "' data-street='" . $eachLine['street'] . "' data-city='" . $eachLine['city'] . "' data-state='" . $eachLine['state'] . "' data-mobile='" . $eachLine['mobile'] . "' data-country='" . strtoupper(
                    $eachLine['country']
                ) . "' data-pincode='" . $eachLine['pincode'] . "' data-code='" . $eachLine['code'] . "' data-company_code='" . $eachLine['company_code'] . "' data-branch_code='" . $eachLine['branch_code'] . "' data-fax='" . $eachLine['fax'] . "' data-latitude='" . $eachLine['latitude'] . "' data-house_number='" . $eachLine['house_number'] . "' data-longitude='" . $eachLine['longitude'] . "' data-role='" . strtoupper($eachLine['role']) . "' value='" . $eachLine['id'] . "'>";
            $result[] = [
                'inputField' => $inputField,
                'id' => $eachLine['id'],
                'name' => $eachLine['name'],
                'email' => $eachLine['email'],
                'street' => $eachLine['street'],
                'city' => $eachLine['city'],
                'state' => $eachLine['state'],
                'mobile' => $eachLine['mobile'],
                'house_number' => $eachLine['house_number'],
                'address' => $eachLine['address'],
                'country' => $eachLine['country'],
                'pincode' => $eachLine['pincode'],
                'code' => $eachLine['code'],
                'company_code' => $eachLine['company_code'],
                'branch_code' => $eachLine['branch_code'],
                'fax' => $eachLine['fax'],
                'partytype_id' => $eachLine['partytype_id'],
                'role' => $eachLine['role'],
                'latitude' => $eachLine['latitude'],
                'longitude' => $eachLine['longitude']
            ];
        }
        $getPartyIds = $this->db->query("SELECT id,name from tbl_party_types WHERE name IN ? AND company_code IN ? AND status = ? ", [$partyTypes, $dbXborderCountries, 1]);
        $partyTypeResultIds = $getPartyIds->num_rows() > 0 ? $getPartyIds->result_array() : [];
        foreach ($partyTypeResultIds as $eachLine) {
            $partyTypeIds[] = $eachLine['id'];
            $partyName[$eachLine['id']] = $eachLine['name'];
        }
        if (empty($partyTypeIds)) {
            return $result ?? [];
        }
        $queryString = "SELECT m.id,m.name,m.email,m.mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.address,m.country,m.state,m.street,m.pincode,m.party_types,m.latitude,m.longitude,m.fax,m.house_number FROM tbl_party_master m WHERE ";
        if (!empty($masterIds)) {
            $queryString .= " m.id NOT IN ? AND ";
            $queryArray[] = $masterIds;
        }
        if ($shipperCode != "") {
            $queryString .= "m.code LIKE ? AND ";
            $queryArray[] = "%" . $shipperCode . "%";
        }
        $queryString .= " m.customer_code IN ? AND m.company_code IN ? AND m.status =? ";
        $queryArray[] = $customerCodes;
        $queryArray[] = $dbXborderCountries;
        $queryArray[] = '1';
        $getAdditionalData = $this->db->query($queryString, $queryArray);
        $getAdditionalResultData = $getAdditionalData->num_rows() > 0 ? $getAdditionalData->result_array() : [];
        foreach ($getAdditionalResultData as $eachLine) {
            $dbPartyTypes = $eachLine['party_types'];
            if ($dbPartyTypes != "" && $dbPartyTypes != '0') {
                $partyTypesArray = explode(',', $dbPartyTypes);
                if (end($partyTypesArray) == "") {
                    array_pop($partyTypesArray);
                }
                foreach ($partyTypesArray as $eachId) {
                    if (in_array($eachId, $partyTypeIds, true) && !in_array($eachLine['id'], $masterIds, true)) {
                        $masterIds[] = $eachLine['id'];
                        $partyName = $partyName[$eachId] ?? $partyTypes[0];
                        $inputField = "<input type='radio' name='partylist' id='partylist_" . $eachLine['id'] . "' class='partylistclass' onchange='selectpartylist(" . $eachLine['id'] . ")' data-name='" . $eachLine['name'] . "' data-email='" . $eachLine['email'] . "' data-street='" . $eachLine['street'] . "' data-city='" . $eachLine['city'] . "' data-state='" . $eachLine['state'] . "' data-mobile='" . $eachLine['mobile'] . "' data-country='" . strtoupper(
                                $eachLine['country']
                            ) . "' data-pincode='" . $eachLine['pincode'] . "' data-code='" . $eachLine['code'] . "' data-company_code='" . $eachLine['company_code'] . "' data-branch_code='" . $eachLine['branch_code'] . "' data-fax='" . $eachLine['fax'] . "' data-latitude='" . $eachLine['latitude'] . "' data-longitude='" . $eachLine['longitude'] . "' data-house_number='" . $eachLine['house_number'] . "' data-role='" . strtoupper($partyName) . "' value='" . $eachLine['id'] . "'>";
                        $result[] = [
                            'inputField' => $inputField,
                            'id' => $eachLine['id'],
                            'name' => $eachLine['name'],
                            'email' => $eachLine['email'],
                            'street' => $eachLine['street'],
                            'city' => $eachLine['city'],
                            'state' => $eachLine['state'],
                            'mobile' => $eachLine['mobile'],
                            'house_number' => $eachLine['house_number'],
                            'address' => $eachLine['address'],
                            'country' => $eachLine['country'],
                            'pincode' => $eachLine['pincode'],
                            'code' => $eachLine['code'],
                            'company_code' => $eachLine['company_code'],
                            'branch_code' => $eachLine['branch_code'],
                            'fax' => $eachLine['fax'],
                            'partytype_id' => $eachId,
                            'role' => $partyName,
                            'latitude' => $eachLine['latitude'],
                            'longitude' => $eachLine['longitude']
                        ];
                    }
                }
            }
        }
        return $result ?? [];
    }

 public function getVehicleinfoByShiftid(int $shiftid):array
 {
        if(!empty($shiftid)){
            // need to add login for multi-leg case
            $multi_legs_query = $this->db->select("id")->from("tb_shifts")->where("shift_leg_id",$shiftid)->get();
            if($multi_legs_query->num_rows() >= 1 ){
                $mlid = [];
                $multi_leg_ids = $multi_legs_query->result_array();
                foreach($multi_leg_ids as $mid){
                    $mlid[] = $mid['id'];
                }
                $this->db->select("s.id,ts.status_code");
                $this->db->from("tb_shifts s");
                $this->db->join('tb_stop_status ts', 's.id = ts.shipment_id');
                $this->db->where("ts.status_code",'3000');
                $this->db->where_in("s.id",$mlid);
                $getmleg_info = $this->db->get();
                if($getmleg_info->num_rows() > 0) {
                    $curr_shiftid = $getmleg_info->row()->id;
                }
                else{
                    $curr_shiftid = $shiftid;
                }
            }else {
                $curr_shiftid = $shiftid;
            }
                $this->db->select("ttd.register_number,ttt.trucktype");
                $this->db->from("tb_shft_veh tsv");
                $this->db->join('tb_trucks_data ttd', 'ttd.id = tsv.vehicle_id');
                $this->db->join('tb_trucktypes ttt', 'ttt.id = ttd.truck_type');
                $this->db->where("tsv.shft_id", $curr_shiftid);
                $getvehicle_info = $this->db->get();
                if ($getvehicle_info->num_rows() > 0) {
                    $register_number = $getvehicle_info->row()->register_number;
                    $truck_type = $getvehicle_info->row()->trucktype;
                    $result[] = [
                        'registerno' => $register_number,
                        'trucktype' => $truck_type,
                    ];
                }
                return $result ?? [];
        }
        else{
            return [];
        }
 }
    public function secondsTimeSpanToHMS($s) {
        $t = round($s);
        $days = floor($t/86400);
        $day_sec = $days*86400;
        $h = floor( ($t-$day_sec) / (60 * 60) );
        $hour_sec = $h*3600;
        $m = floor((($t-$day_sec)-$hour_sec)/60);
        $min_sec = $m*60;
        $s = (($t-$day_sec)-$hour_sec)-$min_sec;
        return $h." : ".($m <10 ? '0'.$m : $m)." : ".($s < 10 ? '0'.round($s,0) : round($s,0));
    }

    public function etaDateforShift(int $orderId, string $statusCode): array
    {
        if ($orderId > 0) {
            $query = $this->db->query("SELECT id,status_code,createdon FROM tb_stop_status WHERE order_id = ? AND status_code = ? AND status = ? ORDER By id DESC limit 1", [$orderId, $statusCode, '1']);
            if ($query->num_rows() > 0) {
                $result = ['status_code' => $query->row()->status_code, 'eta_date' => $query->row()->createdon];
            }
        }
        return $result ?? [];
    }

    public function getOrderwiseETA(int $tripId, int $tripStatus, string $droptime, int $shiftId, int $orderId): string
    {
        if ($tripId == 0) {
            $checkMultilegs = $this->db->query("SELECT id FROM tb_shifts WHERE shift_leg_id = ?", [$shiftId]);
            if ($checkMultilegs->num_rows() == 0) {
                //log_message("error", "line-2906");
                return $droptime;
            }
        }
        if ($tripStatus == 0) {
            $order_status_eta = $this->etaDateforShift($orderId, '1550');
            $eta_date = $order_status_eta['eta_date'] ?? $droptime;
        }
        if ($tripStatus == 1) {
            $order_status_eta = $this->etaDateforShift($orderId, '3000');
            $eta_date = $order_status_eta['eta_date'] ?? $droptime;
        }
        return $eta_date ?? "";
    }

    public function getDistanceofallStops(int $shiftId, string $order_id, string $curtz) : string {
        if(!empty($shiftId) && !empty($order_id) && !empty($curtz)) {
            $shipmentorderstopsArray = $this->getAllShipmentOrderStops($shiftId, $order_id, $curtz);
            $getorderstops = $this->getOrderShipmentstops($shipmentorderstopsArray, $order_id);
            $smple_distance = [];
            if(!empty($getorderstops)) {
                $pcount = count($getorderstops);
                for ($i = 0; $i < $pcount; $i++) {
                    if ($i < ($pcount - 1)) {
                        $s_lat = $getorderstops[$i]['lat'];
                        $s_lng = $getorderstops[$i]['lng'];
                        $d_lat = $getorderstops[$i + 1]['lat'];
                        $d_lng = $getorderstops[$i + 1]['lng'];
                        if ($s_lat && $s_lng && $d_lat && $d_lng) {
                            $s_distance = distancemetrixship($s_lat, $s_lng, $d_lat, $d_lng);
                            if($s_distance['disttext'] != 'Route') {
                                $smple_distance[] = [
                                    "stop_distance" => $s_distance['disttext']
                                ];
                            }
                        }
                    }
                }
                $scount = (is_array($smple_distance)) ? count($smple_distance) : 0 ;
                $total_distance = 0;
                for ($i = 0; $i < $scount; $i++) {
                    if($smple_distance[$i]['stop_distance'] != '' && !empty($smple_distance[$i]['stop_distance'])) {
                        $dist_uom = substr($smple_distance[$i]['stop_distance'], -2);
                        if (strtolower($dist_uom) == 'km') {
                            $total_dist = str_replace(" km", "", $smple_distance[$i]['stop_distance']);
                            $total_dist = str_replace(",", "", $total_dist);
                            $total_dist = (float)$total_dist;
                        } else {
                            $total_dist_of_uom = str_replace(" m", "", $smple_distance[$i]['stop_distance']);
                            $total_dist_of_uom = str_replace(",", "", $total_dist_of_uom);
                            $total_dist_of_uom = (float)$total_dist_of_uom;
                            $total_dist = $total_dist_of_uom / 1000;
                        }
                        $total_distance += $total_dist;
                    }
                }
                return $total_distance ?? "";
            }
            else{
                return "";
            }
        }
        else{
            return "";
        }
    }

    public function getAllShipmentOrderStops(int $shiftid ,string $orderid, string $timezone ):array{
        if(!empty($shiftid) && !empty($orderid)){
          $shfArray = $this->getCrossBorderShipmentlegs($shiftid, $orderid, $timezone);
          if(!empty($shfArray)){
              $raw_stops = $this->db->select("id,stopname,plat,plng,stopcity,address,stoptype,convertToClientTZ(startdate,'" . $timezone . "') as startdate,
                                 convertToClientTZ(enddate,'" . $timezone . "') as enddate,shipment_id,weight,volume,ship_units,status,ordernumber")
                  ->from('tb_shiporder_stops AS o')
                  ->where_in('shipment_id',$shfArray)->where('status',1)->order_by('id','ASC')->get();
              $stopsarray = [];
              foreach($raw_stops->result_array() as $stops){
                  $stoparray[] = array(
                      "id"=>$stops['id'],
                      "stopname"=>$stops['stopname'],
                      "plat"=>$stops['plat'],
                      "plng"=>$stops['plng'],
                      "stopcity" => $stops['stopcity'],
                      "stoptype" => $stops['stoptype'],
                      "shipment_id"=> $stops['shipment_id'],
                      "status"=> $stops['status'],
                      "ordernumber" => $stops['ordernumber']
                  );
              }
              $sort_array = $this->super_unique($stoparray,'plat');
              return $sort_array;
          }
          else{
              $raw_stops = $this->db->select("id,stopname,plat,plng,stopcity,address,stoptype,convertToClientTZ(startdate,'" . $timezone . "') as startdate,
                                 convertToClientTZ(enddate,'" . $timezone . "') as enddate,shipment_id,weight,volume,ship_units,status,ordernumber")
                  ->order_by('id','ASC')
                  ->get_where('tb_shiporder_stops AS o', array('shipment_id' => $shiftid,'status'=>1));
              $stopsarray = [];
              foreach($raw_stops->result_array() as $stops){
                  $stoparray[] = array(
                      "id"=>$stops['id'],
                      "stopname"=>$stops['stopname'],
                      "plat"=>$stops['plat'],
                      "plng"=>$stops['plng'],
                      "stopcity" => $stops['stopcity'],
                      "stoptype" => $stops['stoptype'],
                      "shipment_id"=> $stops['shipment_id'],
                      "status"=> $stops['status'],
                      "ordernumber" => $stops['ordernumber']
                  );
              }
              $sort_array = $this->super_unique($stoparray,'plat');
              return $sort_array;
          }
      }
      else {
          return [];
      }
    }

    public function  getOrderShipmentstops( array $data, string $orderid ):array{
        if(!empty($data)) {
            $plat = $plng = $dlat = $dlng = "";
            $this->db->select("id,plat,plng,dlat,dlng");
            $this->db->from("tb_orders");
            $this->db->where("order_id", $orderid);
            $order_Data = $this->db->get();
            if ($order_Data->num_rows() > 0) {
                $plat = $order_Data->row()->plat;
                $plng = $order_Data->row()->plng;
                $dlat = $order_Data->row()->dlat;
                $dlng = $order_Data->row()->dlng;
            }
            $checkOrdersPickup = $drop_count = 0;
            $stops_array = $data;
            foreach ($stops_array as $i => $eachstop) {
                if ($eachstop['stoptype'] == 'D') {
                    $drop_count++;
                }
            }
            if ($drop_count == 1) {
                $stops_array = $this->CustomerOrder->sortAssociativeArrayByKey($stops_array, "stoptype", "DESC");
            }
            if (isset($stops_array)) {
                foreach ($stops_array as $i => $eachlocation) {
                    if ($drop_count == 1) {
                        if ($plat == $eachlocation['plat'] && $plng == $eachlocation['plng'] && $eachlocation['stoptype'] == 'P') {
                            $checkOrdersPickup = 1;
                        }
                        if ($checkOrdersPickup > 0) {
                            $pickup[] = array(
                                "lat"=>$eachlocation['plat'],
                                "lng"=>$eachlocation['plng']
                            );
                            if ($dlat == $eachlocation['plat'] && $dlng == $eachlocation['plng']) {
                                break;
                            }
                        }
                    } else {
                        $pickup[] = array(
                            "lat"=>$eachlocation['plat'],
                            "lng"=>$eachlocation['plng']
                        );
                        if ($dlat == $eachlocation['plat'] && $dlng == $eachlocation['plng']) {
                            break;
                        }
                    }
                }
            }
            return $pickup ?? [] ;
        }
        else{
            return [];
        }
    }
    public function getCustomerco2Status($customerId){
        if ($customerId != '') {
            $sql = "SELECT count(tpr.id)  as ecount FROM `tb_customers` tc left JOIN
            tbl_party_master tpm on tpm.code = tc.code and tpm.company_code = tc.company_code and tpm.branch_code= tc.branch_code left JOIN
            tb_party_reference tpr on tpr.partner_id = tpm.id
            WHERE tc.id= ? and tpr.name = 'CO2 Emission' and tpr.value like 'y%' and tpr.status='1'";
            $res = $this->db->query($sql, $customerId);
            $count_array = $res->row_array();
            if(!empty($count_array)) {
                $count = ($count_array['ecount'] == 0) ? 0 : 1;
            }
            return $count ?? 0;
        }
        else{
            return 0;
        }
    }

    public function getOrderInvolvedParties(int $orderRowId): array
    {
        $query = $this->db->query("SELECT o.party_id,o.party_type,p.name,pm.house_number
            FROM tb_order_parties o,tbl_party_types p, tbl_party_master pm
            WHERE pm.id=o.party_id AND o.order_id = ? AND o.status = ? AND o.party_type = p.id AND p.name IN ? ", [$orderRowId, '1', ['Shipper', 'Consignee', 'Pickup', 'Delivery']]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderStopsByBookingId(string $bookingId): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.stopname
                    FROM tb_shiporder_stops o,tb_employee e
                    WHERE o.shipment_id=e.shift_id AND e.order_id=? AND o.status=1 AND e.status=1
                    ORDER BY o.ordernumber ASC",
            [$bookingId]
        );
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function checkDangerousGoodsForOrder(int $orderRowId): array
    {
        $orderCargoIds = $unCode = [];
        $cargosQuery = $this->db->query("SELECT o.id FROM tb_order_cargodetails o,tb_cargo_details c WHERE o.order_id = ? AND o.status = ? AND o.cargo_id = c.id AND c.status = ? AND c.dg_goods > ?", [$orderRowId, 1, 1, 0]);
        $cargoResult = $cargosQuery->num_rows() > 0 ? $cargosQuery->result_array() : [];
        if (empty($cargoResult)) {
            return [];
        }
        foreach ($cargoResult as $eachResult) {
            $orderCargoIds[] = $eachResult['id'];
        }
        $dgGoodsQuery = $this->db->query("SELECT org_number FROM tb_order_dg_goods WHERE order_id = ? AND order_cargo_id IN ? AND status = ? ", [$orderRowId, $orderCargoIds, 1]);
        $dgGoodsResult = $dgGoodsQuery->num_rows() > 0 ? $dgGoodsQuery->result_array() : [];
        if (empty($dgGoodsResult)) {
            return [];
        }
        foreach ($dgGoodsResult as $eachResult) {
            $unCode[] = $eachResult['org_number'];
        }
        $podUploadQuery = $this->db->query("SELECT p.imgpath FROM tb_pod_uploads p,tb_document_types d WHERE p.order_id = ? AND p.doc_type = d.id AND p.status = ? AND d.type_name LIKE ?", [$orderRowId, '1', 'DG Declaration']);
        $podResult = $podUploadQuery->num_rows() > 0 ? $podUploadQuery->result_array() : [];
        foreach ($podResult as $eachLine) {
            $imagePath = $eachLine['imgpath'];
            if ($imagePath != "") {
                $pods[] = sprintf('%s/poduploads/%s', '/var/www/', $imagePath);
            }
        }
        return ['unCode' => $unCode ?? [], 'pods' => $pods ?? []];
    }

    public function getOrderbordertype(string $shiftid) : int {
        if(!empty($shiftid)){
            $type_query = $this->db->select("border_type")->get_where("tb_shifts", ["id" => $shiftid], 1, 0);
            $btype = ($type_query->num_rows() > 0) ? $type_query->row()->border_type :  "";
            return $btype;
        }else{
            return "";
        }
    }

    public function checkOrderwiseDggoods(int $id) : int{
        if(empty($id)){ return 0; } else{
            $cargo_type = $this->db->query("select oc.cargo_id,oc.order_id from tb_order_cargodetails oc left join tb_cargo_details c  on oc.cargo_id = c.id where oc.order_id= ? and c.dg_goods = ? " ,[$id,1]);
            return $cargo_type->num_rows() > 0  ? 1 : 0 ;
        }
    }

    public function getcustomeridsForCid( string $cid ): array {
        if (empty($cid)) { return [];  } else {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", ['code' => $cid]);
            return $getcustomer_id->num_rows() > 0 ? $result = $getcustomer_id->result_array() : [];
        }
    }
    
    public function getVendor(string $id): string {
        if (empty($id)) {
            return ""; // Return empty string instead of array
        }
    
        $query = $this->db->select("name")->get_where("tb_vendors", ['id' => $id]);
        //log_message("error", "Query: " . $this->db->last_query());
    
        if ($query->num_rows() > 0) {
            $row = $query->row(); // Get the row object
            return $row->name ?? ""; // Return name if exists, else empty string
        }
    
        return ""; // Return empty string if no rows
    }
    
    public function getUserCustomerAndVendorData( int $orderRowID ): array {
        if ($orderRowID == '') {
        }
        $this->db->select('o.branch_code,u.name,u.emailid as user_email_id,c.name as customerName,c.email_id as customer_email_id,c.code as customer_code,v.email as vendor_email_id,v.code as vendor_code');
        $this->db->from("tb_orders o");
        $this->db->join('tb_users u', 'o.user_id= u.id', 'LEFT');
        $this->db->join('tb_customers c', 'o.customer_id= c.id', 'LEFT');
        $this->db->join('tb_vendors v', 'o.vendor_id= v.id', 'LEFT');
        $this->db->where('o.id', $orderRowID);
        $this->db->group_by('o.id');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }
}
