<html>
<head>
    <title><?php echo "#".($bookingId ?? ''); ?> | Booking ePOD Information | Svkonekt</title>
</head>
<body>
<?php
    require_once ("./application/helpers/epod_helper.php");
?>
<style>
    div, th, td {
        vertical-align: top;
        line-height: 1.42;
        padding: 8px;
    }
    .no-highlight {
        -webkit-tap-highlight-color: rgba(0,0,0,0);
    }
    .text-left {
        text-align: left;
    }
    section, .base1, .pod-upload {
        font-family: 'Source Sans Pro','Helvetica Neue',Helvetica, sans-serif;
    }
    .base1 {
        -webkit-tap-highlight-color: rgba(0,0,0,0);
        border-collapse: collapse;
        border-spacing: 0;
        border-top: 1px solid #ddd;
        box-sizing: border-box;
    }
    .no-border {
        border: 0;
    }
    .pod-upload {
        border-collapse: collapse;
        border-spacing: 0;
        box-sizing: border-box;
        position: relative;
        min-height: 1px;
        float: left;
        margin: 8px;
    }
</style>
    <section class="no-highlight" style="font-size: 14px;color: #333;font-weight: 400;box-sizing: border-box;display: block;position: relative;background: #fff">
        <table style="box-sizing: border-box;font-weight: 500;line-height: 1.1;color: inherit;padding-bottom: 9px;border-bottom: 1px solid #eee;margin: 10px 0 20px 0;font-size: 22px;width: 100%">
            <tr>
                <td class="base1 no-border"><img src="./assets/images/etnlogo.png" style="height: 40px"></td>
                <td class="base1 no-border" style="font-size: 14px;" align="right">Date: <?= date("d/M/Y") ?></td>
            </tr>
        </table>
      <!-- Table row -->
        <table style="width: 100%">
            <tr>
                <td class="base1 no-border">
                    <center><h3>Svkonekt</h3></center>
                    <center><h4>Booking ePOD Information</h4></center>
                </td>
            </tr>
            <tr>
                <td class="base1 no-border">
                    <h4>Completed Order Information:</h4>
                    <table style="width: 100%">
                        <tr>
                            <?php if($this->session->userdata('company_code') =="AUKN"){ ?>

                                <th class="base1 text-left">Booking ID</th>
                                <td class="base1" ><?= "#".($bookingId ?? '') ?></td>

                                <th class="base1 text-left">Total Cargos</th>
                                <td class="base1"><?= $totalCargo ?? '0' ?></td>

                            <?php } else{ ?>
                                <th class="base1 text-left">Booking ID</th>
                                <td class="base1" colspan="3"><?= "#".($bookingId ?? '') ?></td>
                            <?php } ?>
                        </tr>
                        <tr>
                            <th class="base1 text-left">Pickup location</th>
                            <td class="base1"><?= $shipperAddress ?></td>
                            <th class="base1 text-left">Drop location</th>
                            <td class="base1"><?= $consigneeAddress ?></td>
                        </tr>
                        <tr>
                            <?php

                            $curtz = $this->session->userdata('usr_tzone')['timezone'] ?? 'UTC';
                            $pickupTime = $actualPickupDateTime ? getdatetimebytimezone($curtz, $actualPickupDateTime, 'UTC') : '';
                            $deliveryTime = $actualDeliveryDateTime ? getdatetimebytimezone($curtz,$actualDeliveryDateTime, 'UTC') : '';

                            ?>
                            <th class="base1 text-left">Pickup Date</th>
                            <td class="base1">
                                <?= $pickupTime ? date("d M, Y",strtotime($pickupTime['date'])) : '-'?></td>

                            <th class="base1 text-left">Delivery Date</th>
                            <td class="base1"><?= $deliveryTime ? date("d M, Y",strtotime($deliveryTime['date'])) : '-'?></td>
                        </tr>
                        <tr>
                            <th class="base1 text-left">Pickup Time</th>
                            <td class="base1"><?= $pickupTime ? date("H:i A",strtotime($pickupTime['time'])).' '. $curtz : '-' ?></td>
                            <th class="base1 text-left">Delivery Time</th>
                            <td class="base1"><?= $deliveryTime ? date("H:i A",strtotime($deliveryTime['time'])).' '. $curtz : '-' ?></td>
                        </tr>
                        <tr>
                            <th class="base1 text-left">Pickup Comment</th>
                            <td class="base1"><?= $pickupComments ?? '' ?></td>
                            <th class="base1 text-left">Delivery Comment</th>
                            <td class="base1"><?= $deliveryComments ?? '' ?></td>
                        </tr>
                        <tr>
                            <th class="base1 text-left">Reference Numbers</th>
                            <td colspan="3" class="base1"> <?= $referenceNumbers ?? '-/-' ?> </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <?php

        if(!empty($epods ?? null)) :

        ?>
        <h4>ePOD:</h4>
        <div style="border-collapse: collapse;border-spacing: 0;box-sizing: border-box;margin-left: -15px;margin-right: -15px;">
        <?php

        foreach (($epods ?? []) as $row) :

            $style = $row->type_name === "Signature" ? "height: 200px" : "height: 800px";
            $colWidth = $row->type_name === "Signature" ? "width: calc(33% - 16px);" : "width: calc(100% - 16px);";

            ?>
            <div class="pod-upload" style="<?php echo $colWidth;?>">
                <?= epod_as_html_to_pdf($row, $style) ?>
                <table style="width: 100%">
                    <tr>
                        <th class="base1 text-left">Location</th>
                        <td class="base1"><?php echo getLocationName($row->latitude,$row->longitude);?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">Doc Type</th>
                        <td class="base1"><?php echo $row->type_name;?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">Uploaded Time</th>
                        <td class="base1"><?= date("d M,y h:i A",strtotime(getdatetimebytimezone($curtz,$row->createdon,'UTC')['datetime'])) . ' '. $curtz ?>
                    </tr>
                    <tr>
                        <td colspan="2" class="base1">&nbsp;</td>
                    </tr>
                </table>
            </div>
        <?php endforeach; ?>
        </div>
        <?php
           endif;
        ?>
    </section>
</body>
</html>

