<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/here_map_china/china_css/mapsjs-ui.css" />
<script type="text/javascript" src="<?php echo base_url();?>assets/here_map_china/china_js/mapsjs-core.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/here_map_china/china_js/mapsjs-service.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/here_map_china/china_js/mapsjs-ui.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/here_map_china/china_js/mapsjs-mapevents.js"></script>

<style type="text/css">
#map {
    width: 100%;
    height: calc(100vh - 45px);
    padding: 0px !important;
    background: grey;
}

#panel {
    width: 100%;
    height: 250px;
}
@font-face{
    font-family:'Fira Sans';
    src:
    local("Fira Sans Light"),
    url("fonts/FiraSans-Light.eot") format("embedded-opentype"),
    url("fonts/FiraSans-Light.woff") format("woff2"),
    url("fonts/FiraSans-Light.ttf") format("truetype"),
    url("fonts/FiraSansOT-Light.otf") format("opentype"),
    ;
}

@font-face{
    font-family:'Fira Mono';
    src:
    local("Fira Mono Regular"),
    url("fonts/FiraMono-Regular.eot") format("embedded-opentype"),
    url("fonts/FiraMono-Regular.woff") format("woff"),
    url("fonts/FiraMono-Regular.woff2") format("woff"),
    url("fonts/FiraMono-Regular.ttf") format("truetype");
}

body {
    font-family:'Fira Sans', "Lucida Grande",Tahoma,sans-serif;
    color: #0f1621;
    background-color: transparent;
    font-size: 15px;
    line-height: 22px;
    font-weight: 300;
}

.nomargin{
    margin:0;
}
.table td{
    vertical-align:middle !important;
}
.page-header{
    border-bottom: 1px solid rgb(238, 238, 238);
}
.page-header div.thumbnail{
    display:none;
}
#copy-btn{
    line-height:1.4;
}
#params input.form-control{
    background:#fff url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJMYXllcl8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgd2lkdGg9IjI0cHgiIGhlaWdodD0iMjRweCIgdmlld0JveD0iMCAwIDI0IDI0IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCAyNCAyNCIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+CjxnIGlkPSJYTUxJRF8xXyI+Cgk8cmVjdCBmaWxsPSIjYmFiY2M0IiBmaWxsLW9wYWNpdHk9IjAiIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIvPgoJPHBhdGggZmlsbD0iI2JhYmNjNCIgZD0iTTE5LjI5OCw2LjIyMWwtMS41MjEtMS41MTljLTAuMzUxLTAuMzQ3LTAuOTItMC4zNDctMS4yNjYsMGwtMC42MzUsMC42MzRsMi43ODYsMi43ODRsMC42MzQtMC42MzIgQzE5LjY0Niw3LjE0LDE5LjY0Niw2LjU2OCwxOS4yOTgsNi4yMjF6IE01LjExOSwxNi4wOTZsLTAuOTA1LDMuMzcyYy0wLjA2MiwwLjIzOCwwLjA4LDAuMzgyLDAuMzE4LDAuMzE3bDMuMzcyLTAuOTA0bDkuODc1LTkuODc0IGwtMi43ODYtMi43ODZMNS4xMTksMTYuMDk2eiIvPgo8L2c+Cjwvc3ZnPgo=') no-repeat right 5px
}
#params input.form-control:focus{
    background-image:none;
    padding-right:12px;
}
#params input.disabled,#params input:disabled{
    background:#babcc4;
}
#params td:first-child{
    min-width:120px;
}
#params input.disabled:focus{
    box-shadow:none;
    border:1px solid #cdced0;
}
#image-response{
    border:1px solid #cdced0;
    background:#e4e6e9;
    padding:15px;
    border-radius:4px;
}
#image-response img{
    max-width:100%;
    background-color:#e4e6e9;
    background-image:linear-gradient(45deg, #c0c0c0 25%,transparent 25%,transparent 75%,#c0c0c0 75%,#c0c0c0),linear-gradient(45deg, #c0c0c0 25%,transparent 25%,transparent 75%,#c0c0c0 75%,#c0c0c0);
    background-size:20px 20px;
    background-position:0 0,30px 30px;
}
.no-border{
    border:none;
}
#url-path{
    font-size:x-small;
    word-wrap:break-word;
}

.tooltip.in{
    opacity:1;
    filter:alpha(opacity=100);
}
.tooltip-inner{
    background-color:rgba(15,22,33,0.9);
    color:#fff;
    text-align:left;
    padding:20px;
    white-space:normal;
}
.white{
    background-color:inherit;
}
section.param-section{
    border-bottom:1px solid #e4e6e9;
    display:none;
}
label.param-label{
    font-weight:normal;
}
@media (min-width: 992px){
    .sel-md-10{
        max-width:178px;
    }
}
@media (min-width: 1200px){
    .sel-md-10{
        max-width:250px;
    }
}
.container{
    -webkit-font-smoothing:antialiased;
    -moz-osx-font-smoothing:grayscale;
    padding-left:0;
    padding-right:0;
    margin-right:inherit;
    margin-left:0px !important;
    width:100%;
}
.container p{
    max-width:640px;
    text-rendering:optimizeLegibility;
}
.row{
    margin-right:0;
    margin-left:0;
}
.nav-pills>li>a{
    border-radius:0;
    background-color:#383c45;
    color:#babcc4
}
.nav-pills>li>a:hover{
    background-color:#383c45;
}
.nav-pills>li+li{
    margin-left:0;
}
.nav-pills>li{
    margin-right:1px;
}
.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover{
    color:#fff;
    background-color:#1d232d;
}
.nav-pills>li>a:hover{
    color:#3d73d0;
}
.thumbnail>img,.thumbnail a>img{
    height:60px;
    width:60px;
}
#map .btn-group{
    background-color:transparent !important;
}
.btn-sm{
    font-size:14px;
    line-height:18px;
    border-radius:2px !important;
    box-sizing:border-box;
    padding:10px 16px !important;
}
.btn-primary{
    color: #fff !important;
    background-color: #77a0e7 !important;
    border-color: #77a0e7 !important;
}
.btn-primary:hover,.btn-primary:focus,.btn-primary:active,.open>.dropdown-toggle.btn-primary{
    background: #3d73d0 !important;
    border-color: #3d73d0 !important;
}
.btn-primary.disabled,.btn-primary[disabled],fieldset[disabled] .btn-primary,.btn-primary.disabled:hover,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary:hover,.btn-primary.disabled:focus,.btn-primary[disabled]:focus,fieldset[disabled] .btn-primary:focus,.btn-primary.disabled:active,.btn-primary[disabled]:active,fieldset[disabled] .btn-primary:active,.btn-primary.disabled.active,.btn-primary[disabled].active,fieldset[disabled] .btn-primary.active{
    background:#babcc4 !important;
    color:#fff !important;
    border-color:#babcc4 !important
}
body{
    color:#0f1621;
    background-color:transparent;
    font-size:15px;
    line-height:22px;
}

b,strong{
    color:#0f1621;
}
h2,h3,h4{
    margin-top:2.5em;
}
h1{
    margin-top:40px;
    font-size:22px;
    line-height:34px;
    color:#383c45;
}
h2{
    font-size:18px;
    line-height:28px;
}
h3,h4{
    font-size:16px;
    line-height:24px;
}
.panel{
    background-color:transparent
}
.panel-body{
    padding:15px 0;
}
.panel-body>h3,.panel-header>h3{
    padding:8px 0;
    border-bottom:1px solid #e4e6e9;
}
code{
    font-family: 'Fira Mono', Courier, monospace;
    color: black;
    font-weight:500;
    background-color:transparent;
}
code[class*="language-"],pre[class*="language-"]{
    font-weight:inherit;
}

a,a span{
    font-weight:400;
    color: #77a0e7;
    cursor: pointer;
    text-decoration: none;
}
a:hover,a span:hover{
    color: #3d73d0;
}


.token.comment a.highlight-link{
    color:slategrey;
    font-weight:500;
}
.token.comment a:hover.highlight-link{
    color: #3d73d0;
}
#map{
    width: 100%;
    height: calc(100vh - 45px);
    padding: 0px !important;
    border:1px solid #cdced0;
    background-color:#e4e6e9;
}
#panel{
    width:100%;
    height:250px;
    overflow:auto;
    background:inherit;
}
.H_ib_content>div>h1,.H_ib_content>div>h2,.H_ib_content>div>h3{
    color:#fff;
}
#images{
    padding:10px 10px 10px 10px;
    width:100%;
    border:1px solid #cdced0;
    background-color:#e4e6e9;
}
.embedded-video-frame{
    position:relative;
    padding-top:100%;
    min-height:450px;
}
.embedded-video-frame iframe{
    position:absolute;
    top:0;
    left:0;
    width:100%;
    height:100%;
}
img.image-frame{
    max-width:100%;
    margin-left:auto;
    margin-right:auto;
}
.video-frame{
    padding:10px 10px 10px 10px;
}
.video-frame div{
    text-align:center;
}
.video-frame div video{
    max-width:100%;
}
#collapseIDE{
    height:600px;
    background:inherit;
}
.code-file{
    max-height:470px;
}
strong{
    font-weight:500;
}
.lens-iframe{
    width:100%;
    height:400px;
    border:0;
}
.thumbnail{
    float:left;
    border:none;
    padding-right:10px;
}
.datalens-collapsible__expand{
    display:none;
}
.datalens-collapsible.collapsed .datalens-collapsible__expand,.datalens-collapsible__collapse{
    display:block;
}
.datalens-collapsible__panel{
    display:block;
    margin-top:1em;
}
.datalens-collapsible.collapsed .datalens-collapsible__collapse,.datalens-collapsible.collapsed .datalens-collapsible__panel{
    display:none;
}
.lt-download-link-holder{
    float:left;
}
.nav-pills li.lt-download-link-holder{
    float:right;
}
.nav-pills li.lt-download-link-holder a{
    background-color:transparent;
    color:#00afaa;
}
.nav-tabs>li.active>a,.nav-tabs>li.active>a:hover,.nav-tabs>li.active>a:focus{
    background-color:transparent;
}
.input-group{
    padding-bottom:15px;
}
.form-control,input[type="text"],input[type="email"],textarea{
    -webkit-box-shadow:0 0 0 white;
    -moz-box-shadow:0 0 0 white;
    box-shadow:0 0 0 white;
    border-radius:2px;
    height:40px;
    line-height:22px;
    outline:none;
    padding:0 20px 0 13px;
}
.form-control:focus,input[type="text"]:focus,input[type="email"]:focus,textarea:focus{
    -webkit-tap-highlight-color:rgba(0,0,0,0);
    -webkit-box-shadow:0 0 0 white;
    -moz-box-shadow:0 0 0 white;
    box-shadow:0 0 0 white;
    border-color:#3d73d0;
    outline:0;
    outline:none;
}
.form-control{
    padding-right:24px;
    font-size:13px;
}
@media (min-width: 768px){
    .col-md-1,.col-md-2,.col-md-3,.col-md-4,.col-md-5,.col-md-6,.col-md-7,.col-md-8,.col-md-9,.col-md-10,.col-md-11,.col-md-12{
        float:left;
    }
    .col-md-12{
        width:100%;
    }
    .col-md-11{
        width:91.66667%;
    }
    .col-md-10{
        width:83.33333%;
    }
    .col-md-9{
        width:75%;
    }
    .col-md-8{
        width:66.66667%;
    }
    .col-md-7{
        width:58.33333%;
    }
    .col-md-6{
        width:50%;
    }
    .col-md-5{
        width:41.66667%;
    }
    .col-md-4{
        width:33.33333%;
    }
    .col-md-3{
        width:25%;
    }
    .col-md-2{
        width:16.66667%;
    }
    .col-md-1{
        width:8.33333%;
    }
    #request-params tbody tr td{
        position:relative;
        display:block;
    }
    #request-params tbody tr td:nth-child(1){
        clear:both;
        padding-top:8px;
        padding-bottom:0;
    }
    #request-params tbody tr td:nth-child(2){
        clear:left;
        float:left;
        border-top:none;
        margin-top:8px;
    }
    #request-params tbody tr td:nth-child(3){
        float:left;
        border-top:none;
    }
    #request-params tbody tr:nth-child(1) td:nth-child(1){
        border-top:none;
    }
}
.datalens-viz{
    border:1px solid #ccc;
    height:300px;
    overflow:hidden;
    position:relative;
    display:none;
}
.datalens-error-bg{
    background:url(./default-error-image.png) no-repeat center;
    width:100%;
    height:100%;
}
#url-path{
    display:inline-block;
}
#url-path,#request-params .param-label{
    word-break:break-all;
}

b, strong {
    color: black;
}

      .directions li span.arrow {
        display:inline-block;
        min-width:28px;
        min-height:28px;
        background-position:0px;
        background-image: url("https://heremaps.github.io/maps-api-for-javascript-examples/map-with-route-from-a-to-b/img/arrows.png");
        position:relative;
        top:8px;
      }
      .directions li span.depart  {
        background-position:-28px;
      }
      .directions li span.rightturn  {
        background-position:-224px;
      }
      .directions li span.leftturn{
        background-position:-252px;
      }
      .directions li span.arrive  {
        background-position:-1288px;
      }
      </style>
      <script>
    $(document).ready(function () {
        var slides = document.getElementsByClassName("marker-circle");
        var key = 1;
        var letter = 'A';
        for (var i = 0; i < slides.length; i++) {

            var e = slides.item(i);

            if (i == 0) {
                var start_letter = geralphabit(key++);

                e.innerHTML = start_letter
            } else {
                if (slides.item(i - 1).getAttribute('data-latlang') !== slides.item(i).getAttribute('data-latlang')) {
                    var letter = geralphabit(key++);
                    e.innerHTML = letter;
                    
                } else {
                    e.innerHTML = letter;
                    
                }
            }
        }
    });

    function geralphabit(key) {
        var alphabit = '';

        if (key == '1') {
            alphabit = 'A';
        } else if (key == '2') {
            alphabit = 'B';
        } else if (key == '3') {
            alphabit = 'C';
        } else if (key == '4') {
            alphabit = 'D';
        } else if (key == '5') {
            alphabit = 'E';
        } else if (key == '6') {
            alphabit = 'F';
        } else if (key == '7') {
            alphabit = 'G';
        } else if (key == '8') {
            alphabit = 'H';
        } else if (key == '9') {
            alphabit = 'I';
        } else if (key == '10') {
            alphabit = 'J';
        } else if (key == '11') {
            alphabit = 'K';
        } else if (key == '12') {
            alphabit = 'L';
        } else if (key == '13') {
            alphabit = 'M';
        } else if (key == '14') {
            alphabit = 'N';
        } else if (key == '15') {
            alphabit = 'O';
        }

        return alphabit;
    }
</script>
<?php 
    $cntrylatlng['ulat'] = "35.8617"; 
    $cntrylatlng['ulng'] = "104.1954";
    if($this->session->userdata("user_id") !== FALSE){ 
        $lguid = $this->session->userdata("user_id");
        $cntrylatlng = getLogUserLatLng($lguid);
    }
if(!isset($isSimBased)){
    $isSimBased = "false";
} 
$tripsts = "";
if(isset($trip->status)){
   $tripsts = $trip->status;
}
?>
<!-- Set up constants such as APP ID and token -->
<script type="text/javascript" >
    var ulglat = <?php echo $cntrylatlng['ulat'];?>;
    var ulglng = <?php echo $cntrylatlng['ulng'];?>;
    var trip_id = '<?php echo $trip_id;?>';
    var q = [];
    var vehicle;
    var nextTimeStamp = "";
    var trackerFrequency = 20000;
    var angle = 0;
    var tokBox = null;
    var trafficLayer;
    var trafficFlag = false;
    var isSimBased = false;
    var bounds;
         isSimBased = <?php echo $isSimBased;?>;
        var trip_closed = "<?php echo $tripsts;?>";

            $("footer.main-footer").remove();
            $(".main-header").remove();
            $("#map").css("height", "calc(100vh)");
            $(".tracking-list").css("height", "calc(100vh)");
            $(".rightBottom").css("margin-bottom", "0px");
    
 getTripLocation(isSimBased,'');

 function getTripLocation(isSimBased,timestamp) {

        if (timestamp == "") {
            console.clear();
        }
        $.ajax({
            url: "<?=base_url()?>visibility/getTripLocation/<?=$trip_id?>/" + timestamp,
            dataType: "JSON",
            success: function(data) {
                data.data
                $.each(data.data, function(i, v) {
                    q.push(v);
                });
                if (timestamp == "") {
                    if (q.length != 0) {
                        var d = q.shift();
                        if(!isSimBased){
                            $(".speed").html(d.speed);
                            $(".timestamp").html(d.receivedon);
                        }
                    }
                }
                if (data.data.length != 0) {
                    nextTimeStamp = data.data[data.data.length - 1].timestamp;
                }
                setTimeout(function() {
                    getTripLocation(isSimBased,nextTimeStamp);
                }, trackerFrequency);
            }, error: function (request, status, error) {
                alert(request.responseText);
            }
        });
    }

<?php
    if($isSimBased == "true"){ 
              foreach($records->result() as $row){ ?>
                 image = new H.map.Icon(baseurl+'assets/images/icons/Blu_Truck.png', {size: {w: 30, h: 20}});
                var newPosition = {lat: <?php echo @$record->latitude?>,lng: <?php echo @$record->longitude?>};
                var marker = new H.map.Marker(newPosition, {
                    icon: image
                });
                  map.addObject(marker);
                $(".speed").html("<?php echo uom_value($row->speed, 'kph'); ?>");
                $(".timestamp").html("<?php echo $row->timestamp; ?>");
                <?php
                }
    }else{
        if(isset($record->latitude) && strlen($record->latitude)>0){ 
        ?>

        <?php }
    }

?>
</script>


<?php

$waypoins = array();
foreach ($stops->result() as $stop) {

    foreach ($details as $detail) {

        if ($detail->stop_id == $stop->id) {

            foreach ($detail->statuses as $i => $status) {

                if (count($waypoins) == 0) {

                    $waypoins[] = array('lat' => $detail->lat, 'lang' => $detail->lng, 'alphabet' => $detail->alphabet);

                } else {
                    if (!in_array(array('lat' => $detail->lat, 'lang' => $detail->lng), $waypoins)) {
                        $waypoins[] = array('lat' => $detail->lat, 'lang' => $detail->lng, 'alphabet' => $detail->alphabet);
                    }

                }

                ?>


            <?php }
        }
    }

}

foreach ($waypoins as $key => $value) {
    ?>
    <span class="shipstopopen" data-lat="<?php echo $value['lat']; ?>" data-place="<?php echo $value['alphabet']; ?>" data-lng="<?php echo $value['lang']; ?>"
    </span> <?php
    $waymidpoints[]=$value['lat'].','.$value['lang'];
    $allmidpoints[]=$value['lat'].','.$value['lang'];
 } 

?>

<table width="100%">
    <tr>
        <td style="width:65%">
            <div class="screen" style="position: absolute;text-align: center;z-index: 10000"></div>
            <div id="map"></div>
    <div id="panel"></div>
        </td>
        <td style="position: absolute;overflow: hidden;background: #fff;width: 35%;">
            <div class="tracking-list">
                <?php
                foreach($stops->result() as $stop){
                ?>
                <div class="tracking-item">
                    <div class="tracking-icon status-intransit"><?php echo $stop->stoptype; ?></div>
                    <div class="tracking-date" style="font-weight: 600;"><?php echo date("M d, Y",strtotime($stop->startdate));?><span><?php echo date("h:i A",strtotime($stop->startdate));?></span></div>
                    <div class="tracking-content" style="font-weight: 600;"><?php echo $stop->address;?>
                        <span>
                            <?php
                            $act_ship_units = shipmentStopWeight($stop);
                            ?>
                            WEIGHT : <?php echo uom_string($stop->weight, 'kg'); ?><br>
                            VOLUME : <?php echo uom_string($stop->volume, 'cbm'); ?><br>
                            Actual units : <?php echo $act_ship_units;?> <br>
                            Driver updated units : <?php echo $stop->ship_units;?>
                        </span>
                    </div>
                </div>
                <?php
                foreach($drivers as $driver){
                    $driver = (Object) $driver;
                    ?>
                    <div class="tracking-item">
                        <div class="tracking-date" style="font-weight: 600;"><?php echo date("M d, Y",strtotime($driver->createdon));?><span><?php echo date("h:i A",strtotime($driver->createdon));?></span></div>
                        <div class="tracking-content" style="font-weight: 600;">Driver Assigned : <?php echo $driver->name;?>
                            <span>Mobile : <?php echo $driver->contact_num;?></span>
                            <span>Travelled : <?php echo uom_string($driver->travelled_km, 'km'); ?></span>
                        </div>
                    </div>
                    <?php
                }
                    foreach($details as $detail){
                        if($detail->stop_id == $stop->id){
                            foreach($detail->statuses as $i=>$status){ 
                                if($detail->status=="1"){
                                    if($status->status_id=="1"){
                                        ?>
                                        <div class="tracking-item points" data-lat="<?php echo $detail->lat;?>" data-lng="<?php echo $detail->lng;?>" data-id="<?php echo $detail->id;?>">
                                            <?php
                                            if($detail->type=="P"){
                                                echo '<div class="tracking-icon status-intransit">P</div>';
                                            }else{
                                                echo '<div class="tracking-icon status-outfordelivery">'.$detail->type.'</div>';
                                            }
                                            ?>
                                            <div class="tracking-date">
                                                <?php echo date("M d, Y",strtotime($status->in_time));?>
                                                <span><?php echo date("h:i A",strtotime($status->in_time));?></span>
                                            </div>
                                            <div class="tracking-content">
                                                	<span class="marker-circle"
                                                          data-latlang="<?php echo $detail->lat; ?>-<?php echo $detail->lng; ?>"><?php echo $detail->alphabet; ?></span>
                                                <?php echo $detail->name;?>
                                                <span>
                                                    Expected Time : <?php echo date("M d, Y h:i A",strtotime($detail->time));?><br>
                                                    Shipment Weight : <?php echo uom_string($detail->weight, 'kg'); ?><br>
                                                    Shipment Volume : <?php echo uom_string($detail->volume, 'cbm'); ?><br>
                                                    Shipment Status : <?php echo $status->status_name; ?> <br>
                                                    Order iD : <?php echo $detail->order_id; ?> 
                                                </span>
                                            </div>
                                        </div>
                                <?php
                                    } else{
                                ?>
                                        <div class="tracking-item points" data-lat="<?php echo $detail->lat;?>" data-lng="<?php echo $detail->lng;?>" data-id="<?php echo $detail->id;?>">
                                            <!-- <div class="tracking-icon status-intransit">D</div> -->
                                            <div class="tracking-date" style="font-weight: 600;">
                                                <?php echo date("M d, Y",strtotime($status->in_time));?>
                                                <span><?php echo date("h:i A",strtotime($status->in_time));?></span>
                                            </div>
                                            <div class="tracking-content" style="font-weight: 600;">
                                            <span class="marker-circle"
                                                      data-latlang="<?php echo $detail->lat; ?>-<?php echo $detail->lng; ?>"><?php echo $detail->alphabet; ?></span>
                                            <?php echo $detail->name;?>
                                            <span>
                                                STATUS : <?php echo $status->status_name;?>
                                            </span>
                                            </div>
                                        </div>
                                <?php
                                    }
                                }else{
                                ?>
                                    <div class="tracking-item points" data-lat="<?php echo $detail->lat;?>" data-lng="<?php echo $detail->lng;?>" data-id="<?php echo $detail->id;?>">
                                <?php
                                    if($detail->type=="P"){
                                        echo '<div class="tracking-icon status-intransit">P</div>';
                                    }else{
                                        echo '<div class="tracking-icon status-outfordelivery">'.$detail->type.'</div>';
                                    }
                                ?> 
                                    <div class="tracking-content">
                                     <span class="marker-circle"
                                           data-latlang="<?php echo $detail->lat; ?>-<?php echo $detail->lng; ?>"><?php echo $detail->alphabet; ?></span>
                                            <span style="color: #f97575;font-size: 14px;"><?php echo $detail->name;?></span>
                                            <span>
                                                Expected Time : <?php echo date("M d, Y h:i A",strtotime($detail->time));?><br>
                                                Shipment Weight : <?php echo uom_string($detail->weight, 'kg'); ?><br>
                                                Shipment Volume : <?php echo uom_string($detail->volume, 'cbm'); ?><br>
                                            <?php if ($trip->status == 1) { //Added by Madhavi ?>
                                                Shipment Status : <span style="color: #f97575;font-size: 10px;"><?php echo "In Progress"; ?> </span><br>
                                            <?php } else { ?>
                                                Shipment Status : <span style="color: #f97575;font-size: 10px;"><?php echo "CANCELED/FAILED"; ?> </span><br>
                                            <?php } ?>
                                            </span>
                                        </div>                                     
                                    </div>
                                <?php
                                }
                            }
                        }
                    }
                }
                ?>
            </div>
        </td>
    </tr>
</table>
<div class="rightBottom" style="display: none;">
    <table>
        <tbody>
            <tr>
                <td colspan="2"></td>
            </tr>
            <tr style="font-size: smaller;">
                <td colspan="2" class="locationName"></td>
            </tr>
            <tr>
                <td rowspan="2" style="font-size: 24px;padding-right: 5px;font-weight: 600;width: 18px;" valign="bottom" class="speed"></td>
                <td style="font-size: 12px;" valign="bottom" class="timestamp"></td>
            </tr>
            <tr>
                <td style="font-size: 10px;" valign="top">KM/H</td>
            </tr>
        </tbody>
    </table>
</div>

<style type="text/css">
    body{
        overflow: hidden;
    }
    .tracking-list{
        height: calc(100vh - 50px);
        overflow-x: auto;
        padding: 10px;
    }
    @media only screen and (max-width: 767px) {
        .navbar-static-top {
            display: none;
        }    }

    .rightBottom {
        position: absolute;
        bottom: 0;
        left: 540px;
        background: white;
        z-index: 1;
        margin-bottom: 90px;
        padding: 10px;
    }

    .tracking-detail {
        padding: 3rem 0
    }

    #tracking {
        margin-bottom: 1rem
    }
    .marker-circle{
        width: 2rem;
        height: 2rem;
        text-align: center;
        border-radius: 50%;
        font-size: 14px !important;
        background-color: #e84d3a;
        color: #fff !important;
    }

    [class*=tracking-status-] p {
        margin: 0;
        font-size: 14rem;
        color: #fff;
        text-transform: uppercase;
        text-align: center
    }

    [class*=tracking-status-] {
        padding: 1.6rem 0
    }

    .tracking-status-intransit {
        background-color: #65aee0
    }

    .tracking-status-outfordelivery {
        background-color: #f5a551
    }

    .tracking-status-deliveryoffice {
        background-color: #f7dc6f
    }

    .tracking-status-delivered {
        background-color: #4cbb87
    }

    .tracking-status-attemptfail {
        background-color: #b789c7
    }

    .tracking-status-error,
    .tracking-status-exception {
        background-color: #d26759
    }

    .tracking-status-expired {
        background-color: #616e7d
    }

    .tracking-status-pending {
        background-color: #ccc
    }

    .tracking-status-inforeceived {
        background-color: #214977
    }

    .tracking-list {
        border: 1px solid #e5e5e5
    }
    .inner-list {
        border: 0px !important;
    }

    .tracking-item {
        border-left: 1px solid #e5e5e5;
        position: relative;
        padding: 2rem 1.5rem .5rem 2.5rem;
        font-size: 14px;
        margin-left: 3rem;
        min-height: 5rem
    }

    .tracking-item:last-child {
        padding-bottom: 4rem
    }

    .tracking-item .tracking-date {
        margin-bottom: .5rem;
        font-weight: 600;
        background: #ffffff;
        border-radius: 5px;
        padding: 5px;
        border: 1px solid #e5e5e5;
        font-size: 11px;
    }

    .tracking-item .tracking-date span {
        color: #888;
        font-size: 85%;
        padding-left: .4rem
    }

    .tracking-item .tracking-content {
        padding: .5rem .8rem;
        background-color: #f4f4f4;
        border-radius: .5rem;
        background: #ffffff;
        border-radius: 5px;
        padding: 5px;
        border: 1px solid #e5e5e5;
    }

    .tracking-item .tracking-content span {
        display: block;
        color: #888;
        font-size: 85%
    }

    .tracking-item .tracking-icon {
        line-height: 2.6rem;
        position: absolute;
        left: -1.3rem;
        width: 2.6rem;
        height: 2.6rem;
        text-align: center;
        border-radius: 50%;
        font-size: 1.1rem;
        background-color: #fff;
        color: #fff
    }

    .tracking-item .tracking-icon.status-sponsored {
        background-color: #f68;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-delivered {
        background-color: #4cbb87;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-outfordelivery {
        background-color: #f5a551;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-deliveryoffice {
        background-color: #f7dc6f;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-attemptfail {
        background-color: #b789c7;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-exception {
        background-color: #d26759;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-inforeceived {
        background-color: #214977;
        font-size: 15px;
    }

    .tracking-item .tracking-icon.status-intransit {
        color: #e5e5e5;
        border: 1px solid #e5e5e5;
        font-size: 15px;
    }

    @media(min-width:992px) {
        .tracking-item {
            margin-left: 10rem
        }
        .tracking-item .tracking-date {
            position: absolute;
            left: -10rem;
            width: 7.5rem;
            text-align: right
        }
        .tracking-item .tracking-date span {
            display: block
        }
        .tracking-item .tracking-content {
            background-color: transparent
        }
    }



</style>
<script type="text/javascript" >
    var points = [];
    $(".shipstopopen").each(function() {
                points.push({
                    "lat": $(this).data("lat"),
                    "lng": $(this).data("lng"),
                    "place": $(this).data("place")
                });
            });


function calculateRouteFromAtoB(platform) {
   

      var router = platform.getRoutingService(null, 8),
          routeRequestParams = {
            mode: 'fastest;car',
            representation: 'display',
            routeattributes : 'waypoints,summary,shape,legs',
            maneuverattributes: 'direction,action',
            language: 'zh-UK'
           
          };
        for (var i = 0; i < points.length; i++) {
                    var point = points[i].lat + "," + points[i].lng;
                    routeRequestParams["waypoint"+i] = point;
        }
      router.calculateRoute(
        routeRequestParams,
        onSuccess,
        onError
      );
}


function onSuccess(result) {
     var route,linestring;
     
        if(result.response) {
             var route = result.response.route[0];
             addSummaryToPanel(route.summary);

                         linestring = new H.geo.LineString();

                      for (i = 0;  i < route.waypoint.length; i ++) {
                          var v  =points[i].place;
                           var svgMarkup ='<svg xmlns="http://www.w3.org/2000/svg"  fill="red" width="34" height="34" viewBox="0 0 24 24"><path d="M12 0c-5.522 0-10 4.395-10 9.815 0 5.505 4.375 9.268 10 14.185 5.625-4.917 10-8.68 10-14.185 0-5.42-4.478-9.815-10-9.815zm0 18c-4.419 0-8-3.582-8-8s3.581-8 8-8 8 3.582 8 8-3.581 8-8 8z"/><text x="13" y="16" font-size="12pt" ' +'font-family="Arial" font-weight="bold" text-anchor="middle" ' + 'fill="red">'+v+'</text></svg>';
                        var icon = new H.map.Icon(svgMarkup);

                        var marker =  new H.map.Marker({
                            lat: route.waypoint[i].mappedPosition.latitude,
                            lng: route.waypoint[i].mappedPosition.longitude},{icon:icon});
                        map.addObject(marker);
                      }
                    route.shape.forEach(function(point) {
                        var parts = point.split(',');
                        linestring.pushLatLngAlt(parts[0], parts[1]);
                    });
                    var polyline = new H.map.Polyline(linestring, {
                        style: { strokeColor: '#669DF6', lineWidth: 5,strokeOpacity: 0.5  }
                    });

                  map.addObject(polyline);
                  map.setViewBounds(polyline.getBounds(), true);
        }
}

/**
 * This function will be called if a communication error occurs during the JSON-P request
 * @param {Object} error The error message received.
 */
function onError(error) {
         alert('Can\'t reach the remote server');
}


    var CHINA_HERE_MAP_API_ID='<?=CHINA_HERE_MAP_API_ID;?>';
    var CHINA_HERE_MAP_API_CODE='<?=CHINA_HERE_MAP_API_CODE;?>';

    var mapContainer = document.getElementById('map'),
      routeInstructionsContainer = document.getElementById('panel');

    var platform = new H.service.Platform({
        app_id  : CHINA_HERE_MAP_API_ID,
        app_code: CHINA_HERE_MAP_API_CODE,
        useHTTPS: true
    });

    var defaultLayers = platform.createDefaultLayers();

    var ulglat = <?php echo $cntrylatlng['ulat'];?>;
    var ulglng = <?php echo $cntrylatlng['ulng'];?>;
    var map = new H.Map(mapContainer,
      defaultLayers.normal.map, {
      center: { lng: ulglng, lat:ulglat  },
      zoom: 13,
      pixelRatio: window.devicePixelRatio || 1
    });


    window.addEventListener('resize', () => map.getViewPort().resize());
    var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
    
    function switchMapLanguage(map, platform,defaultLayers){
            var mapTileService = platform.getMapTileService({
                type: 'base'
            }),
            chineseMapLayer = mapTileService.createTileLayer(
                'maptile',
                'normal.day',
                256,
                'png8',
                {lg: 'ENG'}
            );
            map.setBaseLayer(chineseMapLayer);
            var ui = H.ui.UI.createDefault(map, defaultLayers, 'en-US');
            ui.removeControl('mapsettings');
    }
    switchMapLanguage(map , platform,defaultLayers);

    function addMarkersToMap(map) {
  var parisMarker = new H.map.Marker({lat:39.9427, lng:116.3915});
  map.addObject(parisMarker);

  var romeMarker = new H.map.Marker({lat:39.9431, lng: 116.3912});
  map.addObject(romeMarker);

  var berlinMarker = new H.map.Marker({lat:39.9452, lng:116.3947});
  map.addObject(berlinMarker);

  var madridMarker = new H.map.Marker({lat:39.9440, lng: 116.3892});
  map.addObject(madridMarker);

}

    var bubble;

    /**
 * Opens/Closes a infobubble
 * @param  {H.geo.Point} position     The location on the map.
 * @param  {String} text              The contents of the infobubble.
 */
function openBubble(position, text){
 if(!bubble){
    bubble =  new H.ui.InfoBubble(
      position,
      // The FO property holds the province name.
      {content: text});
    ui.addBubble(bubble);
  } else {
    bubble.setPosition(position);
    bubble.setContent(text);
    bubble.open();
  }
}


/**
 * Creates a H.map.Polyline from the shape of the route and adds it to the map.
 * @param {Object} route A route as received from the H.service.RoutingService
 */
function addRouteShapeToMap(route){
  var strip = new H.geo.LineString(),
    routeShape = route.shape,
    polyline;

  routeShape.forEach(function(point) {
    var parts = point.split(',');
    strip.pushLatLngAlt(parts[0], parts[1]);
  });

  polyline = new H.map.Polyline(strip, {
    style: {
      lineWidth: 4,
      strokeColor: 'rgba(0, 128, 255, 0.7)'
    }
  });
  map.addObject(polyline);
  map.setViewBounds(polyline.getBounds(), true);
}


/**
 * Creates a series of H.map.Marker points from the route and adds them to the map.
 * @param {Object} route  A route as received from the H.service.RoutingService
 */
function addManueversToMap(route){
  var svgMarkup = '<svg width="18" height="18" ' +
    'xmlns="http://www.w3.org/2000/svg">' +
    '<circle cx="8" cy="8" r="8" ' +
      'fill="#1b468d" stroke="white" stroke-width="1"  />' +
    '</svg>',
    dotIcon = new H.map.Icon(svgMarkup, {anchor: {x:8, y:8}}),
    group = new  H.map.Group(),
    i,
    j;

  // Add a marker for each maneuver
  for (i = 0;  i < route.leg.length; i += 1) {
    for (j = 0;  j < route.leg[i].maneuver.length; j += 1) {
      // Get the next maneuver.
      maneuver = route.leg[i].maneuver[j];
      // Add a marker to the maneuvers group
      var marker =  new H.map.Marker({
        lat: maneuver.position.latitude,
        lng: maneuver.position.longitude} ,
        {icon: dotIcon});
      marker.instruction = maneuver.instruction;
      group.addObject(marker);
    }
  }

  group.addEventListener('tap', function (evt) {
    map.setCenter(evt.target.getGeometry());
    openBubble(
       evt.target.getGeometry(), evt.target.instruction);
  }, false);

  // Add the maneuvers group to the map
  map.addObject(group);
}


/**
 * Creates a series of H.map.Marker points from the route and adds them to the map.
 * @param {Object} route  A route as received from the H.service.RoutingService
 */
function addWaypointsToPanel(waypoints){



  var nodeH3 = document.createElement('h3'),
    waypointLabels = [],
    i;


   for (i = 0;  i < waypoints.length; i += 1) {
    waypointLabels.push(waypoints[i].label)
   }

  nodeH3.textContent = waypointLabels.join(' - ');
  routeInstructionsContainer.innerHTML = '';
  routeInstructionsContainer.appendChild(nodeH3);
}

/**
 * Creates a series of H.map.Marker points from the route and adds them to the map.
 * @param {Object} route  A route as received from the H.service.RoutingService
 */
function addSummaryToPanel(summary){
  var summaryDiv = document.createElement('div'),
   content = '';
   content += '<b>Total distance</b>: ' + summary.distance  + 'm. <br/>';
   content += '<b>Travel Time</b>: ' + summary.travelTime.toMMSS() + ' (in current traffic)';

  summaryDiv.style.fontSize = 'small';
  summaryDiv.style.marginLeft ='5%';
  summaryDiv.style.marginRight ='5%';
  summaryDiv.innerHTML = content;
  routeInstructionsContainer.appendChild(summaryDiv);
}

/**
 * Creates a series of H.map.Marker points from the route and adds them to the map.
 * @param {Object} route  A route as received from the H.service.RoutingService
 */
function addManueversToPanel(route){



  var nodeOL = document.createElement('ol'),
    i,
    j;

  nodeOL.style.fontSize = 'small';
  nodeOL.style.marginLeft ='5%';
  nodeOL.style.marginRight ='5%';
  nodeOL.className = 'directions';

     // Add a marker for each maneuver
  for (i = 0;  i < route.leg.length; i += 1) {
    for (j = 0;  j < route.leg[i].maneuver.length; j += 1) {
      // Get the next maneuver.
      maneuver = route.leg[i].maneuver[j];

      var li = document.createElement('li'),
        spanArrow = document.createElement('span'),
        spanInstruction = document.createElement('span');

      spanArrow.className = 'arrow '  + maneuver.action;
      spanInstruction.innerHTML = maneuver.instruction;
      li.appendChild(spanArrow);
      li.appendChild(spanInstruction);

      nodeOL.appendChild(li);
    }
  }

  routeInstructionsContainer.appendChild(nodeOL);
}


Number.prototype.toMMSS = function () {
  return  Math.floor(this / 60)  +' minutes '+ (this % 60)  + ' seconds.';
}

calculateRouteFromAtoB(platform);

</script>
