<link href="<?php echo base_url(); ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css" />

<style>
    .select2-selection__choice {
        color: white;
    }

    .datatable-header {
        width: 100%;
    }

    .note-inline {
        display: flex;
        align-items: center;
        color: #516f91ff;
        font-size: 13px;
    }

    .length-control {
        margin-left: auto !important;
    }

    .note-inline i {
        margin-right: 6px;
        /* space after the icon */
        margin-left: 6px;
        /* space after the icon */
    }

    .note-inline strong {
        margin-right: 4px;
        /* space after "Note:" */
    }
</style>

<?php
$prevFrom  = date('m-d-Y', strtotime('-2 week'));
$currentTo = date('m-d-Y');
?>

<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container">
            <div class="filtersHeader">
                <div class="filter-section pull-left">
                    <div class="filter_icons">
                        <div class="navbar pull-right">
                            <a id="adv_filter" href="#" data-action="open" data-side="right" class="adv_filter">
                                <span data-toggle="tooltip" data-placement="bottom" title="Filter"
                                    class="iconSvk icon-filter-icon"></span>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="filter-section pull-right">
                    <div class="filter_icons">
                        <div class="dropdown bcdropdown excelDrop">
                            <button class="dropbtn">
                                <span data-toggle="tooltip" class="iconSvk icon-download-icon"></span>
                            </button>
                            <div class="dropdown-content">
                                <a href="#" onclick="exportsOptions('excel')"><i
                                        class="icon tru-icon-excel"></i><?php echo $this->lang->line('general_excel'); ?></a>
                                <a href="#" onclick="exportsOptions('pdf')"><i
                                        class="icon tru-icon-pdf"></i><?php echo $this->lang->line('general_pdf'); ?></a>
                                <a href="#" onclick="exportsOptions('print')"><i
                                        class="icon tru-icon-print"></i><?php echo $this->lang->line('general_print'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-------Advanced Search---------->
            <div class="sidebars" id="sidebars_search" style="display:none">
                <div class="advance_searchcol sidebar right" id="sidebar_search">
                    <div class="title_header">
                        <h2><span
                                class="iconSvk icon-filter-icon"></span><?php echo $this->lang->line('customer_delay_status'); ?>
                        </h2>
                        <a href="javascript:void(0)" class="closebtn" data-action="close" data-side="right">&times;</a>
                    </div>
                    <form method="POST" action="<?php echo base_url(); ?>AlertsController" id="advsearch_alerts">
                        <input type="hidden" name="searchsubmit" id="searchsubmit_flag" value="">
                        <div class="custom-scroll">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label
                                            for="aqufromdate"><?php echo $this->lang->line('general_from_date'); ?></label>
                                        <input type="text" name="aqufromdate" id="fromDate" class="form-control"
                                            placeholder="MM-DD-YYYY" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label
                                            for="aqutodate"><?php echo $this->lang->line('general_to_date'); ?></label>
                                        <input type="text" name="aqutodate" id="toDate" class="form-control"
                                            placeholder="MM-DD-YYYY" autocomplete="off">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="order_id"><?php echo $this->lang->line('booking_id'); ?></label>
                                        <input type="text" name="order_id" placeholder="Booking ID" class="form-control"
                                            id="order_id" value="" onkeyup="this.value=this.value.toUpperCase();">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="delay"><?php echo $this->lang->line('delay'); ?></label>
                                        <select name="delay" id="delay" class="form-control">
                                            <option value="both"><?php echo $this->lang->line('both'); ?></option>
                                            <option value="pickup"><?php echo $this->lang->line('pickup'); ?></option>
                                            <option value="delivery"><?php echo $this->lang->line('delivery'); ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="footer-search">
                            <div class="top20">
                                <div class="view_more text-center">
                                    <button type="button" class="btn btn-primary btn_color"
                                        onclick="getDelayAlertsReport();"
                                        value="Search"><?php echo $this->lang->line('general_search'); ?></button>
                                    <button type="button" class="btn btn-default btn_color resetbtn"
                                        onclick="resetAdvancedSearch();"><?php echo $this->lang->line('general_reset'); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-------Advanced Search- End--------->

            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white mb70">
                        <div class="main-datatable">
                            <div class="table-responsive">
                                <input type="hidden" name="customer_session_id" id="customer_session_id"
                                    value="<?php echo $custid; ?>">
                                <input type="hidden" name="vendor_session_id" id="vendor_session_id"
                                    value="<?php echo $vendor_id; ?>">
                                <table id="alertslist" class="table table-striped table-bordered" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th><i
                                                    class="icon tru-icon-truck-emp"></i><b><?php echo $this->lang->line('booking_id'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-exclamation-triangle"></i><b><?php echo $this->lang->line('general_remarks'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-truck"></i><b><?php echo $this->lang->line('shipment_id'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-calendar"></i><b><?php echo $this->lang->line('estimated_early_pickup'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-calendar"></i><b><?php echo $this->lang->line('estimated_early_delivery'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-map-marker"></i><b><?php echo $this->lang->line('pickup_address'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-map-marker"></i><b><?php echo $this->lang->line('delivery_address'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-building"></i><b><?php echo $this->lang->line('carrier_name'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-truck"></i><b><?php echo $this->lang->line('truck_no'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-truck"></i><b><?php echo $this->lang->line('vehicle_type'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-user"></i><b><?php echo $this->lang->line('driver_name'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-info-circle"></i><b><?php echo $this->lang->line('last_status'); ?></b>
                                            </th>
                                            <th><i
                                                    class="fa fa-calendar"></i><b><?php echo $this->lang->line('last_status') . ' ' . $this->lang->line('date'); ?></b>
                                            </th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (count($delayorders) > 0) {
                                            foreach ($delayorders as $res) { ?>
                                                <tr>
                                                    <td><?php echo $res['order_id']; ?></td>
                                                    <td><?php echo $res['remark']; ?></td>
                                                    <td><?php echo $res['shipmentid']; ?></td>
                                                    <td><?php echo $res['pickup_datetime']; ?></td>
                                                    <td><?php echo $res['delivery_datetime']; ?></td>
                                                    <td><?php echo $res['pickup_address1']; ?></td>
                                                    <td><?php echo $res['delivery_address1']; ?></td>
                                                    <td><?php echo $res['carrier']; ?></td>
                                                    <td><?php echo $res['vehicle_register_number']; ?></td>
                                                    <td><?php echo $res['truck_type']; ?></td>
                                                    <td><?php echo $res['driver_name']; ?></td>
                                                    <td><?php echo $res['latest_status_name']; ?></td>
                                                    <td><?php echo $res['latest_createdon']; ?></td>
                                                </tr>
                                            <?php }
                                        } else { ?>
                                            <tr>
                                                <td colspan="13" class="text-center">
                                                    <?php echo $this->lang->line('rec_not_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url(); ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?php echo base_url(); ?>assets/newtheme/js/custom.js"></script>
<script src="<?php echo base_url(); ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js">
</script>

<script type="text/javascript">
    var baseurl = "<?php echo base_url(); ?>";
    var dataTable = null;
    var currentSearchData = null;
    var isSearchActive = false;
    var recNotFound = '<?php echo $this->lang->line('rec_not_found'); ?>';
    var noteDetails = '<?php echo $this->lang->line('note_details'); ?>';
    var note = '<?php echo $this->lang->line('note'); ?>';
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = 'none';

        var opts = {
            format: 'mm-dd-yyyy',
            autoclose: false, // We'll handle closing manually after formatting
            todayHighlight: true,
            endDate: '0d',
            forceParse: false
        };

        $('#fromDate, #toDate').datepicker(opts);

        // Format helper
        function formatDateToMMDDYYYY(date) {
            return ("0" + (date.getMonth() + 1)).slice(-2) + '-' +
                ("0" + date.getDate()).slice(-2) + '-' +
                date.getFullYear();
        }

        // Set initial dates
        var fromDate = '<?php echo $prevFrom; ?>';
        var toDate = '<?php echo $currentTo; ?>';

        if (fromDate) {
            var parts = fromDate.split('-');
            var fromObj = new Date(parts[2], parts[0] - 1, parts[1]);
            $('#fromDate').datepicker('setDate', fromObj);
            $('#fromDate').val(formatDateToMMDDYYYY(fromObj));
        }

        if (toDate) {
            var parts = toDate.split('-');
            var toObj = new Date(parts[2], parts[0] - 1, parts[1]);
            $('#toDate').datepicker('setDate', toObj);
            $('#toDate').val(formatDateToMMDDYYYY(toObj));
        }

        // When user selects date from picker
        $('#fromDate, #toDate').on('changeDate', function(e) {
            var $this = $(this);
            if (e.date) {
                // Format date first
                $this.val(formatDateToMMDDYYYY(e.date));

                // Update the other picker's min/max
                if ($this.attr('id') === 'fromDate') {
                    $('#toDate').datepicker('setStartDate', e.date);
                } else {
                    $('#fromDate').datepicker('setEndDate', e.date);
                }

                // Close the picker after formatting
                $this.datepicker('hide');
            }
        });

        // When user manually types and closes the picker
        $('#fromDate, #toDate').on('hide', function(e) {
            var $this = $(this);
            var date = $this.datepicker('getDate');
            if (date) {
                $this.val(formatDateToMMDDYYYY(date));
                // Ensure picker is closed after formatting
                $this.datepicker('hide');
            }
        });

        initializeDataTable();
    });




    function initializeDataTable() {
        if (!$.fn.DataTable.isDataTable('#alertslist')) {
            dataTable = $("#alertslist").DataTable({
                responsive: true,
                processing: true,
                paging: true,
                lengthChange: true,
                info: false,
                autoWidth: true,
                ordering: true,
                order: [
                    [0, "desc"]
                ],
                pageLength: 10,
                searching: false,
                lengthMenu: [
                    [10, 20, 30, 50, 100, -1],
                    [10, 20, 30, 50, 100, "All"]
                ],
                // One row: note left, controls right
                dom: "<'datatable-header d-flex justify-content-between align-items-center mb-2'<'note-inline'><'length-control'l>>" +
                    "Bfrtip",

                buttons: [
                    'copyHtml5', 'excelHtml5', 'csvHtml5', 'print',
                    {
                        extend: 'pdfHtml5',
                        text: '<i class=\"fa fa-file-pdf-o\"></i> PDF',
                        titleAttr: 'Export as PDF',
                        orientation: 'landscape',
                        pageSize: 'A3',
                        exportOptions: {
                            columns: ':visible'
                        }
                    }
                ],
                language: {
                    lengthMenu: 'Show _MENU_',
                    emptyTable: '<div style=\"text-align:center\">' + recNotFound + '</div>'
                }
            });
            $('.note-inline').html(
                '<i class="fa fa-info-circle mr-1"></i>' +
                '<strong>' + note + ': </strong>' + noteDetails
            );

        }
    }

    // This function updates DataTable rows from your backend's returned HTML <tr> elements string
    function updateDataTable(html) {
        if (dataTable) {
            dataTable.clear();

            // Temporary container to parse HTML string to DOM and extract cells
            var $rows = $('<table><tbody>' + html + '</tbody></table>').find('tbody tr');

            var rowsData = [];

            $rows.each(function() {
                var row = [];
                $(this).find('td').each(function() {
                    row.push($(this).html());
                });
                rowsData.push(row);
            });

            dataTable.rows.add(rowsData).draw();
        }
    }

    function getDaysCount(fromDate, toDate) {
        if (!fromDate || !toDate) return 0;

        // Parse MM-DD-YYYY format (with dashes)
        var fromParts = fromDate.split('-');
        var toParts = toDate.split('-');

        if (fromParts.length !== 3 || toParts.length !== 3) {
            console.log('Invalid date format - From:', fromDate, 'To:', toDate);
            return 0;
        }

        // Create dates: new Date(year, month-1, day)  
        var d1 = new Date(fromParts[2], fromParts[0] - 1, fromParts[1]);
        var d2 = new Date(toParts[2], toParts[0] - 1, toParts[1]);

        return Math.ceil(Math.abs((d2 - d1) / (1000 * 3600 * 24))) + 1;
    }

    function getDelayAlertsReport() {
        var from = $('#fromDate').val();
        var to = $('#toDate').val();
        var orderId = $('#order_id').val();
        var delay = $('#delay').val();

        if (from) from = from.replace(/\//g, '-');
        if (to) to = to.replace(/\//g, '-');

        if (!from || !to) {
            gettoast('top-right', '', 'Please Select Date Range');
            return;
        }

        var days = getDaysCount(from, to);
        if (days > 45) {
            gettoast('top-right', '', 'Max History Days Are Limited To 45 Days');
            return;
        }

        var postData = {
            aqufromdate: from,
            aqutodate: to,
            order_id: orderId,
            delay: delay
        };

        $('.btn_color').prop('disabled', true);

        $.ajax({
            url: baseurl + 'AlertsController/ajaxSearch',
            type: 'POST',
            data: postData,
            success: function(html) {
                if (html.includes('Date range exceeds 45 days limit')) {
                    gettoast('top-right', '', 'Max History Days Are Limited To 45 Days');
                    return;
                }

                updateDataTable(html);
                $('#sidebars_search').hide();
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                console.error('Response text:', xhr.responseText);
                gettoast('top-right', '', 'Failed to fetch data. Please try again.');
            },
            complete: function() {
                $('.btn_color').prop('disabled', false);
            }
        });
    }


    function performSearch() {
        $('.btn_color').prop('disabled', true);

        $.ajax({
            url: baseurl + 'AlertsController/ajaxSearch',
            type: 'POST',
            data: currentSearchData,
            success: function(html) {
                // Check if response contains error message
                if (html.includes('Date range exceeds 45 days limit')) {
                    gettoast('top-right', '', 'Max History Days Are Limited To 45 Days');
                    isSearchActive = false;
                    currentSearchData = null;
                    return;
                }

                // Get current page length BEFORE destroying table
                var currentLength = 10; // default
                if (dataTable && dataTable.page) {
                    try {
                        currentLength = dataTable.page.len();
                    } catch (e) {
                        console.log('Could not get page length, using default');
                    }
                }

                // Destroy table safely
                if (dataTable && $.fn.DataTable.isDataTable('#alertslist')) {
                    dataTable.destroy();
                    dataTable = null;
                }

                // Update table content
                $('#alertslist tbody').html(html);

                // Reinitialize DataTable
                initializeDataTable();

                // Set the page length to what it was before
                if (dataTable && dataTable.page && dataTable.page.len) {
                    try {
                        dataTable.page.len(currentLength).draw();
                    } catch (e) {
                        console.log('Could not set page length');
                    }
                }

                // Hide sidebar
                $('#sidebars_search').hide();
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error, xhr.responseText);
                gettoast('top-right', '', 'Failed to fetch data. Please try again.');
                isSearchActive = false;
                currentSearchData = null;
            },
            complete: function() {
                $('.btn_color').prop('disabled', false);
            }
        });
    }

    function resetAdvancedSearch() {
        $('#fromDate').val('<?php echo date("m-d-Y", strtotime("-14 days")); ?>');
        $('#toDate').val('<?php echo date("m-d-Y"); ?>');
        $('#order_id').val('');

        // Clear stored search data
        currentSearchData = null;
        isSearchActive = false;

        // Reload page to show default data
        window.location.reload();
    }

    function gettoast(position, id, desp) {
        if (id != "") {
            if (!$('#' + id).hasClass('errorclass')) {
                $('#' + id).addClass('errorclass');
            }
        }
        try {
            init({
                fade_in: 800,
                fade_out: 800,
                position: position,
            });
            toast({
                type: 'custom',
                title: '<span style="color:#000000ab;">Warning Message</span>',
                description: '<span style="color:black;"><b>' + desp + '</b></span>',
                close_color: '#FF7F50',
                border_color: '#FF8C00',
                color: '#FFBF00',
                timeout: 900
            });
        } catch (e) {
            // Fallback to alert if toast fails
            alert(desp);
        }
    }

    function closeToast() {
        try {
            $('#toast-container').fadeOut(300, function() {
                $(this).remove();
            });
        } catch (e) {
            console.log('Toast close error');
        }
    }

    function exportsOptions(type) {
        try {
            if (dataTable && dataTable.button) {
                if (type == 'excel') {
                    dataTable.button('.buttons-excel').trigger();
                } else if (type == 'pdf') {
                    dataTable.button('.buttons-pdf').trigger();
                } else if (type == 'print') {
                    dataTable.button('.buttons-print').trigger();
                }
            } else {
                console.log('DataTable buttons not available');
            }
        } catch (e) {
            console.error('Export error:', e);
            gettoast('top-right', '', 'Export failed. Please try again.');
        }
    }
</script>