<div class="content-page">
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xs-12">
                    <div class="filter-section mtop15 bg-white ptlbr20">
                        <div class="col-md-10 col-sm-12">
                            <div class="row">
                                <form method="POST" id="search_documents" onsubmit="return validateform(this);" >
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <select form="search_documents" name="doc_id" id="doc_id" class="form-control" placeholder="<?= $this->lang->line('booking_id') ?>">
                                                <option>Select</option>
                                                <?php
                                                foreach ($documents_master as $doc) :
                                                    $selectedDoc = "";
                                                    if ($doc['id'] == $doc_id) {
                                                        $selectedDoc = "selected";
                                                    } else {
                                                        $selectedDoc = "";
                                                    }
                                                    echo "<option value='" . $doc['id'] . "'$selectedDoc>" . $doc['type_name'] . "</option>";
                                                endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <select form="search_documents" name="bookingid[]" id="bookingid" class="form-control searchbookingids" multiple="multiple" placeholder="<?= $this->lang->line('booking_id') ?>">
                                                <?php
                                                foreach ($bookingids as $bookingId) :
                                                    $selected = "selected";
                                                    echo "<option value='" . $bookingId . "'$selected>" . $bookingId . "</option>";
                                                endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <select form="search_documents" name="referencevalues[]" id="referencevalues" class="form-control searchreferencevalues" multiple="multiple" placeholder="<?= $this->lang->line('qbook_deliverynote')." / ".$this->lang->line('qbook_purchaseorder') ?>" >
                                                <?php
                                                foreach ($selected_reference_values as $referenceValues) :
                                                    $selected = "selected";
                                                    echo "<option value='" . $referenceValues . "'$selected>" . $referenceValues . "</option>";
                                                endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <button type="submit" name="searchsubmit" id="searchsubmit"
                                                class="btn  btn-primary btn_color" value="<?="search"?>"><?="search"?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-12">
                            <div class="filter_icons">
                                <div class="navbar pull-right">
                                    <div class="dropdown">
                                        <button class="dropbtn"><span class="icon tru-icon-quick-menu"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="generateZipFile(this)" ><i
                                                    class="icon tru-icon-download"></i>Generate Zip</a>
                                        </div>
                                    </div>
                                    <div class="dropdown">
                                        <button class="dropbtn">
                                            <span class="icon tru-icon-export"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="exportsOptions('excel')"><i
                                                    class="icon tru-icon-excel"></i><?php
                                                echo $this->lang->line('general_excel'); ?></a>
                                            <a href="#" onclick="exportsOptions('pdf')"><i
                                                    class="icon tru-icon-pdf"></i><?php
                                                echo $this->lang->line('general_pdf'); ?></a>
                                            <a href="#" onclick="exportsOptions('print')"><i
                                                    class="icon tru-icon-print"></i><?php
                                                echo $this->lang->line('general_print'); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white ptlbr15 mb70">
                        <div class="main-datatable">
                            <div class="table-responsive">
                                <table id="servicetable"
                                       class="table table-striped table-bordered forcheckboxes"
                                       style="width: 100%">
                                    <thead>
                                    <tr>
                                        <th class="shoring_icon_no">
                                            <div class="checkbox checkbox-info">
                                                <label> <input type="checkbox" class="checkAll" value=""> <span
                                                        class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                </label>
                                            </div>
                                        </th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?=
                                            $this->lang->line('booking_id'); ?></th>
                                        <th><i class="fa fa-pencil-square-o"></i><?=
                                            $this->lang->line('doc_type'); ?></th>
                                        <th><i class="fa fa-pencil-square-o"></i><?=
                                            $this->lang->line('reference_info'); ?></th>
                                        <th><i class="icon tru-icon-pdf"></i><?=
                                            $this->lang->line('documents'); ?></th>
                                        <th><i class="fa fa-user"></i><?=
                                            $this->lang->line('created_by'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?=
                                            $this->lang->line('general_created_on'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($documents as $document) { ?>
                                        <tr>
                                            <td><div class="checkbox checkbox-info">
                                                    <label> <input type="checkbox" name="documents_ids" id="documents_ids[]"
                                                                   value="<?= $document['document_id']; ?>"> <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                    </label>
                                                </div></td>
                                            <td><?= $document['order_id']; ?></td>
                                            <td><?= $document['doc_type']; ?></td>
                                            <td><?= $document['reference_values']; ?></td>
                                            <td><?= $document['path']; ?></td>
                                            <td><?= $document['created_by']; ?></td>
                                            <td><?= $document['date']; ?></td>
                                        </tr>
                                        <?php
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal containerModal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" style="font-weight: bold;"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"
                                style="margin-top: -21px;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Modal body text goes here.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<link
    href="<?php echo base_url();?>assets/newtheme/plugins/toast/toastStyle.css"
    rel="stylesheet" type="text/css" />
<script src="<?php
echo base_url(); ?>assets/newtheme/js/custom.js"></script>
<script src="<?php
echo base_url(); ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url(); ?>assets/plugins/select2/select2.min.js"></script>
<script src="<?= base_url(); ?>assets/js/select2/select2_paste_functionality_override.js"></script>
<link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/select2/select2.min.css">
<script type="text/javascript">
    function validateform(e) {
        var bookingId = $('#bookingid').val();
        var referenceValues = $('#referencevalues').val();
        if (bookingId == null && referenceValues == null) {
            gettoast('top-right', '', 'Please select any booking id or Reference Id');
            return false;
        }
        if (bookingId != "") {
            if (!documentsExistsFor(bookingId)) {
                gettoast('top-right', 'bookingid', 'Please search for the documents older than 90 days with valid Booking ID');
                return false;
            }
        }
        if (referenceValues != "") {
            if(!documentsExistsForReferenceValues(referenceValues)) {
                gettoast('top-right', 'referencevalue', 'Please search for the documents older than 90 days with valid Reference ID');
                return false;
            }
        }
    }

    function gettoast(position, id, desp) {
        if (id != "") {
            if (!$('#' + id).hasClass('errorclass')) {
                $('#' + id).addClass('errorclass');
            }
        }
        init({
            fade_in: 800,
            fade_out: 800,
            position: position,
        });
        toast({
            type: 'custom',
            title: '<span style="color:#000000ab;">Warning Message</span>',
            description: '<span style="color:black;"><b>' + desp + '</b></span>',
            close_color: '#FF7F50',
            border_color: '#FF8C00',
            color: '#FFBF00',
            timeout: 900
        });
    }

    function documentsExistsFor(bookingIds) {
        let baseurl = '<?= base_url();?>';
        let documentExists = false;
        $.ajax({
            url: baseurl + 'archiveddocuments/checkpods',
            async: false,
            type: "POST",
            data: {'booking_ids': bookingIds},
            dataType: 'JSON',
            success: function () {
                documentExists = true;
            },
            error: function () {
                documentExists = false;
            }
        });

        return documentExists;
    }


    function documentsExistsForReferenceValues(referenceIds) {
        let baseurl = '<?= base_url();?>';
        let documentExists = false;
        $.ajax({
            url: baseurl + 'archiveddocuments/checkpods',
            async: false,
            type: "POST",
            data: {'referencevalues': referenceIds},
            dataType: 'JSON',
            success: function () {
                documentExists = true;
            },
            error: function() {
                documentExists = false;
            }
        });

        return documentExists;
    }

    $('.searchbookingids').select2({
        placeholder: "<?= $this->lang->line('booking_id'); ?>",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-bookingid-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        allowClear: true,
        ajax: {
            url: "<?= base_url(); ?>" + 'archiveddocuments/getbookingids',
            type: 'post',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });

    $('.searchreferencevalues').select2({
        placeholder: "<?= $this->lang->line('qbook_deliverynote')." / ".$this->lang->line('qbook_purchaseorder'); ?>",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-referencevalues-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        allowClear: true,
        ajax: {
            url: "<?= base_url(); ?>" + 'archiveddocuments/getreferencevalues',
            type: 'post',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });

    $(document).on('paste', 'span.select2', function (e) {
        e.preventDefault();
        var select = $(e.target).closest('.select2').prev();
        var clipboard = (e.originalEvent || e).clipboardData.getData('text/plain');
        var createOption = function (value, selected) {
            selected = typeof selected !== 'undefined' ? selected : true;
            return $("<option></option>")
                .attr("value", value)
                .attr("selected", selected)
                .text(value)[0]
        };
        $.each(
            clipboard.split(new RegExp(select.data('select2').options.options.tokenSeparators.map(function (a) {
                return (a).replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
            }).join('|'))),
            function (key, value) {
                if (value && (!select.val() || (select.val() && select.val().indexOf('' + value) == -1))) {
                    select.append(createOption(value));
                }
            });
        select.trigger('change');
    });

    $('.checkAll').on('click', function() {
        if (this.checked == true)
            $('.forcheckboxes').find('input[name="documents_ids"]').prop('checked', true);
        else
            $('.forcheckboxes').find('input[name="documents_ids"]').prop('checked', false);
    });

    function generateZipFile(e) {
        var document_ids = [];
        $("input:checkbox[name=documents_ids]:checked").each(function () {
            document_ids.push($(this).val())
        });
        if (document_ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Document');
            return false;
        }
        var baseurl = '<?= base_url();?>';
        $.ajax({
            url: baseurl + 'archiveddocuments/generatezipforarchiveddocuments',
            type: "POST",
            data: {'document_ids' : document_ids},
            dataType: 'json',
            beforeSend: function () {
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Please Wait...");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                if (data.status == 'success') {
                    $(".containerModal").modal("hide");
                    location.href = baseurl + data.file_path;
                } else {
                    location.href = baseurl + 'archiveddocuments/generatezipforarchiveddocuments';
                }
            },
            error: function (errMsg) {
                $(".containerModal").modal("hide");
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Error");
                $(".containerModal").find(".modal-body").html("<span>Oops! Something went wrong</span>");
            }
        });
    }
</script>

