<script src="<?php echo base_url('assets/clipboard.min.js');?>"></script>
<?php
$displayDeliveryNote = checkAccessConditions('DISPLAY_DQ_IN_BY_MILESTONE',$this->session->userdata('company_code'));
function getHeadColumn($column){
    echo '<th>';
    echo $column;
    echo '</th>';
}
function getColumn($value){
    echo '<td>';
    echo $value;
    echo '</td>';
}

$scacColumnEnabled = user_is_using_scac();
?>
<style type="text/css">
    .containerTable .thead-light th {
        color: #fff;
        border-color: #dee2e6;
        background-color: #244062;
    }
    .expandOrder .table th{
        color: #fff;
        background-color: #244062;
    }
    .btn-xs{
        padding: 1px;
    }
    .btn-xs, .btn-group-xs>.btn {
        font-size: 11px !important;
    }
</style>
<section class="content-header" style="padding: 7px 15px 0px 15px;">
    <h1><?=$this->lang->line('shipment_visibility')?></h1>
    <ol class="breadcrumb" style="padding: 0px 0px;">
        <li><a href="<?php echo base_url();?>carrier/dashboard"><i class="fa fa-home"></i> <?=$this->lang->line('general_home')?></a></li>
        <li><a href="<?php echo base_url();?>carrier/livecabdetails"><?=$this->lang->line('menu_visibility')?></a></li>
        <li class="active"><?=$this->lang->line('shipment_visibility')?></li>
    </ol>
</section>
<section class="content" style="display: none">
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->lang->line('shipment_visibility')?></h3>
                    <div class="box-tools">
                        <form method="POST" name="shipvisform" action="<?php echo base_url();?>carrier/visibility">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" name="table_search" class="form-control pull-right" placeholder="Search" style="border-top-color: #d1d5dd;border-left-color: #d1d5dd;border-right-color: #d1d5dd;">
                                <div class="input-group-btn">
                                    <button type="submit" class="btn btn-default" title="Search" name="frmsub"><i class="fa fa-search"></i></button>
                                    <a href="<?=base_url('carrier/visibility')?>" class="btn btn-default btn-sm" title="Refresh"><i class="fa fa-refresh"></i></a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body" style="overflow-x:auto;">
                    <div class="table-responsive">
                        <table class="table table-striped containerTable">
                            <thead class="thead-light">
                            <tr>
                                <th></th>
                                <th><?=$this->lang->line('general_actions')?></th>
                                <th><?=$this->lang->line('id')?></th>
                                <th><?=$this->lang->line('general_source')?></th>
                                <th><?=$this->lang->line('general_destination')?></th>
                                <th><?=$this->lang->line('start_dt')?></th>
                                <th><?=$this->lang->line('end_dt')?></th>
                                <th><?=$this->lang->line('carrier')?></th>
                                <?php if ($scacColumnEnabled) : ?>
                                    <th>SCAC</th>
                                <?php endif ?>
                                <th><?=$this->lang->line('driver')?></th>
                                <th><?=$this->lang->line('vehicle')?></th>
                            </tr>
                            </thead>
                            <tbody style="font-size: 12px;">
                            <?php $bookingId = "";
                            if (count($orders) > 0) {
                                foreach ($orders as $row) {
                                    if (count($row["stops"]) > 0) {
                                        $getOrderId = $orderIdsWithStopIds[$row["stops"][0]["id"]] ?? [];
                                        $bookingId = $getOrderId[0] ?? "";
                                    }
                                    ?>
                                    <tr class="order flow baseOrder" data-id="<?=$row["id"]?>" style="border-top: #fff;">
                                        <td align="center">
                                        <span class="btn btn-xs btn-default showDetailsBtn" onclick="expandOrder(this)" data-optclass="loadRouteOptmise<?=$row["id"]?>">
                                            <i class="fa fa-chevron-circle-down showDetails" title="Show Details"></i>
                                        </span>
                                        </td>
                                        <td>

                                            <?php
                                            if($this->session->userdata()['business_type']=='Truck_Owner'){ ?>
                                                <a class="btn btn-xs btn-default" href="<?=base_url()?>shift/newShift/<?=$row["id"]?>" title="Edit"><i class="fas fa-pencil-alt"></i></a>
                                            <?php } ?>
                                            <?php
                                            $company_code = $this->session->userdata('company_code');
                                            if (checkAccessConditions('ENABLE_RU_DOWNLOADEXCEL_OPTION', $company_code)):
                                            else: ?>
                                                <div class="btn btn-xs btn-default" title="<?= $this->lang->line('generate_twb') ?>" onclick="validateTruckWayBillGeneration(<?=$row['id']?>)">
                                                    <i class="fa fa-file-pdf-o"></i>
                                                </div>
                                            <?php
                                            endif; ?>
                                            <div class="btn btn-xs btn-default " title="<?= $this->lang->line('share_secure_link') ?>" onclick="secureLink('<?= $row["shipmentid"]; ?>','<?= $row["vendor_id"]; ?>','<?= $row['shipmentid'] ?>','<?= $row['txnid'] ?>')"><i class="fa fa-link"></i></div>
                                            <div class="btn btn-xs btn-default clipboard" title="Copy link for share" data-clipboard-text="<?php echo base_url('livetrack/etnshipment/')."/".$bookingId."?inner";?>"><i class="fa fa-copy"></i></div>
                                            <div class="btn btn-xs btn-default" title="<?= $this->lang->line('details_and_live_map') ?>" onclick="livetrackdetails('<?= $bookingId ?>')"><i class="fa fa-map"></i> <?= $this->lang->line('details') ?></div>
                                            <div class="btn btn-xs btn-default" title="Status History" onclick="openHistory('<?=$row["id"]?>','','')"><i class="fa fa-list" aria-hidden="true"></i> <?=$this->lang->line('general_status')?></div>
                                            <div class="btn btn-xs btn-default" title="Change/Assign Vehicle" onclick="openAssignVehicle(this,'<?=$row["id"]?>','<?=$row["vendor_id"]?>','<?=$row["total_volume"]?>','<?=$row["vehicle_id"]?>')"><i class="fa fa-truck" aria-hidden="true"></i> <?=$this->lang->line('assign')?></div>
                                        </td>
                                        <td><?=$row["shipmentid"]?></td>
                                        <td title="<?=$row["splace"]?>"><?=substr($row["splace"],0,10)?></td>
                                        <td title="<?=$row["eplace"]?>"><?=substr($row["eplace"],0,10)?></td>
                                        <td><?=date('d M, h:i A',strtotime($row["startdate"]))?></td>
                                        <td><?=date('d M, h:i A',strtotime($row["enddate"]))?></td>
                                        <td><?=$row["carrier_name"]?></td>
                                        <?php if ($scacColumnEnabled) : ?>
                                            <td><?= $row["SCAC"] ?> </td>
                                        <?php endif ?>
                                        <td><?=$row["driver_name"]?></td>
                                        <td><?=$row['register_number'];?></td>
                                    </tr>
                                    <tr class="order emptyTop" data-id="<?=$row["id"]?>">
                                        <td colspan="11" align="center" style="overflow-x:auto;padding: 2px;">
                                            <table>
                                                <?php
                                                if(count($row["stops"])>0){
                                                    if(count($row["stops"])>1){
                                                        $width = 50/(count($row["stops"]) - 1)."%";
                                                    }else{
                                                        $width = 0;
                                                    }
                                                    echo '<tr>';
                                                    for($i=0;$i<count($row["stops"]);$i++){
                                                        $s1 = $row["stops"][$i];
                                                        $stpid = $s1['id'];
                                                        $getpds = $isEmployeeDataAvailable["P"][$row['id']][$stpid] ?? [];
                                                        $chkcircle = "";
                                                        $pickcount = count($getpds);
                                                        if($pickcount>0){
                                                            $chkcircle .= '<span class="name_cirle" style="cursor:pointer;" onclick="popOver(\''.$row['id'].'\',\''.$stpid.'\',\''.'P'.'\')">P<span style="color: white;font-size: smaller;">'.$pickcount.'</span></span> ';
                                                        }
                                                        $getpds = $isEmployeeDataAvailable["D"][$row['id']][$stpid] ?? [];
                                                        $dropcount = count($getpds);
                                                        if($dropcount>0){
                                                            $chkcircle .= '<span class="name_cirle" style="cursor:pointer;" onclick="popOver(\''.$row['id'].'\',\''.$stpid.'\',\''.'D'.'\')">D<span style="color: white;font-size: smaller;">'.$dropcount.'</span></span> ';
                                                        }
                                                        echo '<td width="'.$width.'" align="left" style="padding-left: 10px;">'.$chkcircle.'</td><td colspan="2" width="'.$width.'" align="right" style="padding-right: 20px;"></td>';
                                                    }
                                                    echo '</tr>';
                                                    echo '<tr>';
                                                    for($i=0;$i<count($row["stops"]);$i++){
                                                        $stop = $row["stops"][$i];
                                                        $s1 = $row["stops"][$i];
                                                        $bc_class ="truck_gray_lg";
                                                        $ss ="NOT STARTED";
                                                        $value = $stop["stopstatus"];
                                                        if($value == "0"){
                                                            $bc_class ="truck_gray_lg";
                                                            $ss ="NOT STARTED";
                                                        }else if($value == "1"){
                                                            $bc_class ="truck_orange_lg";
                                                            $ss="IN PROGRESS";
                                                        }else if($value=="2"){
                                                            $bc_class ="truck_green_lg";
                                                            $ss="COMPLETED";
                                                        }
                                                        if($i>0){
                                                            $ps = $row["stops"][$i-1];
                                                            $response = [];
                                                            if($ps["plat"] && $ps["plng"] && $s1["plat"] && $s1["plng"]){
                                                                $response = distanceship($ps["plat"],$ps["plng"],$s1["plat"],$s1["plng"]);
                                                                if($response['distance'] == ""){
                                                                    $response = distancemetrixship($ps["plat"],$ps["plng"],$s1["plat"],$s1["plng"]);
                                                                }
                                                                echo "<td style='font-size: 10px;width: 15px;border-radius: 6%;background: #e9ecef;color: #495057;font-weight: 600;'><div style='text-align:center;height: 10px;' class='stop-distance' data-stop-id='$stpid' data-value='".$response["distance"]."' id='distance_".$ps["plat"]."_".$ps["plng"]."'>". uom_string((float) $response['distance'] / 1000, 'km', 1) ."</div>";
                                                                echo "<div style='text-align:center;height: 14px;' class='stop-duration' data-stop-id='$stpid' data-value='".$response["duration"]."' id='duration_".$ps["plat"]."_".$ps["plng"]."'>".$response["duratext"]."</div></td>";
                                                            }
                                                        }
                                                        echo '<td colspan=2 class="td_stop_lg center '.$bc_class.' pointer" onclick="openPickupandDropsInRows(this,\''.$stop["id"].'\',\''.$row["id"].'\')">'.$ss."</td>";

                                                    }
                                                    echo '</tr>';
                                                }
                                                ?>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr class="expandOrder data emptyTop" data-id="<?=$row["id"]?>">
                                        <td colspan="11" style="padding: 7px;">
                                            <?php
                                            if(count($row["stops"])>0){
                                            echo '<table width="100%" class="table table-striped" style="margin-bottom: 0px;"><thead>';
                                            echo "<tr>";
                                            echo "<th>".$this->lang->line('general_actions')."</th>";
                                            echo "<th>".$this->lang->line('sno')."</th>";
                                            echo "<th>".$this->lang->line('order_id')."</th>";
                                            echo $displayDeliveryNote ? "<th>".$this->lang->line('qbook_deliverynote')."</th>" : "";
                                            echo "<th>".$this->lang->line('general_location')."</th>";
                                            echo "<th>".$this->lang->line('general_address')."</th>";
                                            echo "<th>".$this->lang->line('general_type')."</th>";
                                            echo "<th>".$this->lang->line('general_start')."</th>";
                                            echo "<th>".$this->lang->line('general_end')."</th>";
                                            echo "<th>".$this->lang->line('general_weight')."</th>";
                                            echo "<th>".$this->lang->line('general_volume')."</th>";
                                            echo "<th>".$this->lang->line('general_status')."</th>";
                                            echo "<th>".$this->lang->line('total_units')."</th>";
                                            echo "<th>".$this->lang->line('updated_units')."</th>";
                                            echo "</tr></thead>";
                                            foreach($row["stops"] as $index=>$stop){
                                            $ship_units_class="";
                                            if($stop["act_ship_units"]!=$stop["ship_units"] && strlen($stop["ship_units"])>0){
                                                $ship_units_class="tr-red";
                                            }
                                            echo '<tr class="pointer '.$ship_units_class.' stop'.$stop["id"]."_".$row["id"].'" onclick="openPickupandDrops(this,\''.$stop["id"].'\',\''.$row["id"].'\')">';
                                            ?>
                                        <td><div class="btn btn-xs btn-default" title="History" onclick="openHistory('<?=$row["id"]?>','<?=$stop["id"]?>','')">Status History</div></td>
                                        <?php
                                        echo "<td>".($index+1)."</td>";
                                        $bookingIds = implode(', ', ($orderIdsWithStopIds[$stop["id"]] ?? []));
                                        echo "<td title='".$bookingIds."' class='unwrap'>".$bookingIds."</td>";
                                        if ($displayDeliveryNote) :
                                            if ($stop['id'] > 0) :
                                                $deliveryNote = @getDeliveryNotes($bookingIds);
                                                echo "<td title='" . $deliveryNote . "' class='unwrap'>" . $deliveryNote . "</td>";
                                            else:
                                                echo "<td></td>";
                                            endif;
                                        endif;
                                        echo "<td>".(substr($stop["stopname"],0,10))."</td>";
                                        echo "<td>".(substr($stop["address"],0,10))."</td>";
                                        echo "<td>".$stop["stoptype"]."</td>";
                                        echo "<td>".(date("d M, h:i A",strtotime($stop["startdate"])))."</td>";
                                        echo "<td>".(date("d M, h:i A",strtotime($stop["enddate"])))."</td>";
                                        echo "<td>".uom_string($stop["weight"], 'kg')."</td>";
                                        echo "<td>".uom_string($stop["volume"], 'cbm')."</td>";
                                        $v = "";
                                        if($stop["stopstatus"] == 0){ $v = 'New';}else if($stop["stopstatus"] == 1){ $v = 'In-Transit';}else{
                                            if($stop["stoptype"] == "D"){ $v = 'Delivered'; } else { $v = "Picked up"; }
                                        }
                                        echo "<td>".$v."</td>";
                                        echo "<td>".$stop["act_ship_units"]."</td>";
                                        echo "<td>".$stop["ship_units"]."</td>";
                                        echo '</tr>';
                                        echo '<tr class="excluded"></tr>';
                                        }
                                        echo '</table>';
                                        }
                                        ?>
                                        </td>
                                    </tr>
                                    <tr class="expandOrder data emptyTop" data-id="<?=$row["id"]?>">
                                        <td colspan="11" style="padding: 7px;">
                                            <center><button class="btn btn-xs btn-default loadRouteOptmise<?=$row["id"]?>" onclick="loadRouteOptmise(<?=$row["id"]?>,this)">Route Optimization</button></center>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <div>
                        <?php if(count($orders)>0){ ?>
                            <ul class="pagination pagination-sm no-margin pull-right">
                                <?php echo $this->pagination->create_links(); ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
                <div class="overlay" style="display: none;">
                    <i class="fa fa-refresh fa-spin"></i>
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
</section>
<div class="modal containerModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Modal body text goes here.</p>
            </div>
        </div>
    </div>
</div>
<input type="text" class="form-control" name="lat" id="sarea" placeholder="Lat,long with comma seperation" value="" required style="display: none" />
<input type="text" class="form-control" name="lat" id="earea" placeholder="Lat,long with comma seperation" value="" required style="display: none" />
<input type="text" class="form-control" name="lat" id="source" placeholder="Lat,long with comma seperation" value="" required style="display: none" />
<div id="tost" class="tost" style="display:none;"></div>
<script src="<?= base_url('assets/confirm/jquery-confirm.js') ?>"></script>
<link href="<?= base_url('assets/confirm/jquery-confirm.css') ?>" rel="stylesheet" type="text/css">
<script type="text/javascript">
    $(document).ready(function(){
        if($(".buffer").length){
            $(".buffer").hide();
        }
        if($(".content").length){
            $(".content").show();
        }
        var clipboard = new ClipboardJS('.clipboard');
        clipboard.on('success', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
            alert("URL Copied to Clipboard!");
            e.clearSelection();
        });
        clipboard.on('error', function(e) {
            console.error('Action:', e.action);
            console.error('Trigger:', e.trigger);
        });
    });
    function livetrackdetails(ordid){
        if(ordid != ""){
            var url = baseurl+"livetrack/etnshipment/"+ordid;
            var modal = $("#fullScreenModal");
            modal.find(".modal-sub-title").html("Live Track:: "+ordid);
            $('#fullScreenModal').modal('toggle');
            modal.find("#viewrtdata").addClass('no-padding');
            modal.find("#viewdata").html('<iframe src="' + url + '" scrolling="no" frameBorder="0" width="100%" height="100%">/iframe>');
            $('#fullScreenModal').on('hidden.bs.modal', function () {
                $("#fullScreenModal").find("#viewrtdata").find("iframe").remove();
            });
        }
    }
    function popOver(ship,stop,type) {
        $.ajax({
            url:"<?=base_url('visibility/popOverData')?>",
            data:{
                shipment_id:ship,
                stop_id:stop,
                type:type
            },
            type:"POST",
            beforeSend:function(){
                $(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("STOP DETAILS");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
                $(".buffer").hide();
                $(".containerModal").find(".modal-body").html(data);
            }
        });
    }
    function closeme(ele,shift_id){
        var td=$(ele).closest("td");
        td.html('<center><button class="btn btn-xs btn-default" onclick="loadRouteOptmise('+shift_id+',this)">Route Optimization</button></center>');
    }
    function loadRouteOptmise(shift_id,ele){
        var td=$(ele).closest("td");
        var tdBody = td.html();
        $.ajax({
            url:"<?=base_url('shift/loadRouteVehs')?>",
            type:"POST",
            data:{id:shift_id},
            beforeSend:function(){
                td.html("<center><progress></center>");
            },
            success:function(data){
                td.html(data);
            },
            error:function(){
                td.html(tdBody);
            }
        })
    }
    function expandOrder(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function(){
            $(this).hide();
        });
        if($(ele).find(".showDetails").hasClass("fa-chevron-circle-down")){
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
            $(ele).find(".showDetails").removeClass("fa-chevron-circle-down");
            $(ele).find(".showDetails").addClass("fa-chevron-circle-up");
            $(ele).find(".showDetails").attr("title","Hide Details");
            $(".expandOrder").each(function(){
                if($(this).data("id")==id){
                    $(this).css("display","table-row");
                }
            });
            $("."+$(ele).data("optclass")).click();
        }else{
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
        }
    }
    function expand_Order(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function(){
            if($(this).data("id")==id){
                $(this).css("display","table-row");
            }
        });
    }
    function openPickupandDropsInRows(ele,stopId,shiftId){
        $.ajax({
            url:"<?=base_url('visibility/getPickupAndDrops')?>/"+stopId+"/"+shiftId,
            data:{
                stopId:stopId,
                shiftId:shiftId
            },
            type:"POST",
            beforeSend:function(){
                if(!$(ele).closest(".order").prev("tr").find(".showDetails").hasClass("fa-chevron-circle-up"))
                    $(ele).closest(".order").prev("tr").find(".showDetailsBtn").click();
                $(".excluded").each(function(){
                    $(this).html("");
                });
                $(".buffer").show();
                $(".stop"+stopId+"_"+shiftId).next("tr").html("<td colspan='12' align='center'><progress></td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-title").html("Pick and Drops");
                // $(".containerModal").find(".modal-body").html("<center></progress></center>");
                // $(".containerModal").find(".modal-footer").hide();
            },
            success:function(data){
                $(".buffer").hide();
                $(".stop"+stopId+"_"+shiftId).next("tr").html("<td colspan='12' align='center'>"+data+"</td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-body").html(data);
            }
        });
    }
    function openPickupandDrops(ele,stopId,shiftId){
        $.ajax({
            url:"<?=base_url('visibility/getPickupAndDrops')?>/"+stopId+"/"+shiftId,
            data:{
                stopId:stopId,
                shiftId:shiftId
            },
            type:"POST",
            beforeSend:function(){
                $(".excluded").each(function(){
                    $(this).html("");
                });
                $(".buffer").show();
                $(ele).next("tr").html("<td colspan='12' align='center'><progress></td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-title").html("Pick and Drops");
                // $(".containerModal").find(".modal-body").html("<center></progress></center>");
                // $(".containerModal").find(".modal-footer").hide();
            },
            success:function(data){
                $(".buffer").hide();
                $(ele).next("tr").html("<td colspan='12' align='center'>"+data+"</td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-body").html(data);
            }
        });
    }
    function openAssignVehicle(ele,shiftId,carrierId,volume,vehicle_id){
        $.ajax({
            url:"<?=base_url('visibility/openAssignVehicle')?>",
            data:{
                carrier_id:carrierId,
                shift_id:shiftId,
                volume:volume,
                vehicle_id:vehicle_id
            },
            type:"POST",
            beforeSend:function(){
                $(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Assign Vehicle");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
                if ($.trim(data) === '1') {
                    $(".containerModal").find(".modal-body").css("text-align", "center");
                    data = "<span style='font-size:16px;color:red;'> You can't assign driver to this shipment because this shipment has the legs</span>";
                }
                $(".buffer").hide();
                $(".containerModal").find(".modal-body").html(data);

            }
        });
    }
    function getVehicles(volume,vehicle_id){
        var carrier_id = $(".containerModal").find("#carrier_id").val();
        $.ajax({
            url:"<?=base_url('visibility/getVehciles')?>",
            type:"POST",
            data:{
                carrier_id:carrier_id,
                volume:volume
            },
            dataType:"JSON",
            success:function(data){
                $(".containerModal").find("#vehicle_id").html("<option>-select-</option>");
                $.each(data["vehicles"],function(i,value){
                    if(value.id == vehicle_id){
                        $("#hiddenValues").data("veh",value.id);
                        $("#hiddenValues").data("reg",value.register_number);
                        $(".containerModal").find("#vehicle_id").append("<option data-reg='"+value.register_number+"' value='"+value.id+"' selected>"+value.register_number+" - "+value.size+" Sq Units</option>");
                    }else{
                        $(".containerModal").find("#vehicle_id").append("<option data-reg='"+value.register_number+"' value='"+value.id+"'>"+value.register_number+" - "+value.size+" Sq Units</option>");
                    }
                });
            }
        });
    }
    function assignVehicleToShipmentStop(ele){
        var shipment_id = $('#assignVehicleToShipmentStop').find("#shipment_id").val();
        var new_vehicle_id = $('#assignVehicleToShipmentStop').find("#vehicle_id").val();
        var vehicle_id = $("#hiddenValues").data("veh");
        var register_number = $("#hiddenValues").data("reg");
        if(new_vehicle_id == vehicle_id){
            $(ele).closest("modal").modal("toggle");
            $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Vehicle data updated successfully!</center>");
            return false;
        }else if(register_number!="" && vehicle_id!=""){
            var r = confirm("Are you sure you want to update vehicle to this shipment?");
            if (r == true) {
                $.ajax({
                    url:"<?php echo base_url('visibility/checkTrip');?>",
                    data:{"vehicle_id":vehicle_id,"shift_id":shipment_id},
                    type:"POST",
                    // dataType:"JSON",
                    beforeSend:function(){
                        $(".assignVehicleToShipmentStopOverlay").show();
                    },
                    success:function(data){
                        $(".assignVehicleToShipmentStopOverlay").hide();
                        if(data=="1"){
                            $.confirm({
                                title: 'Warning',
                                content: "Vehcile "+register_number+" has active trip, are you sure to change vehcle",
                                confirmButton: 'Yes',
                                confirmButtonClass: 'btn-success',
                                autoClose: 'cancel|30000',
                                icon: 'fa fa-warning',
                                animation: 'blur',
                                confirm: function(){
                                    asignVehcile(ele);
                                },
                                cancel: function () {
                                    $('#assignVehicleToShipmentStop').find("#vehicle_id").val(vehicle_id);
                                }
                            });
                        }else{
                            asignVehcile(ele);
                        }
                    }
                });
            }
        }else{
            asignVehcile(ele);
        }
        return false;
    }

    function asignVehcile(ele) {
        var dataa = $(ele).serializeArray();
        $.ajax({
            url:"<?=base_url('visibility/assignVehicleToShipmentStop')?>",
            type:"POST",
            data:dataa,
            beforeSend:function(){
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
                if(data=="1"){
                    $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Successfully assigned!</center>");
                }else{
                    $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Vehicle un-assigned Successfully!</center>");
                }
            },error:function(){
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Vehicle assigning failed!</center>");
            }
        });
    }

    function openHistory(shift_id,stop_id,pickup_id){
        $.ajax({
            url:"<?=base_url('visibility/openHistory')?>",
            type:"POST",
            data:{shift_id:shift_id,stop_id:stop_id,pickup_id:pickup_id},
            beforeSend:function(){
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Status History & Attached documents");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
                $(".containerModal").find(".modal-body").html(data);
            },error:function(){
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
            }
        });
    }

    function sendToServer(optmised,originals){
        var opt=[];
        opt.push(0);
        for(var aa=0;aa<optmised.length;aa++){
            opt.push(optmised[aa]+1);
        }
        opt.push(opt.length+1);
        $.ajax({
            url:"<?=base_url('shift/sendToServer')?>",
            type:"POST",
            data:{opt:opt,org:originals},
            success:function(){
            }
        })
    }

    function validateTruckWayBillGeneration(shiftId) {
        $.ajax({
            url: baseurl + 'Kntruckwaybill/validateTruckWayBillGeneration',
            type: 'POST',
            dataType: 'json',
            data: {'shiftId': shiftId},
            success: function (data) {
                if(data['status'] >0){
                    window.open(baseurl + 'kntruckwaybill/generateTruckWayBillByShiftId/' + shiftId, '_blank');
                }else{
                    openToast($("#tost"), data['message']);
                }
            }
        });
    }
    function openToast(toast, message) {
        toast.show();
        toast.html(message);
        toast.fadeIn()
            .css({top: 1000, position: 'absolute'})
            .animate({top: 275}, 800, function () {
            });
        setTimeout(function () {
            toast.hide('blind', {}, 800)
        }, 8000);
    }
</script>
<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/css/progress-wizard.css">
<style type="text/css">
    .tost {
        position: fixed;
        background-color: #FF3333;
        padding: 10px;
        z-index: 999;
        color: #fff;
        border-radius: 6px;
        box-shadow: 1px 1px #bebebe;
        right: 30px;
        display: none;
        top: 250px;
    }
    .unwrap{
        text-overflow: ellipsis;
        white-space: normal;
        overflow: hidden;
        max-width: 250px;
    }
    .btn-success {
        background-color: #0a5797 !important;
        border-color: #0a5797 !important;
    }
    /*.table .thead-light th {
        color: #495057;
        background-color: #e9ecef;
        border-color: #dee2e6;
    }*/
    .dataTables_wrapper > .row:nth-of-type(1){
        display: none;
    }
    .progress-indicator > li .bubble{
        display: grid !important;
    }
    .progress-indicator > li{
        color:#333333 !important;
    }
    .map-footer{
        height: 40px;
        width: calc(100%);
        background: transparent;
        position: absolute;
        bottom: 0;
        right: 0;
        padding: 0px;
        border-top-color: transparent;
    }
    .emptyTop td,.emptyTop th{
        border-top: #fff !important;
        width:auto;
    }
    .table {
        margin-bottom: 0px;
    }
    th{
        font-weight: 600;
        font-weight: bold;
        color: gray;
    }
    .discription-td{
        border-bottom: 1px solid #f4f4f4;
    }
    .description-block {
        background-color: #ffffff !important;
        margin: 5px 0;
        padding: 5px;
        text-align: left;
    }
    .description-header{
        text-align: center;
    }
    .pointer{
        cursor: pointer;
    }
    .expandOrder{
        display: none;
    }
    td {
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        max-width: 250px;
    }
    .center{
        text-align: center;
        text-align: -webkit-center;
    }
    .td_stop_sm{
        min-width: 150px;
        min-height: 20px;
    }
    .td_stop_lg{
        min-width: 150px;
        min-height: 30px;
    }
    .left{
        text-align: left;
        padding-left: 10px;
        padding-right:20px;
        max-width: 100px;
    }
    .right{
        text-align: right;
        padding-left: 10px;
        padding-right:20px;
        max-width: 100px;
    }
    .flight_gray_sm{
        background-image: url("<?=base_url('assets/stops/sm/flight_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .flight_green_sm{
        background-image: url("<?=base_url('assets/stops/sm/flight_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .flight_orange_sm{
        background-image: url("<?=base_url('assets/stops/sm/flight_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_gray_sm{
        background-image: url("<?=base_url('assets/stops/sm/ship_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_green_sm{
        background-image: url("<?=base_url('assets/stops/sm/ship_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_orange_sm{
        background-image: url("<?=base_url('assets/stops/sm/ship_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_gray_sm{
        background-image: url("<?=base_url('assets/stops/sm/train_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_green_sm{
        background-image: url("<?=base_url('assets/stops/sm/train_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_orange_sm{
        background-image: url("<?=base_url('assets/stops/sm/train_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_gray_sm{
        background-image: url("<?=base_url('assets/stops/sm/truck_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_green_sm{
        background-image: url("<?=base_url('assets/stops/sm/truck_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_orange_sm{
        background-image: url("<?=base_url('assets/stops/sm/truck_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .flight_gray_lg{
        background-image: url("<?=base_url('assets/stops/lg/flight_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .flight_green_lg{
        background-image: url("<?=base_url('assets/stops/lg/flight_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .flight_orange_lg{
        background-image: url("<?=base_url('assets/stops/lg/flight_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_gray_lg{
        background-image: url("<?=base_url('assets/stops/lg/ship_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_green_lg{
        background-image: url("<?=base_url('assets/stops/lg/ship_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .ship_orange_lg{
        background-image: url("<?=base_url('assets/stops/lg/ship_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_gray_lg{
        background-image: url("<?=base_url('assets/stops/lg/train_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_green_lg{
        background-image: url("<?=base_url('assets/stops/lg/train_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .train_orange_lg{
        background-image: url("<?=base_url('assets/stops/lg/train_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_gray_lg{
        background-image: url("<?=base_url('assets/stops/lg/truck_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_green_lg{
        background-image: url("<?=base_url('assets/stops/lg/truck_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .truck_orange_lg{
        background-image: url("<?=base_url('assets/stops/lg/truck_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .drop_gray{
        background-image: url("<?=base_url('assets/stops/drop_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .drop_green{
        background-image: url("<?=base_url('assets/stops/drop_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .drop_orange{
        background-image: url("<?=base_url('assets/stops/drop_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .pickup_gray{
        background-image: url("<?=base_url('assets/stops/pickup_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .pickup_green{
        background-image: url("<?=base_url('assets/stops/pickup_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .pickup_orange{
        background-image: url("<?=base_url('assets/stops/pickup_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .stop_gray{
        background-image: url("<?=base_url('assets/stops/stop_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .stop_green{
        background-image: url("<?=base_url('assets/stops/stop_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .stop_orange{
        background-image: url("<?=base_url('assets/stops/stop_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }
    .name_cirle{
        height: 15px;
        width: 15px;
        text-align: center;
        vertical-align: middle;
        border-radius: 50%;
        font-size: 11px;
        background: #0a2e55;
        /* display: table-cell; */
        font-weight: 600;
        color: #fff;
        padding-left: 4px;
        padding-right: 4px;
    }
    .tr-red td{
        background-color: #fff4f4 !important;
    }
    .tr-red td .btn-default{
        background-color: #fff4f4 !important;
        border-color: #ffbaba !important;
    }
    .tr-red td .btn-default:hover{
        border-color: #ffe0e0 !important;
    }
</style>
<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/datatables/dataTables.bootstrap.min.css">
<script src="<?php echo base_url();?>assets/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="<?php echo base_url();?>assets/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>

<script type="text/javascript">
    setInterval(function() {
        window.location.reload(true);
    }, 1000 * 60 * 15 );  // reload page every 15 minutes or 900000 milliseconds

    function secureLink(ship_id, vendor_id, shipmentid, voyage_number) {
        $.ajax({
            url: "<?=base_url('visibility/secureLink')?>",
            type: "POST",
            data: {ship_id: ship_id, vendor_id: vendor_id, shipmentid: shipmentid, voyage_number: voyage_number},
            beforeSend: function () {
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Secure link to share");
                $(".containerModal").find(".modal-title").css({'background': '#152c55', 'color': '#fff'});
                $(".containerModal").find(".modal-header").css({'background': 'rgb(21, 44, 85)', 'color': '#fff'});
                $(".containerModal").find(".close").css({'color': '#fff', 'opacity': '1'});
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                $(".containerModal").find(".modal-body").html(data);
            }, error: function () {
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
            }
        });
    }
</script>
