<link href="<?= base_url() ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css"/>
<script src="<?= base_url() ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url('assets/clipboard.min.js') ?>"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>&libraries=places&language=en"></script>
<?php
function getHeadColumn($column)
{
    echo '<th>';
    echo $column;
    echo '</th>';
}
function getColumn($value)
{
    echo '<td>';
    echo $value;
    echo '</td>';
}
$scacColumnEnabled = user_is_using_scac();
?>
<style>
    .containerTable .thead-light th {
        color: #fff;
        border-color: #dee2e6;
        background-color: #244062;
    }

    .expandOrder .table th {
        color: #fff;
        background-color: #244062;
    }

    .btn-xs {
        padding: 1px;
    }

    .btn-xs, .btn-group-xs > .btn {
        font-size: 11px !important;
    }

    td {
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        max-width: 295px !important;
    }

    .tost {
        position: fixed;
        background-color: #FF3333;
        padding: 10px;
        z-index: 999;
        color: #fff;
        border-radius: 6px;
        box-shadow: 1px 1px #bebebe;
        right: 30px;
        display: none;
        top: 250px;
    }

    .tostt {
        position: fixed;
        background-color: #009900;
        padding: 10px;
        z-index: 999;
        color: #fff;
        border-radius: 6px;
        box-shadow: 1px 1px #bebebe;
        right: 30px;
        display: none;
        top: 250px;
    }

    .cursor-pointer {
        cursor: pointer;
    }

    .modelsearch {
        background: #F4F1F8;
        display: inline-block;
        width: 100%;
        padding: 15px;
    }

    .modelsearch .form-group {
        margin-bottom: 0;
    }

    .modal-footer {
        padding: 15px;
        text-align: right;
        border-top: 1px solid #E6ECFC;
        background: #E6ECFC;
    }

    .modal-header {
        background: #152c55;
        padding: 10px;
    }

    .modal-title {
        color: white;
    }
</style>
<script type="text/javascript">
    function callauediapi(shift_id, carrid, ele, carrername) {
        if (['BONDS DC', 'BONDS TRANSPORT'].includes(carrername.toUpperCase()) || ['227', '229'].includes(carrid.toString())) {
            window.open(baseurl + 'Bondsedi/bondsapicall/' + shift_id, '_blank');
        }
        if (['BORDER EXPRESS'].includes(carrername.toUpperCase()) || ['228'].includes(carrid.toString())) {
            window.open(baseurl + 'Bondsedi/bordersapicall/' + shift_id, '_blank');
        }
        return false;
    }
</script>
<div id="tost" class="tost" style="display:none;"></div>
<div id="tostt" class="tostt" style="display:none;"></div>
<script type="text/javascript">
    function ConfirmInActive(id) {
        var x = confirm("Are you sure you want to delete this shipment?");
        if (x) {
            window.location.href = baseurl + "shift/delete/" + id;
            return true;
        } else {
            return false;
        }
    }
</script>

<section class="content-header" style="padding: 7px 15px 0px 15px;">
    <h1><?= $this->lang->line('shipment_visibility') ?></h1>
    <ol class="breadcrumb" style="padding: 0px 0px;">
        <li><a href="<?= base_url() ?>shift/dashboard"><i class="fa fa-home"></i> <?= $this->lang->line('dashboard_home') ?></a></li>
        <li><a href="<?= base_url() ?>visibility/fleetview"><?= $this->lang->line('menu_visibility') ?></a></li>
        <li class="active"><?= $this->lang->line('shipment_visibility') ?></li>
    </ol>
</section>
<section class="content" style="display: none">
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?= $this->lang->line('shipment_visibility') ?></h3>
                    <div class="displayMultiOrderUpdateStatus" data-base-url="<?=base_url()?>" style="position: absolute;right: 300px; top: 5px;display: none;">
                        <div style="padding: 5px" class="btn btn-xs btn-default" title="<?= $this->lang->line('change_assign_vehicle') ?>">
                            <i class="fa fa-truck" aria-hidden="true"></i> <?= $this->lang->line('assign');?>
                        </div>
                    </div>
                    <div class="box-tools">
                        <form method="POST" name="shipvisform" onsubmit="return checkvalidation();" action="<?= base_url() ?>visibility/shipment">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" name="table_search" value ="<?php echo $_POST['table_search'] ?? '';?>" id="table_search" class="form-control pull-right" placeholder="Search" style="border-top-color: #d1d5dd;border-left-color: #d1d5dd;border-right-color: #d1d5dd;">
                                <div class="input-group-btn">
                                    <button type="submit" class="btn btn-default" title="Search" name="frmsub"><i class="fa fa-search"></i></button>
                                    <a href="<?= base_url('visibility/shipment') ?>" class="btn btn-default btn-sm" title="Refresh"><i class="fa fa-refresh"></i></a>
                                    <a href="<?= base_url('shift/newShift') ?>" class="btn btn-success btn-sm" title="Add"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <p id="searchvalidation_message" align="right" style="display:none;margin-bottom: 0; color: red;">Minimum number of characters for a search is 5. Please adjust your search query. </p>
                <div class="box-body" style="overflow-x:auto;">
                    <div class="table-responsive">
                        <table class="table table-striped containerTable">
                            <thead class="thead-light">
                            <tr>
                                <th></th>
                                <th><!--<?= $this->lang->line('general_actions') ?>--></th>
                                <th><?= $this->lang->line('id') ?></th>
                                <th><?= $this->lang->line('general_source') ?></th>
                                <th><?= $this->lang->line('general_destination') ?></th>
                                <th><?= $this->lang->line('start_dt') ?></th>
                                <th><?= $this->lang->line('end_dt') ?></th>
                                <th><?= $this->lang->line('customer') ?></th>
                                <th><?= $this->lang->line('carrier') ?></th>
                                <?php if ($scacColumnEnabled): ?>
                                    <th>SCAC</th>
                                <?php endif; ?>
                                <th><?= $this->lang->line('driver') ?></th>
                                <th><?= $this->lang->line('vehicle') ?></th>
                            </tr>
                            </thead>
                            <tbody style="font-size: 12px;">
                            <?php
                            foreach ($orders as $row):
                                log_message("error","row:".json_encode($row));
                                ?>
                                <tr class="order flow baseOrder" data-id="<?= $row["id"] ?>" style="border-top: #fff;">
                                    <td align="center">
                                    <input type="checkbox" name="multiOrderToCarrierAssign[]" id="multiOrderToCarrierAssign" value="<?= $row["id"] ?>" class="multiOrderToCarrierAssign">
                                    <span class="btn btn-xs btn-default showDetailsBtn" onclick="expandOrder(this)" data-optclass="loadRouteOptmise<?= $row["id"] ?>">
                                        <i class="fa fa-chevron-circle-down showDetails" title="<?= $this->lang->line('show_details') ?>"></i>
                                    </span>
                                    </td>
                                    
                                    <td>
                                        <div class="hoverAction">
                                        <a class="btn btn-xs btn-default" href="<?= base_url() ?>shift/newShift/<?= $row["id"] ?>" title="<?= $this->lang->line('general_edit') ?>"><span class="iconSvk icon-edit-icon"></span></a>
                                        <a class="btn btn-xs btn-default" href="#" title="<?= $this->lang->line('general_delete') ?>" onclick="return ConfirmInActive(<?= $row["id"] ?>);"><span class="iconSvk icon-delete-icon"></span></a>

                                        <?php
                                        $company_code = $this->session->userdata('company_code');
                                        if (checkAccessConditions('ENABLE_RU_DOWNLOADEXCEL_OPTION', $company_code)):
                                            $branch_code = $this->session->userdata('branch_code');
                                            $trip_id = $row["shipmentid"];
                                            $query_string = '/' . $company_code . '/' . $branch_code . '/' . $trip_id . '/EMAIL/TRIP/EXCEL';
                                            $ru_generic_carrier_excel_url = base_url('KNCarrierExtract/GenerateRussiaGenericCarrierExcel/') . $query_string; ?>
                                            <div class="btn btn-xs btn-default" title="<?= $this->lang->line('download') . ' ' . $this->lang->line('excel') ?>" onclick="getRussiaGenericCarrierExcel('<?= $ru_generic_carrier_excel_url ?>')">
                                                <i class="fa fa-file-excel-o"></i>
                                            </div>
                                        <?php
                                        else: ?>
                                            <div class="btn btn-xs btn-default" title="<?= $this->lang->line('generate_twb') ?>" onclick="validateTruckWayBillGeneration(<?=$row['id']?>)">
                                                <i class="fa fa-file-pdf-o"></i>
                                            </div>
                                        <?php endif; ?>

                                        <div class="btn btn-xs btn-default " title="<?= $this->lang->line('share_secure_link') ?>" onclick="secureLink('<?= $row["shipmentid"]; ?>','<?= $row["vendor_id"]; ?>','<?= $row['shipmentid'] ?>','<?= $row['txnid'] ?>')"><i class="fa fa-link"></i></div>
                                        <div class="btn btn-xs btn-default clipboard" title="<?= $this->lang->line('copy_link_for_share') ?>" data-clipboard-text="<?= base_url('livetrack/etnshipment/') . "/" . $row['order_id'] . "?inner" ?>"><i class="fa fa-copy"></i></div>
                                        <div class="btn btn-xs btn-default" title="<?= $this->lang->line('details_and_live_map') ?>" onclick="livetrackdetails('<?= $row['order_id'] ?>')"><i class="fa fa-map"></i> <!--<?= $this->lang->line('details') ?>--></div>
                                        <div class="btn btn-xs btn-default" title="<?= $this->lang->line('status_history') ?>" onclick="openHistory('<?= $row["id"] ?>','','')"><i class="fa fa-list" aria-hidden="true"></i><!--<?= $this->lang->line('general_status') ?>--></div>
                                        <div class="btn btn-xs btn-default" title="<?= $this->lang->line('change_assign_vehicle') ?>" onclick="openAssignVehicle(this,'<?= $row["id"] ?>','<?= $row["vendor_id"] ?>','<?= $row["total_volume"] ?>','<?= $row["vehicle_id"] ?>')"><i class="fa fa-truck" aria-hidden="true"></i> <!--<?= $this->lang->line('assign') ?>--></div>
                                        <?php if ($row['carrier_broker'] === '1'): ?>
                                            <div class="btn btn-xs btn-default" title="Call API" id="callapibtn_<?= $row['id'] ?>" onclick="callshipsyapi('<?= $row["id"] ?>');">
                                                <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                            </div>
                                        <?php elseif ($company_code === "AUKN"): ?>
                                            <div class="btn btn-xs btn-default" title="Call API" onclick="callauediapi('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>');">
                                                <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                            </div>
                                        <?php
                                        elseif ($company_code === "NZKN"):
                                            if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $row["vendor_id"])) {
                                                ?>
                                                <div class="btn btn-xs btn-default" title="Call API" onclick="sendtriptoaltova('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                    <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                                </div>
                                            <?php
                                            } else { ?>
                                                <div class="btn btn-xs btn-default" title="Call API" onclick="calltolinfoxedi('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                    <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                                </div>

                                            <?php
                                            }
                                        elseif ($company_code === "NZPG"):
                                            if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $row["vendor_id"])) {
                                                ?>
                                                <div class="btn btn-xs btn-default" title="Call API" onclick="sendtriptoaltova('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                    <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                                </div>
                                                <?php
                                            } else { ?>
                                                <div class="btn btn-xs btn-default" title="Call API" onclick="calltotoll('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                    <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                                </div>
                                            <?php  }
                                        elseif ($company_code === "CNKN" && checkAccessConditions('CHECK_CHINA_CARRIER_FOR_TRIPOUTBOUND_CALL_API', $row["vendor_id"])): ?>
                                            <div class="btn btn-xs btn-default" title="Call API" onclick="calltotripoutbound('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                            </div>
                                        <?php elseif ($company_code === "CNKN" && checkAccessConditions('CHECK_CHINA_CARRIER_FOR_TRIPOUTBOUND_CALL_API', $row["vendor_id"])): ?>
                                            <div class="btn btn-xs btn-default" title="Call API" onclick="calltotripoutbound('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>')">
                                                <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                            </div>
                                        <?php else: ?>
                                            <div class="btn btn-xs btn-default" title="Call API" id="callapibtn_<?= $row['id'] ?>" onclick="callediapi('<?= $row["id"] ?>','<?= urlencode($row["vendor_id"]) ?>',this,'<?= $row["carrier_name"] ?>');">
                                                <i class="fa fa-cloud" aria-hidden="true"></i> <!--Call API-->
                                            </div>
                                        <?php endif; ?>
                                        <br/>
                                        <div id="api<?= $row["id"] ?>"></div>
                                        <div style="display: none" class="btn btn-xs btn-default" title="<?= $this->lang->line('send_email') ?>" onclick="get_transport_order('<?= $row["shipmentid"] ?>')"><i class="fa fa-envelope" aria-hidden="true"></i> <?= $this->lang->line('send_email') ?></div>
                                    </div>
                                    </td>
                                    <td><?= $row["shipmentid"] ?></td>
                                    <td title="<?= $row["splace"] ?>"><?= substr($row["splace"], 0, 10) ?></td>
                                    <td title="<?= $row["eplace"] ?>"><?= substr($row["eplace"], 0, 10) ?></td>
                                    <td><?= date('d M, h:i A', strtotime($row["startdate"])) ?></td>
                                    <td><?= date('d M, h:i A', strtotime($row["enddate"])) ?></td>
                                    <td><?= $row["customer_name"] ?></td>
                                    <td><?= $row["carrier_name"] ?></td>
                                    <?php if ($scacColumnEnabled): ?>
                                        <td><?= $row["SCAC"] ?> </td>
                                    <?php endif; ?>
                                    <td><?= $row["driver_name"] ?></td>
                                    <td><?= $row['register_number']; ?></td>
                                </tr>
                                <tr class="order emptyTop" data-id="<?= $row["id"] ?>">
                                    <td colspan="11" align="center" style="overflow-x:auto;padding: 2px;">
                                        <table>
                                            <?php
                                            if (count($row["stops"]) > 0):
                                                if (count($row["stops"]) > 1):
                                                    $width = 50 / (count($row["stops"]) - 1) . "%";
                                                else:
                                                    $width = 0;
                                                endif;
                                                echo '<tr>';
                                                for ($i = 0; $i < count($row["stops"]); $i++):
                                                    $s1 = $row["stops"][$i];
                                                    $stpid = $s1['id'];
                                                    $getpds = getpicksdropsbystop($row['id'], $stpid, "P");
                                                    $chkcircle = "";
                                                    $pickcount = count($getpds);
                                                    if ($pickcount > 0):
                                                        $chkcircle .= '<span class="name_cirle" style="cursor:pointer;" onclick="popOver(\'' . $row['id'] . '\',\'' . $stpid . '\',\'' . 'P' . '\')">P<span style="color: white;font-size: smaller;">' . $pickcount . '</span></span> ';
                                                    endif;
                                                    $getpds = getpicksdropsbystop($row['id'], $stpid, "D");
                                                    $dropcount = count($getpds);
                                                    if ($dropcount > 0):
                                                        $chkcircle .= '<span class="name_cirle" style="cursor:pointer;" onclick="popOver(\'' . $row['id'] . '\',\'' . $stpid . '\',\'' . 'D' . '\')">D<span style="color: white;font-size: smaller;">' . $dropcount . '</span></span> ';
                                                    endif;
                                                    echo '<td width="' . $width . '" align="left" style="padding-left: 10px;">' . $chkcircle . '</td><td colspan="2" width="' . $width . '" align="right" style="padding-right: 20px;"></td>';
                                                endfor;
                                                echo '</tr>';
                                                echo '<tr>';
                                                for ($i = 0; $i < count($row["stops"]); $i++):
                                                    $stop = $row["stops"][$i];
                                                    $s1 = $row["stops"][$i];
                                                    $bc_class = "truck_gray_lg";
                                                    $ss = "NOT STARTED";
                                                    $value = $stop["stopstatus"];
                                                    if ($value == "0"):
                                                        $bc_class = "truck_gray_lg";
                                                        $ss = "NOT STARTED";
                                                    elseif ($value == "1"):
                                                        $bc_class = "truck_orange_lg";
                                                        $ss = "IN PROGRESS";
                                                    elseif ($value == "2"):
                                                        $bc_class = "truck_green_lg";
                                                        $ss = "COMPLETED";
                                                    endif;
                                                    if ($i > 0):
                                                        $ps = $row["stops"][$i - 1];
                                                        $response = [];
                                                        if ($ps["plat"] && $ps["plng"] && $s1["plat"] && $s1["plng"]):
                                                            $response = distanceship($ps["plat"], $ps["plng"], $s1["plat"], $s1["plng"]);
                                                            if ($response['distance'] == ""):
                                                                $response = distancemetrixship($ps["plat"], $ps["plng"], $s1["plat"], $s1["plng"]);
                                                            endif;
                                                            echo "<td style='font-size: 10px;width: 15px;border-radius: 6%;background: #e9ecef;color: #495057;font-weight: 600;'><div style='text-align:center;height: 10px;' class='stop-distance' data-stop-id='$stpid' data-value='" . $response["distance"] . "' id='distance_" . $ps["plat"] . "_" . $ps["plng"] . "'>" . uom_string((float) $response['distance'] / 1000, 'km', 1) . "</div>";
                                                            echo "<div style='text-align:center;height: 14px;' class='stop-duration' data-stop-id='$stpid' data-value='" . $response["duration"] . "' id='duration_" . $ps["plat"] . "_" . $ps["plng"] . "'>" . $response["duratext"] . "</div></td>";
                                                        endif;
                                                    endif;
                                                    echo '<td colspan=2 class="td_stop_lg center ' . $bc_class . ' pointer" onclick="openPickupandDropsInRows(this,\'' . $stop["id"] . '\',\'' . $row["id"] . '\')">' . $ss . "</td>";
                                                endfor;
                                                echo '</tr>';
                                            endif;
                                            ?>
                                        </table>
                                    </td>
                                </tr>
                                <tr class="expandOrder data emptyTop" data-id="<?= $row["id"] ?>">
                                    <td colspan="11" class="stopsrow<?= $row['id']?>" style="padding: 7px;">
                                    </td>
                                </tr>
                                <tr class="expandOrder data emptyTop" data-id="<?= $row["id"] ?>">
                                    <td colspan="11" style="padding: 7px;">
                                        <center>
                                            <button class="btn btn-xs btn-default loadRouteOptmise<?= $row["id"] ?>" onclick="getStopDetails(<?= $row["id"] ?>,this)"><?= $this->lang->line('route_optimization') ?></button>
                                        </center>
                                    </td>
                                </tr>
                            <?php
                            endforeach;
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <div>
                        <?php
                        if (count($orders) > 0): ?>
                            <ul class="pagination pagination-sm no-margin pull-right">
                                <?= $this->pagination->create_links() ?>
                            </ul>
                        <?php
                        endif; ?>
                    </div>
                </div>
                <div class="overlay" style="display: none;">
                    <i class="fa fa-refresh fa-spin"></i>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="modal containerModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Modal body text goes here.</p>
            </div>
        </div>
    </div>
</div>

<!--=========================================== send transport order =====================================================-->
<div class="modal" tabindex="-1" role="dialog" id="send_transport_order">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: rgb(21, 44, 85); color: rgb(255, 255, 255);">
                <h5 class="modal-title" style="color: white"><?= lang('send_transport_order') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true" style="color: white;opacity: 2 !important;">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>
<!--===========================================end send transport order =====================================================-->
<!--===========================================Nicplace EDI Transport Order =====================================================-->
<div class="modal fade nicplaceResponseModel" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Nicplace Response</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="pop_message">
                    <table class="table table-striped" id="nicplace_reponse_datatb" style="width: 100%">
                        <thead>
                        <tr>
                            <th scope="col">Order ID</th>
                            <th scope="col">Tour ID</th>
                            <th scope="col">Start Tour</th>
                            <th scope="col">Response</th>
                        </tr>
                        </thead>
                        <tbody id="call_api_response_tb_body"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer success_message_footer">
                <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!--===========================================END Nicplace EDI Transport Order =====================================================-->

<input type="hidden" id="branch_code" value="<?= $branch_code ?>"/>
<input type="hidden" id="company_code" value="<?= $company_code ?>"/>
<script src="<?= base_url('assets/confirm/jquery-confirm.js') ?>"></script>
<link href="<?= base_url('assets/confirm/jquery-confirm.css') ?>" rel="stylesheet" type="text/css">
<script type="text/javascript">
    function checkvalidation() {
        var table_search = $('#table_search').val();
        if (table_search.length < 5) {
            $('#searchvalidation_message').css('display', 'block');
            return false;
        }
    }
    function calltotripoutbound(shift_id, carrid, ele, carrername){
        $.ajax({
            url: "<?= base_url('carriercommonedi/callStandrdEdi') ?>/" + shift_id,
            type: "POST",
            data: {shift_id: shift_id},
            success: function (data) {
                if (data != "0") {
                    $("#tostt").show();
                    $("#tostt").html("API process completed successfully");
                    $("#tostt").fadeIn()
                        .css({top: 1000, position: 'absolute'})
                        .animate({top: 275}, 800, function () {
                        });
                    setTimeout(function () {
                        $("#tostt").hide('blind', {}, 500)
                    }, 5000);
                }
            }
        });
    }
    function calltotoll(shift_id, carrid, ele, carrername) {
        if (carrername == "TOLL NETWORKS (NZ) LTD") {
            $.ajax({
                url: "<?= base_url('carriercommonedi/callTollEdi') ?>/" + shift_id,
                type: "POST",
                data: {shift_id: shift_id},
                success: function (data) {
                    if (data == "0") {
                        $("#tostt").show();
                        $("#tostt").html("API process completed successfully");
                        $("#tostt").fadeIn()
                            .css({top: 1000, position: 'absolute'})
                            .animate({top: 275}, 800, function () {
                            });
                        setTimeout(function () {
                            $("#tostt").hide('blind', {}, 500)
                        }, 5000);
                    }
                }
            });
        } else {
            $("#tost").show();
            $("#tost").html("API not found for Carrier");
            $("#tost").fadeIn()
                .css({top: 1000, position: 'absolute'})
                .animate({top: 275}, 800, function () {
                });
            setTimeout(function () {
                $("#tost").hide('blind', {}, 500)
            }, 5000);
        }
    }
    function calltolinfoxedi(shift_id, carrid, ele, carrername) {
        if (carrername == "LINFOX") {
            $.ajax({
                url: "<?= base_url('Linfoxedi/linfoxedi_call') ?>/" + shift_id,
                type: "POST",
                data: {shift_id: shift_id},
                success: function (data) {
                    if (data == "0") {
                        $("#tostt").show();
                        $("#tostt").html("API process completed successfully");
                        $("#tostt").fadeIn()
                            .css({top: 1000, position: 'absolute'})
                            .animate({top: 275}, 800, function () {
                            });
                        setTimeout(function () {
                            $("#tostt").hide('blind', {}, 500)
                        }, 5000);
                    }
                }
            });
        } else {
            $("#tostt").show();
            $("#tostt").html("API not found for Carrier");
            $("#tostt").fadeIn()
                .css({top: 1000, position: 'absolute'})
                .animate({top: 275}, 800, function () {
                });
            setTimeout(function () {
                $("#tostt").hide('blind', {}, 500)
            }, 5000);
        }
    }

    function sendtriptoaltova(shift_id, carrid, ele, carrername) {
        $.ajax({
            url: "<?= base_url('carriercommonedi/call_edi') ?>/" + shift_id,
            type: "POST",
            data: {shift_id: shift_id},
            success: function (data) {
                if (data == "1") {
                    $("#tostt").show();
                    $("#tostt").html("API process completed successfully");
                    $("#tostt").fadeIn()
                        .css({top: 1000, position: 'absolute'})
                        .animate({top: 275}, 800, function () {
                        });
                    setTimeout(function () {
                        $("#tostt").hide('blind', {}, 500)
                    }, 5000);
                }
            }
        });
    }

    function callediapi(shift_id, carrid, ele, carrername) {
        if ((carrername == "BONDS DC") || (carrername == "BONDS TRANSPORT")) {
            alert(carrername);
            window.open('https://elog360.app/svkonekt_test/bondscarrier/sendmanifest/' + shift_id + '/' + carrid, '_blank');
            return false;
        } else if ((carrername == "BLOWHORN")) {
            $.ajax({
                url: "<?= base_url('carriercommonedi/call_edi') ?>/" + shift_id,
                type: "POST",
                data: {shift_id: shift_id},
                success: function (data) {
                    if (data == "1") {
                        $("#tostt").show();
                        $("#tostt").html("API process completed successfully");
                        $("#tostt").fadeIn()
                            .css({top: 1000, position: 'absolute'})
                            .animate({top: 275}, 800, function () {
                            });
                        setTimeout(function () {
                            $("#tostt").hide('blind', {}, 500)
                        }, 5000);
                    }
                }
            });
        } else {
            $("#callapibtn_" + shift_id).attr("disabled", true);
            var base_url_ajax = "<?= base_url()?>";
            var companyCode = $('#company_code').val()
            var branchCode = $('#branch_code').val()
            var URL = base_url_ajax + "Russia_edi_router/calledi/" + shift_id + "/" + carrid + "/" + carrername;
            if (companyCode && companyCode === 'PLKN' && branchCode && branchCode === 'PLKTW') {
                URL = base_url_ajax + "nicplace/calledi/" + shift_id
            }

            var td = $(ele).closest("td");
            var tdBody = td.html();
            var nicplaceModel = $(".nicplaceResponseModel");
            var table = $('#nicplace_reponse_datatb').DataTable();
            table.destroy();
            $.ajax({
                url: URL,
                type: "POST",
                data: {id: shift_id, carrid: carrid},
                dataType: "json",
                beforeSend: function () {
                    $('#call_api_response_tb_body').html('');
                    nicplaceModel.modal("hide");
                    // nicplaceModel.find(".modal-body").html('Waiting for Nicplace server Response...');
                    $("#api" + shift_id).html("<center><progress></center>");
                    $("#api" + shift_id).show();
                },
                success: function (data) {
                    $("#callapibtn_" + shift_id).attr("disabled", false);
                    $('[data-toggle="tooltip"]').tooltip();
                    $("#api" + shift_id).hide();
                    if (companyCode && companyCode === 'PLKN' && branchCode && branchCode === 'PLKTW') {
                        console.log(data);
                        if (data.status === 1) {
                            openToast($("#tostt"), data.message)
                        } else {
                            openToast($("#tost"), data.message)
                        }
                        // call_api_response_tb_body
                        if (data.data) {
                            nicplaceModel.modal("show");
                            var dataTBArr = [];
                            $.each(data.data, function (key, value, index) {
                                Array.prototype.push.apply(dataTBArr, value);
                            })
                            console.log('dataTBArr ', dataTBArr);
                            // nicplaceModel.find(".modal-body").html(JSON.stringify(data));
                            $("#nicplace_reponse_datatb").DataTable({
                                data: dataTBArr,
                                buttons: [],
                                "bPaginate": true,
                                "paging": false,
                                "bLengthChange": true,
                                "bFilter": true,
                                "bInfo": false,
                                "bAutoWidth": true,
                                "ordering": false,
                                dom: 'Blfrtip',
                                "columns": [
                                    {"data": "order_id"},
                                    {"data": "tour_id"},
                                    {"data": "start_tour"},
                                    {"data": "message"}
                                ],
                            });
                        }
                    } else {
                        if (data.status == 0 || data.status == 1) {
                            openToast($(data.status == 1 ? "#tostt" : "#tost"), data.message);
                        }
                    }
                },
                error: function () {
                    $("#callapibtn_" + shift_id).attr("disabled", false);
                    openToast($("#tost"), "Unable to process request.");
                    $("#api" + shift_id).hide();
                }
            })
        }
    }

    function callshipsyapi(shift_id) {
        $.ajax({
            url: "<?= base_url('api/trip') ?>/",
            type: "POST",
            data: {
                trip_id: shift_id,
            },
            success: function (data) {
                $("#tostt").show();
                $("#tostt").html("API process completed successfully");
                $("#tostt").fadeIn()
                    .css({top: 1000, position: 'absolute'})
                    .animate({top: 275}, 800, function () {
                    });
                setTimeout(function () {
                    $("#tostt").hide('blind', {}, 500)
                }, 5000);
            }
        });
    }

    function openToast(toast, message) {
        toast.show();
        toast.html(message);
        toast.fadeIn()
            .css({top: 1000, position: 'absolute'})
            .animate({top: 275}, 800, function () {
            });
        setTimeout(function () {
            toast.hide('blind', {}, 800)
        }, 8000);
    }

    function getRussiaGenericCarrierExcel(url) {
        window.location.href = url;
    }

    function get_transport_order(trip_id) {
        $.ajax({
            url: "<?= base_url('visibility/sent_transport_order') ?>",
            type: "POST",
            data: {trip_id: trip_id},
            success: function (data) {
                $('#send_transport_order').modal('show');
                $('#send_transport_order .modal-body').html(data);
            }
        });
    }

    $(document).ready(function () {
        if ($(".buffer").length) {
            $(".buffer").hide();
        }
        if ($(".content").length) {
            $(".content").show();
        }
        var clipboard = new ClipboardJS('.clipboard');
        clipboard.on('success', function (e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
            alert("URL Copied to Clipboard!");
            e.clearSelection();
        });
        clipboard.on('error', function (e) {
            console.error('Action:', e.action);
            console.error('Trigger:', e.trigger);
        });
    });

    function livetrackdetails(ordid) {
        if (ordid != "") {
            var url = baseurl + "livetrack/etnshipment/" + ordid;
            var modal = $("#fullScreenModal");
            modal.find(".modal-sub-title").html("Live Track:: " + ordid);
            $('#fullScreenModal').modal('toggle');
            modal.find("#viewrtdata").addClass('no-padding');
            modal.find("#viewdata").html('<iframe src="' + url + '" scrolling="no" frameBorder="0" width="100%" height="100%">/iframe>');
            $('#fullScreenModal').on('hidden.bs.modal', function () {
                $("#fullScreenModal").find("#viewrtdata").find("iframe").remove();
            });
        }
    }

    function popOver(ship, stop, type) {
        $.ajax({
            url: "<?=base_url('visibility/popOverData')?>",
            data: {
                shipment_id: ship,
                stop_id: stop,
                type: type
            },
            type: "POST",
            beforeSend: function () {
                $(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("STOP DETAILS");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                $(".buffer").hide();
                $(".containerModal").find(".modal-body").html(data);
            }
        });
    }

    function closeme(ele, shift_id) {
        var td = $(ele).closest("td");
        td.html('<center><button class="btn btn-xs btn-default" onclick="loadRouteOptmise(' + shift_id + ',this)"><?=$this->lang->line('route_optimization')?></button></center>');
    }

    function getStopDetails(shiftId, ele) {
        if ($(".stopstable" + shiftId).length > 0) {
            loadRouteOptmise(shiftId, ele);
        } else {
            $.ajax({
                url: "<?=base_url('visibility/getalltripstopdetailsbyshiftid')?>",
                type: "POST",
                data: {shiftId: shiftId},
                beforeSend: function () {
                    $('.stopsrow' + shiftId).html("<center><progress></center>");
                },
                success: function (data) {
                    $('.stopsrow' + shiftId).html(data);
                    loadRouteOptmise(shiftId, ele);
                },
                error: function () {
                    $('.stopsrow' + shiftId).html("");
                }
            });
        }
    }

    function loadRouteOptmise(shift_id, ele) {
        var td = $(ele).closest("td");
        var tdBody = td.html();
        $.ajax({
            url: "<?=base_url('shift/loadRouteVehs')?>",
            type: "POST",
            data: {id: shift_id},
            beforeSend: function () {
                td.html("<center><progress></center>");
            },
            success: function (data) {
                td.html(data);
            },
            error: function () {
                td.html(tdBody);
            }
        })
    }

    function expandOrder(ele) {
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function () {
            $(this).hide();
        });
        if ($(ele).find(".showDetails").hasClass("fa-chevron-circle-down")) {
            $(".baseOrder").each(function () {
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title", "Show Details");
            });
            $(ele).find(".showDetails").removeClass("fa-chevron-circle-down");
            $(ele).find(".showDetails").addClass("fa-chevron-circle-up");
            $(ele).find(".showDetails").attr("title", "Hide Details");
            $(".expandOrder").each(function () {
                if ($(this).data("id") == id) {
                    $(this).css("display", "table-row");
                }
            });
            $("." + $(ele).data("optclass")).click();
        } else {
            $(".baseOrder").each(function () {
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title", "Show Details");
            });
        }
    }

    function expand_Order(ele) {
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function () {
            if ($(this).data("id") == id) {
                $(this).css("display", "table-row");
            }
        });
    }

    function openPickupandDropsInRows(ele, stopId, shiftId) {
        $.ajax({
            url: "<?=base_url('visibility/getPickupAndDrops')?>/" + stopId + "/" + shiftId,
            data: {
                stopId: stopId,
                shiftId: shiftId
            },
            type: "POST",
            beforeSend: function () {
                if (!$(ele).closest(".order").prev("tr").find(".showDetails").hasClass("fa-chevron-circle-up"))
                    $(ele).closest(".order").prev("tr").find(".showDetailsBtn").click();
                $(".excluded").each(function () {
                    $(this).html("");
                });
                $(".buffer").show();
                $(".stop" + stopId + "_" + shiftId).next("tr").html("<td colspan='12' align='center'><progress></td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-title").html("Pick and Drops");
                // $(".containerModal").find(".modal-body").html("<center></progress></center>");
                // $(".containerModal").find(".modal-footer").hide();
            },
            success: function (data) {
                $(".buffer").hide();
                $(".stop" + stopId + "_" + shiftId).next("tr").html("<td colspan='12' align='center'>" + data + "</td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-body").html(data);
            }
        });
    }

    function openPickupandDrops(ele, stopId, shiftId) {
        $.ajax({
            url: "<?=base_url('visibility/getPickupAndDrops')?>/" + stopId + "/" + shiftId,
            data: {
                stopId: stopId,
                shiftId: shiftId
            },
            type: "POST",
            beforeSend: function () {
                $(".excluded").each(function () {
                    $(this).html("");
                });
                $(".buffer").show();
                $(ele).next("tr").html("<td colspan='12' align='center'><progress></td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-title").html("Pick and Drops");
                // $(".containerModal").find(".modal-body").html("<center></progress></center>");
                // $(".containerModal").find(".modal-footer").hide();
            },
            success: function (data) {
                $(".buffer").hide();
                $(ele).next("tr").html("<td colspan='12' align='center'>" + data + "</td>");
                // $(".containerModal").modal("show");
                // $(".containerModal").find(".modal-body").html(data);
            }
        });

    }

    function openAssignVehicle(ele, shiftId, carrierId, volume, vehicle_id) {
        $.ajax({
            url: "<?=base_url('visibility/openAssignVehicle')?>",
            data: {
                carrier_id: carrierId,
                shift_id: shiftId,
                volume: volume,
                vehicle_id: vehicle_id
            },
            type: "POST",
            beforeSend: function () {
                $(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Assign Vehicle");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                data = data.toString();
                if ($.trim(data) === '1') {
                    $(".containerModal").find(".modal-body").css("text-align", "center");
                    data = "<span style='font-size:16px;color:red;'> You can't assign driver to this shipment because this shipment has the legs</span>";
                    $(".buffer").hide();
                    $(".containerModal").find(".modal-body").html(data);
                } else {
                    $(".buffer").hide();
                    $(".containerModal").find(".modal-body").html(data);
                }

            }
        });
    }

    function getVehicles(volume, vehicle_id) {
        var carrier_id = $(".containerModal").find("#carrier_id").val();
        $.ajax({
            url: "<?=base_url('visibility/getVehciles')?>",
            type: "POST",
            data: {
                carrier_id: carrier_id,
                volume: volume
            },
            dataType: "JSON",
            success: function (data) {
                $(".containerModal").find("#vehicle_id").html("<option>-select-</option>");
                $.each(data["vehicles"], function (i, value) {
                    if (value.id == vehicle_id) {
                        $("#hiddenValues").data("veh", value.id);
                        $("#hiddenValues").data("reg", value.register_number);
                        $(".containerModal").find("#vehicle_id").append("<option data-reg='" + value.register_number + "' value='" + value.id + "' selected>" + value.register_number + " - " + value.trucktype + " </option>");
                    } else {
                        $(".containerModal").find("#vehicle_id").append("<option data-reg='" + value.register_number + "' value='" + value.id + "'>" + value.register_number + " - " + value.trucktype + " </option>");
                    }
                });
            }
        });
    }

    function assignVehicleToShipmentStop(ele) {
        var activeElement = document.activeElement;
        var active_submit_btn = activeElement.value;
        var action = "just_save";
        if (active_submit_btn == "save_notify_customer") {
            var action = "notify";
        }
        var shipment_id = $('#assignVehicleToShipmentStop').find("#shipment_id").val();
        var new_vehicle_id = $('#assignVehicleToShipmentStop').find("#vehicle_id").val();
        var vehicle_id = $("#hiddenValues").data("veh");
        var register_number = $("#hiddenValues").data("reg");

        var old_driverid = $('#assignVehicleToShipmentStop').find("#driveridhiden").val();
        var new_driverid = $('#assignVehicleToShipmentStop').find("#driver_id").val();
        var notify_parties = $('#assignVehicleToShipmentStop').find("#notify_parties").prop("checked");
        var schedule_date = $('#assignVehicleToShipmentStop').find("#schedule_date").val();
        var carrier_id = $('#assignVehicleToShipmentStop').find("#carrier_id").val();

        if (notify_parties == true) {
            var action = "notify";
            notify_customer_consignee(action, shipment_id);
        }

        if (schedule_date == "") {
            gettoast('top-right', 'city', 'Please Select Schedule Date');
            return false;
        }

        if (carrier_id == "" || carrier_id == "-select-") {
            gettoast('top-right', 'city', 'Please Select Carrier');
            return false;
        }
        if (new_vehicle_id == "-select-" || new_vehicle_id == "-Vehicles not found-") {
            gettoast('top-right', 'city', 'Please Select Vehicle');
            return false;
        }
        if (new_driverid == "") {
            gettoast('top-right', 'city', 'Please Select Driver');
            return false;
        }


        if (register_number != "" && vehicle_id != "") {
            var r = confirm("Are you sure you want to update vehicle to this shipment?");
            if (r == true) {
                $.ajax({
                    url: "<?=base_url('visibility/checkTrip')?>",
                    data: {"vehicle_id": vehicle_id, "shift_id": shipment_id, "action": action},
                    async: false,
                    type: "POST",
                    // dataType:"JSON",
                    beforeSend: function () {
                        $(".assignVehicleToShipmentStopOverlay").show();
                    },
                    success: function (data) {
                        $(".assignVehicleToShipmentStopOverlay").hide();
                        if (data == "1") {
                            $.confirm({
                                title: 'Warning',
                                content: "Vehcile " + register_number + " has active trip, are you sure to change vehcle",
                                confirmButton: 'Yes',
                                confirmButtonClass: 'btn-success',
                                autoClose: 'cancel|30000',
                                icon: 'fa fa-warning',
                                animation: 'blur',
                                confirm: function () {
                                    asignVehcile(ele, new_vehicle_id, action, shipment_id);
                                },
                                cancel: function () {
                                    $('#assignVehicleToShipmentStop').find("#vehicle_id").val(vehicle_id);
                                }
                            });
                        } else {
                            asignVehcile(ele, new_vehicle_id, action, shipment_id);
                        }
                    }
                });
            }
        } else {
            asignVehcile(ele, new_vehicle_id, action, shipment_id);
        }
        return false;
    }

    function asignVehcile(ele, new_vehicle_id = '', action = '', shipment_id = '') {
        var dataa = $(ele).serializeArray();
        $.ajax({
            url: "<?=base_url('visibility/assignVehicleToShipmentStop')?>",
            type: "POST",
            data: dataa,
            async: false,
            beforeSend: function () {
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                $(".containerModal").find(".modal-body").html('');
                if (data == 1) {
                    $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Successfully assigned!</center>");
                    if (new_vehicle_id == "-select-") {
                        window.location.href = baseurl + 'visibility/shipment';
                    }
                    notify_customer_consignee(action, shipment_id, data);
                } else {
                    $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Vehicle un-assigned Successfully!</center>");
                    window.location.href = baseurl + 'visibility/shipment';
                }
            }, error: function () {
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Vehicle assigning failed!</center>");
            }
        });
    }

    function notify_customer_consignee(action, shipment_id, response = '') {
        if (action == "just_save") {
            return false;
        }
        $.ajax({
            url: "<?=base_url('visibility/notify_customer')?>",
            type: "POST",
            data: {'action': action, 'shift_id': shipment_id},
            async: false,
            beforeSend: function () {
                console.log("BeforeSend..");
                $(".assignVehicleToShipmentStopOverlay").show();
            },
            success: function (data) {
                var present_data = '';
                if (response.trim() == "1") {
                    var present_data = $(".containerModal").find(".modal-body").html();
                }
                if ((data.trim()).length > 2) {
                    $(".containerModal").find(".modal-body").html('<center>' + present_data + data + '</center>');
                }
            }, error: function () {
                console.log("BeforeSend error");
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Something is went wrong while notify consignee and customer</center>");
            }
        });
        $(".assignVehicleToShipmentStopOverlay").hide();
    }

    function openHistory(shift_id, stop_id, pickup_id) {
        $.ajax({
            url: "<?=base_url('visibility/openHistory')?>",
            type: "POST",
            data: {shift_id: shift_id, stop_id: stop_id, pickup_id: pickup_id},
            beforeSend: function () {
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Status History & Attached documents");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                $(".containerModal").find(".modal-body").html(data);
            }, error: function () {
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
            }
        });
    }

    function sendToServer(optmised, originals) {
        var opt = [];
        opt.push(0);
        for (var aa = 0; aa < optmised.length; aa++) {
            opt.push(optmised[aa] + 1);
        }
        opt.push(opt.length + 1);
        $.ajax({
            url: "<?=base_url('shift/sendToServer')?>",
            type: "POST",
            data: {opt: opt, org: originals},
            success: function () {
            }
        })
    }

    function secureLink(ship_id, vendor_id, shipmentid, voyage_number) {
        $.ajax({
            url: "<?=base_url('visibility/secureLink')?>",
            type: "POST",
            data: {ship_id: ship_id, vendor_id: vendor_id, shipmentid: shipmentid, voyage_number: voyage_number},
            beforeSend: function () {
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Secure link to share");
                $(".containerModal").find(".modal-title").css({'background': '#152c55', 'color': '#fff'});
                $(".containerModal").find(".modal-header").css({'background': 'rgb(21, 44, 85)', 'color': '#fff'});
                $(".containerModal").find(".close").css({'color': '#fff', 'opacity': '1'});
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                $(".containerModal").find(".modal-body").html(data);
            }, error: function () {
                $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
            }
        });
    }

    function validateTruckWayBillGeneration(shiftId) {
        $.ajax({
            url: baseurl + 'Kntruckwaybill/validateTruckWayBillGeneration',
            type: 'POST',
            dataType: 'json',
            data: {'shiftId': shiftId},
            success: function (data) {
                if(data['status'] >0){
                    window.open(baseurl + 'kntruckwaybill/generateTruckWayBillByShiftId/' + shiftId, '_blank');
                }else{
                    openToast($("#tost"), data['message']);
                }
            }
        });
    }

</script>


<script>

    function gettoast(position, id, desp) {
        if (id != "") {
            //$('#'+id).focus();
            if (!$('#' + id).hasClass('errorclass')) {
                $('#' + id).addClass('errorclass');
            }
        }
        init({
            fade_in: 800,
            fade_out: 800,
            position: position,
        });
        toast({
            type: 'custom',
            title: '<span style="color:#000000ab;">Warning Message</span>',
            description: '<span style="color:black;"><b>' + desp + '</b></span>',
            close_color: '#FF7F50',
            border_color: '#FF8C00',
            color: '#FFBF00',
            timeout: 900
        });
    }

    function openMultiCarrierAssignVehicle() {
        $.ajax({
            url: "<?=base_url('visibility/openAssignVehicle')?>",
            data: {
                carrier_id: carrierId,
                shift_id: shiftId,
                volume: volume,
                vehicle_id: vehicle_id
            },
            type: "POST",
            beforeSend: function () {
                $(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("Assign Vehicle");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success: function (data) {
                data = data.toString();
                if ($.trim(data) === '1') {
                    $(".containerModal").find(".modal-body").css("text-align", "center");
                    data = "<span style='font-size:16px;color:red;'> You can't assign driver to this shipment because this shipment has the legs</span>";
                    $(".buffer").hide();
                    $(".containerModal").find(".modal-body").html(data);
                } else {
                    $(".buffer").hide();
                    $(".containerModal").find(".modal-body").html(data);
                }

            }
        });
    }
</script>
<script src="<?= base_url('assets/js/multiOrderAssignCarrierScript.js?t='.date('dmyhis'))?>"></script>
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/css/progress-wizard.css">
<style type="text/css">
    .unwrap {
        text-overflow: ellipsis;
        white-space: normal;
        overflow: hidden;
        max-width: 250px;
    }

    .btn-success {
        background-color: #244062 !important;
        border-color: #244062 !important;
    }

    .dataTables_wrapper > .row:nth-of-type(1) {
        display: none;
    }

    .progress-indicator > li .bubble {
        display: grid !important;
    }

    .progress-indicator > li {
        color: #333333 !important;
    }

    .map-footer {
        height: 40px;
        width: calc(100%);
        background: transparent;
        position: absolute;
        bottom: 0;
        right: 0;
        padding: 0px;
        border-top-color: transparent;
    }

    .emptyTop td, .emptyTop th {
        border-top: #fff !important;
        width: auto;
    }

    .table {
        margin-bottom: 0px;
    }

    th {
        font-weight: 600;
        font-weight: bold;
        color: gray;
    }

    .discription-td {
        border-bottom: 1px solid #f4f4f4;
    }

    .description-block {
        background-color: #ffffff !important;
        margin: 5px 0;
        padding: 5px;
        text-align: left;
    }

    .description-header {
        text-align: center;
    }

    .pointer {
        cursor: pointer;
    }

    .expandOrder {
        display: none;
    }

    td {
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        max-width: 250px;
    }

    .center {
        text-align: center;
        text-align: -webkit-center;
    }

    .td_stop_sm {
        min-width: 150px;
        min-height: 20px;
    }

    .td_stop_lg {
        min-width: 150px;
        min-height: 30px;
    }

    .left {
        text-align: left;
        padding-left: 10px;
        padding-right: 20px;
        max-width: 100px;
    }

    .right {
        text-align: right;
        padding-left: 10px;
        padding-right: 20px;
        max-width: 100px;
    }

    .flight_gray_sm {
        background-image: url("<?=base_url('assets/stops/sm/flight_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .flight_green_sm {
        background-image: url("<?=base_url('assets/stops/sm/flight_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .flight_orange_sm {
        background-image: url("<?=base_url('assets/stops/sm/flight_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_gray_sm {
        background-image: url("<?=base_url('assets/stops/sm/ship_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_green_sm {
        background-image: url("<?=base_url('assets/stops/sm/ship_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_orange_sm {
        background-image: url("<?=base_url('assets/stops/sm/ship_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_gray_sm {
        background-image: url("<?=base_url('assets/stops/sm/train_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_green_sm {
        background-image: url("<?=base_url('assets/stops/sm/train_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_orange_sm {
        background-image: url("<?=base_url('assets/stops/sm/train_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_gray_sm {
        background-image: url("<?=base_url('assets/stops/sm/truck_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_green_sm {
        background-image: url("<?=base_url('assets/stops/sm/truck_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_orange_sm {
        background-image: url("<?=base_url('assets/stops/sm/truck_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .flight_gray_lg {
        background-image: url("<?=base_url('assets/stops/lg/flight_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .flight_green_lg {
        background-image: url("<?=base_url('assets/stops/lg/flight_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .flight_orange_lg {
        background-image: url("<?=base_url('assets/stops/lg/flight_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_gray_lg {
        background-image: url("<?=base_url('assets/stops/lg/ship_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_green_lg {
        background-image: url("<?=base_url('assets/stops/lg/ship_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .ship_orange_lg {
        background-image: url("<?=base_url('assets/stops/lg/ship_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_gray_lg {
        background-image: url("<?=base_url('assets/stops/lg/train_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_green_lg {
        background-image: url("<?=base_url('assets/stops/lg/train_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .train_orange_lg {
        background-image: url("<?=base_url('assets/stops/lg/train_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_gray_lg {
        background-image: url("<?=base_url('assets/stops/lg/truck_gray.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_green_lg {
        background-image: url("<?=base_url('assets/stops/lg/truck_green.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .truck_orange_lg {
        background-image: url("<?=base_url('assets/stops/lg/truck_orange.png');?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .drop_gray {
        background-image: url("<?=base_url('assets/stops/drop_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .drop_green {
        background-image: url("<?=base_url('assets/stops/drop_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .drop_orange {
        background-image: url("<?=base_url('assets/stops/drop_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .pickup_gray {
        background-image: url("<?=base_url('assets/stops/pickup_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .pickup_green {
        background-image: url("<?=base_url('assets/stops/pickup_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .pickup_orange {
        background-image: url("<?=base_url('assets/stops/pickup_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .stop_gray {
        background-image: url("<?=base_url('assets/stops/stop_gray.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #163155;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .stop_green {
        background-image: url("<?=base_url('assets/stops/stop_green.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .stop_orange {
        background-image: url("<?=base_url('assets/stops/stop_orange.png')?>");
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        color: #fff;
        text-shadow: 0 0 2px #e2eff5;
        -moz-text-shadow: 0 0 2px #e2eff5;
        -webkit-text-shadow: 0 0 2px #e2eff5;
    }

    .name_cirle {
        height: 15px;
        width: 15px;
        text-align: center;
        vertical-align: middle;
        border-radius: 50%;
        font-size: 11px;
        background: #0a2e55;
        font-weight: 600;
        color: #fff;
        padding-left: 4px;
        padding-right: 4px;
    }

    .tr-red td {
        background-color: #fff4f4 !important;
    }

    .tr-red td .btn-default {
        background-color: #fff4f4 !important;
        border-color: #ffbaba !important;
    }

    .tr-red td .btn-default:hover {
        border-color: #ffe0e0 !important;
    }
</style>
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/datatables/dataTables.bootstrap.min.css">
<script src="<?= base_url() ?>assets/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="<?= base_url() ?>assets/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
