<!DOCTYPE html>
<html lang="en">
<?php $this->load->view( 'driverappv3/header' ); ?>

<body>

    <!-- Start Preloader Area -->
    <div class="preloader loader loading_roc" id="preloader">
        <div class="preloader" id="preloaderx" >
            <span></span>
            <span></span>
        </div>
    </div>
    <!-- End Preloader Area -->

    <div id="body_div" style="display: none">
        <?php if ( isset($body_content) && strlen( $body_content ) > 3 ) {
            $data = $response??['code' =>500, 'error' =>'Something went wrong'];
            $this->load->view( $body_content, $data);
        } ?>
    </div>
    <?php $this->load->view( "driverappv3/footer" ); ?>
</body>

<script>
  var token = '<?= $token??'400'?>';
  const _ajaxURL = "<?= base_url()?>";
  const cookieExpireDays = 14;
  const lang_connection_lost = document.getElementById('driverapp_connection_lost').value;
  const lang_driverapp_reload = document.getElementById('driverapp_reload').value;
    window.onbeforeunload = function () {
        document.getElementById('preloader').style.display = "inline-block";
    };
    document.onreadystatechange = function () {
        var state = document.readyState;
        if (state == 'interactive') {
            document.getElementById('preloader').style.display = "block";
        } else if (state == 'complete') {
            setTimeout(function () {
                console.log('called none');
                document.getElementById('interactive');
                // document.getElementById('preloader').style.display = "none";
            }, 1);
        }
    };

  if (token === '400') {
      showIndexBody();
  } else {
      getsecureview(token);
  }

  function checkCookie(cookieName) {
      const deviceUUID = new DeviceUUID().get()
      let cookieDeviceID = getCookie(cookieName);
      if (cookieDeviceID !== "" && cookieDeviceID !== null) {
          return cookieDeviceID;
      } else {
          setCookie(cookieName, deviceUUID);
          return deviceUUID;
      }
  }

  function setCookie(cname, cvalue, exdays = cookieExpireDays) {
      const d = new Date();
      d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
      let expires = "expires=" + d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
  }

  function getCookie(cname) {
      let name = cname + "=";
      let ca = document.cookie.split(';');
      for (let i = 0; i < ca.length; i++) {
          let c = ca[i];
          while (c.charAt(0) === ' ') {
              c = c.substring(1);
          }
          if (c.indexOf(name) === 0) {
              return c.substring(name.length, c.length);
          }
      }
      return null;
  }

  function showIndexBody() {
      const du = new DeviceUUID().parse();
      const browserVersion = du.version !== undefined ? ' ' + du.version : ''
      const deviceMinInfo = {platform: du.platform + ' ' + du.os, browser: du.browser + browserVersion}
      let device_info = ''
      if (du.isMobile) {
          device_info = {mobile: deviceMinInfo};
      } else if (du.isDesktop) {
          device_info = {desktop: deviceMinInfo};
      } else if (du.isTablet) {
          device_info = {tablet: deviceMinInfo};
      }

      const secure_link_device_uuid = checkCookie('secureLinkDeviceUUID');
      const secure_token = $(document).find('body #secure_token').val()
      $(document).find('body #secure_link_device_uuid').val(secure_link_device_uuid);
      $(document).find('body #device_info').val(JSON.stringify(device_info));
      const shipment_id = $('#shipment_id').val()
      const url = _ajaxURL + '/Driverappv3/check_driver_registration/' + shipment_id + '/' + secure_link_device_uuid;
      $.get(url).then(function (res) {
          const resData = JSON.parse(res)
          if (resData.status !== 1) {
              console.log(resData);
              getsecureview(secure_token)
          } else {
              $('#body_div').show();
          }
      }).fail(function (err) {
          set_message(err);
          return false;
      })
  }
  /*  ********** Online / Offline Detection **********  */

  // Request a small image at an interval to determine status

  window.addEventListener('load', function (e) {
    connectionCheckPOP(navigator.onLine)
  }, false)

  window.addEventListener('online', function (e) {
    connectionCheckPOP(e.type)
  }, false)

  window.addEventListener('offline', function (e) {
    connectionCheckPOP(e.type)
  }, false)

  function connectionCheckPOP (connect) {
    if (connect === 'offline') {
      document.getElementById('ios-modal').style.display = 'inline-block'
      // document.getElementById('preloader').style.zIndex = '9999'
      set_message(lang_connection_lost, lang_driverapp_reload)
    } else {
      document.getElementById('ios-modal').style.display = 'none'
      document.getElementById('alert_modal').style.display = 'none'
    }
  }

  /*  ********** Online / Offline Detection ********** END */

    function getsecureview(token) {
        document.getElementById('preloader').style.display = "inline-block";
        var json_as_str = "token=" + token;
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                var res = JSON.parse(this.responseText);
                var status = res.status;
                if (status == "1") {
                    render_secure_view(res.response.url);
                } else {
                    if (status == '2') {
                        set_message(res.message);
                    } else {
                        set_message('Please Provide valid secure link');
                    }
                }
            }
        };
        xhttp.open("POST", "<?= base_url( 'Driverappv3/get_secure_view' ) ?>");
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send(json_as_str);
    }

    Date.prototype.stdTimezoneOffset = function () {
        var jan = new Date(this.getFullYear(), 0, 1);
        var jul = new Date(this.getFullYear(), 6, 1);
        return Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
    }

    Date.prototype.isDstObserved = function () {
        return this.getTimezoneOffset() < this.stdTimezoneOffset();
    }

    var today = new Date();

      async function render_secure_view(url) {
        document.getElementById('preloader').style.display = "inline-block";
        getClientTimeZoneOffset();
        let timeOffset = document.getElementById('client_time_zone_offset').value;
        let myPromise = new Promise(function (myResolve, myReject) {
            let req = new XMLHttpRequest();
            req.open('GET', url + "?timeOffset=" + timeOffset + "&isDST=" + today.isDstObserved());
            req.onload = function () {
                if (req.readyState == 4 && req.status == 200) {
                    if ((req.response).trim() == "") {
                        set_message('Please Refresh again connect to Server', 'Reload');
                    } else {
                        myResolve(req.response);
                    }
                } else {
                    myResolve("Something went wrong");
                }
            };
            req.send();
        });
        document.getElementById("body_div").innerHTML = await myPromise;
        setTimeout(function () {
            setStops();
        }, 100);
        document.getElementById('body_div').style.display = 'block';
        document.getElementById('preloader').style.display = 'none';
    }

  function getClientTimeZoneOffset () {
      var visitortime = new Date()
      document.getElementById('client_time_zone_offset').value = -visitortime.getTimezoneOffset() * 60
  }
</script>

<script type="text/javascript">
    var message = "please wait...";
    var appId = '<?= CHINA_HERE_MAP_API_ID;?>';
    var appCode = '<?= CHINA_HERE_MAP_API_CODE;?>';

    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition, locationShowError, {
                enableHighAccuracy: true,
                timeout: 5000,
                maximumAge: 0
            });
        } else {
            message = "Geolocation is not supported by this browser.";
        }
    }

    function showPosition(position) {
        lat = position.coords.latitude;
        lon = position.coords.longitude;
        $('#geoLocationLatLng').val('lat=' + lat + '&lon=' + lon);
        const companyCode = $('#company_code').val();
        if (companyCode !== 'CNKN') {
            setInTransStatus('4', 'T');
        } else {
            $.getScript(_ajaxURL + "assets/driverappv3/js/WGS-84_to_GCJ-02.js").done(function () {

                var prox=lat+','+lon+','+'250';
                $.ajax({
                  url: 'https://reverse.geocoder.hereapi.cn/6.2/reversegeocode.json',
                  type: 'GET',
                  dataType: 'json',
                  data: {
                    prox: prox,
                    mode: 'retrieveAddresses',
                    maxresults: '1',
                    gen: '9',
                    app_id: appId,
                    app_code: appCode
                  },
                  success: function (data) {
                    var View=data['Response'].View;
                    if (View.length > 0) {
                        var Address =View[0].Result[0].Location.Address;
                        var Label=Address.Label;
                        let Lat_Lang_Array = WGS84_to_GCJ02.prototype.transform(lon, lat);
                        $('#geoLocationLatLng').val('lat=' + Lat_Lang_Array[1] + '&lon=' + Lat_Lang_Array[0]);
                        setInTransStatus('4', 'T');
                    }else{
                       $('#geoLocationLatLng').val('lat=' + lat + '&lon=' + lon);
                        setInTransStatus('4', 'T');
                    }
                  }
                });

            });
        }
    }

    function locationShowError(error) {
        switch (error.code) {
            case error.PERMISSION_DENIED:
                message = "User denied the request for Geolocation."
                break;
            case error.POSITION_UNAVAILABLE:
                message = "Location information is unavailable."
                break;
            case error.TIMEOUT:
                message = "The request to get user location timed out."
                break;
            default:
                message = "An unknown error occurred."
                break;
        }
        set_message(message);
    }
</script>
</html>
