<?php

date_default_timezone_set(DFLT_TZ);

$this->load->helper('generic');

$this->session->set_userdata(
    'prev_uri',
    $prev_url = $this->session->has_userdata('secure_token_link') ?: $this->uri->uri_string()
);

$pickup_drop_stops_master = [];
$soure_name_with_date = $soure_name ?? 'N/A';
$destination_name_with_date = $destination_name ?? 'N/A';
$client_timezone_offset = $client_timezone_offset ?? 2 * 60 * 60;
$isDST = filter_var($isDST, FILTER_VALIDATE_BOOLEAN);
$tz = get_offset_time_abbr($client_timezone_offset, $isDST);
$curtz = $tz ?: $this->session->userdata('timezone');
$share_location_count = 0;
if (!empty($end_points)) {
    $soure_name_with_date = $end_points['source'];
    $destination_name_with_date = $end_points['destination'];
}

$lang_status = [
    'PICKUP_GATE_IN' => lang('driverapp_pickup') . ' - ' . lang('driverapp_gate_in'),
    'PICKUP_OK' => lang('driverapp_pickup') . ' - ' . lang('driverapp_ok'),
    'PICKUP_BROKEN' => lang('driverapp_pickup') . ' - ' . lang('driverapp_damaged'),
    'PICKUP_NOT_DONE' => lang('driverapp_pickup') . ' - ' . lang('driverapp_not_done'),
    'PICKUP_GATE_OUT' => lang('driverapp_pickup') . ' - ' . lang('driverapp_gate_out'),
    'IN_TRANSIT' => 'IN-TRANSIT',
    'DELIVERY_GATE_IN' => lang('driverapp_delivery') . ' - ' . lang('driverapp_gate_in'),
    'DELIVERED' => lang('driverapp_delivery') . ' - ' . lang('driverapp_ok'),
    'DELIVERED_WITH_DAMAGE' => lang('driverapp_delivered') . ' - ' . lang('driverapp_damaged'),
    'DELIVERY_NOT_DONE' => lang('driverapp_delivery') . ' - ' . lang('driverapp_not_done'),
    'DELIVERY_SHORT' => lang('driverapp_delivery') . ' - ' . lang('driverapp_short'),
    'DELIVERY_REFUSED' => lang('driverapp_delivery') . ' - ' . lang('driverapp_refused'),
    'DELIVERY_GATE_OUT' => lang('driverapp_delivery') . ' - ' . lang('driverapp_gate_out'),
];

$lang_status_h3 = [
    'OK'       => lang('driverapp_ok'),
    'BROKEN'   => lang('driverapp_damaged'),
    'NOT_DONE' => lang('driverapp_not_done'),
    'DONE'     => lang('driverapp_ok'),
    'DAMAGE'   => lang('driverapp_damaged'),
    'SHORT'    => lang('driverapp_short'),
    'REFUSED'  => lang('driverapp_refused'),
];

$total_stops = sizeof($pickup) + sizeof($destination);
$trip_num = $pickup[0]->assoc_id;
$quantity_type = $pickup[0]->quantity_type;
$created_source = $pickup[0]->created_source;
$company_code = $pickup[0]->company_code;

function get_dg_goods_str($danger_goods_data)
{
    $limited_qty  = isset($danger_goods_data->limitqty_flag) && $danger_goods_data->limitqty_flag == 'Y' ? 'Limited Quantity <br>' : '';
    $excepted_qty = isset($danger_goods_data->exceptqty_flag) && $danger_goods_data->exceptqty_flag == 'Y' ? 'Excepted Quantity <br>' : '';
    $org_num      = $danger_goods_data->org_number ? ' UN: ' . $danger_goods_data->org_number : '';
    $cl_main_risk = $danger_goods_data->mainrisk ? 'Class ' . $danger_goods_data->mainrisk : '';
    $dg_dsc       = $danger_goods_data->description ? $danger_goods_data->description : '';
    $hf           = $cl_main_risk && $org_num ? ' - ' : ' ';

    return reduce_comma($limited_qty . $excepted_qty . $cl_main_risk . $hf . $org_num . '<br>' . $dg_dsc);
}

function pod_upload_info_icon($pod_ico_info)
{
    foreach ($pod_ico_info as $pod_ic) {
        if (! empty($pod_ic)) {
            echo '<a class="attachIconPod" href="' . base_url('downloadEpod/safelink/' . $pod_ic['hash'] . '.epod') . '" target="_blank"><span class="attach_icon ml-0"><img src="' . base_url('assets/driverappv3/img/attachment.svg') . '" alt="pickup_icon" /></span></a>';
        }
    }
}

?>
<div class="navbar-area navbar-two">
    <?php
    $this->load->view('driverappv3/header_inner'); ?>
    <div class="topid-section">
        <div class="row align-items-center">
            <div class="col-12">
                <div class="headerLocation">
                    <?php
                    if (!empty($legPickupLocations)) {
                        $src_name = $legPickupLocations['street'] . "," . $legPickupLocations['city'] . "," . $legPickupLocations['state'] . "," . $legPickupLocations['country'] . "," . $legPickupLocations['pincode'];
                    } else {
                        $src_name = reduce_comma(html_entity_decode($soure_name_with_date));
                    }
                    if (!empty($legDeliveryLocations)) {
                        $des_name = $legDeliveryLocations['street'] . "," . $legDeliveryLocations['city'] . "," . $legDeliveryLocations['state'] . "," . $legDeliveryLocations['country'] . "," . $legDeliveryLocations['pincode'];
                    } else {
                        $des_name = reduce_comma(html_entity_decode($destination_name_with_date));
                    }
                    ?>
                    <div class="headerLocationText"><span class="iconSvk icon-tracking-icon"></span>
                        <h5><span><?= lang('pickup_address'); ?></span> <?= $src_name ?></h5>
                    </div>
                    <div class="headerLocationArrow"><span class="iconSvk icon-arrow-right"></span></div>
                    <div class="headerLocationText"><span class="iconSvk icon-tracking-icon"></span>
                        <h5><span><?= lang('delivery_address'); ?></span> <?= $des_name ?></h5>
                    </div>
                </div>
            </div>
            <!--<div class="col-6">
                <div class="choose-text_col text-right">
                    <input type="hidden" name="trip_num" id="trip_num" value="<?= $trip_num ?>">
                    <input type="hidden" name="shift_leg_id" id="shift_leg_id" value="<?= $shiftLegId ?>">

                    <h3><?= $trip_num ?></h3>
                </div>
            </div>-->
        </div>
    </div>

    <div class="overlappBlock">
        <!-- <h6><span>Booking ID :</span> <?= $tracking_ref ?></h6> -->
        <h6><span><?= lang('trip_id'); ?>:</span> <?= $trip_num ?></h6>
    </div>
</div>



<!-- Choose Area -->
<section class="trip-block choose-section pt-196 pb-70">
    <div class="container-fluid">
        <div class="row align-items-center left_line_col">
            <?php
            if (in_array($company_code, SECURE_LINK_IN_TRANS_SHARE_LOCATION_ALLOWED_COUNTRIES, true)) { ?>
                <div class="choose-text share-location-left animated animatedFadeInUp fadeInUp">
                    <button class="icon share-ico shadow-card" onclick="getLocation();" data-status="IN_TRANSIT" id="shareLocationBtn">
                        <img class="share-img-ico" src="<?= base_url('assets/driverappv3/img/location_pin-w.svg') ?>" alt="share location">
                    </button>
                    <i class="share-location-count-label" style="display: none" id="locationSharedCount">0</i>
                </div>
                <input type="hidden" value="<?= htmlentities(json_encode([])) ?>" id="shareLocationEligibleOrders">
                <input type="hidden" value="" id="geoLocationLatLng">
                <div class="share-location-left-label animated animatedFadeInUp fadeInUp">
                    <span class="ml-1 font-weight-500 text-shadow" id="shareLocationBtnLabel"
                        onclick="$('#shareLocationBtn').trigger('click')"><?= lang('driverapp_share') ?></span>
                    <span class="ml-1 d-none" id="shareLocationBtnLabelCount"></span>
                </div>
            <?php
            } ?>
            <div class="stopstextRight">
                <button class="animated animatedFadeInUp fadeInUp"> <img src="<?= base_url('assets/driverappv3/img/info2.svg') ?>"></button>
                <p class="animated animatedFadeInUp fadeInUp"><span id="stops_left_val"><?= $total_stops ?></span> <?= lang('driverapp_stops_left'); ?></p>
            </div>
            <?php
            /*
      * Pickup stops list
      */
            $next_id = random_string('alnum', 6);

            foreach ($pickup as $i => $pickup_point) {
                $id                   = $pickup_point->id; // stop details id
                $name                 = $pickup_point->name;
                $pickup_location      = $pickup_point->pickup;
                $drop_location        = $pickup_point->drop;
                $assoc_id             = $pickup_point->assoc_id;
                $plat                 = $pickup_point->plat;
                $plng                 = $pickup_point->plng;
                $ship_type            = $pickup_point->ship_type;
                $cargo_content        = $pickup_point->cargo_content;
                $shipment_volume      = $pickup_point->shipment_volume;
                $startdate            = $pickup_point->startdate;
                $enddate              = $pickup_point->enddate;
                $priority             = $pickup_point->priority;
                $status               = $pickup_point->status;
                $order_id             = $pickup_point->order_id;
                $capacity             = $pickup_point->capacity;
                $milestone            = $pickup_point->milestone;
                $accepted             = $pickup_point->accepted;
                $stop_id              = $pickup_point->stop_id;
                $allstatus            = (array)$pickup_point->allstatus;
                $allstatus_dates      = (array)$pickup_point->allstatus_dates;
                $has_pod              = $pickup_point->has_pod;
                $service_id           = $pickup_point->service_id;
                $service_name         = $pickup_point->service_name;
                $dg_goods             = $pickup_point->dg_goods;
                $order_ref_data       = $pickup_point->order_ref_data;
                $purchase_order       = ($pickup_point->purchase_order == "") ? '-' : $pickup_point->purchase_order; // as customer ref
                $pickup_datetime      = $pickup_point->pickup_datetime;
                $pickup_late_datetime = $pickup_point->pickup_late_datetime;
                $tb_orders_id         = $pickup_point->tb_orders_id;
                $tb_orders_id_list[]  = $pickup_point->tb_orders_id;
                $share_location_count += $pickup_point->share_location_count;
                /*
        *  cargo Details Info
        */
                $cargo_type         = $pickup_point->cargo_type;
                $goods_description1 = $pickup_point->goods_description;
                $length             = $pickup_point->length . ' ' . $pickup_point->length_unit;
                $width              = $pickup_point->width . ' ' . $pickup_point->width_unit;
                $height             = $pickup_point->height . ' ' . $pickup_point->height_unit;
                $quantity           = $pickup_point->quantity;
                $stackable          = $pickup_point->stackable;
                $grounded           = $pickup_point->grounded;
                $splittable         = $pickup_point->splittable;
                $stop_id            = $pickup_point->stop_id;

                $EFP = $kn_office = $order_pic_decs = $tracking_ref = $customer_phone = $trans_con_trip_note = $trans_veh_trip_note = $trans_stop_order_trip_note = $SHIPPER_NAME = $abo_ref = $DEPARTMENT_CODE = '';
                $tracking_ref = $order_id;
                foreach ($order_ref_data as $ref) {
                    $ref = (object)$ref;
                    if ($ref->ref_belongs_to == 'KN OFFICE' && $ref->reference_id == 'INN') {
                        $kn_office = (trim($ref->ref_value) != '') ? $ref->ref_value : '';
                    }

                    switch ($ref->reference_id) {
                        case 'ORD_PIKINST':
                            $order_pic_decs = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'TRACKING_NUMBER':
                            $tracking_ref = $ref->ref_value ?: '';
                            break;

                        case 'TRUCKINGWAYPOINT_PUP_CT_TE':
                            $customer_phone = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'TRANS_COND_TRIP_NOTE':
                            $trans_con_trip_note = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'VEHICLE_TRIP_NOTE':
                            $trans_veh_trip_note = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'STOP_ORDER_TRIP_NOTE':
                            $trans_stop_order_trip_note = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'EFP':
                            $EFP = $ref->ref_value ? $ref->ref_value : '';
                            break;

                        case 'SHIPPER_NAME':
                            $SHIPPER_NAME = $ref->ref_value ? $ref->ref_value : '';
                            break;
                    }

                    switch ($ref->ref_belongs_to) {
                        case 'SHIPPER':
                            $abo_ref = $ref->ref_value ? $ref->ref_value : '--';
                            break;

                        case 'DEPARTMENT_CODE':
                            $DEPARTMENT_CODE = $ref->ref_value ? $ref->ref_value : '--';
                            break;
                    }
                }
                /*
        *  1 - pickup or drop
        *  2 - gate In
        *  3 - gateout
        *  4 - inTransit
        *  5 - pod
        */
                $allstatus[0] = 'avoid it';

                $pickup = $gate_in = $gate_out = $inTransit = $pod = 0;
                foreach (array_reverse($allstatus,true) as $key => $value) {
                    switch ($key) {
                        case 285:
                            $pickup = $value;
                            break;

                        case  274:
                            $gate_in = $value;
                            break;

                        case 275:
                            $gate_out = $value;
                            break;

                        case 278:
                            $inTransit = $value;
                            break;

                        case 286:
                            $pod = $inTransit == '1';
                    }
                }

                $pickup_date = $gate_in_date = $gate_out_date = $inTransit_date = $pod_date = 0;
                foreach ($allstatus_dates as $key => $value) {
                    $value = (object) $value;
                    switch ($key) {
                        case 285:
                            $pickup_date = $value;
                            break;

                        case 274:
                            $gate_in_date = $value;
                            break;

                        case 275:
                            $gate_out_date = $value;
                            break;

                        case 278:
                            $inTransit_date = $value;
                            break;

                        case 286:
                            $pod_date = $inTransit_date == '1';
                    }
                }

                $ship_stops_status_arr = [
                    "status_type"      => 1,
                    "employee_id"      => $id,
                    "order_id"         => $tb_orders_id,
                    "trip_id"          => $shipstopsstatus_atpickup['trip_id'],
                    "shipment_id"      => $shipstopsstatus_atpickup['shipment_id'],
                    "latitude"         => $plat,
                    "longitude"        => $plng,
                    "stop_type"        => "P",
                    "doc_type" => "4",
                    "stop_id"          => $stop_id,
                    "driver_id"        => $shipstopsstatus_atpickup['driver_id'],
                    "timezone"         => $this->session->userdata('timezone'),
                    "stop_detail_type" => $ship_type,
                    "stop_detail_id"   => $id
                ];

                /*
        *  Proof of pick req parameters
        */
                $pop = [
                    "shift_id"       => $shipstopsstatus_atpickup['shipment_id'],
                    // "stop_id" => $shipstopsstatus_atpickup['stop_id'],
                    "stop_id"        => $stop_id,
                    "trip_id"        => $shipstopsstatus_atpickup['trip_id'],
                    "stop_detail_id" => $id,
                    "timezone"       => $this->session->userdata('timezone'),
                    "stop_type"      => "P"
                ];

                /*
        * Save to pick_drop_stops_master
        */
                $macadam_data = [
                    'order_id'            => $order_id,
                    'tracking_ref'        => $tracking_ref,
                    'assoc_id'            => $assoc_id,
                    'ref_value_kn_office' => $kn_office,
                    'order_city'          => $pickup_location,
                    'current_date_time'   => date('Y-m-d\TH:i:s\Z'),
                    'current_time'        => date('H:i:s\Z'),
                    'current_date'        => date('Y-m-d'),
                ];

            ?>
                <!-- Pickup_box-->
                <div class="col-lg-12 col-md-12 animated animatedFadeInUp fadeInUp pickup-details">
                    <input type="hidden" id="pickup_data<?= $i ?>" value="<?= htmlentities(json_encode($ship_stops_status_arr)) ?>">
                    <input type="hidden" id="pickup_macadam_data<?= $i ?>" value="<?= htmlentities(json_encode($macadam_data)) ?>">
                    <input type="hidden" id="pickup_POP_res<?= $i ?>" value="">
                    <div class="cardSecure bg-white ptblr10 ml-25 pk_sec<?= $i ?>">
                        <!-- Pickup card info -->
                        <div class="card shadow-card-sm pickupleft-boarder progress_left_col pk_card">
                            <div class="right_icons_box">
                                <a href="javascript:void(0)">
                                    <div class="choose-text">
                                        <!--<div class="icon" id="icon_p_<?= $i ?>">
                                            <img src="<?= base_url('assets/driverappv3/img/pickup_icon.png') ?>" alt="pickup_icon">
                                        </div>-->
                                        <!-- <h3><?= $tracking_ref ?></h3>-->
                                        <?php
                                        if (!empty($legPickupLocations)): ?>
                                            <h2><?= $legPickupLocations['name'] ?? "" ?></h2>
                                        <?php
                                            echo $legPickupLocations['street'] . "," . $legPickupLocations['state'] . "," . $legPickupLocations['pincode'] . "," . $legPickupLocations['city'] . "," . $legPickupLocations['country'];
                                        else: ?>
                                            <h2><strong><?= $pickup_point->pickup_company; ?>,</strong> <?= reduce_comma(trim($pickup_point->pickup_address_f) . ', ' . trim($pickup_location)) ?></h2>

                                            <?php endif;
                                        $y = 1;
                                        foreach ($cargo_details as $cargo) {
                                            if ($cargo['order_id'] == $pickup_point->tb_orders_id && ($y <= 4)) { ?>
                                                <p class="kg_col animated fadeIn" style="display: none"><?= floatval($cargo['weight']) . ' ' . $cargo['weight_unit'] . ' - ' . intval($cargo['quantity']) . ' ' . $cargo['quantity_type'] ?></p>
                                        <?php
                                                $y++;
                                            }
                                        } ?>
                                        <p class="dt_col animated fadeIn" style="display: none"><?= $pickup_datetime; ?></p>
                                        <p class="dt_col animated fadeIn" style="display: none"><?= $pickup_late_datetime; ?></p>
                                    </div>
                                </a>
                                <p class="information_icon">
                                    <a class="burger-menu pk_info pk_info_sec<?= $i ?>" data-tail="<?= $i ?>" href="javascript:void(0)">
                                        <img src="<?= base_url('assets/driverappv3/img/information_icon-b.png') ?>" alt="information_icon">
                                    </a>
                                </p>
                                <?php

                                $danger_goods_order_id = $t_cg_ord_id = $pickup_point->tb_order_cargodetails_orderid;

                                if ($danger_goods_order_id && $is_danger_goods == 1) {
                                    $danger_goods_data = (array)$dg_goods_arr[$t_cg_ord_id]['danger_goods_data'];
                                ?>
                                    <p class="danger_icon">
                                        <a href="javascript:void(0)" onclick="show_dg(<?= $danger_goods_order_id ?>)">
                                            <img src="<?= base_url('assets/driverappv3/img/adr-ico.svg') ?>" alt="danger_icon" style="width: 25px; height: 25px">
                                        </a>
                                    </p>
                                <?php
                                }

                                if ($EFP) { ?>
                                    <p class="pallete_icon">
                                        <a href="javascript:void(0)">
                                            <span class="label-badge" style="margin-top:3px;"><?= $EFP ?></span>
                                            <img src="<?= base_url('assets/driverappv3/img/eur-b.svg') ?>" alt="pallete_icon">
                                            sdsd
                                        </a>
                                    </p>
                                <?php
                                } ?>
                            </div>
                        </div>
                        <!-- Pickup card info //-->
                        <!-- Pickup Status -->

                        <div class="collapse1" id="p_act_btn_sec<?= $i ?>">
                            <div class="status_col_main">
                                <div class="list_icons">
                                    <ul class="list_stats">
                                        <li>
                                            <?php

                                            $dlv_btn_en  = 0;
                                            $label_stage = '';

                                            if ($gate_in == "0") {
                                                $label_gt_in = '';
                                                $class       = 'pnd_btn';
                                                $ico         = 'b';
                                                $disabled    = '';
                                            } else {
                                                $label_gt_in       = (is_object($gate_in_date)) ? $gate_in_date->date : $gate_in_date;
                                                $label_gt_in_stage = $gate_in_date->status_stage ?: 'PICKUP_GATE_IN';
                                                $class             = 'active2';
                                                $ico               = 'w';
                                                $disabled          = 'disabled';
                                            }

                                            $curr_id = $next_id;
                                            $next_id = random_string('alnum', 6);
                                            ?>
                                            <button type="button" id="gatein_btn" <?= $disabled ?>
                                                onclick="setshipstopstatus('274', 'P', '<?= $i ?>', this);"
                                                data-status="PICKUP_GATE_IN"
                                                data-tail="<?= $i ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                class="gatein_btn <?= $class ?> act_btn">
                                                <!-- <span class="iconSvk icon-estimated-pickup"></span>-->
                                                <img src="<?= base_url('assets/driverappv3/img/gatein.svg') ?>" alt="gate_in" />
                                                <!--<img src="<?= base_url('assets/driverappv3/img/gtin-' . $ico . '.svg') ?>" alt="gate_in"/>-->
                                                <div class="gateIn-hideshow dl_action_lables<?= $i ?>">
                                                    <?php
                                                    if ($label_gt_in) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">

                                                            <small><?= $lang_status[str_replace(' ', '_', $label_gt_in_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_in)), DFLT_TZ)['datetime'])); ?>
                                                            </p>

                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>

                                                <div class="buttonTitle"><?= lang('driverapp_gate_in'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <?php

                                            if ($pickup == "0") {
                                                $label_pk       = '';
                                                $label_pk_stage = 'PICKUP_OK';
                                                $class          = 'pnd_btn';
                                                $ico            = 'b';
                                                $disabled       = $gate_in == "0" ? 'disabled' : '';
                                            } else {
                                                $label_pk       = (is_object($pickup_date)) ? $pickup_date->date : $pickup_date;
                                                $label_pk_stage = $pickup_date->status_stage ?: 'PICKUP_OK';
                                                $class          = 'active2';
                                                $ico            = 'w';
                                                $disabled       = 'disabled';
                                            }

                                            $pk_status_delivery_restrict = $label_pk_stage;
                                            $curr_id                     = $next_id;
                                            $next_id                     = random_string('alnum', 6);
                                            ?>
                                            <input type="hidden" value="<?= str_replace(' ', '_', $label_pk_stage) ?>" id="crd_act_p_<?= $i ?>">
                                            <button type="button" <?= $disabled ?>
                                                onclick="setpickupdata('285', 'P', '<?= $i ?>', this)"
                                                data-status="<?= $label_pk_stage ?>"
                                                data-tail="<?= $i ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                data-order-id="<?= $tb_orders_id ?>"
                                                data-toggle="modal" data-target="#pickupok<?= $i ?>"
                                                class="pickup_btn <?= $class ?> act_btn">
                                                <h5 class="headingLine"><?= lang('driverapp_pickup'); ?></h5>
                                                <!-- <img src="<?= base_url('assets/driverappv3/img/pickup-' . $ico . '.svg') ?>" alt="pickup_icon"/>
                                                   <span class="iconSvk icon-estimated-delivery"></span>-->
                                                <img src="<?= base_url('assets/driverappv3/img/pickup.svg') ?>" alt="gate_in" />

                                                <div class="gateIn-hideshow pk_action_lables<?= $i ?>">
                                                    <?php
                                                    if ($label_pk) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">

                                                            <small><?= $lang_status[str_replace(' ', '_', $label_pk_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_pk)), DFLT_TZ)['datetime'])); ?>
                                                                <?php
                                                                pod_upload_info_icon($pickup_point->pod_uploads_info); ?>
                                                                <?= ($label_pk_stage == 'PICKUP NOT DONE') ? '<span class="kn-info-text text-muted"> ' . lang('driverapp_pickup_not_done_KN_message') . ' </span>' : '' ?>
                                                            </p>


                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>
                                                <div class="buttonTitle"><?= lang('driverapp_pickup'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <?php

                                            if ($gate_out == "0") {
                                                $label_gt_out = '';
                                                $class        = 'pnd_btn';
                                                $ico          = 'b';
                                                $disabled     = $pickup == "0" ? 'disabled' : '';
                                            } else {
                                                $label_gt_out       = (is_object($gate_out_date)) ? $gate_out_date->date : $gate_out_date;
                                                $label_gt_out_stage = $gate_out_date->status_stage ?: 'PICKUP_GATE_OUT';
                                                $class              = 'active2'; //'btn-success';
                                                $disabled           = 'disabled';
                                                $ico                = 'w';
                                                $dlv_btn_en         = 1;
                                                $total_stops--;
                                            }
                                            $curr_id = $next_id;
                                            $next_id = random_string('alnum', 6);
                                            ?>
                                            <button type="button" <?= $disabled ?>
                                                onclick="setshipstopstatus('275', 'P', '<?= $i ?>', this);"
                                                data-status="PICKUP_GATE_OUT"
                                                data-tail="<?= $i ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                data-order-id="<?= $tb_orders_id ?>"
                                                class="gateout_btn <?= $class ?> act_btn">

                                                <!--<img src="<?= base_url('assets/driverappv3/img/gtout-' . $ico . '.svg') ?>" alt="gate_out"/>-->
                                                <img src="<?= base_url('assets/driverappv3/img/gateout.svg') ?>" alt="gate_out" />
                                                <div class="gateIn-hideshow pk_action_lables<?= $i ?>">
                                                    <?php
                                                    if ($label_gt_out) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">
                                                            <small><?= $lang_status[str_replace(' ', '_', $label_gt_out_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_out)), DFLT_TZ)['datetime'])); ?>
                                                            </p>

                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>

                                                <div class="buttonTitle"> <?= lang('driverapp_gate_out'); ?></div>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="gateIn-hideshow pk_action_lables<?= $i ?>">
                                    <?php
                                    if ($label_gt_in) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <small><?= $lang_status[str_replace(' ', '_', $label_gt_in_stage)] ?></small>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_in)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                            </h3>
                                        </div>
                                    <?php
                                    }
                                    if ($label_pk) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <small><?= $lang_status[str_replace(' ', '_', $label_pk_stage)] ?></small>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_pk)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                                <?php
                                                pod_upload_info_icon($pickup_point->pod_uploads_info); ?>
                                                <?= ($label_pk_stage == 'PICKUP NOT DONE') ? '<span class="kn-info-text text-muted"> ' . lang('driverapp_pickup_not_done_KN_message') . ' </span>' : '' ?>
                                            </h3>
                                        </div>
                                    <?php
                                    }
                                    if ($label_gt_out) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <small><?= $lang_status[str_replace(' ', '_', $label_gt_out_stage)] ?></small>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_out)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                            </h3>
                                        </div>
                                    <?php
                                    } ?>
                                </div>
                            </div>
                        </div>
                        <!-- Pickup Status //-->
                    </div>
                </div>
                <div class="modal fade secureModal" id="pickupok<?= $i ?>" tabindex="-1" aria-labelledby="" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                PICKUP
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="pickMain-hideshow animated animatedFadeIn fadeIn secRadioBts" id="pickup_act_ico<?= $i ?>">
                                    <p class="pull-right">
                                        <a class="closebtn" id="closebtn<?= $i ?>" href="javascript:void(0)">
                                            <img src="<?= base_url('assets/driverappv3/img/times.svg') ?>" alt="close_icon" />
                                        </a>
                                    </p>
                                    <ul>
                                        <li>
                                            <div class="pickup-status-option">
                                                <input class="form-check-input action_btn_pk" type="radio" name="pickup_status<?= $i ?>" id="pkdone<?= $i ?>">
                                                <label class="form-check-label" for="pkdone<?= $i ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_done'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="pickup-status-option">
                                                <input class="form-check-input action_btn_pk" type="radio" name="pickup_status<?= $i ?>" id="pkdamage<?= $i ?>">
                                                <label class="form-check-label" for="pkdamage<?= $i ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_damaged'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="pickup-status-option">
                                                <input class="form-check-input action_btn_pk" type="radio" name="pickup_status<?= $i ?>" id="pknotdone<?= $i ?>">
                                                <label class="form-check-label" for="pknotdone<?= $i ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_not_done'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <div class="pickDone-hideshow animated bounceIn" id="btn_com_pic_sec<?= $i ?>" style="display: none;">
                                    <form id="pod_sign_uploads<?= $i ?>" enctype="multipart/form-data" method="POST" autocomplete="off">
                                        <!--- Pickup action from -->
                                        <h2 class="text-center pickdone_heading mb-3 animated bounceIn" id="pickdone_heading<?= $i ?>"><?= lang('driverapp_pickup_status') ?> <span></span></h2>
                                        <div class="back_icon my-2 d-none">
                                            <a class="back_iconbtn" href="#"><img class="back_icon_img" src="<?= base_url('assets/driverappv3/img/undo.svg') ?>" alt="back_icon" /></a>
                                        </div>
                                        <div class="position-relative form-group commentBlock">
                                            <span class="req-inp" id="c_asterisk<?= $i ?>">*</span>
                                            <input type="text" id="comment<?= $i ?>" maxlength="160" class="form-control" form="pod_sign_uploads<?= $i ?>" placeholder="<?= lang('driverapp_comment') ?>" title="<?= lang('driverapp_comment') ?>" required />
                                            <span class="error"></span>
                                        </div>
                                        <div class="position-relative form-group uploadBlock">
                                            <div class="cemara_icon_col">
                                                <span class="req-inp" id="p_asterisk<?= $i ?>">*</span>
                                                <label class="lable_col limitChar label_color_mute" id="fname<?= $i ?>"><?= lang('driverapp_attachment') ?></label>
                                                <input type="file" id="picture<?= $i ?>" name="file_name" class="form-control uploadFile" form="pod_sign_uploads<?= $i ?>" accept="image/*" />
                                                <input type="file" id="picture_cam<?= $i ?>" name="file_name" class="form-control uploadFile" form="pod_sign_uploads<?= $i ?>" accept="image/*" capture="environment" style="display:none;" />
                                                <input type="hidden" id="picture_base64<?= $i ?>">
                                                <input type="hidden" id="picture_base64_cam<?= $i ?>">
                                                <input type="hidden" name="picture_file_name" id="picture_file_name<?= $i ?>">
                                                <input type="hidden" name="status_id" id="status_id<?= $i ?>" form="pod_sign_uploads<?= $i ?>">
                                                <?php
                                                $proof_of_pickup_details = $ship_stops_status_arr;
                                                foreach ($proof_of_pickup_details as $key => $value) { ?>
                                                    <input type="hidden" form="pod_sign_uploads<?= $i ?>" value="<?= $value ?>" name="<?= $key ?>">
                                                <?php
                                                } ?>
                                                <span id="button<?= $i ?>" class="mr-2"><img src="<?= base_url('assets/driverappv3/img/attachment-b.svg') ?>" alt="att_icon"></span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="imgUp">
                                                    <div class="imagePreview" id="imagePreview<?= $i ?>" style="display: none">
                                                        <img src="" style="object-fit: contain" />
                                                    </div>
                                                    <label class="btn btn-primary imageAddCam" id="imgIco<?= $i ?>">
                                                        <img src="<?= base_url('assets/driverappv3/img/camera-b.svg') ?>" alt="camera_icon" onclick="$('#picture_cam<?= $i ?>').trigger('click'); ">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="position-relative form-group">
                                                    <button type="button" class="default-btn confirmsave_btn firstLetterUp" id="confirm_close<?= $i ?>"><?= lang('driverapp_confirm_close') ?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <!--- Pickup action from //-->
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pickup_box //-->
                <!-- Sidebar Modal -->
                <div class="sidebar-modal" id="pickup_info_slide<?= $i ?>">
                    <div class="sidebar-modal-inner">
                        <div class="sidebar-about-area">
                            <div class="titleColm">
                                <h1><?= lang('driverapp_pickup'); ?> </h1>
                            </div>
                            <div class="title">
                                <h2><?= lang('general_info'); ?></h2>
                            </div>
                            <ul class="sidebar_list">
                                <?php if ($tracking_ref): ?>
                                    <li>
                                        <span> <img src="<?= base_url('assets/driverappv3/img/ref_ico-b.svg') ?>" alt="ref_ico" /></span>
                                        <span><?= $tracking_ref ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php
                                if ($DEPARTMENT_CODE) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/dep_code-b.svg') ?>" alt="dep_code" /></span>
                                        <span><?= $DEPARTMENT_CODE ?></span>
                                    </li>
                                <?php
                                } ?>
                                <li>
                                    <span><img src="<?= base_url('assets/driverappv3/img/pickup_address-b.svg') ?>" alt="pickup_address" /></span>
                                    <span class="address_col"><?= reduce_comma(trim($pickup_point->pickup_company) . ', <br>' . trim($pickup_point->pickup_address_f) . ', ' . trim($pickup_location)) ?></span>
                                </li>
                                <li>
                                    <span><img src="<?= base_url('assets/driverappv3/img/pickup_address-b.svg') ?>" alt="pickup_address" /></span>
                                    <span class="address_col"><?= reduce_comma(trim($pickup_point->delivery_company)) . ', <br>' . reduce_comma(trim($drop_location)); ?></span>
                                </li>
                                <?php
                                if ($customer_phone) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/call-contact.svg') ?>" width="19.716" height="21.274" alt="call-contact_icon" /></span>
                                        <span><?= $SHIPPER_NAME . ' <br> ' . $customer_phone ?></span>
                                    </li>
                                <?php
                                }
                                if ($abo_ref) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/abo_ref-b.svg') ?>" alt="abo_ref" /></span>
                                        <span><?= $abo_ref ?></span>
                                    </li>
                                <?php
                                } ?>
                                <?php
                                if ($order_pic_decs) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/pk_desc-b.svg') ?>" alt="pk_desc" /></span>
                                        <span><?= $order_pic_decs ?></span>
                                    </li>
                                <?php
                                } ?>
                                <li>
                                    <span><img src="<?= base_url('assets/driverappv3/img/start_dt-b.svg') ?>" alt="start_dt" /></span>
                                    <span><?= $startdate; ?></span>
                                </li>
                            </ul>
                            <div class="title">
                                <h2><?= lang('driverapp_collection_list') ?></h2>
                            </div>
                            <ul class="sidebar_list stopinfo">
                                <?php
                                $y = 1;
                                foreach ($cargo_details as $cargo) {
                                    if ($cargo['order_id'] == $pickup_point->tb_orders_id && ($y <= 4)) {
                                        $ldm = $cargo['ldm'] > 0 ? ', ' . $cargo['ldm'] : ''; ?>
                                        <li>
                                            <span><img src="<?= base_url('assets/driverappv3/img/cargo_info-b.svg') ?>" alt="cargo_ico" /></span>
                                            <span> <?= $cargo['weight'] . ' ' . $cargo['weight_unit'] . ', ' . $cargo['quantity'] . ' ' . $cargo['quantity_type'] . $ldm ?></span> <br>
                                        </li>
                                <?php
                                        $y++;
                                    }
                                } ?>
                                <?php
                                if (trim($cargo_content)) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/cargo_content-b.svg') ?>" alt="cargo_content_ico" /></span>
                                        <span> <?= (trim($cargo_content) != '') ? $cargo_content : '--'; ?></span>
                                    </li>
                                <?php
                                } ?>
                                <?php
                                if ($EFP) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/eur-b.svg') ?>" alt="efp_ico" /> </span>
                                        <span><?= $EFP ?></span>
                                    </li>
                                <?php
                                } ?>
                                <?php

                                if ($danger_goods_order_id && $is_danger_goods == 1) {
                                    $danger_goods_data = (array)$danger_goods_data;

                                    foreach ($danger_goods_data['response'] as $danger_goods_datum) { ?>
                                        <li>
                                            <span><img src="<?= base_url('assets/driverappv3/img/adr-ico.svg') ?>" alt="danger-ico" /> </span>
                                            <span style="display: inline-block; vertical-align: middle;"><?= get_dg_goods_str((object) $danger_goods_datum); ?></span>
                                        </li>
                                <?php
                                    }
                                }
                                ?>
                            </ul>
                            <?php
                            if ($trans_con_trip_note || $trans_veh_trip_note || $trans_stop_order_trip_note) { ?>
                                <div class="title">
                                    <h2>Trip Notes</h2>
                                </div>
                                <ul class="sidebar_list stopinfo">
                                    <li>
                                        <?= $trans_con_trip_note ?> <br />
                                        <?= $trans_veh_trip_note ?> <br />
                                        <?= $trans_stop_order_trip_note ?>
                                    </li>
                                </ul>
                            <?php
                            } ?>
                        </div>
                        <span class="close-btn sidebar-modal-close-btn"><i class="flaticon-cancel"></i></span>
                    </div>
                </div>
                <!-- End Sidebar Modal -->
            <?php
            }

            foreach ($destination as $k => $drop_point) {
                $id                  = $drop_point->id;
                $name                = $drop_point->name;
                $drop_location       = $drop_point->drop;
                $dlat                = $drop_point->dlat;
                $dlng                = $drop_point->dlng;
                $ship_type           = $drop_point->ship_type;
                $shipment_volume     = $drop_point->shipment_volume;
                $startdate           = $drop_point->startdate;
                $enddate             = $drop_point->enddate;
                $priority            = $drop_point->priority;
                $status              = $drop_point->status;
                $order_id            = $drop_point->order_id;
                $assoc_id            = $drop_point->assoc_id;
                $capacity            = $drop_point->capacity;
                $milestone           = $drop_point->milestone;
                $accepted            = $drop_point->accepted;
                $allstatus           = (array)$drop_point->allstatus;
                $allstatus_dates     = (array)$drop_point->allstatus_dates;
                $has_pod             = $drop_point->has_pod;
                $service_id          = $drop_point->service_id;
                $service_name        = $drop_point->service_name;
                $dg_goods            = $drop_point->dg_goods;
                $order_ref_data      = $drop_point->order_ref_data;
                $purchase_order      = ($drop_point->purchase_order == "") ? '-' : $drop_point->purchase_order;
                $drop_datetime       = $drop_point->drop_datetime;
                $drop_late_datetime  = $drop_point->drop_late_datetime;
                $tb_orders_id        = $drop_point->tb_orders_id;
                $tb_orders_id_list[] = $pickup_point->tb_orders_id;
                $share_location_count += $drop_point->share_location_count;
                // cargo Details Info
                $cargo_type         = $drop_point->cargo_type;
                $goods_description1 = $drop_point->goods_description;
                $length             = $drop_point->length . ' ' . $drop_point->length_unit;
                $width              = $drop_point->width . ' ' . $drop_point->width_unit;
                $height             = $drop_point->height . ' ' . $drop_point->height_unit;
                $quantity           = $drop_point->quantity;
                $stackable          = $drop_point->stackable;
                $grounded           = $drop_point->grounded;
                $splittable         = $drop_point->splittable;
                $stop_id            = $drop_point->stop_id;
                /*
        *  1 - pickup or drop
        *  2 - gate In
        *  3 - gateout
        *  4 - inTransit
        *  5 - pod
        */

                $allstatus[0] = 'avoid it';

                $drop = $gate_in = $gate_out = $inTransit = $pod = 0;
                foreach (array_reverse($allstatus,true) as $key => $value) {
                    switch ($key) {
                        case 280:
                            $drop = $value;
                            break;

                        case 279:
                            $gate_in = $value;
                            break;

                        case 281:
                            $gate_out = $value;
                            break;

                        case 278:
                            $inTransit = $value;
                            break;

                        case 286:
                            $pod = $inTransit == '1';
                    }
                }

                $drop_date = $gate_in_date = $gate_out_date = $inTransit_date = $pod_date = 0;
                foreach ($allstatus_dates as $key => $value) {
                    $value = (object) $value;
                    switch ($key) {
                        case 280:
                            $drop_date = $value;
                            break;

                        case 279:
                            $gate_in_date = $value;
                            break;

                        case 281:
                            $gate_out_date = $value;
                            break;

                        case 278:
                            $inTransit_date = $value;
                            break;

                        case 286:
                            $pod_date = $inTransit_date == '1';
                    }
                }

                $EFP = $kn_office = $order_del_decs = $order_pic_decs = $tracking_ref = $customer_phone = $trans_con_trip_note = $trans_veh_trip_note = $trans_stop_order_trip_note = $CONSIGNEE_NAME = $abo_ref_c = $DEPARTMENT_CODE = '';
                $tracking_ref = $order_id;
                foreach ($order_ref_data as $ref) {
                    $ref = (object)$ref;
                    if ($ref->ref_belongs_to == 'KN OFFICE' && $ref->reference_id == 'INN') {
                        $kn_office = (trim($ref->ref_value) != '') ? $ref->ref_value : '';
                    }

                    switch ($ref->reference_id) {
                        case 'ORD_DLVINST':
                            $order_del_decs = $ref->ref_value ?: '';
                            break;

                        case 'TRACKING_NUMBER':
                            $tracking_ref = $ref->ref_value ?: '';
                            break;

                        case 'TRANS_COND_TRIP_NOTE':
                            $trans_con_trip_note = $ref->ref_value ?: '';
                            break;

                        case 'VEHICLE_TRIP_NOTE':
                            $trans_veh_trip_note = $ref->ref_value ?: '';
                            break;

                        case 'STOP_ORDER_TRIP_NOTE':
                            $trans_stop_order_trip_note = $ref->ref_value ?: '';
                            break;

                        case 'EFP':
                            $EFP = $ref->ref_value ?: '';
                            break;

                        case 'CONSIGNEE_NAME':
                            $CONSIGNEE_NAME = $ref->ref_value ?: '';
                            break;

                        case 'TRUCKINGWAYPOINT_DEL_CT_TE':
                            $customer_phone = $ref->ref_value ?: '';
                            break;
                    }

                    switch ($ref->ref_belongs_to) {
                        case 'CONSIGNEE':
                            $abo_ref_c = $ref->ref_value ?: '--';
                            break;

                        case 'DEPARTMENT_CODE':
                            $DEPARTMENT_CODE = (trim($ref->ref_value) != '') ? $ref->ref_value : '--';
                            break;
                    }
                }

                $ship_stops_drop_status_arr = [
                    "status_type"      => 1,
                    "employee_id"      => $id,
                    "order_id"         => $tb_orders_id,
                    "trip_id"          => $shipstopsstatus_atdrop['trip_id'],
                    "shipment_id"      => $shipstopsstatus_atdrop['shipment_id'],
                    "latitude"         => $dlat,
                    "longitude"        => $dlng,
                    "stop_type"        => "D",
                    // "stop_id" => $shipstopsstatus_atdrop['stop_id'],
                    "stop_id"          => $stop_id,
                    "driver_id"        => $shipstopsstatus_atdrop['driver_id'],
                    "timezone"         => $this->session->userdata('timezone'),
                    "stop_detail_type" => $ship_type,
                    "stop_detail_id"   => $id
                ];

                // Save to pick_drop_stops_master
                $macadam_del_data = [
                    'order_id'            => $order_id,
                    'assoc_id'            => $assoc_id,
                    'tracking_ref'        => $tracking_ref,
                    'ref_value_kn_office' => $kn_office,
                    'order_city'          => $drop_location,
                    'current_date_time'   => date('Y-m-d\TH:i:s\Z'),
                    'current_time'        => date('H:i:s\Z'),
                    'current_date'        => date('Y-m-d'),
                ];

            ?>
                <input type="hidden" id="drop_data<?= $k ?>" value="<?= htmlentities(json_encode($ship_stops_drop_status_arr)) ?>">
                <input type="hidden" id="delivery_macadam_data<?= $k ?>" value="<?= htmlentities(json_encode($macadam_del_data)) ?>">
                <input type="hidden" id="delivery_POD_res<?= $k ?>" value="">
                <!-- drop_box-->
                <div class="col-lg-12 col-md-12 animated animatedFadeInUp fadeInUp drop-details">
                    <div class="cardSecure bg-white ptblr10 ml-25 dl_sec<?= $k ?>" data-tail="<?= $k ?>">
                        <!-- drop card info -->
                        <div class="card shadow-card-sm dropleft-boarder progress_left_col">
                            <a href="javascript:void(0)">
                                <div class="right_icons_box">
                                    <div class="choose-text">
                                        <!--<div class="icon" id="icon_d_<?= $k ?>">
                                            <img src="<?= base_url('assets/driverappv3/img/drop_icon.png') ?>" alt="drop_icon">
                                        </div>
                                        <h3><?= $tracking_ref ?></h3>-->
                                        <?php
                                        if (!empty($legDeliveryLocations)): ?>
                                            <h2><?= $legDeliveryLocations['name'] ?? "" ?></h2>
                                        <?php
                                            echo $legDeliveryLocations['street'] . "," . $legDeliveryLocations['state'] . "," . $legDeliveryLocations['pincode'] . "," . $legDeliveryLocations['city'] . "," . $legDeliveryLocations['country'];
                                        else: ?>
                                            <h2><strong><?= $drop_point->delivery_company ?>,</strong> <?= reduce_comma(trim($drop_point->delivery_address_f) . ', ' . trim($drop_location)) ?></h2>

                                            <?php endif;
                                        $i = 1;
                                        foreach ($cargo_details as $cargo) {
                                            if ($cargo['order_id'] == $drop_point->tb_orders_id && ($i <= 4)) { ?>
                                                <p class="kg_col animated fadeIn" style="display: none"><?= floatval($cargo['weight']) . ' ' . $cargo['weight_unit'] . ' - ' . intval($cargo['quantity']) . ' ' . $cargo['quantity_type'] ?></p>
                                        <?php
                                                $i++;
                                            }
                                        } ?>
                                        <p class="dt_col animated fadeIn" style="display: none">
                                            <?= $drop_datetime; ?>
                                        </p>
                                        <p class="dt_col animated fadeIn" style="display: none">
                                            <?= $drop_late_datetime; ?>
                                        </p>
                                    </div>
                                    <p class="information_icon">
                                        <a class="burger-menu dl_info dl_info_sec<?= $k ?>" data-tail="<?= $k ?>" href="javascript:void(0)">
                                            <img src="<?= base_url('assets/driverappv3/img/information_icon-b.png') ?>" alt="information_icon">
                                        </a>
                                    </p>
                                    <?php

                                    if ($danger_goods_order_id && $is_danger_goods == 1) {
                                        $danger_goods_data = (array)$dg_goods_arr[$t_cg_ord_id]['danger_goods_data']; ?>
                                        <p class="danger_icon">
                                            <a href="javascript:void(0)" onclick="show_dg('<?= $danger_goods_order_id ?>')">
                                                <img src="<?= base_url('assets/driverappv3/img/adr-ico.svg') ?>" alt="danger_icon" style="width: 25px; height: 25px;">
                                            </a>
                                        </p>
                                    <?php
                                    }

                                    if ($EFP) { ?>
                                        <p class="pallete_icon">
                                            <a href="javascript:void(0)">
                                                <span class="label-badge" style="margin-top:3px"><?= $EFP ?></span>
                                                <img src="<?= base_url('assets/driverappv3/img/eur-b.svg') ?>" alt="pallete_icon">
                                            </a>
                                        </p>
                                    <?php
                                    } ?>
                                </div>
                            </a>
                        </div>
                        <!-- drop card info //-->
                        <!-- drop action buttons Status -->



                        <!-- <div class="collapse1" id="d_act_btn_sec<?= $k ?>">
                            <div class="status_col_main"> -->
                        <!-- <h2 class="text-center dl_heading mb-3 animated bounceIn"><?= lang('driverapp_delivery_status') ?><span></span></h2> -->

                        <div class="collapse1" id="d_act_btn_sec<?= $k ?>">
                            <div class="status_col_main">
                                <div class="list_icons">
                                    <ul class="list_stats">
                                        <li>
                                            <?php

                                            $dlv_btn_en = 0;

                                            $b_btn = isset($pk_status_delivery_restrict) && $pk_status_delivery_restrict !== 'PICKUP NOT DONE' ? 1 : 0;

                                            if ($gate_in == "0") {
                                                $class       = 'pnd_btn';
                                                $disabled    = $dlv_btn_en == 1 && $b_btn == 1 ? 'enabled' : 'disabled';
                                                $label_gt_in = '';
                                                $ico         = 'b';
                                            } else {
                                                $label_gt_in       = (is_object($gate_in_date)) ? $gate_in_date->date : $gate_in_date;
                                                $label_gt_in_stage = $gate_in_date->status_stage ?: 'DELIVERY_GATE_IN';
                                                $class             = 'active2';
                                                $ico               = 'w';
                                                $disabled          = 'disabled';
                                            }

                                            $curr_id = $next_id;
                                            $next_id = random_string('alnum', 6);

                                            ?>
                                            <button type="button" <?= $disabled ?>
                                                onclick="setshipstopstatus('279', 'D', '<?= $k ?>', this);"
                                                data-status="DELIVERY_GATE_IN"
                                                data-tail="<?= $k ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                data-order-id="d_<?= $tb_orders_id ?>"
                                                class="gatein_btn <?= $class ?> act_btn">
                                                <h5 class="headingLine"><?= lang('driverapp_delivery'); ?></h5>

                                                <!-- <img src="<?= base_url('assets/driverappv3/img/gtin-' . $ico . '.svg') ?>" alt="gate_in"/>-->
                                                <img src="<?= base_url('assets/driverappv3/img/gatein.svg') ?>" alt="gate_in" />

                                                <div class="gateIn-hideshow dl_action_lables<?= $k ?>">
                                                    <?php
                                                    if ($label_gt_in) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">

                                                            <small><?= $lang_status[str_replace(' ', '_', $label_gt_in_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_in)), DFLT_TZ)['datetime'])); ?>
                                                            </p>

                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>
                                                <div class="buttonTitle"><?= lang('driverapp_gate_in'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <?php
                                            if ($drop == "0") {
                                                $label_dl       = '';
                                                $label_dl_stage = 'DELIVERED';
                                                $class          = 'pnd_btn';
                                                $ico            = 'b';
                                                $disabled       = $dlv_btn_en != 1 && $gate_in == "0" ? 'disabled' : '';
                                            } else {
                                                $label_dl       = (is_object($drop_date)) ? $drop_date->date : $drop_date;
                                                $label_dl_stage = $drop_date->status_stage ?: 'DELIVERED';
                                                $class          = 'active2';
                                                $ico            = 'w';
                                                $disabled       = 'disabled';
                                            }
                                            $curr_id = $next_id;
                                            $next_id = random_string('alnum', 6);
                                            ?>
                                            <input type="hidden" value="<?= str_replace(' ', '_', $label_dl_stage) ?>" id="crd_act_d_<?= $k ?>">
                                            <button type="button" <?= $disabled ?>
                                                onclick="setdeliverydata('280', 'D', '<?= $k ?>', this)"
                                                data-status="<?= $label_dl_stage ?>"
                                                data-tail="<?= $k ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                data-order-id="d_<?= $tb_orders_id ?>"
                                                data-toggle="modal" data-target="#deliveryok<?= $k ?>"
                                                class="delivery_btn <?= $class ?> act_btn">


                                                <img src="<?= base_url('assets/driverappv3/img/drop.svg') ?>" alt="delivery_icon" />

                                                <div class="gateIn-hideshow dl_action_lables<?= $k ?>">
                                                    <?php
                                                    if ($label_dl) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">

                                                            <small><?= $lang_status[str_replace(' ', '_', $label_dl_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_dl)), DFLT_TZ)['datetime'])); ?>
                                                            </p>
                                                            <?php
                                                            pod_upload_info_icon($drop_point->pod_uploads_info); ?>
                                                            <?= ($label_dl_stage == 'DELIVERY NOT DONE') ? '<span class="kn-info-text text-muted"> ' . lang('driverapp_pickup_not_done_KN_message') . ' </span>' : '' ?>
                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>
                                                <div class="buttonTitle"> <?= lang('driverapp_drop'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <?php
                                            if ($gate_out == "0") {
                                                $label_gt_out = '';
                                                $class        = 'pnd_btn';
                                                $ico          = 'b';
                                                $disabled     = $dlv_btn_en != 1 && $drop == "0" ? 'disabled' : '';
                                            } else {
                                                $label_gt_out       = (is_object($gate_out_date)) ? $gate_out_date->date : $gate_out_date;
                                                $label_gt_out_stage = $gate_out_date->status_stage ?: 'DELIVERY_GATE_OUT';
                                                $class              = 'active2';
                                                $disabled           = 'disabled';
                                                $ico                = 'w';
                                                $dlv_btn_en         = 1;
                                                $total_stops--;
                                            }

                                            $curr_id = $next_id;
                                            $next_id = random_string('alnum', 6);
                                            ?>
                                            <button type="button" <?= $disabled ?>
                                                onclick="setshipstopstatus('281', 'D', '<?= $k ?>', this)"
                                                data-status="DELIVERY_GATE_OUT"
                                                data-tail="<?= $k ?>"
                                                id="<?= $curr_id ?>"
                                                data-next-id="<?= $next_id ?>"
                                                data-order-id="d_<?= $tb_orders_id ?>"
                                                class="gateout_btn <?= $class ?> act_btn">
                                                <img src="<?= base_url('assets/driverappv3/img/gateout.svg') ?>" alt="gate_out" />
                                                <div class="gateIn-hideshow dl_action_lables<?= $k ?>">
                                                    <?php
                                                    if ($label_gt_out) { ?>
                                                        <div class="animated animatedFadeInUp fadeInUp activeCont">

                                                            <small><?= $lang_status[str_replace(' ', '_', $label_gt_out_stage)] ?></small>
                                                            <p>
                                                                <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_out)), DFLT_TZ)['datetime'])); ?>
                                                            </p>

                                                        </div>
                                                    <?php
                                                    } ?>
                                                </div>
                                                <div class="buttonTitle"> <?= lang('driverapp_gate_out'); ?></div>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="gateIn-hideshow dl_action_lables<?= $k ?>">
                                    <?php
                                    if ($label_gt_in) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <span><?= $lang_status[str_replace(' ', '_', $label_gt_in_stage)] ?></span>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_in)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                            </h3>
                                        </div>
                                    <?php
                                    }
                                    if ($label_dl) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <span><?= $lang_status[str_replace(' ', '_', $label_dl_stage)] ?></span>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_dl)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                                <?php
                                                pod_upload_info_icon($drop_point->pod_uploads_info); ?>
                                                <?= ($label_dl_stage == 'DELIVERY NOT DONE') ? '<span class="kn-info-text text-muted"> ' . lang('driverapp_pickup_not_done_KN_message') . ' </span>' : '' ?>
                                            </h3>
                                        </div>
                                    <?php
                                    }
                                    if ($label_gt_out) { ?>
                                        <div class="animated animatedFadeInUp fadeInUp">
                                            <h3>
                                                <span><?= $lang_status[str_replace(' ', '_', $label_gt_out_stage)] ?></span>
                                                <p>
                                                    <?= date('H:i d/m/y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d H:i', strtotime($label_gt_out)), DFLT_TZ)['datetime'])); ?>
                                                </p>
                                            </h3>
                                        </div>
                                    <?php
                                    } ?>
                                </div>
                            </div>
                        </div>
                        <!-- drop action buttons Status //-->
                    </div>
                </div>
                <div class="modal fade secureModal" id="deliveryok<?= $k ?>" tabindex="-1" aria-labelledby="" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                Delivery - Drop
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>

                            <div class="modal-body">
                                <div class="dropMain-hideshow animated fadeIn secRadioBts" id="delivery_act_ico<?= $k ?>">
                                    <p class="pull-right">
                                        <a class="closebtn" id="d_closebtn<?= $k ?>" href="javascript:void(0)">
                                            <img src="<?= base_url('assets/driverappv3/img/times.svg') ?>" alt="close_icon" />
                                        </a>
                                    </p>
                                    <ul>
                                        <li>

                                            <div class="delivery-status-option">
                                                <input class="form-check-input action_btn_dl" type="radio" name="delivery_status_<?= $k ?>" class="action_btn_dl" id="d_done<?= $k ?>">
                                                <label for="d_done<?= $k ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_done'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="delivery-status-option">
                                                <input class="form-check-input action_btn_dl" type="radio" name="delivery_status_<?= $k ?>" class="action_btn_dl" id="d_damage<?= $k ?>">
                                                <label for="d_damage<?= $k ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_damaged'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="delivery-status-option">
                                                <input class="form-check-input action_btn_dl" type="radio" name="delivery_status_<?= $k ?>" class="action_btn_dl" id="d_notdone<?= $k ?>">
                                                <label for="d_notdone<?= $k ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_not_done'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="delivery-status-option">
                                                <input class="form-check-input action_btn_dl" type="radio" name="delivery_status_<?= $k ?>" class="action_btn_dl" id="d_short<?= $k ?>">
                                                <label for="d_short<?= $k ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_short'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="delivery-status-option">
                                                <input class="form-check-input action_btn_dl" type="radio" name="delivery_status_<?= $k ?>" class="action_btn_dl" id="d_refused<?= $k ?>">
                                                <label for="d_refuse<?= $k ?>">
                                                    <div class="custom-radio-circle"></div>
                                                    <span><?= lang('driverapp_refused'); ?></span>
                                                </label>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="dropDone-hideshow animated bounceIn" id="d_btn_com_pic_sec<?= $k ?>" style="display: none; padding-bottom: 100px">
                                    <form id="d_pod_sign_uploads<?= $k ?>" enctype="multipart/form-data" method="POST" autocomplete="off">
                                        <h2 class="text-center delivered_heading mb-3 animated bounceIn" id="delivered_heading<?= $k ?>"><?= lang('driverapp_delivery_status') ?> <span></span></h2>

                                        <!--- Delivery action from -->
                                        <div class="position-relative form-group commentBlock d_missing_qty_blk<?= $k ?>">
                                            <span class="req-inp" id="d_m_asterisk<?= $k ?>">*</span>
                                            <input type="number" min="1" maxlength="4" max="9999" class="form-control onlyNumeric" form="d_pod_sign_uploads<?= $k ?>"
                                                placeholder="<?= lang('driverapp_missing_quantity') ?>" title="<?= lang('driverapp_missing_quantity') ?>"
                                                id="d_missing_qty<?= $k ?>"
                                                oninput="if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"
                                                pattern="\d*" />
                                            <span class="error"></span>
                                            <input type="hidden" id="d_missing_qty_max<?= $k ?>" value="<?= $quantity ?>">
                                        </div>
                                        <div class="position-relative form-group commentBlock">
                                            <span class="req-inp" id="d_c_asterisk<?= $k ?>">*</span>
                                            <input type="text" id="d_comment<?= $k ?>" maxlength="160" class="form-control" form="d_pod_sign_uploads<?= $k ?>" title="<?= lang('driverapp_comment') ?>" placeholder="<?= lang('driverapp_comment') ?>" required />
                                            <span class="error"></span>
                                        </div>
                                        <div class="position-relative form-group uploadBlock">
                                            <div class="cemara_icon_col">
                                                <span class="req-inp" id="d_p_asterisk<?= $k ?>">*</span>
                                                <label class="lable_col limitChar label_color_mute" id="d_fname<?= $k ?>"><?= lang('driverapp_attachment') ?></label>
                                                <input type="file" id="d_picture<?= $k ?>" name="file_name" class="form-control uploadFile" form="d_pod_sign_uploads<?= $k ?>" accept="image/*" />
                                                <input type="file" id="d_picture_cam<?= $k ?>" name="file_name" class="form-control uploadFile" form="d_pod_sign_uploads<?= $k ?>" accept="image/*" capture="environment" style="display:none;"/>
                                                <input type="hidden" name="status_id" id="d_status_id<?= $k ?>" form="d_pod_sign_uploads<?= $k ?>">
                                                <input type="hidden" id="d_picture_base64<?= $k ?>">
                                                <input type="hidden" id="d_picture_base64_cam<?= $k ?>">
                                                <input type="hidden" name="picture_file_name" id="d_picture_file_name<?= $k ?>">
                                                <input type="hidden" form="d_pod_sign_uploads<?= $k ?>" name="doc_type" value="2">

                                                <?php

                                                $proof_of_drop_details = $ship_stops_drop_status_arr;
                                                foreach ($proof_of_drop_details as $key => $value) { ?>
                                                    <input type="hidden" form="d_pod_sign_uploads<?= $k ?>" value="<?= $value ?>" name="<?= $key ?>">
                                                <?php
                                                } ?>
                                                <span id="d_button<?= $k ?>" class="mr-2"><img src="<?= base_url('assets/driverappv3/img/attachment-b.svg') ?>" alt="att_icon"></span>
                                            </div>
                                            <span class="error pod_error<?= $k ?>"></span>
                                        </div>
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="imgUp">
                                                    <div class="imagePreview" id="d_imagePreview<?= $k ?>" style="display: none">
                                                        <img src="" style="object-fit: contain" />
                                                    </div>
                                                    <label class="btn btn-primary imageAddCam" id="d_imgIco<?= $k ?>">
                                                        <img src="<?= base_url('assets/driverappv3/img/camera-b.svg') ?>" alt="camera_icon" onclick="$('#d_picture_cam<?= $k ?>').trigger('click'); ">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 confirmBt">
                                                <div class="position-relative form-group">
                                                    <button type="button" class="default-btn confirmsave_btn firstLetterUp" data-nxt-type="c" id="d_confirm_close<?= $k ?>" disabled><?= lang('driverapp_confirm_close') ?></button>
                                                </div>
                                            </div>
                                        </div>

                                    </form>
                                </div>
                                <div class="dropPOD-hideshow animated animatedFadeInUp fadeInUp" id="deliveryModal_pod<?= $k ?>" style="display: none; padding-bottom: 100px">
                                    <!--- POD Upload from -->
                                    <form id="d_pod_sign_uploads_pod<?= $k ?>" enctype="multipart/form-data" method="POST" autocomplete="off">
                                        <div class="back_icon my-2 d-flex" style="justify-content: space-between;">
                                            <a class="back_iconbtn<?= $k ?>" href="javascript:void(0)">
                                                <img class="back_icon_img" src="<?= base_url('assets/driverappv3/img/undo.svg') ?>" alt="back_icon" />
                                            </a>
                                            <div class="col mb-3">
                                                <?php
                                                $sess_lang   = $this->session->has_userdata('site_lang') && $this->session->userdata('site_lang') != 'english';
                                                $lang_str_h2 = $sess_lang ? '</h2><h2 class="dl_heading_pod text-center">(' . lang('driverapp_pod') . ')' : '(' . lang('driverapp_pod') . ')';
                                                ?>
                                                <h2 class="dl_heading_pod text-center"><?= lang('driverapp_proof_of_delivery') . ' ' . $lang_str_h2 ?> </h2>
                                            </div>
                                        </div>
                                        <div class="position-relative form-group commentBlock">
                                            <div class="imgUp d-flex" style="justify-content: space-around;">
                                                <div class="imagePreview" id="d_pod_imagePreview<?= $k ?>" style="display: none">
                                                    <img src="" style="object-fit: contain" />
                                                </div>
                                                <label class="btn imageAddCam" id="d_pod_imgIco<?= $k ?>">
                                                    <img src="<?= base_url('assets/driverappv3/img/camera-b.svg') ?>" alt="camera_icon" onclick="$('#d_picture_pod_cam<?= $k ?>').trigger('click'); ">
                                                </label>
                                            </div>
                                        </div>
                                        <div class="position-relative form-group uploadBlock">
                                            <div class="cemara_icon_col">
                                                <span class="req-inp" id="d_p_asterisk_pod<?= $k ?>">*</span>
                                                <label class="lable_col limitChar label_color_mute" id="d_fname_pod<?= $k ?>"><?= lang('driverapp_attachment') ?></label>
                                                <input type="file" placeholder="<?= lang('driverapp_attachment') ?>" id="d_picture_pod<?= $k ?>" name="file_name" form="d_pod_sign_uploads_pod<?= $k ?>" accept="image/*" class="form-control" required />
                                                
                                                <input type="file" placeholder="<?= lang('driverapp_attachment') ?>" id="d_picture_pod_cam<?= $k ?>" name="file_name" form="d_pod_sign_uploads_pod<?= $k ?>" accept="image/*" capture="environment" style="display:none;" class="form-control" required />
                                                
                                                <input type="hidden" name="status_id" id="d_status_id_pod<?= $k ?>" form="d_pod_sign_uploads_pod<?= $k ?>">
                                                <input type="hidden" id="d_picture_base64_pod<?= $k ?>">
                                                <input type="hidden" id="d_picture_base64_pod_cam<?= $k ?>">
                                                <input type="hidden" name="picture_file_name" id="d_picture_file_name_pod<?= $k ?>">
                                                <input type="hidden" form="d_pod_sign_uploads_pod<?= $k ?>" name="doc_type" value="3">
                                                <?php

                                                $proof_of_drop_details = $ship_stops_drop_status_arr;

                                                foreach ($proof_of_drop_details as $key => $value) { ?>
                                                    <input type="hidden" form="d_pod_sign_uploads_pod<?= $k ?>" value="<?= $value ?>" name="<?= $key ?>">
                                                <?php
                                                } ?>
                                                <span id="d_pod_button<?= $k ?>" class="mr-2"><img src="<?= base_url('assets/driverappv3/img/attachment-b.svg') ?>" alt="att_icon"></span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <span class="req-inp" id="d_c_asterisk_pod<?= $k ?>">*</span>
                                                <input type="text" class="form-control" autocomplete="off" title="<?= lang('driverapp_signees_name') ?>" placeholder="<?= lang('driverapp_signees_name') ?>" id="d_sign<?= $k ?>" required />
                                                <span class="error"></span>
                                                <span class="error pod_error<?= $k ?>"></span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12 confirmBt">
                                                <div class="form-group d-flex" style="justify-content: space-around;">
                                                    <button type="button" id="d_confirm_close_pod<?= $k ?>" class="default-btn confirmsave_btn firstLetterUp shortconfirmsave_btn" form="d_pod_sign_uploads_pod<?= $k ?>" disabled><?= lang('driverapp_confirm_close') ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    <!--- POD Upload from //-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- drop_box //-->
                <!-- Sidebar Modal -->
                <div class="sidebar-modal" id="delivery_info_slide<?= $k ?>">
                    <div class="sidebar-modal-inner">
                        <div class="sidebar-about-area">
                            <div class="titleColm">
                                <h1><?= lang('driverapp_delivery'); ?> </h1>
                            </div>
                            <div class="title">
                                <h2><?= lang('general_info'); ?></h2>
                            </div>
                            <ul class="sidebar_list stopinfo">
                                <?php
                                if ($tracking_ref) { ?>
                                    <li>
                                        <span> <img src="<?= base_url('assets/driverappv3/img/ref_ico-b.svg') ?>" alt="ref_ico" /></span>
                                        <span><?= $tracking_ref ?></span>
                                    </li>
                                <?php
                                } ?>
                                <?php
                                if ($DEPARTMENT_CODE) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/dep_code-b.svg') ?>" alt="dep_code" /></span>
                                        <span><?= $DEPARTMENT_CODE ?></span>
                                    </li>
                                <?php
                                } ?>
                                <li>
                                    <span><img src="<?= base_url('assets/driverappv3/img/pickup_address-b.svg') ?>" alt="pickup_address" /></span>
                                    <span class="address_col"><?= reduce_comma(trim($drop_point->delivery_company) . ', <br>' . trim($drop_point->delivery_address_f) . ', ' . trim($drop_location)) ?></span>
                                </li>
                                <?php
                                if ($customer_phone) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/call-contact.svg') ?>" width="19.716" height="21.274" alt="call-contact_icon" /></span>
                                        <span><?= $CONSIGNEE_NAME . '<br>' . $customer_phone ?></span>
                                    </li>
                                <?php
                                }

                                if ($abo_ref_c) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/abo_ref-b.svg') ?>" alt="abo_ref" /></span>
                                        <span><?= $abo_ref_c ?></span>
                                    </li>
                                <?php
                                }

                                if ($order_del_decs) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/pk_desc-b.svg') ?>" alt="pk_desc" /></span>
                                        <span><?= $order_del_decs ?></span>
                                    </li>
                                <?php
                                } ?>
                                <li>
                                    <span><img src="<?= base_url('assets/driverappv3/img/start_dt-b.svg') ?>" alt="start_dt" /></span>
                                    <span><?= $enddate; ?></span>
                                </li>
                            </ul>
                            <div class="title">
                                <h2><?= lang('driverapp_collection_list') ?></h2>
                            </div>
                            <ul class="sidebar_list stopinfo">
                                <?php
                                $i = 1;
                                foreach ($cargo_details as $cargo) {
                                    if ($cargo['order_id'] == $drop_point->tb_orders_id && ($i <= 4)) {
                                        $ldm = $cargo['ldm'] > 0 ? ', ' . $cargo['ldm'] : ''; ?>
                                        <li>
                                            <span><img src="<?= base_url('assets/driverappv3/img/cargo_info-b.svg') ?>" alt="cargo_ico" /></span>
                                            <span> <?= $cargo['weight'] . ' ' . $cargo['weight_unit'] . ', ' . $cargo['quantity'] . ' ' . $cargo['quantity_type'] . $ldm ?></span> <br>
                                        </li>
                                <?php
                                        $i++;
                                    }
                                } ?>
                                <?php
                                if (trim($cargo_content)) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/cargo_content-b.svg') ?>" alt="cargo_content_ico" /></span>
                                        <span><?= (trim($cargo_content) != '') ? $cargo_content : '--'; ?></span>
                                    </li>
                                <?php
                                }

                                if ($EFP) { ?>
                                    <li>
                                        <span><img src="<?= base_url('assets/driverappv3/img/eur-b.svg') ?>" alt="efp_ico" /> </span>
                                        <span><?= $EFP ?></span>
                                    </li>
                                    <?php
                                }

                                if ($danger_goods_order_id && $is_danger_goods == 1) {
                                    $danger_goods_data = (array)$danger_goods_data;

                                    foreach ($danger_goods_data['response'] as $danger_goods_datum) { ?>
                                        <li>
                                            <span><img src="<?= base_url('assets/driverappv3/img/adr-ico.svg') ?>" alt="danger-ico" /> </span>
                                            <span style="display: inline-block; vertical-align: middle;"><?= get_dg_goods_str((object) $danger_goods_datum); ?></span>
                                        </li>
                                <?php
                                    }
                                } ?>
                            </ul>
                            <?php
                            if ($trans_con_trip_note || $trans_veh_trip_note || $trans_stop_order_trip_note) { ?>
                                <div class="title">
                                    <h2>Trip Notes</h2>
                                </div>
                                <ul class="sidebar_list stopinfo">
                                    <li>
                                        <?= $trans_con_trip_note ?> <br />
                                        <?= $trans_veh_trip_note ?> <br />
                                        <?= $trans_stop_order_trip_note ?>
                                    </li>
                                </ul>
                            <?php
                            } ?>
                            </ul>
                            <span class="close-btn sidebar-modal-close-btn"> <i class="flaticon-cancel"></i></span>
                        </div>
                    </div>
                    <!-- End Sidebar Modal -->
                </div>
            <?php
            } ?>
            <!----------- Danger Symbol Description -------------------->
            <div id="dg">
                <div class="modal fade" id="dg_model" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document" style="top: 10%;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><?= lang('driverapp_dg_info') . '&nbsp;:' ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="">
                                    <div class="row">
                                        <div class="col-12">
                                            <div id="dg_content"></div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-sm custom_btn" data-dismiss="modal" aria-label="Close"><?= lang('driverapp_close'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- -----------------Danger Symbol desc //---------------- -->
        </div>
    </div>
</section>
<!-- Choose Area //-->
<div class="trip-completed main-banner-area-four1" style="display:none">
    <div class="d-table">
        <div class="d-table-cell">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <div class="banner-image text-center">
                            <div class="row justify-content-center align-items-center job_icon animated animatedFadeInUp fadeInUp">
                                <img src="<?= base_url('/assets/driverappv3/img/coffee-cup-w.svg') ?>" alt="coffee-cup">
                            </div>
                            <h2 class="animated animatedFadeInUp fadeInUp"><?= lang('driver_good_job'); ?></h2>
                            <p class="animated animatedFadeInUp fadeInUp"><?= lang('driver_success_completed'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" value="<?= htmlentities(json_encode(is_array($tb_orders_id_list) ? array_unique($tb_orders_id_list) : null)) ?>" name="order_id" id="order_id">
<input type="hidden" id="stops_left" value="<?= $total_stops ?>">
<input type="hidden" id="share_location_count" value="<?= $share_location_count ?>">
<input type="hidden" id="company_code" value="<?= $company_code ?>">
<input type="hidden" id="lang_status" value="<?= htmlentities(json_encode($lang_status, JSON_UNESCAPED_SLASHES)) ?>">
<input type="hidden" id="lang_status_h3" value="<?= htmlentities(json_encode($lang_status_h3, JSON_UNESCAPED_SLASHES)) ?>">



<!-- delivery modal close-->