<div class="panel panel-default">
    <div class="panel-heading" role="tab" id="heading-involved-parties">
        <h4 class="panel-title">
            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#involved-parties-panel" aria-expanded="false" aria-controls="collapseThree">
                <i class="more-less fa fa-angle-right"></i>
                <?= $this->lang->line('involved_parties'); ?>
            </a>
        </h4>
    </div>
    <div id="involved-parties-panel" class="panel-collapse  collapse" role="tabpanel" aria-labelledby="heading-involved-parties">
        <div class="panel-body">
            <div class="row">
                <div class="main-datatable">
                    <div class="table-responsive">
                        <div id="involved-parties-details" class="dataTables_wrapper dt-bootstrap no-footer">
                            <div class="dataTables_length" id="involved-parties-length">
                                <label>
                                    <select class="form-control">
                                        <option value="10">10</option>
                                        <option value="20">20</option>
                                        <option value="30">30</option>
                                        <option value="40">40</option>
                                        <option value="50">50</option>
                                        <option value="-1">All</option>
                                    </select>
                                </label>
                            </div>
                            <table id="involved-parties-table" class="table table-striped add-edit-table table-bordered table_bg applyActionFilters dataTable no-footer" style="width:100%" role="grid">
                                <thead>
                                    <tr role="row">
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('party_type'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('party_identifier'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('customer_identifier'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('general_name'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('general_street'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('general_city'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('general_state'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('general_country_code'); ?>
                                        </th>
                                        <th class="sorting_asc" tabindex="0" aria-controls="involvedParties_details" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Party ID: activate to sort column descending" style="width: 0px;">
                                            <?= $this->lang->line('zipcode'); ?>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody id="dynamicPartiesData">
                                    <?php $parties = getPartiesbyOrder($order->id); ?>
                                    <?php if ( count( $parties ) > 0 ): ?>
                                        <?php foreach ( $parties as $party ): ?>
                                            <tr role="row" class="odd">
                                                <td><?= $party['partytype'];?></td>
                                                <td><?= $party['partyindetifier'];?></td>
                                                <td><?= $party['customeridentifier'];?></td>
                                                <td><?= $party['name'];?></td>
                                                <td><?= $party['street'];?></td>
                                                <td><?= $party['location_id'];?></td>
                                                <td><?= $party['state'];?></td>
                                                <td><?= $party['country'];?></td>
                                                <td><?= $party['pincode'];?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <?php if ( $show_new_form ): ?>
                                        <?= $this->load->view('elements/orders/involved_party_form', [
                                            'order' => $order
                                        ], true); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="dataTables_paginate paging_simple_numbers" id="involved-parties-paginate">
                                <ul class="pagination">
                                    <li class="paginate_button previous disabled" aria-controls="involved-parties-table" tabindex="0" id="involved-parties-previous">
                                        <a href="#">Previous</a>
                                    </li>
                                    <li class="paginate_button active" aria-controls="involved-parties-table" tabindex="0">
                                        <a href="#">1</a>
                                    </li>
                                    <li class="paginate_button next disabled" aria-controls="involved-parties-table" tabindex="0" id="involved-parties-next">
                                        <a href="#">Next</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
