<section class="content-header">
	<h1>
		Spread Sheets
		<small>Google Drive</small>
	</h1>
	<ol class="breadcrumb">
		<li><a href="<?php echo base_url(); ?>"><i class="fa fa-home"></i> Home</a></li>
		<li class="active">Spread Sheets</li>
	</ol>
</section>

<section class="content">
	<div class="container top-padding-10">
		<div class="row">
			<div class="col-xs-12">
				<div class="box" style="display: none;">
					<div class="box-header">
						<h3 class="box-title">Google Drive - Spread Sheets</h3>
					</div>
					<div class="box-body">
						<div class="row">
							<div class="col-md-3">
								<div class="form-group">
									<label for="custmer_id"><?php echo $this->lang->line('customer_id'); ?></label>
									<div class="input-group">
										<input form="order_form" type="text" class="form-control ui-autocomplete-input" id="customer_id" name="customer_id" readonly="" autocomplete="off">
										<div class="input-group-btn">
											<button class="btn btn-outline-secondary" type="button" data-toggle="modal" onclick="searchcustomerlist(event)" data-placement="top" title="Search">
												<i class="icon tru-icon-search"></i>
											</button>
											<button class="btn btn-outline-secondary" type="button" data-placement="top" title="List" data-toggle="modal" onclick="viewcustomerlist(event)">
												<i class="icon tru-icon-tender-list"></i>
											</button>
										</div>
									</div>
								</div>
							</div>
							<div class="col-md-3">
								<div class="form-group">
									<label for="sheet_type">Sheet type</label>
									<select name="sheet_type" id="sheet_type" class="form-control">
										<option value="">Select</option>
										<option value="sheet_type_1">Sheet type 1</option>
										<option value="sheet_type_2">Sheet type 2</option>
									</select>
								</div>
							</div>
							<div class="col-md-6">
								<button type="submit" name="submit" class="btn btn-default btn_color pull-right" onclick="submitDocument()" style="margin: 16px;">Import Document</button>
							</div>
						</div>
						<div class="row">
							<div class="col-md-3">
								<div id="ordercustomer_details"></div>
							</div>
						</div>
					</div>
					<div class="overlay">
						<i class="fa fa-refresh fa-spin"></i>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- company Code Find modal content -->
	<div class="modal fade" id="view_customer">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title" id="view_customer_title">Party details</h4>
				</div>
				<div class="modal-body ">
					<div class="custom-box">
						<!--  <div id="search">  -->
						<table class="table table-striped table-bordered" width="100%" id="list_party">
							<thead>
								<tr>
									<th scope="col">#</th>
									<th scope="col"><?php echo $this->lang->line('id'); ?></th>
									<th scope="col"><?php echo $this->lang->line('bpartner_pname'); ?><?php echo $this->lang->line('bpartner_pname'); ?></th>
									<th scope="col"><?php echo $this->lang->line('general_email'); ?></th>
									<th scope="col"><?php echo $this->lang->line('general_company_code'); ?></th>
									<th scope="col"><?php echo $this->lang->line('general_branch_code'); ?></th>
								</tr>
							</thead>
							<tbody></tbody>
							<!--  <tbody id="customer-show_data">
                           </tbody> -->
						</table>
						<!-- </div> -->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
					<button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light" onclick="selectshipperinlist()"><?php echo $this->lang->line('general_select'); ?></button>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- <link href="<?php echo base_url(); ?>/assets/newtheme/css/app-style.css" rel="stylesheet" type="text/css">
<link href="<?php echo base_url(); ?>/assets/newtheme/css/bootstrap.min.css" rel="stylesheet" type="text/css"> -->
<link href="<?php echo base_url();?>assets/newtheme/css/mj-box.css" rel="stylesheet" type="text/css" />
<script src="<?php echo base_url(); ?>assets/newtheme/js/bootstable.js"></script>
<script src="<?php echo base_url(); ?>assets/js/order_script.js"></script>
<script type="text/javascript">
	var baseurl = "<?php echo base_url(); ?>";
	$(document).ready(function(){
		$(".box").show();
	});
	function submitDocument() {
		var cid = $("#customer_id").val();
		var sheet_type = $("#sheet_type").val();
		if(cid.trim().length > 0 && sheet_type.length > 0) {
			$.ajax({
				url:"<?php echo base_url('gdocs/submitDocument'); ?>",
				data:{
					customer_id:cid,
					sheet_type:sheet_type
				},
				type:"POST",
				dataType:"JSON",
				beforeSend:function(){
					$(".overlay").show();
				},
				success:function(data){
					$(".overlay").hide();
					if(data.status=="1"){
						alert("Order created successfully!");
						window.location = "/orders";
					}else{
						alert(data.message);
					}
				}
			});
		}else{
			if(cid.trim().length == 0){
				groupAlert($("#customer_id"),"Please choose custmer","error");
			}
			if(sheet_type.trim().length == 0){
				groupAlert($("#sheet_type"),"Please choose sheet type","error");
			}
		}
	}
	function groupAlert(ele,message,type){
		var group = ele.closest(".form-group");
		group.removeClass("has-error");
		group.remove(".haserror-text");
		group.removeClass("has-success");
		group.remove(".hassuccess-text");
		if(type=="error"){
			group.addClass("has-error");
			group.append("<span class=\"haserror-text\">"+message+"</span>")
		}else{
			group.addClass("has-success");
			group.append("<span class=\"hassuccess-text\">"+message+"</span>")
		}
	}
</script>
<style type="text/css">
.box .overlay, .overlay-wrapper .overlay {
    z-index: 50;
    background: rgba(255,255,255,0.7);
    border-radius: 3px;
    display: none;
}
.box .overlay, .overlay-wrapper>.overlay, .box>.loading-img, .overlay-wrapper>.loading-img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}
.overlay>.fa, .overlay-wrapper .overlay>.fa {
    position: absolute;
    top: 50%;
    left: 50%;
    margin-left: -15px;
    margin-top: -15px;
    color: #000;
    font-size: 30px;
}
.top-padding-10{
	padding-top: 10px;
}
span.haserror-text {
    font-size: 11px;
    position: absolute;
    bottom: -14px;
    color: #d96464;
}
.input-group .input-group-btn:last-child>.btn {
    margin-top: 0px;
    position: relative;
    padding: 6px 8px 5px 8px;
}
</style>