<!-- <?php
    $this->load->view( 'loader' );
    $XL_MAX_ROWS = $this->session->userdata( 'XL_MAX_ROWS' );
    $XL_MAX_COLS = $this->session->userdata( 'XL_MAX_COLS' );
    ?> -->

    <div class="content-page overflowVisible">
        <!-- Start content -->
        <div class="content">
            <div class="container">
                <?php $this->load->helper( 'drop_down' ); ?>
                 <div class="overlapHeading">
                            <div class="">
                                <h2 class="moadleHeading"><?= $this->lang->line('general_edit') . ' ' . $this->lang->line('geo_tier'); ?></h2>
                            </div>
                        </div>
                <div class="card-box_lis row">
                    <form method="POST" id="tier" onsubmit="return savecheckrs(this);">
                        <div class="col-md-12">
                            <div class="tab_list_col">
                                <!-- Nav tabs -->
                                <div class="col-sm-6 pd-left-0">
                                    <ul id="tabs" class="nav nav-tabs" role="tablist">
                                        <li role="presentation" class="active"><a href="#all" role="tab" data-toggle="tab"> <i class="icon tru-icon-info"></i> <?php echo $this->lang->line( 'general_info' ); ?>                                        </a></li>
                                    </ul>
                                </div>
                                <div class="col-sm-6">
                                    <div class="view_moretab text-right">
                                        <button type="submit" name="submit" class="btn btn-default btn_color ">
                                            <a style="color: white;" href="<?php echo base_url( 'Geotier/edit/' . $edit_data['id'] ); ?>"><?= $this->lang->line( 'general_reset' ); ?></a>
                                        </button>
                                        <button type="reset" name="reset" class="btn btn-default btn_color ">
                                            <a style="color: white;" href="<?php echo site_url( 'Geotier' ); ?>"><?php echo $this->lang->line( 'general_cancel' ); ?></a>
                                        </button>
                                        <button type="submit" name="savetier" class="btn btn-default btn_color resetbtn" value="1">
                                            <?php echo $this->lang->line( 'general_update' ); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade in active" id="all">
                                    <div class="">
                                        <!-- accordion start -->
                                        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                                            <div class="generalInfo panel panel-default">
                                                <div class="panel-heading active" role="tab" id="headingGeneralInfo">
                                                    <h4 class="panel-title">
                                                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#generalInfo" aria-expanded="true" aria-controls="collapseOne">
                                                            <i class="more-less fa fa-angle-right"></i>
                                                            <?php echo $this->lang->line( 'general_info' ); ?>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="generalInfo" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingGeneralInfo">
                                                    <div class="panel-body">
                                                        <div class="general_input_fields">
                                                            <!------------------------------ Tier form code------------ form="tier"--------------------------------------------------------------------->
                                                            <div class="row">
                                                                <div class="col-sm-3">
                                                                    <div class="cardCol">
                                                                    <div class="form-group">
                                                                        <label for="tier_id"><?php echo $this->lang->line( 'geo_tier_id' ); ?> *</label>
                                                                        <input type="text" name="tier_id" parsley-trigger="change" id="tier_id" placeholder="" class="form-control" value="<?= $edit_data['geo_tier_id']; ?>" readonly>
                                                                        <input type="hidden" name="g_id" parsley-trigger="change" id="g_id" placeholder="" class="form-control" value="<?= $edit_data['id']; ?>">
                                                                    </div>
                                                                    <div class="row input-group">
                                                                        <div class="col-sm-6">
                                                                            <label for="uom1"><?php echo $this->lang->line( 'uom' ); ?> *</label>
                                                                            <select name="uom1" id="uom1" class="form-control">
                                                                                <?= unit_of_measure_list( $edit_data['uom1'] ); ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <label for="uom1_m"><?php echo $this->lang->line( 'general_units' ); ?> *</label>
                                                                            <select name="uom1_m" id="uom1_m" class="form-control">
                                                                                <?= get_measurement_units( $edit_data['uom1'], $edit_data['unit_measure1'] ); ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                     <div class="form-group">
                                                                        <label for="mr_cost"><?php echo $this->lang->line( 'marginal_cost' ); ?></label><br/>&nbsp
                                                                        <input type="checkbox" name="mr_cost" id="mr_cost" <?= $edit_data['marginal_cost'] == 1 ? "Checked" : "" ?> >
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-3">
                                                                    <div class="cardCol">
                                                                    <div class="form-group ">
                                                                        <label for="tier_name" style="margin-top: 3px; margin-left: 3px;"><?php echo $this->lang->line( 'geo_tier_name' ); ?> *</label>
                                                                        <input type="text" onkeyup="this.value = this.value.toUpperCase();" class="form-control Txtfld mandatoryflds" name="tier_name" id="tier_name" tabindex="2" value=" <?= $edit_data['geo_tier_name']; ?>">
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label for="curr"><?php echo $this->lang->line( 'general_currency' ); ?> *</label>
                                                                        <select name="curr" id="curr" class="form-control">
                                                                            <option value="">SELECT</option>
                                                                            <?php if ( ! empty( $currencies ) ) {
                                                                                foreach ( $currencies as $currency ) { ?>
                                                                                    <option value="<?php echo $currency; ?>" <?= ( $edit_data['currency'] == $currency ) ? "selected" : "" ?> > <?php echo $currency; ?> </option>
                                                                                <?php }
                                                                            } ?>
                                                                        </select>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label for="flat"> <?php echo $this->lang->line( 'flat' ); ?></label><br/>
                                                                        &nbsp <input type="checkbox" name="flat" id="flat" <?= ( $edit_data['flat'] == 1 ) ? "Checked" : "" ?> >
                                                                    </div>
                                                                </div>    
                                                                </div>
                                                                <div class="col-sm-3">
                                                                    <div class="cardCol">
                                                                    <div class="form-group">
                                                                        <label for="geo_hierarchy"><?php echo $this->lang->line( 'geo_hierarchy' ); ?> *</label>
                                                                        <select name="geo_hierarchy" id="geo_hierarchy" class="form-control">
                                                                            <option value="">Select</option>
                                                                            <?php if ( ! empty( $geo_master ) ) {
                                                                                foreach ( $geo_master as $geo_data ) { ?>
                                                                                    <option value="<?= $geo_data['name']; ?>" geo="<?= $geo_data['name']; ?>" <?= $edit_data['geo_hierarchy'] == strtoupper( $geo_data['name'] ) ? "selected" : "" ?> > <?= $geo_data['name']; ?> </option>
                                                                                <?php }
                                                                            } ?>
                                                                        </select>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label for="vehicle_type"><?php echo $this->lang->line( 'vehicle_type' ); ?> </label>
                                                                        <select name="vehicle_type" id="vehicle_type" class="form-control">
                                                                            <option value="">SELECT</option>
                                                                            <?php if ( ! empty( $veh_type ) ) {
                                                                                foreach ( $veh_type as $veh_type_data ) { ?>
                                                                                    <option value="<?php echo $veh_type_data['id']; ?>" <?= ( $edit_data['vehicle_type'] == $veh_type_data['id'] ) ? "selected" : "" ?> > <?php echo $veh_type_data['trucktype']; ?></option>
                                                                                <?php }
                                                                            } ?>
                                                                        </select>
                                                                    </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-3">
                                                                    <div class="cardCol">
                                                                    <div class="input-group">
                                                                        <label for="company_code"><?php echo $this->lang->line( 'general_company_code' ); ?> *</label>
                                                                        <input name="company_code" id="company_code" type="text" class="form-control" aria-label="..." value="<?= $edit_data['company_code'] ?? ""; ?>" readonly>
                                                                        <div class="input-group-btn">
                                                                            <button class="btn " type="button" data-toggle="modal">
                                                                                <a href="#" title="Find" id="findcompanylist" onclick="findcompanylist(event)"> <i class="icon tru-icon-find-new"></i></a>
                                                                            </button>
                                                                            <button class="btn " type="button" data-placement="top" title="Find" data-toggle="modal">
                                                                                <a href="#" title="List" id="viewcompanylist" onclick="viewcompanylist(event)"> <i class="icon tru-icon-tender-list"></i></a>
                                                                            </button>
                                                                            <button class="btn " type="button" data-placement="top" title="Add" data-toggle="modal">
                                                                                <a title="Search" href="#" id="searchviewcompany" onclick="searchviewcompany(event)"><i class="icon tru-icon-search"></i></a>
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="input-group">
                                                                        <label for="branch_code"> <?php echo $this->lang->line( 'general_branch_code' ); ?></label>
                                                                        <input name="branch_code" id="branch_code" type="text" class="form-control" aria-label="..." value="<?= $edit_data['branch_code'] ?? ""; ?>" readonly>
                                                                        <div class="input-group-btn">
                                                                            <button class="btn " type="button" data-toggle="modal">
                                                                                <a href="#" title="Find" id="findbranchlist" onclick="findbranchlist(event)"> <i class="icon tru-icon-find-new"></i></a>
                                                                            </button>
                                                                            <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                                                <a href="#" title="List" id="viewbranchlist" onclick="viewbranchlist(event)"> <i class="icon tru-icon-tender-list"></i></a>
                                                                            </button>
                                                                            <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                                                <a title="Search" href="#" id="searchviewbranch" onclick="searchviewbranch(event)"> <i class="icon tru-icon-search"></i></a>
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            </div>
                                                            <!-------------------------------------------------------------- Tier form code------------------------------------------------------>
                                                            <br/>
                                                            <!-- table-->
                                                            <div class="row">
                                                                <div class="col-sm-12 panel-body-table">
                                                                    <div class="main-datatable">
                                                                        <div class="table-responsive minheight">
                                                                            <button type="button" class="btn btn-default btn_color pull-right" style="margin-bottom:5px" id="add_col_table" data-no-rows="<?= $XL_MAX_ROWS ?>" data-no-cols="<?= $XL_MAX_COLS ?>" data-current-col-id="<?= $XL_MAX_COLS - 1 ?>"><?= $this->lang->line('add_column'); ?></button>
                                                                            <input type="hidden" name="ext_cols" value="0" id="ext_cols">
                                                                            <input type="hidden" name="ext_rows" value="0" id="ext_rows">
                                                                            <table id="tier_mtab" class="table table-striped table-bordered " style="width: 100%">
                                                                                <thead>
                                                                                <tr style="background-color: #a5b6cb;; color: #152C55; height: 40px; text-align: center; text-transform: uppercase">
                                                                                    <th style="background-color: #fff; border: 1px solid white;" colspan="2"><b> </b></th>
                                                                                    <th class="cen1" colspan="<?= ( $XL_MAX_COLS / 2 ) + 1 ?>" id="tab_hed1" style="text-transform:uppercase;height:40px">
                                                                                        <b><?= $edit_data['uom1'] . '[' . $edit_data['unit_measure1'] . ']'; ?></b>
                                                                                    </th>
                                                                                    <th class="cen1" colspan="<?= ( $XL_MAX_COLS / 2 ) * 3 ?>" id="tab_hed2" style="text-transform:uppercase;height:40px"><b></b></th>
                                                                                </tr>
                                                                                <tr style="color: #152C55">
                                                                                    <th class="cen" colspan="2" style="background-color: #a5b6cb;; color: #152C55; height: 40px; text-align: center; text-transform: uppercase" id="tab_hed"><b> <?= $edit_data['geo_hierarchy']; ?></b></th>
                                                                                    <th class="wid_td2"><b><?= $this->lang->line( 'minimum' ); ?></b></th>
                                                                                    <?php for ( $x = 1; $x <= $XL_MAX_COLS - 2; $x ++ ) { ?>
                                                                                        <th class="wid_td"><b><?= $this->lang->line( 'min' ); ?></b></th>
                                                                                        <th class="wid_td"><b><?= $this->lang->line( 'max' ); ?></b></th>
                                                                                    <?php } ?>
                                                                                <tr>
                                                                                </thead>
                                                                                <tbody id="tb_sheet">
                                                                                <?php
                                                                                $min_max_array         = array();
                                                                                $uom1_min_max_row_gen  = array();
                                                                                $temp_list             = $knratetier_sheet;
                                                                                $existing_col_val_sets = count( $temp_list );
                                                                                $row_seq               = 0;
                                                                                $j                     = 0;

                                                                                /* main loop */
                                                                                for ( $i = 0; $i < sizeof( $knratetier_sheet ); $i ++ ) {
                                                                                    /* main loop condition 0 */
                                                                                    if ( $i == 0 ) { ?>
                                                                                        <tr>
                                                                                            <th class="wid_td2 "><b><?= $this->lang->line( 'from' ); ?></b></th>
                                                                                            <th class="wid_td2"><b><?= $this->lang->line( 'to' ); ?></b></th>
                                                                                            <?php
                                                                                            $uom2_header_index = 1;
                                                                                            /* Scoend loop */
                                                                                            $col_c = 0;
                                                                                            for ( $k = 0; $k < sizeof( $temp_list ); $k ++ ) {
                                                                                                $col_sz       = count( $temp_list[ $k ] );
                                                                                                $uom2_min     = $temp_list[ $k ]['uom1_min'];
                                                                                                $uom2_max     = $temp_list[ $k ]['uom1_max'];
                                                                                                $uom1_minimum = $temp_list[ $k ]['uom1_minimum'];
                                                                                                $sep_point    = $uom2_min . '_' . $uom2_max;
                                                                                                if ( ! in_array( $sep_point, $min_max_array ) ) {
                                                                                                    array_push( $min_max_array, $sep_point ); ?>
                                                                                                    <?php
                                                                                                    /* main loop condition 0 */
                                                                                                    if ( $k == 0 ) {
                                                                                                        if ( $uom1_minimum > 0 ) {
                                                                                                            $j ++; ?>
                                                                                                            <td class="wid_td1">
                                                                                                                <input type="text" name="minimum_1" onkeypress="return isNumberKey(event)" value="<?= $uom1_minimum ?>" placeholder="<?= $this->lang->line( 'minimum' ); ?>" class="form-control"></td>
                                                                                                        <?php } else { ?>
                                                                                                            <td class="wid_td1">
                                                                                                                <input type="text" name="minimum_1" onkeypress="return isNumberKey(event)" value="" placeholder="<?= $this->lang->line( 'minimum' ); ?>" class="form-control">
                                                                                                            </td>
                                                                                                            <td class="wid_td2"><input type="text" value="<?= $uom2_min ?>" name="uom2_min_c<?= $uom2_header_index ?>" class="form-control"></td>
                                                                                                            <td class="wid_td2"><input type="text" value="<?= $uom2_max ?>" name="uom2_max_c<?= $uom2_header_index ?>" class="form-control"></td>
                                                                                                        <?php }
                                                                                                    } else {
                                                                                                        log_message( 'error', 'Error Message uom2_header_index -> 353' . $uom2_header_index );
                                                                                                        ?>
                                                                                                        <td class="wid_td2"><input type="text" value="<?= $uom2_min ?>" name="uom2_min_c<?= $uom2_header_index ?>" class="form-control"></td>
                                                                                                        <td class="wid_td2"><input type="text" value="<?= $uom2_max ?>" name="uom2_max_c<?= $uom2_header_index ?>" class="form-control"></td>
                                                                                                        <?php
                                                                                                    }
                                                                                                    $uom2_header_index = $uom2_header_index + 1;
                                                                                                }
                                                                                            }
                                                                                            $size_of_min_max_array = sizeof( $min_max_array );
                                                                                            if ( $j == 1 ) {
                                                                                                $size_of_min_max_array = $size_of_min_max_array - 1;
                                                                                            } ?>
                                                                                        </tr>
                                                                                        <?php
                                                                                    }
                                                                                    /* main loop condition 0 end */

                                                                                    $uom1_min            = $knratetier_sheet[ $i ]['geo_from'];
                                                                                    $uom1_max            = $knratetier_sheet[ $i ]['geo_to'];
                                                                                    $sep_of_uom1_min_max = $uom1_min . '__' . $uom1_max;
                                                                                    if ( ! in_array( $sep_of_uom1_min_max, $uom1_min_max_row_gen ) ) {
                                                                                        array_push( $uom1_min_max_row_gen, $sep_of_uom1_min_max );
                                                                                        $row_seq = $row_seq + 1; ?>
                                                                                        <tr data-row_id="<?= $row_seq ?>">
                                                                                            <td class="wid_td"><input type="text" name="uom1_<?= $row_seq ?>_min" value="<?= $uom1_min ?>" class="form-control"></td>
                                                                                            <td class="wid_td"><input type="text" name="uom1_<?= $row_seq ?>_max" value="<?= $uom1_max ?>" class="form-control"></td>
                                                                                            <?php
                                                                                            // loop column values....
                                                                                            $column_count = 1;
                                                                                            $rc           = 0;
                                                                                            for ( $column_loop = 0; $column_loop < sizeof( $knratetier_sheet ); $column_loop ++ ) {
                                                                                                $uom1_minimum_col = $knratetier_sheet[ $column_loop ]['uom1_minimum'];
                                                                                                $id               = $knratetier_sheet[ $column_loop ]['id'];
                                                                                                if ( $column_loop == 0 ) {
                                                                                                    if ( $uom1_minimum_col > 0 && $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                        $cost1 = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                        if ( $cost1 == 0.00 ) {
                                                                                                            $cost1 = "";
                                                                                                        } ?>
                                                                                                        <td class="wid_td1"><input type="text" value="<?= $cost1 ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                            <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                        </td>
                                                                                                        <?php
                                                                                                        $rc ++;
                                                                                                        $column_count ++;
                                                                                                    } else {
                                                                                                        if ( $uom1_minimum_col > 0 && $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                            $cost1 = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                            if ( $cost1 == 0.00 ) {
                                                                                                                $cost1 = "";
                                                                                                            } ?>
                                                                                                            <td class="wid_td1">
                                                                                                                <input type="text" value="<?= $cost1 ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control"></td>
                                                                                                            <?php
                                                                                                            $column_count ++;
                                                                                                        } else {
                                                                                                            if ( $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                                $cost = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                                if ( $cost == 0.00 ) {
                                                                                                                    $cost = "";
                                                                                                                } ?>
                                                                                                                <td class="wid_td1">
                                                                                                                    <input type="text" value="" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                    <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                                </td>
                                                                                                                <?php $column_count ++; ?>
                                                                                                                <td colspan='2' class="wid_td">
                                                                                                                    <input type="text" value="<?= $cost ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                    <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control"></td>
                                                                                                                <?php
                                                                                                                $column_count ++;
                                                                                                                $rc ++;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                } else {
                                                                                                    if ( $rc == 0 ) {
                                                                                                        if ( $uom1_minimum_col > 0 && $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                            $cost1 = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                            if ( $cost1 == 0.00 ) {
                                                                                                                $cost1 = "";
                                                                                                            } ?>
                                                                                                            <td class="wid_td1">
                                                                                                                <input type="text" value="<?= $cost1 ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                            </td>
                                                                                                            <?php
                                                                                                            $rc ++;
                                                                                                            $column_count ++;
                                                                                                        } else {
                                                                                                            if ( $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                                $cost = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                                if ( $cost == 0.00 ) {
                                                                                                                    $cost = "";
                                                                                                                }
                                                                                                                $id = $knratetier_sheet[ $column_loop ]['id'];
                                                                                                                ?>
                                                                                                                <td class="wid_td1">
                                                                                                                    <input type="text" value="" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                    <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                                </td>
                                                                                                                <?php $column_count ++; ?>
                                                                                                                <td colspan='2' class="wid_td">
                                                                                                                    <input type="text" value="<?= $cost ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                    <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                                </td>
                                                                                                                <?php
                                                                                                                $rc ++;
                                                                                                                $column_count ++;
                                                                                                            }
                                                                                                        }
                                                                                                    } else {
                                                                                                        if ( $knratetier_sheet[ $column_loop ]['geo_from'] == $uom1_min && $knratetier_sheet[ $column_loop ]['geo_to'] == $uom1_max ) {
                                                                                                            $cost = $knratetier_sheet[ $column_loop ]['cost'];
                                                                                                            if ( $cost == 0.00 ) {
                                                                                                                $cost = "";
                                                                                                            }
                                                                                                            $id = $knratetier_sheet[ $column_loop ]['id'];
                                                                                                            if ( $column_count <= $XL_MAX_COLS + 1 ) { ?>
                                                                                                                <td colspan='2' class='wid_td'>
                                                                                                                    <input type="text" value="<?= $cost ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>" class="form-control">
                                                                                                                    <input type="hidden" value="<?= $id ?>" name="result_r<?= $row_seq ?>_c<?= $column_count ?>_hidden_id" class="form-control">
                                                                                                                </td>
                                                                                                                <?php
                                                                                                            }
                                                                                                            $column_count ++;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            } ?>
                                                                                        </tr>
                                                                                        <?php
                                                                                    }
                                                                                }
                                                                                $gen_rows = sizeof( $uom1_min_max_row_gen );
                                                                                // Auto genrate rows in the size of colums // MAX_colums // max_rows
                                                                                for ( $i = $gen_rows + 1; $i <= $XL_MAX_ROWS; $i ++ ) { ?>
                                                                                    <tr>
                                                                                        <td class="wid_td1"><input type="text" onkeyup="upper(this);" name="uom1_<?= $i ?>_min" placeholder="" class="form-control"></td>
                                                                                        <td class="wid_td1"><input type="text" onkeyup="upper(this);" name="uom1_<?= $i ?>_max" placeholder="" class="form-control"></td>

                                                                                        <td class="wid_td1"><input type="text" onkeypress="return isNumberKey(event)" name="result_r<?= $i ?>_c1" class="form-control"></td>
                                                                                        <?php for ( $x = 1; $x <= $XL_MAX_COLS; $x ++ ) {
                                                                                            $xxi = $x + 1;
                                                                                            echo '<td colspan="2" class="wid_td"><input type="text" onkeypress="return isNumberKey(event)" name="result_r' . $i . '_c' . $xxi . '" class="form-control"></td>';
                                                                                        } ?>
                                                                                    </tr>
                                                                                <?php } ?>
                                                                                <tbody>
                                                                            </table>
                                                                            <button type="button" class="btn btn-default btn_color" id="add_row_table" data-current-row-id="<?= $XL_MAX_ROWS ?>" data-no-cols="<?= $XL_MAX_COLS ?>"><?= $this->lang->line('add_row'); ?></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- table-->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                    </form>
                </div>
            </div>
            <!-- End fillter section -->
        </div>
    </div>
    <!-- end col -->
    </div>
    <!-- end row -->
    <!-- Branch Code add -->
    <div id="create_view_branch" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="create_view_branch" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title" id="companyCodeAddmodalLabel">
                        <?php echo $this->lang->line( 'general_addbranch' ); ?>
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="CompanyName"><?php echo $this->lang->line( 'branch_name' ); ?></label>
                                <input type="text" name="nbname" id="nbname" parsley-trigger="change" required placeholder="" class="add_branch form-control">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="CompanyCode"><?php echo $this->lang->line( 'general_branch_code' ); ?></label>
                                <input type="text" name="nbcode" id="nbcode" parsley-trigger="change" required placeholder="" class="add_branch form-control">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="Description"><?php echo $this->lang->line( 'description' ); ?></label>
                                <input type="text" name="nbdescrpt" id="nbdescrpt" parsley-trigger="change" required placeholder="" class="form-control add_branch">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="Description"><?php echo $this->lang->line( 'general_company_code' ); ?></label>
                                <input type="text" name="nbcmcode" id="nbcmcode" parsley-trigger="change" required placeholder="" class="form-control add_branch">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?php echo $this->lang->line( 'general_close' ); ?></button>
                    <button type="button" onclick="newbranchadd(event)" class="btn btn-primary  btn_color waves-effect waves-light" id="new_branch_add"><?php echo $this->lang->line( 'general_add' ); ?></button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Branch Code search -->
    <div class="modal fade" id="view_branch">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="closevalues close" >&times;</button>
                    <h4 class="modal-title" id="view_branch_title"><?php echo $this->lang->line( 'branch_details' ); ?>  </h4>
                </div>
                <div class="modal-body ">
                    <div class="box custom-box">
                        <!--    <div id="search"> -->
                        <table class="table table-striped" id="branch_tab" width="100%">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?php echo $this->lang->line( 'branch_name' ); ?></th>
                                <th scope="col"><?php echo $this->lang->line( 'general_branch_code' ); ?></th>
                                <th scope="col"><?php echo $this->lang->line( 'general_company_code' ); ?></th>
                                <th scope="col"><?php echo $this->lang->line( 'description' ); ?></th>
                            </tr>
                            </thead>
                            <tbody id="show_branchdata"></tbody>
                        </table>
                    </div>
                    <!-- </div> -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn">
                        <?php echo $this->lang->line( 'general_close' ); ?>
                    </button>
                    <button type="button" class="selectbranch btn btn-primary  btn_color waves-effect waves-light" onclick="selectbranchinlist()">
                        <?php echo $this->lang->line( 'general_select' ); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- company Code Add -->
    <div id="create_view_company" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="companyCodeAddmodalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title" id="companyCodeAddmodalLabel"><?php echo $this->lang->line( 'add_company' ); ?></h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="ncname"><?php echo $this->lang->line( 'general_company_name' ); ?></label>
                                <input type="text" name="ncname" id="ncname" parsley-trigger="change" required placeholder="" class="add_company form-control">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="nccode"><?php echo $this->lang->line( 'general_company_code' ); ?></label>
                                <input type="text" name="nccode" id="nccode" parsley-trigger="change" required placeholder="" class="add_company form-control">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="ncdescrpt"><?php echo $this->lang->line( 'description' ); ?></label>
                                <input type="text" name="ncdescrpt" id="ncdescrpt" parsley-trigger="change" required placeholder="" class="form-control add_company">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?php echo $this->lang->line( 'general_close' ); ?></button>
                    <button type="button" onclick="newcompanyadd(event)" class="btn btn-primary  btn_color waves-effect waves-light" id="new_company_add"><?php echo $this->lang->line( 'general_add' ); ?></button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- company Code Find modal content -->
    <div class="modal fade" id="view_company">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="closevalues close">&times;</button>
                    <h4 class="modal-title" id="view_company_title"><?php echo $this->lang->line( 'company_details' ); ?>  </h4>
                </div>
                <div class="modal-body ">
                    <div class="box custom-box">
                        <!--    <div id="search">  -->
                        <table class="table table-striped" id="company_tab" width="100%">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">
                                    <?php echo $this->lang->line( 'truckowner_company' ); ?>
                                </th>
                                <th scope="col">
                                    <?php echo $this->lang->line( 'general_company_code' ); ?>
                                </th>
                                <th scope="col">
                                    <?php echo $this->lang->line( 'truck_desc' ); ?>
                                </th>
                            </tr>
                            </thead>
                            <tbody id="company-show_data"></tbody>
                        </table>
                        <!-- </div> -->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn"><?php echo $this->lang->line( 'general_close' ); ?></button>
                    <button type="button" class="selectcompany btn btn-primary btn_color waves-effect waves-light" onclick="selectcompanyinlist()"><?php echo $this->lang->line( 'general_select' ); ?></button>
                </div>
            </div>
        </div>
    </div>
    <div style="background-color: lightblue;" id="dialog_box" title="&nbsp;&nbsp;Alert">
        <p style="color: red" id="dialog_text"></p>
    </div>
    <div id="dialog" title="&nbsp;&nbsp;Alert">
        <p id="dialog-text"></p>
    </div>
    <div class="modal fade insert_success_div" id="insert_success_div" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header success_message_header"></div>
                <div class="modal-body">
                    <p style="font-size: 19px;">
                        <span class="glyphicon glyphicon-ok-circle popup_circle" style="font-size: 22px; color: green;"></span>&nbsp;
                        <span class="pop_message"><?= $this->lang->line('alert_updatesuccessfully'); ?></span>
                    </p>
                </div>
                <div class="modal-footer success_message_footer">
                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal"><?= $this->lang->line('general_ok'); ?></button>
                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!-- container -->
    </div>
    <!-- content -->
    </div>

    <script>
      var baseurl = "<?php echo base_url();?>"

      $('#add_row_table').click(function () {
        // $('#add_col_table').attr('disabled', true);
        var form_url = baseurl + 'Geotier/getNewRow'
        var row_id = parseInt($(this).data('current-row-id')) + 1
        var no_cols = $(this).data('no-cols')

        var ext_rows = parseInt($('#ext_rows').val())
        ext_rows += 1
        $('#ext_rows').val(ext_rows)

        $('#add_row_table').data('current-row-id', row_id)
        console.log(row_id);

        $.ajax({
          type: 'POST',
          url: form_url,
          data: { row_id: row_id, no_cols: no_cols },
          beforeSend: function () {
            $('#preloader').show()
          },
          success: function (response) {
            $('#add_row_table').data('current-row-id', row_id)
            //alert(response);
            $('#preloader').hide()
            console.log(response)
            $('#tb_sheet').append(response)
          }
        })
      })

      $('#add_col_table').click(function () {
        // $('#add_row_table').attr('disabled', true);
        var form_url = baseurl + 'Geotier/getNewRow'
        // var row_id = parseInt($(this).data('current-row-id')) + 1;
        var col_id = parseInt($(this).data('current-col-id')) + 1
        console.log(col_id)
        var ext_cols = parseInt($('#ext_cols').val())
        ext_cols += 1
        $('#ext_cols').val(ext_cols)
        var t_num_cols = parseInt($('#add_col_table').data('no-cols'))
        $('#add_row_table').data('no-cols', t_num_cols + ext_cols)
        $('#add_col_table').data('current-col-id', col_id)
        var rows = $('#tb_sheet').find('tr').length
        // console.log(rows);
        var colsapn = parseInt($('#tab_hed2').attr('colspan'))
        $('#tab_hed2').attr('colspan', colsapn + 2)

        // console.log(colsapn);
        $('#tier_mtab thead tr:nth-child(2)').append('<th class="wid_td"><b>Min</b></th><th class="wid_td"><b>Max</b></th>')
        $('#tb_sheet tr:nth-child(1)').append('<td class="wid_td2"><input type="text" name="uom2_min_c' + col_id + '" class="form-control"></td><td class="wid_td2"><input type="text" name="uom2_max_c' + col_id + '" class="form-control"></td>')
        $('#tb_sheet tr:not(:first-child)').each(function () {
          var row_seq_id = $(this).data('row_id')
          $(this).append('<td class="wid_td2" colspan="2"><input type="text" value="" name="result_r' + row_seq_id + '_c' + col_id + '" class="form-control"></td>')
        })
      })

      function savecheckrs (e) {
        var tier_name = ($('#tier_name').val()).trim()
        var uom1 = ($('#uom1').val()).trim()
        var uom1_m = ($('#uom1_m').val()).trim()
        var company_code = ($('#company_code').val()).trim()
        var curr = ($('#curr').val()).trim()
        var branch_code = ($('#branch_code').val()).trim()
        var vehicle_type = ($('#vehicle_type').val()).trim()
        var geo_hierarchy = ($('#geo_hierarchy').val()).trim()
        var g_id = ($('#g_id').val()).trim()

        var chkduplicate = 0
        var check_table1 = check_table()
        if ((tier_name.length > 0) && (company_code.length > 0) && (branch_code.length > 0)) {
          chkduplicate = check_name(tier_name, company_code, g_id, e)
        }
        if (tier_name == '') {
          gettoast('top-right', 'tier_name', 'Please Enter Tier Name')
          return false
        } else if (chkduplicate == 1) {
          gettoast('top-right', 'tier_name', 'Tier Name already exists')
          return false
        } else if (geo_hierarchy == '') {
          gettoast('top-right', 'geo_hierarchy', 'Please Select Geo Hierarchy')
          return false
        } else if (uom1 == '' || uom1 == 'SELECT') {
          gettoast('top-right', 'uom1', 'Please Select UOM ')
          return false
        } else if (uom1_m == '' || uom1_m.length == 0 || uom1_m == 'SELECT') {
          gettoast('top-right', 'uom1_m', 'Please Select UOM  Units')
          return false
        } else if (company_code == '') {
          gettoast('top-right', 'company_code', 'Please Select Company Code')
          return false
        } else if (curr == '' || curr == 'SELECT') {
          gettoast('top-right', 'curr', 'Please Select Currency')
          return false
        } else if (check_table1 == 1) {
          gettoast('top-right', 'minimum_1', 'Please enter atleast one record')
          return false
        } else {
          //alert("hai");
          var datastring = $('#tier').serializeArray()
          var form_url = baseurl + 'Geotier/geotierupdate'
          $.ajax({
            type: 'POST',
            url: form_url,
            data: datastring,
            dataType: 'json',
            cache: false,
            beforeSend: function () {
              $('#preloader').show()
            },
            success: function (response) {
              //alert(response);
              $('#preloader').hide()
              console.log(response)
              $('#insert_success_div').modal('show')
              setTimeout(function () {
                window.location.href = baseurl + 'Geotier'
              }, 2000)
            },
            error: function (jqXHR, textStatus, errorThrown) {
              alert('Error Occurred.')
            }
          })
        }
        return false
      }

      function check_name (tier_name, company_code, id, e) {
        //e.preventDefault();
        var data
        $.ajax({
          url: baseurl + 'Geotier/checkname',
          async: false,
          type: 'POST',
          data: {
            'tier_name': tier_name, 'company_code': company_code, 'id': id
          },
          dataType: 'JSON',
          success: function (resp) {
            data = resp
          }
        })
        return data
      }

      function check_table () {
        //e.preventDefault();
        var datastring = $('#tier').serializeArray()
        var data
        $.ajax({
          url: baseurl + 'Geotier/get_min_max_records_count',
          async: false,
          type: 'POST',
          data: datastring,
          dataType: 'JSON',
          success: function (resp) {
            data = resp
          }
        })
        return data
      }

      function gettoast (position, id, desp) {
        if (id != '') {
          if (!$('#' + id).hasClass('errorclass')) {
            $('#' + id).addClass('errorclass')
          }
        }
        init({
          fade_in: 800,
          fade_out: 800,
          position: position,
        })
        toast({
          type: 'custom',
          title: '<span style="color:#000000ab;">Warning Message</span>',
          description: '<span style="color:black;"><b>' + desp + '</b></span>',
          close_color: '#FF7F50',
          border_color: '#FF8C00',
          color: '#FFBF00',
          timeout: 900
        })
      }

      $(document).ready(function () {
        $('#geo_hierarchy').change(function () {
          let get_val = event.target.selectedOptions[0].getAttribute('geo')
          $('#tab_hed').html(get_val)
        })
        $('#uom1').change(function () {
          var val = $(this).val()
          $('#tab_hed1').html(val)
        })
        $('#uom1_m').change(function () {
          // var val1 = $(this).val();
          $('#tab_hed1').html($('#uom1').val() + '&nbsp;[' + $('#uom1_m').val() + ']')
        })
      })

      $(document).ready(function () {
        $('#uom1').change(function () {
          var type = ($(this).val()).toUpperCase()
          var res = generate_drop_down(type)
          $('#uom1_m').html(res)
        })

        $('#geo_hierarchy option').each(function () {
          $(this).text($(this).text().toUpperCase())
        })

        $('#uom2').change(function () {
          var val = $(this).val()
          var option1 = '<option value=\'\'>Select</option>'
          var option = ''
          if (val == 'distance') {
            var option = '<option value=\'km\'>KM</option><option value=\'mi\'>MI</option>'
          } else if (val == 'weight') {
            var option = '<option value=\'kg\'>KG</option><option value=\'lb\'>LB</option><option value=\'ton\'>Tons</option><option value=\'mton\'>M Tons</option>'
          } else if (val == 'volume') {
            var option = '<option value=\'cbm\'>cbm</option>'
          } else if (val == 'Duration') {
            var option = '<option value=\'days\'>Days</option><option value=\'hours\'>Hours</option><option value=\'minutes\'>minutes</option>'
          }
          $('#uom2_m').html(option1 + option)
        })

      })

      function isNumberKey (evt) {
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
          return false

        return true
      }

      function generate_drop_down (type) {
        var data_repsonse = ''
        var formdata = new FormData()
        formdata.set('type', type)
        $.ajax({
          type: 'POST',
          url: baseurl + 'Geotier/generate_drop_down',
          processData: false,
          data: formdata,
          contentType: false,
          cache: false,
          async: false,
          success: function (response) {
            data_repsonse = response
          },
          error: function (jqXHR, textStatus, errorThrown) {
            alert('Error Occurred.')
          }
        })
        return data_repsonse
      }

      function isNumberKey (evt) {
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
          return false

        return true
      }
    $('.resetbtn, .closevalues').click(function(){
    $('#view_branch').modal('hide');
    $('#view_company').modal('hide');
    });
    </script>
    <style>
        wid_td2 {
            min-width: 60px !important;
            color: #797979;
        }

        .wid_td {
            min-width: 60px !important;
            color: #797979;
        }

        .wid_td1 {
            min-width: 100px !important;
            color: #797979;
        }

        .cen1 {
            text-align: center;
            min-width: 80px !important;
        }

        .cen {
            text-align: center;
        }

        .main-datatable .table > tbody > tr > td {
            vertical-align: middle;
            padding: 3px 2px 3px 2px;
        }
    </style>
    <script src="<?php echo base_url(); ?>assets/newtheme/js/custom.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/jquery-ui.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/businesspartners_script.js"></script>
    <script src="<?php echo base_url(); ?>assets/newtheme/plugins/toast/toast.js"></script>
    <link href="<?php echo base_url(); ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css"/>
