<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap.css">
<link rel="stylesheet" href="<?= base_url() ?>assets/css/common.css">
<script src="<?= base_url() ?>assets/js/uservalidation.js"></script>
<script src="<?= base_url() ?>assets/js/jQuery.fixTableHeader.js"></script>
<section class="content-header">
    <h4>Svkonekt KPI Targets</h4>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box custom-box">
                <div class="card">
                    <ul class="nav nav-tabs" role="tablist">
                        <li id="listdetails_currentyear" class="listyear active" data-info="<?= date('Y') ?>" role="presentation"><a href="#details" aria-controls="home" role="tab" data-toggle="tab"><i class="glyphicon glyphicon-list-alt"></i>&nbsp;<?= date('Y') ?></a></li>
                        <li id="listdetails_prevyear" class="listyear" data-info="<?= date("Y", strtotime("-1 year")) ?>" role="presentation"><a href="#details" aria-controls="home" role="tab" data-toggle="tab"><i class="glyphicon glyphicon-list-alt"></i>&nbsp;<?= date("Y", strtotime("-1 year")) ?></a></li>
                        <li id="listdetails_saas" class="listyear" data-info="<?= date('Y') ?>" data-saas="1" role="presentation"><a href="#details" aria-controls="home" role="tab" data-toggle="tab"><i class="glyphicon glyphicon-list-alt"></i>&nbsp;SaaS</a></li>
                    </ul>

                    <div class=""><!--tab-content-->
                        <div role="tabpanel" class="tab-pane active bd reports_search" id="search">

                            <div class="col-md-12">
                                <h4>
                                    <strong>Overall Shipments</strong>
                                </h4>
                            </div>

                            <div class="col-md-12">
                                <div class="col-md-10">
                                    <?php
                                    $dateyear = isset($year) ? $year : date('Y');
                                    $current_year = date('Y');
                                    $target_count = 100000;
                                    if ($dateyear == $current_year) {
                                        $target_count = 500000;
                                    }
                                    $overall_count = $shipment_count;
                                    $percentage = ($overall_count * 100) / $target_count;
                                    ?>

                                    <div class="progress-group">
                                        <div class="progress sm rep_progress">
                                            <div class="progress-bar progress-bar-green" style="width: <?php
                                            echo $percentage; ?>%">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1 rep_count"><?= $shipment_count . '(' . $percentage . ')'; ?>%
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="box">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"><b>Country based Summary</b></h3>
                                    </div>
                                    <div class="box-body">
                                        <div class="table-responsive">
                                            <table class="table no-margin">
                                                <thead>
                                                <tr>
                                                    <th>Country</th>
                                                    <?php
                                                    for ($i = 1; $i <= date('n'); $i++) {
                                                        $timestamp = mktime(0, 0, 0, $i, 1);
                                                        ?>
                                                        <th><?= date('M', $timestamp) ?></th><?php
                                                    } ?>
                                                    <th>YTD-<?= date('Y') ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                $final_total = 0;
                                                $sum = 0;
                                                $montly_ship = [];
                                                foreach ($row_result as $result):
                                                    echo "<tr><td>" . $result['country_name'] . "</td>";
                                                    $month = date('n');
                                                    $row_total = 0;
                                                    for ($i = 1; $i <= date('n'); $i++) {
                                                        echo "<td>" . $result[$i] . "</td>";
                                                        $montly_ship[$i][] = $result[$i];
                                                        $row_total = $row_total + $result[$i];
                                                    }
                                                    $final_total = $final_total + $row_total;
                                                    $delta = ($result['target'] - $row_total);
                                                    $per_achived = 0;
                                                    if ($result['target'] > 0) {
                                                        $per_achived = ($row_total * 100) / ($result['target']);
                                                    }
                                                    $current_month = date('n');
                                                    $projected = round((($result['target']) / 12) * $current_month);
                                                    $remaining_months = 12 - $current_month;
                                                    $deficit = round($projected - $row_total);
                                                    if ($remaining_months == 0) {
                                                        $remaining_months = 1;
                                                    }
                                                    $revised_target = round($delta / $remaining_months);

                                                    echo "<td>" . $row_total . "</td>";
                                                    echo "</tr>";
                                                endforeach; ?>
                                                </tbody>
                                                <tr class="rep_total">
                                                    <td>Total
                                                    </td>
                                                    <?php
                                                    $monnum = date('n');
                                                    $mntint = (int)$monnum;
                                                    for ($i = 1; $i <= date('n'); $i++) {
                                                        ?>
                                                        <td><?= array_sum($montly_ship[$i])
                                                        ?></td><?php
                                                    } ?>
                                                    <td><?= $final_total ?></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<link rel="stylesheet" href="<?= base_url() ?>assets/css/gauge_new.css" type="text/css"/>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxcore.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxdata.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxdraw.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxgauge.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxbuttons.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/jqxslider.js"></script>
<script type="text/javascript" src="<?= base_url() ?>assets/js/gauges/demos.js"></script>
<script src="<?= base_url() ?>assets/js/jquery-ui.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.listyear').on('click', function () {
            var id = $(this).attr('id');
            var year = $('#' + id).attr('data-info');
            var saas = $('#' + id).data('saas');
            $.ajax({
                url: baseurl + 'go99/getyeardata',
                type: 'POST',
                data: {
                    year: year,
                    saas: saas,
                },
                beforeSend: function () {
                    $(".reports_search").html("<center><progress></center>");
                },
                success: function (data) {
                    $('.reports_search').html(data);
                }
            });
        });
        /* gaugemain(<?php echo $shipment_count;?>);    */

    });

    function getSaasYear(currentYear) {
        $.ajax({
            url: baseurl + 'go99/getyeardata',
            type: 'POST',
            data: {
                year: currentYear,
                saas: $('#listdetails_saas').data('saas'),
            },
            beforeSend: function () {
                $(".reports_search").html("<center><progress></center>");
            },
            success: function (data) {
                $('.reports_search').html(data);
            }
        });
    }
</script>

