<html>
<head>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>"></script>
    <script src="https://code.jquery.com/jquery-1.12.0.min.js" integrity="<?=SHA_JQUERY_MIN_JS_V112?>" crossorigin="anonymous"></script>
    <style type="text/css">
        html,
        body,
        #map {
            height: 100%;
            width: 100%;
            margin: 0px;
            padding: 0px
        }
        .panel-widget {
            border-radius: 3px;
            box-shadow: 0 0 3px rgba(0, 0, 0, .2);
            height: auto;
            border: 0;
            margin-bottom: 15px;
            display: table;
            width: 100%;
            max-width: 100%;
        }
        .panel {
            margin-bottom: 20px;
            background-color: #fff;
            border: 1px solid transparent;
            border-radius: 4px;
            -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
            box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
        }
        .panel-heading {
            padding: 10px 15px;
            border-bottom: 1px solid transparent;
            border-top-right-radius: 3px;
            border-top-left-radius: 3px;
        }
        .widget-heading {
            border: 1px solid #293a4a;
            background-color: rgba(41, 58, 74, .95);
            color: #fff;
            text-transform: uppercase;
        }
        .panel>.table:last-child,
        .panel>.table-responsive:last-child>.table:last-child {
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
        }
        .panel>.table,
        .panel>.table-responsive>.table {
            margin-bottom: 0;
        }
        .table {
            width: 100%;
            margin-bottom: 20px;
            max-width: 100%;
            background-color: transparent;
            border-collapse: collapse;
            border-spacing: 0;
        }
        .table>tbody>tr>td,
        .table>tfoot>tr>td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border-top: 1px solid #ddd;
        }
        .general-info-label {
            text-transform: capitalize;
            display: block;
        }
        html {
            font-family: monospace;
        }
        .circle {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            color: black;
            font-size: large;
            line-height: 30px;
            text-align: center;
            background: #73BF37
        }
        .red_circle {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            color: black;
            font-size: large;
            line-height: 30px;
            text-align: center;
            background: #F7685C
        }
        @media only screen and (max-width: 767px) {
            .navbar-static-top{
                display: none;
            }
        }
        .rightBottom{
            position: absolute;
            bottom: 0;
            left: 0;
            background: white;
            z-index: 1;
            padding: 10px;
        }
    </style>
    <?php $dlat = $dlng = 0;
    if(count($record)>0){
        $dlat = $record->latitude;
        $dlng = $record->longitude;
    }?>
    <script type="text/javascript">
        var dlatitude = <?php echo $dlat;?>;
        var dlongitude = <?php echo $dlng;?>;
        var gkey = "<?php echo GOOGLE_MAP_KEY;?>";
        var geocoder;
        var map;
        var directionsDisplay;
        var i,vehicle;
        var q = [];
        var googleMap;
        var nextTimeStamp = "";
        var trackerFrequency = 30000;
        var directionsService ;
        function getLatitudeLongitude(callback, address) {
            // If adress is not supplied, use default value 'Ferrol, Galicia, Spain'
            address = address || '';
            // Initialize the Geocoder
            geocoder = new google.maps.Geocoder();
            if (geocoder) {
                geocoder.geocode({
                    'address': address
                }, function (results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        callback(results[0]);
                    }
                });
            }
        }
        var locations = <?php 
            $rows=[];
            if(count($stops)>0){
                foreach($stops as $row){
                    if($row['ship_type']=="P"){
                        $rows[]=array($row['name'],$row['lat'],$row['lng']);
                    }else{
                        $rows[]=array($row['name'],$row['lat'],$row['lng']);
                    }
                }
                $rows[] = array('current',(float)$pos['latitude'],(float)$pos['longitude']);
            }
            echo json_encode($rows).";";
        ?>
        window.parent.$("#RtPopupType").css("width","70%");
        function initialize() {
            directionsService = new google.maps.DirectionsService();
            directionsDisplay = new google.maps.DirectionsRenderer();
            map = new google.maps.Map(document.getElementById('map'), {
                zoom: 4,
                center: new google.maps.LatLng(17, 80),
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });
            directionsDisplay.setMap(map);
            var infowindow = new google.maps.InfoWindow();
            var request = {
                travelMode: google.maps.TravelMode.DRIVING
            };
            for (i = 0; i < locations.length; i++) {
                var point = new google.maps.LatLng(locations[i][1],locations[i][2]);
                if (i == 0) {
                    request.origin = point;
                }else if (i == locations.length - 1){
                    request.destination = point;
                }else {
                    if (!request.waypoints) request.waypoints = [];
                    request.waypoints.push({
                        location: point,
                        stopover: true
                    });
                }
            }
            directionsService.route(request, function(result, status) {
                if (status == google.maps.DirectionsStatus.OK) {
                    directionsDisplay.setDirections(result);
                }
                vehicle = new google.maps.Marker({
                    position: {lat: dlatitude, lng: dlongitude},
                    map: map,
                    icon: getIconByAngle(0)
                });
                getLiveLocation('');
            });
        }
        function getLiveLocation(timestamp){
            if(timestamp==""){
                console.clear();
            }
            $.ajax({
                url:"<?=base_url()?>visibility/getLiveLocation/<?=$imei?>/"+timestamp,
                dataType:"JSON",
                success:function(data){
                    data.data
                    $.each(data.data,function(i,v){
                        q.push(v); 
                    });
                    if (timestamp == ""){
                        if(q.length!=0){
                            
                            var d = q.shift();
                            vehicle.setPosition(new google.maps.LatLng(d.lat,d.lng));
                            map.panTo(new google.maps.LatLng(d.lat,d.lng));
                            $(".speed").html(d.speed);
                            $(".timestamp").html(d.receivedon);
                            //q.shift();
                            startQueueProcessing();
                        }
                    }
                    if(data.data.length!=0){
                        nextTimeStamp = data.data[data.data.length - 1].timestamp;
                    }
                    setTimeout(function() {
                        getLiveLocation(nextTimeStamp);
                    }, 10000);
                }
            });
        }
        function startQueueProcessing(){
            queueFunction();
            setInterval(function(){
                queueFunction();
            }, trackerFrequency);
        }
        function queueFunction(){
            var data = q.shift();
            console.log(new Date($.now()));
            console.log(q);
            if (data != null && vehicle != null) {
                $(".speed").html(data.speed);
                $(".timestamp").html(data.receivedon);
                angle = Math.round(data.course/10);
                vehicle.setIcon(getIconByAngle(angle));
                getAddress(vehicle.position.lat(),vehicle.position.lng())
                var newPosition = new google.maps.LatLng(data.lat,data.lng);
                var oldPosition = new google.maps.LatLng(vehicle.position.lat(),vehicle.position.lng());
                vehicle.animateTo(map,newPosition, { duration: trackerFrequency });
            }
        }
        function getAddress (latitude, longitude) {
            new Promise(function (resolve, reject) {
                var request = new XMLHttpRequest();

                var method = 'GET';
                var url = 'https://maps.googleapis.com/maps/api/geocode/json?latlng=' + latitude + ',' + longitude + '&sensor=true&key='+gkey;
                var async = true;

                request.open(method, url, async);
                request.onreadystatechange = function () {
                    if (request.readyState == 4) {
                        if (request.status == 200) {
                            var data = JSON.parse(request.responseText);
                            var address = data.results[0];
                            $(".locationName").html(address.formatted_address);
                        }
                        else {
                            reject(request.status);
                        }
                    }
                };
                request.send();
            });
        };

        function getIconByAngle(angle){
            return "<?=base_url()?>assets/vehicle/vehicle copy "+angle+".png";
        }
        google.maps.event.addDomListener(window, "load", initialize);
    </script>
    <title>Trip Map View :: RT Trucks</title>
</head>
<body>
    <div style="width:100%;">
        <div style="width:80%; float:left;">
            <div id="map"></div>
            <div class="rightBottom">
                <table>
                    <tbody>
                        <tr><td colspan="2"><?=$vehicle->register_number?></td></tr>
                        <tr style="font-size: smaller;"><td colspan="2" class="locationName"></td></tr>
                        <tr>
                            <td rowspan="2" style="font-size: 24px;padding-right: 5px;font-weight: 600;width: 18px;" valign="bottom" class="speed"></td>
                            <td style="font-size: 12px;" valign="bottom" class="timestamp"></td>
                        </tr>
                        <tr><td style="font-size: 10px;" valign="top">KM/H</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div style="width:20%; float:right;max-height: 100%;overflow-y: auto;">
            <div id="generalInfoSection" class="panel panel-widget">
                <div id="generalInfoHeaderSection" class="panel-heading widget-heading">
                    Trip Information
                </div>
                <table class="table">
                    <tbody>
<?php 
$alphabet = range('A', 'Z');
$rows=[];
$i=0;
if(count($stops)>0){
    foreach($stops as $row){
        if($row['ship_type'] == 'P'){
            $loc = $row['pickup'];
            $date=$row['startdate'];
        }else{
            $loc = $row['drop'];
            $date=$row['enddate'];
        }
?>
                            <tr>
                                <td>
                                    <label id="lblHomeDirectory" class="general-info-label">
                                        <div class="<?php if($row['ship_type'] == 'P') echo 'circle';else echo 'red_circle';?>">
                                            <?php echo $alphabet[$i];?>
                                        </div>
                                        <?=$row['name'].' ('.$row['ship_type'].')';?><br/><?=date("d M Y, h:i A",strtotime($date))?><br/>Location:<?php echo $loc;?></br>Weight:<?=$row['shipment_weight']?></br>Volume:<?=$row['shipment_volume']?></br>
                                    </label>
                                </td>
                            </tr>
<?php
        $i++;
    }
}
?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>