<html>
<head>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>"></script>
<style type="text/css">
	html,
body,
#map {
  height: 100%;
  width: 100%;
  margin: 0px;
  padding: 0px
}
.panel-widget {
    border-radius: 3px;
    box-shadow: 0 0 3px rgba(0,0,0,.2);
    height: auto;
    border: 0;
    margin-bottom: 15px;
    display: table;
    width: 100%;
    max-width: 100%;
}
.panel {
    margin-bottom: 20px;
    background-color: #fff;
    border: 1px solid transparent;
    border-radius: 4px;
    -webkit-box-shadow: 0 1px 1px rgba(0,0,0,.05);
    box-shadow: 0 1px 1px rgba(0,0,0,.05);
}
.panel-heading {
    padding: 10px 15px;
    border-bottom: 1px solid transparent;
    border-top-right-radius: 3px;
    border-top-left-radius: 3px;
}
.widget-heading {
    border: 1px solid #293a4a;
    background-color: rgba(41,58,74,.95);
    color: #fff;
    text-transform: uppercase;
}
.panel>.table:last-child, .panel>.table-responsive:last-child>.table:last-child {
    border-bottom-right-radius: 3px;
    border-bottom-left-radius: 3px;
}
.panel>.table, .panel>.table-responsive>.table {
    margin-bottom: 0;
}
.table {
    width: 100%;
    margin-bottom: 20px;
    max-width: 100%;
    background-color: transparent;
    border-collapse: collapse;
    border-spacing: 0;
}
.table>tbody>tr>td, .table>tfoot>tr>td {
    padding: 8px;
    line-height: 1.42857143;
    vertical-align: top;
    border-top: 1px solid #ddd;
}

.general-info-label {
    text-transform: capitalize;
    display: block;
}
html{
  font-family: monospace;
}
.circle {
  width: 30px;
  height: 30px;
  border-radius: 50%;
  color: black;
  font-size: large;
  line-height: 30px;
  text-align: center;
  background: #73BF37
}
.red_circle {
  width: 30px;
  height: 30px;
  border-radius: 50%;
  color: black;
  font-size: large;
  line-height: 30px;
  text-align: center;
  background: #F7685C
}
</style>
<script>
var geocoder;
var map;
var directionsDisplay;
var directionsService = new google.maps.DirectionsService();
var locations =<?php 
	$rows=[];
	if($emps->num_rows()>0){
		foreach($emps->result() as $row){
      if($row->plat != '0.0' && $row->plng != '0.0'){
        $rows[]=array($row->name,$row->plat,$row->plng);
      }
		}
		$rows[]=$company;
	}
	echo json_encode($rows).";";
?>

function initialize() {
  directionsDisplay = new google.maps.DirectionsRenderer();


  var map = new google.maps.Map(document.getElementById('map'), {
    zoom: 10,
    center: new google.maps.LatLng(-33.92, 151.25),
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    styles:[{
                                featureType: "all",
                                stylers: [{
                                    saturation: 0
                                }, {
                                    hue: "#e7ecf0"
                                }]
                            }, {
                                featureType: "road",
                                stylers: [{
                                    saturation: -70
                                }]
                            }, {
                                featureType: "transit",
                                stylers: [{
                                    visibility: "off"
                                }]
                            }, {
                                featureType: "poi",
                                stylers: [{
                                    visibility: "off"
                                }]
                            }, {
                                featureType: "water",
                                stylers: [{
                                    visibility: "simplified"
                                }, {
                                    saturation: -60
                                }]
                            }]
  });
  directionsDisplay.setMap(map);
  var infowindow = new google.maps.InfoWindow();

  var marker, i;
  var request = {
    travelMode: google.maps.TravelMode.DRIVING
  };
  for (i = 0; i < locations.length; i++) {
    marker = new google.maps.Marker({
      position: new google.maps.LatLng(locations[i][1], locations[i][2]),
    });

    google.maps.event.addListener(marker, 'click', (function(marker, i) {
      return function() {
        //infowindow.setContent(locations[i][0]);
        infowindow.open(map, marker);
      }
    })(marker, i));

    if (i == 0) request.origin = marker.getPosition();
    else if (i == locations.length - 1) request.destination = marker.getPosition();
    else {
      if (!request.waypoints) request.waypoints = [];
      request.waypoints.push({
        location: marker.getPosition(),
        stopover: true
      });
    }

  }
  directionsService.route(request, function(result, status) {
    if (status == google.maps.DirectionsStatus.OK) {
      directionsDisplay.setDirections(result);
    }
  });
}
google.maps.event.addDomListener(window, "load", initialize);
</script>
<title>Trip Map View :: RT Trucks</title>
</head>
<body>
<div style="width:100%;">
  <div style="width:80%; float:left;">
    <div id="map"></div>
  </div>
  <div style="width:20%; float:right;max-height: 100%;overflow-y: auto;overflow-x: hidden;">
    <div id="generalInfoSection" class="panel panel-widget">
            <div id="generalInfoHeaderSection" class="panel-heading widget-heading">
                Trip Information
            </div>
            <table class="table">
                <tbody>
<?php 
$alphabet = range('A', 'Z');


  $rows=[];
  $i=0;
  if($emps->num_rows()>0){

      foreach($emps->result() as $row){
        if($row->ship_type == 'P'){
          $loc = $row->pickup;
        }else{
          $loc = $row->drop;
        }
?>
<tr>
    <td>
        <label id="lblHomeDirectory" class="general-info-label"><div class="circle"><?php echo $alphabet[$i];?></div><?=$row->name.' ('.$row->ship_type.')';?><br/><?=date("Y-m-d h:i A",strtotime($row->check_in))?><br/><?php echo $loc;?></label>
    </td>
</tr>
<?php
    $i++;
    }
      if($emps->row()->trip_type=="0"){
?>
<tr>
    <td>
        <label id="lblHomeDirectory" class="general-info-label"><div class="red_circle"><?php echo $alphabet[$i];?></div><?=$company[0]?></label>
    </td>
</tr>
<?php
$i++;
      }

  }
?>
                </tbody>
            </table>
        </div>
  </div>
</div>
</body>
</html>