<?php

$this->load->helper('generic');
$prevFrom  = date('d-m-Y', strtotime("-2 week"));
$currentTo = date('d-m-Y');

?>
<style>
    .key {
        color: #015692;
    }

    .string {
        color: #54790d;
    }

    .number {
        color: #6a0d79;
        display: inline-block;
    }

    pre {
        background-color: #f6f6f6;
        color: #2f3337;
    }

    td.noclick {
        pointer-events: none;
    }

    .fixed_widh_btn1 {
        width: 120px;
        padding: 2px;
    }

    .fixed_widh_btn2 {
        width: 151px;
        padding: 2px;
    }

    .fixed_widh_btn3 {
        width: 113px;
        padding: 2px;
    }

    .fixed_widh_btn4 {
        width: 172px;
        padding: 2px;
    }
    .alarmActive{
        font-weight: 500;
    }

    .alarmInactive{
        cursor: not-allowed;
    }

    .alarmActive:hover{
        font-weight: 500;
        text-decoration: underline;
    }

    .spin {
        -webkit-animation:spin 1000ms linear infinite;
        -moz-animation:spin 1000ms linear infinite;
        animation:spin 1000ms linear infinite;
    }
    @-moz-keyframes spin { 100% { -moz-transform: rotate(360deg); } }
    @-webkit-keyframes spin { 100% { -webkit-transform: rotate(360deg); } }
    @keyframes spin { 100% { -webkit-transform: rotate(360deg); transform:rotate(360deg); } }

    /***Snackbar CSS start***/

    #snackbar {
        visibility: hidden;
        min-width: 250px;
        margin-left: 30px;
        background-color: #162d56;
        color: #ffffff;
        border: 3px solid #13b4e5;
        text-align: center;
        border-radius: 5px;
        padding: 10px;
        padding-top: 0px;
        position: fixed;
        z-index: 99999;
        left: 0;
        bottom: 30px;
        line-height: 15px;
    }

    .toast-body{
        text-align: left;
        float: left;
        display: block;
        width: 100%;
        padding: 5px 0 5px 0;
        text-transform: capitalize;
    }

    .toast-close {
        float: right;
        left: 0;
        position: relative;
        top: 10px;
    }

    .undo-toast {
        color: #7ba7ef;
        font-weight: 500;
        text-decoration: none;
        padding: 10px;
        /*transition:all 0.5s*/
    }
    .undo-toast:hover {
        background: rgb(31, 31, 31);
        border-radius: 5px;

    }
    .show-toast {
        visibility: visible !important;
        animation: fadein 0.5s, fadeout 0.3s;
    }
    /***Snackbar CSS End***/
</style>
<div class="content-page">

    <!-- Start content -->
    <div class="content">
        <div class="container">
            <div class="row">
                <!-- fillter section -->
                <div class="col-xs-12">
                    <div class="filter-section mtop15 bg-white ptlbr20">
                        <div class="col-md-10 col-sm-12">
                            <div class="row">
                                <form method="POST" action="#" id="search_edi" onsubmit="return checkseachvalidation(this);">
                                    <div class="col-sm-2 fixed_widh_btn1">
                                        <div class="form-group">
                                          <?php
                                          $aqufromdate = (isset($_POST['from_date'])) ? $_POST['from_date'] : $prevFrom; ?>
                                            <input type="text" name="from_date" id="from_date"
                                                   parsley-trigger="change"
                                                   placeholder="<?= $this->lang->line('general_from_date') ?>"
                                                   class="form-control" form="search_edi" autocomplete="off"
                                                   value="<?= $aqufromdate ?>"> <i
                                                    class="icon tru-icon-calendar"></i>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn1">
                                        <div class="form-group">
                                          <?php
                                          $aqutodate = (isset($_POST['to_date'])) ? $_POST['to_date'] : $currentTo; ?>
                                            <input type="text" name="to_date" id="to_date"
                                                   parsley-trigger="change" form="search_edi"
                                                   placeholder="<?= $this->lang->line('general_to_date') ?>"
                                                   class="form-control" autocomplete="off"
                                                   value="<?= $aqutodate ?>"> <i class="icon tru-icon-calendar"></i>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn1">
                                        <div class="form-group">
                                          <?php
                                          $obj_type = (isset($_POST['obj_type'])) ? $_POST['obj_type'] : ''; ?>
                                            <select form="search_edi" id="obj_type" name="obj_type" class="form-control">
                                                <option value=""><?= $this->lang->line('general_name') . "'s"; ?></option>
                                              <?php

                                              if (!empty($object_types) && count($object_types) > 0) {
                                                foreach ($object_types as $object_types_list) { ?>
                                                    <option value="<?= $object_types_list['id']; ?>"
                                                      <?php
                                                      if ($object_types_list['id'] == $obj_type) {
                                                        echo "selected";
                                                      } ?>> <?= $object_types_list['edi_name']; ?> </option>
                                                  <?php
                                                }
                                              } ?>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn2">
                                        <div class="form-group">
                                          <?php
                                          $bound_type = (isset($_POST['bound_type'])) ? $_POST['bound_type'] : ''; ?>
                                            <select form="search_edi" id="bound_type" name="bound_type" class="form-control">
                                                <option <?= $bound_type == "0" ? 'selected' : '' ?> value="0">Bounded Type</option>
                                                <option <?= $bound_type == "1" ? 'selected' : '' ?> value="1">Inbound</option>
                                                <option <?= $bound_type == "2" ? 'selected' : '' ?> value="2">Outbound</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn3">
                                        <div class="form-group">

                                          <?php
                                          $status = (isset($_POST['status'])) ? $_POST['status'] : '';
                                          ?>
                                            <select form="search_edi" name="status" id="status" class="form-control">
                                                <option value=""><?= $this->lang->line('leftmenu_status'); ?></option>
                                                <option value="1"
                                                  <?php
                                                  if ($status == '1') {
                                                    echo "selected";
                                                  } ?>>Success
                                                </option>
                                                <option value="0"
                                                  <?php
                                                  if ($status == '0') {
                                                    echo "selected";
                                                  } ?>>Fail
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn4">
                                        <div class="form-group">

                                          <?php
                                          $txn_obj_id = (isset($_POST['txn_obj_id'])) ? $_POST['txn_obj_id'] : ''; ?>
                                            <input type="text" name="txn_obj_id" parsley-trigger="change"
                                                   placeholder="<?= $this->lang->line('tran_obj_id'); ?> "
                                                   form="search_edi" autocomplete="off" class="form-control"
                                                   id="txn_obj_id" value="<?= $txn_obj_id; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-2 fixed_widh_btn1">
                                        <button type="submit" name="searchsubmit" id="searchsubmit" class="btn  btn-primary btn_color" value="<?= "search" ?>"><?= "search" ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-12">
                            <div class="filter_icons">
                                <div class="navbar pull-right">
                                    <div class="dropdown">
                                        <button class="dropbtn"><span class="icon tru-icon-quick-menu"></span> </button>
                                        <div class="dropdown-content">
                                            <button class="btn btn-primary btn_color" ></button>
                                            <button class="btn btn-primary btn_color" id=""></button>
                                            <a href="#" id="view_all_assets_btn"><i class="icon tru-icon-template"></i>View Assets</a>
                                            <a href="#" id="view_all_alarms_btn"><i class="fa fa-bell"></i>View Alarms</a>
                                        </div>
                                    </div>
                                    <div class="dropdown">
                                        <button class="dropbtn">
                                            <span class="icon tru-icon-export"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="exportsOptions('excel')"><i class="icon tru-icon-excel"></i><?= $this->lang->line('general_excel'); ?></a>
                                            <a href="#" onclick="exportsOptions('pdf')"><i class="icon tru-icon-pdf"></i><?= $this->lang->line('general_pdf'); ?></a>
                                            <a href="#" onclick="exportsOptions('print')"><i class="icon tru-icon-print"></i><?= $this->lang->line('general_print'); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white ptlbr15 mb70">
                        <div class="main-datatable">
                            <div class="table-responsive">
                                <!-- container -->

                                <button class="btn btn-primary btn_color" id="sync_assets_alarms_btn"><i class="fa fa-sync-alt syncIcon"></i> Sync Assets/Alarms</button>
                                <table id="servicetable" class="table table-striped table-bordered forcheckboxes" style="width: 100%">
                                    <thead>
                                    <tr>
                                        <th class="shoring_icon_no">
                                            <div class="checkbox checkbox-info">
                                                <label> <input type="checkbox" class="checkAll" value="">
                                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                </label>
                                            </div>
                                        </th>

                                        <th><b><?= $this->lang->line('tran_obj_id'); ?> </b></th>
                                        <th><b><?= 'External-id'; ?> </b></th>
                                        <th><b><?= 'Start POI'; ?> </b></th>
                                        <th><b><?= 'End POI'; ?> </b></th>
                                        <th><b><?= $this->lang->line('bpartner_editype'); ?> </b></th>
                                        <th><b><?= 'Vehicle type'; ?> </b></th>
                                        <th><b><?= 'Alarms'; ?> </b></th>
                                        <th><b><?= $this->lang->line('format_type'); ?> </b></th>
                                        <th><b><?= 'Request Type' ?> </b></th>
                                        <th><b><?= 'Response Type' ?> </b></th>
                                        <th><b><?= $this->lang->line('leftmenu_status'); ?> </b></th>
                                        <th><b><?= 'Nicplace Tour Status'; ?> </b></th>
                                        <th><b><?= $this->lang->line('general_created_on'); ?> </b></th>
                                        <th><b><?= $this->lang->line('general_company_code'); ?> </b></th>
                                        <th><b><?= $this->lang->line('general_branch_code'); ?> </b></th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <?php
                                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                    if (!empty($getdata)) {
                                      foreach ($getdata as $getdata_e) { ?>
                                          <tr>
                                              <td>
                                                  <div class="checkbox checkbox-info">
                                                      <label> <input type="checkbox" name="chck1" id="chck1[]" value=""> <span class="cr"><i class="cr-icon fa fa-check"></i></span> </label>
                                                  </div>
                                              </td>
                                              <td><?= $getdata_e['txn_obj_id']; ?></td>
                                              <td><?= $getdata_e['tour_id']; ?>
                                                  <a href="#" class="dt-delete" onclick="boundspopup(<?= $getdata_e['nt_id']; ?>, 0)">
                                                      <span class="icon tru-icon-view" aria-hidden="true"></span>
                                                  </a>
                                              </td>
                                              <td>
                                                <?= $getdata_e['pickup_poi_id']; ?>
                                                  <a href="#" class="dt-delete" onclick="boundspopup(<?= $getdata_e['pickup_poi_id']; ?>, 1)">
                                                      <span class="icon tru-icon-view" aria-hidden="true"></span>
                                                  </a>
                                              </td>
                                              <td>
                                                <?= $getdata_e['delivery_poi_id']; ?>
                                                  <a href="#" class="dt-delete" onclick="boundspopup(<?= $getdata_e['pickup_poi_id']; ?>, 1)">
                                                      <span class="icon tru-icon-view" aria-hidden="true"></span>
                                                  </a>
                                              </td>
                                              <td><?= ($getdata_e['edi_type'] == 1) ? "EDI Data" : "EDI Status"; ?></td>
                                              <td><?= ucfirst($getdata_e['request_for']); ?></td>
                                              <td>
                                                <?php
                                                $edi_response = json_decode($getdata_e['edi_response'], true);
                                                $edi_request = json_decode($getdata_e['edi_request'], true);
                                                $alarm_ids    = [];
                                                $nicplace_tour_status = strtoupper($getdata_e['tour_status'] ?: 'n/a');
                                                if (!empty($edi_request)) {
                                                  $alarm_ids = $edi_request['alarms']['ids'] ?? [];
                                                }
                                                if (! empty($alarm_ids)) {
                                                  $alarm_class  = 'primary';
                                                  $alarm_active = 'alarmActive';
                                                  $alarm_text = count($alarm_ids) . ' Added';
                                                } else {
                                                  $alarm_class  = 'muted';
                                                  $alarm_active = 'alarmInactive';
                                                  $alarm_text   = 'N/A';
                                                }
                                                ?>
                                                  <a href="javascript:void(0)" class="alarmBtn <?= $alarm_active ?> text-<?= $alarm_class ?>" data-alarm-ids='<?= json_encode($alarm_ids) ?>'><?= $alarm_text ?></a>
                                              </td>
                                              <td><?= $getdata_e['edi_format_type']; ?></td>
                                              <td><b><?= $getdata_e['http_request_method']; ?></b></td>
                                              <td><?php $http_response_word = get_http_response_word($getdata_e['http_request_method'],$getdata_e['http_status']); ?>
                                                  <b><span class="text-<?=$http_response_word['color']?>"> <?= $http_response_word['key']?></span></b>
                                              </td>

                                            <?php
                                            if ($getdata_e['status'] && $getdata_e['http_status'] < 400) {
                                              $lb_class = 'success';
                                              $lb_value = 'Success';
                                            } else {
                                              $lb_class = 'danger';
                                              $lb_value = 'Failed';
                                            }
                                            ?>
                                              <td><b><?= $getdata_e['http_status'] ?></b> <span class="label label-<?= $lb_class ?>"><?= $lb_value ?></span></td>
                                              <td><b class="<?= nicplace_status_class($nicplace_tour_status) ?>"><?= $nicplace_tour_status ?></b></td>
                                              <td><?= getdatetimebytimezone($curtz, $getdata_e['created_on'], DFLT_TZ)['datetime']; ?></td>
                                              <td><?= $getdata_e['company_code']; ?></td>
                                              <td><?= $getdata_e['branch_code']; ?></td>
                                          </tr>
                                        <?php
                                      }
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->
</div>
<div id="snackbar" class="fadeIn">
    <i class="fa fa-times toast-close" onclick="$(this).parent('div#snackbar').removeClass('show-toast');"></i>
    <span id="toast-message"></span>
</div>

<div class="modal fade" id="view_rqe">
    <p id="datatype" class="hide"></p>
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="bound_title"></h4>
            </div>
            <div class="modal-body">
                <div class="row" style="display: flex">
                    <div class="col-md-6">
                        <h4>Request</h4>
                        <pre id="data_request"></pre>
                    </div>
                    <div class="col-md-6">
                        <h4>Response</h4>
                        <pre id="data_response"></pre>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div style="z-index: 9999;" class="modal fade" id="alarms_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header success_message_header">
                <button type="button" class="closevalues close" data-dismiss="modal">×</button>
                <h4 class="modal-title" id="view_customer_title">Alarms List</h4>
            </div>
            <div class="modal-body">
                <h4 class="pop_message_load"></h4>
                <div class="pop_message">
                    <table class="table table-striped" id="alarms_tb" style="width: 100%">
                        <thead>
                            <tr>
                                <th scope="col">Alarm ID</th>
                                <th scope="col">Name</th>
                                <th scope="col">Status</th>
                            </tr>
                        </thead>
                        <tbody id="alarms_tb_body"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer success_message_footer">
                <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Close</button>
            </div>

        </div>
    </div>
</div>

<div style="z-index: 9999;" class="modal fade" id="view_all_assets_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header success_message_header">
                <button type="button" class="closevalues close" data-dismiss="modal">×</button>
                <h4 class="modal-title" id="view_customer_title">Assets List</h4>
            </div>
            <div class="modal-body">
                <h4 class="pop_message_load"></h4>
                <div class="pop_message">
                    <table class="table table-striped" id="view_all_assets_tb" style="width: 100%">
                        <thead>
                        <tr>
                            <th scope="col">Asset ID</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Service Provider Id</th>
                            <th scope="col">Status</th>
                        </tr>
                        </thead>
                        <tbody id="view_all_assets_tb_body"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer success_message_footer">
                <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Close</button>
            </div>

        </div>
    </div>
</div>

<div style="z-index: 9999;" class="modal fade" id="view_all_alarms_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header success_message_header">
                <button type="button" class="closevalues close" data-dismiss="modal">×</button>
                <h4 class="modal-title" id="view_customer_title">Alarms List</h4>
            </div>
            <div class="modal-body">
                <h4 class="pop_message_load"></h4>
                <div class="pop_message">
                    <table class="table table-striped" id="view_all_alarms_tb" style="width: 100%">
                        <thead>
                        <tr>
                            <th scope="col">Alarm ID</th>
                            <th scope="col">Name</th>
                            <th scope="col">For Trailer</th>
                            <th scope="col">For Truck</th>
                            <th scope="col">Status</th>
                        </tr>
                        </thead>
                        <tbody id="view_all_alarms_tb_body"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer success_message_footer">
                <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Close</button>
            </div>

        </div>
    </div>
</div>

<script src="<?= base_url(); ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="<?= base_url(); ?>assets/newtheme/js/custom.js"></script>
<link href="<?= base_url(); ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css"/>
<script src="<?= base_url(); ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url(); ?>assets/js/daysValidation.js"></script>
<script>
  function checkseachvalidation (e) {
    var fromDate = $('#from_date').val()
    var toDate = $('#to_date').val()
    var obj_type = $('#obj_type').val()
    var status = $('#status').val()
    var txn_obj_id = $('#txn_obj_id').val()
    if (toDate == '') {
    } else {
      if (fromDate == '') {
        gettoast('top-right', 'fromDate', 'Please Enter From Date')
        return false
      }
    }
    if (status == '' && txn_obj_id == '' && obj_type == '' && fromDate == '' && toDate == '') {
      gettoast('top-right', '', 'Please select any field for search orders')
      return false
    }

    var daysCount = getHistoryDaysCount(fromDate, toDate, 'd-m-y', '-')
    if (daysCount > 30) {
      gettoast('top-right', '', 'Max History Days Are Limited To 30 Days')
      return false
    }

  }

  function gettoast (position, id, desp) {
    if (id != '') {
      /*  $('#'+id).focus();*/
      if (!$('#' + id).hasClass('errorclass')) {
        $('#' + id).addClass('errorclass')
      }
    }
    init({
      fade_in: 800,
      fade_out: 800,
      position: position,
    })
    toast({
      type: 'custom',
      title: '<span style="color:#000000ab;">Warning Message</span>',
      description: '<span style="color:black;"><b>' + desp + '</b></span>',
      close_color: '#FF7F50',
      border_color: '#FF8C00',
      color: '#FFBF00',
      timeout: 900
    })
  }

  var baseurl = "<?php echo base_url();?>"
  $(document).ready(function () {
    $('.unselectable').prop('disabled', true)
    var from_date = $('#from_date').val()
    if (from_date != '') {
      var date_array = from_date.split('-')
      // console.log(date_array);
      var newDate = date_array[1] + '-' + date_array[0] + '-' + date_array[2]
      var formatDate = new Date(newDate).getTime()
      var minDate = new Date(formatDate)
      // var minDate = new Date(date_array[2],date_array[1],date_array[0]);
      $('#to_date').datepicker('setStartDate', minDate)
    }
  })

  $('#from_date').datepicker({
    format: 'dd-mm-yyyy',
    //todayHighlight: true,
    autoclose: true,
  }).on('changeDate', function (selected) {
    var minDate = new Date(selected.date.valueOf())
    console.log(selected.date.valueOf())
    $('#to_date').datepicker('setStartDate', minDate)
    // $('#to_date').val('');
  })
  $('#to_date').datepicker({
    format: 'dd-mm-yyyy',
  }).on('changeDate', function (selected) {
    var maxDate = new Date(selected.date.valueOf())
    $('#from_date').datepicker('setEndDate', maxDate)
  })

  $('.checkAll').on('click', function () {
    if (this.checked == true)
      $('.forcheckboxes').find('input[name="chck1"]').prop('checked', true)
    else
      $('.forcheckboxes').find('input[name="chck1"]').prop('checked', false)
  })

  function boundspopup (id, poiFlag = 0) {

    var title_val = 'EDI API'
    if (poiFlag) {
      title_val = 'POI API'
    }
    $.ajax({
      url: baseurl + 'Nicplacetransactions/getbounddata',
      type: 'POST',
      data: { 'id': id, 'poiFlag': poiFlag },
      dataType: 'text',
      success: function (data) {
        var res = JSON.parse(data)
        console.log(res);
        console.log(data.length);
        if (data.length) {
          var request = JSON.parse(res.request)
          var response = JSON.parse(res.response)
          $('#bound_title').html(title_val)
          $('#data_request').html(syntaxHighlight(JSON.stringify(request, null, 2)))
          $('#data_response').html(syntaxHighlight(JSON.stringify(response, null, 2)))
          $('#view_rqe').modal('show')
        } else {
          var em_data = 'No data is available in the ' + title_val
          $('#bound_title').html(title_val)
          $('#data_request').text(em_data)
          $('#data_response').text(em_data)
          $('#view_rqe').modal('show')
        }
      }
    })

  }

  function syntaxHighlight (json) {
    if (typeof json != 'string') {
      json = JSON.stringify(json, undefined, 2)
    }
    json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;')
    return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
      var cls = 'number'
      if (/^"/.test(match)) {
        if (/:$/.test(match)) {
          cls = 'key'
        } else {
          cls = 'string'
        }
      } else if (/true|false/.test(match)) {
        cls = 'boolean'
      } else if (/null/.test(match)) {
        cls = 'null'
      }
      return '<span class="' + cls + '">' + match + '</span>'
    })
  }

  $('.alarmBtn').click(function (){
    var alarmIds = $(this).attr('data-alarm-ids');
    var table = $('#alarms_tb').DataTable();
    table.destroy();
    console.log('alarmIds', alarmIds);
    $.ajax({
      url: baseurl + 'Nicplacetransactions/getalarms',
      type: 'POST',
      data: { 'ids': alarmIds },
      dataType: 'json',
      beforeSend: function () {
        $('#alarms_tb_body').html('');
        $('.pop_message_load').html('Please wait..!');
        $("#alarms_model").modal('show');
      },
      success: function (data) {
        var res = (data)
        console.log(res);
        console.log(data.length);
        $('.pop_message_load').html('');
        $("#alarms_tb").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "ordering": false,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          dom: 'Blfrtip',
          "columns": [
            // {"data": "check"},
            {"data": "alarm_id"},
            {"data": "name"},
            {"data": "status"}
          ],
        });
      }
    })
  });

  $('#view_all_assets_btn').click(function (){
    var table = $('#view_all_assets_tb').DataTable();
    table.destroy();
    $.ajax({
      url: baseurl + 'Nicplace/get_all_asset_db',
      type: 'GET',
      dataType: 'json',
      beforeSend: function () {
        $('#view_all_assets_tb_body').html('');
        $('.pop_message_load').html('Please wait..!');
        $("#view_all_assets_model").modal('show');
      },
      success: function (data) {
        var res = (data)
        console.log(res);
        console.log(data.length);
        $('.pop_message_load').html('');
        $("#view_all_assets_tb").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "ordering": false,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          dom: 'Blfrtip',
          "columns": [
            // {"data": "check"},
            {"data": "asset_id"},
            {"data": "name"},
            {"data": "service_provider_id"},
            {"data": "ActiveStatus"},
          ],
        });
      }
    })
  });

  $('#view_all_alarms_btn').click(function (){
    var table = $('#view_all_alarms_tb').DataTable();
    table.destroy();
    $.ajax({
      url: baseurl + 'Nicplace/get_all_alarms_db',
      type: 'GET',
      dataType: 'json',
      beforeSend: function () {
        $('#view_all_alarms_tb_body').html('');
        $('.pop_message_load').html('Please wait..!');
        $("#view_all_alarms_model").modal('show');
      },
      success: function (data) {
        var res = (data)
        console.log(res);
        console.log(data.length);
        $('.pop_message_load').html('');
        $("#view_all_alarms_tb").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "ordering": false,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          dom: 'Blfrtip',
          "columns": [
            // {"data": "check"},
            {"data": "alarm_id"},
            {"data": "name"},
            {"data": "forTrailer"},
            {"data": "forTruck"},
            {"data": "ActiveStatus"},
          ],
        });
      }
    })
  });

  $('#sync_assets_alarms_btn').click(function (){
    var syncIcon = $(this).find('.syncIcon');
    syncIcon.addClass('spin');
    $.ajax({
      url: baseurl + 'Nicplace/sync_assets',
      type: 'GET',
      beforeSend: function () {
        $('#toast-message').html('');
        $('#snackbar').removeClass('show-toast')
        $('.pop_message_load').html('Please wait..!');
      },
      success: function (data) {
        var res = (data)
        console.log(res);
        syncIcon.removeClass('spin');
        $('#toast-message').html(res);
        $('#snackbar').addClass('show-toast')
        setTimeout(function () {
          $('#snackbar').removeClass('show-toast')
        }, 10000)
      }
    })
  });

  $(document).on('change', '.alarmStatusChange', function () {
      const selectedElement = $(this)
      var alarm_id = selectedElement.data('alarm_id')
      var setFor = selectedElement.data('set_for')
      var selectedValue = selectedElement.val();
      $.ajax({
          url: baseurl + 'Nicplace/updateAlarm/' + alarm_id + '/' + setFor + '/' + selectedValue,
          type: 'POST',
          beforeSend: function () {
              $('#toast-message').html('');
              $('#snackbar').removeClass('show-toast')
              $('.pop_message_load').html('Please wait..! <i class="fa fa-sync-alt syncIcon spin font-14"></i>');
          },
          success: function (responseData) {
              $('#toast-message').html(responseData);
              $('.pop_message_load').html('&nbsp;');
              $('#snackbar').addClass('show-toast')
              setTimeout(function () {
                  $('#snackbar').removeClass('show-toast')
              }, 3000)
          }
      })
  });
</script>
