<?php
require('fpdf.php');

class PDF extends FPDF
{
    // Page header
    function Header()
    {
        // Logo
        $this->Image('logo.png',10,6,30);
        $this->SetFont('Arial','B',12);
        $this->Cell(0,10,'GOODS CONSIGNMENT NOTE',0,1,'C');
        $this->Ln(10);
    }

    // Page footer
    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

    // Custom function to add content
    function AddContent($data)
    {
        $this->SetFont('Arial','',10);
        foreach ($data as $key => $value) {
            $this->Cell(0,10,$key.': '.$value,0,1);
        }
    }
}

// Data to be added to the PDF
$data = array(
    'Consignment Note No.' => '7116',
    'Origin' => 'Mumbai',
    'Destination' => 'Ghaziabad',
    'Date of Booking' => '04-04-25',
    'Consignee Name and Delivery Address' => 'BHARTI AIRTEL LTD, Ghaziabad',
    'Consignor Name and Pick-up Address' => 'ERICSSON INDIA PVT LTD, Pune',
    'Mode of Dispatch' => 'Road',
    'Mode of Payment' => 'Prepaid',
    'Gross Weight (Kgs.)' => '1000',
    'Volumetric Weight (Kgs.)' => '1200',
    'No. of Packages' => '8',
    'Invoice Number' => 'PNA125000040',
    'Invoice Amount' => '3193817.61',
    'E-Way Bill No.' => '1234567890'
);

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->AddContent($data);
$pdf->Output();
?>
