<?php
require_once APPPATH . 'libraries/OrderCreationSourceHelper.php';
use App\Libraries\OrderCreationSourceHelper;

$this->load->library('AtsService');
$atsservice = new AtsService();
$this->load->view($atsservice->get_ats_service());
$this->load->helper('required_marker');
$postData = $postData ?? [];
$rateServiceRowIdForBook = $postData['rateServiceRowIdForBook'] ?? 0;
$pickup_details = [];
if (!empty($postData)):
    $customerFromProfile = $postData['customerIdForBook'] ?? 0;
    $vendorFromProfile = $postData['vendorIdForBook'] ?? 0;
    if ($customerFromProfile > 0):
        $pickup_details['name'] = $postData['customerNameForBook'] ?? "";
        $pickup_details['party_id'] = $postData['customerCodeForBook'] ?? "";
        $customerCity = $postData['customerCityForBook'] ?? "";
        $customerState = $postData['customerStateForBook'] ?? "";
        $customerStreet = $postData['customerStreetForBook'] ?? "";
        $pickup_details['address'] = $customerStreet . "," . $customerCity . "," . $customerState;
        $pickup_details['country'] = $postData['customerCountryForBook'] ?? "";
        $pickup_details['pincode'] = $postData['customerPincodeForBook'] ?? "";
        $customerIdFromProfile = $postData['customerIdForBook'] ?? 0;
    endif;
    if ($vendorFromProfile > 0):
        $vendorIdFromProfile = $postData['vendorIdForBook'] ?? 0;
        $vendorCodeFromProfile = $postData['vendorCodeForBook'] ?? "";
    endif;
endif;
?>

<?php
if ($this->session->userdata('company_code') == 'NZKN') { ?>
    <style>
        .modal {
            z-index: 1001 !important;
        }

        .modal-backdrop {
            z-index: 1000 !important;
        }

        .pac-container {
            z-index: 1055 !important;
            width: auto !important;
        }

        .pac-container:after {
            /* Disclaimer: not needed to show 'powered by Google' if also a Google Map is shown */

            background-image: none !important;
            height: 0px;
        }

.modal-open .modal.insert_success_div#insert_success_div{
    z-index: 9999 !important;
}
</style>
 
   <?php } ?>
   
<link  href="<?= base_url(); ?>assets/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
   <?php if($this->session->userdata('company_code') == 'CNKN') { ?>
<style>
div.dataTables_wrapper div.dataTables_info{padding-top:8px;margin-right: 85px !important;white-space:nowrap}
.paginate_button.next {
    display: none !important;
}
.paginate_button {
    margin-right: 7px  !important;
}

.paginate_button.previous {
    display: none !important;
}
</style>
<?php } else { ?>
<style>
div.dataTables_wrapper div.dataTables_info{padding-top:8px;white-space:nowrap}
.paginate_button.next {
   display: inline-block !important;
}
.paginate_button.previous {
    display: inline-block !important;
}
</style>
<?php } ?>
<style>

    .blurModal {

        z-index: 10 !important; 

    } 

</style>
<link href="<?= base_url() ?>assets/newtheme/css/appdev-style.css" rel="stylesheet" type="text/css" />
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <?php
        if($this->session->flashdata('success_msg'))
        {
            echo "<div class='flashmessages alert alert-success'>".$this->session->flashdata('success_msg')."</div>";
        }
        if($this->session->flashdata('error_msg'))
        {
            echo "<div class='flashmessages alert alert-danger'>".$this->session->flashdata('error_msg')."</div>";
        }
        if($this->session->flashdata('edierror_msg')) {
            echo ' <div class="alert alert-danger alert-dismissable"> <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.$this->session->flashdata('edierror_msg').'</div>';
            unset($_SESSION['edierror_msg']);
        }
        unset($_SESSION['success_msg']);
        unset($_SESSION['error_msg']);
        ?>
        <div class="container">
            <div class="row">
                <?php
                $transport = gettransportmode();

                $cust_id = "0";
                if($this->session->userdata('cust_id')){
                    $cust_id = $this->session->userdata('cust_id');
                    if($cust_id == ""){
                        $cust_id = "0";
                    }
                }
                $company_code = $this->session->userdata('company_code');
                $ordertypes = getOrderTypes($cust_id,$company_code);
                
                ?>
                <!-- fillter section -->





            <div class="filtersHeader">

                <div class="filter-section pull-left ">
                    <div class="filter_icons borderRight">
            <!--  data-toggle="modal" data-target="#addOrderModal"  -->
                        <?php if(strtoupper($this->session->userdata('branch_code')) != HIDE_BRANCH_ADD) { ?>
                        <a href="<?php echo base_url(); ?>orders/neworder"  data-toggle="modal" data-target="#editOrderModal"  >
                            <span data-toggle="tooltip" data-placement="bottom" title="Add Booking" class="iconSvk icon-add-icon"></span>
                        </a>            
                        <?php } ?>

                           <!-- <a href="" >
                            <span data-toggle="tooltip" data-placement="bottom" title="View Booking" class="iconSvk icon-view-icon"></span>
                        </a>
                        
                        <a href="">
                            <span data-toggle="tooltip" data-placement="bottom" title="Edit Booking" class="iconSvk icon-edit-icon"></span>
                            </a>

                        <a href="">
                            <span data-toggle="tooltip" data-placement="bottom" title="Delete Booking" class="iconSvk icon-delete-icon"></span>
                    </a>-->
                    </div>
                </div>

                <div class="filter-section pull-left">
                            <div class="filter_icons">
                                <div class="navbar pull-right">
                                    <a id="adv_filter" href="#" data-action="open" data-side="right" class="adv_filter">
                                    <span data-toggle="tooltip" data-placement="bottom" title="Filter" class="iconSvk icon-filter-icon"></span>
                                    </a>
                                    <div class="dropdown bcdropdown">
                                        <button class="dropbtn"><span class="iconSvk icon-list-icon"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <?php if(strtoupper($this->session->userdata('branch_code')) != HIDE_BRANCH_ADD) { ?>
                                            <!--<a href="<?php echo base_url(); ?>orders/neworder" data-toggle="modal" data-target="#addOrderModal" ><i class="icon tru-icon-add"></i><?= $this->lang->line('new_order') ?></a>-->
                                            <?php } ?>
                                            <a href="<?php echo base_url(); ?>orders/addQuickBook" id="quickBookId" data-toggle="modal" data-target="#addQuickBookModal"><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('quickbook') ?></a>
                                            <a href="<?php echo base_url(); ?>orders/addIndent" data-toggle="modal" data-target="#addIndentModal" >
                                                <i class="icon tru-icon-quickbook"></i><?= $this->lang->line('indent') ?>
                                            </a>
                                            <?php   $base_url = base_url();
                                            $company_code = $this->session->userdata('company_code');
                                            $country_code="";
                                            if($company_code=="KNAU"){
                                                $country_code=$company_code;
                                            }else{
                                                $country_code=substr($company_code, 0, 2);
                                            }
                                            $imglink = $base_url."assets/ordertemplate/ordertemplate.xlsx";
                                            $file = $base_url."assets/ordertemplate/".$country_code."-ordertemplate.xlsx";

                                            if(file_exists("assets/ordertemplate/".$country_code."-ordertemplate.xlsx")){
                                                $imglink =$file;
                                            }
                                            ?>
                                            <input type="hidden" name="chkcompanycode" id="chkcompanycode" value="<?= strtoupper($this->session->userdata('company_code')) ?>">
                                            <input type="hidden" name="chkbranchcode" id="chkbranchcode" value="<?= strtoupper($this->session->userdata('branch_code')) ?>">
                                            <a href="<?= $imglink ?>"><i class="icon tru-icon-template"></i><?= $this->lang->line('order_template') ?></a>
                                            <a href="#" id='buttonid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('upload_excel') ?></a>
                                            <!-- <a href="#"><i class="icon tru-icon-graph"></i><?= $this->lang->line('order_financial') ?></a> -->
                                            <form action="<?= base_url() ?>Excelimportorders/orderbooking"  id="excelform" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="import_file"  id="exlfile" style="display:none" >
                                            </form>
                                            <form action="<?= base_url() ?>Indorderexcelimport/orderExcelUpload"  id="excelform" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="import_file"  id="indexlfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                            </form>
                                            
                                            <form
                                                action="<?= base_url() ?>Macpacexcelimport/orderbooking"
                                                id="excelform" method="POST" enctype="multipart/form-data">
                                                <input type="file" name="import_file" id="indexaufile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <?php
                                            if (in_array($this->session->userdata('company_code'), ['THCL', 'THKN', 'RUKN'])): ?>
                                                <a href="<?= base_url() ?>assets/ordertemplate/CL-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('cl_template') ?></a>
                                                <a href="#"
                                                   id='buttonclid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upload_cl') ?></a>
                                                <form
                                                    action="<?= base_url() ?>Excelimportclorders/cladddata"
                                                    id="exlclfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlclupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                            <?php
                                            endif; ?>
                                            <?php
                                            $userCompanyCode = $this->session->userdata('company_code');
                                            if ($userCompanyCode == "PHKN") : ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/eTN_Milkrun_tmpl.xlsx"><i
                                                        class="icon tru-icon-template"></i>eTN_Milkrun_tmpl</a>
                                                <a href="#" id='buttonsgid'><i class="icon tru-icon-excel"></i>Upload eTN_Milkrun_tmpl</a>
                                                <form action="<?= base_url() ?>Excelimportclorders/uploadmilkrunexcel" id="exlsgfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlsgupfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none">
                                                </form>
                                            <?php
                                            endif; ?>
                                            <?php if($this->session->userdata('company_code') == 'INKN') { ?>
                                                <a href="#" id='buttoninid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('kninbkg_upld') ?></a>
                                                <form action="<?= base_url() ?>Ordertripexcel/uploadinexcel"  id="exlsgfile" method="POST" enctype="multipart/form-data" >
                                                    <input type="file"  name="import_file" id="exlinupfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                                </form>
                                            <?php  } 
                                            if ($this->session->userdata('company_code') == 'INFD'): ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/ManualPlanning-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('mdt_template'); ?></a>
                                                <a href="#"
                                                   id='buttonsgid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upd_mdt'); ?></a>
                                                <form
                                                    action="<?= base_url(); ?>Excelimportorders/uploadsgexcel"
                                                    id="exlsgfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlsgupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                             
                                            <?php
                                            endif; ?>
                                            <a href="#" onclick="importFromGSheets();"><i class="icon tru-icon-excel"></i> <?= $this->lang->line('import_gsheets') ?></a>
                                            <a href="#" onclick="generateBulkLabel(event);"><i class="icon tru-icon-pdf"></i> <?= $this->lang->line('generate_bulk_label'); ?></a>
                                            <a href="#" onclick="newtripcreate(event);"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('trip_create') ?></a>
                                            <?php // if($this->session->userdata('company_code') == 'INKN' || $this->session->userdata('company_code') == 'AUKN') { ?>
                                            <a href="#" onclick="newtripcreate(event,'multi');"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('trip_create_bulk') ?></a>
                                            <?php // } ?>
                                            <!--<a href="#" onclick="sendorderdetailsclick(event);"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('roadlog') ?></a>-->
                                            <!-- <a href="#" onclick="generateaconedi(event);"><i class="glyphicon glyphicon-plus"></i>  Send To KNBilling</a> -->
                                            <!-- <a href="#" onclick="checkdebitorandacon(event);"><i class="glyphicon glyphicon-plus"></i>  Send To KNBilling</a> -->

                                            <a href="#" onclick="shipmentxmlclick(event)"><i class="glyphicon glyphicon-hand-up"></i> <?= $this->lang->line('kn_login') ?></a>
                                            <a href="#" onclick="sendShipmentStatusxml(event)"><i class="fa fa-hourglass-start" aria-hidden="true"></i> <?= $this->lang->line('leftmenu_status') . " " . $this->lang->line('to') . " " . $this->lang->line('kn_login') ?></a>
                                            <a href="<?= base_url('bulkupload') ?>" data-toggle="modal" data-target="#uploadModal" ><i class="icon tru-icon-excel"></i><?= $this->lang->line('general_bulkupload') ?></a>
                                            <?php if($company_code == 'AUKN' ||$company_code == "KNAU"){ ?>
                                                <a href="#" onclick="manifestwithtrip(event);"><i class="icon tru-icon-pdf"></i>  <?= $this->lang->line('generate_manifest') ?></a>
                                            <?php } ?>
                                            <a href="<?= base_url() ?>assets/cargo_update.xlsx"><i class="icon tru-icon-template"></i><?= $this->lang->line('cargo_update_template'); ?></a>
                                            <a href="<?= base_url('orderlistspecification') ?>"><i
                                                    class="glyphicon glyphicon-hand-up"></i><?= $this->lang->line('order_list_spec') ?></a>
                                            <a href="#" id='buttoncargoid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('cargo_update') ?></a>
                                            <form action="<?= base_url() ?>Ordercargoupdateexcel/getexceldata"  id="exlcargofile" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="exlcargoupfile" id="exlcargoupfile" style="display:none" >
                                            </form>
                                            <?php if($this->session->userdata('company_code') == 'AUKN' && $this->session->userdata('user_role_id') == '1'){ ?>
                                                <a href="#" onclick="updatebulkcargo(event);"><span class="icon tru-icon-edit" aria-hidden="true"></span>&nbsp;<?= $this->lang->line('edit_cargo_details') ?></a>
                                            <?php } ?>
                                                 
                                            <?php if($this->session->userdata('company_code') == "NZKN"){ ?>
                                                <a href="#"
                                               onclick="showNzCarriersPop();"><i
                                                    class="icon tru-icon-pdf"></i>  <?= $this->lang->line('download_manifestdoc') ?></a>
                                            <?php } ?>
                                            
                                            <a href="#"  class="icon tru-icon-delete" onclick="deleteselectedrecords()"> <?= $this->lang->line('delete_records'); ?></a>
                                        </div>
                                    </div>
                                    <div class="dropdown bcdropdown">
                                        <button class="dropbtn">
                                            <!-- <span class="fa fa-money"></span> -->
                                            <span class="iconSvk icon-invoice-icon"></span>
                                        </button>
                                         <div class="dropdown-content">
                                             <a href="<?= base_url() ?>assets/Rateupload.xlsx">
                                                <i class="icon tru-icon-template"></i>
                                                    <?= $this->lang->line('charges_template') ?></a>
                                            <a href="#" id='buttoncostid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('import_charges') ?></a>
                                            <form
                                                action="<?= base_url() ?>Excelimportorders/ordercost"
                                                id="excelcostform" method="POST"
                                                enctype="multipart/form-data">
                                                <input type="file" name="import_costfile" id="exlcostfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <?php if ($bill_type == "Knbill") { ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceknbill(event);"><i
                                                        class="glyphicon glyphicon-plus"></i> <?= $this->lang->line('send_to_knbilling'); ?></a>
                                                <?php } else { ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceforselected(event);"><i
                                                        class="icon tru-icon-tender-list"></i> <?= $this->lang->line('ready_to_invoice'); ?></a>
                                                    <a href="#"
                                                   onclick="filetrasnferfor_selectedorders(event);"><i
                                                        class="icon tru-icon-tender-list"></i><?= $this->lang->line('send_file_to_account'); ?></a>
                                                <?php } ?>
                                                <a href="#" data-toggle="modal" data-target="#consolidation_modal"><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('menu_consolidation') ?></a>
                                                <a href="#" onclick="getdistributiondata(event);" ><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('charges_distribution') ?></a>
                                            </div>
                                    </div>
                                    <?php // include('tripcreat.php') ?>
                                    <div class="dropdown bcdropdown excelDrop">
                                        <button class="dropbtn">
                                        <span class="iconSvk icon-download-icon"></span>

                                            </span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('excel')"><i class="icon tru-icon-excel"></i><?= $this->lang->line('general_excel') ?></a>
                                            <!--<a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('pdf')"><i class="icon tru-icon-pdf"></i><?= $this->lang->line('general_pdf') ?></a>-->
                                            <a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('print')"><i class="icon tru-icon-print"></i><?= $this->lang->line('general_print') ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- ADD Indent modal -->
                    <div class="modal fade modalStyleSvk" id="addIndentModal" tabindex="-1" aria-labelledby="addIndentModalLabel" aria-hidden="true" data-backdrop="static">
                      <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                          
                        </div>
                      </div>
                    </div>
                    <!-- ADD Indent modal -->
                    
                    <!-- ADD QuickBook modal -->
                    <div class="modal fade modalStyleSvk" id="addQuickBookModal" tabindex="-1" aria-labelledby="addQuickBookModalLabel" aria-hidden="true" data-backdrop="static">
                      <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                          
                        </div>
                      </div>
                    </div>
                    <!-- ADD QuickBook modal -->
                    
                    <div class="modal fade" id="deleteConfirmModal" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmLabel" aria-hidden="true">
                      <div class="modal-dialog" role="document">
                        <div class="modal-content">
                          <div class="modal-header">
                            
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            Are you sure you want to delete this order?
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                            <button type="button" class="btn btn-danger" id="confirmDeleteBtn"><?= $this->lang->line('general_delete'); ?></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    
                    <div class="modal fade modalStyleSvk" id="uploadModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true" data-backdrop="static">
                        <div class="modal-dialog modal-xl">
                           <div class="modal-content">
                           
                            </div>
                        </div>
                    </div>
                    
                    <!-------Advanced Search-------->
                    <div class="sidebars sideBarStyle" id="sidebars_search" style="display:none">
                        <div class="advance_searchcol sidebar right" id="sidebar_search">
                            <div class="title_header">
                            <h2> <span class="iconSvk icon-filter-icon"></span> <?= $this->lang->line('menu_orders') ?></h2>
                                <!-- <h2><?= $this->lang->line('order_list') ?></h2>
                                <h3><?= $this->lang->line('general_advancesrch') ?></h3> -->
                                <a href="javascript:void(0)" class="closebtn" data-action="close" data-side="right">&times;</a>
                            </div>
                            <?php $products = getProductMasterData();
                            $service = getServiceMasterData(); ?>
                            <form method="GET" action="<?= base_url() ?>orders" onsubmit="return checkreference(this);" id="advsearch_orders">
                                <div class="custom-scroll">
                                    <input type="hidden" name="search_type" value="advanced" />
                                
                                     <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advfrom_date'] ?? ''; ?>
                                                <label for="advfrom_date"><?= $this->lang->line('general_from_date') ?></label>
                                                <input type="text" name="advfrom_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_from_date') ?>" class="form-control fromdate" id="advfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advto_date'] ?? ''; ?>
                                                <label for="advto_date"><?= $this->lang->line('general_to_date') ?></label>
                                                <input type="text" name="advto_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_to_date') ?>" class="form-control todate" id="advto_date" value="<?= $selectto_date?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
                                    
                                <div class='row'>
                                <?php if($company_code=="AUKN" || $company_code=="KNAU"){
                                        ?>
                                         <div class="col-sm-6">
                                            <?php $selectbooking_id = $_GET['order_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_id"><?= $this->lang->line('booking_id') ?> </label>
                                                <input type="text" name="order_id" parsley-trigger="change" placeholder="<?= $this->lang->line('booking_id') ?>" class="form-control" id="order_id" form="advsearch_orders" value="<?= $selectbooking_id ?>">
                                            </div>
                                        </div>
                                        <?php
                                    }else{
                                        ?>
                                    <div class="col-sm-6">
                                        <?php $wildcard_order_id = $_GET['wildcard_order_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="wildcard_order_id"><?= $this->lang->line('booking_id') ?>-Wildcard Search </label>
                                                <input type="text" name="wildcard_order_id" parsley-trigger="change" placeholder="Search with %" class="form-control" onkeypress="return checkwildcardsearch(event);" id="wildcard_order_id" form="advsearch_orders" value="<?= $wildcard_order_id ?>" autocomplete="off">
                                            </div>
                                        </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                        <label for="order_id"><?= $this->lang->line('booking_id') ?>
                                       <?php $bookingid = $_GET['bookingid'] ?? [];
                                        if(empty($bookingid)){
                                            $bookingid = $getbookingid ?? [];
                                        }
                                        ?>
                                        
                                        <input type="hidden" name="ats_parties" id="ats_parties" value='<?php
                                        if (!empty($ats_parties)) {
                                            echo $ats_parties;
                                        }
                                        ?>'>
                                        
                                            <select form="advsearch_orders" name="bookingid[]" id="bookingid" class="form-control searchbookingids" multiple="multiple">
                                                <?php foreach($bookingid as $res) :
                                                        $sel = "selected";
                                                        echo "<option value='".$res."'$sel>".$res."</option>";
                                                    endforeach; ?>
                                            </select>
                                        </div>
                                        </div>
                                        <?php
                                    }
                                        ?>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php $order_reftype = $_GET['order_reftype'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_reftype"><?= $this->lang->line('bpartner_reftype') ?></label>
                                                <select class="form-control" name="order_reftype" id="order_reftype" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($ref_names_arr)) {
                                                        foreach($ref_names_arr as $res) { ?>
                                                            <option value="<?= $res['name'] ?>" <?php if($order_reftype == $res['name']){ echo "selected";} ?>><?= $res['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
									    <div class="col-sm-6">
                                            <?php $ref_val = $_GET['ref_val'] ?? ''; ?> 
                                            <div class="form-group">
                                                <label for="ref_val"><?= $this->lang->line('referencevalue') ?></label>
                                                <input type="text" name="ref_val" parsley-trigger="change" placeholder="<?= $this->lang->line('referencevalue') ?>" class="form-control" id="ref_val" form="advsearch_orders" value="<?= $ref_val ?>">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                       <div class="col-sm-6">
                                            <!--<?php $selectorder_status = $_GET['order_status'] ?? ''; ?>-->
                                            <?php
                                            $orderstatus = getOrderStatus();
                                            $selectorder_status = (isset($_GET['order_status'])) ? $_GET['order_status'] : '' ?><div class="form-group">
                                                <label for="order_status"><?= $this->lang->line('bpartner_ordstatus') ?></label>
                                                <!--  <input type="text" name="order_status" parsley-trigger="change" placeholder="<?= $this->lang->line('bpartner_ordstatus') ?>" class="form-control" id="order_status" form="advsearch_orders" value="<?= $selectorder_status ?>"> -->
                                                
                                                <select class="form-control" name="order_status"
                                                    id="order_status" form="advsearch_orders" name="status">
                                                    <option value="*">All</option>
                                                    <?php

                                                    if (! empty($orderstatus)) {
                                                    foreach ($orderstatus as $res) {
                                                    ?>
                                                    <option value="<?= $res ?>"
                                                    <?php if(strtoupper($selectorder_status) == $res) { echo "selected"; } ?>><?= $res ?></option>
                                                    <?php }  if($company_code == 'AUKN'){ ?>
                                                    <option value="SCANNED"   <?php if(strtoupper($selectorder_status) == "SCANNED") { echo "selected"; } ?>><?= "SCANNED" ?></option>
                                                    <?php
                                                    }
                                                    if($company_code == 'AUKN'|| $company_code == 'KNAU'){
                                                    ?>
                                                    <option value="MANIFESTED" <?php if(strtoupper($selectorder_status) == "MANIFESTED") { echo "selected"; } ?>><?= "MANIFESTED" ?></option>

                                                    <?php
                                                    }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
									    <?php if ($this->session->userdata('company_code') == "AUKN"): ?>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <?php $selectload_plan_connote = $_GET['load_plan_connote'] ?? ''; ?>
                                                    <label for="load_plan_connote"><?= $this->lang->line('load_plan_connote') ?></label>
                                                    <input type="text" name="load_plan_connote" parsley-trigger="change" placeholder="<?= $this->lang->line('load_plan_connote') ?>" class="form-control" id="load_plan_connote" form="advsearch_orders" value="<?= $selectload_plan_connote ?>">
                                                </div>
                                            </div>
                                       <?php else : ?>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <?php $selecttrip_id = $_GET['trip_id'] ?? ''; ?>
                                                    <label for="trip_id"><?= $this->lang->line('trip_id') ?></label>
                                                    <input type="text" name="trip_id" parsley-trigger="change" placeholder="<?= $this->lang->line('trip_id') ?>" class="form-control" id="trip_id" value="<?= $selecttrip_id ?>">
                                                </div>
                                            </div>
                                         <?php endif; ?>
                                    </div>
                                    <div class="panel-group" id="accordionMassFilter" role="tablist" aria-multiselectable="true">
                                                        <div class="panel panel-default">
                                                            <div class="panel-heading active" role="tab" id="headingMassFilter">
                                                                <h4 class="panel-title">
                                                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordionMassFilter" href="#massFilter"  aria-expanded="false" aria-controls="massFilter">
                                                                        <i class="more-less fa fa-angle-right"></i>
                                                                        <span class="iconSvk icon-filter-icon"></span>
                                                                       Advanced Filter
                                                                    </a>
                                                                </h4>
                                                            </div>
                                                            <div id="massFilter" class="panel-collapse collapse" role="tabpanel"  aria-labelledby="headingMassFilter">

                                                                    <div class="panel-body p-10">
                                    
                                    <div class="row">

                                        <div class="col-sm-6">
                                            <?php $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php $charge_list_type = isset($charge_list_type) ? $charge_list_type : ''; ?>
                                            <input type="hidden" name="list_type" id="list_type" value="<?= $list_type ?>">
                                            <input type="hidden" name="charge_list_type" id="charge_list_type" value="<?= $charge_list_type ?>">
                                             
                                            <?php $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <input type="hidden" name="cllist_type" id="cllist_type" value="<?= $cllist_type ?>">
                                             
                                            <?php $knlogin_list_type = $knlogin_list_type ?? 0; ?>
                                            <input type="hidden" name="knlogin_list_type" id="knlogin_list_type" value="<?= $knlogin_list_type ?>">
                                            <?php $selectcustomer_id = $_GET['searchcustomer_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_id"><?= $this->lang->line('customer_id') ?> </label>
                                                <input type="text" name="searchcustomer_id" parsley-trigger="change" placeholder="<?= $this->lang->line('customer_id') ?>" class="form-control" id="searchcustomer_id" form="advsearch_orders" value="<?= $selectcustomer_id ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <input type="hidden" name="list_type" id="list_type" value="<?= $list_type ?>">
                                            <input type="hidden" name="cllist_type" id="cllist_type" value="<?= $cllist_type;  ?>">
                                            <?php $selectcustomer_name = isset($_GET['searchcustomer_name']) ? $_GET['searchcustomer_name'] : ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_name"><?= $this->lang->line('customer_name') ?> </label>
                                                <input type="text" name="searchcustomer_name" parsley-trigger="change" placeholder="<?= $this->lang->line('customer_name') ?>" class="form-control" id="searchcustomer_name" form="advsearch_orders" value="<?= $selectcustomer_name ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php $selectservice = $_GET['service'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="service"><?= $this->lang->line('bpartner_service') ?></label>
                                                <select class="form-control" name="service" id="service" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($service)) {
                                                        foreach($service as $res) { ?>
                                                            <option value="<?= $res['row_id'] ?>" <?php if($selectservice == $res['row_id']){ echo "selected";} ?>><?= $res['id']."-".$res['name']; ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                         <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectcarrier = $_GET['advcarrier'] ?? '';  ?>
                                                <label for="carrier"><?= $this->lang->line('carrier') ?></label>
                                                <input type="text" name="carrier" parsley-trigger="change" placeholder="<?= $this->lang->line('carrier') ?>" class="form-control" id="carrier" value="<?= $selectcarrier ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php $selectorder_type = $_GET['order_type'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_type"><?= $this->lang->line('bpartner_ordtype') ?></label>
                                                <select class="form-control" name="order_type" id="order_type" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($ordertypes)) {
                                                        foreach($ordertypes as $types){
                                                            if($types['type_name'] != ""){
                                                                ?>
                                                                <option value="<?= $types['type_id'] ?>" <?php if($selectorder_type == $types['type_id']){ echo "selected";} ?>><?= $types['type_name'] ?></option>
                                                            <?php } } } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectproduct = $_GET['product'] ?? ''; ?>
                                                <label for="product"><?= $this->lang->line('bpartner_product') ?></label>
                                                <select name="product" class="form-control" id="product" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($products)){
                                                        foreach($products as $res){
                                                            ?>
                                                            <option value="<?= $res['name'] ?>" <?php if($selectproduct == $res['name']){ echo "selected";} ?>><?= $res['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selecttrasnport = $_GET['modeof_trasnport'] ?? ''; ?>
                                                <label for="modeof_trasnport"><?= $this->lang->line('bpartner_motransport');  ?></label>
                                                <select name="modeof_trasnport" class="form-control" id="modeof_trasnport" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($transport)){
                                                        foreach($transport as $mode) { ?>
                                                            <option value="<?= $mode['code'] ?>" <?php if($selecttrasnport == $mode['code']){ echo "selected";} ?>><?= $mode['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectshipper_id = $_GET['searchshipper_id'] ?? ''; ?>
                                                <label for="searchshipper_id"><?= $this->lang->line('qbook_shipperid') ?></label>
                                                <input type="text" name="searchshipper_id" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_shipperid') ?>" class="form-control" id="searchshipper_id" form="advsearch_orders" value="<?= $selectshipper_id ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <?php $selectshipper_name = isset($_GET['searchshipper_name']) ? $_GET['searchshipper_name'] : ''; ?>
                                            <label for="searchshipper_id"><?= $this->lang->line('shipper_name') ?></label>
                                            <input type="text" name="searchshipper_name" parsley-trigger="change" placeholder="<?= $this->lang->line('shipper_name') ?>" class="form-control" id="searchshipper_name" form="advsearch_orders" value="<?= $selectshipper_name ?>">
                                        </div>
                                    </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectconsignee_id = isset($_GET['searchconsignee_id']) ? $_GET['searchconsignee_id'] : ''; ?>
                                                <label for="consignee_id"><?= $this->lang->line('qbook_consigneeid') ?></label>
                                                <input type="text" name="searchconsignee_id" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_consigneeid') ?>" class="form-control" id="searchconsignee_id" form="advsearch_orders" value="<?= $selectconsignee_id ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectconsignee_name = isset($_GET['searchconsignee_name']) ? $_GET['searchconsignee_name'] : ''; ?>
                                                <label for="consignee_name"><?= $this->lang->line('consignee_name') ?></label>
                                                <input type="text" name="searchconsignee_name" parsley-trigger="change" placeholder="<?= $this->lang->line('consignee_name') ?>" class="form-control" id="searchconsignee_name" form="advsearch_orders" value="<?= $selectconsignee_name ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectdelivery_note = isset($_GET['delivery_note']) ? $_GET['delivery_note'] : ''; ?>
                                                <label for="delivery_note"><?= $this->lang->line('qbook_deliverynote') ?></label>
                                                <input type="text" name="delivery_note" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_deliverynote') ?>" class="form-control" id="delivery_note" form="advsearch_orders" value="<?= $selectdelivery_note?>">
                                            </div>
                                        </div>
                                    </div>
                                    <!--<div class="row">
									<div class="col-sm-6">
                                            <div class="form-group">
			                                    <?php
			                                    $salog_ref = $_GET['salog_ref'] ?? ''; ?>
                                                <label for="salog_ref"><?= $this->lang->line(
					                                    'salog_ref'
				                                    ) ?></label>
                                                <input type="text" name="salog_ref" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('salog_ref') ?>"
                                                       class="form-control" id="salog_ref" form="advsearch_orders"
                                                       value="<?= $salog_ref ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectpurchase_order = $_GET['purchase_order'] ?? ''; ?>
                                                <label for="purchase_order"><?= $this->lang->line('qbook_purchaseorder') ?></label>
                                                <input type="text" name="purchase_order" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_purchaseorder') ?>" class="form-control" id="purchase_order" form="advsearch_orders" value="<?= $selectpurchase_order?>">
                                            </div>
                                        </div>
                                    </div>-->
                                    <?php if ($this->session->userdata('company_code') == "AUKN"): ?>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <?php $selecttrip_id = $_GET['trip_id'] ?? ''; ?>
                                                    <label for="trip_id"><?= $this->lang->line('trip_id') ?></label>
                                                    <input type="text" name="trip_id" parsley-trigger="change" placeholder="<?= $this->lang->line('trip_id') ?>" class="form-control" id="trip_id" value="<?= $selecttrip_id ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-6"></div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="row">
									
                                       <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectcompany_code = $_GET['company_code'] ?? '';  ?>
                                                <label for="company_code"><?= $this->lang->line('general_company_code') ?></label>
                                                <input type="text" name="company_code" parsley-trigger="change" placeholder="<?= $this->lang->line('general_company_code') ?>" class="form-control" id="company_code" value="<?= $selectcompany_code ?>">
                                            </div>
                                        </div>
                                         <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectbranch_code = $_GET['branch_code'] ?? ''; ?>
                                                <label for="branch_code"><?= $this->lang->line('general_branch_code') ?></label>
                                                <input type="text" name="branch_code" parsley-trigger="change" placeholder="<?= $this->lang->line('general_branch_code') ?>" class="form-control" id="branch_code" value="<?= $selectbranch_code ?>">
                                            </div>
                                        </div>

                                    </div>

                                    
                                    <div class="row">
									   
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advdeliveryfrom_date'] ?? ''; ?>
                                                <label for="advdeliveryfrom_date"> <?= $this->lang->line('delivery_from_date'); ?></label>
                                                <input type="text" name="advdeliveryfrom_date" parsley-trigger="change" placeholder="<?= $this->lang->line('delivery_from_date'); ?>" class="form-control fromdate" id="advdeliveryfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advdeliveryto_date'] ?? ''; ?>
                                                <label for="advdeliveryto_date"><?= $this->lang->line('delivery_to_date'); ?></label>
                                                <input type="text" name="advdeliveryto_date" parsley-trigger="change" placeholder="<?= $this->lang->line('delivery_to_date'); ?>" class="form-control todate" id="advdeliveryto_date" value="<?= $selectto_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
								
                                    <!------------pickup date range----------------------------------------->
                                    <div class="row">
                                        
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advpickupfrom_date'] ?? ''; ?>
                                                <label for="advpickupfrom_date"> <?= $this->lang->line('pickup_from_date'); ?></label>
                                                <input type="text" name="advpickupfrom_date" parsley-trigger="change" placeholder="<?= $this->lang->line('pickup_from_date'); ?>" class="form-control fromdate" id="advpickupfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advpickupto_date'] ?? ''; ?>
                                                <label for="advpickupto_date"> <?= $this->lang->line('pickup_to_date'); ?></label>
                                                <input type="text" name="advpickupto_date" parsley-trigger="change" placeholder="<?= $this->lang->line('pickup_to_date'); ?>" class="form-control todate" id="advpickupto_date" value="<?= $selectto_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
                                    <!------------Delivery date range----------------------------------------->
                                    <div class="row">
									    <!--<div class="col-sm-6">
                                            <div class="form-group">
			                                    <?php
			                                    $salog_ref = $_GET['salog_ref'] ?? ''; ?>
                                                <label for="salog_ref"><?= $this->lang->line(
					                                    'salog_ref'
				                                    ) ?></label>
                                                <input type="text" name="salog_ref" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('salog_ref') ?>"
                                                       class="form-control" id="salog_ref" form="advsearch_orders"
                                                       value="<?= $salog_ref ?>">
                                            </div>
                                        </div>-->
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectpurchase_order = $_GET['purchase_order'] ?? ''; ?>
                                                <label for="purchase_order"><?= $this->lang->line('qbook_purchaseorder') ?></label>
                                                <input type="text" name="purchase_order" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_purchaseorder') ?>" class="form-control" id="purchase_order" form="advsearch_orders" value="<?= $selectpurchase_order?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                                                                </div>
                                                            </div>
                                <div class="footer-search">

                                    <div class="top20 ">
                                        <div class="view_more text-right">
                                        <button type="Reset"  form="advsearch_orders" name="reset" class="btn btnCancel mr-2  resetbtn"><?= $this->lang->line('general_reset') ?></button>
                                            <button type="submit" name="searchsubmit" class="btn btn_color" value="Search"><?= $this->lang->line('search_orders') ?></button>
                                            

                                        </div>
                                    </div>
                                </div>
                            </form>
                            </div>
                        </div>
                    </div>
                    <!-------Advanced Search- End------->















                <!--<div class="col-xs-12">
                    <div class="filter-section mtop15 bg-white ptlbr20">
                        <div class="col-md-9 col-sm-12">
                            <div class="row">
                            
                                <form method="GET" onsubmit="return checkseachvalidation(this);" action="<?= base_url() ?>orders" id="search_orders">
                                    <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                        <div class="form-group">
                                            <?php $selecfromdate = $_GET['fromdate'] ?? ''; ?>
                                            <input type="text" class="form-control" form="search_orders" placeholder="<?= $this->lang->line('general_from_date'); ?>" name="fromdate" id="fromDate" value="<?= $selecfromdate ?>" autocomplete="off">
                                            <i class="icon tru-icon-calendar"></i>
                                        </div>

                                    </div>
                                    <div class="col-sm-2" style="width:113px;padding: 2px;">
                                        <?php $selectodate = (isset($_GET['todate'])) ? $_GET['todate'] : '' ?>
                                        <div class="form-group">
                                            <input type="text" class="form-control" form="search_orders" name="todate" id="toDate" placeholder="<?= $this->lang->line('general_to_date') ?>" value="<?= $selectodate ?>" autocomplete="off">
                                            <i class="icon tru-icon-calendar"></i>
                                        </div>
                                    </div>
                                    <?php
                                    $company_code = $this->session->userdata('company_code');
                                    $inbrnchcode = $this->session->userdata('branch_code');
                                    if (($company_code == 'AUKN') || ($company_code == 'UKKN') || ($inbrnchcode == 'INCL')) {
                                        $plshold = $this->lang->line('container_num');
                                        if($inbrnchcode == 'INCL'){
                                            $plshold = $this->lang->line('docket_number');
                                        }
                                        ?>
                                        <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                            <?php $container_no = $_GET['container_no'] ?? ''; ?>
                                            <div class="form-group">
                                                <input type="text" class="form-control" form="search_orders" name="container_no" id="container_no" placeholder="<?= $plshold ?>" value="<?= $container_no ?>" autocomplete="off">
                                            </div>
                                        </div>
                                    <?php }
                                    if ($company_code != 'AUKN' ) {
                                    ?>
                                    <div class="col-sm-2" style="width:135px;padding: 2px;">
                                    <?php $normal_wcs = $_GET['wildcard_order_id'] ?? ''; ?>
                                        <div class="form-group">
                                            <input type="text" name="wildcard_order_id" parsley-trigger="change" title="Wildcard Search for Booking Id" placeholder="Search with %" class="form-control" onkeypress="return checkwildcardsearch(event);" id="wildcard_order_id" form="search_orders" value="<?= $normal_wcs ?>" autocomplete="off">
                                        </div>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <div class="col-sm-2" style="width:146px;padding: 2px;">
                                        <?php $bookingid = $_GET['bookingid'] ?? [];
                                        if(empty($bookingid)){
                                            $bookingid = $getbookingid ?? [];
                                        }
                                        ?>
                                        
                                        <input type="hidden" name="ats_parties" id="ats_parties" value='<?php
                                        if (!empty($ats_parties)) {
                                            echo $ats_parties;
                                        }
                                        ?>'>
                                       
                                        <div class="form-group">
                                            <select form="search_orders" name="bookingid[]" id="bookingid" class="form-control searchbookingids" multiple="multiple" placeholder="<?= $this->lang->line('booking_id') ?>">
                                                <?php foreach($bookingid as $res) :
                                                        $sel = "selected";
                                                        echo "<option value='".$res."'$sel>".$res."</option>";
                                                    endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                        <?php
                                        $orderstatus = getOrderStatus();
                                        $selectstatus = (isset($_GET['status'])) ? $_GET['status'] : '' ?>
                                        <div class="form-group">
                                           
                                            <select class="form-control" id="searchstatus" name="status">
                                                <option value=""><?= $this->lang->line('general_select') ?></option>
                                                <?php

                                                if (! empty($orderstatus)) {
                                                foreach ($orderstatus as $res) {
                                                ?>
                                                <option
                                                value="<?= $res ?>"
                                                <?php if(strtoupper($selectstatus) == $res) { echo "selected"; }?>><?= $res ?></option>
                                                <?php }  if($company_code == 'AUKN'){ ?>
                                                <option value="SCANNED" <?php if(strtoupper($selectstatus) == "SCANNED") { echo "selected"; }?>><?= "SCANNED" ?></option>
                                                <?php
                                                }
                                                if($company_code == 'AUKN'|| $company_code == 'KNAU'){
                                                ?>
                                                <option value="MANIFESTED"
                                                <?php if(strtoupper($selectstatus) == "MANIFESTED") { echo "selected"; }?>
                                                ><?= "MANIFESTED" ?></option>

                                                <?php
                                                }
                                                }
                                                ?>
                                            </select>
                                         
                                        </div>
                                    </div>
                                    <div class="col-sm-2" style="width:142px;padding: 2px;">
                                        <div class="form-group">
                                            <select name="order_references[]" id="order_references" form="search_orders"  class="form-control order_references" multiple="multiple" placeholder="<?php echo $this->lang->line('reference_no'); ?>">
                                                <?php  $orderReferences = $_GET['order_references'] ?? [];
                                                foreach($orderReferences as $eachOrderReferences) :
                                                    echo "<option value='".$eachOrderReferences."' selected>".$eachOrderReferences."</option>";
                                                endforeach; ?>
                                            </select> </div>
                                    </div>
                                    <div class="col-sm-1">
                                        <button type="submit"  name="searchsubmit" id="searchsubmit" class="btn  btn-primary btn_color" value="Search"><?= $this->lang->line('general_search') ?></button>
                                    </div>
                                     
                                </form>
                            </div>
                        </div>
               
                </div>
                <!-- End fillter section 
            </div>-->
            <!-- end row -->
		
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white mb70">
                        <div class="main-datatable">

                            <div class="table-responsive minheight">
                                
                                <?= $pagination->renderPagination() ?>
                                <table data-paging="false" <?php if($company_code=='CNKN'){ ?> id="orderslistchina" <?php } else { ?> id="orderslist" <?php } ?> class="table table-striped table-bordered forcheckboxes" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th class="shoring_icon_no">
                                            <div class="checkbox checkbox-info">
                                                <label>
                                                    <input type="checkbox" class="checkAll" value="">
                                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                </label>
                                            </div>
                                        </th>
                                        <th class="shoring_icon_no"></th>

                                        <th><b><?= $this->lang->line('sno') ?></b></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('booking_id') ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><i class="fa fa-address-card"></i><?= $this->lang->line('booking_created') ?></th>
                                        <!--<th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('salog_ref') ?></th>-->

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('customer_name'); ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('carrier_name'); ?></th>
                                        <?php
                                        $containertxt = $this->lang->line('container_num');
                                        if ($this->session->userdata('branch_code') == 'INCL') {
                                            $containertxt = $this->lang->line('docket_number');
                                        } ?>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $containertxt ?></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('kn_origin_ref') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('load_plan_connote') ?></th>

                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('pickup') ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('general_delivery') ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('del_city') ?></th>
                                        <th><i class="fa fa-list-alt" aria-hidden="true"></i><?= $this->lang->line('trip_no') ?></th>

                                        <th><i class="fa fa-hourglass-start"></i><?= $this->lang->line('general_status') ?></th>
                                        <th><i class="fa fa-hourglass-start" aria-hidden="true"></i><?= $this->lang->line('manifest_no') ?></th>

                                        <th><i class="fa fa-hourglass-start" aria-hidden="true"></i><?= $this->lang->line('otherstatus') ?></th>

                                        <th><i class="fa fa-hourglass-start"></i><?= $this->lang->line('Stoppage') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('created_date'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('pic_date') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('estimated_delivery_date') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('deliverydate') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('bpartner_motransport') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('department'); ?></th>
                                        <th><i class="fa fa-archive" aria-hidden="true"></i><?= $this->lang->line('total_packages') ?></th>
                                        <th><i class="fa fa-print" aria-hidden="true"></i><b> <?= $this->lang->line('scanned_quantity') ?></b></th>
                                        <th><i class="fa fa-archive" aria-hidden="true"></i><?= $this->lang->line('no_of_pallets') ?></th>
                                        <th style="min-width: 220px;"><i class="fa fa-money"></i><?= $this->lang->line('billing_status') ?></th>

                                        <?php
                                            if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                $uomWeight = '(Kgs)';
                                                $uomVolume = '(m3)';
                                            } else {
                                                $uomWeight = '';
                                                $uomVolume = '';
                                            }
                                            ?>
                                            <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('actual_weight') ?> <?= $uomWeight ?></th>
                                            <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('general_weight') ?> <?= $uomWeight ?></th>
                                            <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('actual_volume') ?> <?= $uomVolume ?></th>
                                            <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('general_volume') ?> <?= $uomVolume ?></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('pod'); ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('jfr'); ?></th>

                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_company_code') ?></th>
                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_branch_code') ?></th>

                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('from') . " " . $this->lang->line('general_source') ?></th>
                                        <th><i class="icon tru-icon-calendar" aria-hidden="true"></i><?=  $this->lang->line('booking_updated'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('pq_ref') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('external_customer') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="tbodyDynamicData">
                                    <?php
                                    if(!empty($pagination->hasItems())) {

                                        $i=1;
                                        foreach($pagination->items() as $res) {
                                           
                                            if($this->session->userdata('company_code')=="AUKN"){
                                                if($res['check_val']==1){
                                                    ?>
                                                    <tr style="background-color:#fff0e6" title="<?= $res['alert_msg'] ?>">
                                                    <?php
                                                }
                                                else{
                                                    echo "<tr>";
                                                }
                                            }else{
                                                echo "<tr>";
                                            }
                                            ?>

                                            <!--<tr>-->
                                            <td>
                                                <div class="checkbox checkbox-info">
                                                    <label>
                                                        <input type="checkbox" class="recordcheckbox" name="chck1" id="<?= $res['order_row_id'] ?>" value="<?= $res['order_row_id'];?>">
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                    </label></div>

                                            </td>

                                            <td>
                                                <input type="hidden" id="row_newvvorder_<?= $i; ?>" name="row_newvvorder_<?= $i; ?>" value="<?= $res['order_row_id'] ?>" />
                                                <ul class="nav nav-tabs">

                                                    <li class="dropdown tablebtnrleft">
                                                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                                            <span class="icon  tru-icon-action-setting"></span>
                                                        </a>
                                                        <ul class="dropdown-menu" role="menu">
                                                            <li>
                                                                <a data-toggle="modal" data-target="#viewOrderModal" href="<?= base_url() ?>orders/vieworder/<?= $res['order_row_id'] ?>" id="viewo_<?= $res['order_row_id']; ?>">
                                                                    <span class="icon tru-icon-view" aria-hidden="true"></span><?= $this->lang->line('general_view') ?>
                                                                </a>
                                                            </li>
                                                            <?php
                                                            $country_userids = $this->session->userdata("country_user_ids");
                                                            if ($res['order_status'] != 'CANCELLED' && $res['customer_code'] != HIDE_CUSTOMERS) {
                                                            if(($this->session->userdata('company_code') == 'AUKN') && (empty($country_userids))){
                                                                if($res['order_status'] == 'ACTIVE' || $res['order_status'] == 'PENDING' || $res['order_status'] == 'SCANNED') { ?>
                                                                    <li>
                                                                        <a data-toggle="modal" data-target="#editOrderModal" href="<?= base_url() ?>orders/editorder/<?= $res['order_row_id']?>" id="edito_<?= $res['order_row_id'] ?>" class="dt-edit">
                                                                            <span class="icon tru-icon-edit" aria-hidden="true"></span><?= $this->lang->line('general_edit') ?>
                                                                        </a>
                                                                    </li>
                                                                <?php }
                                                            } else { ?>
                                                                <li>
                                                                    <a data-toggle="modal" data-target="#editOrderModal" href="<?= base_url() ?>orders/editorder/<?= $res['order_row_id'] ?>" id="edito_<?= $res['order_row_id'];  ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-edit" aria-hidden="true"></span><?= $this->lang->line('general_edit') ?>
                                                                    </a>
                                                                </li>
                                                            <?php }  ?>

                                                            <li>
                                                               <a href="javascript:void(0);" onclick="deleteorderbyid(<?= $res['order_row_id'] ?>)" class="dt-delete">
                                                               <span class="icon tru-icon-delete" aria-hidden="true"></span> <?= $this->lang->line('general_delete') ?>
                                                               </a>
                                                            </li>
                                                            <?php } ?>
                                                            <?php $val = getorderreftypeinfo('TKN', $res['order_row_id']);//log_message("error","OrderValue:".$val);
                                                                if($val != "") {//log_message("error","OrderCarrierCode:".$res['carrier_code']); 
                                                                if($res['carrier_code'] == FLIPKART_USERID || $res['carrier_code'] == APACEKART) { 
                                                                
                                                            ?>
                                                            <li>
                                                                <a href="<?= base_url() ?>assets/poduploads/<?= $res['order_id'];  ?>_<?= $val  ?>_Docket.pdf" target="_blank" class="dt-edit">
                                                                    <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?= $this->lang->line('carrier_docket') ?>
                                                                </a>
                                                            </li>
                                                            
                                                            <li>
                                                                <a href="<?= base_url() ?>assets/poduploads/<?= $res['order_id'];  ?>_<?= $val  ?>_Label.pdf" target="_blank" class="dt-edit">
                                                                    <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?= $this->lang->line('carrier_label') ?>
                                                                </a>
                                                            </li>
                                                            
                                                            <?php if($res['order_status'] != "CLOSED" && $res['order_status'] != "CANCELLED" ){ ?>
                                                            
                                                            <li>
                                                                <a href="<?= base_url() ?>apis/FlipkartEDI/getTracking/<?= $val; ?>/<?= $res['order_row_id'] ?>/FLIPKART" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?= $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>
                                                            
                                                            <?php }}else if($res['carrier_code'] == XP_INDIA_USERID) {
                                                                if($res['order_status'] != "CLOSED" && $res['order_status'] != "CANCELLED" ){?>
                                                            <li>
                                                                <a href="<?= base_url() ?>apis/FlipkartEDI/getTracking/<?= $val; ?>/<?= $res['order_row_id'] ?>/<?= $res['customer_code'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?= $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>
                                                            <?php } if ($res['order_status'] != 'PENDING') {?>
                                                            <li>
                                                                <a href="<?= base_url() ?>apis/FlipkartEDI/getPOD/<?= $val; ?>/<?= $res['order_row_id'] ?>/<?= $res['customer_code'] ?>">
                                                                        <span class="icon tru-icon-edit" aria-hidden="true"></span><?= $this->lang->line('get_pod') ?>
                                                                </a>
                                                            </li>
                                                            <?php }}
                                                            if ($res['carrier_name'] == "I-WAY_LOGISTICS") {?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/IwayExxEDI/getStatus/<?php echo $val; ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php }
                                                                        if ($res['carrier_name'] == "DTDC EXPRESS LIMITED") {?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/DTDCEDI/getStatus/<?php echo $val; ?>/<?php echo $res['order_id'] ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php }if ($res['carrier_name'] == "THREE W LOGISTICS PRIVATE LIMITED") {?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/ThreeWLEDI/getStatus/<?php echo $val; ?>/<?php echo $res['order_id'] ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php }
                                                            if ($res['carrier_name'] == "BUSYBEES LOGISTICS SOLUTIONS PVT. LTD") {?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/ExpressBeesEDI/getStatus/<?php echo $val; ?>/<?php echo $res['order_id'] ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php }
                                                            if ($res['carrier_name'] == "SAFEXPRESS PVT. LTD") {?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/SafeExpressEDI/getStatus/<?php echo $val; ?>/<?php echo $res['order_id'] ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php }
                                                            if ($res['carrier_name'] == "BLUEDART_TRANSPORT_MUM") { 
                                                                $awbVal = getorderreftypeinfo('AWB', $res['order_row_id']);//log_message("error","OrderValue:".$val);
                                                                if($awbVal != "") { ?>

                                                            <li>
                                                                <a href="<?php echo base_url() ?>apis/BlueDartEDI/getStatus/<?php echo $awbVal; ?>/<?php echo $res['order_id'] ?>/<?php echo $res['order_row_id'] ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-tender-list" aria-hidden="true"></span><?php echo $this->lang->line('get_status') ?>
                                                                </a>
                                                            </li>

                                                            <?php } } 
                                                                } 
                                                                if ($res['order_status'] == 'ACTIVE') { ?>
                                                            
                                                            <!--<li>
                                                                <a href="#" onclick="orddocsdetails('<?php echo $res['order_row_id'];?>','<?php echo $res['order_id'];?>')"  class="btn btn-xs btn-default">
                                                                    <span class="icon tru-icon-tender-list"></span><?= $this->lang->line('manage_doc') ?>
                                                                </a>
                                                            </li>-->
                                                            
                                                             <?php } ?>
                                                            
                                                            <?php
                                                                if ($res['order_status'] != 'PENDING') { ?>
                                                            
                                                            <li>
                                                                <a href="#" onclick="livetrackdetails('<?php echo $res['order_row_id'];?>','<?php echo $res['order_id'];?>');"  class="btn btn-xs btn-default">
                                                                    <span class="fa fa-map-marker" aria-hidden="true"></span><?= $this->lang->line('live_track') ?>
                                                                </a>
                                                            </li>
                                                            
                                                            <li>
                                                                <a href="<?php echo base_url('lrgenerate/index/'.$res['order_row_id']);?>" target="_blank" class="btn btn-xs btn-default">
                                                                    <span class="icon tru-icon-tender-list"></span><?= $this->lang->line('documents') ?>
                                                                </a>
                                                            </li>
                                                            
                                                             <?php } ?>

                                                            <li>
                                                                        <a href="<?= base_url() ?>orders/copyorder/<?= $res['order_row_id'] ?>" class="dt-delete" id="copyco_<?= $res['order_row_id'] ?>" data-toggle="modal" data-target="#editOrderModal">
                                                                            <span class="fa fa-clone" aria-hidden="true"></span><?= $this->lang->line('copy_order') ?>
                                                                        </a>
                                                                    </li>
                                                            <!-- <li>
                                                                <a href="<?= base_url() ?>orders/reverseorder/<?= $res['order_row_id'] ?>" class="dt-delete">
                                                                    <span class="icon tru-icon-edit" id="revero_<?= $res['order_row_id'] ?>" aria-hidden="true"></span><?= $this->lang->line('reverse_order') ?>
                                                                </a>
                                                            </li>-->
                                                            <li>
                                                                <?php if($this->session->userdata('company_code') == 'PLKN') { ?>
                                                                    <a href="<?= base_url() ?>kntruckwaybill/tripwisetruckwaybill/<?= $res['order_row_id']."_english"; ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb')." English"; ?>
                                                                    </a>
                                                                    <a href="<?= base_url() ?>kntruckwaybill/tripwisetruckwaybill/<?= $res['order_row_id']."_polish"; ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb')." Polish"; ?>
                                                                    </a>
                                                                <?php } else {  ?>
                                                                    <a href="<?= base_url()?>kntruckwaybill/index/<?= $res['order_row_id']?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb'); ?>
                                                                    </a>
                                                                <?php  }  ?>
                                                            </li>
                                                            
                                                            <?php
                                                                if( $company_code == 'KNAU' ){ ?>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Macpaclabel/multiplelabels/<?= $res['order_row_id'];
                                                                     ?>" target="_blank">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('print_label'); ?>
                                                                    </a></li>
                                                                    <?php
                                                                }else{
                                                                    ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>orders/orderlabel/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('print_label'); ?>
                                                                        </a>
                                                                    </li>

                                                                <?php
                                                                }
                                                            ?>
                                                            
                                                            <?php if($company_code == "SGKN") { ?>
                                                                <li><a
                                                                href="<?php
                                                                echo base_url() ?>Generatebillinginvoice/internalbubilling/<?= $res['order_row_id'];
                                                                 ?>">
                                                                <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate')." ".$this->lang->line('internal_invoice'); ?>
                                                                </a></li>
                                                            <?php } ?>

                                                            <?php if($res['salog_ref'] != "" && $this->session->userdata('branch_code') != "INCL") : ?>
                                                                <li>
                                                                    <a href="<?= base_url()?>shipments/sendepodtosalog/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_salog_epod'); ?>
                                                                    </a>
                                                                </li>
                                                                <?php if ($res['order_status'] == "CLOSED") : ?>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggersalogstatuses/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('retrigger_salog_statuses'); ?>
                                                                        </a>
                                                                    </li>
                                                            <?php endif;endif; ?>
                                                            <?php if(checkCustomerHasAltovaConnection($res['order_row_id']) != 0) :?>
                                                                <li>
                                                                    <a href="<?= base_url()?>carriercommonedi/sendAltovaOrder/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_order_to_roadlog'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php endif; ?>

                                                            <?php if($res['created_source'] == 18 && $res['order_status'] == "CLOSED") : ?>
                                                                <li>
                                                                    <a href="<?= base_url()?>shipments/retriggerepodtoroadlog/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog Epod
                                                                    </a>
                                                                </li>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggerroadlogstatuses/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog statuses
                                                                        </a>
                                                                    </li>
                                                            <?php endif; ?>

                                                            <?php if ($res['can_cancel']) { ?>


                                                                    <?php if($this->session->userdata('branch_code') != "INCL" && in_array($res['vendor_id'], [310,311])) { ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>uniqloactions/cancelcarrierorder/<?= $res['order_row_id'] ?>" onclick="return checkcancelconfirm();">
                                                                            <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('general_cancel')." ".$this->lang->line('menu_trip'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php } else { ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>trip/cancel/<?= $res['order_row_id'] ?>" onclick="return checkcancelconfirm();">
                                                                            <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('general_cancel')." ".$this->lang->line('menu_trip'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php } ?>

                                                            <?php } ?>

                                                            <?php if($this->session->userdata('company_code') == "RUKN") {
                                                                if(($res['order_status'] == "ACTIVE") || ($res['order_status'] == "CLOSED")) { ?>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Knruinvoice/rupoa/<?= $res['order_row_id'];
                                                                     ?>">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span>POA
                                                                    </a></li>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Rutransportorder/index/<?= $res['order_row_id'];
                                                                     ?>">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('transport_order') ?>
                                                                    </a></li>
                                                            <?php } } ?>
                                                            <?php if($company_code == 'AUKN' || $company_code == "KNAU"){ ?>
                                                                <li>
                                                                    <?php if(!empty($res['manifestno'])){ ?>
                                                                        <a href="<?= base_url('aulabel/downloadmanifest/'.$res['order_row_id']) ?>" >
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('download_manifestdoc') ?>
                                                                        </a>
                                                                    <?php } else { ?>
                                                                        <a href="#" class="dt-delete" onclick="alert('Manifest file not generated for this Order')">
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('download_manifestdoc') ?>
                                                                        </a>
                                                                    <?php } ?>
                                                                </li>
                                                            <?php } ?>

                                                            <?php if($this->session->userdata('company_code')=="AUKN"){
                                                                ?>
                                                                <li>
                                                                    <a href="#" class="" onclick="palletadd(<?= $res['order_row_id'] ?>)" ><span class="fa fa-plus"></span><?= $this->lang->line('add_pallets'); ?></a>
                                                                </li>
                                                                <?php
                                                                $country_userids = $this->session->userdata("country_user_ids");
                                                                if(!empty($country_userids)){
                                                                    ?>
                                                                    <li>
                                                                        <a href="#" class="" onclick="manifestoverride(<?= $res['order_row_id']; ?>)" ><span class="fa fa-plus"></span><?= $this->lang->line('manifest')." ".$this->lang->line('override'); ?> </a>
                                                                    </li>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                            <?php if ($res['order_status'] == 'PENDING') : ?>
                                                                <li>
                                                                    <a href="<?= base_url() ?>Orderdata/cancelOrder/<?= $res['order_row_id'] ?>">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('cancel_order'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php endif;
                                                            if ($res['created_source'] == 5) : ?>
                                                                <li>
                                                                    <a href="javascript:void(0);" onclick="fetchSALOGDocs(<?= $res['order_row_id']; ?>)" ><span class="fas fa fa-file-pdf-o"></span><?= $this->lang->line('download')." ".$this->lang->line('salog_ref')." ".$this->lang->line('documents'); ?> </a>
                                                                </li>
                                                            <?php endif; ?>
                                                            <?php if ($res['carrier_name'] == "BLOWHORN") { ?>
                                                                <li>
                                                                    <a href="#" class="" onclick="getblowhornstatus(<?= $res['order_row_id']; ?>)"><span class="fas fa fa-file-pdf-o"></span><?= $this->lang->line('blowornstatus'); ?> </a>
                                                                </li>
                                                            <?php } ?>
                                                            <?php
                                                            if (checkAccessConditions('CHECK_UNIQLO_CARRIER', $res['vendor_id']) && ($res['shift_id'] != 0)) : ?>
                                                                <li>
                                                                    <a href="<?= base_url() ?>uniqloactions/updateorder/<?= $res['order_row_id'] ?>" onclick="return checktriprevertconfirm();">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('trip_revert'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php
                                                            endif; ?>
                                                            <?php 
                                                            if (checkAccessConditions('CHECK_CARGO_EXCHANGE_CARRIER', $res['vendor_id']) && ($res['shift_id'] != 0)) : ?>
                                                                <li>
                                                                    <a href="#" onclick="sendTripToCargoExchange(<?=  $res['shift_id'] ?>,<?= $res['order_row_id']; ?> )">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span>Send to Cargo Exchange</a>
                                                                </li>
                                                            <?php
                                                            endif; ?>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td><?= $i; ?></td>
                                           
                                            <td><?= $res['order_id'] ?></td>
                                            <td><?= $res['delivery_note'] ?></td>
                                            <td><?= $res['username'] ?></td>
                                            <!--<td><?= $res['salog_ref'] ?></td>-->
                                            <td><?= $res['customer_name']; ?></td>
                                            <td><?= $res['carrier_name']; ?></td>
                                            <td><?= $res['container_no'] ?></td>
                                            <td><?= $res['pos_ref'] ?></td>
                                            <td><?= $res['loadplanconnote'] ?></td>
                                            <td><?= $res['pickup'] ?></td>
                                            <td><?= $res['delivery']; ?></td>
                                            <td><?= $res['deliverycity']; ?></td>
                                            <td><?= $res['trip_no'] ?></td>
                                            <td><?= $res['order_status']; ?></td>
                                            <td><?= $res['manifestno'] ?></td>
                                            <td><?= $res['otherstatus'] ?></td>
                                            <td><?= $res['Stoppage']; ?></td>
                                            <td><?= date('Y-m-d', strtotime($res['createdon'])) ?></td>
                                            <td><?php
                                                    if (!empty($res['pickup_date']) && ($res['pickup_date'] != '0000-00-00 00:00:00')) {
                                                        echo date('Y-m-d h:i A', strtotime($res['pickup_date']));
                                                    }
                                                    ?></td>
                                                <td><?php 
                                                    if (!empty($res['delivery_date']) && ($res['delivery_date'] != '0000-00-00 00:00:00')) {
                                                        echo date('Y-m-d h:i A', strtotime($res['delivery_date']));
                                                    }
                                                    ?></td>
                                           <!-- <?php
                                            if ($company_code == 'AUKN' || $company_code == "KNAU") { ?>
                                                <td><?php
                                                    if (!empty($res['pickup_date'])) {
                                                        echo date('Y-m-d h:i A', strtotime($res['pickup_date']));
                                                    }
                                                    ?></td>
                                                <td><?php
                                                    if (!empty($res['delivery_date'])) {
                                                        echo date('Y-m-d h:i A', strtotime($res['delivery_date']));
                                                    }
                                                    ?></td>
                                            <?php
                                            } else { ?>
                                                <td><?php
                                                    echo date('Y-m-d h:i A', strtotime($res['pickup_date'])); ?></td>
                                                <td><?= date('Y-m-d h:i A', strtotime($res['delivery_date'])); ?></td>
                                            <?php
                                            } ?>-->
                                            <td><?= $res['final_delivery'] ?></td>
                                            <td><?= $res['transport_mode'] ?></td>
                                            <td><?= $res['department_code']; ?></td>
                                            <td><?= $res['total_packages'] ?></td>
                                            <td><?= $res['tot_scanned_qty'] ?></td>
                                            <td><?= $res['num_of_pallets'] ?></td>
                                            <td style="min-width: 220px;"><?= $res['html'] ?></td>
                                            <?php if($res['salog_ref'] != "") : ?>
                                            <td> <?= $res['gross_weight']. ' ' .$res['gross_weight_uom'] ?> </td>
                                            <td><?=  $res['chargeable_weight']. ' ' .$res['chargeable_weight_uom'] ?> </td>
                                                <?php else : ?>
                                            <td>
                                            <?php
                                            $weightunit = isset($res['weight_unit']) ? $res['weight_unit'] : 'kg';
                                            if ($res['weight'] > 0) {
                                                if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                    echo round(floatval($res['weight']), 2);
                                                } elseif ($weightunit === 'kg') {
                                                    echo uom_string($res['weight'], 'kg');
                                                } else {
                                                    echo round(floatval($res['weight']), 2) . " " . $weightunit;
                                                }
                                            }
                                            ?>
                                            </td>

                                            <td><?php
                                            if ($res['second_weight'] > 0) {
                                                if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                    echo round(floatval($res['second_weight']), 2);
                                                } else {
                                                    echo uom_string($res['second_weight'], 'kg');
                                                }
                                            } ?> </td>
                                                <?php endif;  ?>
                                            <td><?php
                                                if ($res['volume'] > 0) {
                                                    if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                        echo round(floatval($res['volume']), 2);
                                                    } else {
                                                        echo uom_string($res['volume'], 'cbm', 2);
                                                    }
                                                } ?></td>

                                                <td><?php
                                                    if ($res['second_volume'] > 0) {
                                                        if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                            echo round(floatval($res['second_volume']), 2);
                                                        } else {
                                                            echo uom_string($res['second_volume'], 'cbm', 2);
                                                        }
                                                    } ?>
                                                </td>

                                            <td><?= $res['POD']; ?></td>
                                            <td><?= $res['JFR']; ?></td>
                                            <td><?= $res['company_code'] ?></td>
                                            <td><?= $res['branch_code'] ?></td>
                                            <td><?= (new OrderCreationSourceHelper())->getOrderSourceName(
                                                    $res['created_source']
                                                ); ?></td>
                                            <td><?=  date('Y-m-d h:i A',strtotime($res['updatedDate']))?></td>
                                            <td><?= $res['pq_ref'] ?></td>
                                            <td><?= $res['external_customer']; ?></td>
                                            </tr>
                                            <?php
                                            $i++;
                                        } ?>
                                    <?php
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-------Order List View-------->
                            <div class="sidebars" id="sidebars_list" style="display:none">
                                <div class="advance_searchcol sidebar right" id="sidebar_list">

                                    <div class="title_header">
                                        <h2>IN0303200041</h2>
                                        <h3><?= $this->lang->line('booking_id'); ?></h3><a href="javascript:void(0)" class="closebtn" data-action="close" data-popup="open-data" data-side="right">&times;</a>
                                    </div>
                                    <div class="custom-scroll" style="max-height: 250px; overflow-y: auto; ">
                                        <form action="#">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for=""><?= $this->lang->line('bpartner_product'); ?></label>
                                                        <p><?= $this->lang->line('product_name'); ?> </p>

                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('general_company_code'); ?> </label>
                                                            <p>INKN</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('order_status'); ?></label>
                                                            <p><?= $this->lang->line('menu_pending'); ?></p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('delivery_term_inco'); ?></label>
                                                            <p>Inco Term Details</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('client_code'); ?></label>
                                                            <p>INHYD</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('customer_id'); ?></label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('delivery_terms'); ?> </label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('general_department_code'); ?> </label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">SRMT</label>
                                                            <p>STREET NO.2,ALIPURDUAR, INDIA, 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('order_type'); ?></label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('bpartner_service'); ?></label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('bpartner_motransport'); ?></label>
                                                            <p>Full Truck Load</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="title_header">

                                                        <h3>Routing Details</h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('qbook_shipperid'); ?></label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('shipper_name'); ?></label>
                                                            <p>SRMT</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('early_pickup'); ?></label>
                                                            <p>2020-03-06 08:00:00 </p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('late_pickup'); ?> </label>
                                                            <p>2020-03-06 10:00:00 </p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('general_location'); ?></label>
                                                            <p>Street No.2, Alipurduar, India - 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('general_phone'); ?></label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for=""><?= $this->lang->line('general_email'); ?></label>
                                                            <p>kevin@gmail.com</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="footer-view_list">

                                                <div class="top20 ">
                                                    <div class="view_more text-center">
                                                        <button type="submit" name="submit" class="btn btn-default btn_color "><?= $this->lang->line('general_edit') . ' ' . $this->lang->line('details'); ?></button>
                                                        <button type="Reset" name="reset" class="btn btn-default btn_color resetbtn"><?= $this->lang->line('view_more_details'); ?></button>

                                                    </div>


                                                </div>
                                            </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-------Order List View- End------->
                    </div>
                    <div style="z-index: 9999;" class="modal fade consolidation_modal" id="consolidation_modal" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" style="width:45%;" role="document">
                            <div class="modal-content">
                            <div class="modal-header">
                            <button type="button" class="closevalues close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title" id="companyCodeAddmodalLabel">
                            <?= $this->lang->line('menu_choose_consolidation'); ?>
                            </h4>
                            </div>
                            <div class="modal-body">
                            <div class="row">
                            <div class="col-sm-3">
                            <div class="form-group">
                            <div class="form-group">
                            <select name="consolidation_id" class="select2" id="consolidation_id" form="updatecargobulk" class="form-control updcargo-form">
                            <option value="">Select</option>
                            <?php if (!empty($consolidation_data)) {
                            foreach ($consolidation_data as $consolidation) { ?>
                            <option value="<?= $consolidation['id']; ?>"><?= $consolidation['consolidation_id_name']; ?></option>
                            <?php }
                            } ?>
                            </select>
                            </div>
                            </div>

                            </div>
                            </div>
                            <div class="modal-footer success_message_footer">
                            <button type="button" class="btn btn-primary success_redirect suc_pop_ok" onclick="applyconsolidation(this,0)"><?= $this->lang->line('apply'); ?></button>
                            <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                            </div>

                            </div>
                            </div>
                    </div>
                 </div>

                    <div style="z-index: 9999;" class="modal fade insert_success_div" id="insert_success_div" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                </div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;"><span class="glyphicon glyphicon-ok-circle popup_circle" style="font-size: 22px;
                                       color: green;"></span>&nbsp;<span class="pop_message"><?= $this->lang->line('insert_message'); ?></span></p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok hide_popbutton" data-dismiss="modal"><?= $this->lang->line('general_ok'); ?></button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel hide_popbutton" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                                    <button type="button" class="btn btn-primary  show_popbutton" style="display:none" onclick="applyconsolidation(this,1)">Yes</button>
                                    <button type="button" class="btn btn-danger  show_popbutton" style="display:none" data-dismiss="modal"><?= $this->lang->line('general_no'); ?></button>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                    <div class="modal fade tabsModalView orgTabModalStyle" id="RtPopupModal" role="dialog" style="display: none;">
                        <div class="modal-dialog modal-xl" id="RtPopupType" style="width: 90%;">
                    
                            <!-- Modal content-->
                            <div class="modal-content">
                                <div class="modal-header overlapHeading">
                                    <button type="button" class="close" data-dismiss="modal" style="margin-top: -30px;">×</button>
                                    <div class="modal-title" id="rtpopuptitle">
                                        <div class="modal-sub-title">
                                        <?= $this->lang->line('live_trips_map_view'); ?>
                                        </div>
                                        </div>
                                </div>
                                <div class="modal-body no-padding" id="viewrtdata" style="height: 75vh;"></div>
                    
                            </div>
                    
                        </div>
                    </div>
                    <div class="modal fade in tabsModalView orgTabModalStyle" id="myModal" role="dialog">
                    	<div class="modal-dialog modal-xl">
                    
                    	  <!-- Modal content-->
                    	  <div class="modal-content" style="border-radius: 10px;">
                    		<div class="modal-header overlapHeading">
                    		  <button type="button" class="close" data-dismiss="modal" style="margin-top: -30px;">&times;</button>
                    		  <div class="modal-title" id="mtitle">  <div class="modal-sub-title"> <?php echo $this->lang->line('general_loading'); ?></div></div>
                    		</div>
                    			<div class="modal-body" id="viewdata">
                    
                    			</div>
                    
                    			<div class="modal-footer">
                    			  <!--<button type="button" class="btn btn-default" onClick="saveRCA()" >Save</button>
                    			  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>-->
                    			</div>
                    
                    	  </div>
                    
                    	</div>
                    </div>
                    <div class="modal fade in tabsModalView orgTabModalStyle" id="fullScreenModal" role="dialog" style="padding-left: 0px;">
                    	<div class="modal-dialog modal-xl">
                    	    <div class="modal-content">
                                <div class="modal-header overlapHeading">
                                    <button type="button" class="close" data-dismiss="modal" style="margin-top: -30px;">×</button>
                                    <div class="modal-title modal-sub-title" id="rtpopuptitle" style="display: flex;">
                                        <div class="modal-sub-title" style="padding:8px;"></div>
                                        <!--<div class="tt_os_btn" data-dismiss="modal" ><?php echo $this->lang->line('close_popup'); ?></div>-->
                                    </div>
                                </div>
                    			<div class="modal-body" id="viewdata" style="height: calc(100vh - 82px);padding: 0px;"></div>
                    	    </div>
                    	</div>
                    </div>
                    
                    
                    
                    <div style="z-index: 9999;" class="modal fade ats_service_model" id="ats_service_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                </div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;">&nbsp;<span class="pop_message"></span></p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal"><?= $this->lang->line('general_ok'); ?></button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                    <div style="z-index: 9999;" class="modal fade " id="ready_invoice" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                    <button type="button" class="closevalues close" data-dismiss="modal">×</button>
                                    <h4 class="modal-title" id="view_customer_title"><?= $this->lang->line('response'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <h4 class="pop_message_load"></h4>
                                    <span class="pop_message">
                                        <table class="table table-striped" id="ready_invoice_tb" width="100%">
                                            <thead>
                                                <tr>
<!--                                                    <th scope="col">#</th>-->
                                                    <th scope="col"><?= $this->lang->line('booking_id'); ?></th>
                                                    <th scope="col"><?= $this->lang->line('recipient_role'); ?></th>
                                                    <th scope="col"><?= $this->lang->line('general_jfr'); ?></th>
                                                    <th scope="col">Res. Message</th>
                                                    <th scope="col"><?= $this->lang->line('general_status'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody id="readyinvoice_show_data"></tbody>
                                        </table>
                                    </span>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal"><?= $this->lang->line('general_ok'); ?></button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="charges_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;"><?= $this->lang->line('order_charges'); ?></h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id'); ?></th>
                                        <th><?= $this->lang->line('total_revenue'); ?></th>
                                        <th><?= $this->lang->line('general_jfr'); ?></th>
                                        <th><?= $this->lang->line('bu_jfr'); ?></th>
                                        <th> <?= $this->lang->line('failure_status'); ?></th>
                                        <th><?= $this->lang->line('total_cost'); ?></th>
                                        <th><?= $this->lang->line('general_jfr'); ?></th>
                                        <th><?= $this->lang->line('bu_jfr'); ?></th>
                                        <th> <?= $this->lang->line('failure_status'); ?></th>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($chexcel_uploaddata)) {
                                                foreach ($chexcel_uploaddata as $chrg) {
                                                    ?>
                                                    <tr>
                                                        <td><?= $chrg->booking_id; ?></td>
                                                        <td><?= $chrg->total_revenue; ?></td>
                                                        <td><?= $chrg->rev_debtor_jfr; ?></td>
                                                        <td><?= $chrg->rev_bu_jfrs; ?></td>
                                                        <td><?php
                                                        $rstyle = "";
                                                        if($chrg->rev_failure != ""){
                                                            $rstyle = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $rstyle ?>"><?= $chrg->rev_failure; ?></span></td>
                                                        <td><?= $chrg->total_cost; ?></td>
                                                        <td><?= $chrg->cost_jfr; ?></td>
                                                        <td><?= $chrg->cost_bu_jfrs; ?></td>
                                                        <td><?php
                                                        $style = "";
                                                        if($chrg->cst_failure != ""){
                                                            $style = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $style ?>"><?= $chrg->cst_failure; ?></span></td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                     
                    <div class="modal containerModal" id="knloginstatus_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Status Send To KN Login</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id') ?></th>
                                        <th><?= $this->lang->line('qbook_customer') ?></th>
                                        <th><?= $this->lang->line('cust_status') ?></th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $knlogin_uploaddata = $knlogin_uploaddata ?? [];
                                        foreach ($knlogin_uploaddata as $eachLine):
                                            ?>
                                            <tr>
                                                <td><?= $eachLine->orderId; ?></td>
                                                <td><?= $eachLine->customer; ?></td>
                                                <td><?php
                                                    $style = "";
                                                    if ($eachLine->status === 0) {
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    } ?>
                                                    <span style="<?= $style ?>"><?= $eachLine->message; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="clorders_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;"><?= $this->lang->line('trip_orders') . ' ' . $this->lang->line('bpartner_plist'); ?></h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id'); ?></th>
                                        <th><?= $this->lang->line( 'customer' )." ".$this->lang->line( 'user_cid' ); ?></th>
                                        <th><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><?= $this->lang->line('trip_id') ?></th>
                                        <th><?= $this->lang->line('general_status') ?></th>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($clexcel_uploaddata)) {
                                                foreach ($clexcel_uploaddata as $ord) {
                                                    ?>
                                                    <tr>
                                                        <td><?= $ord->booking_id; ?></td>
                                                        <td><?= $ord->customer_id; ?></td>
                                                        <td><?= $ord->delivery_note; ?></td>
                                                        <td><?= $ord->trip_id; ?></td>
                                                        <td><?php
                                                            $excel_status = $ord->status;
                                                            $style = "";
                                                            if (strtolower($excel_status) == "success") {
                                                                $style = "font-weight:bold;color:#099e59eb;";
                                                            } else {
                                                                $style = "font-weight:bold;color:#b71209d6;";
                                                            }
                                                            ?>
                                                            <span style="<?= $style; ?>"><?= $excel_status; ?></span></td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal containerModal" id="file_tranfer_succeslist"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">File Transfer Response</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="filetransfersucces_list">
                                        <thead>
                                        <th><?= $this->lang->line( 'booking_id' ); ?></th>
                                        <th><?= $this->lang->line('general_status') ?></th>
                                        </thead>
                                        <tbody class="filetransfersucces_list-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="orders_success_list" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;"><?= $this->lang->line('trip_orders') . ' ' . $this->lang->line('bpartner_plist'); ?></h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table  class="table table-striped table-bordered" id="orderssucces_list">
                                        <thead>
                                        
                                        <th><?= $this->lang->line( 'booking_id' ); ?></th>
                                        <th><?= $this->lang->line( 'customer' )." ".$this->lang->line( 'user_cid' ); ?></th>
                                        <th><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><?= $this->lang->line('general_status') ?></th>
                                        
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($excel_uploaddata)) {
                                            foreach($excel_uploaddata as $ord){ ?>
                                                <tr>
                                                    <td><?= $ord->booking_id ?></td>
                                                    <td><?= $ord->customer_id ?></td>
                                                    <td><?= $ord->delivery_note ?></td>
                                                    <td><?php $excel_status = $ord->status;
                                                        $style = "";
                                                        if(strtolower($excel_status) == "success")
                                                        {
                                                            $style = "font-weight:bold;color:#099e59eb;";
                                                        }else{
                                                            $style = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $style?>"><?= $excel_status ?></span></td>
                                                </tr>
                                            <?php } } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="cargobulkupload">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                                    <h4 class="modal-title">Update Cargo For Selected Orders </h4>

                                </div>

                                <div class="modal-body">
                                   <form name="updatecargobulk" id="updatecargobulk" method="post" class="updatecargobulk" action="" >
                                        <div class="box custom-box">
                                        <input type="hidden" id="cargo_orderids" class="updcargo-form" form="updatecargobulk" name="cargo_orderids" value="">
                                            <table  border="0" width="100%">
                                                <span id="cargoupd_success" style="display:none;color: #008000bd;">Cargos Updated Successfully...</span>
                                                <tr><td colspan="2"></td></tr>
                                                <tr>
                                                    <td width="40%" style="padding-left: 30px;font-size: 13px;font-weight: 600;color: #162d56;">
                                                        <b><?= $this->lang->line( 'package_type' )." : "; ?></b>
                                                    </td>
                                                    <td width="60%"  style="padding-right: 60px;">
                                                        <select name="updatcargo_val" id="updatcargo_val" form="updatecargobulk" class="form-control updcargo-form">
                                                            <option value="">Select</option>
                                                            <option value="PALLET">PALLET</option>
                                                            <option value="CARTON">CARTON</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                    <input type="submit"  form="updatecargobulk" class="submittype btn btn-primary  btn_color waves-effect waves-light" onclick="submitbulkcargos_fororder(event)" id="cargoupdate" data-dismiss="close" data-info="add" value="<?= $this->lang->line('general_update'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                     <div class="modal fade modalStyleSvk" id="optimizeParametersPopup" tabindex="-1" aria-hidden="true"  data-backdrop="static" data-keyboard="false">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content p-3" style="width: 550px !important; margin-left: 330px !important; min-height: 300px !important">
                                <div class="modal-body" style="padding: 0 !important;">
                                    <div class="content-page">
                                        <div class="content">
                                            <div class="container">
                                                <div class="card-box_lis row">
                                                    <div class="col-xs-12">
                                                        <div class="tab_list_col tabBts">
                                                            <div class="col-sm-6 pd-left-0">
                                                            <ul id="tabs" class="nav nav-tabs" role="tablist">
                                                                <li role="presentation" class="active">
                                                                <a href="#all" role="tab" data-toggle="tab"> Optimize Parameters </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-12" style="padding:0px 10px;">
                                                                <div class="view_moretab text-right">
                                                                <button type="button" class="closeOptimizeParametersPopup btn btn-default waves-effect btn_color" > <?= $this->lang->line('general_close'); ?> </button>
                                                                <input type="submit" class="submitOptimizeParametersPopup btn btn-primary btn_color waves-effect waves-light" id="submitOptimizePopup" value="submit">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content">
                                                            <div role="tabpanel" class="tab-pane fade in active" id="all">
                                                                <div class="bg-white_main">
                                                                <!-- accordion start -->
                                                                <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                                                                    <div class="generalInfo panel panel-default" style="background: transparent">
                                                                        <div class="panel-heading active" role="tab" id="headingGeneralInfo">
                                                                            <h4 class="panel-title">
                                                                            <a role="button" data-toggle="collapse" data-parent="#accordion" href="#generalInfo" aria-expanded="true" aria-controls="collapseOne">
                                                                            <i class="more-less fa fa-angle-right"></i>
                                                                            </a>
                                                                            </h4>
                                                                        </div>
                                                                        <div id="generalInfo" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingGeneralInfo">
                                                                            <div class="panel-body" style="background: transparent; border:none !important;padding:0px !important;">
                                                                            <div class="general_input_fields"></div>
                                                                            <div class="row">
                                                                                <div class="col-sm-12">
                                                                                    <div class="cardCol">
                                                                                        <div class="form-group">
                                                                                        <label> <?= $this->lang->line('tariff_type'); ?></label>
                                                                                        <select name="optimizeTariffType" class="form-control optimizePupupDropDowns" id="tariffTypeOptions">
                                                                                            <option value="">SELECT Tariff Type</option>
                                                                                            <option value="BUY">BUY</option>
                                                                                            <option value="SELL">SELL</option>
                                                                                        </select>
                                                                                        </div>
                                                                                        <div class="form-group optimizeCarrierData" style="display: none;">
                                                                                        <label for="optimizeCarrierId"> <?= $this->lang->line('carrier'); ?>  </label>
                                                                                <select name="optimizeCarrierId" class="optimizePupupDropDowns form-control" id="optimizeCarrierId">
                                                                                    <option value="">--Select--</option> <?php  foreach(($carriersList ?? []) as $eachCarrier): ?> <option value="
                                                                                            <?= $eachCarrier['id'] ?>"> <?= $eachCarrier['name'] ?> </option> <?php endforeach; ?>
                                                                                </select>
                                                                                        </span>
                                                                                        </div>
                                                                                        <div class="form-group">
                                                                                            <label for="optimizeMod"><?= $this->lang->line('bpartner_motransport');  ?></label>
                                                                                        <select name="optimizeMod" class="optimizePupupDropDowns form-control" id="optimizeMod">
                                                                                            <option value="">--Select--</option>
                                                                                            <?php
                                                                                                foreach($transport as $mode) : ?>
                                                                                                    <option value="<?= $mode['code'] ?>" ><?= $mode['name'] ?></option>
                                                                                                <?php endforeach; ?>
                                                                                        </select>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                        </div>
                    <div class="modal fade modalStyleSvk" id="individualChargesPopup" role="dialog" aria-hidden="true" data-backdrop="static" 
     data-keyboard="false">
                        <div class="modal-dialog modal-sm modal-dialog-centered" style="width: 50%">
                            <div class="modal-content" style="min-height: 200px !important;">
                                <div class="modal-body" style="padding: 5px !important">
                                    <div class="content-page">
                                        <div class="content">
                                            <div class="container">
                                                <div class="card-box_lis row">
                                                    <div class="col-xs-12">
                                                        <div class="tab_list_col tabBts">
                                                            <div class="col-sm-6 pd-left-0">
                                                                <ul id="tabs" class="nav nav-tabs" role="tablist">
                                                                    <li role="presentation" class="active">
                                                                    <a href="#all" role="tab" data-toggle="tab"> Price Breakup </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-12" style="padding:0px 10px;">
                                                                    <div class="view_moretab text-right">
                                                                        <button type="button" class="closeIndividualChargesPopup btn_color" data-dismiss="modal" aria-label="Close">
                                                                            <?= $this->lang->line('close')?>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div id="individualChargesBody">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade modalStyleSvk" id="optimizeTripPopup" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-sm" style="padding-left: 200px;">
                            <div class="modal-content p-3" style="max-width: 80% !important; min-height: 200px !important;">
                                <div class="modal-body" style="padding: 0 !important;">
                                    <div class="content-page">
                                        <div class="content">
                                            <div class="container">
                                                <div class="card-box_lis row">
                                                    <div class="col-xs-12">
                                                        <div class="tab_list_col tabBts">
                                                            <div class="col-sm-6 pd-left-0">
                                                                <ul id="tabs" class="nav nav-tabs" role="tablist">
                                                                    <li role="presentation" class="active">
                                                                    <a href="#all" role="tab" data-toggle="tab"> Optimize Rates </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-12" style="padding:0px 10px;">
                                                                    <div class="view_moretab text-right">
                                                                        <button type="button" class="closeOptimizeTripPopup btn btn-default waves-effect btn_color" > <?= $this->lang->line('general_close'); ?> </button>
                                                                        <input type="submit" class="createTripButton btn btn-primary  btn_color waves-effect waves-light" data-info="add" value="submit">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div id="dynamicOptimizeBody">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade modalStyleSvk" id="trip_creation">
                    <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                    <div class="modal-body">
                        <div class="content-page">
                        <div class="content">
                        <div class="container">
                        <div class="card-box_lis row">
                            <form name="tripcreation" id="tripcreation" method="post" class="tripcreation" action="<?= base_url()?>orders/triporderintoshipment" <?= ($this->session->userdata('company_code')=='AUKN')?'onsubmit="return validatetrip();"':''?>>
                   <input type="hidden" id="trip_orderid" name="ordid">
                   <input type="hidden" id="trip_type" name="trip_type" value="single">
                   <div class="col-xs-12">
                     <div class="tab_list_col tabBts">
                      
                       <div class="col-sm-6 pd-left-0">
                         <ul id="tabs" class="nav nav-tabs" role="tablist">
                           <li role="presentation" class="active">
                             <a href="#all" role="tab" data-toggle="tab"> <?= $this->lang->line('trip_mgt'); ?> </a>
                           </li>
                         </ul>
                       </div>
                       <div class="row">
                         <div class="col-sm-12" style="padding:0px 10px;"> <?php
                                     $user_id = $this->session->userdata('user_id');
                                     $list = getListForTrip($user_id);
                                     $carrierlist = $vehicletypes = array();
                                    if(!empty($list)){
                                      $carrierlist = $list['carrierlist'];
                                      $vehicletypes = $list['vehicletypes'];
                                    } ?> <div class="col-sm-3">
                             <div class="form-group">
                               <label> <?= $this->lang->line('template_id') ?> </label>
                               <select form='tripcreation' name="templateId" onchange="disableOtherInputFields()" class="Txtfld form-control" id="templateId">
                                 <option value="">--Select--</option>
                               </select>
                               <input type="hidden" form='tripcreation' name="fromsource" id="fromsource" value="orders">
                               </td>
                             </div>
                           </div>
                          
                           <div class="col-sm-3">
                             <div class="form-group">
                               <label> <?= $this->lang->line('carrier_name'); ?> * </label>
                               <select name="carrierid" class="tripcar_id tripcreatefields Txtfld mandatoryflds form-control" id="tcarrierid" required="">
                                 <option value="">--Select--</option> <?php  foreach($carrierlist as $carrier){ ?> <option value="
																			<?= $carrier['id'] ?>"> <?= $carrier['name'] ?> </option> <?php } ?>
                               </select>
                             </div>
                           </div>
                           <div class="col-sm-2">
                             <div class="form-group">
                               <label> <?= $this->lang->line('carrier_id');  ?> </label>
                               <input onkeypress="return isNonSpecialCharCheck(event);" type="text" class="form-control tripcar_name Txtfld" readonly onkeyup="upper(this);" id="nccode" size="20" value="">
                             </div>
                           </div>
                           <div class="col-sm-4">
                             <div class="view_moretab text-right labelWithoutBt">
                                <input type="button" class="btn btn-primary btn_color waves-effect waves-light" id="tripOtimize" data-info="add" value="<?= $this->lang->line('optimize'); ?>" style="padding:8px;" onclick="optimizeCarrierTripForOrder()">
                               <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"> <?= $this->lang->line('general_close'); ?> </button>
                               <input type="submit" class="submittype btn btn-primary  btn_color waves-effect waves-light" id="new_company_add" data-dismiss="close" data-info="add" value="
																			<?= $this->lang->line('submit_trip'); ?>">
                             </div>
                           </div>
                         </div>
                       </div>
       
                       <div class="tab-content">
                        <div role="tabpanel" class="tab-pane fade in active" id="all">
                            <div class="bg-white_main">
                             <!-- accordion start -->
                               <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                               <div class="generalInfo panel panel-default" style="background: transparent">
                                 <div class="panel-heading active" role="tab" id="headingGeneralInfo">
                                   <h4 class="panel-title">
                                     <a role="button" data-toggle="collapse" data-parent="#accordion" href="#generalInfo" aria-expanded="true" aria-controls="collapseOne">
                                       <i class="more-less fa fa-angle-right"></i>
                                     </a>
                                   </h4>
                                 </div>
                                <div id="generalInfo" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingGeneralInfo">
                                   <div class="panel-body" style="background: transparent; border:none !important;">
                                     <div class="general_input_fields"></div>
                                  
                                   <div class="row">
                                     <div class="col-sm-4">
                                       <div class="cardCol">
                                         <div class="form-group"> <?php  $vehicle_types = getVehicletypeMasterData(); ?> <label> <?= $this->lang->line('vehicle_type'); ?> </label>
                                           <select name="vehicle_type" id="tpvehicle_type" class="tripcreatefields Txtfld tripcar_id form-control"> <?php
                                                        echo "
																										<option value=''>-Select-</option>";
                                                            if(!empty($vehicle_types)){foreach($vehicle_types as $tt){
                                                                 echo "
																										<option value='" . $tt['id']. "'>" . $tt['trucktype']. "</option>";
                                                            }}
                                                    ?> </select>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('veh_type_name'); ?> </label>
                                           <input type="text" class="Txtfld form-control" readonly id="tpveh_typename" size="20" value="">
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('vehicle_no'); ?> </label>
                                           <span id="tpveh_numdiv">
                                             <select name="veh_typenum" form='tripcreation' id="tvehnum" class="tripcreatefields Txtfld tripcar_id form-control">
                                               <option value=''>--Select--</option>
                                             </select>
                                           </span>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('vehicle_id'); ?> </label>
                                           <input type="text" name="vehicle_id" readonly class="add_company Txtfld form-control" id="tvehid" size="20" value="">
                                         </div>
                                       </div>
                                     </div> 
                               <div class="col-sm-4">
                                       <div class="cardCol">
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('driver_name'); ?> </label>
                                           <span id="tdrivespan">
                                             <select class="add_company Txtfld tripcreatefields tripcar_id form-control" id="tdri_name" onchange="getdrid()" name="tdrivernum">
                                               <option value=''>--Select--</option>
                                             </select>
                                           </span>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('driver_id'); ?> </label>
                                           <input type="text" readonly class="add_company Txtfld form-control" id="tdri_id" name="driver_id" size="20" value="">
                                         </div>  
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('weight_capacity'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="weight_capacity" class="tripcreatefields form-control Txtfld" name="weight_capacity"></textarea>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('volume_capacity'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="volume_capacity" class="tripcreatefields form-control Txtfld" name="volume_capacity"></textarea>
                                         </div>
                                        </div>
                                    </div>
                                
                                <div class="col-sm-4">
                                       <div class="cardCol">
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('carrier_instructions'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="carrier_instructions" class="form-control tripcreatefields Txtfld" name="carrier_instructions"></textarea>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('additional_conditions'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="additional_conditions" class="form-control tripcreatefields Txtfld" name="additional_conditions"></textarea>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('temperature_regime'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="temperature_regime" class="form-control Txtfld tripcreatefields" name="temperature_regime"></textarea>
                                         </div>
                                         <div class="form-group">
                                           <label> <?= $this->lang->line('time_for_loading_penality_rate'); ?> </label>
                                           <textarea rows="2" form="tripcreation" cols="30" id="time_for_loading_penality_rate" class="form-control Txtfld tripcreatefields" name="time_for_loading_penality_rate"></textarea>
                                         </div>
                                        </div>
                                    </div>
                                </div> 
                            </form>
                        </div>
                        </div>
                            </div>
                                </div>
                                </div>
                                </div>
                            </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        </div>
                    </div>
                    </div>
                    </div>
                    </div>
                    <div class="modal containerModal containerModalForDg" tabindex="-1" role="dialog" style="z-index: 9999 !important;">
                        <div class="modal-dialog modal-lg" role="document" style="width:98%">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Modal title</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p>Modal body text goes here.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary  btn_color waves-effect waves-light" onclick="submitDgGoodsList()"><?= $this->lang->line('general_submit'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
                <!-- /.modal-dialog -->
            </div>
            </div>
            <div id="create_popupreference" class="modal fade" tabindex="-1" role="dialog"  aria-hidden="true" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('create_popupreference');" aria-hidden="true">×</button>
                            <h4 class="modal-title" id="companyCodeAddmodalLabel">
                                <?= $this->lang->line('addreferencedetails'); ?>
                            </h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label><?= $this->lang->line('ref_name'); ?></label>
                                        <input type="hidden" name="popupref_row_id" id="popupref_row_id" value="">
                                        <input type="text"  class="popupref Txtfld form-control" id="popupreference_id"  value="" onkeyup="upper(this);" size="20" >
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="Description"><?= $this->lang->line('description'); ?></label>
                                        <input type="text" class="popupref Txtfld form-control" onkeyup="upper(this);" id="popupreference_name" size="20" value="">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label><?= $this->lang->line('referencevalue'); ?></label>
                                        <input type="text"class="popupref form-control Txtfld "  id="popupreference_value" onkeyup="upper(this);"   size="20" value="">
                                        <input type="hidden" name="order_ref_id" id="order_ref_id">
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="row">

                            </div> -->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn" onclick="viewmodaleclose('create_popupreference');"><?= $this->lang->line('general_close'); ?></button>
                            <input type="submit" class="submittypebtn btn-primary  btn_color waves-effect waves-light" id="popupadd_refernce" onclick="addpopupreferencedetails(event)" data-dismiss="close"  data-info="add" value="<?= $this->lang->line('general_save'); ?>">

                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>




        </div>

    </div>

</div>
<!-- end col -->
</div>
<!-- end row -->
</div>




<!-- EDIT modal -->
<div class="modal fade tabsModalView" id="editOrderModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

    </div>
  </div>
</div>
<!-- EDIT modal -->

<!-- VIEW modal -->
<div class="modal fade tabsModalView " id="viewOrderModal" tabindex="-1" aria-labelledby="viewModalLabel" data-backdrop="static">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
    
    </div>
  </div>
</div>
<!-- VIEW modal -->

<!-- ADD modal -->
<div class="modal fade tabsModalView" id="addOrderModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

    </div>
  </div>
</div>
<!-- ADD modal -->

<div class="modal fade" id="uploadConfirmModal" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"></h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        Are you sure you want to upload this file?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
        <button type="button" class="btn btn-primary" id="confirmUploadBtn"><?= $this->lang->line('general_upload'); ?></button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="uploadCargoModal" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"></h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        Are you sure you want to upload this file?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
        <button type="button" class="btn btn-primary" id="confirmUploadcargoBtn"><?= $this->lang->line('general_upload'); ?></button>
      </div>
    </div>
  </div>
</div>

<style>
    .panel-group .cargoTable>tbody>tr>td {
        border-top: solid 2px #fff !important;
    border-bottom: solid 1px #fff !important;
    padding: 0px;
     padding-bottom: 7%;
    margin-bottom: 0px;
}
.cargoTable>thead:first-child>tr:first-child>th {
    color: #747e8d !important;
}
.cargoTable>thead {
    background-color: transparent  !important;
    border-bottom: 3px solid #797979;
}
.cargoTable .input-group .input-group-btn:last-child>.btn {
    margin-top: 6px;
}
.cargoTable .input-group {
    margin-bottom: 5px !important;
}
.cargoTable .input-group .quantity {
   height:25px;
}
</style>
<?php include('addpallets.php');?>
<?php include('charges_distribution_modal.php');?>
<script>
    var baseurl = "<?= base_url();?>";
    var rateServiceId = <?= $rateServiceRowIdForBook?>;
    if (rateServiceId > 0) {
        $('#quickBookId').click();
    }
    var referenceNoLanguageString = '<?= $this->lang->line('reference_no'); ?>';
</script>
<script src="<?= base_url() ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<link href="<?= base_url() ?>assets/css/jquery.datetimepicker.css" rel="stylesheet">
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.js"></script>
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.full.js"></script>
<script>
    var bookingSearchURL= "orderrevenues/getorderids";
    var referenceSearchURL = "carrier/getrefinfo/massstatus";
</script>
<?php $this->load->view("searchBookingIds"); ?>
<?php $this->load->view("carriersPopUpForNzManifest"); ?>
<script  src="<?= base_url(); ?>assets/sweetalerts/sweetalert.min.js"></script>
<script>
 var baseurl = "<?= base_url();?>";
</script>

		 <?php if ($this->session->userdata('company_code') == "NZKN") { ?>
			<script src="https://maps.googleapis.com/maps/api/js?key=<?= GOOGLE_MAP_KEY; ?>&libraries=places&callback=initAutocomplete" async defer></script>
	<script type='text/javascript'>
	$(document).ready(function() {
		var autocompletesWraps = ['facility_address', 'source_address'];
		createGeoListeners(autocompletesWraps);
	});
	// Perhaps put these into a javascript library
	function createGeoListeners(autocompletesWraps) {
		var options = {types: ['geocode']};
		var inputs = $('.autocomplete');
		var autocompletes = [];
		for (var i = 0; i < inputs.length; i++) {
			var autocomplete = new google.maps.places.Autocomplete(inputs[i], options);
			autocomplete.inputId = inputs[i].id;
			autocomplete.setComponentRestrictions({'country': ['NZ']});
			autocomplete.parentDiv = autocompletesWraps[i];
			autocomplete.addListener('place_changed', fillInAddressFields);
			inputs[i].addEventListener("focus", function() {
				geoLocate(autocomplete);
			}, false);
			autocompletes.push(autocomplete);
		}
	}
	function fillInAddressFields() {
		$('.googleerror').removeClass('is-valid is-invalid');
		var place = this.getPlace();
		for (var i = 0; i < place.address_components.length; i++) {
			var addressType = place.address_components[i].types[0];
			var val = place.address_components[i].long_name;
			//console.log("address Type " + addressType + " val " + val + " pd " + this.parentDiv);
			if(addressType=='street_number'){
				var street_number_val = place.address_components[i].long_name;
			}
			 if(addressType=='route'){
				if(street_number_val=='undefined' || street_number_val=='' || street_number_val==null){
				var val = place.address_components[i].long_name;
			}else{
				var val = street_number_val+ " " +place.address_components[i].long_name;
			}
			}
			$('#'+this.parentDiv).find("."+addressType).val(val);
			$('#'+this.parentDiv).find("."+addressType).attr('disabled', false);
        }
    }

    function geoLocate(autocomplete) {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle({
                    center: geolocation,
                    radius: position.coords.accuracy
                });
                autocomplete.setBounds(circle.getBounds());
            });
        }
    }

    function gm_authFailure() {
        $('.gm-err-autocomplete').addClass('is-invalid');
        swal("Error", "There is a problem with the Google Maps or Places API", "error");
    }

    </script>
         <?php
         } ?>
<script type="text/javascript">
    function updatebulkcargo(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push($(this).attr("id"));
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Select anyone to Update Cargo');
            return false;
        } else {
            $('.updcargo-form').val("");
            $("#cargobulkupload").modal('show');
            $('#cargo_orderids').val(ids);
        }
    }
     function submitbulkcargos_fororder(e){
        e.preventDefault();
        var ids = $('#cargo_orderids').val();
        var cargo_type = $('#updatcargo_val').val();
        if(cargo_type == ""){
            gettoast('top-right1','updatcargo_val','Select Cargo Type');
            return false;
        }else{
            $.ajax({
                url: baseurl + 'orderrevenues/updatebulkcargo',
                type: "POST",
                data: {'order_ids': ids,'cargo_type':cargo_type},
                success: function (data) {
                    $('#cargoupd_success').css('display','block');
                    setTimeout(function () {
                        $('#cargoupd_success').fadeOut('fast');
                    }, 1000);
                    setTimeout(function () {
                        $("#cargobulkupload").modal('hide');
                    }, 2000);
                }
            });
        }
    }


    var list_type = $('#list_type').val();
    if(list_type == '1'){
        getorderslist();
    }
    
    var ats = $('#ats_parties').val();
    if (ats != "" && list_type == '0') {
        checkatsservice();
    }
    if (list_type > 0) {
        check_excelatsservice();
    }
    function checkatsservice() {

        var ats_parties = $('#ats_parties').val();
        let fd = new FormData();
        fd.append('ats_parties', ats_parties);
        fd.append('action', 'list');

        $.ajax({
            url: baseurl + 'ats/ats_lib',
            type: 'POST',
            processData: false,
            data: fd,
            contentType: false,
            cache: false,
            async: false,
            success: function (data) {
                if (data.trim() == "0" || data.trim() == 0) {
                    // do nothing here. i.e no need to show any model here.
                    console.log("order edit zero hits received");
                } else {
                    $('#atsModel .modal-body').html(data);
                    $('#atsModel').modal('show');
                }
            }
        });
    }
    function check_excelatsservice() {
        var ats_parties = $('#ats_parties').val();
        if(ats_parties != ""){
            let fd = new FormData();
            fd.append('ats_parties', ats_parties);
            fd.append('action', 'count');
            $.ajax({
                url: baseurl + 'ats/ats_lib',
                type: 'POST',
                processData: false,
                data: fd,
                contentType: false,
                cache: false,
                async: false,
                success: function (data) {
                    if (data.trim() == 0 || data.trim() == "0") {
                        // do nothing here.
                        console.log("Zero hits received.");
                    } else {
                        //                    $("#ats_service_model").modal('show');
                        var html = "Total ATS Hit Count is " + data + "";
                        //                    $('.pop_message').html(data);
                        $('#atsModel .modal-body').html(html);
                        $('#atsModel').modal('show');
                    }
                }
            });
        }
    }
    
    var knlogin_list_type = $('#knlogin_list_type').val();
    if (knlogin_list_type > 0) {
        getknLoginStatusRespose();
    }

    function getknLoginStatusRespose() {
        $('#knloginstatus_success_list').modal('show');
    }
    
    /*var charge_list_type = $('#charge_list_type').val();
    if (charge_list_type == '1') {
        getchargesuploadpopup();
    }
    var knlogin_list_type = $('#knlogin_list_type').val();
    if (knlogin_list_type > 0) {
        getknLoginStatusRespose();
    }

    function getknLoginStatusRespose() {
        $('#knloginstatus_success_list').modal('show');
    }
    function getorderslist(){
        $('#orders_success_list').modal('show');
    }
    function getchargesuploadpopup() {
        $('#charges_success_list').modal('show');
    }*/
    
    var cllist_type = $('#cllist_type').val();
    if (cllist_type == '1') {
        getclorderslist();
    }
    if (cllist_type > 0) {
        check_excelatsservice();
    }

    function getclorderslist() {
        $('#clorders_success_list').modal('show');
    }

    function checkwildcardsearch(evt) {
        var keyCode = (evt.which) ? evt.which : event.keyCode
        if ((keyCode != 8 || keyCode == 32) && (keyCode < 48 || keyCode > 57)) {
            if (keyCode != 46 && keyCode != 37) {
                return false;
            }
        }
    }
    
    function livetrackdetails(ordid, ord) {
        //alert(ordid);
        if (ordid != "") {
            var url = baseurl + "livetrack/etnshipment/" + ordid;
            var modal = $("#fullScreenModal");
            modal.find(".modal-sub-title").html("Live Track:: " + ord);
            $('#fullScreenModal').modal('toggle');
            modal.find("#viewrtdata").addClass('no-padding');
            modal.find("#viewdata").html('<iframe src="' + url + '" scrolling="yes" frameBorder="0" width="100%" height="100%">/iframe>');
            $('#fullScreenModal').on('hidden.bs.modal', function () {
                $("#fullScreenModal").find("#viewrtdata").find("iframe").remove();
            });
        }
    }
    
    function orddocsdetails(ord,ordid){
        alert(ord);
        alert(ordid);
        if(ord != ""){

            $.ajax({

                url:"<?=base_url('admin/orddocsdetails')?>",

                data:{"order_id":ordid,"id":ord,'type':'pending'},

                type:"POST",

                beforeSend:function(){

                    $(".buffer").show();

                    $(".containerModal").modal("show");

                    $(".containerModal").find(".modal-title").html("<?php echo $this->lang->line('manage_doc'); ?> : "+ordid);

                    $(".containerModal").find(".modal-body").html("<center><progress></center>");

                },

                success:function(data){

                    $(".buffer").hide();

                    $(".containerModal").find(".modal-body").html(data);

                }

            });

        }

    }

    /*
       Search validation (without entering any value, system should not allow to get result)
    */
    function checkseachvalidation(e) {
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var bookingid = $('#bookingid').val();
        var status = $('#searchstatus').val();
        var wildcardsearch = $('#wildcard_order_id').val();
        var order_references = $('#order_references').val();

        if (toDate == "") {
        } else {
            if (fromDate == "") {
                gettoast('top-right', 'fromDate', 'Please Enter From Date');
                return false;
            }
        }
        if (status == 'SCANNED') {
            if (fromDate == "") {
                gettoast('top-right', 'fromDate', 'Please enter a From date');
                return false;
            } else if (toDate == "") {
                gettoast('top-right', 'toDate', 'Please enter a to date');
                return false;
            } else if (fromDate != "" && toDate != "") {
                let toDateX = toDate.split('-');
                let fromDateX = fromDate.split('-');
                const date1 = new Date(toDateX[2] + '-' + toDateX[1] + '-' + toDateX[0])
                const date2 = new Date(fromDateX[2] + '-' + fromDateX[1] + '-' + fromDateX[0])
                const diffDays = Math.ceil(Math.abs(date2 - date1) / (1000 * 60 * 60 * 24));
                if (diffDays > 62) {
                    gettoast('top-right', 'toDate', 'Difference between two dates should not be greater than 60');
                    return false;
                }

            }

        }
        var company_code = $('#chkcompanycode').val();
        var chkbranchcode = $('#chkbranchcode').val();
        if (company_code == "AUKN" || chkbranchcode == "INCL") {
            var container_no = $('#container_no').val().trim();
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "" && container_no == "" && wildcardsearch == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        } else {
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "" && wildcardsearch == "" && order_references == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        }

        $("<input />").attr("type", "hidden")
            .attr("name", "limit")
            .attr("value", $('#pagination-length').find(":selected").text())
            .appendTo(e);
    }

    $("#popupshipper_country, #popupshipper_country").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseurl + "businesspartners/getcountrieslist",
                type: "POST",
                dataType: "json",
                data: {
                    country: request.term
                },
                success: function (data) {
                    if (data.length == 0) {
                        /* if(type == 'main'){
                           gettoast('top-right',id,'Please Enter Proper Country');
                         }else{*/
                        gettoast('top-right1', id, 'Please Enter Proper Country');
                        /*}*/

                        $('#' + popupshipper_country).val("");
                        return true;
                    } else {
                        response(data);
                    }
                }
            });
        },
    });
    $(".chkpopupcountry").each(function () {
        var id = $(this).attr('id');
        $('#' + id).autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: baseurl + "businesspartners/getcountrieslist",
                    type: "POST",
                    dataType: "json",
                    data: {
                        country: request.term
                    },
                    success: function (data) {
                        if (data.length == 0) {
                            /* if(type == 'main'){
                               gettoast('top-right',id,'Please Enter Proper Country');
                             }else{*/
                            gettoast('top-right1', id, 'Please Enter Proper Country');
                            /*}*/

                            $('#' + id).val("");
                            return true;
                        } else {
                            response(data);
                        }
                    }
                });
            },

        });
    });
    function validatetrip(){
        var carrier = $('#tcarrierid').val();
        var vehicletype = $('#tpvehicle_type').val();
        if(carrier == 277 && vehicletype == ''){
            gettoast('top-right','tpvehicle_type','Please Select Vehicle Type');
            return false;
        }
    }
    var company_code = "<?= $this->session->userdata('company_code');?>";
    if(company_code == 'RUKN'){
        var incoterm = "";
        $.ajax({
            url: baseurl+'orders/getdeliverytermvalue',
            type: 'POST',
            dataType: 'json',
            data: {
                incoterm : incoterm,
            },
            success: function(data) {
                var htm ="<option value=''>Select</option>";
                if(data.length >0){
                    $.each(data,function(key,value){
                        htm +="<option value='"+value.id+"'>"+value.name+"</option>";
                    });
                }
                $('#popupdelivery_terms').html(htm);
            }
        });
    }else{
        $('#incoterm_popup').on('change',function(){
            var incoterm = $(this).val();
            $.ajax({
                url: baseurl+'orders/getdeliverytermvalue',
                type: 'POST',
                dataType: 'json',
                data: {
                    incoterm : incoterm,
                },
                success: function(data) {
                    var htm ="<option value=''>Select</option>";
                    if(data.length >0){
                        $.each(data,function(key,value){
                            htm +="<option value='"+value.id+"'>"+value.id+" "+value.name+"-"+value.incoterm+"</option>";
                        });
                    }
                    $('#popupdelivery_terms').html(htm);
                }
            });
        });
    }

    function filetrasnferfor_selectedorders(){
            $("input:checkbox[name=chck1]:checked").each(function () {
                ids.push({
                    'ids': $(this).attr("id")
                })
            });
            if (ids.length == 0) {
                gettoast('top-right', '', 'Please Select any Order');
                return false;
            } else {
                $.ajax({
                    url: baseurl + 'Sendmultipleaconedi/filetrasnferfor_selectedorders',
                    type: "POST",
                    dataType: 'json',
                    data: {'order_ids': ids},
                    beforeSend: function () {
                        var table = $('#filetransfersucces_list').DataTable();
                        table.destroy();
                        $('#file_tranfer_succeslist').modal('show');
                        $('.filetransfersucces_list-body').html('<tr><td colspan="2" align="center"><img id="gif"  src="<?= base_url();?>assets/images/482.gif"></td></tr>');
                    },
                    success: function (data) {
                       $("#filetransfersucces_list").DataTable({
                            data: data,
                            "bPaginate": true,
                            "paging": true,
                            "bLengthChange": true,
                            "bFilter": true,
                            "bInfo": false,
                            "bAutoWidth": true,
                            "language": {
                                "lengthMenu": '<select class="form-control">' +
                                        '<option value="10">10</option>' +
                                        '<option value="20">20</option>' +
                                        '<option value="30">30</option>' +
                                        '<option value="40">40</option>' +
                                        '<option value="50">50</option>' +
                                        '<option value="-1">All</option>' +
                                        '</select>'
                            },
                            dom: 'Blfrtip',
                            buttons: [
                                'copyHtml5',
                                'excelHtml5',
                                'csvHtml5',
                                'pdfHtml5',
                                'print'
                            ],
                            "columns": [
                                {"data": "id"},
                                {"data": "status"},
                            ]
                        });

                    },error: function (errMsg) {
                        $(".filetransfersucces_list-body").html('<tr><td colspan="2" align="center">Something Went Wrong</td></tr>');
                    }
                });
            }
    }

    function readytoinvoiceforselected(e){
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids':$(this).attr("id")
            })
        });
        if(ids.length==0){
            gettoast('top-right','','Please Select any Order');
            return false;
        }else{
            var table = $('#ready_invoice_tb').DataTable();
            table.destroy();
            $('#readyinvoice_show_data').html('');
            $.ajax({
                url:baseurl+'orderrevenues/makeselectedasinvoice',
                type:"POST",
                dataType:'json',
                data:{'order_ids':ids,'fromdate':from_date},
                beforeSend: function () {
                    $('#readyinvoice_show_data').html('');
                    $('.pop_message_load').html('Please wait..!');
                    $("#ready_invoice").modal('show');
                    // $(".pop_message").html('Please Wait !!');
                },
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    console.log(data);
                    $('.pop_message_load').html('');
                    $("#ready_invoice_tb").DataTable({
                        data: data,
                        "bPaginate": true,
                        "paging": true,
                        "bLengthChange": true,
                        "bFilter": true,
                        "bInfo": false,
                        "bAutoWidth": true,
                        "language": {
                            "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                        },
                        dom: 'Blfrtip',
                        buttons: [
                            'copyHtml5',
                            'excelHtml5',
                            'csvHtml5',
                            'pdfHtml5',
                            'print'
                        ],
                        "columns": [
                            // {"data": "check"},
                            {"data": "id"},
                            {"data": "recipient_role"},
                            {"data": "JFR"},
                            {"data": "message"},
                            {"data": "status"},
                        ],
                    });
                }
            });
        }

    }
    function readytoinvoiceknbill(e){
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids':$(this).attr("id")
            })
        });
        if(ids.length==0){
            gettoast('top-right','','Please Select any Order');
            return false;
        }else{
            $.ajax({
                url:baseurl+'aconedi/index',
                type:"POST",
                data:{'order_ids':ids,'fromdate':from_date},
                beforeSend: function() {
                    $(".containerModal").modal("show");
                    $(".containerModal").find(".modal-title").html("Please Wait...");
                    $(".containerModal").find(".modal-body").html("<center><progress></center>");
                },
                success:function(data){
                    var data = JSON.parse(data);
                    $(".containerModal").modal("hide");
                    if((data.revenue_count > 0) || (data.accural_count > 0)){
                        $(".pop_message").html('EDI Sent to KNbill Successfully');
                    }else{
                        $(".pop_message").html('No charges Found');
                    }
                    $("#insert_success_div").modal('show');
                },
                error: function(errMsg) {
                    $(".pop_message").html('Oops! Something went wrong');
                    $("#insert_success_div").modal('show');

                }
            });
        }

    }

    function isNonSpecialCharCheck(e)
    {
        var keynum;
        var keychar;
        var numcheck;
        // For Internet Explorer
        if (window.event)
        {
            keynum = e.keyCode;
        }
        // For Netscape/Firefox/Opera
        else if (e.which)
        {
            keynum = e.which;
        }
        keychar = String.fromCharCode(keynum);
        //List of special characters you want to restrict
        if (keychar == "'" || keychar == "`" || keychar == "~" || keychar == "+"
            || keychar == "/"  || keychar == "\/" || keychar == "//" || keychar == "\\"
            || keychar == "<" || keychar == ">" || keychar == "^" || keychar == "|")
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    $(document).ready(function(){
        var from_date = $('#fromDate').val();
        if(from_date != ''){
            var date_array = from_date.split("-");
            var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#toDate').datepicker('setStartDate', minDate);
        }
        var advfrom_date = $('#advfrom_date').val();
        if(advfrom_date != ''){
            var date_array = advfrom_date.split("-");
            var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#advto_date').datepicker('setStartDate', minDate);
        }

		<?php /*if ("VNKN" === $this->session->userdata( 'company_code' )):*/ ?>
            var advpickupfrom_date = $('#advpickupfrom_date').val();
            if(advpickupfrom_date != ''){
                var date_array = advpickupfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advpickupto_date').datepicker('setStartDate', minDate);
            }

            var advdeliveryfrom_date = $('#advdeliveryfrom_date').val();
            if(advdeliveryfrom_date != ''){
                var date_array = advdeliveryfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advdeliveryto_date').datepicker('setStartDate', minDate);
            }
        <?php /*endif;*/ ?>
    });

    $('#fromDate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#toDate').datepicker('setStartDate', minDate);
    });
    $('#toDate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#fromDate').datepicker('setEndDate', maxDate);
    });

    $('#advfrom_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#advto_date').datepicker('setStartDate', minDate);
    });
    $('#advto_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#advfrom_date').datepicker('setEndDate', maxDate);
    });

	  <?php /*if ("VNKN" === $this->session->userdata( 'company_code' )):*/ ?>
        $('#advpickupfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advpickupto_date').datepicker('setStartDate', minDate);
        });
        $('#advpickupto_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advpickupfrom_date').datepicker('setEndDate', maxDate);
        });


        $('#advdeliveryfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advdeliveryto_date').datepicker('setStartDate', minDate);
        });
        $('#advdeliveryto_date').datepicker({
            format: 'dd-mm-yyyy',
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advdeliveryfrom_date').datepicker('setEndDate', maxDate);
        });

    <?php /*endif;*/ ?>

    $(document).ready(function(){
        var company_code = "<?= $this->session->userdata('company_code');?>";
        if(company_code == "INKN"){
            $("#popupshipper_zipcode").on('change', function() {
                if($(this).val() != ""){
                    $.ajax({
                        url: baseurl+'live/getcovidstatusbypincode',
                        type:"POST",
                        dataType:'JSON',
                        data:{'pincode':$(this).val()},
                        beforeSend:function(){
                            $(".covid19pickupstatus").html("");
                        },
                        success:function(data){
                            console.log(data);
                            if(data.status == 200){
                                var data1 = data.data;
                                var covid19 = data1[0];
                                if(covid19['containmentsAvailability']){
                                    var msg = "";
                                    /*if(covid19['city']){
                                     msg += "<strong>City:</strong> "+covid19['city']+"<br/>";
                                    }else{*/
                                    msg += "<strong>City:</strong> "+covid19['district']+"<br/>";
                                    /*}*/
                                    /*if(covid19['name']){
                                     msg += "<strong>Area:</strong> "+covid19['name']+"<br/>";
                                    }else{*/
                                    msg += "<strong>Area:</strong> "+covid19['containmentZoneName']+"<br/>";
                                    /*}*/
                                    /*if(covid19['zoneType']){
                                     msg += "<strong>Zone Type:</strong> "+covid19['zoneType']+"<br/>";
                                     var dzone = covid19['zoneType'];
                                    }else{*/
                                    var zonetype = "NA";
                                    if(covid19['districtCurrentActive'] != "NA"){
                                        zonetype = covid19['districtCurrentActive'];
                                    }
                                    msg += "<strong>Total Confirmed:</strong> "+covid19['districtTotalConfirmed']+"<br/>";
                                    msg += "<strong>Current Active:</strong> "+covid19['districtCurrentActive']+"<br/>";
                                    var dzone = zonetype;
                                    /*}*/
                                    var cvcolor = "#FF0000";
                                    if(dzone == "Green Zone"){
                                        cvcolor = "#008000";
                                    }else if(dzone == "Containment Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "Orange Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "NA"){
                                        cvcolor = "#008000";
                                    }else if(dzone > 100){
                                        cvcolor = "#FFA500";
                                    }
                                    msg += "<strong>Map View:</strong> <a href='"+baseurl+"live/covid19map/"+data.lat+"/"+data.lng+"/"+dzone+"' title='Zone in Map View' target='_blank'><span class='fa fa-map-marker' aria-hidden='true' style='color:"+cvcolor+";'></span></a>";
                                    $(".covid19pickupstatus").html(msg);
                                }
                            }
                        }
                    });
                }
            });
            $("#popupconsignee_zipcode").on('change', function() {
                if($(this).val() != ""){
                    $.ajax({
                        url: baseurl+'live/getcovidstatusbypincode',
                        type:"POST",
                        dataType:'JSON',
                        data:{'pincode':$(this).val()},
                        beforeSend:function(){
                            $(".covid19deliverstatus").html("");
                        },
                        success:function(data){
                            console.log(data);
                            if(data.status == 200){
                                var data1 = data.data;
                                var covid19 = data1[0];
                                if(covid19['containmentsAvailability']){
                                    var msg = "";
                                    /*if(covid19['city']){
                                     msg += "<strong>City:</strong> "+covid19['city']+"<br/>";
                                    }else{*/
                                    msg += "<strong>City:</strong> "+covid19['district']+"<br/>";
                                    /*}*/
                                    /*if(covid19['name']){
                                     msg += "<strong>Area:</strong> "+covid19['name']+"<br/>";
                                    }else{*/
                                    msg += "<strong>Area:</strong> "+covid19['containmentZoneName']+"<br/>";
                                    /*}*/
                                    /*if(covid19['zoneType']){
                                     msg += "<strong>Zone Type:</strong> "+covid19['zoneType']+"<br/>";
                                     var dzone = covid19['zoneType'];
                                    }else{*/
                                    var zonetype = "NA";
                                    if(covid19['districtCurrentActive'] != "NA"){
                                        zonetype = covid19['districtCurrentActive'];
                                    }
                                    msg += "<strong>Total Confirmed:</strong> "+covid19['districtTotalConfirmed']+"<br/>";
                                    msg += "<strong>Current Active:</strong> "+covid19['districtCurrentActive']+"<br/>";
                                    var dzone = zonetype;
                                    /*}*/
                                    var cvcolor = "#FF0000";
                                    if(dzone == "Green Zone"){
                                        cvcolor = "#008000";
                                    }else if(dzone == "Containment Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "Orange Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "NA"){
                                        cvcolor = "#008000";
                                    }else if(dzone > 100){
                                        cvcolor = "#FFA500";
                                    }
                                    msg += "<strong>Map View:</strong> <a href='"+baseurl+"live/covid19map/"+data.lat+"/"+data.lng+"/"+dzone+"' title='Zone in Map View' target='_blank'><span class='fa fa-map-marker' aria-hidden='true' style='color:"+cvcolor+";'></span></a>";
                                    $(".covid19deliverstatus").html(msg);
                                }
                            }
                        }
                    });
                }
            });
        }
    });
    
    let deleteOrderId = null;
    function deleteorderbyid(orderid){
    $('#deleteConfirmModal').modal('show');
    $('#confirmDeleteBtn').off('click').on('click', function() {
            $.ajax({
                url:baseurl+'orders/deleteorder/'+orderid,
                type:"GET",
                success:function(){
                    location.reload();
                }
            });
        });
        
    }
    /*function deleteorderbyid(orderid){
        var x = confirm("Are you sure you want to delete this Order?");
        if (x){
            $.ajax({
                url:baseurl+'orders/deleteorder/'+orderid,
                type:"GET",
                success:function(){
                    location.reload();
                }
            });
        }else{
            return false;
        }
    }*/
     $('#toldcarrierid').on('change', function() {
        var id=$("#tcarrierid").val();
        if(id==''){
            $("#nccode").val('');
            return false;
        }
        $.ajax({
            url: baseurl+'orders/gettripcarinfo/'+id,
            type:"POST",
            dataType:'JSON',
            success:function(data){
                $(".tripcar_name").val(data.carrier_name);
                $("#tdrivespan").html(data.drivers);
            }
        });
    });
    $('#tcarrierid').on('change', function() {
        var id=$("#tcarrierid").val();
        if(id==''){
            $("#nccode").val('');
            return false;
        }
        $.ajax({
            url: baseurl+'orderrevenues/getVehicleDetailsByCarrierInfo',
            type:"POST",
            data:{carrierId:id},
            dataType:'JSON',
            success:function(data){
                vehicles = data.vehicles;
                $(".tripcar_name").val(data.carrierCode);
                var htm ="<option value=''>Select</option>";
                var driverHtm = "<option value=''>Select</option>";
                if(vehicles.length >0){
                    $.each(vehicles,function(key,value){
                        htm +="<option value='"+value.id+"'>"+value.register_number+"</option>";
                    });
                }
                $('#tvehnum').html(htm);
                $('#tdri_name').html(driverHtm);
            }
        });
    });
    $('#tpoldvehicle_type').on('change', function() {
        var id=$("#tpvehicle_type").val();
        if(id!=''){
            var carrierid=$('#tcarrierid').val();
            $("#tvehid").val('');
            if(carrierid==''){
                $("#dialog").dialog();
                $(".ui-dialog").addClass('alert_zindex');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog-text").text("Please select carrier details");
                return false;
            }
            $.ajax({
                url: baseurl+'orders/gettripvelinfo',
                type:"POST",
                data: {
                    carrierid : carrierid,vtype : id,
                },
                dataType:'JSON',
                success:function(data){
                    $("#tpveh_typename").val(data.typename);
                    $("#tpveh_numdiv").html(data.vehiclenum);
                }
            });
        }else{
            $("#tpveh_typename").val('');
            return false;
        }

    });
    $('#tvehnum').on('change',function(){
        var vehicle_num = $( "#tvehnum option:selected" ).val();
        var carrier_id = $('#tcarrierid').val();
        if(vehicle_num == ""){
            $('#tcarrierid').trigger("change");
        }else{
            var carrier_id = $("#tcarrierid option:selected").val();
            var register_number = $( "#tvehnum option:selected" ).html();
            $('#tvehid').val(register_number);
            $.ajax({
            url:baseurl+"shipmentplan/getdriversbyvendor",
            type:"POST",
            data:{'carrier_id': carrier_id},
            dataType:"JSON",
            success:function(data){
                if(data['drivers'].length==0){
                    $("#tdri_name").html("<option value=''>-Driver(s) not found-</option>");
                }else{
                    $("#tdri_name").html("<option value=''>-select-</option>");
                }
                $.each(data["drivers"],function(i,value){
                    var sts = "";
                    $("#tdri_name").append("<option  value='"+value.id+"'> "+value.name+" </option>");
                });
            }
        });
        }
    })
    $('#tpvehicle_type').on('change', function() {
        var id=$("#tpvehicle_type").val();
        if(id!=''){
            var carrierid=$('#tcarrierid').val();
            $("#tvehid").val('');
            if(carrierid==''){
                $("#dialog").dialog();
                $(".ui-dialog").addClass('alert_zindex');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog-text").text("Please select carrier details");
                return false;
            }
            $.ajax({
                url: baseurl+'orderrevenues/getVehicleDetailsByCarrierInfo',
                type:"POST",
                data: {
                    carrierId : carrierid,vehicleType : id,
                },
                dataType:'JSON',
                success:function(data){
                    var vehicleTypeName = data.vehicleTypeName;
                    if(vehicleTypeName != ""){
                        $("#tpveh_typename").val(vehicleTypeName);
                    }
                    vehicles = data.vehicles;
                    var htm ="<option value=''>Select</option>";
                    if(vehicles.length >0){
                        $.each(vehicles,function(key,value){
                            htm +="<option value='"+value.id+"'>"+value.register_number+"</option>";
                        });
                      }
                    $('#tvehnum').html(htm);
                }
            });
        }else{
            $("#tpveh_typename").val('');
            return false;
        }
    });
    function myfun(){
        var id=$("#tvehnum").val();
        if(id!=''){
            $.ajax({
                url: baseurl+'orders/getvelinfo/'+id,
                type:"POST",
                dataType:'JSON',
                success:function(data){
                    if(data.transit==1){
                        $("#tvehid").val('');
                        $("#dialog").dialog();
                        $(".ui-dialog").addClass('alert_zindex');
                        $('.ui-dialog-title').addClass('fa fa-warning');
                        $("#dialog-text").text("Vehicle already in Transit Mode, Please select another Vehicle");
                        var id=$("#tpvehicle_type").val();
                        var carrierid=$('#tcarrierid').val();
                        if(carrierid==''){
                            $("#dialog").dialog();
                            $(".ui-dialog").addClass('alert_zindex');
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $("#dialog-text").text("Please select carrier details");
                            return false;
                        }
                        $.ajax({
                            url: baseurl+'orders/gettripvelinfo',
                            type:"POST",
                            data: {
                                carrierid : carrierid,vtype : id,
                            },
                            dataType:'JSON',
                            success:function(data){
                                $("#tpveh_typename").val(data.typename);
                                $("#tpveh_numdiv").html(data.vehiclenum);
                            }
                        });
                        return false;
                    }else{
                        $("#tvehid").val(data.vehid);
                    }
                }
            });
        }else{
            $('#tvehid').val('');
            return false;
        }
    }
    function getdrid(){
        var vehicle_num = $( "#tvehnum option:selected" ).val();
        if(vehicle_num == ""){
            $('#tcarrierid').trigger("change");
        }else{
            var id=$("#tdri_name").val();
            if(id!=""){
                $.ajax({
                    url: baseurl+'orders/getdriverid/'+id,
                    type:"POST",
                    success:function(data){
                        $("#tdri_id").val(data);
                    }
                });
            }else{
                $('#tdri_id').val('');
                return false;
            }
        }
    }
    function applyconsolidation(e,branch) {
        var ids = [];
        var consolidation_id = $("#consolidation_id").val();
        $("input:checkbox[name=chck1]:checked").each(function() {
            var found = $.inArray($(this).attr("id"), ids);
            if (found >= 0) {
                ids.splice(found, 1);
            } else {
                ids.push($(this).attr("id"));
            }
        });
        var validate = 0;
        if (ids.length > 0) {
          validate = validateconsolidation(ids, e);
        }
        if (consolidation_id.length == 0) {
            gettoast('top-right1', 'select2-consolidation_id-container', 'Select Consolidation Rule');
            return false;
        } else if (ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Order');
            return false;
        }else if (ids.length > 1000) {
            gettoast('top-right', '', 'Too many orders were selected, please adjust your search. Up to 1000 orders could be selected for consolidation.');
            return false;
        }else if (validate == 1) {
            gettoast('top-right', '', 'There are orders which were not allocated to a trips. Please adjust your search or allocate all orders to trips');
            return false;
        }else if (validate == 2 && branch == 0) {
            $("#consolidation_modal").modal("hide");
            $("#insert_success_div").modal('show');
            $('.hide_popbutton').hide();
            $('.show_popbutton').show();
            $(".pop_message").html('Different Clients were selected.Do you want to continue?');
        } else {
            $.ajax({
                url: baseurl + 'Consolidation/applyconsolidation',
                type: "POST",
                dataType: 'json',
                data: {
                    'order_ids': ids,'consolidation_id':consolidation_id
                },
                beforeSend: function() {
                    $("#consolidation_modal").modal("hide");
                    $(".containerModal").modal("show");
                    $(".containerModal").find(".modal-title").html("Consolidation is on progress..");
                    $(".containerModal").find(".modal-body").html("<center><progress></center>");

                },
                success: function(data) {
                    if (data == 0) {
                        var msg = 'Consolidation rule UOM not found in GeoTiers';
                    }else if (data == 1) {
                        var msg = 'Orders not found for Consolidation';
                    }
                    else if (data == 2) {
                        var msg = 'Charges lines not found for Consolidation';
                    }else if (data == 6) {
                        var msg = 'Grouped orders not found';
                    }else if (data == 7) {
                        var msg = 'Consolidation rule UOM doesnt match with GeoTiers UOM';
                    }else if (data == 10) {
                        var msg = 'Consolidation applied successfully!';
                    }else{
                        var msg = 'Consolidation not possible';
                    }
                    $(".containerModal").modal("hide");
                    $("#consolidation_modal").modal("hide");
                    $(".pop_message").html(msg);
                    $('.hide_popbutton').show();
                    $('.show_popbutton').hide();
                    $("#insert_success_div").modal('show');
                },
                error: function(errMsg) {
                    $(".containerModal").modal("hide");
                    $(".pop_message").html('Oops! Something went wrong');
                    $('.hide_popbutton').show();
                    $('.show_popbutton').hide();
                    $("#insert_success_div").modal('show');
                }
            });
        }
    }
    function validateconsolidation(ids, e) {
      var data;
        $.ajax({
            url: baseurl + 'Consolidation/validateconsolidation',
            async: false,
            type: "POST",
            data: {
                    'order_ids': ids
                },
            dataType: 'JSON',
            success: function (resp) {
                data = resp;
            }
        });
        return data;
        }

    $('#select2-consolidation_id-container').keypress(function() {

        if ($('#select2-consolidation_id-container').hasClass('errorclass')) {

            $('#select2-consolidation_id-container').removeClass('errorclass');

        }

    });
    $('#select2-consolidation_id-container').click(function() {

        if ($('#select2-consolidation_id-container').hasClass('errorclass')) {

            $('#select2-consolidation_id-container').removeClass('errorclass');

        }

    });
</script>
<script type="text/javascript">
    function importFromGSheets() {
        window.location = '<?= base_url('gdocs/selectFile');?>';
    }
    var company_code = $('#chkcompanycode').val();
    $('#buttonid').on('click',function(){
        if(company_code == "IDKN"){
            $("#indexlfile").click();
        }
        else if (company_code == "KNAU") {
            $("#indexaufile").click();
        }
        else{
            $("#exlfile").click();
        }
    });
    $('#buttonsgid').on('click',function(){
        /*$("#exlsgfile").click();*/
        $("#exlsgupfile").click();
    });
    $('#buttoncargoid').on('click',function(){
        $("#exlcargoupfile").click();
    });
    
    $('#buttonclid').on('click', function () {
        $("#exlclupfile").click();
    });
    
    $('#buttoninid').on('click',function(){
        /*$("#exlsgfile").click();*/
        $("#exlinupfile").click();
    });
    $('#buttoncostid').on('click',function(){
        $("#exlcostfile").click();
    });
    $(document).ready(function(){
        $(".datetimepicker").datetimepicker({
            format:"Y-m-d H:i:s",
            /* minDate : 0,
             minTime: 0,*/
            autoclose: true,
        });
    });
    $('.closevalues').click(function(){
        $('.quickbookform').val("");
        $('#shipper_details').html("");
        $('#consignee_details').html("");
        var company_code = "<?= $this->session->userdata('company_code');?>";
        var branch_code = "<?= $this->session->userdata('branch_code');?>";
        $('#popupcompany_code').val(company_code);
        $('#popupbranch_code').val(branch_code);
        var custid = "<?= $this->session->userdata('cust_id');?>";
        if(custid == ""){
            $('#customer_details').html("");
            $('#popupcustomer_id').val("");
        }

    });
    popupheight.oninput = function() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_height = height;
        $('#mainpopupheight').val(main_height);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        if(height != "" && width != "" && length != ""){
            var volume= length * width * height;
            $('#popupvolume').val(volume);
        }
    }; popupweight.oninput = function() {

        var weight =$('#popupweight').val();
        var quantity = $('#popupquantity').val();
        var main_weight = weight;
        $('#mainpopupweight').val(main_weight);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");

    };
    popupwidth.oninput = function() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_width = width;
        $('#mainpopupwidth').val(main_width);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        if(height != "" && width != "" && length != ""){
            var volume= length * width * height;
            $('#popupvolume').val(volume);
        }
    };
    function changepopupbylength() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        var quantity = $('#popupquantity').val();
        var main_length = length;
        $('mainpopuplength').val(main_length);
        if(height != "" && width != "" && length != ""){
            var volume = length * width * height;
            $('#popupvolume').val(volume);
        }

    }

    function sendorderdetailsclick(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 1) {
            /*   $('.order-tabs').removeClass('active');
               $('#order-details').addClass('active');
               $('.tab-pane').removeClass('active');
               $('#details').addClass('active')*/

            var id = ids[0]['ids'];
            $.ajax({
                url: baseurl + 'orders/getorderdetails/' + id,
                beforeSend: function () {
                },
                success: function (data) {
                    //  $('#bodyDataDiv').html(data);
                }
            });
        }
    }

    function checkpopuppurchaseordervalue() {
        var val = $('#purchaseorder_popup').val();
        var customer_id = $('#popupcustomer_id').val();
        $.ajax({
            url: baseurl+'orders/checkpurchaseordervalue',
            type: 'POST',
            dataType: 'json',
            data: {'purchase_order' : val,'customer_id':customer_id},
            success: function(data){
                if(data == 1){
                    /*$("#dialog").dialog();
                    $('.ui-dialog-title').addClass('fa fa-warning');
                     $(".ui-dialog").addClass('alert_zindex');
                    $("#dialog-text").html("Purchase Order already exist with another order");
                    $('.ui-dialog-titlebar-close').click(function(){*/
                    $('#purchaseorder_popup').val('');
                    // $('#purchaseorder_popup').focus();
                    gettoast('top-right1', 'purchaseorder_popup', 'Purchase Order already exist with another order');
                    /* });*/
                }
            }
        });
    }

    function addreferenceforquickbook(e){
        e.preventDefault();

        $('#popupref_row_id').val('');
        $('.popupref').val("");
        $("#create_popupreference").modal('show');
    }
    function viewmodaleclose(id){
        $('#'+id).modal('hide');
    }
    function changepopupdimensions(ele){
        var count = $(ele).val() * 1;
        if(count >= '1'){
            var plength = $('#popuplength').val();
            var pwidth = $('#popupwidth').val();
            var pheight = $('#popupheight').val();
            var pweight = $('#popupweight').val();
            var weight = pweight * count;
            /*  var length = plength * count;
              var width = pwidth * count;
              var height = pheight * count;
             */
            /*$('#popuplength').val(length);
            $('#popupwidth').val(width);
            $('#popupheight').val(height);*/
            $('#popupweight').val(weight);

            var volume = plength * pwidth * pheight * count;
            $('#popupvolume').val(volume);
        }

    }

    $('.checkAll').on('click', function() {
        if (this.checked == true)
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', true);
        else
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', false);
    });
    /* pallet add model pop */
    function palletadd(id){
        $('#order_row_id').val(id);
        $('#Modal_Add').modal('show');
    }
    /* Advanced search reference type validation */
    function checkreference(e){
        var order_reftype = $('#order_reftype').val();
        var ref_val = $('#ref_val').val();

        if(order_reftype != ""){
            if(ref_val == ""){
                gettoast('top-right','ref_val','Please Enter reference Value');
                return false;
            }
        }
        $("<input />").attr("type", "hidden")
            .attr("name", "limit")
            .attr("value", $('#pagination-length').find(":selected").text())
            .appendTo(e);
    }

    $(document).ready(function(){
        <?php if(isset($_SESSION['download_files'])){ ?>
        var link = document.createElement('a');
        <?php  foreach($_SESSION['download_files'] as $file){ ?>
        link.style.display = 'none';
        var value = "<?= $file?>";
        document.body.appendChild(link);
        link.setAttribute('download', value);
        var downloadurl = baseurl+'assets/manifestdocs/'+value;
        link.setAttribute('href', downloadurl);
        link.click();
        <?php } ?>
        document.body.removeChild(link);
        <?php unset($_SESSION['download_files']); } ?>
    });
    /*cancel shipment confirm message*/
    function checkcancelconfirm(){
        if (confirm('Are you sure to cancel this trip?')){
            return true;
        }else{
            return false;
        }
    }
    function checktriprevertconfirm(){
        if (confirm('Are you sure to Revert this trip?')){
            return true;
        }else{
            return false;
        }
    }
</script>
<link href="<?= base_url() ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css" />
<script src="<?= base_url() ?>assets/newtheme/js/custom.js?v=1.1"></script>
<script src="<?= base_url() ?>assets/js/jquery-ui.js"></script>
<script src="<?= base_url() ?>assets/newtheme/js/main.js"></script>
<script src="<?= base_url() ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url() ?>assets/js/order_script.js?v=1.0"></script>

<style type="text/css">
 #cargobulkupload .modal-dialog {
        width: 30%;
        margin: 30px auto;
    }
    #cargobulkupload .modal-footer, {
        padding: 5px 15px;

    }
    #cargobulkupload .modal-body {
        position: relative;
        padding: 5px;
    }
    #cargobulkupload .modal-header {
        /*background-color: white;*/
    }
    .dataTables_empty{
        height: 30px;
    }
    #quickbook_popup {
        overflow-y:auto;

    }
    .select2-selection__choice{
        color: white;
    }
    .popupcargo_form {
        margin-bottom: 0px;
    }
    FIELDSET    { PADDING-TOP:0px; PADDING-BOTTOM:4px; BORDER:solid 1px #ccc;}
    LEGEND      {COLOR:black; FONT-WEIGHT:bold;font-size: 13px;}
</style>
<?php
    $auArray = array('AUKN','KNAU');
    if(in_array($this->session->userdata('company_code'),$auArray)){
        $labelUrl= base_url().'bulkOrderLabel/bulkMacpacLabels';
    }else{
         $labelUrl= base_url().'bulkOrderLabel/orderlabel';
    }
?>
<form method="POST" action="<?= $labelUrl; ?>" id="bulkLabelPdfForm">
    <input type="hidden" name="orderIds" id="bulkOrderArray">
</form>

<script>
function deleteselectedrecords()
{
    var selectedrecords = [];
    $('input.recordcheckbox:checkbox:checked').each(function () {
        selectedrecords.push($(this).val());
    });
    if(selectedrecords.length==0)
    {
        gettoast('top-right1', '', 'No records were selected for this operation');
        return false;
    }
    else{
        swal({
            title: 'Are you going to delete these records?',
            text: 'There will be no way to restore them. Would you like to continue',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'No, cancel !',
            closeOnConfirm: true,
            closeOnCancel: false
            }, function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    type:"post",
                    url:"<?= base_url('orders/deleteorders/');?>",
                    data:{deleteids:selectedrecords},
                    success:function(data)
                    {
                        location.reload();
                    },
                })
            }
            else {
                swal('Cancelled', 'Your record is safe :)', 'error');
            }
        });
    }
}

function disableOtherInputFields() {
    var url = baseurl + "orders/triporderintoshipment";
    var templateId = $('#templateId').val();
    if (templateId != "") {
        url = baseurl + "tripstemplate/storeShipmentByTemplate";
        $('.tripcreatefields').prop('disabled', true);
        $('#tcarrierid').attr('required', false);
    } else {
        $('.tripcreatefields').prop('disabled', false);
        $('#tcarrierid').attr('required', true);
    }
    $("#tripcreation").attr("action", url);
}

function sendShipmentStatusxml(e) {
    e.preventDefault();
    var ids = [];
    $("input:checkbox[name=chck1]:checked").each(function () {
        ids.push($(this).attr("id"));
    });
    if (ids.length == 0) {
        gettoast('top-right', '', 'Please select atleast one order');
    } else if (ids.length > 5) {
        gettoast('top-right', '', 'Maximum orders to be selected are 5');
    } else {
        $.ajax({
            url: baseurl + 'shipmentxmldata/sendOrderStatusXmlstoKNlogin',
            type: "POST",
            data: {'ids': ids},
            dataType: 'json',
            beforeSend: function () {
            },
            success: function () {
                location.href = baseurl + 'orders/orderslist/04';
            }
        });
    }
}

function checkDggoods(){
    if ($('#popupdg_goods').prop('checked') == true) {
        getDangerousGoodsDetails(0,0,0,1);
    }
}

let fileSelected = null;
$('#exlfile').off('change').on('change', function(){
    if (this.files.length > 0) {
        fileSelected = $(this);
        $('#uploadConfirmModal').modal('show');
    }
});
$('#confirmUploadBtn').off('click').on('click', function(){
    if (fileSelected) {
        fileSelected.closest('form').submit(); 
        $('#uploadConfirmModal').modal('hide');
        fileSelected = null;
    }
});
</script>
<script>
$('#exlcargoupfile').off('change').on('change', function(){
    if(this.files.length > 0){
        selectedUploadInput = $(this); 
        $('#uploadCargoModal').modal('show');
    }
});

$('#confirmUploadcargoBtn').off('click').on('click', function(){
    if(selectedUploadInput){
        $('#exlcargofile').submit();
        $('#uploadCargoModal').modal('hide');
    }
});

$('.checkAll').on('click', function() {
    $('.table').find('input[name="chck1"]').prop('checked', this.checked);
});
function optimizeCarrierTripForOrder(){
       $("#trip_creation").addClass("blurModal");
        $('#optimizeParametersPopup').modal('show');
    }

    function getIndividualRateCharges(rowId){
        var postData = $("#optPopupData").serializeArray();
        var radioData = $('#optimizeRatesRadioButton'+rowId);
        postData.push({name: 'rateServiceRowId', value: radioData.attr('data-rateServiceRowId')});
        postData.push({name: 'offeringRowId', value: radioData.attr('data-offeringRowId')});
        postData.push({name: 'rateOfferingId', value: radioData.attr('data-rateoffering')});
        postData.push({name: 'recordRowId', value: radioData.attr('data-recordRowId')});
        postData.push({name: 'rateRecordId', value: radioData.attr('data-raterecord')});
        postData.push({name: 'fuelSurchargePercentageAmount', value: radioData.attr('data-fuelSurchargePercentageAmount')});
        postData.push({name: 'fuelSurchargeFlatAmount', value: radioData.attr('data-fuelSurchargeFlatAmount')});
        postData.push({name: 'uomConversionId', value: radioData.attr('data-uomConversionId')});
        postData.push({name: 'fuelSurchargepercentage', value: radioData.attr('data-fuelSurchargepercentage')});
        postData.push({name:'rowId', value:rowId});
        $.ajax({
            url: baseurl+'OptimizeTripOrders/getIndividualRateCharges',
            type: "POST",
            data: postData,
            success:function(data){
                $('#individualChargesBody').html(data);
                $('#individualChargesPopup').modal('show');
                $("#optimizeTripPopup").addClass("blurModal");
            }
        });
    }
    $('.closeOptimizeTripPopup').on('click', function() {
        setTimeout(function() {
            $("#trip_creation").removeClass("blurModal");
        }, 500);
        $('#optimizeTripPopup').modal('hide');
        
    });
    $('.createTripButton').on('click', function() {
        const radioData = $('input[name=rateCharge]:checked');
        if(radioData.length  == 0){
            gettoast('top-right', '', 'Please select anyone');
        }else{
            var orderIds = $('#trip_orderid').val();
            var vehicleId = radioData.attr('data-vehicletype');
            var vendorId = radioData.attr('data-vendor');
             $.ajax({
                url: baseurl+'orders/triporderintoshipment/',
                type: "POST",
                data: {
                        ordid: orderIds,
                        trip_type: "single",
                        carrierid: vendorId,
                        vehicle_type: vehicleId,
                        ajaxCall: 1,
                        noVendorTrip: 1
                    },
                success:function(data){
                    if(data >0){
                        var postData = $("#optPopupData").serializeArray();
                        postData.push({name: 'tariffType', value: radioData.attr('data-tariffType')});
                        postData.push({name: 'code', value: radioData.attr('data-code')});
                        postData.push({name: 'name', value: radioData.attr('data-name')});
                        postData.push({name: 'rateServiceRowId', value: radioData.attr('data-rateServiceRowId')});
                        postData.push({name: 'offeringRowId', value: radioData.attr('data-offeringRowId')});
                        postData.push({name: 'rateOfferingId', value: radioData.attr('data-rateoffering')});
                        postData.push({name: 'recordRowId', value: radioData.attr('data-recordRowId')});
                        postData.push({name: 'rateRecordId', value: radioData.attr('data-raterecord')});
                        postData.push({name: 'fuelSurchargePercentageAmount', value: radioData.attr('data-fuelSurchargePercentageAmount')});
                        postData.push({name: 'fuelSurchargeFlatAmount', value: radioData.attr('data-fuelSurchargeFlatAmount')});
                        postData.push({name: 'uomConversionId', value: radioData.attr('data-uomConversionId')});
                        postData.push({name: 'fuelSurchargepercentage', value: radioData.attr('data-fuelSurchargepercentage')});
                        postData.push({name:'orderIds', value:orderIds});
                        $.ajax({
                            url: baseurl+'OptimizeTripOrders/addRatesToTripWithoutPreference',
                            type: "POST",
                            data: postData,
                            success:function(data){
                                location.reload();
                            }
                        });
                    }
                }
            }); 
        }
    });
    $('.closeOptimizeParametersPopup').on('click', function() {
        setTimeout(function() {
            $("#trip_creation").removeClass("blurModal");
        }, 500);
        $('#optimizeParametersPopup').modal('hide');
        $('.optimizeCarrierData').css({'display':'none'});
        $('.optimizePupupDropDowns').prop('selectedIndex', 0);
        
    });
    $('.closeIndividualChargesPopup').on('click', function() {
        $("#optimizeTripPopup").removeClass("blurModal");
        $('#individualChargesPopup').modal('hide');
    });
    $('#tariffTypeOptions').on('change', function() {
        var tariffType = $(this).val();
        if(tariffType == "BUY"){
            $('.optimizeCarrierData').css({'display':'block'});
        }else{
            $('.optimizeCarrierData').css({'display':'none'});
        }
        
    });
    $('#submitOptimizePopup').on('click', function() {
        var tariffType = $('#tariffTypeOptions').val();
        var carrierId = $('#optimizeCarrierId').val();
        var modeOfTransport = $('#optimizeMod').val();
        var orderIds = $('#trip_orderid').val();
        $.ajax({
            url: baseurl+'OptimizeTripOrders/prepareOptimizeTripList/',
            type: "POST",
            data: {'orderIds': orderIds,'tariffType':tariffType,'carrierId':carrierId,'modeOfTransport':modeOfTransport},
            success:function(data){
                $('#optimizeParametersPopup').modal('hide');
                $('#dynamicOptimizeBody').html(data);
                $('#optimizeTripPopup').modal('show');
                $('.optimizePupupDropDowns').prop('selectedIndex', 0);
                $('.optimizeCarrierData').css({'display':'none'});
            }
        });
  });
</script>
