<?php

use App\Libraries\OrderCreationSourceHelper;

$this->load->library('AtsService');
$atsservice = new AtsService();
$this->load->view($atsservice->get_ats_service());
$this->load->helper('required_marker');
$postData = $postData ?? [];
$rateServiceRowIdForBook = $postData['rateServiceRowIdForBook'] ?? 0;
$pickup_details = [];
if (!empty($postData)):
    $customerFromProfile = $postData['customerIdForBook'] ?? 0;
    $vendorFromProfile = $postData['vendorIdForBook'] ?? 0;
    if ($customerFromProfile > 0):
        $pickup_details['name'] = $postData['customerNameForBook'] ?? "";
        $pickup_details['party_id'] = $postData['customerCodeForBook'] ?? "";
        $customerCity = $postData['customerCityForBook'] ?? "";
        $customerState = $postData['customerStateForBook'] ?? "";
        $customerStreet = $postData['customerStreetForBook'] ?? "";
        $pickup_details['address'] = $customerStreet . "," . $customerCity . "," . $customerState;
        $pickup_details['country'] = $postData['customerCountryForBook'] ?? "";
        $pickup_details['pincode'] = $postData['customerPincodeForBook'] ?? "";
        $customerIdFromProfile = $postData['customerIdForBook'] ?? 0;
    endif;
    if ($vendorFromProfile > 0):
        $vendorIdFromProfile = $postData['vendorIdForBook'] ?? 0;
        $vendorCodeFromProfile = $postData['vendorCodeForBook'] ?? "";
    endif;
endif;
?>

<?php
if ($this->session->userdata('company_code') == 'NZKN') { ?>
    <style>
        .modal {
            z-index: 1001 !important;
        }

        .modal-backdrop {
            z-index: 1000 !important;
        }

        .pac-container {
            z-index: 1055 !important;
            width: auto !important;
        }

        .pac-container:after {
            /* Disclaimer: not needed to show 'powered by Google' if also a Google Map is shown */

            background-image: none !important;
            height: 0px;
        }

.modal-open .modal.insert_success_div#insert_success_div{
    z-index: 9999 !important;
}
</style>
 
   <?php } ?>
    
<link  href="<?= base_url(); ?>assets/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
   <?php if($this->session->userdata('company_code') == 'CNKN') { ?>
<style>
div.dataTables_wrapper div.dataTables_info{padding-top:8px;margin-right: 85px !important;white-space:nowrap}
.paginate_button.next {
    display: none !important;
}
.paginate_button {
    margin-right: 7px  !important;
}

.paginate_button.previous {
    display: none !important;
}
</style>
<?php } else { ?>
<style>
div.dataTables_wrapper div.dataTables_info{padding-top:8px;white-space:nowrap}
.paginate_button.next {
   display: inline-block !important;
}
.paginate_button.previous {
    display: inline-block !important;
}
</style>
<?php } ?>

<link href="<?= base_url() ?>assets/newtheme/css/appdev-style.css" rel="stylesheet" type="text/css" />
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <?php
        if($this->session->flashdata('success_msg'))
        {
            echo "<div class='flashmessages alert alert-success'>".$this->session->flashdata('success_msg')."</div>";
        }
        if($this->session->flashdata('error_msg'))
        {
            echo "<div class='flashmessages alert alert-danger'>".$this->session->flashdata('error_msg')."</div>";
        }
        if($this->session->flashdata('edierror_msg')) {
            echo ' <div class="alert alert-danger alert-dismissable"> <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.$this->session->flashdata('edierror_msg').'</div>';
            unset($_SESSION['edierror_msg']);
        }
        unset($_SESSION['success_msg']);
        unset($_SESSION['error_msg']);
        ?>
        <div class="container">
            <div class="row">
                <?php
                $transport = gettransportmode();

                $cust_id = "0";
                if($this->session->userdata('cust_id')){
                    $cust_id = $this->session->userdata('cust_id');
                    if($cust_id == ""){
                        $cust_id = "0";
                    }
                }
                $company_code = $this->session->userdata('company_code');
                $ordertypes = getOrderTypes($cust_id,$company_code);?>
                <!-- fillter section -->





            <div class="filtersHeader">

                <div class="filter-section pull-left ">
                    <div class="filter_icons borderRight">
                        <a href="<?php echo base_url(); ?>orders/neworder" data-toggle="modal" data-target="#addOrderModal" >
                            <span data-toggle="tooltip" data-placement="bottom" title="Add Booking" class="iconSvk icon-add-icon"></span>
                        </a>                          

                           <!-- <a href="" >
                            <span data-toggle="tooltip" data-placement="bottom" title="View Booking" class="iconSvk icon-view-icon"></span>
                        </a>
                        
                        <a href="">
                            <span data-toggle="tooltip" data-placement="bottom" title="Edit Booking" class="iconSvk icon-edit-icon"></span>
                            </a>

                        <a href="">
                            <span data-toggle="tooltip" data-placement="bottom" title="Delete Booking" class="iconSvk icon-delete-icon"></span>
                    </a>-->
                    </div>
                </div>

                <div class="filter-section pull-left">
                            <div class="filter_icons">
                                <div class="navbar pull-right">
                                    <a id="adv_filter" href="#" data-action="open" data-side="right" class="adv_filter">
                                    <span data-toggle="tooltip" data-placement="bottom" title="Filter" class="iconSvk icon-filter-icon"></span>
                                    </a>
                                    <div class="dropdown bcdropdown">
                                        <button class="dropbtn"><span class="iconSvk icon-list-icon"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="<?php echo base_url(); ?>orders/neworder" data-toggle="modal" data-target="#addOrderModal" ><i class="icon tru-icon-add"></i><?= $this->lang->line('new_order') ?></a>
                                            <a href="#" id="quickBookId" data-toggle="modal" data-target="#quickbook_popup"><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('quickbook') ?></a>
                                            <?php   $base_url = base_url();
                                            $company_code = $this->session->userdata('company_code');
                                            $country_code="";
                                            if($company_code=="KNAU"){
                                                $country_code=$company_code;
                                            }else{
                                                $country_code=substr($company_code, 0, 2);
                                            }
                                            $imglink = $base_url."assets/ordertemplate/ordertemplate.xlsx";
                                            $file = $base_url."assets/ordertemplate/".$country_code."-ordertemplate.xlsx";

                                            if(file_exists("assets/ordertemplate/".$country_code."-ordertemplate.xlsx")){
                                                $imglink =$file;
                                            }
                                            ?>
                                            <input type="hidden" name="chkcompanycode" id="chkcompanycode" value="<?= strtoupper($this->session->userdata('company_code')) ?>">
                                            <input type="hidden" name="chkbranchcode" id="chkbranchcode" value="<?= strtoupper($this->session->userdata('branch_code')) ?>">
                                            <a href="<?= $imglink ?>"><i class="icon tru-icon-template"></i><?= $this->lang->line('order_template') ?></a>
                                            <a href="#" id='buttonid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('upload_excel') ?></a>
                                            <!-- <a href="#"><i class="icon tru-icon-graph"></i><?= $this->lang->line('order_financial') ?></a> -->
                                            <form action="<?= base_url() ?>Excelimportorders/orderbooking"  id="excelform" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="import_file"  id="exlfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                            </form>
                                            <form action="<?= base_url() ?>Indorderexcelimport/orderExcelUpload"  id="excelform" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="import_file"  id="indexlfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                            </form>
                                            
                                            <form
                                                action="<?= base_url() ?>Macpacexcelimport/orderbooking"
                                                id="excelform" method="POST" enctype="multipart/form-data">
                                                <input type="file" name="import_file" id="indexaufile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <?php
                                            if (in_array($this->session->userdata('company_code'), ['THCL', 'THKN', 'RUKN'])): ?>
                                                <a href="<?= base_url() ?>assets/ordertemplate/CL-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('cl_template') ?></a>
                                                <a href="#"
                                                   id='buttonclid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upload_cl') ?></a>
                                                <form
                                                    action="<?= base_url() ?>Excelimportclorders/cladddata"
                                                    id="exlclfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlclupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                            <?php
                                            endif; ?>
                                            <?php
                                            $userCompanyCode = $this->session->userdata('company_code');
                                            if ($userCompanyCode == "PHKN") : ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/eTN_Milkrun_tmpl.xlsx"><i
                                                        class="icon tru-icon-template"></i>eTN_Milkrun_tmpl</a>
                                                <a href="#" id='buttonsgid'><i class="icon tru-icon-excel"></i>Upload eTN_Milkrun_tmpl</a>
                                                <form action="<?= base_url() ?>Excelimportclorders/uploadmilkrunexcel" id="exlsgfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlsgupfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none">
                                                </form>
                                            <?php
                                            endif; ?>
                                            <?php if($this->session->userdata('company_code') == 'INKN') { ?>
                                                <a href="#" id='buttoninid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('kninbkg_upld') ?></a>
                                                <form action="<?= base_url() ?>Ordertripexcel/uploadinexcel"  id="exlsgfile" method="POST" enctype="multipart/form-data" >
                                                    <input type="file"  name="import_file" id="exlinupfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                                </form>
                                            <?php  } 
                                            if ($this->session->userdata('company_code') == 'INFD'): ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/ManualPlanning-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('mdt_template'); ?></a>
                                                <a href="#"
                                                   id='buttonsgid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upd_mdt'); ?></a>
                                                <form
                                                    action="<?= base_url(); ?>Excelimportorders/uploadsgexcel"
                                                    id="exlsgfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlsgupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                             
                                            <?php
                                            endif; ?>
                                            <a href="#" onclick="importFromGSheets();"><i class="icon tru-icon-excel"></i> <?= $this->lang->line('import_gsheets') ?></a>
                                            <a href="#" onclick="generateBulkLabel(event);"><i class="icon tru-icon-pdf"></i> <?= $this->lang->line('generate_bulk_label'); ?></a>
                                            <a href="#" onclick="newtripcreate(event);"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('trip_create') ?></a>
                                            <?php // if($this->session->userdata('company_code') == 'INKN' || $this->session->userdata('company_code') == 'AUKN') { ?>
                                            <!--<a href="#" onclick="newtripcreate(event,'multi');"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('trip_create').' '.$this->lang->line('bill_bulk') ?></a>-->
                                            <?php // } ?>
                                            <!--<a href="#" onclick="sendorderdetailsclick(event);"><i class="glyphicon glyphicon-plus"></i>  <?= $this->lang->line('roadlog') ?></a>-->
                                            <!-- <a href="#" onclick="generateaconedi(event);"><i class="glyphicon glyphicon-plus"></i>  Send To KNBilling</a> -->
                                            <!-- <a href="#" onclick="checkdebitorandacon(event);"><i class="glyphicon glyphicon-plus"></i>  Send To KNBilling</a> -->

                                            <!--<a href="#" onclick="shipmentxmlclick(event)"><i class="glyphicon glyphicon-hand-up"></i> <?= $this->lang->line('kn_login') ?></a>
                                            <a href="#" onclick="sendShipmentStatusxml(event)"><i class="fa fa-hourglass-start" aria-hidden="true"></i> <?= $this->lang->line('leftmenu_status') . " " . $this->lang->line('to') . " " . $this->lang->line('kn_login') ?></a>-->
                                            <a href="<?= base_url('bulkupload') ?>"><i class="icon tru-icon-excel"></i><?= $this->lang->line('general_bulkupload') ?></a>
                                            <?php if($company_code == 'AUKN' ||$company_code == "KNAU"){ ?>
                                                <a href="#" onclick="manifestwithtrip(event);"><i class="icon tru-icon-pdf"></i>  <?= $this->lang->line('generate_manifest') ?></a>
                                            <?php } ?>
                                            <a href="<?= base_url() ?>assets/cargo_update.xlsx"><i class="icon tru-icon-template"></i>Cargo Update Template</a>
                                            <a href="<?= base_url('orderlistspecification') ?>"><i
                                                    class="glyphicon glyphicon-hand-up"></i><?= $this->lang->line('order_list_spec') ?></a>
                                            <a href="#" id='buttoncargoid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('cargo_update') ?></a>
                                            <form action="<?= base_url() ?>Ordercargoupdateexcel/getexceldata"  id="exlcargofile" method="POST" enctype="multipart/form-data" >
                                                <input type="file"  name="exlcargoupfile" id="exlcargoupfile" onchange="if (confirm('Are you sure to upload file?') ) this.form.submit();" style="display:none" >
                                            </form>
                                            <?php if($this->session->userdata('company_code') == 'AUKN' && $this->session->userdata('user_role_id') == '1'){ ?>
                                                <a href="#" onclick="updatebulkcargo(event);"><span class="icon tru-icon-edit" aria-hidden="true"></span>&nbsp;<?= $this->lang->line('edit_cargo_details') ?></a>
                                            <?php } ?>
                                                 
                                            <?php if($this->session->userdata('company_code') == "NZKN"){ ?>
                                                <a href="#"
                                               onclick="showNzCarriersPop();"><i
                                                    class="icon tru-icon-pdf"></i>  <?= $this->lang->line('download_manifestdoc') ?></a>
                                            <?php } ?>
                                            
                                            <a href="#"  class="icon tru-icon-delete" onclick="deleteselectedrecords()"> Delete Records</a>
                                        </div>
                                    </div>
                                    <div class="dropdown bcdropdown">
                                        <button class="dropbtn">
                                            <!-- <span class="fa fa-money"></span> -->
                                            <span class="iconSvk icon-invoice-icon"></span>
                                        </button>
                                         <div class="dropdown-content">
                                             <a href="<?= base_url() ?>assets/Rateupload.xlsx">
                                                <i class="icon tru-icon-template"></i>
                                                    <?= $this->lang->line('charges_template') ?></a>
                                            <a href="#" id='buttoncostid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('import_charges') ?></a>
                                            <form
                                                action="<?= base_url() ?>Excelimportorders/ordercost"
                                                id="excelcostform" method="POST"
                                                enctype="multipart/form-data">
                                                <input type="file" name="import_costfile" id="exlcostfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <?php if ($bill_type == "Knbill") { ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceknbill(event);"><i
                                                        class="glyphicon glyphicon-plus"></i> Send To KNBilling</a>
                                                <?php } else { ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceforselected(event);"><i
                                                        class="icon tru-icon-tender-list"></i> Ready To Invoice</a>
                                                    <a href="#"
                                                   onclick="filetrasnferfor_selectedorders(event);"><i
                                                        class="icon tru-icon-tender-list"></i>Send File to ACON</a>
                                                <?php } ?>
                                                <a href="#" data-toggle="modal" data-target="#consolidation_modal"><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('menu_consolidation') ?></a>
                                                <a href="#" onclick="getdistributiondata(event);" ><i class="icon tru-icon-quickbook"></i><?= $this->lang->line('charges_distribution') ?></a>
                                            </div>
                                    </div>
                                    <?php // include('tripcreat.php') ?>
                                    <div class="dropdown bcdropdown excelDrop">
                                        <button class="dropbtn">
                                        <span class="iconSvk icon-download-icon"></span>

                                            </span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('excel')"><i class="icon tru-icon-excel"></i><?= $this->lang->line('general_excel') ?></a>
                                            <a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('pdf')"><i class="icon tru-icon-pdf"></i><?= $this->lang->line('general_pdf') ?></a>
                                            <a href="#" onclick="<?php if($company_code=='CNKN'){ echo "orderExportOptionschina";}else{ echo "orderExportOptions";} ?>('print')"><i class="icon tru-icon-print"></i><?= $this->lang->line('general_print') ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-------Advanced Search-------->
                    <div class="sidebars sideBarStyle" id="sidebars_search" style="display:none">
                        <div class="advance_searchcol sidebar right" id="sidebar_search">
                            <div class="title_header">
                            <h2> <span class="iconSvk icon-filter-icon"></span> Filter</h2>
                                <!-- <h2><?= $this->lang->line('order_list') ?></h2>
                                <h3><?= $this->lang->line('general_advancesrch') ?></h3> -->
                                <a href="javascript:void(0)" class="closebtn" data-action="close" data-side="right">&times;</a>
                            </div>
                            <?php $products = getProductMasterData();
                            $service = getServiceMasterData(); ?>
                            <form method="GET" action="<?= base_url() ?>orders" onsubmit="return checkreference(this);" id="advsearch_orders">
                                <div class="custom-scroll">
                                    <input type="hidden" name="search_type" value="advanced" />
                                <div class="row">
									    <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advfrom_date'] ?? ''; ?>
                                                <label for="advfrom_date"><?= $this->lang->line('general_from_date') ?></label>
                                                <input type="text" name="advfrom_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_from_date') ?>" class="form-control fromdate" id="advfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
									    <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advto_date'] ?? ''; ?>
                                                <label for="advto_date"><?= $this->lang->line('general_to_date') ?></label>
                                                <input type="text" name="advto_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_to_date') ?>" class="form-control todate" id="advto_date" value="<?= $selectto_date?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                       
                                   </div>
                                <div class='row'>
                                <?php if($company_code=="AUKN" || $company_code=="KNAU"){
                                        ?>
                                         <div class="col-sm-6">
                                            <?php $selectbooking_id = $_GET['order_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_id"><?= $this->lang->line('booking_id') ?> </label>
                                                <input type="text" name="order_id" parsley-trigger="change" placeholder="<?= $this->lang->line('booking_id') ?>" class="form-control" id="order_id" form="advsearch_orders" value="<?= $selectbooking_id ?>">
                                            </div>
                                        </div>
                                        <?php
                                    }else{
                                        ?>
                                    <div class="col-sm-6">
                                        <?php $wildcard_order_id = $_GET['wildcard_order_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="wildcard_order_id"><?= $this->lang->line('booking_id') ?>-Wildcard Search </label>
                                                <input type="text" name="wildcard_order_id" parsley-trigger="change" placeholder="Search with %" class="form-control" onkeypress="return checkwildcardsearch(event);" id="wildcard_order_id" form="advsearch_orders" value="<?= $wildcard_order_id ?>" autocomplete="off">
                                            </div>
                                        </div>
                                   <div class="col-sm-6">
                                        <?php $bookingid = $_GET['order_id'] ?? [];
                                        
                                        if(empty($bookingid)){
                                            $bookingid = $getbookingid ?? [];
                                        }
                                        ?>
                                        
                                            <?php $selectbooking_id = $_GET['order_id'] ?? ''; ?>
                                            
                                            <div class="form-group">
                                               <label for="order_id"><?= $this->lang->line('booking_id') ?> </label>
                                                <input type="text" name="order_id" parsley-trigger="change" placeholder="<?= $this->lang->line('booking_id') ?>" class="form-control" id="order_id" form="advsearch_orders" value="<?= $selectbooking_id ?>">
                                                <!--<select form="form-control" name="order_id" id="order_id" parsley-trigger="change"  class="form-control searchbookingids" style="width:290px" multiple="multiple" placeholder="<?= $this->lang->line('booking_id') ?>" form="advsearch_orders" >
                                                        <?php foreach ($bookingid as $res):
                                                            
                                                            $sel = "selected";
                                                            echo "<option value='" . $res . "' $sel>" . $res . "</option>";
                                                        endforeach; ?>
                                                </select>-->
                                            </div>
                                        </div>
                                    
                                        <?php
                                    }
                                        ?>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <!--<?php $selectorder_status = $_GET['order_status'] ?? ''; ?>-->
                                            <?php
                                        $orderstatus = getOrderStatus();
                                        $selectorder_status = (isset($_GET['order_status'])) ? $_GET['order_status'] : '' ?><div class="form-group">
                                                <label for="order_status"><?= $this->lang->line('bpartner_ordstatus') ?></label>
                                                <!--  <input type="text" name="order_status" parsley-trigger="change" placeholder="<?= $this->lang->line('bpartner_ordstatus') ?>" class="form-control" id="order_status" form="advsearch_orders" value="<?= $selectorder_status ?>"> -->
                                                
                                                <select class="form-control" name="order_status"
                                                    id="order_status" form="advsearch_orders" name="status">
                                                    <option value="">All</option>
                                                    <?php

                                                    if (! empty($orderstatus)) {
                                                    foreach ($orderstatus as $res) {
                                                    ?>
                                                    <option value="<?= $res ?>"
                                                    <?php if(strtoupper($selectorder_status) == $res) { echo "selected"; } ?>><?= $res ?></option>
                                                    <?php }  if($company_code == 'AUKN'){ ?>
                                                    <option value="SCANNED"   <?php if(strtoupper($selectorder_status) == "SCANNED") { echo "selected"; } ?>><?= "SCANNED" ?></option>
                                                    <?php
                                                    }
                                                    if($company_code == 'AUKN'|| $company_code == 'KNAU'){
                                                    ?>
                                                    <option value="MANIFESTED" <?php if(strtoupper($selectorder_status) == "MANIFESTED") { echo "selected"; } ?>><?= "MANIFESTED" ?></option>

                                                    <?php
                                                    }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="panel-group" id="accordionMassFilter" role="tablist" aria-multiselectable="true">    
                                                        <div class="panel panel-default">
                                                            <div class="panel-heading active" role="tab" id="headingMassFilter">
                                                                <h4 class="panel-title">
                                                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordionMassFilter" href="#massFilter"  aria-expanded="false" aria-controls="massFilter">
                                                                        <i class="more-less fa fa-angle-right"></i> 
                                                                        <span class="iconSvk icon-filter-icon"></span>
                                                                       Advanced Filter
                                                                    </a>
                                                                </h4>
                                                            </div>
                                                            <div id="massFilter" class="panel-collapse collapse" role="tabpanel"  aria-labelledby="headingMassFilter">
                                                                
                                                                <div class="panel-body p-10">
                                                                         <!-- ADSEARCH -->
                                                               <div class="row">

                                        <div class="col-sm-6">
                                            <?php $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php $charge_list_type = isset($charge_list_type) ? $charge_list_type : ''; ?>
                                            <input type="hidden" name="list_type" id="list_type" value="<?= $list_type ?>">
                                            <input type="hidden" name="charge_list_type" id="charge_list_type" value="<?= $charge_list_type ?>">
                                             
                                            <?php $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <input type="hidden" name="cllist_type" id="cllist_type" value="<?= $cllist_type ?>">
                                             
                                            <?php $knlogin_list_type = $knlogin_list_type ?? 0; ?>
                                            <input type="hidden" name="knlogin_list_type" id="knlogin_list_type" value="<?= $knlogin_list_type ?>">
                                            <?php $selectcustomer_id = $_GET['searchcustomer_id'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_id"><?= $this->lang->line('customer_id') ?> </label>
                                                <input type="text" name="searchcustomer_id" parsley-trigger="change" placeholder="<?= $this->lang->line('customer_id') ?>" class="form-control" id="searchcustomer_id" form="advsearch_orders" value="<?= $selectcustomer_id ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <input type="hidden" name="list_type" id="list_type" value="<?= $list_type ?>">
                                            <input type="hidden" name="cllist_type" id="cllist_type" value="<?= $cllist_type;  ?>">
                                            <?php $selectcustomer_name = isset($_GET['searchcustomer_name']) ? $_GET['searchcustomer_name'] : ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_name"><?= $this->lang->line('customer_name') ?> </label>
                                                <input type="text" name="searchcustomer_name" parsley-trigger="change" placeholder="<?= $this->lang->line('customer_name') ?>" class="form-control" id="searchcustomer_name" form="advsearch_orders" value="<?= $selectcustomer_name ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php $selectservice = $_GET['service'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="service"><?= $this->lang->line('bpartner_service') ?></label>
                                                <select class="form-control" name="service" id="service" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($service)) {
                                                        foreach($service as $res) { ?>
                                                            <option value="<?= $res['row_id'] ?>" <?php if($selectservice == $res['row_id']){ echo "selected";} ?>><?= $res['id']."-".$res['name']; ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php $selectorder_type = $_GET['order_type'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_type"><?= $this->lang->line('bpartner_ordtype') ?></label>
                                                <select class="form-control" name="order_type" id="order_type" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($ordertypes)) {
                                                        foreach($ordertypes as $types){
                                                            if($types['type_name'] != ""){
                                                                ?>
                                                                <option value="<?= $types['type_id'] ?>" <?php if($selectorder_type == $types['type_id']){ echo "selected";} ?>><?= $types['type_name'] ?></option>
                                                            <?php } } } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectproduct = $_GET['product'] ?? ''; ?>
                                                <label for="product"><?= $this->lang->line('bpartner_product') ?></label>
                                                <select name="product" class="form-control" id="product" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($products)){
                                                        foreach($products as $res){
                                                            ?>
                                                            <option value="<?= $res['name'] ?>" <?php if($selectproduct == $res['name']){ echo "selected";} ?>><?= $res['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selecttrasnport = $_GET['modeof_trasnport'] ?? ''; ?>
                                                <label for="modeof_trasnport"><?= $this->lang->line('bpartner_motransport');  ?></label>
                                                <select name="modeof_trasnport" class="form-control" id="modeof_trasnport" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($transport)){
                                                        foreach($transport as $mode) { ?>
                                                            <option value="<?= $mode['code'] ?>" <?php if($selecttrasnport == $mode['code']){ echo "selected";} ?>><?= $mode['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectshipper_id = $_GET['searchshipper_id'] ?? ''; ?>
                                                <label for="searchshipper_id"><?= $this->lang->line('qbook_shipperid') ?></label>
                                                <input type="text" name="searchshipper_id" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_shipperid') ?>" class="form-control" id="searchshipper_id" form="advsearch_orders" value="<?= $selectshipper_id ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                        <div class="form-group">
                                            <?php $selectshipper_name = isset($_GET['searchshipper_name']) ? $_GET['searchshipper_name'] : ''; ?>
                                            <label for="searchshipper_id"><?= $this->lang->line('shipper_name') ?></label>
                                            <input type="text" name="searchshipper_name" parsley-trigger="change" placeholder="<?= $this->lang->line('shipper_name') ?>" class="form-control" id="searchshipper_name" form="advsearch_orders" value="<?= $selectshipper_name ?>">
                                        </div>
                                    </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectconsignee_id = isset($_GET['searchconsignee_id']) ? $_GET['searchconsignee_id'] : ''; ?>
                                                <label for="consignee_id"><?= $this->lang->line('qbook_consigneeid') ?></label>
                                                <input type="text" name="searchconsignee_id" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_consigneeid') ?>" class="form-control" id="searchconsignee_id" form="advsearch_orders" value="<?= $selectconsignee_id ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectconsignee_name = isset($_GET['searchconsignee_name']) ? $_GET['searchconsignee_name'] : ''; ?>
                                                <label for="consignee_name"><?= $this->lang->line('consignee_name') ?></label>
                                                <input type="text" name="searchconsignee_name" parsley-trigger="change" placeholder="<?= $this->lang->line('consignee_name') ?>" class="form-control" id="searchconsignee_name" form="advsearch_orders" value="<?= $selectconsignee_name ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectdelivery_note = isset($_GET['delivery_note']) ? $_GET['delivery_note'] : ''; ?>
                                                <label for="delivery_note"><?= $this->lang->line('qbook_deliverynote') ?></label>
                                                <input type="text" name="delivery_note" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_deliverynote') ?>" class="form-control" id="delivery_note" form="advsearch_orders" value="<?= $selectdelivery_note?>">
                                            </div>
                                        </div>
									    <div class="col-sm-6">
                                            <div class="form-group">
			                                    <?php
			                                    $salog_ref = $_GET['salog_ref'] ?? ''; ?>
                                                <label for="salog_ref"><?= $this->lang->line(
					                                    'salog_ref'
				                                    ) ?></label>
                                                <input type="text" name="salog_ref" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('salog_ref') ?>"
                                                       class="form-control" id="salog_ref" form="advsearch_orders"
                                                       value="<?= $salog_ref ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectpurchase_order = $_GET['purchase_order'] ?? ''; ?>
                                                <label for="purchase_order"><?= $this->lang->line('qbook_purchaseorder') ?></label>
                                                <input type="text" name="purchase_order" parsley-trigger="change" placeholder="<?= $this->lang->line('qbook_purchaseorder') ?>" class="form-control" id="purchase_order" form="advsearch_orders" value="<?= $selectpurchase_order?>">
                                            </div>
                                        </div>
                                        <?php if ($this->session->userdata('company_code') == "AUKN"): ?>
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <?php $selecttrip_id = $_GET['trip_id'] ?? ''; ?>
                                                        <label for="trip_id"><?= $this->lang->line('trip_id') ?></label>
                                                        <input type="text" name="trip_id" parsley-trigger="change" placeholder="<?= $this->lang->line('trip_id') ?>" class="form-control" id="trip_id" value="<?= $selecttrip_id ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-6"></div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($this->session->userdata('company_code') == "AUKN"): ?>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <?php $selectload_plan_connote = $_GET['load_plan_connote'] ?? ''; ?>
                                                    <label for="load_plan_connote"><?= $this->lang->line('load_plan_connote') ?></label>
                                                    <input type="text" name="load_plan_connote" parsley-trigger="change" placeholder="<?= $this->lang->line('load_plan_connote') ?>" class="form-control" id="load_plan_connote" form="advsearch_orders" value="<?= $selectload_plan_connote ?>">
                                                </div>
                                            </div>
                                        <?php else : ?>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <?php $selecttrip_id = $_GET['trip_id'] ?? ''; ?>
                                                    <label for="trip_id"><?= $this->lang->line('trip_id') ?></label>
                                                    <input type="text" name="trip_id" parsley-trigger="change" placeholder="<?= $this->lang->line('trip_id') ?>" class="form-control" id="trip_id" value="<?= $selecttrip_id ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php $order_reftype = $_GET['order_reftype'] ?? ''; ?>
                                            <div class="form-group">
                                                <label for="order_reftype"><?= $this->lang->line('bpartner_reftype') ?></label>
                                                <select class="form-control" name="order_reftype" id="order_reftype" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php if(!empty($ref_names_arr)) {
                                                        foreach($ref_names_arr as $res) { ?>
                                                            <option value="<?= $res['name'] ?>" <?php if($order_reftype == $res['name']){ echo "selected";} ?>><?= $res['name'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php $ref_val = $_GET['ref_val'] ?? ''; ?> <div class="form-group">
                                                <label for="ref_val"><?= $this->lang->line('referencevalue') ?></label>
                                                <input type="text" name="ref_val" parsley-trigger="change" placeholder="<?= $this->lang->line('referencevalue') ?>" class="form-control" id="ref_val" form="advsearch_orders" value="<?= $ref_val ?>">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectcompany_code = $_GET['company_code'] ?? '';  ?>
                                                <label for="company_code"><?= $this->lang->line('general_company_code') ?></label>
                                                <input type="text" name="company_code" parsley-trigger="change" placeholder="<?= $this->lang->line('general_company_code') ?>" class="form-control" id="company_code" value="<?= $selectcompany_code ?>">
                                            </div>
                                        </div>
                                        <!-- <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <?php $selectfrom_date = $_GET['from_date'] ?? ''; ?>
                                                        <label for="from_date"><?= $this->lang->line('general_from_date') ?></label>
                                                        <input type="text" name="from_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_from_date'); ?>" class="form-control fromdate" id="from_date" value="<?= $selectfrom_date ?>">
                                                    </div>
                                                </div> -->
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectbranch_code = $_GET['branch_code'] ?? ''; ?>
                                                <label for="branch_code"><?= $this->lang->line('general_branch_code') ?></label>
                                                <input type="text" name="branch_code" parsley-trigger="change" placeholder="<?= $this->lang->line('general_branch_code') ?>" class="form-control" id="branch_code" value="<?= $selectbranch_code ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                         <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectcarrier = $_GET['advcarrier'] ?? '';  ?>
                                                <label for="carrier"><?= $this->lang->line('carrier') ?></label>
                                                <input type="text" name="carrier" parsley-trigger="change" placeholder="<?= $this->lang->line('carrier') ?>" class="form-control" id="carrier" value="<?= $selectcarrier ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advpickupfrom_date'] ?? ''; ?>
                                                <label for="advpickupfrom_date"> Pickup From Date</label>
                                                <input type="text" name="advpickupfrom_date" parsley-trigger="change" placeholder="Pickup From Date" class="form-control fromdate" id="advpickupfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
									<!--<div class="row">
									    <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advfrom_date'] ?? ''; ?>
                                                <label for="advfrom_date"><?= $this->lang->line('general_from_date') ?></label>
                                                <input type="text" name="advfrom_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_from_date') ?>" class="form-control fromdate" id="advfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
									<div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advto_date'] ?? ''; ?>
                                                <label for="advto_date"><?= $this->lang->line('general_to_date') ?></label>
                                                <input type="text" name="advto_date" parsley-trigger="change" placeholder="<?= $this->lang->line('general_to_date') ?>" class="form-control todate" id="advto_date" value="<?= $selectto_date?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                       
                                   </div>-->
                                    <!------------pickup date range----------------------------------------->
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advpickupto_date'] ?? ''; ?>
                                                <label for="advpickupto_date"> Pickup To Date</label>
                                                <input type="text" name="advpickupto_date" parsley-trigger="change" placeholder="Pickup To Date" class="form-control todate" id="advpickupto_date" value="<?= $selectto_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectfrom_date = $_GET['advdeliveryfrom_date'] ?? ''; ?>
                                                <label for="advdeliveryfrom_date"> Delivery From Date</label>
                                                <input type="text" name="advdeliveryfrom_date" parsley-trigger="change" placeholder="Delivery From Date" class="form-control fromdate" id="advdeliveryfrom_date" value="<?= $selectfrom_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
                                    <!------------Delivery date range----------------------------------------->
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php $selectto_date = $_GET['advdeliveryto_date'] ?? ''; ?>
                                                <label for="advdeliveryto_date"> Delivery To Date</label>
                                                <input type="text" name="advdeliveryto_date" parsley-trigger="change" placeholder="Delivery To Date" class="form-control todate" id="advdeliveryto_date" value="<?= $selectto_date ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                                                          <!-- ADSEARCH -->
                                                                </div>
                                                            </div>
                                </div>
                                </div>
                                    
                                    
                              
                                
                                <div class="footer-search">

                                    <div class="top20 ">
                                        <div class="view_more text-right">
                                        <button type="Reset"  form="advsearch_orders" name="reset" class="btn btnCancel mr-2  resetbtn">Reset</button>
                                            <button type="submit" name="searchsubmit" class="btn btn_color" value="Search"><?= $this->lang->line('search_orders') ?></button>
                                            

                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-------Advanced Search- End------->















                <!--<div class="col-xs-12">
                    <div class="filter-section mtop15 bg-white ptlbr20">
                        <div class="col-md-9 col-sm-12">
                            <div class="row">
                            
                                <form method="GET" onsubmit="return checkseachvalidation(this);" action="<?= base_url() ?>orders" id="search_orders">
                                    <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                        <div class="form-group">
                                            <?php $selecfromdate = $_GET['fromdate'] ?? ''; ?>
                                            <input type="text" class="form-control" form="search_orders" placeholder="<?= $this->lang->line('general_from_date'); ?>" name="fromdate" id="fromDate" value="<?= $selecfromdate ?>" autocomplete="off">
                                            <i class="icon tru-icon-calendar"></i>
                                        </div>

                                    </div>
                                    <div class="col-sm-2" style="width:113px;padding: 2px;">
                                        <?php $selectodate = (isset($_GET['todate'])) ? $_GET['todate'] : '' ?>
                                        <div class="form-group">
                                            <input type="text" class="form-control" form="search_orders" name="todate" id="toDate" placeholder="<?= $this->lang->line('general_to_date') ?>" value="<?= $selectodate ?>" autocomplete="off">
                                            <i class="icon tru-icon-calendar"></i>
                                        </div>
                                    </div>
                                    <?php
                                    $company_code = $this->session->userdata('company_code');
                                    $inbrnchcode = $this->session->userdata('branch_code');
                                    if (($company_code == 'AUKN') || ($company_code == 'UKKN') || ($inbrnchcode == 'INCL')) {
                                        $plshold = $this->lang->line('container_num');
                                        if($inbrnchcode == 'INCL'){
                                            $plshold = $this->lang->line('docket_number');
                                        }
                                        ?>
                                        <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                            <?php $container_no = $_GET['container_no'] ?? ''; ?>
                                            <div class="form-group">
                                                <input type="text" class="form-control" form="search_orders" name="container_no" id="container_no" placeholder="<?= $plshold ?>" value="<?= $container_no ?>" autocomplete="off">
                                            </div>
                                        </div>
                                    <?php }
                                    if ($company_code != 'AUKN' ) {
                                    ?>
                                    <div class="col-sm-2" style="width:135px;padding: 2px;">
                                    <?php $normal_wcs = $_GET['wildcard_order_id'] ?? ''; ?>
                                        <div class="form-group">
                                            <input type="text" name="wildcard_order_id" parsley-trigger="change" title="Wildcard Search for Booking Id" placeholder="Search with %" class="form-control" onkeypress="return checkwildcardsearch(event);" id="wildcard_order_id" form="search_orders" value="<?= $normal_wcs ?>" autocomplete="off">
                                        </div>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <div class="col-sm-2" style="width:146px;padding: 2px;">
                                        <?php $bookingid = $_GET['bookingid'] ?? [];
                                        if(empty($bookingid)){
                                            $bookingid = $getbookingid ?? [];
                                        }
                                        ?>
                                        
                                        <input type="hidden" name="ats_parties" id="ats_parties" value='<?php
                                        if (!empty($ats_parties)) {
                                            echo $ats_parties;
                                        }
                                        ?>'>
                                       
                                        <div class="form-group">
                                            <select form="search_orders" name="bookingid[]" id="bookingid" class="form-control searchbookingids" multiple="multiple" placeholder="<?= $this->lang->line('booking_id') ?>">
                                                <?php foreach($bookingid as $res) :
                                                        $sel = "selected";
                                                        echo "<option value='".$res."'$sel>".$res."</option>";
                                                    endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2"  style="width:113px;padding: 2px;">
                                        <?php
                                        $orderstatus = getOrderStatus();
                                        $selectstatus = (isset($_GET['status'])) ? $_GET['status'] : '' ?>
                                        <div class="form-group">
                                           
                                            <select class="form-control" id="searchstatus" name="status">
                                                <option value=""><?= $this->lang->line('general_select') ?></option>
                                                <?php

                                                if (! empty($orderstatus)) {
                                                foreach ($orderstatus as $res) {
                                                ?>
                                                <option
                                                value="<?= $res ?>"
                                                <?php if(strtoupper($selectstatus) == $res) { echo "selected"; }?>><?= $res ?></option>
                                                <?php }  if($company_code == 'AUKN'){ ?>
                                                <option value="SCANNED" <?php if(strtoupper($selectstatus) == "SCANNED") { echo "selected"; }?>><?= "SCANNED" ?></option>
                                                <?php
                                                }
                                                if($company_code == 'AUKN'|| $company_code == 'KNAU'){
                                                ?>
                                                <option value="MANIFESTED"
                                                <?php if(strtoupper($selectstatus) == "MANIFESTED") { echo "selected"; }?>
                                                ><?= "MANIFESTED" ?></option>

                                                <?php
                                                }
                                                }
                                                ?>
                                            </select>
                                         
                                        </div>
                                    </div>
                                    <div class="col-sm-2" style="width:142px;padding: 2px;">
                                        <div class="form-group">
                                            <select name="order_references[]" id="order_references" form="search_orders"  class="form-control order_references" multiple="multiple" placeholder="<?php echo $this->lang->line('reference_no'); ?>">
                                                <?php  $orderReferences = $_GET['order_references'] ?? [];
                                                foreach($orderReferences as $eachOrderReferences) :
                                                    echo "<option value='".$eachOrderReferences."' selected>".$eachOrderReferences."</option>";
                                                endforeach; ?>
                                            </select> </div>
                                    </div>
                                    <div class="col-sm-1">
                                        <button type="submit"  name="searchsubmit" id="searchsubmit" class="btn  btn-primary btn_color" value="Search"><?= $this->lang->line('general_search') ?></button>
                                    </div>
                                     
                                </form>
                            </div>
                        </div>
               
                </div>
                 End fillter section 
            </div>
            <!-- end row -->
			
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white mb70">
                        <div class="main-datatable">

                            <div class="table-responsive minheight">
                                <?= $pagination->renderPagination() ?>
                                <table data-paging="false" <?php if($company_code=='CNKN'){ ?> id="orderslistchina" <?php } else { ?> id="orderslist" <?php } ?> class="table table-striped table-bordered forcheckboxes" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th class="shoring_icon_no">
                                            <div class="checkbox checkbox-info">
                                                <label>
                                                    <input type="checkbox" class="checkAll" value="">
                                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                </label>
                                            </div>
                                        </th>
                                        <th class="shoring_icon_no"></th>

                                        <th><b><?= $this->lang->line('sno') ?></b></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('booking_id') ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><i class="fa fa-address-card"></i><?= $this->lang->line('booking_created') ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('salog_ref') ?></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('customer_name'); ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('carrier_name'); ?></th>
                                        <?php
                                        $containertxt = $this->lang->line('container_num');
                                        if ($this->session->userdata('branch_code') == 'INCL') {
                                            $containertxt = $this->lang->line('docket_number');
                                        } ?>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $containertxt ?></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('kn_origin_ref') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('load_plan_connote') ?></th>

                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('pickup') ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('general_delivery') ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('del_city') ?></th>
                                        <th><i class="fa fa-list-alt" aria-hidden="true"></i><?= $this->lang->line('trip_no') ?></th>

                                        <th><i class="fa fa-hourglass-start"></i><?= $this->lang->line('general_status') ?></th>
                                        <th><i class="fa fa-hourglass-start" aria-hidden="true"></i><?= $this->lang->line('manifest_no') ?></th>

                                        <th><i class="fa fa-hourglass-start" aria-hidden="true"></i><?= $this->lang->line('otherstatus') ?></th>

                                        <th><i class="fa fa-hourglass-start"></i><?= $this->lang->line('Stoppage') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('created_date'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('pic_date') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('estimated_delivery_date') ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('deliverydate') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('bpartner_motransport') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('department'); ?></th>
                                        <th><i class="fa fa-archive" aria-hidden="true"></i><?= $this->lang->line('total_packages') ?></th>
                                        <th><i class="fa fa-print" aria-hidden="true"></i><b> <?= $this->lang->line('scanned_quantity') ?></b></th>
                                        <th><i class="fa fa-archive" aria-hidden="true"></i><?= $this->lang->line('no_of_pallets') ?></th>
                                        <th style="min-width: 220px;"><i class="fa fa-money"></i><?= $this->lang->line('billing_status') ?></th>

                                        <?php
                                            if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                $uomWeight = '(Kgs)';
                                                $uomVolume = '(m3)';
                                            } else {
                                                $uomWeight = '';
                                                $uomVolume = '';
                                            }
                                            ?>
                                            <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('actual_weight') ?> <?= $uomWeight ?></th>
                                            <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('general_weight') ?> <?= $uomWeight ?></th>
                                            <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('actual_volume') ?> <?= $uomVolume ?></th>
                                            <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('general_volume') ?> <?= $uomVolume ?></th>

                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('pod'); ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('jfr'); ?></th>

                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_company_code') ?></th>
                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_branch_code') ?></th>

                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('from') . " " . $this->lang->line('general_source') ?></th>
                                        <th><i class="icon tru-icon-calendar" aria-hidden="true"></i><?=  $this->lang->line('booking_updated'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('pq_ref') ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('external_customer') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="tbodyDynamicData">
                                    <?php
                                    if(!empty($pagination->hasItems())) {

                                        $i=1;
                                        foreach($pagination->items() as $res) {
                                            if($this->session->userdata('company_code')=="AUKN"){
                                                if($res['check_val']==1){
                                                    ?>
                                                    <tr style="background-color:#fff0e6" title="<?= $res['alert_msg'] ?>">
                                                    <?php
                                                }
                                                else{
                                                    echo "<tr>";
                                                }
                                            }else{
                                                echo "<tr>";
                                            }
                                            ?>

                                            <!--<tr>-->
                                            <td>
                                                <div class="checkbox checkbox-info">
                                                    <label>
                                                        <input type="checkbox" class="recordcheckbox" name="chck1" id="<?= $res['order_row_id'] ?>" value="<?= $res['order_row_id'];?>">
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                    </label></div>

                                            </td>

                                            <td>
                                                <input type="hidden" id="row_newvvorder_<?= $i; ?>" name="row_newvvorder_<?= $i; ?>" value="<?= $res['order_row_id'] ?>" />
                                                <ul class="nav nav-tabs">

                                                    <li class="dropdown tablebtnrleft">
                                                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                                            <span class="icon  tru-icon-action-setting"></span>
                                                        </a>
                                                        <ul class="dropdown-menu" role="menu">
                                                            <li>
                                                                <a data-toggle="modal" data-target="#viewOrderModal" href="<?= base_url() ?>orders/vieworder/<?= $res['order_row_id'] ?>" id="viewo_<?= $res['order_row_id']; ?>">
                                                                    <span class="icon tru-icon-view" aria-hidden="true"></span><?= $this->lang->line('general_view') ?>
                                                                </a>
                                                            </li>
                                                            <?php
                                                            $country_userids = $this->session->userdata("country_user_ids");
                                                            if ($res['order_status'] != 'CANCELLED') {
                                                            if(($this->session->userdata('company_code') == 'AUKN') && (empty($country_userids))){
                                                                if($res['order_status'] == 'ACTIVE' || $res['order_status'] == 'PENDING' || $res['order_status'] == 'SCANNED') { ?>
                                                                    <li>
                                                                        <a data-toggle="modal" data-target="#editOrderModal" href="<?= base_url() ?>orders/editorder/<?= $res['order_row_id']?>" id="edito_<?= $res['order_row_id'] ?>" class="dt-edit">
                                                                            <span class="icon tru-icon-edit" aria-hidden="true"></span><?= $this->lang->line('general_edit') ?>
                                                                        </a>
                                                                    </li>
                                                                <?php }
                                                            } else { ?>
                                                                <li>
                                                                    <a data-toggle="modal" data-target="#editOrderModal" href="<?= base_url() ?>orders/editorder/<?= $res['order_row_id'] ?>" id="edito_<?= $res['order_row_id'];  ?>" class="dt-edit">
                                                                        <span class="icon tru-icon-edit" aria-hidden="true"></span><?= $this->lang->line('general_edit') ?>
                                                                    </a>
                                                                </li>
                                                            <?php } } ?>

                                                            <li>
                                                                <a href="#" onclick="deleteorderbyid(<?= $res['order_row_id'] ?>)" class="dt-delete">
                                                                    <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('general_delete') ?>
                                                                </a>
                                                            </li>

                                                            <li>
                                                                <a href="<?= base_url() ?>orders/copyorder/<?= $res['order_row_id'] ?>" class="dt-delete" id="copyco_<?= $res['order_row_id'] ?>">
                                                                    <span class="fa fa-clone" aria-hidden="true"></span><?= $this->lang->line('copy_order') ?>
                                                                </a>
                                                            </li>

                                                            <li>
                                                                <a href="<?= base_url() ?>orders/reverseorder/<?= $res['order_row_id'] ?>" class="dt-delete">
                                                                    <span class="icon tru-icon-edit" id="revero_<?= $res['order_row_id'] ?>" aria-hidden="true"></span><?= $this->lang->line('reverse_order') ?>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <?php if($this->session->userdata('company_code') == 'PLKN') { ?>
                                                                    <a href="<?= base_url() ?>kntruckwaybill/tripwisetruckwaybill/<?= $res['order_row_id']."_english"; ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb')." English"; ?>
                                                                    </a>
                                                                    <a href="<?= base_url() ?>kntruckwaybill/tripwisetruckwaybill/<?= $res['order_row_id']."_polish"; ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb')." Polish"; ?>
                                                                    </a>
                                                                <?php } else {  ?>
                                                                    <a href="<?= base_url()?>kntruckwaybill/index/<?= $res['order_row_id']?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb'); ?>
                                                                    </a>
                                                                <?php  }  ?>
                                                            </li>
                                                            
                                                            <?php
                                                                if( $company_code == 'KNAU' ){ ?>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Macpaclabel/multiplelabels/<?= $res['order_row_id'];
                                                                     ?>" target="_blank">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('print_label'); ?>
                                                                    </a></li>
                                                                    <?php
                                                                }else{
                                                                    ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>orders/orderlabel/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('print_label'); ?>
                                                                        </a>
                                                                    </li>

                                                                <?php
                                                                }
                                                            ?>
                                                            
                                                            <?php if($company_code == "SGKN") { ?>
                                                                <li><a
                                                                href="<?php
                                                                echo base_url() ?>Generatebillinginvoice/internalbubilling/<?= $res['order_row_id'];
                                                                 ?>">
                                                                <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate')." ".$this->lang->line('internal_invoice'); ?>
                                                                </a></li>
                                                            <?php } ?>

                                                            <?php if($res['salog_ref'] != "" && $this->session->userdata('branch_code') != "INCL") : ?>
                                                                <li>
                                                                    <a href="<?= base_url()?>shipments/sendepodtosalog/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_salog_epod'); ?>
                                                                    </a>
                                                                </li>
                                                                <?php if ($res['order_status'] == "CLOSED") : ?>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggersalogstatuses/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('retrigger_salog_statuses'); ?>
                                                                        </a>
                                                                    </li>
                                                            <?php endif;endif; ?>
                                                            <?php if(checkCustomerHasAltovaConnection($res['order_row_id']) != 0) :?>
                                                                <li>
                                                                    <a href="<?= base_url()?>carriercommonedi/sendAltovaOrder/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_order_to_roadlog'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php endif; ?>

                                                            <?php if($res['created_source'] == 18 && $res['order_status'] == "CLOSED") : ?>
                                                                <li>
                                                                    <a href="<?= base_url()?>shipments/retriggerepodtoroadlog/<?= $res['order_row_id'] ?>">
                                                                        <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog Epod
                                                                    </a>
                                                                </li>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggerroadlogstatuses/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog statuses
                                                                        </a>
                                                                    </li>
                                                            <?php endif; ?>

                                                            <?php if ($res['can_cancel']) { ?>


                                                                    <?php if($this->session->userdata('branch_code') != "INCL" && in_array($res['vendor_id'], [310,311])) { ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>uniqloactions/cancelcarrierorder/<?= $res['order_row_id'] ?>" onclick="return checkcancelconfirm();">
                                                                            <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('general_cancel')." ".$this->lang->line('menu_trip'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php } else { ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>trip/cancel/<?= $res['order_row_id'] ?>" onclick="return checkcancelconfirm();">
                                                                            <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('general_cancel')." ".$this->lang->line('menu_trip'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php } ?>

                                                            <?php } ?>

                                                            <?php if($this->session->userdata('company_code') == "RUKN") {
                                                                if(($res['order_status'] == "ACTIVE") || ($res['order_status'] == "CLOSED")) { ?>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Knruinvoice/rupoa/<?= $res['order_row_id'];
                                                                     ?>">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span>POA
                                                                    </a></li>
                                                                    <li><a
                                                                    href="<?php
                                                                    echo base_url() ?>Rutransportorder/index/<?= $res['order_row_id'];
                                                                     ?>">
                                                                    <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('transport_order') ?>
                                                                    </a></li>
                                                            <?php } } ?>
                                                            <?php if($company_code == 'AUKN' || $company_code == "KNAU"){ ?>
                                                                <li>
                                                                    <?php if(!empty($res['manifestno'])){ ?>
                                                                        <a href="<?= base_url('aulabel/downloadmanifest/'.$res['order_row_id']) ?>" >
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('download_manifestdoc') ?>
                                                                        </a>
                                                                    <?php } else { ?>
                                                                        <a href="#" class="dt-delete" onclick="alert('Manifest file not generated for this Order')">
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('download_manifestdoc') ?>
                                                                        </a>
                                                                    <?php } ?>
                                                                </li>
                                                            <?php } ?>

                                                            <?php if($this->session->userdata('company_code')=="AUKN"){
                                                                ?>
                                                                <li>
                                                                    <a href="#" class="" onclick="palletadd(<?= $res['order_row_id'] ?>)" ><span class="fa fa-plus"></span> Add Pallets</a>
                                                                </li>
                                                                <?php
                                                                $country_userids = $this->session->userdata("country_user_ids");
                                                                if(!empty($country_userids)){
                                                                    ?>
                                                                    <li>
                                                                        <a href="#" class="" onclick="manifestoverride(<?= $res['order_row_id']; ?>)" ><span class="fa fa-plus"></span><?= $this->lang->line('manifest')." ".$this->lang->line('override'); ?> </a>
                                                                    </li>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                            <?php if ($res['order_status'] == 'PENDING') : ?>
                                                                <li>
                                                                    <a href="<?= base_url() ?>Orderdata/cancelOrder/<?= $res['order_row_id'] ?>">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('cancel_order'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php endif;
                                                            if ($res['created_source'] == 5) : ?>
                                                                <li>
                                                                    <a href="javascript:void(0);" onclick="fetchSALOGDocs(<?= $res['order_row_id']; ?>)" ><span class="fas fa fa-file-pdf-o"></span><?= $this->lang->line('download')." ".$this->lang->line('salog_ref')." ".$this->lang->line('documents'); ?> </a>
                                                                </li>
                                                            <?php endif; ?>
                                                            <?php if ($res['carrier_name'] == "BLOWHORN") { ?>
                                                                <li>
                                                                    <a href="#" class="" onclick="getblowhornstatus(<?= $res['order_row_id']; ?>)"><span class="fas fa fa-file-pdf-o"></span><?= $this->lang->line('blowornstatus'); ?> </a>
                                                                </li>
                                                            <?php } ?>
                                                            <?php
                                                            if (checkAccessConditions('CHECK_UNIQLO_CARRIER', $res['vendor_id']) && ($res['shift_id'] != 0)) : ?>
                                                                <li>
                                                                    <a href="<?= base_url() ?>uniqloactions/updateorder/<?= $res['order_row_id'] ?>" onclick="return checktriprevertconfirm();">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('trip_revert'); ?>
                                                                    </a>
                                                                </li>
                                                            <?php
                                                            endif; ?>
                                                            <?php
                                                            if (checkAccessConditions('CHECK_CARGO_EXCHANGE_CARRIER', $res['vendor_id']) && ($res['shift_id'] != 0)) : ?>
                                                                <li>
                                                                    <a href="#" onclick="sendTripToCargoExchange(<?=  $res['shift_id'] ?>,<?= $res['order_row_id']; ?> )">
                                                                        <span class="icon tru-icon-delete" aria-hidden="true"></span>Send to Cargo Exchange</a>
                                                                </li>
                                                            <?php
                                                            endif; ?>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td><?= $i; ?></td>
                                            <td><?= $res['order_id'] ?></td>
                                            <td><?= $res['delivery_note'] ?></td>
                                            <td><?= $res['username'] ?></td>
                                            <td><?= $res['salog_ref'] ?></td>
                                            <td><?= $res['customer_name']; ?></td>
                                            <td><?= $res['carrier_name']; ?></td>
                                            <td><?= $res['container_no'] ?></td>
                                            <td><?= $res['pos_ref'] ?></td>
                                            <td><?= $res['loadplanconnote'] ?></td>
                                            <td><?= $res['pickup'] ?></td>
                                            <td><?= $res['delivery']; ?></td>
                                            <td><?= $res['deliverycity']; ?></td>
                                            <td><?= $res['trip_no'] ?></td>
                                            <td><?= $res['order_status']; ?></td>
                                            <td><?= $res['manifestno'] ?></td>
                                            <td><?= $res['otherstatus'] ?></td>
                                            <td><?= $res['Stoppage']; ?></td>
                                            <td><?= date('Y-m-d', strtotime($res['createdon'])) ?></td>
                                            <?php
                                            if ($company_code == 'AUKN' || $company_code == "KNAU") { ?>
                                                <td><?php
                                                    if (!empty($res['pickup_date'])) {
                                                        echo date('Y-m-d h:i A', strtotime($res['pickup_date']));
                                                    }
                                                    ?></td>
                                                <td><?php
                                                    if (!empty($res['delivery_date'])) {
                                                        echo date('Y-m-d h:i A', strtotime($res['delivery_date']));
                                                    }
                                                    ?></td>
                                            <?php
                                            } else { ?>
                                                <td><?php
                                                    echo date('Y-m-d h:i A', strtotime($res['pickup_date'])); ?></td>
                                                <td><?= date('Y-m-d h:i A', strtotime($res['delivery_date'])); ?></td>
                                            <?php
                                            } ?>
                                            <td><?= $res['final_delivery'] ?></td>
                                            <td><?= $res['transport_mode'] ?></td>
                                            <td><?= $res['department_code']; ?></td>
                                            <td><?= $res['total_packages'] ?></td>
                                            <td><?= $res['tot_scanned_qty'] ?></td>
                                            <td><?= $res['num_of_pallets'] ?></td>
                                            <td style="min-width: 220px;"><?= $res['html'] ?></td>
                                            <?php if($res['salog_ref'] != "") : ?>
                                            <td> <?= $res['gross_weight']. ' ' .$res['gross_weight_uom'] ?> </td>
                                            <td><?=  $res['chargeable_weight']. ' ' .$res['chargeable_weight_uom'] ?> </td>
                                                <?php else : ?>
                                            <td>
                                            <?php
                                            $weightunit = isset($res['weight_unit']) ? $res['weight_unit'] : 'kg';
                                            if ($res['weight'] > 0) {
                                                if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                    echo round(floatval($res['weight']), 2);
                                                } elseif ($weightunit === 'kg') {
                                                    echo uom_string($res['weight'], 'kg');
                                                } else {
                                                    echo round(floatval($res['weight']), 2) . " " . $weightunit;
                                                }
                                            }
                                            ?>
                                            </td>

                                            <td><?php
                                            if ($res['second_weight'] > 0) {
                                                if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                    echo round(floatval($res['second_weight']), 2);
                                                } else {
                                                    echo uom_string($res['second_weight'], 'kg');
                                                }
                                            } ?> </td>
                                                <?php endif;  ?>
                                            <td><?php
                                                if ($res['volume'] > 0) {
                                                    if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                        echo round(floatval($res['volume']), 2);
                                                    } else {
                                                        echo uom_string($res['volume'], 'cbm', 2);
                                                    }
                                                } ?></td>

                                                <td><?php
                                                    if ($res['second_volume'] > 0) {
                                                        if ($company_code === 'AUKN' || $company_code === 'KNAU') {
                                                            echo round(floatval($res['second_volume']), 2);
                                                        } else {
                                                            echo uom_string($res['second_volume'], 'cbm', 2);
                                                        }
                                                    } ?>
                                                </td>

                                            <td><?= $res['POD']; ?></td>
                                            <td><?= $res['JFR']; ?></td>
                                            <td><?= $res['company_code'] ?></td>
                                            <td><?= $res['branch_code'] ?></td>
                                            <td><?= (new OrderCreationSourceHelper())->getOrderSourceName(
                                                    $res['created_source']
                                                ); ?></td>
                                            <td><?=  date('Y-m-d h:i A',strtotime($res['updatedDate']))?></td>
                                            <td><?= $res['pq_ref'] ?></td>
                                            <td><?= $res['external_customer']; ?></td>
                                            </tr>
                                            <?php
                                            $i++;
                                        } ?>
                                    <?php
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-------Order List View-------->
                            <div class="sidebars" id="sidebars_list" style="display:none">
                                <div class="advance_searchcol sidebar right" id="sidebar_list">

                                    <div class="title_header">
                                        <h2>IN0303200041</h2>
                                        <h3>Booking ID</h3><a href="javascript:void(0)" class="closebtn" data-action="close" data-popup="open-data" data-side="right">&times;</a>
                                    </div>
                                    <div class="custom-scroll" style="max-height: 250px; overflow-y: auto; ">
                                        <form action="#">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="">Product</label>
                                                        <p>Product Name </p>

                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Company Code </label>
                                                            <p>INKN</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Order Status</label>
                                                            <p>Pending</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Inco Term</label>
                                                            <p>Inco Term Details</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Branch Code</label>
                                                            <p>INHYD</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Customer ID</label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Delivery Terms </label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Department Code </label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">SRMT</label>
                                                            <p>STREET NO.2,ALIPURDUAR, INDIA, 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Order Type</label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Service</label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Mode Of Transport</label>
                                                            <p>Full Truck Load</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="title_header">

                                                        <h3>Routing Details</h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Shipper ID </label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Shipper Name </label>
                                                            <p>SRMT</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Early Pickup </label>
                                                            <p>2020-03-06 08:00:00 </p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Late Pickup </label>
                                                            <p>2020-03-06 10:00:00 </p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Location</label>
                                                            <p>Street No.2, Alipurduar, India - 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Phone</label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Email</label>
                                                            <p>kevin@gmail.com</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="footer-view_list">

                                                <div class="top20 ">
                                                    <div class="view_more text-center">
                                                        <button type="submit" name="submit" class="btn btn-default btn_color ">Edit Details</button>
                                                        <button type="Reset" name="reset" class="btn btn-default btn_color resetbtn">View More Details</button>

                                                    </div>


                                                </div>
                                            </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-------Order List View- End------->
                    </div>
                    <div style="z-index: 9999;" class="modal fade consolidation_modal" id="consolidation_modal" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" style="width:45%;" role="document">
                            <div class="modal-content">
                            <div class="modal-header">
                            <button type="button" class="closevalues close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title" id="companyCodeAddmodalLabel">
                            <?= $this->lang->line('menu_choose_consolidation'); ?>
                            </h4>
                            </div>
                            <div class="modal-body">
                            <div class="row">
                            <div class="col-sm-3">
                            <div class="form-group">
                            <div class="form-group">
                            <select name="consolidation_id" class="select2" id="consolidation_id" form="updatecargobulk" class="form-control updcargo-form">
                            <option value="">Select</option>
                            <?php if (!empty($consolidation_data)) {
                            foreach ($consolidation_data as $consolidation) { ?>
                            <option value="<?= $consolidation['id']; ?>"><?= $consolidation['consolidation_id_name']; ?></option>
                            <?php }
                            } ?>
                            </select>
                            </div>
                            </div>

                            </div>
                            </div>
                            <div class="modal-footer success_message_footer">
                            <button type="button" class="btn btn-primary success_redirect suc_pop_ok" onclick="applyconsolidation(this,0)">Apply</button>
                            <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Cancel</button>
                            </div>

                            </div>
                            </div>
                    </div>
                 </div>

                    <div style="z-index: 9999;" class="modal fade insert_success_div" id="insert_success_div" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                </div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;"><span class="glyphicon glyphicon-ok-circle popup_circle" style="font-size: 22px;
                                       color: green;"></span>&nbsp;<span class="pop_message">New Record Inserted Successfully !!</span></p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok hide_popbutton" data-dismiss="modal">Ok</button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel hide_popbutton" data-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary  show_popbutton" style="display:none" onclick="applyconsolidation(this,1)">Yes</button>
                                    <button type="button" class="btn btn-danger  show_popbutton" style="display:none" data-dismiss="modal">No</button>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                    <div style="z-index: 9999;" class="modal fade ats_service_model" id="ats_service_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                </div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;">&nbsp;<span class="pop_message"></span></p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal">Ok</button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Cancel</button>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                    <div style="z-index: 9999;" class="modal fade " id="ready_invoice" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                    <button type="button" class="closevalues close" data-dismiss="modal">×</button>
                                    <h4 class="modal-title" id="view_customer_title">Response</h4>
                                </div>
                                <div class="modal-body">
                                    <h4 class="pop_message_load"></h4>
                                    <span class="pop_message">
                                        <table class="table table-striped" id="ready_invoice_tb" width="100%">
                                            <thead>
                                                <tr>
<!--                                                    <th scope="col">#</th>-->
                                                    <th scope="col">Booking ID</th>
                                                    <th scope="col">Recipient Role</th>
                                                    <th scope="col">JFR</th>
                                                    <th scope="col">Res. Message</th>
                                                    <th scope="col">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="readyinvoice_show_data"></tbody>
                                        </table>
                                    </span>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal">Ok</button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Cancel</button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="charges_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Order Charges</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Total Revenue</th>
                                        <th>JFR</th>
                                        <th>BU JFR</th>
                                        <th>Failure Status</th>
                                        <th>Total Cost</th>
                                        <th>JFR</th>
                                        <th>BU JFR</th>
                                        <th>Failure Status</th>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($chexcel_uploaddata)) {
                                                foreach ($chexcel_uploaddata as $chrg) {
                                                    ?>
                                                    <tr>
                                                        <td><?= $chrg->booking_id; ?></td>
                                                        <td><?= $chrg->total_revenue; ?></td>
                                                        <td><?= $chrg->rev_debtor_jfr; ?></td>
                                                        <td><?= $chrg->rev_bu_jfrs; ?></td>
                                                        <td><?php
                                                        $rstyle = "";
                                                        if($chrg->rev_failure != ""){
                                                            $rstyle = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $rstyle ?>"><?= $chrg->rev_failure; ?></span></td>
                                                        <td><?= $chrg->total_cost; ?></td>
                                                        <td><?= $chrg->cost_jfr; ?></td>
                                                        <td><?= $chrg->cost_bu_jfrs; ?></td>
                                                        <td><?php
                                                        $style = "";
                                                        if($chrg->cst_failure != ""){
                                                            $style = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $style ?>"><?= $chrg->cst_failure; ?></span></td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                     
                    <div class="modal containerModal" id="knloginstatus_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Status Send To KN Login</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id') ?></th>
                                        <th><?= $this->lang->line('qbook_customer') ?></th>
                                        <th><?= $this->lang->line('cust_status') ?></th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $knlogin_uploaddata = $knlogin_uploaddata ?? [];
                                        foreach ($knlogin_uploaddata as $eachLine):
                                            ?>
                                            <tr>
                                                <td><?= $eachLine->orderId; ?></td>
                                                <td><?= $eachLine->customer; ?></td>
                                                <td><?php
                                                    $style = "";
                                                    if ($eachLine->status === 0) {
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    } ?>
                                                    <span style="<?= $style ?>"><?= $eachLine->message; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="clorders_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Orders List</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id'); ?></th>
                                        <th><?= $this->lang->line( 'customer' )." ".$this->lang->line( 'user_cid' ); ?></th>
                                        <th><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><?= $this->lang->line('trip_id') ?></th>
                                        <th><?= $this->lang->line('general_status') ?></th>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($clexcel_uploaddata)) {
                                                foreach ($clexcel_uploaddata as $ord) {
                                                    ?>
                                                    <tr>
                                                        <td><?= $ord->booking_id; ?></td>
                                                        <td><?= $ord->customer_id; ?></td>
                                                        <td><?= $ord->delivery_note; ?></td>
                                                        <td><?= $ord->trip_id; ?></td>
                                                        <td><?php
                                                            $excel_status = $ord->status;
                                                            $style = "";
                                                            if (strtolower($excel_status) == "success") {
                                                                $style = "font-weight:bold;color:#099e59eb;";
                                                            } else {
                                                                $style = "font-weight:bold;color:#b71209d6;";
                                                            }
                                                            ?>
                                                            <span style="<?= $style; ?>"><?= $excel_status; ?></span></td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal containerModal" id="file_tranfer_succeslist"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">File Transfer Response</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="filetransfersucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Status</th>
                                        </thead>
                                        <tbody class="filetransfersucces_list-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="orders_success_list" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Orders List</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table  class="table table-striped table-bordered" id="orderssucces_list">
                                        <thead>
                                        
                                        <th><?= $this->lang->line( 'booking_id' ); ?></th>
                                        <th><?= $this->lang->line( 'customer' )." ".$this->lang->line( 'user_cid' ); ?></th>
                                        <th><?= $this->lang->line('qbook_deliverynote') ?></th>
                                        <th><?= $this->lang->line('general_status') ?></th>
                                        
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($excel_uploaddata)) {
                                            foreach($excel_uploaddata as $ord){ ?>
                                                <tr>
                                                    <td><?= $ord->booking_id ?></td>
                                                    <td><?= $ord->customer_id ?></td>
                                                    <td><?= $ord->delivery_note ?></td>
                                                    <td><?php $excel_status = $ord->status;
                                                        $style = "";
                                                        if(strtolower($excel_status) == "success")
                                                        {
                                                            $style = "font-weight:bold;color:#099e59eb;";
                                                        }else{
                                                            $style = "font-weight:bold;color:#b71209d6;";
                                                        } ?>
                                                        <span style="<?= $style?>"><?= $excel_status ?></span></td>
                                                </tr>
                                            <?php } } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="cargobulkupload">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                                    <h4 class="modal-title">Update Cargo For Selected Orders </h4>

                                </div>

                                <div class="modal-body">
                                   <form name="updatecargobulk" id="updatecargobulk" method="post" class="updatecargobulk" action="" >
                                        <div class="box custom-box">
                                        <input type="hidden" id="cargo_orderids" class="updcargo-form" form="updatecargobulk" name="cargo_orderids" value="">
                                            <table  border="0" width="100%">
                                                <span id="cargoupd_success" style="display:none;color: #008000bd;">Cargos Updated Successfully...</span>
                                                <tr><td colspan="2"></td></tr>
                                                <tr>
                                                    <td width="40%" style="padding-left: 30px;font-size: 13px;font-weight: 600;color: #162d56;">
                                                        <b><?= $this->lang->line( 'package_type' )." : "; ?></b>
                                                    </td>
                                                    <td width="60%"  style="padding-right: 60px;">
                                                        <select name="updatcargo_val" id="updatcargo_val" form="updatecargobulk" class="form-control updcargo-form">
                                                            <option value="">Select</option>
                                                            <option value="PALLET">PALLET</option>
                                                            <option value="CARTON">CARTON</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                    <input type="submit"  form="updatecargobulk" class="submittype btn btn-primary  btn_color waves-effect waves-light" onclick="submitbulkcargos_fororder(event)" id="cargoupdate" data-dismiss="close" data-info="add" value="<?= $this->lang->line('general_update'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="trip_creation">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                                    <h4 class="modal-title"><?= $this->lang->line('trip_mgt'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <form name="tripcreation" id="tripcreation" method="post" class="tripcreation" action="<?= base_url()?>orders/triporderintoshipment" <?= ($this->session->userdata('company_code')=='AUKN')?'onsubmit="return validatetrip();"':''?>>
                                        <input type="hidden" id="trip_orderid" name="ordid">
                                        <input type="hidden" id="trip_type" name="trip_type" value="single">
                                        <div class="box custom-box">
                                            <div id="">
                                                <?php
                                                $user_id = $this->session->userdata('user_id');
                                                $list = getListForTrip($user_id);
                                                $carrierlist = $vehicletypes = array();
                                                if(!empty($list)){
                                                    $carrierlist = $list['carrierlist'];
                                                    $vehicletypes = $list['vehicletypes'];
                                                } ?>
                                                <table border="0" width="100%">
                                                    <tr>
                                                        <td width="20%"><label><?= $this->lang->line('template_id') ?></label></td>
                                                        <td width="30%"><select form='tripcreation' name="templateId" onchange="disableOtherInputFields()" class="Txtfld form-control" id="templateId">
                                                                <option value="">--Select--</option>
                                                            </select>
                                                            <input type="hidden" form='tripcreation' name="fromsource" id="fromsource" value = "orders"></td>
                                                    </tr>
                                                    <tr class="" >
                                                        <td width="20%"><label><?= $this->lang->line('carrier_name'); ?> * </label></td>
                                                        <td width="25%">
                                                            <select name="carrierid"  class="tripcar_id tripcreatefields Txtfld mandatoryflds form-control" id="tcarrierid" required="">
                                                                <option value="">--Select--</option>
                                                                <?php  foreach($carrierlist as $carrier){ ?>
                                                                    <option value="<?= $carrier['id'] ?>"><?= $carrier['name'] ?></option>
                                                                <?php } ?>
                                                            </select>
                                                        <td width="20%"><label><?= $this->lang->line('carrier_id');  ?></label></td>
                                                        <td width="25%">
                                                            <input onkeypress="return isNonSpecialCharCheck(event);" type="text" class="form-control tripcar_name Txtfld" readonly onkeyup="upper(this);"  id="nccode" size="20" value="">
                                                        </td>
                                                    </tr>
													
													 <?php  $vehicle_types = getVehicletypeMasterData(); ?>
                                                    <tr class="" >
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_type'); ?></label></td>
                                                        <td width="25%">
                                                            <select name="vehicle_type" id="tpvehicle_type" class="tripcreatefields Txtfld tripcar_id form-control" >
                                                                <?php
                                                                                    echo "<option value=''>-Select-</option>";
                                                                                    if(!empty($vehicle_types)){
		   foreach($vehicle_types as $tt){
                                                                                        echo "<option value='" . $tt['id']. "'>" . $tt['trucktype']. "</option>";
                                                                                    }}
                                                                                    ?>
                                                            </select>
                                                        </td>
                                                        <td width="20%"><label><?= $this->lang->line('veh_type_name'); ?></label></td>
                                                        <td width="25%">
                                                            <input type="text" class="Txtfld form-control" readonly   id="tpveh_typename"  size="20" value="">
                                                        </td>
                                                    </tr>
                                                    <tr class="" >
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_no'); ?></label></td>
                                                        <td width="25%">
                                                    <span id="tpveh_numdiv">
                                                        <select name="veh_typenum" form='tripcreation' id="tvehnum" class="tripcreatefields Txtfld tripcar_id form-control">
                                                            <option value=''>--Select--</option>
                                                        </select>
                                                    </span>
                                                        </td>
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_id'); ?></label></td>
                                                        <td width="25%">
                                                            <input  type="text" name="vehicle_id" readonly class="add_company Txtfld form-control" id="tvehid"  size="20" value="">
                                                        </td>
                                                    </tr>
                                                    <tr class="" >
                                                        <td width="20%"><label><?= $this->lang->line('driver_name'); ?></label></td>
                                                        <td width="25%">
                                                    <span id="tdrivespan">
                                                        <select class="add_company Txtfld tripcreatefields tripcar_id form-control" id="tdri_name"  onchange="getdrid()" name="tdrivernum">
                                                            <option value=''>--Select--</option>
                                                        </select>
                                                    </span></td>
                                                        <td width="20%"><label><?= $this->lang->line('driver_id'); ?></label></td>
                                                        <td width="25%">
                                                            <input type="text" readonly class="add_company Txtfld form-control" id="tdri_id" name="driver_id"  size="20" value="">
                                                        </td>
                                                    </tr>
 
                                                   <tr class="" >
                                                        <td width="25%"><label><?= $this->lang->line('carrier_instructions'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="carrier_instructions" class="form-control tripcreatefields Txtfld" name="carrier_instructions" ></textarea>
                                                        </td>

                                                        <td width="25%"><label><?= $this->lang->line('weight_capacity'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="weight_capacity" class="tripcreatefields form-control Txtfld" name="weight_capacity"></textarea>
                                                        </td>

                                                    </tr>

                                                    <tr class="" >

                                                       <td width="25%"><label><?= $this->lang->line('volume_capacity'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="volume_capacity" class="tripcreatefields form-control Txtfld" name="volume_capacity"></textarea>
                                                        </td>

                                                        <td width="20%"><label><?= $this->lang->line('additional_conditions'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="additional_conditions" class="form-control tripcreatefields Txtfld" name="additional_conditions" ></textarea>
                                                        </td>

                                                        <tr class="" >

                                                        <td width="20%"><label><?= $this->lang->line('temperature_regime'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="temperature_regime" class="form-control Txtfld tripcreatefields" name="temperature_regime"></textarea>
                                                        </td>
                                                        <td width="20%"><label><?= $this->lang->line('time_for_loading_penality_rate'); ?></label></td>
                                                        <td width="25%">
                                                            <textarea  rows="2" form="tripcreation" cols="30" id="time_for_loading_penality_rate" class="form-control Txtfld tripcreatefields" name="time_for_loading_penality_rate"></textarea>
                                                        </td>


                                                       </tr>
                                                    </tr>
                                                 
                                                </table>
                                            </div></div>
                                </div>
                                <div class="modal-footer">

                                    <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                    <input type="submit" class="submittype btn btn-primary  btn_color waves-effect waves-light" id="new_company_add" data-dismiss="close" data-info="add" value="<?= $this->lang->line('submit_trip'); ?>">
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal containerModalForDg" tabindex="-1" role="dialog" style="z-index: 9999 !important;">
                        <div class="modal-dialog modal-lg" role="document" style="width:98%">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Modal title</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p>Modal body text goes here.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary  btn_color waves-effect waves-light" onclick="submitDgGoodsList()">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="quickbook_popup" class="modal fade quickbook_popup" data-backdrop="static" data-keyboard="false" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4 class="modal-title" id="companyCodeAddmodalLabel">
                                        <?= $this->lang->line('quickbook'); ?>
                                    </h4>
                                </div>
                                <div class="modal-body">
                                    <?php if($this->session->userdata('company_code') == 'INKN') { $submit = 'onsubmit="return savequickbook(0);"'; }else{ $submit = 'onsubmit="return savequickbook(1);"'; } ?>
                                    <form method="POST" action="<?= base_url() ?>orders/savequickbook" <?= $submit ?> novalidate id="quickbook_form">
                                        <input type="hidden" name="quickbookreference_ids" class="quickbookform" id="quickbookreference_ids" value="">
                                        <input type="hidden" name="quickbook_order_reference_ids" class="quickbookform" id="quickbook_order_reference_ids" value="">
                                        <input type="hidden" name="quickbookpickup_id" class="quickbookform" id="quickbookpickup_id" value="<?php $cust_id = $this->session->userdata('cust_id'); if($cust_id != "") { echo $cust_id; } ?>">
                                        <input type="hidden" name="quickbookshipper_id" class="quickbookform" id="quickbookshipper_id" value="<?= $postData['pickupRowIdForBook'] ?? "" ?>">
                                        <input type="hidden" name="quickboookconsignee_id" class="quickbookform" id="quickboookconsignee_id" value="<?= $postData['consigneeRowIdForBook'] ?? "" ?>">
                                        <input type="hidden" name="quickbookdelivery_id" class="quickbookform" id="quickbookdelivery_id" value="">
                                        <input type="hidden" name="quickbookorder_cargo_id" class="quickbookform" id="quickbookorder_cargo_id" value="">
                                        <input type="hidden" name="quickbookcargo_row_id" class="quickbookform" id="quickbookcargo_row_id" value="">
                                        <input type="hidden" name="rateServiceRowId"
                                               class="quickbookform" form="quickbook_form" id="rateServiceRowId" value="<?= $postData['rateServiceRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="rateOfferingRowId"
                                               class="quickbookform" form="quickbook_form" id="rateOfferingRowId" value="<?= $postData['rateOfferingRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="rateRecordRowId"
                                               class="quickbookform" form="quickbook_form" id="rateRecordRowId" value="<?= $postData['rateRecordRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="customerProfileId"
                                               class="quickbookform" form="quickbook_form" id="customerProfileId" value="<?= $postData['customerProfileIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="laneRowIdForBook"
                                               class="quickbookform" form="quickbook_form" id="laneRowIdForBook" value="<?= $postData['laneRowIdForBook'] ?? 0 ?>">
                                        <?php $products = getProductMasterData();
                                        $incoterm = getIncotermMasterData();
                                        $service = getServiceMasterData();
                                        $cust_id = "0";
                                        if($this->session->userdata('cust_id')){
                                            $cust_id = $this->session->userdata('cust_id');
                                            if($cust_id == ""){
                                                $cust_id = "0";
                                            }
                                        }
                                        $company_code = $this->session->userdata('company_code');
                                        /*   $ordertypes = getOrderTypes($cust_id,$company_code);*/
                                        /*   $transport = gettransportmode();*/
                                        ?>
                                        <div class="bg-white_main">
                                            <!-- accordion start -->
                                            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                                                <div class="generalInfo panel panel-default">
                                                    <div class="panel-heading active" role="tab" id="headingGeneralInfo" >
                                                        <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse" data-parent="#accordion" href="#generalInfo" aria-expanded="true" aria-controls="collapseOne">
                                                                <i class="more-less fa fa-angle-right"></i> <?= $this->lang->line('qbook_bookinginfo'); ?>
                                                            </a>
                                                        </h4>
                                                    </div>
                                                    <div id="generalInfo" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingGeneralInfo">
                                                        <div class="panel-body">
                                                            <div class="general_input_fields" >
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <fieldset style="min-width: 0;min-height: 350px;">
                                                                            <legend style="display: block;width: auto;padding: 0;margin-bottom: 0px;font-size:13px;line-height: inherit;border: 0;"><?= $this->lang->line('qbook_routing'); ?></legend>
                                                                            <div class="row">

                                                                                <div class="col-md-12">
                                                                                    <div class="form-group pull-left covid19pickupstatus">
                                                                                    </div>
                                                                                    <div class="form-group pull-right">
                                                                                        <div class="checkbox checkbox-info">
                                                                                            <label>
                                                                                                <input type="checkbox" value="" id="save_popupmaster1" onchange="return checkbeforesavepopupshipper(event)">
                                                                                                <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                                                            </label>
                                                                                        </div>
                                                                                        <label class="checkbox_cls" for=""><?= $this->lang->line('general_save'); ?></label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label for="popupshipper_id"><?= $this->lang->line('qbook_shipperid'); ?> * </label>
                                                                                        <input form="quickbook_form" type="text" name="popupshipper_id" class="form-control add_book Txtfld quickbookform" id="popupshipper_id"  value="<?= $postData['pickupCodeForBook'] ?? "" ?>" onkeyup="upper(this);" size="20" >
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#" id="searchpopuppartylist" data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   onclick="searchpopuppartylist(event,'shipper_details')"><i
                                                                                                            class="icon tru-icon-search"></i></a>

                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" data-info="<?= $this->lang->line('bpartner_plist'); ?>" title="List" id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event,'shipper_details')"> <i
                                                                                                            class="icon tru-icon-tender-list"></i></a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('shipper_name'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);"  type="text" name="popupshipper_name" id="popupshipper_name" parsley-trigger="change" required placeholder="" class="form-control quickbookform" value="<?= $postData['pickupNameForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
																			
                                                                            <?php if ($this->session->userdata('company_code') == "NZKN") { ?><div id="facility_address"><?php } ?>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_street'); ?> * </label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);"  type="text" name="popupshipper_street" id="popupshipper_street" parsley-trigger="change" required placeholder="" class="quickbookform form-control <?php if ($this->session->userdata('company_code') == "NZKN") { ?>autocomplete route<?php } ?>" value="<?= $postData['pickupStreetForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_city'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popupshipper_city" id="popupshipper_city" parsley-trigger="change" required placeholder="" class="quickbookform form-control locality" value="<?= $postData['pickupCityForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?php if ( $this->session->userdata( 'company_code' ) == 'NZKN' ) { ?><?= $this->lang->line('suburb'); ?><?php } else { ?><?= $this->lang->line('general_province'); ?><?php } ?><?php if ( $this->session->userdata( 'company_code' ) == 'VNKN' ) { }else{ ?> *<?php } ?> </label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);" type="text" name="popupshipper_state" id="popupshipper_state" parsley-trigger="change" required placeholder="" class="quickbookform form-control sublocality_level_1" value="<?= $postData['pickupStateForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_country'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popupshipper_country" id="popupshipper_country" parsley-trigger="change" required placeholder="" class="form-control chkpopupcountry quickbookform country" value="<?= $postData['pickupCountryForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('zipcode'); ?> * </label>
                                                                                        <input onkeypress="return isNumberKey(event);" type="text" name="popupshipper_zipcode" id="popupshipper_zipcode" parsley-trigger="change" required placeholder="" class="form-control quickbookform postal_code" value="<?= $postData['pickupPincodeForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_phone'); ?> </label>
                                                                                        <input onkeypress="return isNumberKey(event);"   type="text" name="popupshipper_phone" id="popupshipper_phone" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
																			<?php if ($this->session->userdata('company_code') == "NZKN") { ?>  </div><?php } ?>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_fax'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);"  type="text" name="popupshipper_fax" id="popupshipper_fax" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_email'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popupshipper_email" id="popupshipper_email" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
 
                                                                                 <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('estimated_pickup_date'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               name="popuppickup"
                                                                                               class="quickbookform <?php if($this->session->userdata('company_code') != 'THKN' || $this->session->userdata('company_code') == 'THCL') {echo "datetimepicker"; } ?> add_book Txtfld form-control"
                                                                                               id="popuppickup" autocomplete="off" value=""
                                                                                               onkeyup="upper(this);" size="20" placeholder="<?php if($this->session->userdata('company_code') == 'THKN' || $this->session->userdata('company_code') == 'THCL') {echo "YYYY-MM-DD HH:MM:SS"; }?>">

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <hr style="border-top: 1px solid #ccc">
                                                                            <div class="row">

                                                                                <div class="col-md-12" >
                                                                                    <div class="form-group pull-left covid19deliverstatus"></div>
                                                                                    <div class="form-group pull-right">
                                                                                        <div class="checkbox checkbox-info">
                                                                                            <label>
                                                                                                <input type="checkbox" id="save_popupmaster" onchange="return checkbeforesavepopupconsignee()" value="">
                                                                                                <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                                                            </label>
                                                                                        </div>
                                                                                        <label class="checkbox_cls" for=""><?= $this->lang->line('general_save'); ?></label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('qbook_consigneeid'); ?> * </label>
                                                                                        <input type="text" class="add_book form-control Txtfld quickbookform" onkeyup="upper(this);"  id="popupconsignee_id" size="20" value="<?= $postData['consigneeCodeForBook'] ?? "" ?>">
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#" data-info="<?= $this->lang->line('bpartner_plist'); ?>" id="searchpopuppartylist"
                                                                                                   onclick="searchpopuppartylist(event,'consignee_details')"><i
                                                                                                            class="icon tru-icon-search"></i></a>
                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" title="List" data-info="<?= $this->lang->line('bpartner_plist'); ?>" id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event,'consignee_details')"> <i
                                                                                                            class="icon tru-icon-tender-list"></i></a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('consignee_name'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);"  id="popupconsignee_name" name="popupconsignee_name" type="text" parsley-trigger="change" required placeholder="" class="quickbookform form-control" value="<?= $postData['consigneeNameForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
																			<?php if ($this->session->userdata('company_code') == "NZKN") { ?><div id="source_address"><?php } ?>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_street'); ?> * </label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);"  type="text" name="popupconsignee_street" id="popupconsignee_street" parsley-trigger="change" required placeholder="" class="form-control quickbookform <?php if ($this->session->userdata('company_code') == "NZKN") { ?>autocomplete route<?php } ?>" value="<?= $postData['consigneeStreetForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_city'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" name="popupconsignee_city" id="popupconsignee_city" type="text" name="City" parsley-trigger="change" required placeholder="" class="form-control quickbookform locality" value="<?= $postData['consigneeCityForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
																				
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?php if ( $this->session->userdata( 'company_code' ) == 'NZKN' ) { ?><?= $this->lang->line('suburb'); ?><?php } else { ?><?= $this->lang->line('general_province'); ?><?php } ?> <?php if ( $this->session->userdata( 'company_code' ) == 'VNKN' ) { }else{ ?> *<?php } ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);" name="popupconsignee_state" type="text" id="popupconsignee_state" parsley-trigger="change" required placeholder="" class="form-control quickbookform sublocality_level_1" value="<?= $postData['consigneeStateForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_country'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);"  type="text" name="popupconsignee_country" id="popupconsignee_country" parsley-trigger="change" required placeholder="" class="form-control chkpopupcountry quickbookform country" value="<?= $postData['consigneeCountryForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('zipcode'); ?> * </label>
                                                                                        <input onkeypress="return isNumberKey(event);"  type="text" name="popupconsignee_zipcode" id="popupconsignee_zipcode" parsley-trigger="change" required placeholder="" class="form-control quickbookform postal_code" value="<?= $postData['consigneePincodeForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_phone'); ?>  </label>
                                                                                        <input onkeypress="return isNumberKey(event);" type="text" name="popupconsignee_phone" id="popupconsignee_phone" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
																			<?php if ($this->session->userdata('company_code') == "NZKN") { ?> </div><?php } ?>

                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_fax'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);"  type="text" name="popupconsignee_fax" id="popupconsignee_fax" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_email'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popupconsignee_email" id="popupconsignee_email" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
  
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('estimate_delivery_date'); ?> * </label>
                                                                                        <input type="text"
                                                                                               class="quickbookform <?php if($this->session->userdata('company_code') != 'THKN' && $this->session->userdata('company_code') != 'THCL') {echo "datetimepicker"; } ?> add_book Txtfld form-control"
                                                                                               onkeyup="upper(this);" name="popupdelivery"
                                                                                               autocomplete="off" id="popupdelivery" size="20"
                                                                                               value="" placeholder="<?php if($this->session->userdata('company_code') == 'THKN' || $this->session->userdata('company_code') == 'THCL') {echo "YYYY-MM-DD HH:MM:SS"; }?>">
                                                                                    </div>
                                                                                </div>

                                                                            </div>


                                                                        </fieldset>
                                                                    </div>
                                                                    <div class="col-md-6" >
                                                                        <fieldset style="min-width: 0;min-height: 350px;">
                                                                            <legend style="display: block;width: auto;padding: 0;font-size: 13px;line-height: inherit;color: #333;border: 0;"><?= $this->lang->line('qbook_orderdeatils'); ?></legend>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_company_code'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form" name="popupcompany_code" class="add_book Txtfld form-control quickbookform" id="popupcompany_code"  value="<?= $this->session->userdata('company_code')?>" onkeyup="upper(this);" size="20" readonly>
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" data-info="<?= $this->lang->line('general_listofcompanies'); ?>" href="#" id="searchviewcompany"
                                                                                                   onclick="searchpopupviewcompany(event)"><i
                                                                                                            class="icon tru-icon-search"></i></a>

                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" data-info="<?= $this->lang->line('general_listofcompanies'); ?>" title="List" id="viewcompanylist"
                                                                                                   onclick="viewpopupcompanylist(event)"> <i
                                                                                                            class="icon tru-icon-tender-list"></i></a>
                                                                                            </button>
                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_branch_code'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form" class="add_book Txtfld form-control quickbookform" onkeyup="upper(this);" name="popupbranch_code" id="popupbranch_code" size="20" value="<?= $this->session->userdata('branch_code')?>" readonly>
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" data-toggle="modal">
                                                                                                <a title="Search" data-info="<?= $this->lang->line('general_searchbranchdetials'); ?>" href="#" id="searchviewbranch"
                                                                                                   onclick="searchpopupviewbranch(event)"> <i
                                                                                                            class="icon tru-icon-search"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" data-toggle="modal">
                                                                                                <a href="#" data-info="<?= $this->lang->line('general_listofbranches'); ?>" title="List" id="viewbranchlist"
                                                                                                   onclick="viewpopupbranchlist(event)"> <i
                                                                                                            class="icon tru-icon-tender-list"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <?php $departments = getDepartmentMasterData(); ?>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('general_department_code'); ?> <?php if($this->session->userdata('company_code') != 'INKN'){ ?> *<?php } ?> </label>
                                                                                        <select name="popupdepartment_code" class="add_book Txtfld quickbookform main-control form-control custom-select-main" id="popupdepartment_code">
                                                                                            <option value="">Select</option>
                                                                                            <?php if(!empty($departments)) {
                                                                                                foreach ($departments as $res) { ?>
                                                                                                    <option value="<?= $res?>"><?= $res ?></option>
                                                                                                <?php } } ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <input type="hidden" form="quickbook_form" name="vendorIdFromProfile" value="<?= $vendorIdFromProfile ?? 0 ?>">
                                                                                    <input type="hidden" form="quickbook_form" name="vendorCodeFromProfile" value="<?= $vendorCodeFromProfile ?? 0 ?>">
                                                                                    <input type="hidden" form="quickbook_form" name="customerIdFromProfile" value="<?= $customerIdFromProfile ?? 0 ?>">
                                                                                    <?php $custid = $this->session->userdata('cust_id');
                                                                                    if($custid == "") { ?>
                                                                                        <div class="input-group">
                                                                                            <label><?= $this->lang->line('qbook_customer'); ?> * </label>
                                                                                            <input type="text" form="quickbook_form" name="popupcustomer_id" class="add_book Txtfld cutsomerid form-control" id="popupcustomer_id"  value="<?= $pickup_details['party_id'] ?? ""?>" onkeyup="upper(this);" size="20" >
                                                                                            <div class="input-group-btn">
                                                                                                <button class="btn btn-outline-secondary" type="button" data-toggle="modal" data-info="<?= $this->lang->line('bpartner_plist'); ?>" onclick="searchpopupcustomerlist(event)"data-placement="top" title="Search">
                                                                                                    <i class="icon tru-icon-search"></i>
                                                                                                </button>
                                                                                                <button class="btn btn-outline-secondary" type="button" data-placement="top" data-info="<?= $this->lang->line('bpartner_plist'); ?>" title="List" data-toggle="modal" onclick="viewpopupcustomerlist(event)">
                                                                                                    <i class="icon tru-icon-tender-list"></i>
                                                                                                </button>
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php }else{ ?>
                                                                                        <div class="form-group">
                                                                                            <label><?= $this->lang->line('qbook_customer'); ?> * </label>
                                                                                            <input type="text" form="quickbook_form" name="popupcustomer_id" class="add_book Txtfld quickbookform form-control" readonly id="popupcustomer_id"  value="<?php if(isset($pickup_details['party_id'])){ echo $pickup_details['party_id']; } ?>" onkeyup="upper(this);" size="20" >
                                                                                        </div>
                                                                                    <?php } ?>
                                                                                </div>

                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-dm-6"></div>
                                                                                <div class="col-md-6 pull-right" id="customer_details">
                                                                                    <?php if(!empty($pickup_details)){
                                                                                        if($pickup_details['name'] != ""){ echo "<b>".$pickup_details['name']."</b><br>"; } if($pickup_details['address'] != "") { echo strtoupper($pickup_details['address'])." , </b><br>"; } if($pickup_details['country'] != ""){ echo strtoupper($pickup_details['country']).","; } if($pickup_details['pincode'] != ""){ echo strtoupper($pickup_details['pincode']); } } ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_product'); ?> <?php if($this->session->userdata('company_code') != 'INKN'){ ?> *<?php } ?></label>
                                                                                        <select form="quickbook_form" name="productpopup" class="form-control quickbookform main-control custom-select-main" id="productpopup" >
                                                                                            <option value="">Select</option>
                                                                                            <?php if(!empty($products)){
                                                                                                foreach($products as $res){
                                                                                                    ?>
                                                                                                    <option value="<?= $res['name'] ?>"><?= $res['name'] ?></option>
                                                                                                <?php } }  ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_service'); ?><?php if($this->session->userdata('company_code') != 'INKN'){ ?> *<?php } ?> </label>
                                                                                        <select form="quickbook_form" name="servicepopup" class="form-control main-control custom-select-main" id="servicepopup">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            $rateServiceId = $postData['serviceIdForBook'] ?? 0;
                                                                                            foreach ($service as $res): ?>
                                                                                                <option <?php
                                                                                                if ($res['row_id'] == $rateServiceId): echo "selected"; endif; ?> value="<?= $res['row_id'] ?>"><?= $res['id'] . "-" . $res['name']; ?></option>
                                                                                            <?php
                                                                                            endforeach; ?>
                                                                                        </select>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_incoterms'); ?></label>
                                                                                        <select form="quickbook_form" name="incoterm_popup" class="main-control custom-select-main form-control quickbookform" id="incoterm_popup" >
                                                                                            <option value="">Select</option>
                                                                                            <?php if(!empty($incoterm)){
                                                                                                foreach($incoterm as $name) { ?>
                                                                                                    <option value="<?= $name?>"><?= $name ?></option>
                                                                                                <?php } } ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_deliveryterms'); ?></label>
                                                                                        <select form="quickbook_form" name="popupdelivery_terms" class="quickbookform form-control main-control custom-select-main" id="popupdelivery_terms" >
                                                                                        </select>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_deliverynote'); ?> </label>
                                                                                        <input type="text" onkeyup="upper(this);" class="quickbookform Txtfld form-control" form="quickbook_form" form="quickbook_form" name="popupdelivery_note" id="deliverynote_popup"  >
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_notifyparty'); ?></label>
                                                                                        <input type="text" class="form-control  quickbookform add_book Txtfld" onkeyup="upper(this);" form="quickbook_form" name="popupnotifyparty"  id="popupnotifyparty"  size="20" value="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>

                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="popuporder_type"><?= $this->lang->line('bpartner_ordtype'); ?><?php if(in_array($this->session->userdata('company_code'),array('INKN','VNKN'))){ } else {?> *<?php } ?></label>
                                                                                        <select class="quickbookform main-control custom-select-main form-control" name="popuporder_type" id="popuporder_type">
                                                                                            <option value="">Select</option>
                                                                                            <?php if(!empty($ordertypes)) {
                                                                                                foreach($ordertypes as $types){
                                                                                                    if($types['type_name'] != ""){
                                                                                                        ?>
                                                                                                        <option value="<?= $types['type_id'] ?>"><?= $types['type_name'] ?></option>
                                                                                                    <?php } } } ?>
                                                                                        </select>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="popupmodeof_trasnport"><?= $this->lang->line('mode_of_transport'); ?> * </label>
                                                                                        <select class="quickbookform main-control custom-select-main form-control" name="popupmodeof_trasnport" id="popupmodeof_trasnport">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            $rateOfferingType = $rateOfferingType ?? "";
                                                                                                foreach($transport as $res): ?>
                                                                                                    <option <?php if($res['code'] == $rateOfferingType): echo "selected"; endif;?> value="<?= $res['code'] ?>"><?= $res['name'] ?></option>
                                                                                                <?php endforeach; ?>

                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('qbook_purchaseorder'); ?></label>
                                                                                        <input type="text" form="quickbook_form" onkeyup="upper(this);" class="quickbookform Txtfld form-control"  onblur ="checkpopuppurchaseordervalue()"  name="purchaseorder_popup" id="purchaseorder_popup"  >
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('driver_pickup_instruction'); ?></label>
                                                                                        <input type="text" form="quickbook_form" onkeyup="upper(this);" class="quickbookform Txtfld form-control"   name="driverpickup_popup" id="driverpickup_popup">
                                                                                    </div>
                                                                                </div>
 										<div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('driver_delivery_instruction'); ?></label>
                                                                                        <input type="text" form="quickbook_form" onkeyup="upper(this);" class="quickbookform Txtfld form-control"   name="driverdelivery_popup" id="driverdelivery_popup" >
                                                                                    </div>
                                                                                </div>


																			<div class="col-sm-6">
																				 <div class="form-group">
																					<label for="goods_value"><?= $this->lang->line('goods_value'); ?></label>
																					<div class="row">
																					   <div class="col-md-6">
																					<input onkeypress="return isNonSpecialCharCheck(event);" form="quickbook_form" type="text" name="goods_value" id="goods_value" parsley-trigger="change" required placeholder="" class="decimal form-control" style="width:115px;">
																				 </div>
																				<div class="col-sm-6" style="0px;">
																				 <select form="quickbook_form" class="form-control" name="currency" id="currency">
																				 <?php  if ( !empty( $currencies ) ) {
																							foreach ( $currencies as $currency ) {
																								$sel = ( $user_currency == $currency ) ? "selected" : '';
																							 ?>
																							 <option value="<?= $currency;  ?>" <?= $sel; ?>><?= $currency;  ?></option>
																						 <?php
																							}
																						}
																						?>
																				 </select>
																			 </div>
																			  </div>
																			  </div>
																			  </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <button class="btn  btn-primary btn_color" style="margin-top: 22px;" title="Add Reference" data-toggle="modal" data-target="#exampleModal" onclick="addreferenceforquickbook(event)">
                                                                                        <small><i class="glyphicon glyphicon-plus"></i></small>&nbsp;<?= $this->lang->line('qbook_refvalues'); ?>
                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-12">
                                                                                    <div class="col-md-12 new_popupreference_table" style="background-color: white;display: none;">
                                                                                        <table id="popupref_table" class="table table-bordered table-striped">
                                                                                            <thead>
                                                                                            <tr>
                                                                                                <th>Refernce Name</th>
                                                                                                <th>Description</th>
                                                                                                <th>Value</th>
                                                                                                <th width="20%"></th>
                                                                                            </tr>
                                                                                            </thead>
                                                                                            <tbody>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </fieldset>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="CargoInfo panel panel-default">
                                                    <div class="panel-heading active" role="tab" id="headingCargoInfo" style="margin-top: -19px;">
                                                        <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse" data-parent="#accordion" href="#CargoInfo" aria-expanded="true" aria-controls="collapseTwo">
                                                                <i class="more-less fa fa-angle-right"></i><?= $this->lang->line('cargo_details'); ?>
                                                            </a>
                                                        </h4>
                                                    </div>
                                    </form>
                                    <div id="CargoInfo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingCargoInfo">
                                        <div class="panel-body">
                                            <div class="general_input_fields">
                                                <form method="POST" action="<?= base_url()?>orders/savepopupcargo<?= @$id ?>" id="popupcargo_form" novalidate onsubmit="return savepopupCargo();" autocomplete="off">
                                                    <div class="row">
                                                        <input type="hidden" name="mainpopupheight" id="mainpopupheight" value="">
                                                        <input type="hidden" name="mainpopupweight" id="mainpopupweight" value="">
                                                        <input type="hidden" name="mainpopupwidth" id="mainpopupwidth" value="">
                                                        <input type="hidden" name="mainpopuplength" id="mainpopuplength" value="">
                                                        <div class="col-md-12">
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group">
                                                                        <label for="popupcargo_type"><?= $this->lang->line('package_type'); ?> * </label>
                                                                        <input type="text" class="popupcargo_form Txtfld form-control ui-autocomplete-input" name="popupcargo_type" id="popupmarks_number" autocomplete="off">
                                                                        <div class="input-group-btn">
                                                                            <button class="btn " type="button"
                                                                                    data-placement="top" data-toggle="modal">
                                                                                <a data-war="<?= $this->lang->line('alert_entervalue'); ?>" data-info="<?= $this->lang->line('general_searchitemdts'); ?>" title="Search" href="#" id="searchviewbranch"
                                                                                   onclick="searchviewpopupitem(event)"> <i
                                                                                            class="icon tru-icon-search"></i>
                                                                                </a>
                                                                            </button>
                                                                            <button class="btn " type="button"
                                                                                    data-placement="top" data-toggle="modal">

                                                                                <a href="#" title="List" id="viewbranchlist"
                                                                                   onclick="viewpopupitemlist(event)"> <i
                                                                                            class="icon tru-icon-tender-list"></i>
                                                                                </a>
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <!-- </div> -->
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="popupcargo_type"><?= $this->lang->line('qbook_goodsdescription'); ?> <?= order_cargo_description_mandatory($company_code) ?></label>
                                                                        <input type="text" onkeyup="upper(this);" class="Txtfld popupcargo_form form-control" name="popupgoods_desc" id="popupgoods_desc" >
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="popupcargo_type">
                                                                            <?= $this->lang->line('general_quantity'); ?> <?= order_cargo_quantity_mandatory($company_code) ?>
                                                                        </label>
                                                                        <input type="number" onkeypress="return quantitytype(event);" class="Txtfld popupcargo_form form-control" name="popupquantity" min='1' id="popupquantity">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popuplength"><?= $this->lang->line('general_length'); ?> </label>
                                                                            <input type="text" class="decimal form-control popupcargo_form  ui-autocomplete-input" name="popuplength" id="popuplength" oninput="changepopupbylength()" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="popuplength_uom" id="popuplength_uom" class="cargo_details main-control custom-select form-control">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupwidth"><?= $this->lang->line('general_width'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);" class="decimal form-control ui-autocomplete-input popupcargo_form" name="popupwidth"  id="popupwidth" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="popupwidth_uom"  class="cargo_details main-control form-control custom-select" id="popupwidth_uom">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupheight"><?= $this->lang->line('general_height'); ?> </label>
                                                                            <input  type="text" class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control" onkeyup="upper(this);" name="popupheight" id="popupheight" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="popupheight_uom"class="cargo_details main-control form-control custom-select" id="popupheight_uom">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupweight"><?= $this->lang->line('actual_weight'); ?> <?= order_cargo_weight_mandatory($company_code); ?></label>
                                                                            <input decimaltype="text"
                                                                                   onkeyup="upper(this);"
                                                                                   class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control"
                                                                                   name="popupweight" id="popupweight"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="popupweight_uom"
                                                                                    class="main-control form-control custom-select"
                                                                                    id="popupweight_uom">
                                                                                <option value="G">G</option>
                                                                                <option value="Kg">Kg</option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="secondweight"><?= $this->lang->line('general_weight'); ?> </label>
                                                                            <input decimaltype="text"
                                                                                   onkeyup="upper(this);"
                                                                                   class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control"
                                                                                   name="secondweight" id="secondweight"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="secondpopupweight_uom"
                                                                                    class="main-control form-control custom-select"
                                                                                    id="secondpopupweight_uom">
                                                                                <option value="G">G</option>
                                                                                <option value="Kg">Kg</option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupvolume"><?= $this->lang->line('volumetric_weight'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="popupvolumetric_weight"
                                                                                   id="popupvolumetric_weight"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>

                                                                            <select name="popupvow_uom"
                                                                                    class="main-control form-control custom-select"
                                                                                    id="popupvow_uom">
                                                                                <option value="G">G</option>
                                                                                <option value="Kg">Kg</option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupvolume"><?= $this->lang->line('actual_volume'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);" class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form" name="popupvolume" id="popupvolume" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="popupvolume_uom" class="main-control custom-select form-control" id="popupvolume_uom">
                                                                                <option value="cbm"><?= $this->lang->line('cbm'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="secondvolume"><?= $this->lang->line('general_volume'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);" class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form" name="secondvolume" id="secondvolume" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label>
                                                                            <select name="secondpopupvolume_uom" class="main-control custom-select form-control" id="secondpopupvolume_uom">
                                                                                <option value="cbm"><?= $this->lang->line('cbm'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupwidth"><?= $this->lang->line('ldm'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);" class="decimal form-control ui-autocomplete-input popupcargo_form" name="popupldm"  id="popupldm" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="input-group row">
                                                                                <div class="dgGoodsColumn"></div>
                                                                                <input name="popupstackable" type="checkbox" id="popupstackable" class="cargo_details" value="1"> &nbsp;&nbsp;
                                                                                <label for="popupstackable"><?= $this->lang->line('qbook_stackable'); ?></label>
                                                                                <br>
                                                                                <input name="popupgroundable" type="checkbox" id="popupgroundable" class="cargo_details" value="1"> &nbsp;&nbsp;
                                                                                <label for="popupgroundable"><?= $this->lang->line('grounded'); ?></label>
                                                                                <br>
                                                                                <input name="popupsplittable" type="checkbox" id="popupsplittable" class="cargo_details" value="1"> &nbsp;&nbsp;
                                                                                <label for="popupsplittable"><?= $this->lang->line('splittable'); ?></label>
                                                                                <br>
                                                                                <input name="popupdg_goods" type="checkbox" id="popupdg_goods" class="cargo_details" value="1"  onchange="checkDggoods()"> &nbsp;&nbsp;
                                                                                <label for="popupdg_goods"><?= $this->lang->line('dg_goods'); ?></label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="add-button-row">
                                                                    <div class="col-md-4"  style="padding-top: 15px;">
                                                                        <input type="submit" name="add" value="<?= $this->lang->line('general_save'); ?>" class="btn btn-primary btn_color waves-effect waves-light">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                            </form>
                                            <div class="col-md-12">
                                                <div class="row" style="overflow-x:auto;">
                                                    <table class="table table-striped table-bordered"  cellspacing="0" style="width: 100%;" id="popuporder_cargo">
                                                        <thead>
                                                        <tr>
                                                            <th class="th-sm"><?= $this->lang->line('general_actions'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('package_type'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('qbook_goodsdescription'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_quantity'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_length'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_width'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_height'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('actual_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('volumetric_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('actual_volume'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_volume'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('ldm'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('qbook_stackable'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('grounded'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('splittable'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('dg_goods'); ?></th>

                                                        </tr>
                                                        </thead>
                                                        <tbody class="cargo_details">
                                                        </tbody>
                                                    </table>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="closevalues btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                            <!-- <button type="button" form="quickbook_form" class="btn btn-primary  btn_color waves-effect waves-light" >Add</button> -->
                            <input type="submit" class="btn btn-primary submitorderdetails btn_color waves-effect waves-light" name="submit" value="<?= $this->lang->line('general_save'); ?>" form="quickbook_form">
                            <!--  <input type="submit" class="submittype btn btn-xs btn-primary" id="new_company_add" onclick="newcompanyadd(event)" data-dismiss="close"  data-info="add" value="ADD"> -->
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <div class="modal fade" id="view_items">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('view_items');">&times;</button>
                            <h4 class="modal-title" id="view_items_title">List of Items</h4>
                        </div>
                        <div class="modal-body " style="overflow-x:auto;">
                            <div class="box custom-box">
                                <table class="table table-striped"  width="100%" id="item_tab">
                                    <thead>
                                    <tr>
                                        <th scope="col"></th>
                                        <th scope="col"><?= $this->lang->line('package_type'); ?></th>
                                        <!-- <th scope="col">Item Name</th> -->
                                        <th scope="col">Length</th>
                                        <th scope="col">Width</th>
                                        <th scope="col">Height</th>
                                        <th scope="col">Actual Weight</th>
                                        <th scope="col">Weight</th>
                                        <th scope="col">Volumetric Weight</th>
                                        <th scope="col">Actual Volume</th>
                                        <th scope="col">Volume</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="items-show_data">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn"   onclick="viewmodaleclose('view_items');">Close</button>
                            <button type="button" class="selectitem btn btn-primary btn_color waves-effect waves-light" onclick="selectiteminlist()">Select</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_branch">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('view_branch');">&times;</button>
                            <h4 class="modal-title" id="view_branch_title">Branch details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box">
                                <!--    <div id="search"> -->
                                <table class="table table-striped" id="branch_tab" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Branch Name</th>
                                        <th scope="col">Branch Code</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="show_branchdata">
                                    </tbody>
                                </table>
                            </div>
                            <!-- </div> -->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn" onclick="viewmodaleclose('view_branch');">Close</button>
                            <button type="button" class="selectbranch btn btn-primary  btn_color waves-effect waves-light" onclick="selectbranchinlist()">Select</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_company">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('view_company');">&times;</button>
                            <h4 class="modal-title" id="view_company_title">Company details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box">
                                <!--    <div id="search">  -->
                                <table class="table table-striped" id="company_tab" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Company Name</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="company-show_data">
                                    </tbody>
                                </table>
                                <!-- </div> -->
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn"  onclick="viewmodaleclose('view_company');">Close</button>
                            <button type="button" class="selectcompany btn btn-primary btn_color waves-effect waves-light" onclick="selectcompanyinlist()">Select</button>
                        </div>
                    </div>
                </div>
            </div>
            <!--<div class="modal fade" id="view_customer" >
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('view_customer');">&times;</button>
                            <h4 class="modal-title" id="view_customer_title">Party details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box" style="overflow-x:auto;">
                                <!--  <div id="search">  
                                <table class="table table-striped table-bordered" width="100%" id="list_party">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">ID</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Street</th>
                                        <th scope="col">City</th>
                                        <th scope="col">Country</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Branch Code</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                    <!--  <tbody id="customer-show_data">
                                    </tbody> 
                                </table>
                                <!-- </div> 
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn" onclick="viewmodaleclose('view_customer');">Close</button>
                            <button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light" onclick="selectshipperinlist()">Select</button>
                        </div>
                    </div>
                </div>
            </div>-->
            <!--<div class="modal fade" id="view_party" >
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('view_party');">&times;</button>
                            <h4 class="modal-title" id="view_party_title">Party details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box" style="overflow-x:auto;">
                                <table class="table table-striped add-edit-table table-bordered table_bg" id="partylistdata" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">ID</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Party Type</th>
                                        <th scope="col">Street</th>
                                        <th scope="col">City</th>
                                        <th scope="col">Country</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Branch Code</th>
                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" onclick="viewmodaleclose('view_party');" class="btn btn-default waves-effect btn_color resetbtn">Close</button>
                            <button type="button" class="selectparty btn btn-primary  btn_color waves-effect waves-light" onclick="selectpartyinlist()">Select</button>
                        </div>
                    </div>
                </div>
            </div>-->
            <div id="create_popupreference" class="modal fade" tabindex="-1" role="dialog"  aria-hidden="true" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" onclick="viewmodaleclose('create_popupreference');" aria-hidden="true">×</button>
                            <h4 class="modal-title" id="companyCodeAddmodalLabel">
                                Add Reference Details
                            </h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label>Reference Name</label>
                                        <input type="hidden" name="popupref_row_id" id="popupref_row_id" value="">
                                        <input type="text"  class="popupref Txtfld form-control" id="popupreference_id"  value="" onkeyup="upper(this);" size="20" >
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="Description">Description</label>
                                        <input type="text" class="popupref Txtfld form-control" onkeyup="upper(this);" id="popupreference_name" size="20" value="">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label>Reference Value</label>
                                        <input type="text"class="popupref form-control Txtfld "  id="popupreference_value" onkeyup="upper(this);"   size="20" value="">
                                        <input type="hidden" name="order_ref_id" id="order_ref_id">
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="row">

                            </div> -->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default waves-effect btn_color resetbtn" onclick="viewmodaleclose('create_popupreference');">Close</button>
                            <input type="submit" class="submittypebtn btn-primary  btn_color waves-effect waves-light" id="popupadd_refernce" onclick="addpopupreferencedetails(event)" data-dismiss="close"  data-info="add" value="Save">

                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>




        </div>

    </div>

</div>
<!-- end col -->
</div>
<!-- end row -->
</div>




<!-- EDIT modal -->
<div class="modal fade tabsModalView" id="editOrderModal" tabindex="-1" aria-labelledby="editModalLabel">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

    </div>
  </div>
</div>
<!-- EDIT modal -->

<!-- VIEW modal -->
<div class="modal fade tabsModalView " id="viewOrderModal" tabindex="-1" aria-labelledby="viewModalLabel">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
    
    </div>
  </div>
</div>
<!-- VIEW modal -->

<!-- ADD modal -->
<div class="modal fade tabsModalView" id="addOrderModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

    </div>
  </div>
</div>
<!-- ADD modal -->


<?php include('addpallets.php');?>
<?php include('charges_distribution_modal.php');?>
<script>
    var baseurl = "<?= base_url();?>";
    var rateServiceId = <?= $rateServiceRowIdForBook?>;
    if (rateServiceId > 0) {
        $('#quickBookId').click();
    }
    var referenceNoLanguageString = '<?= $this->lang->line('reference_no'); ?>';
</script>
<script src="<?= base_url() ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<link href="<?= base_url() ?>assets/css/jquery.datetimepicker.css" rel="stylesheet">
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.js"></script>
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.full.js"></script>
<script>
    var bookingSearchURL= "orderrevenues/getorderids";
    var referenceSearchURL = "carrier/getrefinfo/massstatus";
</script>
<?php $this->load->view("searchBookingIds"); ?>
<?php $this->load->view("carriersPopUpForNzManifest"); ?>
<script  src="<?= base_url(); ?>assets/sweetalerts/sweetalert.min.js"></script>
<script>
 var baseurl = "<?= base_url();?>";
</script>
<!-- Google APi for address autocomplete - ishak@thhrs.com -->
		 <?php if ($this->session->userdata('company_code') == "NZKN") { ?>
			<script src="https://maps.googleapis.com/maps/api/js?key=<?= GOOGLE_MAP_KEY; ?>&libraries=places&callback=initAutocomplete" async defer></script>
	<script type='text/javascript'>
	$(document).ready(function() {
		var autocompletesWraps = ['facility_address', 'source_address'];
		createGeoListeners(autocompletesWraps);
	});
	// Perhaps put these into a javascript library
	function createGeoListeners(autocompletesWraps) {
		var options = {types: ['geocode']};
		var inputs = $('.autocomplete');
		var autocompletes = [];
		for (var i = 0; i < inputs.length; i++) {
			var autocomplete = new google.maps.places.Autocomplete(inputs[i], options);
			autocomplete.inputId = inputs[i].id;
			autocomplete.setComponentRestrictions({'country': ['NZ']});
			autocomplete.parentDiv = autocompletesWraps[i];
			autocomplete.addListener('place_changed', fillInAddressFields);
			inputs[i].addEventListener("focus", function() {
				geoLocate(autocomplete);
			}, false);
			autocompletes.push(autocomplete);
		}
	}
	function fillInAddressFields() {
		$('.googleerror').removeClass('is-valid is-invalid');
		var place = this.getPlace();
		for (var i = 0; i < place.address_components.length; i++) {
			var addressType = place.address_components[i].types[0];
			var val = place.address_components[i].long_name;
			//console.log("address Type " + addressType + " val " + val + " pd " + this.parentDiv);
			if(addressType=='street_number'){
				var street_number_val = place.address_components[i].long_name;
			}
			 if(addressType=='route'){
				if(street_number_val=='undefined' || street_number_val=='' || street_number_val==null){
				var val = place.address_components[i].long_name;
			}else{
				var val = street_number_val+ " " +place.address_components[i].long_name;
			}
			}
			$('#'+this.parentDiv).find("."+addressType).val(val);
			$('#'+this.parentDiv).find("."+addressType).attr('disabled', false);
        }
    }

    function geoLocate(autocomplete) {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle({
                    center: geolocation,
                    radius: position.coords.accuracy
                });
                autocomplete.setBounds(circle.getBounds());
            });
        }
    }

    function gm_authFailure() {
        $('.gm-err-autocomplete').addClass('is-invalid');
        swal("Error", "There is a problem with the Google Maps or Places API", "error");
    }

    </script>
         <?php
         } ?>
<script type="text/javascript">
    function updatebulkcargo(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push($(this).attr("id"));
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Select anyone to Update Cargo');
            return false;
        } else {
            $('.updcargo-form').val("");
            $("#cargobulkupload").modal('show');
            $('#cargo_orderids').val(ids);
        }
    }
     function submitbulkcargos_fororder(e){
        e.preventDefault();
        var ids = $('#cargo_orderids').val();
        var cargo_type = $('#updatcargo_val').val();
        if(cargo_type == ""){
            gettoast('top-right1','updatcargo_val','Select Cargo Type');
            return false;
        }else{
            $.ajax({
                url: baseurl + 'orderrevenues/updatebulkcargo',
                type: "POST",
                data: {'order_ids': ids,'cargo_type':cargo_type},
                success: function (data) {
                    $('#cargoupd_success').css('display','block');
                    setTimeout(function () {
                        $('#cargoupd_success').fadeOut('fast');
                    }, 1000);
                    setTimeout(function () {
                        $("#cargobulkupload").modal('hide');
                    }, 2000);
                }
            });
        }
    }


    var list_type = $('#list_type').val();
    if(list_type == '1'){
        getorderslist();
    }
    
    var ats = $('#ats_parties').val();
    if (ats != "" && list_type == '0') {
        checkatsservice();
    }
    if (list_type > 0) {
        check_excelatsservice();
    }
    function checkatsservice() {

        var ats_parties = $('#ats_parties').val();
        let fd = new FormData();
        fd.append('ats_parties', ats_parties);
        fd.append('action', 'list');

        $.ajax({
            url: baseurl + 'ats/ats_lib',
            type: 'POST',
            processData: false,
            data: fd,
            contentType: false,
            cache: false,
            async: false,
            success: function (data) {
                if (data.trim() == "0" || data.trim() == 0) {
                    // do nothing here. i.e no need to show any model here.
                    console.log("order edit zero hits received");
                } else {
                    $('#atsModel .modal-body').html(data);
                    $('#atsModel').modal('show');
                }
            }
        });
    }
    function check_excelatsservice() {
        var ats_parties = $('#ats_parties').val();
        if(ats_parties != ""){
            let fd = new FormData();
            fd.append('ats_parties', ats_parties);
            fd.append('action', 'count');
            $.ajax({
                url: baseurl + 'ats/ats_lib',
                type: 'POST',
                processData: false,
                data: fd,
                contentType: false,
                cache: false,
                async: false,
                success: function (data) {
                    if (data.trim() == 0 || data.trim() == "0") {
                        // do nothing here.
                        console.log("Zero hits received.");
                    } else {
                        //                    $("#ats_service_model").modal('show');
                        var html = "Total ATS Hit Count is " + data + "";
                        //                    $('.pop_message').html(data);
                        $('#atsModel .modal-body').html(html);
                        $('#atsModel').modal('show');
                    }
                }
            });
        }
    }
    
    var charge_list_type = $('#charge_list_type').val();
    if (charge_list_type == '1') {
        getchargesuploadpopup();
    }
    var knlogin_list_type = $('#knlogin_list_type').val();
    if (knlogin_list_type > 0) {
        getknLoginStatusRespose();
    }

    function getknLoginStatusRespose() {
        $('#knloginstatus_success_list').modal('show');
    }
    function getorderslist(){
        $('#orders_success_list').modal('show');
    }
    function getchargesuploadpopup() {
        $('#charges_success_list').modal('show');
    }
    
    var cllist_type = $('#cllist_type').val();
    if (cllist_type == '1') {
        getclorderslist();
    }
    if (cllist_type > 0) {
        check_excelatsservice();
    }

    function getclorderslist() {
        $('#clorders_success_list').modal('show');
    }

    function checkwildcardsearch(evt) {
        var keyCode = (evt.which) ? evt.which : event.keyCode
        if ((keyCode != 8 || keyCode == 32) && (keyCode < 48 || keyCode > 57)) {
            if (keyCode != 46 && keyCode != 37) {
                return false;
            }
        }
    }

    /*
       Search validation (without entering any value, system should not allow to get result)
    */
    function checkseachvalidation(e) {
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var bookingid = $('#bookingid').val();
        var status = $('#searchstatus').val();
        var wildcardsearch = $('#wildcard_order_id').val();
        var order_references = $('#order_references').val();

        if (toDate == "") {
        } else {
            if (fromDate == "") {
                gettoast('top-right', 'fromDate', 'Please Enter From Date');
                return false;
            }
        }
        if (status == 'SCANNED') {
            if (fromDate == "") {
                gettoast('top-right', 'fromDate', 'Please enter a From date');
                return false;
            } else if (toDate == "") {
                gettoast('top-right', 'toDate', 'Please enter a to date');
                return false;
            } else if (fromDate != "" && toDate != "") {
                let toDateX = toDate.split('-');
                let fromDateX = fromDate.split('-');
                const date1 = new Date(toDateX[2] + '-' + toDateX[1] + '-' + toDateX[0])
                const date2 = new Date(fromDateX[2] + '-' + fromDateX[1] + '-' + fromDateX[0])
                const diffDays = Math.ceil(Math.abs(date2 - date1) / (1000 * 60 * 60 * 24));
                if (diffDays > 62) {
                    gettoast('top-right', 'toDate', 'Difference between two dates should not be greater than 60');
                    return false;
                }

            }

        }
        var company_code = $('#chkcompanycode').val();
        var chkbranchcode = $('#chkbranchcode').val();
        if (company_code == "AUKN" || chkbranchcode == "INCL") {
            var container_no = $('#container_no').val().trim();
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "" && container_no == "" && wildcardsearch == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        } else {
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "" && wildcardsearch == "" && order_references == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        }

        $("<input />").attr("type", "hidden")
            .attr("name", "limit")
            .attr("value", $('#pagination-length').find(":selected").text())
            .appendTo(e);
    }

    $("#popupshipper_country, #popupshipper_country").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseurl + "businesspartners/getcountrieslist",
                type: "POST",
                dataType: "json",
                data: {
                    country: request.term
                },
                success: function (data) {
                    if (data.length == 0) {
                        /* if(type == 'main'){
                           gettoast('top-right',id,'Please Enter Proper Country');
                         }else{*/
                        gettoast('top-right1', id, 'Please Enter Proper Country');
                        /*}*/

                        $('#' + popupshipper_country).val("");
                        return true;
                    } else {
                        response(data);
                    }
                }
            });
        },
    });
    $(".chkpopupcountry").each(function () {
        var id = $(this).attr('id');
        $('#' + id).autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: baseurl + "businesspartners/getcountrieslist",
                    type: "POST",
                    dataType: "json",
                    data: {
                        country: request.term
                    },
                    success: function (data) {
                        if (data.length == 0) {
                            /* if(type == 'main'){
                               gettoast('top-right',id,'Please Enter Proper Country');
                             }else{*/
                            gettoast('top-right1', id, 'Please Enter Proper Country');
                            /*}*/

                            $('#' + id).val("");
                            return true;
                        } else {
                            response(data);
                        }
                    }
                });
            },

        });
    });
    function validatetrip(){
        var carrier = $('#tcarrierid').val();
        var vehicletype = $('#tpvehicle_type').val();
        if(carrier == 277 && vehicletype == ''){
            gettoast('top-right','tpvehicle_type','Please Select Vehicle Type');
            return false;
        }
    }
    var company_code = "<?= $this->session->userdata('company_code');?>";
    if(company_code == 'RUKN'){
        var incoterm = "";
        $.ajax({
            url: baseurl+'orders/getdeliverytermvalue',
            type: 'POST',
            dataType: 'json',
            data: {
                incoterm : incoterm,
            },
            success: function(data) {
                var htm ="<option value=''>Select</option>";
                if(data.length >0){
                    $.each(data,function(key,value){
                        htm +="<option value='"+value.id+"'>"+value.name+"</option>";
                    });
                }
                $('#popupdelivery_terms').html(htm);
            }
        });
    }else{
        $('#incoterm_popup').on('change',function(){
            var incoterm = $(this).val();
            $.ajax({
                url: baseurl+'orders/getdeliverytermvalue',
                type: 'POST',
                dataType: 'json',
                data: {
                    incoterm : incoterm,
                },
                success: function(data) {
                    var htm ="<option value=''>Select</option>";
                    if(data.length >0){
                        $.each(data,function(key,value){
                            htm +="<option value='"+value.id+"'>"+value.id+" "+value.name+"-"+value.incoterm+"</option>";
                        });
                    }
                    $('#popupdelivery_terms').html(htm);
                }
            });
        });
    }

    function filetrasnferfor_selectedorders(){
            $("input:checkbox[name=chck1]:checked").each(function () {
                ids.push({
                    'ids': $(this).attr("id")
                })
            });
            if (ids.length == 0) {
                gettoast('top-right', '', 'Please Select any Order');
                return false;
            } else {
                $.ajax({
                    url: baseurl + 'Sendmultipleaconedi/filetrasnferfor_selectedorders',
                    type: "POST",
                    dataType: 'json',
                    data: {'order_ids': ids},
                    beforeSend: function () {
                        var table = $('#filetransfersucces_list').DataTable();
                        table.destroy();
                        $('#file_tranfer_succeslist').modal('show');
                        $('.filetransfersucces_list-body').html('<tr><td colspan="2" align="center"><img id="gif"  src="<?= base_url();?>assets/images/482.gif"></td></tr>');
                    },
                    success: function (data) {
                       $("#filetransfersucces_list").DataTable({
                            data: data,
                            "bPaginate": true,
                            "paging": true,
                            "bLengthChange": true,
                            "bFilter": true,
                            "bInfo": false,
                            "bAutoWidth": true,
                            "language": {
                                "lengthMenu": '<select class="form-control">' +
                                        '<option value="10">10</option>' +
                                        '<option value="20">20</option>' +
                                        '<option value="30">30</option>' +
                                        '<option value="40">40</option>' +
                                        '<option value="50">50</option>' +
                                        '<option value="-1">All</option>' +
                                        '</select>'
                            },
                            dom: 'Blfrtip',
                            buttons: [
                                'copyHtml5',
                                'excelHtml5',
                                'csvHtml5',
                                'pdfHtml5',
                                'print'
                            ],
                            "columns": [
                                {"data": "id"},
                                {"data": "status"},
                            ]
                        });

                    },error: function (errMsg) {
                        $(".filetransfersucces_list-body").html('<tr><td colspan="2" align="center">Something Went Wrong</td></tr>');
                    }
                });
            }
    }

    function readytoinvoiceforselected(e){
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids':$(this).attr("id")
            })
        });
        if(ids.length==0){
            gettoast('top-right','','Please Select any Order');
            return false;
        }else{
            var table = $('#ready_invoice_tb').DataTable();
            table.destroy();
            $('#readyinvoice_show_data').html('');
            $.ajax({
                url:baseurl+'orderrevenues/makeselectedasinvoice',
                type:"POST",
                dataType:'json',
                data:{'order_ids':ids,'fromdate':from_date},
                beforeSend: function () {
                    $('#readyinvoice_show_data').html('');
                    $('.pop_message_load').html('Please wait..!');
                    $("#ready_invoice").modal('show');
                    // $(".pop_message").html('Please Wait !!');
                },
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    console.log(data);
                    $('.pop_message_load').html('');
                    $("#ready_invoice_tb").DataTable({
                        data: data,
                        "bPaginate": true,
                        "paging": true,
                        "bLengthChange": true,
                        "bFilter": true,
                        "bInfo": false,
                        "bAutoWidth": true,
                        "language": {
                            "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                        },
                        dom: 'Blfrtip',
                        buttons: [
                            'copyHtml5',
                            'excelHtml5',
                            'csvHtml5',
                            'pdfHtml5',
                            'print'
                        ],
                        "columns": [
                            // {"data": "check"},
                            {"data": "id"},
                            {"data": "recipient_role"},
                            {"data": "JFR"},
                            {"data": "message"},
                            {"data": "status"},
                        ],
                    });
                }
            });
        }

    }
    function readytoinvoiceknbill(e){
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids':$(this).attr("id")
            })
        });
        if(ids.length==0){
            gettoast('top-right','','Please Select any Order');
            return false;
        }else{
            $.ajax({
                url:baseurl+'aconedi/index',
                type:"POST",
                data:{'order_ids':ids,'fromdate':from_date},
                beforeSend: function() {
                    $(".containerModal").modal("show");
                    $(".containerModal").find(".modal-title").html("Please Wait...");
                    $(".containerModal").find(".modal-body").html("<center><progress></center>");
                },
                success:function(data){
                    var data = JSON.parse(data);
                    $(".containerModal").modal("hide");
                    if((data.revenue_count > 0) || (data.accural_count > 0)){
                        $(".pop_message").html('EDI Sent to KNbill Successfully');
                    }else{
                        $(".pop_message").html('No charges Found');
                    }
                    $("#insert_success_div").modal('show');
                },
                error: function(errMsg) {
                    $(".pop_message").html('Oops! Something went wrong');
                    $("#insert_success_div").modal('show');

                }
            });
        }

    }

    function isNonSpecialCharCheck(e)
    {
        var keynum;
        var keychar;
        var numcheck;
        // For Internet Explorer
        if (window.event)
        {
            keynum = e.keyCode;
        }
        // For Netscape/Firefox/Opera
        else if (e.which)
        {
            keynum = e.which;
        }
        keychar = String.fromCharCode(keynum);
        //List of special characters you want to restrict
        if (keychar == "'" || keychar == "`" || keychar == "~" || keychar == "+"
            || keychar == "/"  || keychar == "\/" || keychar == "//" || keychar == "\\"
            || keychar == "<" || keychar == ">" || keychar == "^" || keychar == "|")
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    $(document).ready(function(){
        var from_date = $('#fromDate').val();
        if(from_date != ''){
            var date_array = from_date.split("-");
            var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#toDate').datepicker('setStartDate', minDate);
        }
        var advfrom_date = $('#advfrom_date').val();
        if(advfrom_date != ''){
            var date_array = advfrom_date.split("-");
            var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#advto_date').datepicker('setStartDate', minDate);
        }

		<?php if ("VNKN" === $this->session->userdata( 'company_code' )): ?>
            var advpickupfrom_date = $('#advpickupfrom_date').val();
            if(advpickupfrom_date != ''){
                var date_array = advpickupfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advpickupto_date').datepicker('setStartDate', minDate);
            }

            var advdeliveryfrom_date = $('#advdeliveryfrom_date').val();
            if(advdeliveryfrom_date != ''){
                var date_array = advdeliveryfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advdeliveryto_date').datepicker('setStartDate', minDate);
            }
        <?php endif; ?>
    });

    $('#fromDate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#toDate').datepicker('setStartDate', minDate);
    });
    $('#toDate').datepicker({
        format: 'dd-mm-yyyy',
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#fromDate').datepicker('setEndDate', maxDate);
    });

    $('#advfrom_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#advto_date').datepicker('setStartDate', minDate);
    });
    $('#advto_date').datepicker({
        format: 'dd-mm-yyyy',
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#advfrom_date').datepicker('setEndDate', maxDate);
    });

	  <?php if ("VNKN" === $this->session->userdata( 'company_code' )): ?>
        $('#advpickupfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advpickupto_date').datepicker('setStartDate', minDate);
        });
        $('#advpickupto_date').datepicker({
            format: 'dd-mm-yyyy',
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advpickupfrom_date').datepicker('setEndDate', maxDate);
        });


        $('#advdeliveryfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advdeliveryto_date').datepicker('setStartDate', minDate);
        });
        $('#advdeliveryto_date').datepicker({
            format: 'dd-mm-yyyy',
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advdeliveryfrom_date').datepicker('setEndDate', maxDate);
        });

    <?php endif; ?>

    $(document).ready(function(){
        var company_code = "<?= $this->session->userdata('company_code');?>";
        if(company_code == "INKN"){
            $("#popupshipper_zipcode").on('change', function() {
                if($(this).val() != ""){
                    $.ajax({
                        url: baseurl+'live/getcovidstatusbypincode',
                        type:"POST",
                        dataType:'JSON',
                        data:{'pincode':$(this).val()},
                        beforeSend:function(){
                            $(".covid19pickupstatus").html("");
                        },
                        success:function(data){
                            console.log(data);
                            if(data.status == 200){
                                var data1 = data.data;
                                var covid19 = data1[0];
                                if(covid19['containmentsAvailability']){
                                    var msg = "";
                                    /*if(covid19['city']){
                                     msg += "<strong>City:</strong> "+covid19['city']+"<br/>";
                                    }else{*/
                                    msg += "<strong>City:</strong> "+covid19['district']+"<br/>";
                                    /*}*/
                                    /*if(covid19['name']){
                                     msg += "<strong>Area:</strong> "+covid19['name']+"<br/>";
                                    }else{*/
                                    msg += "<strong>Area:</strong> "+covid19['containmentZoneName']+"<br/>";
                                    /*}*/
                                    /*if(covid19['zoneType']){
                                     msg += "<strong>Zone Type:</strong> "+covid19['zoneType']+"<br/>";
                                     var dzone = covid19['zoneType'];
                                    }else{*/
                                    var zonetype = "NA";
                                    if(covid19['districtCurrentActive'] != "NA"){
                                        zonetype = covid19['districtCurrentActive'];
                                    }
                                    msg += "<strong>Total Confirmed:</strong> "+covid19['districtTotalConfirmed']+"<br/>";
                                    msg += "<strong>Current Active:</strong> "+covid19['districtCurrentActive']+"<br/>";
                                    var dzone = zonetype;
                                    /*}*/
                                    var cvcolor = "#FF0000";
                                    if(dzone == "Green Zone"){
                                        cvcolor = "#008000";
                                    }else if(dzone == "Containment Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "Orange Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "NA"){
                                        cvcolor = "#008000";
                                    }else if(dzone > 100){
                                        cvcolor = "#FFA500";
                                    }
                                    msg += "<strong>Map View:</strong> <a href='"+baseurl+"live/covid19map/"+data.lat+"/"+data.lng+"/"+dzone+"' title='Zone in Map View' target='_blank'><span class='fa fa-map-marker' aria-hidden='true' style='color:"+cvcolor+";'></span></a>";
                                    $(".covid19pickupstatus").html(msg);
                                }
                            }
                        }
                    });
                }
            });
            $("#popupconsignee_zipcode").on('change', function() {
                if($(this).val() != ""){
                    $.ajax({
                        url: baseurl+'live/getcovidstatusbypincode',
                        type:"POST",
                        dataType:'JSON',
                        data:{'pincode':$(this).val()},
                        beforeSend:function(){
                            $(".covid19deliverstatus").html("");
                        },
                        success:function(data){
                            console.log(data);
                            if(data.status == 200){
                                var data1 = data.data;
                                var covid19 = data1[0];
                                if(covid19['containmentsAvailability']){
                                    var msg = "";
                                    /*if(covid19['city']){
                                     msg += "<strong>City:</strong> "+covid19['city']+"<br/>";
                                    }else{*/
                                    msg += "<strong>City:</strong> "+covid19['district']+"<br/>";
                                    /*}*/
                                    /*if(covid19['name']){
                                     msg += "<strong>Area:</strong> "+covid19['name']+"<br/>";
                                    }else{*/
                                    msg += "<strong>Area:</strong> "+covid19['containmentZoneName']+"<br/>";
                                    /*}*/
                                    /*if(covid19['zoneType']){
                                     msg += "<strong>Zone Type:</strong> "+covid19['zoneType']+"<br/>";
                                     var dzone = covid19['zoneType'];
                                    }else{*/
                                    var zonetype = "NA";
                                    if(covid19['districtCurrentActive'] != "NA"){
                                        zonetype = covid19['districtCurrentActive'];
                                    }
                                    msg += "<strong>Total Confirmed:</strong> "+covid19['districtTotalConfirmed']+"<br/>";
                                    msg += "<strong>Current Active:</strong> "+covid19['districtCurrentActive']+"<br/>";
                                    var dzone = zonetype;
                                    /*}*/
                                    var cvcolor = "#FF0000";
                                    if(dzone == "Green Zone"){
                                        cvcolor = "#008000";
                                    }else if(dzone == "Containment Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "Orange Zone"){
                                        cvcolor = "#FFA500";
                                    }else if(dzone == "NA"){
                                        cvcolor = "#008000";
                                    }else if(dzone > 100){
                                        cvcolor = "#FFA500";
                                    }
                                    msg += "<strong>Map View:</strong> <a href='"+baseurl+"live/covid19map/"+data.lat+"/"+data.lng+"/"+dzone+"' title='Zone in Map View' target='_blank'><span class='fa fa-map-marker' aria-hidden='true' style='color:"+cvcolor+";'></span></a>";
                                    $(".covid19deliverstatus").html(msg);
                                }
                            }
                        }
                    });
                }
            });
        }
    });
    function deleteorderbyid(orderid){
        var x = confirm("Are you sure you want to delete this Order?");
        if (x){
            $.ajax({
                url:baseurl+'orders/deleteorder/'+orderid,
                type:"GET",
                success:function(){
                    location.reload();
                }
            });
        }else{
            return false;
        }
    }
     $('#toldcarrierid').on('change', function() {
        var id=$("#tcarrierid").val();
        if(id==''){
            $("#nccode").val('');
            return false;
        }
        $.ajax({
            url: baseurl+'orders/gettripcarinfo/'+id,
            type:"POST",
            dataType:'JSON',
            success:function(data){
                $(".tripcar_name").val(data.carrier_name);
                $("#tdrivespan").html(data.drivers);
            }
        });
    });
    $('#tcarrierid').on('change', function() {
        var id=$("#tcarrierid").val();
        if(id==''){
            $("#nccode").val('');
            return false;
        }
        $.ajax({
            url: baseurl+'orderrevenues/getVehicleDetailsByCarrierInfo',
            type:"POST",
            data:{carrierId:id},
            dataType:'JSON',
            success:function(data){
                vehicles = data.vehicles;
                $(".tripcar_name").val(data.carrierCode);
                var htm ="<option value=''>Select</option>";
                var driverHtm = "<option value=''>Select</option>";
                if(vehicles.length >0){
                    $.each(vehicles,function(key,value){
                        htm +="<option value='"+value.id+"'>"+value.register_number+"</option>";
                    });
                }
                $('#tvehnum').html(htm);
                $('#tdri_name').html(driverHtm);
            }
        });
    });
    $('#tpoldvehicle_type').on('change', function() {
        var id=$("#tpvehicle_type").val();
        if(id!=''){
            var carrierid=$('#tcarrierid').val();
            $("#tvehid").val('');
            if(carrierid==''){
                $("#dialog").dialog();
                $(".ui-dialog").addClass('alert_zindex');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog-text").text("Please select carrier details");
                return false;
            }
            $.ajax({
                url: baseurl+'orders/gettripvelinfo',
                type:"POST",
                data: {
                    carrierid : carrierid,vtype : id,
                },
                dataType:'JSON',
                success:function(data){
                    $("#tpveh_typename").val(data.typename);
                    $("#tpveh_numdiv").html(data.vehiclenum);
                }
            });
        }else{
            $("#tpveh_typename").val('');
            return false;
        }

    });
    $('#tvehnum').on('change',function(){
        var vehicle_num = $( "#tvehnum option:selected" ).val();
        var carrier_id = $('#tcarrierid').val();
        if(vehicle_num == ""){
            $('#tcarrierid').trigger("change");
        }else{
            var carrier_id = $("#tcarrierid option:selected").val();
            var register_number = $( "#tvehnum option:selected" ).html();
            $('#tvehid').val(register_number);
            $.ajax({
            url:baseurl+"shipmentplan/getdriversbyvendor",
            type:"POST",
            data:{'carrier_id': carrier_id},
            dataType:"JSON",
            success:function(data){
                if(data['drivers'].length==0){
                    $("#tdri_name").html("<option value=''>-Driver(s) not found-</option>");
                }else{
                    $("#tdri_name").html("<option value=''>-select-</option>");
                }
                $.each(data["drivers"],function(i,value){
                    var sts = "";
                    $("#tdri_name").append("<option  value='"+value.id+"'> "+value.name+" </option>");
                });
            }
        });
        }
    })
    $('#tpvehicle_type').on('change', function() {
        var id=$("#tpvehicle_type").val();
        if(id!=''){
            var carrierid=$('#tcarrierid').val();
            $("#tvehid").val('');
            if(carrierid==''){
                $("#dialog").dialog();
                $(".ui-dialog").addClass('alert_zindex');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog-text").text("Please select carrier details");
                return false;
            }
            $.ajax({
                url: baseurl+'orderrevenues/getVehicleDetailsByCarrierInfo',
                type:"POST",
                data: {
                    carrierId : carrierid,vehicleType : id,
                },
                dataType:'JSON',
                success:function(data){
                    var vehicleTypeName = data.vehicleTypeName;
                    if(vehicleTypeName != ""){
                        $("#tpveh_typename").val(vehicleTypeName);
                    }
                    vehicles = data.vehicles;
                    var htm ="<option value=''>Select</option>";
                    if(vehicles.length >0){
                        $.each(vehicles,function(key,value){
                            htm +="<option value='"+value.id+"'>"+value.register_number+"</option>";
                        });
                      }
                    $('#tvehnum').html(htm);
                }
            });
        }else{
            $("#tpveh_typename").val('');
            return false;
        }
    });
    function myfun(){
        var id=$("#tvehnum").val();
        if(id!=''){
            $.ajax({
                url: baseurl+'orders/getvelinfo/'+id,
                type:"POST",
                dataType:'JSON',
                success:function(data){
                    if(data.transit==1){
                        $("#tvehid").val('');
                        $("#dialog").dialog();
                        $(".ui-dialog").addClass('alert_zindex');
                        $('.ui-dialog-title').addClass('fa fa-warning');
                        $("#dialog-text").text("Vehicle already in Transit Mode, Please select another Vehicle");
                        var id=$("#tpvehicle_type").val();
                        var carrierid=$('#tcarrierid').val();
                        if(carrierid==''){
                            $("#dialog").dialog();
                            $(".ui-dialog").addClass('alert_zindex');
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $("#dialog-text").text("Please select carrier details");
                            return false;
                        }
                        $.ajax({
                            url: baseurl+'orders/gettripvelinfo',
                            type:"POST",
                            data: {
                                carrierid : carrierid,vtype : id,
                            },
                            dataType:'JSON',
                            success:function(data){
                                $("#tpveh_typename").val(data.typename);
                                $("#tpveh_numdiv").html(data.vehiclenum);
                            }
                        });
                        return false;
                    }else{
                        $("#tvehid").val(data.vehid);
                    }
                }
            });
        }else{
            $('#tvehid').val('');
            return false;
        }
    }
    function getdrid(){
        var vehicle_num = $( "#tvehnum option:selected" ).val();
        if(vehicle_num == ""){
            $('#tcarrierid').trigger("change");
        }else{
            var id=$("#tdri_name").val();
            if(id!=""){
                $.ajax({
                    url: baseurl+'orders/getdriverid/'+id,
                    type:"POST",
                    success:function(data){
                        $("#tdri_id").val(data);
                    }
                });
            }else{
                $('#tdri_id').val('');
                return false;
            }
        }
    }
    function applyconsolidation(e,branch) {
        var ids = [];
        var consolidation_id = $("#consolidation_id").val();
        $("input:checkbox[name=chck1]:checked").each(function() {
            var found = $.inArray($(this).attr("id"), ids);
            if (found >= 0) {
                ids.splice(found, 1);
            } else {
                ids.push($(this).attr("id"));
            }
        });
        var validate = 0;
        if (ids.length > 0) {
          validate = validateconsolidation(ids, e);
        }
        if (consolidation_id.length == 0) {
            gettoast('top-right1', 'select2-consolidation_id-container', 'Select Consolidation Rule');
            return false;
        } else if (ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Order');
            return false;
        }else if (ids.length > 1000) {
            gettoast('top-right', '', 'Too many orders were selected, please adjust your search. Up to 1000 orders could be selected for consolidation.');
            return false;
        }else if (validate == 1) {
            gettoast('top-right', '', 'There are orders which were not allocated to a trips. Please adjust your search or allocate all orders to trips');
            return false;
        }else if (validate == 2 && branch == 0) {
            $("#consolidation_modal").modal("hide");
            $("#insert_success_div").modal('show');
            $('.hide_popbutton').hide();
            $('.show_popbutton').show();
            $(".pop_message").html('Different branches were selected.Do you want to continue?');
        } else {
            $.ajax({
                url: baseurl + 'Consolidation/applyconsolidation',
                type: "POST",
                dataType: 'json',
                data: {
                    'order_ids': ids,'consolidation_id':consolidation_id
                },
                beforeSend: function() {
                    $("#consolidation_modal").modal("hide");
                    $(".containerModal").modal("show");
                    $(".containerModal").find(".modal-title").html("Consolidation is on progress..");
                    $(".containerModal").find(".modal-body").html("<center><progress></center>");

                },
                success: function(data) {
                    if (data == 0) {
                        var msg = 'Consolidation rule UOM not found in GeoTiers';
                    }else if (data == 1) {
                        var msg = 'Orders not found for Consolidation';
                    }
                    else if (data == 2) {
                        var msg = 'Charges lines not found for Consolidation';
                    }else if (data == 6) {
                        var msg = 'Grouped orders not found';
                    }else if (data == 7) {
                        var msg = 'Consolidation rule UOM doesnt match with GeoTiers UOM';
                    }else if (data == 10) {
                        var msg = 'Consolidation applied successfully!';
                    }else{
                        var msg = 'Consolidation not possible';
                    }
                    $(".containerModal").modal("hide");
                    $("#consolidation_modal").modal("hide");
                    $(".pop_message").html(msg);
                    $('.hide_popbutton').show();
                    $('.show_popbutton').hide();
                    $("#insert_success_div").modal('show');
                },
                error: function(errMsg) {
                    $(".containerModal").modal("hide");
                    $(".pop_message").html('Oops! Something went wrong');
                    $('.hide_popbutton').show();
                    $('.show_popbutton').hide();
                    $("#insert_success_div").modal('show');
                }
            });
        }
    }
    function validateconsolidation(ids, e) {
      var data;
        $.ajax({
            url: baseurl + 'Consolidation/validateconsolidation',
            async: false,
            type: "POST",
            data: {
                    'order_ids': ids
                },
            dataType: 'JSON',
            success: function (resp) {
                data = resp;
            }
        });
        return data;
        }

    $('#select2-consolidation_id-container').keypress(function() {

        if ($('#select2-consolidation_id-container').hasClass('errorclass')) {

            $('#select2-consolidation_id-container').removeClass('errorclass');

        }

    });
    $('#select2-consolidation_id-container').click(function() {

        if ($('#select2-consolidation_id-container').hasClass('errorclass')) {

            $('#select2-consolidation_id-container').removeClass('errorclass');

        }

    });
</script>
<script type="text/javascript">
    function importFromGSheets() {
        window.location = '<?= base_url('gdocs/selectFile');?>';
    }
    var company_code = $('#chkcompanycode').val();
    $('#buttonid').on('click',function(){
        if(company_code == "IDKN"){
            $("#indexlfile").click();
        }
        else if (company_code == "KNAU") {
            $("#indexaufile").click();
        }
        else{
            $("#exlfile").click();
        }
    });
    $('#buttonsgid').on('click',function(){
        /*$("#exlsgfile").click();*/
        $("#exlsgupfile").click();
    });
    $('#buttoncargoid').on('click',function(){
        $("#exlcargoupfile").click();
    });
    
    $('#buttonclid').on('click', function () {
        $("#exlclupfile").click();
    });
    
    $('#buttoninid').on('click',function(){
        /*$("#exlsgfile").click();*/
        $("#exlinupfile").click();
    });
    $('#buttoncostid').on('click',function(){
        $("#exlcostfile").click();
    });
    $(document).ready(function(){
        $(".datetimepicker").datetimepicker({
            format:"Y-m-d H:i:s",
            /* minDate : 0,
             minTime: 0,*/
            autoclose: true,
        });
    });
    $('.closevalues').click(function(){
        $('.quickbookform').val("");
        $('#shipper_details').html("");
        $('#consignee_details').html("");
        var company_code = "<?= $this->session->userdata('company_code');?>";
        var branch_code = "<?= $this->session->userdata('branch_code');?>";
        $('#popupcompany_code').val(company_code);
        $('#popupbranch_code').val(branch_code);
        var custid = "<?= $this->session->userdata('cust_id');?>";
        if(custid == ""){
            $('#customer_details').html("");
            $('#popupcustomer_id').val("");
        }

    });
    popupheight.oninput = function() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_height = height;
        $('#mainpopupheight').val(main_height);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        if(height != "" && width != "" && length != ""){
            var volume= length * width * height;
            $('#popupvolume').val(volume);
        }
    }; popupweight.oninput = function() {

        var weight =$('#popupweight').val();
        var quantity = $('#popupquantity').val();
        var main_weight = weight;
        $('#mainpopupweight').val(main_weight);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");

    };
    popupwidth.oninput = function() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_width = width;
        $('#mainpopupwidth').val(main_width);
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        if(height != "" && width != "" && length != ""){
            var volume= length * width * height;
            $('#popupvolume').val(volume);
        }
    };
    function changepopupbylength() {
        var height = $('#popupheight').val();

        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height =$('#popupheight').val();
        $('#popupquantity').attr("onkeyup","changepopupdimensions(this);");
        var quantity = $('#popupquantity').val();
        var main_length = length;
        $('mainpopuplength').val(main_length);
        if(height != "" && width != "" && length != ""){
            var volume = length * width * height;
            $('#popupvolume').val(volume);
        }

    }

    function sendorderdetailsclick(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 1) {
            /*   $('.order-tabs').removeClass('active');
               $('#order-details').addClass('active');
               $('.tab-pane').removeClass('active');
               $('#details').addClass('active')*/

            var id = ids[0]['ids'];
            $.ajax({
                url: baseurl + 'orders/getorderdetails/' + id,
                beforeSend: function () {
                },
                success: function (data) {
                    //  $('#bodyDataDiv').html(data);
                }
            });
        }
    }

    function checkpopuppurchaseordervalue() {
        var val = $('#purchaseorder_popup').val();
        var customer_id = $('#popupcustomer_id').val();
        $.ajax({
            url: baseurl+'orders/checkpurchaseordervalue',
            type: 'POST',
            dataType: 'json',
            data: {'purchase_order' : val,'customer_id':customer_id},
            success: function(data){
                if(data == 1){
                    /*$("#dialog").dialog();
                    $('.ui-dialog-title').addClass('fa fa-warning');
                     $(".ui-dialog").addClass('alert_zindex');
                    $("#dialog-text").html("Purchase Order already exist with another order");
                    $('.ui-dialog-titlebar-close').click(function(){*/
                    $('#purchaseorder_popup').val('');
                    // $('#purchaseorder_popup').focus();
                    gettoast('top-right1', 'purchaseorder_popup', 'Purchase Order already exist with another order');
                    /* });*/
                }
            }
        });
    }

    function addreferenceforquickbook(e){
        e.preventDefault();

        $('#popupref_row_id').val('');
        $('.popupref').val("");
        $("#create_popupreference").modal('show');
    }
    function viewmodaleclose(id){
        $('#'+id).modal('hide');
    }
    function changepopupdimensions(ele){
        var count = $(ele).val() * 1;
        if(count >= '1'){
            var plength = $('#popuplength').val();
            var pwidth = $('#popupwidth').val();
            var pheight = $('#popupheight').val();
            var pweight = $('#popupweight').val();
            var weight = pweight * count;
            /*  var length = plength * count;
              var width = pwidth * count;
              var height = pheight * count;
             */
            /*$('#popuplength').val(length);
            $('#popupwidth').val(width);
            $('#popupheight').val(height);*/
            $('#popupweight').val(weight);

            var volume = plength * pwidth * pheight * count;
            $('#popupvolume').val(volume);
        }

    }

    $('.checkAll').on('click', function() {
        if (this.checked == true)
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', true);
        else
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', false);
    });
    /* pallet add model pop */
    function palletadd(id){
        $('#order_row_id').val(id);
        $('#Modal_Add').modal('show');
    }
    /* Advanced search reference type validation */
    function checkreference(e){
        var order_reftype = $('#order_reftype').val();
        var ref_val = $('#ref_val').val();

        if(order_reftype != ""){
            if(ref_val == ""){
                gettoast('top-right','ref_val','Please Enter reference Value');
                return false;
            }
        }
        $("<input />").attr("type", "hidden")
            .attr("name", "limit")
            .attr("value", $('#pagination-length').find(":selected").text())
            .appendTo(e);
    }

    $(document).ready(function(){
        <?php if(isset($_SESSION['download_files'])){ ?>
        var link = document.createElement('a');
        <?php  foreach($_SESSION['download_files'] as $file){ ?>
        link.style.display = 'none';
        var value = "<?= $file?>";
        document.body.appendChild(link);
        link.setAttribute('download', value);
        var downloadurl = baseurl+'assets/manifestdocs/'+value;
        link.setAttribute('href', downloadurl);
        link.click();
        <?php } ?>
        document.body.removeChild(link);
        <?php unset($_SESSION['download_files']); } ?>
    });
    /*cancel shipment confirm message*/
    function checkcancelconfirm(){
        if (confirm('Are you sure to cancel this trip?')){
            return true;
        }else{
            return false;
        }
    }
    function checktriprevertconfirm(){
        if (confirm('Are you sure to Revert this trip?')){
            return true;
        }else{
            return false;
        }
    }
</script>
<link href="<?= base_url() ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css" />
<script src="<?= base_url() ?>assets/newtheme/js/custom.js?v=1.1"></script>
<script src="<?php echo base_url(); ?>assets/newtheme/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/newtheme/plugins/datatables/dataTables.bootstrap.js"></script>
<script src="<?= base_url() ?>assets/js/jquery-ui.js"></script>
<script src="<?= base_url() ?>assets/newtheme/js/main.js"></script>
<script src="<?= base_url() ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url() ?>assets/js/order_script.js?v=1.0"></script>

<style type="text/css">
 #cargobulkupload .modal-dialog {
        width: 30%;
        margin: 30px auto;
    }
    #cargobulkupload .modal-footer, {
        padding: 5px 15px;

    }
    #cargobulkupload .modal-body {
        position: relative;
        padding: 5px;
    }
    #cargobulkupload .modal-header {
        /*background-color: white;*/
    }
    .dataTables_empty{
        height: 30px;
    }
    #quickbook_popup {
        overflow-y:auto;

    }
    .select2-selection__choice{
        color: white;
    }
    .popupcargo_form {
        margin-bottom: 0px;
    }
    FIELDSET    { PADDING-TOP:0px; PADDING-BOTTOM:4px; BORDER:solid 1px #ccc;}
    LEGEND      {COLOR:black; FONT-WEIGHT:bold;font-size: 13px;}
</style>
<?php
    $auArray = array('AUKN','KNAU');
    if(in_array($this->session->userdata('company_code'),$auArray)){
        $labelUrl= base_url().'bulkOrderLabel/bulkMacpacLabels';
    }else{
         $labelUrl= base_url().'bulkOrderLabel/orderlabel';
    }
?>
<form method="POST" action="<?= $labelUrl; ?>" id="bulkLabelPdfForm">
    <input type="hidden" name="orderIds" id="bulkOrderArray">
</form>

<script>
function deleteselectedrecords()
{
    var selectedrecords = [];
    $('input.recordcheckbox:checkbox:checked').each(function () {
        selectedrecords.push($(this).val());
    });
    if(selectedrecords.length==0)
    {
        gettoast('top-right1', '', 'No records were selected for this operation');
        return false;
    }
    else{
        swal({
            title: 'Are you going to delete these records?',
            text: 'There will be no way to restore them. Would you like to continue',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'No, cancel !',
            closeOnConfirm: true,
            closeOnCancel: false
            }, function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    type:"post",
                    url:"<?= base_url('orders/deleteorders/');?>",
                    data:{deleteids:selectedrecords},
                    success:function(data)
                    {
                        location.reload();
                    },
                })
            }
            else {
                swal('Cancelled', 'Your record is safe :)', 'error');
            }
        });
    }
}

function disableOtherInputFields() {
    var url = baseurl + "orders/triporderintoshipment";
    var templateId = $('#templateId').val();
    if (templateId != "") {
        url = baseurl + "tripstemplate/storeShipmentByTemplate";
        $('.tripcreatefields').prop('disabled', true);
        $('#tcarrierid').attr('required', false);
    } else {
        $('.tripcreatefields').prop('disabled', false);
        $('#tcarrierid').attr('required', true);
    }
    $("#tripcreation").attr("action", url);
}

function sendShipmentStatusxml(e) {
    e.preventDefault();
    var ids = [];
    $("input:checkbox[name=chck1]:checked").each(function () {
        ids.push($(this).attr("id"));
    });
    if (ids.length == 0) {
        gettoast('top-right', '', 'Please select atleast one order');
    } else if (ids.length > 5) {
        gettoast('top-right', '', 'Maximum orders to be selected are 5');
    } else {
        $.ajax({
            url: baseurl + 'shipmentxmldata/sendOrderStatusXmlstoKNlogin',
            type: "POST",
            data: {'ids': ids},
            dataType: 'json',
            beforeSend: function () {
            },
            success: function () {
                location.href = baseurl + 'orders/orderslist/04';
            }
        });
    }
}

function checkDggoods(){
    if ($('#popupdg_goods').prop('checked') == true) {
        getDangerousGoodsDetails(0,0,0,1);
    }
}

</script>
