<?php if(!empty($final_data)) { ?>
    <table width="100%">
        <tr>
            <td align="left"><img width ="170" height="50" src="./assets/images/logo-1807.png"></td>
            <td align="left"><b><span style="font-size: 28px;"><?= strtoupper($this->lang->line('manifest'))?></span></b>  </td>
            <td align="left"><span style="font-size: 14px;"><?= $carrier_name ?? '' ?></span></td>
            <td align="center">
                <?php
                $curtd = date('Y-m-d H:i:s');
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $getdate = getdatetimebytimezone(DFLT_TZ, $curtd, $curtz);
                $nz_date = date('d/m/Y',strtotime($getdate['date']));
                $nz_time = date('H:i',strtotime($getdate['time']));
                $manifest_no = date('Ymd',strtotime($getdate['date']));
                ?>
                <small>
                    <span><?= $this->lang->line('date')." : ".$nz_date?></span><br>
                    <span style="margin-left: -25px;"><?= $this->lang->line('gen_time'). " : ".$nz_time?></span><br>
                    <span style="margin-left: 15px;"><?= $this->lang->line('manifest_no')." : ".$manifest_no?></span>
                </small>
            </td>
        </tr>
    </table>
    <br>
    <table width="100%">
        <tr class="main-header">
            <th align="center" class="main-th"><?= strtoupper($this->lang->line('booking_id'))?></th>
            <th align="center" class="main-th"><?= strtoupper($this->lang->line('qbook_deliverynote'))?></th>
            <th align="center" class="main-th static-width"><?= strtoupper($this->lang->line('general_shipper'))?></th>
            <th align="center" class="main-th static-width"><?= strtoupper($this->lang->line('general_consignee'))?></th>
            <th align="center" class="main-th static-width"><?= strtoupper($this->lang->line('general_consignee'))."  ".strtoupper($this->lang->line('general_city'))?></th>
            <th align="center" class="main-th"><?= strtoupper($this->lang->line('packages'))?></th>
        </tr>
        <?php foreach($final_data as $row) { ?>
            <tr>
                <td class="main-td" align="center">
                    <?php $orderId = "SVK".$row['order_id']; ?>
                    <img src="<?php echo 'data:image/png;base64,' . base64_encode($row['generator']->getBarcode($orderId, $row['generator']::TYPE_CODE_128))?>" style="height:50px;width:125px">
                    <?= $orderId ?></td>
                <td class="main-td" align="center"><?= $row['deliverynote']?></td>
                <td class="main-td" align="center"><?= $row['pickup_company']?></td>
                <td class="main-td" align="center"><?= $row['delivery_company']?></td>
                <td class="main-td" align="center"><?= $row['delivery_city']?></td>
                <td class="main-td">
                    <table width="100%" style="border-spacing: 15px 25px;">
                        <tr>
                            <th class="border-bottom individual-cargos" align="left"><?php echo $this->lang->line('general_no').". ".$this->lang->line('items');?></th>
                            <th class="border-bottom individual-cargos" align="left">Wt. (kg)</th>
                            <th class="border-bottom individual-cargos" align="left">Vol. (cbm)</th>
                        </tr>
                        <?php $cargos = $row['cargos'];
                        $eachOrderWeight = $eachOrderVolume = $eachOrderQuantity = 0;
                        foreach ($cargos as $eachCargo) {
                            $eachOrderWeight += $eachCargo['weight'];
                            $eachOrderVolume += $eachCargo['volume'];
                            $eachOrderQuantity += $eachCargo['quantity'];
                            ?>
                            <tr>
                                <td class="individual-cargos" align="left"><?= round($eachCargo['quantity']). "  ".$eachCargo['quantity_type']?></td>
                                <td class="individual-cargos" align="left"><?= round($eachCargo['weight'],2)?></td>
                                <td class="individual-cargos" align="left"><?= round($eachCargo['volume'],2)?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td class="border-top individual-cargos" align="left"><b><?= $this->lang->line('general_total')."  ".round($eachOrderQuantity)?></b></td>
                            <td class="border-top individual-cargos" align="left"><b><?= round($eachOrderWeight,2)?></b></td>
                            <td class="border-top individual-cargos" align="left"><b><?= round($eachOrderVolume,2)?></b></td>
                        </tr>
                    </table>
                </td>
            </tr>
        <?php } ?>
        <tr>
            <td colspan="5"></td>
            <td style="border-bottom: 1px solid black;padding-top: 10px;"></td>
        </tr>
        <tr>
            <td colspan="5"></td>
            <td style="padding-top: 5px;">
                <table class="totalcargos-tbl">
                    <tr>
                        <td class="first-cargo-line background-highlight" id="first-cargo-column">&nbsp;&nbsp;<b><?= strtoupper($this->lang->line('general_total'))?></b></td>
                        <td class="first-cargo-line" id="second-cargo-column" align="center"><?= round($row['total_quantity'])?></td>
                        <td class="first-cargo-line" id="third-cargo-column" align="center"><?= round($row['total_weight'],2)?></td>
                        <td class="first-cargo-line" id="fourth-cargo-column"><?= round($row['total_volume'],2)?></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td colspan="5"></td>
            <td class="">
                <table class="totalcargos-tbl">
                    <tr>
                        <td class="second-individual-cargos background-highlight" id="first-sign-column" align="left"><b><?= strtoupper($this->lang->line('sign_here'))?>:</b></td>
                        <td class="second-individual-cargos" id="second-sign-column"></td>
                    </tr>
                </table>
            </td>

        </tr>
    </table>
<?php } ?>

<style type="text/css">
    table {
        border-collapse: collapse;
    }
    td.main-td{
        padding: 15px;
        border-bottom: 1px solid black;
    }
    .main-header, .main-th { border: 1px solid }

    .totalcargos-tbl{
        border: 1px solid black;
    }
    .border-bottom{
        border-bottom: 1px solid black;
    }
    .border-top{
        border-top:  1px solid black;
    }
    .static-width{
        width: 140px;
    }
    .individual-cargos, .first-cargo-line{
        padding: 5px;
    }
    .second-individual-cargos{
        padding: 15px;
    }
    .background-highlight{
        background-color: rgba(128, 128, 128, 0.16);
    }
    #first-cargo-column, #first-sign-column{
        width: 115px;
    }
    #second-cargo-column{
        width: 75px;
    }
    #third-cargo-column{
        width: 105px;
    }
    #fourth-cargo-column{
        width: 10px;
    }
    #second-sign-column{
        width: 215px;
    }

</style>
