<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Livetrack :: Svkonekt</title>
    <link href="<?php echo base_url("assets/livetrack/css/bootstrap.min.css");?>" rel="stylesheet">
    <link href="<?php echo base_url("assets/livetrack/css/style.css");?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo base_url("assets/css/font-awesome.min.css");?>">
    <script src="<?php echo base_url("assets/livetrack/js/jquery.min.js");?>"></script>
    <script src="<?php echo base_url("assets/livetrack/js/bootstrap.min.js");?>"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>&libraries=places&language=en"></script> 
    <script src="<?php echo base_url("assets/livetrack/js/scripts.js");?>"></script>
    <script src="<?php echo base_url('assets/movemarker/markerAnimate.js');?>"></script>
  </head>
  <body>
    <div class="container-fluid">
        <div class="row details-row">
            
        </div>
        <div class="row tt_bottom_pane">
                <div class="col-md-8">
                <div class="row cards-row" style="margin-bottom:15px">
                    <div class="col-xs-6">
                        <div class="row">
                           
                      
                           
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" id="googleMap">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="modal fade in" id="myModal" role="dialog">
	<div class="modal-dialog">

	  <!-- Modal content-->
	  <div class="modal-content" style="border-radius: 10px;">
		<div class="modal-header">
		  <button type="button" class="close" data-dismiss="modal">&times;</button>
		  <h4 class="modal-title" id="mtitle">Loading...</h4>
		</div>
		<div class="modal-body" id="viewdata">
			
		</div>
	  </div>
	</div>
</div>
<?php 
    $finalsts = "a";
    if(count($trip)>0){
        if($trip['status'] == "0"){
            $finalsts = "b";
        }
    }
    $cntrylatlng['ulat'] = 20.5937; 
    $cntrylatlng['ulng'] = 78.9629;
    if(isset($lguid)){
        $cntrylatlng = getLogUserLatLng($lguid);
    }
?>
<script type="text/javascript">
    var fnsts = "<?php echo $finalsts;?>";
    var ulglat = <?php echo $cntrylatlng['ulat'];?>;
    var ulglng = <?php echo $cntrylatlng['ulng'];?>;
    var trip_id = '<?php echo $trip_id;?>';
    var q = [];
    var googleMap;
    var vehicle;
    var nextTimeStamp = "";
    var trackerFrequency = 20000;
    var angle = 0;
    var tokBox = null;
    var trafficLayer;
    var trafficFlag = false;
    var isSimBased = false;
    var bounds;
    var id = '<?php echo $id;?>';
    var order_id = '<?php echo $order_id;?>';
    var mph = 13.8889;
    var tripClose = false;
    var directionsService;
    var directionsDisplay;
    var level1Bounds;
    var showRoute = false;
    $(document).ready(function() {
        level1Bounds = new google.maps.LatLngBounds();
        <?php
        $etime = $tstatus = "";
        if(count($trip)>0){
            $tstatus = $trip['status'];
            if($trip['status']=="0"){
                echo "tripClose = true;";
            }
            $etime = $trip['etime'];
        }
        ?>
        if(tripClose){
            $(".cards-eta").html('<?php echo $etime;?>');
        }
        $(".tt_box").css("width",(window.outerWidth/5) - 16)
        setAllTabs();
        if (window.top !== window.self) {
            $("footer.main-footer").remove();
            $(".main-header").remove();
        
            
            $(".tracking-list").css("height", "auto");
            $(".rightBottom").css("margin-bottom", "0px");
        }
        var drh = $(".details-row").outerHeight();
        var crh = $(".cards-row").outerHeight();
        var th = $(".details-row").closest("body").outerHeight() - drh - crh - 45;
        $("#googleMap").css("height", th+"px");
        googleMap = new google.maps.Map(document.getElementById('googleMap'), {
            center: {
                lat: ulglat,
                lng: ulglng
            },
            mapTypeControl: true,
            mapTypeControlOptions: {
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                position: google.maps.ControlPosition.TOP_CENTER
            },
            zoom: 5
        });
        trafficLayer = new google.maps.TrafficLayer();
        var centerControlDiv = document.createElement('div');
        var centerControl = new CenterControl(centerControlDiv, googleMap);
        centerControlDiv.index = 1;
        googleMap.controls[google.maps.ControlPosition.TOP_CENTER].push(centerControlDiv);
        
        isSimBased = <?php echo $isSimBased;?>;
        var trip_closed = '<?php echo $tstatus;?>';
        var iconn = getIconByAngle(0);
        // if(isSimBased){
        //     iconn = {path: google.maps.SymbolPath.CIRCLE, scale: 8.5, fillColor: "#F00", fillOpacity: 0.4, strokeWeight: 0.4 };
        // }
        var pos = new google.maps.LatLng(0,0);
        bounds = new google.maps.LatLngBounds();
        vehicle = new google.maps.Marker({
            position: pos,
            map: googleMap,
            icon: iconn
        });
        var coords = [];
        var timestamp = "";
    <?php
    foreach($records->result() as $i=>$row){
        if($i == 0){
    ?>  
        pos = new google.maps.LatLng(<?php echo @$row->latitude?>,<?php echo @$row->longitude?>);
        var marker = new google.maps.Marker({
             position: pos,
             map: googleMap
        });
        marker.setIcon('http://maps.google.com/mapfiles/ms/icons/green-dot.png');
    <?php
        }
        if($i<=$pings){
    ?>
        pos = new google.maps.LatLng(<?php echo @$row->latitude?>,<?php echo @$row->longitude?>);
        coords.push(pos);
        bounds.extend(pos);
        level1Bounds.extend(pos);
        $(".speed").html("<?php echo @$row->speed?>");
        $(".timestamp").html("<?php echo @$row->timestamp?>");
        <?php } ?>
        timestamp = "<?php echo @strtotime($row->timestamp)?>";
    <?php } ?>
        if(coords.length > 0){
            vehicle.setPosition(pos);
            var line= new google.maps.Polyline({
                path: coords,
                strokeColor: "#C32148",
                strokeOpacity: 0.7,
                strokeWeight: 8
            });
            line.setMap(googleMap);
        }
        getTripLocation(isSimBased,timestamp);

        getAddress();
        $(".switch_map_view").click(function(){
             if(showRoute == false){
                 googleMap.fitBounds(level1Bounds);
                 showRoute = true;
                 $(this).html("View All");
             }else{
                 googleMap.fitBounds(bounds);
                 showRoute = false;
                 $(this).html("View Vehicle");
             } 
        });
        $("[href='#tab1'],[href='#tab2'],[href='#tab5'],[href='#tab6']").click(function(){
            if($(this).attr("href") == "#tab1") {
                if($($(this).attr("href")).text().trim().length == 0) {
                    $.ajax({
                        url:"<?php echo base_url('livetrack/statusviewdetails');?>",
                        data:{"order_id":order_id,"id":id,'timezone':'<?php echo $timezone;?>'},
                        type:"POST",
                        success:function(data){
                            $("#tab1").html(data);
                            var distance = $(".details-distance").text().replace("Kms","").replace("km","");
                            $(".cards-distance").html(distance);
                            if(tripClose == false){
                                var parts = distance.split("/");
                                if(parts.length == 2){
                                    var travelled = parseFloat(parts[0]);
                                    var total = parseFloat(parts[1]);
                                    var remaining = total - travelled;
                                    if(remaining > 0){
                                        remaining = (remaining*1000) / mph ;
                                        remaining = secondsTimeSpanToHMS(remaining);
                                        total = (total*1000) / mph;
                                        total = secondsTimeSpanToHMS(total);
                                        $(".cards-eta").html(remaining+" / "+total);
                                    }else{
                                        var total = parseFloat(parts[0]);
                                        total = (total*1000) / mph;
                                        total = secondsTimeSpanToHMS(total);
                                        $(".cards-eta").html(total);
                                    }
                                }else if(parts.length == 1){
                                    var total = parseFloat(parts[0]);
                                    total = (total*1000) / mph;
                                    total = secondsTimeSpanToHMS(total);
                                    $(".cards-eta").html(total);
                                }else{
                                    var total = parseFloat(distance);
                                    total = (total*1000) / mph;
                                    total = secondsTimeSpanToHMS(total);
                                    $(".cards-eta").html(total);
                                }
                            }
                        }
                    });
                }
            }
            if($(this).attr("href") == "#tab2") {
                if($($(this).attr("href")).text().trim().length == 0) {
                    $.ajax({
                        url:"<?php echo base_url('livetrack/orderdetails');?>",
                        data:{"order_id":id,'type':'done','timezone':'<?php echo $timezone;?>'},
                        type:"POST",
                        success:function(data){
                            $("#tab2").html(data);
                        }
                    });
                }
            }
            if($(this).attr("href") == "#tab5") {
                if($($(this).attr("href")).text().trim().length == 0) {
                    <?php
                    if(isset($_GET) && isset($_GET["inner"])){
                        echo "var inner = 0;";
                    }else{
                        echo "var inner = 1;";
                    }
                    ?>
                    $.ajax({
                        url:"<?php echo base_url('livetrack/orddocsdetails');?>",
                        data:{"order_id":order_id,"id":id,'type':'done','timezone':'<?php echo $timezone;?>','inner':inner},
                        type:"POST",
                        success:function(data){
                            $("#tab5").html(data);
                        }
                    });
                }
            }
            if($(this).attr("href") == "#tab6") {
                if($($(this).attr("href")).text().trim().length == 0) {
                    $.ajax({
                        url:"<?php echo base_url('livetrack/shipmentView/'.$order_id);?>",
                        type:"POST",
                        data:{'timezone':'<?php echo $timezone;?>'},
                        success:function(html){
                            $("#tab6").html(html);
                            calcRoute();
                        }
                    });
                }
            }
        })
    });

    function getTripLocation(isSimBased,timestamp) {
        if (timestamp == "") {
            /*console.clear();*/
        }
        $.ajax({
            url: "<?=base_url()?>livetrack/getTripLocation/<?php echo $trip_id;?>/" + timestamp,
            data:{'timezone':'<?php echo $timezone;?>'},
            type:"POST",
            dataType: "JSON",
            success: function(data) {
                $.each(data.data, function(i, v) {
                    q.push(v);
                });
                if (q.length > 0) {
                    var lastPoint = new google.maps.LatLng(q[q.length - 1].lat, q[q.length - 1].lng);
                    var d = q.shift();
                    var pos = new google.maps.LatLng(d.lat, d.lng);
                    if (timestamp != "") {
                        $(".speed").html(d.speed);
                        $(".timestamp").html(d.receivedon);
                        startQueueProcessing();
                        
                        if(showRoute){
                            googleMap.fitBounds(level1Bounds);
                        }
                    } else{
                        vehicle.setPosition(pos);
                    }
                    $(".cards-battery").html(parseFloat(d.battery).toFixed(0) + " %");
                    $(".cards-speed").html(parseFloat(d.speed).toFixed(2) + " KMPH");
                }
                
                if (data.data.length != 0) {
                    nextTimeStamp = data.data[data.data.length - 1].timestamp;
                }
                if(fnsts == "a"){
                    setTimeout(function() {
                        getTripLocation(isSimBased,nextTimeStamp);
                    }, trackerFrequency);
                }
            }
        });
    }

    function startQueueProcessing() {
        queueFunction();
        setInterval(function() {
            queueFunction();
        }, trackerFrequency);
    }

    function queueFunction() {
        var data = q.shift();
        if (data != null && vehicle != null) {
            $(".speed").html(data.speed);
            $(".timestamp").html(data.receivedon);
            angle = Math.round(data.course / 10);
            vehicle.setIcon(getIconByAngle(angle));
            //getAddress(vehicle.position.lat(), vehicle.position.lng())
            var newPosition = new google.maps.LatLng(data.lat, data.lng);
            var oldPosition = new google.maps.LatLng(vehicle.position.lat(), vehicle.position.lng());
            
            bounds = new google.maps.LatLngBounds();
            bounds.extend(vehicle.position);
            bounds.extend(newPosition);
            if(!showRoute){
                vehicle.animateTo(googleMap, newPosition, {
                    duration: trackerFrequency,
                    drawRoute:"draw"
                });
            }else{
                vehicle.animateTo(googleMap, newPosition, {
                    duration: trackerFrequency,
                    dragMap: "no-stick",
                    drawRoute:"draw"
                });
            }
        }
    }
    function secondsTimeSpanToHMS(s) {
        var h = Math.floor(s/3600); //Get whole hours
        s -= h*3600;
        var m = Math.floor(s/60); //Get remaining minutes
        s -= (m*60).toFixed(0);
        return h+":"+(m < 10 ? '0'+m : m)+":"+(s < 10 ? '0'+s.toFixed(0) : s.toFixed(0)); //zero padding on minutes and seconds
    }
    function CenterControl(controlDiv, map) {

        // Set CSS for the control border.
        var controlUI = document.createElement('div');
        controlUI.style.backgroundColor = '#fff';
        controlUI.style.boxShadow = 'rgba(0, 0, 0, 0.3) 0px 0px 6px';
        controlUI.style.cursor = 'pointer';
        controlUI.style.marginTop = '10px';
        controlUI.style.marginLeft = '-10px';
        controlUI.style.textAlign = 'center';
        controlUI.title = 'Click to view traffic in the map';
        controlDiv.appendChild(controlUI);

        // Set CSS for the control interior.
        var controlText = document.createElement('div');
        controlText.style.color = 'rgb(86, 86, 86)';
        controlText.style.fontFamily = 'Roboto,Arial,sans-serif';
        controlText.style.fontSize = '18px';
        controlText.style.lineHeight = '40px';
        controlText.style.paddingLeft = '17px';
        controlText.style.paddingRight = '17px';
        controlText.innerHTML = 'Traffic';
        controlUI.appendChild(controlText);

        // Setup the click event listeners: simply set the map to Chicago.
        controlUI.addEventListener('click', function() {
            if(trafficFlag){
                trafficLayer.setMap(null);
                trafficFlag = false;
                controlText.style.color = 'rgb(86, 86, 86)';
            }else{
                trafficLayer.setMap(map);
                trafficFlag = true;
                controlText.style.color = 'black';
            }
        });

    }

    function calcRoute() {
        directionsService = new google.maps.DirectionsService();
        directionsDisplay = new google.maps.DirectionsRenderer();
        var start ;
        var end ;
        var waypts = [];
        $(".points").each(function(index,ele){
            var point = new google.maps.LatLng($(this).data("lat"), $(this).data("lng"));
            level1Bounds.extend({lat:$(this).data("lat"),lng:$(this).data("lng")});
            if(index==0){
                start = point;
            }else if(index==$(".points").length-1){
                end = point;
            }else{
                waypts.push({
                    location: point,
                    stopover: true
                });
            }
        });
        var request = {
            origin: start,
            destination: end,
            waypoints: waypts,
            travelMode: google.maps.TravelMode.DRIVING
        };
        directionsService.route(request, function(response, status) {
            if (status == google.maps.DirectionsStatus.OK) {
                directionsDisplay.setDirections(response);
                directionsDisplay.setMap(googleMap);
            } else {
                console.log("Directions Request from " + start.toUrlValue(6) + " to " + end.toUrlValue(6) + " failed: " + status);
            }
            
            setTimeout(function() {
                googleMap.fitBounds(bounds);
            }, 1000);
        });
    }

    function getIconByAngle(angle) {
        return "<?=base_url()?>assets/vehicle/vehicle copy " + angle + ".png";
    }
    function reloadLocation(ele){
        getAddress();
    }
    function getAddress () {
        var latlng = vehicle.position
        // This is making the Geocode request
        var geocoder = new google.maps.Geocoder();
        geocoder.geocode({ 'latLng': latlng }, function (results, status) {
            if (status !== google.maps.GeocoderStatus.OK) {
                /*alert(status);*/
            }
            // This is checking to see if the Geoeode Status is OK before proceeding
            if (status == google.maps.GeocoderStatus.OK) {
                var address = (results[0].formatted_address);
                $(".locationName").html(address+" <div class='btn btn-xs btn-default' onclick='reloadLocation(this)'><i class='fa fa-fa fa-refresh'></i></div>");
            }
        });
    }
    function setAllTabs(){
        $.ajax({
            url:"<?php echo base_url('livetrack/statusviewdetails');?>",
            data:{"order_id":order_id,"id":id,'timezone':'<?php echo $timezone;?>'},
            type:"POST",
            success:function(data){
                $("#tab1").html(data);
                var distance = $(".details-distance").text().replace("Kms","").replace("km","");
                $(".cards-distance").html(distance);
                if(tripClose == false){
                    var parts = distance.split("/");
                    if(parts.length == 2){
                        var travelled = parseFloat(parts[0]);
                        var total = parseFloat(parts[1]);
                        var remaining = total - travelled;
                        if(remaining > 0){
                            remaining = (remaining*1000) / mph ;
                            remaining = secondsTimeSpanToHMS(remaining);
                            total = (total*1000) / mph;
                            total = secondsTimeSpanToHMS(total);
                            $(".cards-eta").html(remaining+" / "+total);
                        }else{
                            var total = parseFloat(parts[0]);
                            total = (total*1000) / mph;
                            total = secondsTimeSpanToHMS(total);
                            $(".cards-eta").html(total);
                        }
                    }else if(parts.length == 1){
                        var total = parseFloat(parts[0]);
                        total = (total*1000) / mph;
                        total = secondsTimeSpanToHMS(total);
                        $(".cards-eta").html(total);
                    }else{
                        var total = parseFloat(distance);
                        total = (total*1000) / mph;
                        total = secondsTimeSpanToHMS(total);
                        $(".cards-eta").html(total);
                    }
                }
            }
        });
        $.ajax({
            url:"<?php echo base_url('livetrack/shipmentView/'.$order_id);?>",
            type:"POST",
            data:{'timezone':'<?php echo $timezone;?>'},
            success:function(html){
                $("#tab6").html(html);
                calcRoute();
            }
        });
    }
    function openHOS(order_id){
        $.ajax({
            url:"<?php echo base_url('livetrack/hosdetails');?>",
            data:{"order_id":order_id,'timezone':'<?php echo $timezone;?>'},
            type:"POST",
            beforeSend:function(){
                $("#myModal").modal("show");
                $("#mtitle").html("HOS Details");
                $("#viewdata").html("<center><progress></progress></center>");
            },
            success:function(data){
                $("#viewdata").html(data);
            }
        });
    }
    function openAlarms(order_id){
        $.ajax({
            url:"<?php echo base_url('livetrack/alarmdetails');?>",
            data:{"order_id":order_id,'timezone':'<?php echo $timezone;?>'},
            type:"POST",
            beforeSend:function(){
                $("#myModal").modal("show");
                $("#mtitle").html("Alarm Details");
                $("#viewdata").html("<center><progress></progress></center>");
            },
            success:function(data){
                $("#viewdata").html(data);
            }
        });
    }
</script>
    <style type="text/css">
        .tt_box {
            padding: 0px;
            border: 1px solid #dcdcdc;
            background: white;
            margin: 8px;
            border-radius: 4px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_box1 {
            padding: 0px;
            border: 1px solid #dcdcdc;
            background: white;
            margin: 8px;
            border-radius: 4px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_box_title {
            padding: 4px;
            text-align: center;
            background: #808080e3; /*#dcdcdc;*/
            color:white;
        }
        .tt_box_body{
            padding:8px;
        }
        .tt_card{
            padding: 0px 20px;
        }
        .tt_card_value{
            text-align: right;
            font-size: 12px;
            font-weight: 400;
            overflow: hidden;
            max-height: 20px;
        }
        .tt_card_title {
            text-align:right;
            font-size:12px;
            padding: 8px 0px;
        }
        .tt_card_row i {
            color: #244062;
            font-size: 32px;
            padding: 0px 0px;
        }
        .tt_card_row img {
            color: #244062;
            padding: 5px 0px;
        }
        .tt_card_row{
            background: #ffffff;
            border: 1px solid gainsboro;
            border-radius: 8px;
            padding: 8px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_bottom_pane{
            margin: 0px;
            padding: 16px 0px;
            height:calc(100vh - 180px);
        }
        .tt_dd_value{
            font-size: 16px;
            font-weight: 600;
            text-align: right;
        }
        .tt_dd_label{
            font-size: 12px;
            color: gray;
            text-align: right;
        }
        .tt_os_received_time{
            font-size: 12px;
            color: gray;
            text-align: center;
        }
        .tt_os_location i {
            color: #3C969F;
            margin-right: 8px;
        }
        .tt_os_title{
            font-size: 12px;
            text-align: center;
        }
        .tt_os_location{
            text-align: center;
            overflow: hidden;
        }
        .tt_os_btn{
            min-width: 10px;
            padding: 4px 8px;
            font-size: 12px;
            color: #fff;
            text-align: center;
            
            border-radius: 4px;
            max-width: 100px;
            
            margin: 4px 0px;
        }
        .tt_ld_date{
            font-size: 12px;
            color: gray;
            margin-left: 24px;  
        }
        .tt_ld_address{
            display:block;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
        }
        .tt_ld_address i{
            color:#65b3f1;
            margin-right: 8px;
        }
        .tt_value{
            font-size: 16px;
            overflow: auto;
        }
        .tt_head{
            font-size: 12px;
            color: gray;
            margin-top: 8px;
        }
        .hide{
            display:none;
        }
        #googleMap {
            border: 1px solid #dcdcdc;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
            border-radius: 4px;
        }
        .rt-tab-pane {
           display: block;
            max-height: calc(100vh - 226px);
            overflow-y: auto;
            padding: 8px;
            overflow-x: hidden;
        }
        .table-bordered.custom-blue-color > thead > tr > th, .table-bordered.custom-blue-color > tbody > tr > th, .table-bordered.custom-blue-color > tfoot > tr > th, .table-bordered.custom-blue-color > thead > tr > td, .table-bordered.custom-blue-color > tbody > tr > td, .table-bordered.custom-blue-color > tfoot > tr > td {
            border: 1px solid #cecbcb;
        }
        .custom-blue-color th {
            background: rgb(36, 64, 98);
            color: white;
        }
        .nav-tabs>li>a {
            margin-right: 2px;
            line-height: 1.42857143;
            border: 1px solid transparent;
            border-radius: 4px 4px 0 0;
            padding: 2px 8px;
        }
        .no-padding{
            padding-left:2px;
            padding-right:2px;
        }
        .tt_click{
            cursor:pointer;
        }
        .tt_click:hover{
            background:#fbf9f9;
        }
    </style>
  </body>
</html>