<section class="content-header">
    <h1>
    Quick Book
    <small>Quote</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?php echo base_url();?>"><i class="fa fa-home"></i> Home</a></li>
        <li><a href="#">Quote</a></li>
        <li class="active">Quick Book</li>
    </ol>
</section>
<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/quote/style.css');?>">
<script type="text/javascript" src="<?=base_url('assets/ebooking/PlacePicker.js')?>"></script>
<section class="content quickbook" style="display: none">
    <form action="<?php echo base_url('quote/quickbook_quote');?>" method="post" id="quickBookForm" onsubmit="return getQuote();">
        <div class="grid">
            <div class="row">
                <div class="col-md-6 left_gap_lg" style="padding-right: 25px;">
                    <div class="row">
                        <div class="box quick_book_box" style="border-top: 3px solid #002b54;box-shadow: 0 2px 3px rgba(0, 0, 0, 0.3);">
                            <div class="box-header">
                                <div class="box-title">Quick Book</div>
                                <div class="box-tools pull-right">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                        <i class="fa fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="box-body">
                                <div class="row ">
                                    <div class="col-md-12 quote-label gap-vert"><img src="<?php echo base_url('assets/quote/pickup_shipment.png');?>"> Pickup</div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Country*</label>
                                            <div class="input-group date material">
                                                <input type="text" name="pickup_country" class="form-control" id="pickup_country" placeholder="Country" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Postal code*</label>
                                            <div class="input-group date material">
                                                <input type="text" name="pickup_postal_code" class="form-control" id="pickup_postal" placeholder="Postal Code" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Date*</label>
                                            <div class="input-group date material">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" name="pickup_date" class="form-control datepicker" id="pickup_date" placeholder="DD/MM/YYYY" value="<?=date('d/m/Y')?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 quote-label gap-vert"><img src="<?php echo base_url('assets/quote/drop_shipment.png');?>"> Delivery</div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Country*</label>
                                            <div class="input-group date material">
                                                <input type="text" name="drop_country" class="form-control" id="drop_country" placeholder="Country" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Postal code*</label>
                                            <div class="input-group date material">
                                                <input type="text" name="drop_postal_code" class="form-control" id="drop_postal" placeholder="Postal Code" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Date*</label> 
                                            <div class="input-group date material">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" name="drop_date" class="form-control datepicker" id="drop_date" placeholder="DD/MM/YYYY" value="<?=date('d/m/Y')?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 quote-label gap-vert">Vehicles</div>
                                    <div class="col-md-12">
                                        <section class="pagedImages">
                                            <input id="page1" accesskey="1" type="radio" name="pagedImages1" title="Images page 1" checked="checked">
                                            <input id="page2" accesskey="2" type="radio" name="pagedImages1" title="Images page 2">
                                            <label for="page1" title="To page 1">1</label>
                                            <label for="page2" title="To page 2">2</label>
                                            <label for="page3" title="To page 3">3</label>
                                            <ul title="This is page 1">
                                                <li id="image1">
                                                    <div class="member" data-vehicle-type="4 WHEELER">
                                                        <img src="<?php echo base_url('assets/quote/truck1.png');?>" class="img-responsive" alt="Responsive image">
                                                        <div class="name">
                                                            <br>4 WHEELER</div>
                                                        <input type="radio" name="vehicle_type" id="vehicle_type1" value="4 WHEELS CABINET" class="hidden" autocomplete="off">
                                                    </div>
                                                </li>
                                                <li id="image2">
                                                    <div class="member" data-vehicle-type="6 WHEELER">
                                                        <img src="<?php echo base_url('assets/quote/truck1.png');?>" class="img-responsive" alt="Responsive image">
                                                        <div class="name">
                                                            <br>6 WHEELER</div>
                                                            <input type="radio" name="vehicle_type" id="vehicle_type2" value="4 WHEELS STALL" class="hidden" autocomplete="off">
                                                    </div>
                                                </li>
                                                <li id="image3">
                                                    <div class="member" data-vehicle-type="10 WHEELER">
                                                        <img src="<?php echo base_url('assets/quote/truck1.png');?>" class="img-responsive" alt="Responsive image">
                                                        <div class="name">
                                                            <br>10 WHEELER</div>
                                                            <input type="radio" name="vehicle_type" id="vehicle_type3" value="4 WHEELS REEFER" class="hidden" autocomplete="off">
                                                    </div>
                                                </li>
                                                <li id="image4">
                                                    <div class="member" data-vehicle-type="Trailer 18 Wheels">
                                                        <img src="<?php echo base_url('assets/quote/truck1.png');?>" class="img-responsive" alt="Responsive image">
                                                        <div class="name">
                                                            <br>Trailer 18 Wheels</div>
                                                            <input type="radio" name="vehicle_type" id="vehicle_type4" value="4 WHEELS CABINET" class="hidden" autocomplete="off">
                                                    </div>
                                                </li>
                                            </ul>
                                            <ul title="This is page 2">
                                                <li id="image5">
                                                    <div class="member" data-vehicle-type="Trailer 22 Wheels">
                                                        <img src="<?php echo base_url('assets/quote/truck1.png');?>" class="img-responsive" alt="Responsive image">
                                                        <div class="name">
                                                            <br>Trailer 22 Wheels</div>
                                                            <input type="radio" name="vehicle_type" id="vehicle_type5" value="4 WHEELS STALL" class="hidden" autocomplete="off">
                                                    </div>
                                                </li>
                                            </ul>
                                            <input type="hidden" name="vehicle_type" id="vehicle_type">
                                        </section>
                                    </div>
                                    <div class="col-md-6">
                                        <button class="btn btn-primary btn-lg pull-right ctm_btn gap-vert" type="submit">Book Vehicle Instantly</button>
                                    </div>
                                    <div class="col-md-6">
                                        <a class="btn btn-primary btn-lg ctm_btn gap-vert" href="<?php echo base_url('quote');?>">Recommand Best Price</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6" style="padding-left: 25px;">
                    <div class="row">
                        <div class="box" style="border-top: 3px solid #002b54;box-shadow: 0 2px 3px rgba(0, 0, 0, 0.3);">
                            <div class="box-header">
                                <div class="box-title">Price</div>
                                <div class="box-tools pull-right">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                        <i class="fa fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="box-body response_body">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="overlay" style="display: none">
      <i class="fa fa-refresh fa-spin"></i>
    </div>
</section>
<script type="text/javascript">
$(document).ready(function(){

    $(".quickbook").show();
    $(".content-wrapper").addClass("hero_image");
    $("#pickup_country,#pickup_postal").PlacePicker({
        title:"Pickup Location",
        center: {lat: 17.6868, lng: 83.2185},
        success:function(data,address){
            $("#pickup_country").val(data.country);
            $("#pickup_postal").val(data.postal_code);
        }
    });
    $("#drop_country,#drop_postal").PlacePicker({
        title:"Drop Location",
        center: {lat: 17.6868, lng: 83.2185},
        success:function(data,address){
            $("#drop_country").val(data.country);
            $("#drop_postal").val(data.postal_code);
        }
    });
    $(".datepicker").datepicker({
        format: "dd/mm/yyyy"
    });

    $(".member").click(function(){
        $("li").removeClass("selected");
        $(this).closest("li").toggleClass("selected");
        $(this).closest("li").attr('selected','selected');
        $("#vehicle_type").val($(this).data("vehicleType"));
    });
});
function getQuote() {
    var serializeArray = $("#quickBookForm").serializeArray();
    $.ajax({
        url:"<?php echo base_url('quote/quickbook_quote');?>",
        type:"POST",
        data:serializeArray,
        beforeSend:function(){
            $(".overlay").show();
        },
        success:function(data){
            $(".overlay").hide();
            $(".response_body").html(data);
        },
        complete:function(event,xhr,options){
            $(".overlay").hide();
            $(".response_body").html(event.responseText);
        }
    });
    return false;
}


</script>
<style type="text/css">

.hero_image {
    background-image: linear-gradient(0deg,rgba(255, 255, 255, 0.75),rgba(255, 255, 255, 0.75)), url(<?php echo base_url();?>assets/quote/quickbook.jpg);
    background-position: left center;
    background-size: 1000px;
    background-repeat: repeat-x;
}
.ctm_btn{
    border-radius: 100px;
    background-color: #002b55 !important;
    border: #011223;
    color: #fff;
}
.ctm_btn a{
    color: #fff !important;
}
.material {
    border-bottom: 1px solid #082c54;
    margin-bottom: 17px;
    width: 100%;
}
.response_body{
    overflow-y: auto;
}
.box {
    position: relative;
    border-radius: 3px;
    background: #ffffffc4;
    border-top: 3px solid #d2d6de;
    margin-bottom: 20px;
    width: 100%;
    box-shadow: 0 2px 3px rgba(0, 0, 0, 0.1);
}
</style>