<?php

$rateServiceId = $rateServiceId ?? "";
$rateOfferingId = $rateOfferingId ?? "";
$rateRecordId = $recordId = $rateRecordId ?? "";
$rateServiceName = $rateServiceName ?? "";
$rateOfferingName = $rateOfferingName ?? "";
$rateRecordName = $rateRecordName ?? "";
$userCurrency = $userCurrency ?? "";
$rateDetails = $rateDetails ?? [];
$vasMasterData = $rateDetails['vasMasterData'] ?? [];
$chargeMasterData = $rateDetails['chargeMasterData'] ?? [];
$chargesData = $rateDetails['chargesData'] ?? [];
$fuelSurchargeData = $rateDetails['fuelSurchargeData'] ?? [];
$geoTierData = $rateDetails['geoTierData'] ?? [];
$rateTierData = $rateDetails['rateTierData'] ?? [];
$totalAmount = $rateDetails['totalAmount'] ?? "";
$titleNearTotalAmount = $rateDetails['titleNearTotalAmount'] ?? "";
$exchangeAmount = $rateDetails['exchangeAmount'] ?? 0;
?>
<div class="advanceViewtab ">
    <div class="custom-scroll">
        <div class="row">
            <div class="col-md-3">
                <b>Rate Service :</b>
                <p><?= $rateServiceId . " - " . $rateServiceName ?></p>
            </div>
            <div class="col-md-3">
                <b>Rate Offering :</b>
                <p><?= $rateOfferingId . " - " . $rateOfferingName ?></p>
            </div>
            <div class="col-md-3">
                <b>Rate Record :</b>
                <p><?= $rateRecordId . " - " . $rateRecordName ?></p>
            </div>
            <div class="col-md-3">
                <b>Tariff Type :</b>
                <p><?= $tariffType ?? "" ?></p>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <b>Service :</b>
                <p><?= $serviceType ?? "" ?></p>
            </div>
            <div class="col-md-3">
                <b>Mode Of Transport :</b>
                <p><?= $transportMode ?? "" ?></p>
            </div>
            <div class="col-md-3">
                <b>Profile Id :</b>
                <p><?= $profileId ?? "" ?></p>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <b>Effective Date :</b>
                <p><?= $effectiveDate ?? "" ?></p>
            </div>
            <div class="col-md-3">
                <b>Expiry Date :</b>
                <p><?= $expiryDate ?? "" ?></p>
            </div>
            <?php
            if ($exchangeAmount > 0): ?>
                <div class="col-md-3">
                    <b>Exchange Rate :</b>
                    <p><?= $exchangeAmount ?></p>
                </div>
            <?php
            endif; ?>
            <div class="col-md-3"></div>
            <div class="col-md-3">
                <p style="font-size: 27px;font-weight: 600;"><?= $totalAmount . " " . $userCurrency ?>
                    <?php
                    if ($titleNearTotalAmount != ""): ?>
                        &nbsp;<img src="<?= base_url() ?>assets/images/info-help-circle.svg" style="height:35px;width:30px;cursor:pointer" title="<?= $titleNearTotalAmount ?>">
                    <?php
                    endif; ?>
                </p>
            </div>
        </div>
        <div class="main-datatable">
            <div class="table-responsive">
                <table class="table table-striped table-bordered chargestable" id="usertable" style="width: 95%;padding: 11px;10px;">
                    <thead>
                    <tr>
                        <th><b><?= $this->lang->line('rate_id') ?></b></th>
                        <th><b><?= $this->lang->line('vas_id') ?></b></th>
                        <th><b><?= $this->lang->line('charge_id') ?></b></th>
                        <th><b><?= $this->lang->line('min_amount') ?></b></th>
                        <th><b><?= $this->lang->line('general_amount') ?></b></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    if (!empty($chargesData)):
                        foreach (
                            $chargesData as $eachLine
                        ):
                            $chargeBasis = $eachLine['chargeBasis'];
                            if ($chargeBasis == "FRT"):
                                $fuelSurchargeId = $eachLine['fuelSurchargeId'] ?? 0;
                                if ($fuelSurchargeId > 0):
                                    $fuelSurchargeIdData = $fuelSurchargeData[$fuelSurchargeId] ?? [];
                                    foreach ($fuelSurchargeIdData as $eachRowData):
                                        ?>
                                        <tr>
                                            <td><?= $eachRowData['fafId'] ?? "" ?></td>
                                            <td></td>
                                            <td>FAF</td>
                                            <td></td>
                                            <td><?= $eachRowData['amount'] . " " . $eachRowData['currency'] ?></td>
                                        </tr>
                                    <?php
                                    endforeach;
                                endif; ?>
                            <?php
                            else:
                                $geoTierId = $eachLine['geoTierId'];
                                $rateTierId = $eachLine['rateTierId'];
                                $amount = $eachLine['amount'] . " " . $eachLine['currency'];
                                $rateRecordId = $recordId;
                                if ($geoTierId > 0) :
                                    if (empty($geoTierData[$geoTierId])) :
                                        continue;
                                    endif;
                                    $rateRecordId = $geoTierData[$geoTierId]['geoTierId'] ?? $rateRecordId;
                                    $amount = $geoTierData[$geoTierId]['amount'] . " " . $geoTierData[$geoTierId]['currency'] . " &nbsp;&nbsp;" . "<img src='" . base_url('assets/images/info-help-circle.svg') . "' style='height:25px;width:25px;cursor:pointer' title='" . $geoTierData[$geoTierId]['message'] . "'>";
                                    $displayVehicleName = $geoTierData[$geoTierId]['displayVehicleName'] ?? 0;
                                    $vehicleTypeName = $geoTierData[$geoTierId]['vehicleTypeName'] ?? "";
                                    if ($displayVehicleName > 0 && $vehicleTypeName != ""):
                                        $amount .= "&nbsp;&nbsp;<img src='" . base_url('assets/images/no-truck-icon.webp') . "' style='height:38px;width:38px;cursor:pointer' title='Vehicle Type is empty For " . $rateRecordId . "'>";
                                    endif;
                                endif;
                                if ($rateTierId > 0) :
                                    if (empty($rateTierData[$rateTierId])) :
                                        continue;
                                    endif;
                                    $rateRecordId = $rateTierData[$rateTierId]['tierId'] ?? $rateRecordId;
                                    $amount = $rateTierData[$rateTierId]['amount'] . " " . $rateTierData[$rateTierId]['currency'] . " &nbsp;&nbsp;" . "<img src='" . base_url('assets/images/info-help-circle.svg') . "' style='height:25px;width:25px;cursor:pointer' title='" . $rateTierData[$rateTierId]['message'] . "'>";
                                endif;
                                ?>
                                <tr>
                                    <td><?= $eachLine['offeringId'] > 0 ? $rateOfferingId : $rateRecordId ?></td>
                                    <td><?= $eachLine['vasId'] > 0 ? $vasMasterData[$eachLine['vasId']]['vasId'] : "" ?></td>
                                    <td><?= $eachLine['chargeId'] > 0 ? $chargeMasterData[$eachLine['chargeId']]['chargeCode'] : "" ?></td>
                                    <td><?= $eachLine['minimumAmount'] ?></td>
                                    <td><?= $amount ?></td>
                                </tr>
                            <?php
                            endif;
                        endforeach;
                    else: ?>
                        <tr>
                            <td colspan="5">
                                <center>No Data</center>
                            </td>
                        </tr>
                    <?php
                    endif;
                    ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
