<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Cargo Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <?php $assets_url = base_url('assets/scanner'); ?>
    <script src="<?= $assets_url . '/js/jquery.min.js' ?>"></script>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f9f9f9;
        }

        h2 {
            text-align: center;
            color: #333;
        }

        .table-container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .header-row {
            background-color: #f0f0f0;
            font-weight: bold;
        }

        th,
        td {
            padding: 12px 15px;
            border: 1px solid #ddd;
            text-align: left;
        }

        .data-row td {
            border-bottom: 2px solid #eee;
        }

        @media (max-width: 768px) {
            .table-container {
                max-width: 100%;
            }
        }

        .back-btn {
            display: block;
            width: 100%;
            max-width: 300px;
            margin: 30px auto 0;
            padding: 15px;
            background-color: #88A0BF;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            text-align: center;
            text-decoration: none;
        }

        .back-btn:hover {
            background-color: #88A0BF;
        }

        .scan-img {
            width: 50px;
            height: auto;
            display: block;
            margin: 0 auto;
            border-radius: 4px;
        }
    </style>
</head>

<body>
    <!-- Limit Reached Modal -->
    <div class="modal fade" id="limitReachedModal" tabindex="-1" aria-labelledby="limitReachedLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content text-center">
                <div class="modal-header">
                    <h5 class="modal-title w-100" id="limitReachedLabel">Alert</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Scan Limit Reached
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>


    <div id="reader"></div>

    <h2>Cargo Details</h2>
    <h4 style="text-align:center;">Order ID: <?= htmlspecialchars($order_id ?? '') ?></h4>

    <div class="table-container">
        <table class="cargo_table">
            <thead>
                <tr class="header-row">
                    <th></th>
                    <th>Cargo Type</th>
                    <th>Qty</th>
                    <th>Actual Qty</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($cargo_details as $row): ?>
                    <tr class="data-row">
                        <td>
                            <button type="button" class="btn-info scanBtn" data-order-id="<?= htmlspecialchars($order_id) ?>" data-cargo-id="<?= htmlspecialchars($row['cargo_id'] ?? 0) ?>" data-scanned-quantity="<?= htmlspecialchars($row['scanned_quantity'] ?? 0) ?>" data-quantity="<?= htmlspecialchars($row['quantity'] ?? 0) ?>" data-ref="<?= htmlspecialchars($ref) ?>">
                                <img src="<?= htmlspecialchars($assets_url . '/img/scan.jpg') ?>" alt="Scan Image" class="scan-img" />
                            </button>
                        </td>
                        <td><?= htmlspecialchars($row['cargo_type'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['quantity'] ?? '0') ?></td>
                        <td><?= htmlspecialchars($row['scanned_quantity'] ?? '0') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <a href="<?= base_url('scanner') ?>" class="back-btn">Back to Scanner</a>


    <script>
        $(document).on("click", ".scanBtn", function(event) {
            // console.log('scanner opened');
            event.preventDefault();
            const orderId = $(this).data("order-id");
            const cargoId = $(this).data("cargo-id");
            const ScanQu = $(this).data("scanned-quantity");
            const quantity = $(this).data("quantity");
            const ref = $(this).data("ref");
            if (ScanQu < quantity) {
                startScanner(orderId, cargoId, ScanQu, quantity, ref);
            } else {
                $("#limitReachedModal").modal('show');
            }
        });

        function startScanner(orderId, cargoId, ScanQu, quantity, ref) {
            const html5QrCode = new Html5Qrcode("reader");

            const config = {
                fps: 10,
                qrbox: 250
            };

            html5QrCode.start({
                    facingMode: "environment"
                },
                config,
                (decodedText, decodedResult) => {
                    // console.log("Scanned Code:", decodedText);
                    html5QrCode.stop(); // stop camera
                    fetchApiData(decodedText, orderId, cargoId, ScanQu, quantity, ref);
                },
                (errorMessage) => {}
            ).catch(err => {
                // console.error("Camera start failed:", err);
                alert("Camera failed to start");
            });
        }

        function fetchApiData(code, orderId, cargoId, ScanQu, quantity, ref) {
            $.ajax({
                type: "GET",
                url: "<?php echo base_url('Scanner/UpdateScannerQuantity'); ?>",
                data: {
                    tknNo: code,
                    curr_order_id: orderId,
                    cargoId: cargoId,
                    ScanQu: ScanQu,
                    quantity: quantity,
                    ref: ref,
                },
                dataType: "json",
                success: function(response) {
                    let data = response;

                    // console.log(response);
                    // console.log(response.cargo_details.cargo_details);
                    // console.log('came here');

                    if (data.cargo_details && data.cargo_details.cargo_details) {
                        updateTable(data.cargo_details.cargo_details, data.order_id, data.ref);
                    }
                },
                error: function() {
                    alert("Failed to contact server.");
                }
            });
        }

        function updateTable(cargoDetails, orderId, ref) {
            // console.log('came here2');
            let tbody = "";
            cargoDetails.forEach((row, index) => {
                tbody += `
        <tr class="data-row">
            <td>
                <button type="button" class="btn-info scanBtn"
                    data-order-id="${orderId}"
                    data-cargo-id="${row['cargo_id']}"
                    data-scanned-quantity="${row['scanned_quantity']}"
                    data-quantity="${row['quantity']}" data-ref="${ref}">
                    <img src="<?= $assets_url ?>/img/scan.jpg" alt="Scan Image" class="scan-img" />
                </button>
            </td>
            <td>${row['cargo_type']}</td>
            <td>${row['quantity']}</td>
            <td>${row['scanned_quantity']}</td>
        </tr>
        `;
            });

            $(".cargo_table tbody").html(tbody);
        }
    </script>

</body>

</html>