<!doctype html>
<html>

<head>
    <title>SVKONEKT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php $assets_url = base_url('assets/scanner'); ?>
    <script src="<?= $assets_url . '/js/jquery.min.js' ?>"></script>
    <script src="https://unpkg.com/html5-qrcode"></script>

    <style>
        .logo {
            width: 100%;
            height: fit-content;
            padding: 0px;
            margin: 0px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            text-align: center;
            margin-top: 50px;
            padding: 10px;
        }

        #scanBtn {
            font-size: 32px;
            padding: 25px 25px;
            border-radius: 12px;
            min-width: 100px;
            background-color: #88A0BF;
            color: white;
            border: none;
            cursor: pointer;
            margin: 5px;
        }

        /* Make button full width and larger on mobile */
        /* @media (max-width: 768px) {
            #scanBtn {
                font-size: 40px;
                padding: 25px 25px;
                width: 50%;
            }
        } */

        .scan-img {
            width: 100px;
            height: 100px;
            display: block;
            margin: 10px 10px 10px 10px;
            border-radius: 4px;
        }

        .scanner_btns {
            height: 80vh;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            margin-top: -100px;
        }

        .reader_div {
            width: 300px;

        }

        .lable {
            font-size: 26px;
        }
        
        .main_logo{
            width: 65%;
            height:65%;
        }

    </style>
</head>

<body>

    <div class="container">
        <div class="logo">
            <img src="<?= base_url('assets/images/svkonekt-logo.svg'); ?>" alt="" class="main_logo">
        </div>

        <div id="reader"></div>

        <div class="scanner_btns">
            <div class="scanner_btn1">
                <button type="button" class="btn btn-info TKN scanBtn" id="scanBtn"><img src="<?= htmlspecialchars($assets_url . '/img/scan.jpg') ?>" alt="Scan Image" class="scan-img" /></button>
                <p class="lable">LR</p>
            </div>
            <div class="scanner_btn2">
                <button type="button" class="btn btn-info AWB scanBtn" id="scanBtn"><img src="<?= htmlspecialchars($assets_url . '/img/scan.jpg') ?>" alt="Scan Image" class="scan-img" /></button>
                <p class="lable">AWB</p>
            </div>
        </div>
        
    </div>

    <script>
        let html5QrCode = null;

        $(".scanBtn").click(function(event) {
            event.preventDefault();
            let classList = $(this).attr("class").split(/\s+/);
            let Clickedbtn = classList.find(cls => cls === "TKN" || cls === "AWB");
            
            startScanner(Clickedbtn);
        });

        function startScanner(btn) {
            html5QrCode = new Html5Qrcode("reader");
            const config = {
                fps: 10,
                qrbox: 250
            };

            html5QrCode.start({
                    facingMode: "environment"
                }, // rear camera
                config,
                (decodedText, decodedResult) => {
                    html5QrCode.stop();
                    fetchApiData(decodedText, btn);
                },
                (errorMessage) => {
                    // console.log(`Scan error: ${errorMessage}`);
                }
            ).catch(err => {
                console.error("Camera start failed:", err);
                alert("Camera failed to start");
            });
        }

        function fetchApiData(code,btn) {
            
            $.ajax({
                type: "GET",
                url: "<?php echo base_url('Scanner/fetchDataFromAPI'); ?>",
                data: {
                    tknNo: code,
                    ref:btn
                },
                success: function(data) {
                    console.log("Response:", data);

                    // Ensure JSON string (in case it's already a string)
                    const jsonString = (typeof data === "string") ? data : JSON.stringify(data);

                    // Create a hidden form to submit POST
                    const form = document.createElement("form");
                    form.method = "POST";
                    form.action = "<?= base_url('Scanner/displayCargo') ?>";

                    const input = document.createElement("input");
                    input.type = "hidden";
                    input.name = "cargoData";
                    input.value = jsonString;

                    form.appendChild(input);
                    document.body.appendChild(form);
                    form.submit();
                },

                error: function() {
                    alert("Failed to contact server.");
                }
            });
        }

    </script>

</body>

</html>