<?php 
    if($type=="add"){
        $s=array("splace"=>"","eplace"=>"","stime"=>date("h:i A"),"etime"=>date("h:i A"),"slat"=>"","slng"=>"","elat"=>"","elng"=>"","zone_id"=>"","startdate"=>date("Y-m-d"),"enddate"=>date("Y-m-d"),"shipment_name"=>"","customer_id"=>"","carrier_type"=>"","vendor_id"=>"","border_type"=>"0");
    }else if($type=="edit"){
        if($shift->num_rows()>0){
            $s=$shift->row_array();
            $s['stime'] = date('h:i A', strtotime($s['stime']));
            $s['etime'] = date('h:i A', strtotime($s['etime']));
        }
    }
?>
<style type="text/css">
 
 input[type='radio']:after {
        width: 15px;
        height: 15px;
        border-radius: 15px;
        top: -2px;
        left: -1px;
        position: relative;
        background-color: #d1d3d1;
        content: '';
        display: inline-block;
        visibility: visible;
        border: 2px solid white;

    }
    input[type='radio']:checked:after {
        width: 15px;
        height: 15px;
        border-radius: 15px;
        top: -2px;
        left: -1px;
        position: relative;
        background-color: #2eaade;
        content: '';
        display: inline-block;
        visibility: visible;
        border: 2px solid lightskyblue; 
        border-radius:50%;
    }
 </style>
<div class="content">
    <section class="content-header">
        <h1>
            <?php echo $page_title;?><small>
                <?php echo $sub_title;?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>"><i class="fa fa-home"></i> Home</a></li>
            <li><a href="<?php echo base_url()."shift";?>">
                    <?php echo $page_title;?></a></li>
            <li class="active">
                <?php echo $sub_title;?>
            </li>
        </ol>
    </section>
    <section class="content">
        <div class="box theia-box">
            <div class="box-header hide">
                <h3 class="box-title">
                    <?php echo $sub_title;?>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body theia-box-body">
                <nav class="nav nav-pills nav-justified">
                    <span class="nav-link active" id="shipments">Shipment #<?=$id?></span>
                    <span class="nav-link disabled" id="stops">Stops</span>
                    <span class="nav-link disabled" id="stop_details">Stop Details</span>
                    <span class="nav-link disabled" id="rates">Rates</span>
                    <span class="nav-link disabled" id="contacts">Contacts</span>
                    <span class="nav-link disabled" id="remarks">Remarks</span>
                </nav>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="callout_div"></div>
                    </div>
                </div>
                <div class="nav-content">
                    <div class="nav-block active" id="shipments_content">
                        <form id="shipment_form" method="POST" action="<?php echo base_url().'shift/add/'.$id;?>" autocomplete="off" onsubmit="return saveShipment()">
                            <div class="row">
                                 <div class="col-sm-6" style="display: flex;">
                                    <h5 style="padding:0px;">Shipment</h5>
                                    <select name="carrier_type" class="form-control">
                                        <option value= "0" <?php if($s['carrier_type']=='0') echo 'selected'; ?>>Single Carrier</option>
                                        <option value= "1" <?php if($s['carrier_type']=='1') echo 'selected'; ?>>Multiple Carrier</option>
                                    </select>
                                </div>
                                <div class="col-sm-6">
                                    <select name="border_type" id="border_type" class="form-control">
                                        <option value= "0" <?php if($s['border_type']=='0') echo 'selected'; ?>>Domestic</option>
                                        <option value= "1" <?php if($s['border_type']=='1') echo 'selected'; ?>>Cross Border</option>
                                    </select>
                                </div>
                            </div>                            
                            <div class="row">
                                <div class="col-sm-3 form-group">
                                    <label>Shipment Order Name:</label>
                                    <input type="text" name="shipment_name" id="shipment_name" value="<?php echo $s['shipment_name'];?>" class="form-control" placeholder="Order Name">
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label>Zone:</label>
                                    <select name="zone_id" id="zone_id" class="form-control">
                                        <option value="">-select-</option>
                                        <?php
                                        if($zones->num_rows()>0){
                                          foreach($zones->result() as $zone){
                                            echo "<option value='".$zone->id."'>".$zone->zone_name."</option>";
                                          }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <script type="text/javascript">
                                    <?php echo '$("#zone_id").val("'.$s['zone_id'].'");'; ?>
                                </script>
                                <div class="col-sm-3 form-group">
                                    <div class="form-group">
                                        <label>*Carrier:</label>
                                        <select name="vendor_id" id="vendor_id" class="form-control" required>
                                            <?php foreach($vendors->result() as $mt){ ?>
                                            <option value="<?php echo $mt->id;?>" <?php if(@$s['vendor_id']==$mt->id){ echo 'selected';}?>>
                                                <?php echo $mt->name.' - '.$mt->mobile;?>
                                            </option>
                                            <?php }?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <div class="form-group">
                                        <label>*Customer:</label>
                                        <select name="customer_id" id="customer_id" class="form-control" required>
                                            <?php foreach($customers as $mt){ ?>
                                            <option value="<?php echo $mt->id;?>" <?php if(@$s['customer_id']==$mt->id){ echo 'selected';}?>>
                                                <?php echo $mt->name.' - '.$mt->phone;?>
                                            </option>
                                            <?php }?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 form-group">
                                    <label><i class="red">*</i> Pickup Location </label>
                                    <input type="text" class="form-control place" name="splace" id="splace" value="<?php echo $s['splace'];?>" placeholder="Pickup Location" required /><input type="hidden" value="<?php echo $s['slat'];?>" name="slat" id="slat" class="lat"><input type="hidden" name="slng" value="<?php echo $s['slng'];?>" id="slng" class="lng">
                                </div>
                                <div class="col-sm-6 form-group">
                                    <label><i class="red">*</i> Droping Location </label>
                                    <input type="text" class="form-control place" name="eplace" id="eplace" value="<?php echo $s['eplace'];?>" placeholder="Dropping Loaction" required /><input type="hidden" value="<?php echo $s['elat'];?>" name="elat" id="elat" class="lat"><input type="hidden" name="elng" value="<?php echo $s['elng'];?>" id="elng" class="lng">
                                </div>
                                <div class="col-sm-3 bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>Pickup Date:</label>
                                        <input type="text" autocomplete="off" id="dp2" data-date-format="yyyy-mm-dd" placeholder="From Date" class="form-control datepicker" name="startdate" value="<?php echo date('Y-m-d',strtotime(@$s['startdate']));?>" onkeypress="return checkdate(event);" />
                                    </div>
                                </div>
                                <div class="col-sm-3 bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>Pickup Time:</label>
                                        <input type="text" name="stime" id="stime" value="<?php echo @$s['stime'];?>" class="form-control timepicker">
                                    </div>
                                </div>
                                <div class="col-sm-3 bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>Droping Date:</label>
                                        <input type="text" autocomplete="off" id="dp2" data-date-format="yyyy-mm-dd" placeholder="To Date" class="form-control datepicker" name="enddate" value="<?php echo date('Y-m-d',strtotime(@$s['enddate']));?>" onkeypress="return checkdate(event);" />
                                    </div>
                                </div>
                                <div class="col-sm-3 bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>Droping Time:</label>
                                        <input type="text" name="etime" id="etime" value="<?php echo @$s['etime'];?>" class="form-control timepicker">
                                    </div>
                                </div>
                                <div class="col-sm-3 ">
                                 <div class="form-group">      
                                 <label class="radio">  
                                  <input type="radio"   name="border_type" value="0" title="Border Type" <?php if($s['border_type']=='0') echo 'checked'; ?>>
                                 Domestic</label>
                                </div>
                                </div>
                                <div class="col-sm-3 ">
                                 <div class="form-group"> 
                                 <label  class="radio">  
                                  <input type="radio"   name="border_type" title="Border Type"  value="1" <?php if($s['border_type']=='1') echo 'checked'; ?>>
                                  Cross Border</label>
                                </div>
                                </div>
                            </div>
                            <input type="hidden" name="trip_type" value="0">
                            <div class="row">
                                <div class="col-sm-12 form-group">
                                    <input type="submit" class="btn btn-sm btn-save pull-right" value="Save" />
                                    <input type="reset" class="btn btn-sm btn-cancel pull-right" value="Cancel" />
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="nav-block" id="stops_content">
                        <div class="row">
                            <div class="col-sm-6">
                                <h5>Stops</h5>
                            </div>
                            <div class="col-sm-6">
                                <span class="pull-right addShipmentStop" style="color: #2c9dc5;cursor: pointer;"><i class="fa fa-plus-circle" style="color:#002b55;padding-right: 5px;"></i>Add New Shipment Stop</span>
                            </div>
                        </div>
                        <form method="POST" action="<?php echo base_url('shift/saveStop');?>" class="stop_form" id="stopForm" style="display: none" autocomplete="off" onsubmit="return saveStop();">
                            
                            <input type="hidden" name="shipment_id" id="shipment_id" value="<?=$id?>">  
                            <div class="col-sm-2 form-group">
                                <label><i class="red">*</i> Stop Type </label>
                                <select class="form-control" name="stoptype" id="stoptype">
                                    <option value="P">Only Pickups</option>
                                    <option value="D">Only Drops</option>
                                    <option value="P/D">Both Pickup & Drops</option>
                                </select>
                            </div>
                            <div class="col-sm-2 form-group">
                                <label> Sequence Number </label>
                                <input type="text" class="form-control onlynumaric" name="ordernumber" id="ordernumber" placeholder="Sequence Number" />
                            </div>
                            <div class="col-sm-4 form-group">
                                <label><i class="red">*</i> Stop Name </label>
                                <input type="text" class="form-control place" name="stopname" id="stopname" placeholder="Stop Name" required /><input type="hidden" name="plat" id="plat" class="lat"><input type="hidden" name="plng" id="plng" class="lng">
                            </div>

                            <div class="col-sm-4 form-group">
                                <label><i class="red">*</i> Address </label>
                                <input type="text" class="form-control" name="address" id="address" placeholder="Address" required />
                            </div>

                            <div class="col-sm-3 bootstrap-timepicker">
                                <div class="form-group">
                                    <label>Estimated Start:</label>
                                    <input type="text" autocomplete="off" id="startdate" data-date-format="Y-m-d H:i:s" placeholder="Estimated Start Date Time" class="form-control datetimepicker" name="startdate" onkeypress="return checkdate(event);" required/>
                                </div>
                            </div>

                            <div class="col-sm-3 bootstrap-timepicker">
                                <div class="form-group">
                                    <label>Estimated End:</label>
                                    <input type="text" autocomplete="off" id="enddate" data-date-format="Y-m-d H:i:s" placeholder="Estimated End Date Time" class="form-control datetimepicker" name="enddate" onkeypress="return checkdate(event);" required/>
                                </div>
                            </div>
                            <div class="col-sm-3 form-group">
                                <label> Weight </label>
                                <input type="text" class="form-control onlynumaric" name="weight" id="weight" placeholder="Weight" />
                            </div>
                            <div class="col-sm-3 form-group">
                                <label> Volume </label>
                                <input type="text" class="form-control onlynumaric" name="volume" id="volume" placeholder="Volume" />
                            </div>
                            <div class="col-sm-12 form-group">
                                <input type="submit" class="btn btn-sm btn-save pull-right" value="Save" />
                                <input type="reset" class="btn btn-sm btn-cancel pull-right saveStopCancel" value="Cancel" />
                            </div>
                        </form>

                        <table class="table table-striped stops_table table-theia">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Sequence No</th>
                                    <th>Stop</th>
                                    <th>Type</th>
                                    <th>Start</th>
                                    <th>End</th>
                                    <th>Weight</th>
                                    <th>Volumne</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <div class="nav-block" id="stop_details_content">
                        <div class="row">
                            <div class="col-sm-9" style="display: flex;">
                                <h5>Stop Details</h5>
                                <select style="border-color: transparent;background-color: transparent;display: inline;font-size: smaller;" id="stops_dropdown">
                                </select>
                            </div>
                            <div class="col-sm-3">
                                <span class="pull-right addShipmentStopDetail" style="color: #2c9dc5;cursor: pointer;"><i class="fa fa-plus-circle" style="color:#002b55;padding-right: 5px;"></i>Add New Pickup/Drop</span>
                            </div>
                        </div>
                        <form method="POST" enctype="multipart/form-data" action="<?php echo base_url('shift/emp_save');?>" class="stop_details_form" id="stopDetailsForm" style="display: none" autocomplete="off" onsubmit="return saveShipmentStopDetail();">
                            <div class="col-sm-1 form-group hide">
                                <label>Name:</label>
                                <input type="text" class="form-control" name="empName" id="empName" placeholder="Shipment/Stop Name" required />
                                <input type="hidden" name="emp_id" id="emp_id" value="0" />
                                <input type="hidden" name="assoc_id" id="assoc_id" value="0" />
                                <input type="hidden" name="shift_id" id="shift_id" value="<?=$id?>" />
                            </div>
                            <div class="col-sm-2 form-group">
                                <label title="Stop Sequence">Stop Sequence</label>
                                <input type="text" class="form-control onlynumaric" name="stop_order" id="stop_order" placeholder="Stop Number" />
                            </div>
                            <div class="col-sm-2 form-group">
                                <label>Order No:</label>
                                <input type="text" class="form-control" name="order_id" id="order_id" placeholder="Order No" />
                            </div>
                            <div class="col-sm-2 form-group">
                                <label>Material:</label>
                                <select name="material_id" id="material_id" class="form-control">
                                    <?php foreach(@$materials as $mt){ ?>
                                    <option value="<?php echo $mt->id;?>">
                                        <?php echo $mt->material;?>
                                    </option>
                                    <?php
                                    }?>
                                </select>
                            </div>
                            <div class="col-sm-2 form-group">
                                <label>Type:</label>
                                <select name="ship_type" id="ship_type" class="form-control">
                                    <option value="<?php echo 'D';?>">
                                        <?php echo 'Delivery';?>
                                    </option>
                                    <option value="<?php echo 'P';?>">
                                        <?php echo 'Pickup';?>
                                    </option>
                                    <option value="<?php echo 'I';?>">
                                        <?php echo 'In-Transit';?>
                                    </option>
                                </select>
                            </div>
                            <div class="col-sm-2 form-group">
                                <label>Customer:</label>
                                <select name="customer_id" id="customer_id" class="form-control" required>
                                    <?php foreach(@$customers as $mt){ ?>
                                    <option value="<?php echo $mt->id;?>">
                                        <?php echo $mt->name.' - '.$mt->phone;?>
                                    </option>
                                    <?php
                                    }?>
                                </select>
                            </div>
                            <div class="col-sm-2 form-group">
                                <label>*Carrier:</label>
                                <select name="carrier_id" id="carrier_id" class="form-control" required>
                                    <?php foreach(@$vendors->result() as $mt){ ?>
                                    <option value="<?php echo $mt->id;?>">
                                        <?php echo $mt->name.' - '.$mt->mobile;?>
                                    </option>
                                    <?php
                                    }?>
                                </select>
                            </div>
                            <div class="col-sm-3 form-group">
                                <label>Pickup Stop:</label>
                                <select class="form-control" id="stop_id" name="stop_id" required></select>
                            </div>
                            <div class="col-sm-5 form-group">
                                <label><i class="red">*</i>Pickup Location </label>
                                <input type="text" class="form-control place" name="pickup" id="pickup" placeholder="Pickup Location" required /><input type="hidden" name="plat" id="plat" class="lat"><input type="hidden" name="plng" id="plng" class="lng">
                            </div>
                            <div class="col-sm-4 bootstrap-timepicker">
                                <div class="form-group">
                                    <label>*Pickup Date:</label>
                                    <input type="text" autocomplete="off" id="pickup_datetime" data-date-format="yyyy-mm-dd" placeholder="From Date" class="form-control datetimepicker" name="pickup_datetime" onkeypress="return checkdate(event);" required/>
                                </div>
                            </div>
                            <div class="col-sm-3 form-group">
                                <label>Drop Stop:</label>
                                <select class="form-control" id="drop_stopid" name="drop_stopid" required></select>
                            </div>
                            <div class="col-sm-5 form-group">
                                <label><i class="red">*</i> Droping Location </label>
                                <input type="text" class="form-control place" name="drop" id="drop" placeholder="Dropping Loaction" required /><input type="hidden" name="dlat" id="dlat" class="lat"><input type="hidden" name="dlng" id="dlng" class="lng">
                            </div>
                            <div class="col-sm-4 bootstrap-timepicker">
                                <div class="form-group">
                                    <label>*Droping Date:</label>
                                    <input type="text" autocomplete="off" id="drop_datetime" data-date-format="yyyy-mm-dd" placeholder="To Date" class="form-control datetimepicker" name="drop_datetime" onkeypress="return checkdate(event);" required/>
                                </div>
                            </div>
                            <div class="col-sm-3 form-group">
                                <label><i class="red">*</i> Shipment Capacity </label>
                                <input type="text" class="form-control onlynumaric" name="capacity" id="capacity" placeholder="Capacity" />
                            </div>
                            <div class="col-sm-3 form-group">
                                <label><i class="red">*</i> Shipment Weight </label>
                                <input type="text" class="form-control onlynumaric" name="shipment_weight" id="shipment_weight" placeholder="Shipment Weight" />
                            </div>
                            <div class="col-sm-3 form-group">
                                <label><i class="red">*</i> Shipment Volume </label>
                                <input type="text" class="form-control onlynumaric" name="shipment_volume" id="shipment_volume" placeholder="Shipment Volume" />
                            </div>
                            <span class="hide">
                                <div class="col-sm-3 form-group">
                                    <label> Alternat Contact: </label>
                                    <input type="text" class="form-control onlynumaric" name="phone" id="phone" placeholder="Contact Number"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label><i class="red"></i> Email-ID </label>
                                    <input type="text" class="form-control" name="emailid" id="emailid" placeholder="Email-ID" />
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label><i class="red"></i> Information </label>
                                    <textarea class="form-control" name="information" id="information" placeholder="Information" style="height: 34px;"></textarea>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label><i class="red">*</i> Address </label>
                                    <textarea class="form-control" name="address" id="address" placeholder="Full Address" style="height: 34px;"></textarea>
                                </div>

                                <div class="col-md-3">
                                    <label> POD </label>
                                    <input type="file" name="img" id="img" class="form-control">
                                </div>
                            </span>
                            <div class="col-sm-12 form-group">
                                <input type="submit" class="btn btn-sm btn-save pull-right" value="Save" />
                                <input type="reset" class="btn btn-sm btn-cancel pull-right addShipmentStopDetailCancel" value="Cancel" />
                            </div>
                        </form>

                        <table class="table table-striped stop_details_table table-theia">
                            <thead>
                                <tr>
                                    <th>Leg</th>
                                    <th>Order ID</th>
                                    <th style="width: 400px;">Carrier Name</th>
                                    <th>Customer Name</th>
                                    <th>Material</th>
                                    <th>Pickup Date</th>
                                    <th>Drop Date</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <div class="nav-block" id="rates_content">
                        <div class="row">
                            <div class="col-sm-6">
                                <h5>Rates</h5>
                            </div>
                            <div class="col-sm-6">
                                <span class="pull-right addShipmentRate" style="color: #2c9dc5;cursor: pointer;"><i class="fa fa-plus-circle" style="color:#002b55;padding-right: 5px;"></i>Add new shipment rate</span>
                            </div>
                        </div>
                        <form method="POST" action="<?php echo base_url('shift/saveShipmentRate');?>" id="saveShipmentRate" class="saveShipmentRate" style="display: none" autocomplete="off" onsubmit="return saveShipmentRate()">
                            <input type="hidden" name="shift_id" id="shift_id" value="<?=$id?>" />
                            <div class="col-sm-3 form-group">
                                <label> Category </label>
                                <select name="category" id="category" class="form-control">
                                    <?php foreach(@$rateCategories as $mt){ ?>
                                    <option value="<?php echo $mt->id;?>">
                                        <?php echo $mt->name;?>
                                    </option>
                                    <?php
                                    }?>
                                </select>
                            </div>
                            <div class="col-sm-3 form-group">
                                <label> Rate </label>
                                <input type="text" class="form-control" name="rate" id="rate" placeholder="Rate" />
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-sm-6 form-group">
                                <input type="submit" class="btn btn-sm btn-save pull-right" value="Save" />
                                <input type="reset" class="btn btn-sm btn-cancel pull-right addShipmentRateCancel" value="Cancel" />
                            </div>
                        </form>
                        <table class="table table-striped rates-table table-theia">
                            <thead>
                                <tr>
                                    <th>Category</th>
                                    <th>Buy</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <div class="nav-block" id="contacts_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <h5>Contacts</h5>
                            </div>
                        </div>
                    </div>
                    <div class="nav-block" id="remarks_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <h5>Remarks</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="overlay" style="display: none;">
                <i class="fa fa-refresh fa-spin"></i>
            </div>
            <!-- /.box-body -->
        </div>
    </section>
</div>
<script type="text/javascript">
    function checkdate(evt) {
        var keyCode = (evt.which) ? evt.which : evt.keyCode
        if (keyCode == 8 || keyCode == 73) {
            $(this).val('');
        }
        return false;
    }
    var ele;
    $(document).ready(function() {
        $('input').on('keydown', function() { 
            ele = $(this);
        });
        setUpNextItemsVisibility();
        $(".nav .nav-link").click(function(e) {
            if(!$(this).hasClass("disabled")){
                var eleId = $(this).attr("id");
                $(".nav-content .nav-block").each(function() {
                    $(this).removeClass("active");
                });
                $(".nav .nav-link").each(function() {
                    $(this).removeClass("active");
                });
                $(".nav-block#" + eleId + "_content").addClass("active");
                $(".nav-link#" + eleId).addClass("active");
            }
        });
        $('.onlynumaric').keypress(function(event){
            var charCode = (event.which) ? event.which : event.keyCode;
            if ((charCode != 45 || $(this).val().indexOf('-') != -1) && (charCode != 46 || $(this).val().indexOf('.') != -1) && (charCode < 48 || charCode > 57) && (charCode != 8) && (charCode != 9)){
                return false;
            }
            return true;
        });
        $(".addShipmentStop").click(function(){
            var form =$("form#stopForm");
            var shipmentForm =$("form#shipment_form");
            form.show();
            form.attr("action","<?php echo base_url('shift/saveStop');?>");
            var shift_id = form.find("#shipment_id").val();
            var stop_no = $('.stops_table tbody tr').length;
            form.find("#ordernumber").val(((stop_no/2)+1));
            form.find("#stoptype").val("P");
            if(stop_no == 0){
                form.find("#stopname").val(shipmentForm.find("#splace").val());
                form.find("#stopname").closest("div").find(".lat").val(shipmentForm.find("#splace").closest("div").find(".lat").val());
                form.find("#stopname").closest("div").find(".lng").val(shipmentForm.find("#splace").closest("div").find(".lng").val());
                form.find("#startdate").val("<?php echo date('Y-m-d H:i:s',strtotime(date('Y-m-d',strtotime($s['startdate']))." ".$s['stime'].":00"));?>");
                form.find("#enddate").val("<?php echo date('Y-m-d H:i:s',strtotime($s['enddate']." ".$s['etime']));?>");
            }else{
                form.find("#stopname").val($(".stops_table tbody tr:last").find("td:nth-child(3)").html());
                form.find("#stopname").closest("div").find(".lat").val($('.stops_table tbody tr:last').data("lat"));
                form.find("#stopname").closest("div").find(".lng").val($('.stops_table tbody tr:last').data("lng"));
                form.find("#startdate").val($(".stops_table tbody tr:last").find("td:nth-child(6)").html());
                form.find("#enddate").val("<?php echo date('Y-m-d H:i:s',strtotime(date('Y-m-d',strtotime($s['enddate']))." ".$s['etime']));?>");
            }
        });
        $(".addShipmentStopDetail").click(function(){
            var form = $("form#stopDetailsForm");
            form.show();
            form.attr("action","<?php echo base_url('shift/emp_save');?>");
            var shift_id = form.find("#shift_id").val();
            var stop_no = $('.stop_details_table tbody tr').length;
            var carrier_type = $("select[name='carrier_type']").val();
            var carrier = $("form#shipment_form").find("#vendor_id").val();
            var customer_id = $("form#shipment_form").find("#customer_id").val();
            form.find("#customer_id").val(customer_id);
            form.find("#vendor_id").val(carrier);
            form.find("#stop_order").val(((stop_no/2)+1));
            form.find("#empName").val("#"+shift_id+"-"+((stop_no/2)+1));
            if(carrier_type == 0){
                form.find("#carrier_id").attr("readonly",true);
            }else{
                form.find("#carrier_id").removeAttr("readonly");
            }
            if(stop_no == 0){
                var parts = $(".nav-link#stops").html().split("#");
                var stop_id = "";
                if(parts.length==2){
                    stop_id = parts[1];
                }
                var assoc_tr = $("tr[data-id='"+stop_id+"']");
                var trData = assoc_tr.data();
                form.find("#pickup").val(assoc_tr.find("td:nth-child(3)").html());
                form.find("#pickup").closest("div").find(".lat").val(trData.lat);
                form.find("#pickup").closest("div").find(".lng").val(trData.lng);
                form.find("#pickup_datetime").val(assoc_tr.find("td:nth-child(5)").html());
                form.find("#drop").val("");
                form.find("#drop").closest("div").find(".lat").val("");
                form.find("#drop").closest("div").find(".lng").val("");
                form.find("#drop_datetime").val("");
            }else{
                form.find("#pickup").val($('.stop_details_table tbody tr:last').data("eplace"));
                form.find("#pickup").closest("div").find(".lat").val($('.stop_details_table tbody tr:last').data("elat"));
                form.find("#pickup").closest("div").find(".lng").val($('.stop_details_table tbody tr:last').data("elng"));
                form.find("#pickup_datetime").val($('.stop_details_table tbody tr:last').data("ddate"));
                form.find("#drop").val("");
                form.find("#drop").closest("div").find(".lat").val("");
                form.find("#drop").closest("div").find(".lng").val("");
                form.find("#drop_datetime").val("");
            }
        });
        $(".addShipmentStopDetailCancel").click(function(){
            $("form#stopDetailsForm").trigger("reset");
            $("form#stopDetailsForm").hide();
        });
        $(".saveStopCancel").click(function(){
            $("form#stopForm").trigger("reset");
            $("form#stopForm").hide();
        });
        $(".addShipmentRate").click(function(){
            $("form#saveShipmentRate").show();
        });
        $(".addShipmentRateCancel").click(function(){
            $("form#saveShipmentRate").trigger("reset");
            $("form#saveShipmentRate").hide();
        });
        $(".nav-link#stops").click(function(){
            if(!$(this).hasClass("disabled")){
                getShipmentStops();
            }
        });
        $(".nav-link#stop_details").click(function(){
            if(!$(this).hasClass("disabled")){
                getShipmentStopDetails();
            }
        });
        $(".nav-link#rates").click(function(){
            if(!$(this).hasClass("disabled")){
                getShipmentRates();
            }
        });
        $("#stops_dropdown").change(function(){
            var stop_id = $(this).val();
            $("span.nav-link#stops").html("Stops #"+stop_id);
            $("span.nav-link#stop_details").click();
        });
        var fields = document.getElementsByClassName("place");
        for(var i=0;i<fields.length;i++){
            var input = fields[i];

            new google.maps.places.Autocomplete(input).addListener('place_changed', function() {
                var place = this.getPlace();
                if (place==undefined || !place.geometry) {
                    return;
                }
                if (place.geometry.viewport) {
                    ele.closest("div").find(".lat").val(place.geometry.viewport.getCenter().lat());
                    ele.closest("div").find(".lng").val(place.geometry.viewport.getCenter().lng());
                } else if (place.geometry.location) {
                    ele.closest("div").find(".lat").val(place.geometry.location.lat());
                    ele.closest("div").find(".lng").val(place.geometry.location.lng());
                }
            });
        }
        $(".timepicker").timepicker({
            showInputs: false
        });
        $('.datepicker').datepicker({
            format: "yyyy-mm-dd"
        });
        $(".datetimepicker").datetimepicker({
            format:"Y-m-d H:i:s"
        });
    });

    function saveShipment() {
        var data = $("#shipment_form").serializeArray();
        $.ajax({
            url: $("#shipment_form").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                if (data.status == "0") {
                    alert("Shipment saving failed.");
                } else {
                    alert("Shipment saved sucessfully.");
                    $("#shipment_form").attr("action", "<?=base_url()?>shift/add/" + data.shipment_id);
                    $(".stop_details_form").find("#shift_id").val(data.shipment_id);
                    $("#saveShipmentRate").find("#shift_id").val(data.shipment_id);
                    $(".stop_form").find("#shipment_id").val(data.shipment_id);
                    $("#shipments").html("Shipment #"+data.shipment_id);
                    setUpNextItemsVisibility();
                    $(".nav").find("#stops").click();
                }
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while creating shipment.");
            }
        });
        return false;
    }
    function saveStop(){
        var data = $("form.stop_form").serializeArray();
        $.ajax({
            url: $("form.stop_form").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                if (data.status == "0") {
                    alert(data.message);
                } else {
                    alert(data.message);
                    $("form#stopForm").trigger("reset");
                    $("form#stopForm").hide();
                    getShipmentStops();
                }
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while creating shipment stop.");
            }
        });
        return false;
    }
    function saveShipmentStopDetail(){
        var data =  new FormData($(".stop_details_form")[0]);
        $.ajax({
            url: $(".stop_details_form").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            contentType: false,
            processData: false,
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                if (data.status == "0") {
                    alert(data.message);
                } else {
                    alert(data.message);
                    $("form#stopDetailsForm").trigger("reset");
                    $("form#stopDetailsForm").hide();
                    getShipmentStopDetails();
                }
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while creating shipment stop detail.");
            }
        });
        return false;
    }
    function saveShipmentRate(){
        var data =  $(".saveShipmentRate").serializeArray();
        $.ajax({
            url: $(".saveShipmentRate").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                if (data.status == "0") {
                    alert(data.message);
                } else {
                    alert(data.message);
                    $("form#saveShipmentRate").trigger("reset");
                    $("form#saveShipmentRate").hide();
                    getShipmentRates();
                }
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while creating shipment stop.");
            }
        });
        return false;
    }
    function getShipmentStops(){
        var action = $("#shipment_form").attr("action");
        var action_parts = action.split("/");
        var id = (action_parts[action_parts.length - 1]).trim();
        $.ajax({
            url: '<?=base_url('shift/getShipmentStops')?>',
            type: "POST",
            data: {shift_id:id},
            dataType: "JSON",
            beforeSend: function() {
                $(".saveStopCancel").click();
                $(".overlay").show();
                $(".stops_table").find("tbody").html("");
            },
            success: function(data) {
                $(".overlay").hide();
                populateShipmentStops(data);
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment stops.");
            }
        });

    }
    function populateShipmentStops(data){
        $.each(data,function(key,val){
            if(key==0){
                $("span.nav-link#stops").html("Stops #"+val.id);
            }
            $(".stops_table").find("tbody").append('<tr>'+
                '<td colspan="10">'+val.address+'</td>'+
            '</tr>'+
            '<tr data-lat="'+val.plat+'" data-lng="'+val.plng+'" data-id="'+val.id+'">'+
                '<td>'+val.id+'</td>'+
                '<td>'+val.ordernumber+'</td>'+
                '<td style="color: #28B8EB;font-weight: 600;">'+val.stopname+'</td>'+
                '<td>'+val.stoptype+'</td>'+
                '<td>'+val.startdate+'</td>'+
                '<td>'+val.enddate+'</td>'+
                '<td>'+val.weight+'</td>'+
                '<td>'+val.volume+'</td>'+
                '<td><div class="btn btn-xs btn-primary" title="Edit" onClick="editStop('+val.id+')"><i class="fas fa-pencil-alt"></i></div> | <div class="btn btn-xs btn-default" onClick="showStopDetails('+val.id+')">Stop Details</div></td>'+
            '</tr>');
        });
    }
    function showStopDetails(id){
        $("span.nav-link#stops").html("Stops #"+id);
        $("span.nav-link#stop_details").click();
    }
    function getShipmentStopDetails(){
        var action = $("#shipment_form").attr("action");
        var action_parts = action.split("/");
        var id = (action_parts[action_parts.length - 1]).trim();
        var parts = $(".nav-link#stops").html().split("#");
        var stop_id = "";
        if(parts.length==2){
            stop_id = parts[1];
        }
        $.ajax({
            url: '<?=base_url('shift/getShipmentStopDetails')?>',
            type: "POST",
            data: {shift_id:id,stop_id:stop_id},
            dataType: "JSON",
            beforeSend: function() {
                $(".addShipmentStopDetailCancel").click();
                $(".overlay").show();
                $(".stop_details_table").find("tbody").html("");
                $("#stops_dropdown").html("");
                $("#stop_id").html("");
                $("#drop_stopid").html("");
            },
            success: function(data) {
                if(data.status=="1"){
                    $.each(data.stop_details,function(key,val){
                        $(".stop_details_table").find("tbody").append('<tr>'+
                            '<td>'+val.stop_order+'</td>'+
                            '<td colspan="8">'+val.pickup+' <i class="fa fa-long-arrow-right"></i> '+val.drop+'</td>'+
                        '</tr>'+
                        '<tr data-slat="'+val.plat+'" data-slng="'+val.plng+'" data-elat="'+val.dlat+'" data-elng="'+val.dlng+'" data-splace="'+val.pickup+'" data-eplace="'+val.drop+'" data-pdate="'+val.pickup_datetime+'" data-ddate="'+val.drop_datetime+'">'+
                            '<td></td>'+
                            '<td>'+val.order_id+'</td>'+
                            '<td style="color: #28B8EB;font-weight: 600;">'+val.carrier_name+'</td>'+
                            '<td>'+val.customer_name+'</td>'+
                            '<td>'+val.material_name+'</td>'+
                            '<td>'+val.pickup_datetime+'</td>'+
                            '<td>'+val.drop_datetime+'</td>'+
                            '<td>'+val.ship_type+'</td>'+
                            '<td><div class="btn btn-xs btn-primary" title="Edit" onClick="editStopDetails('+val.id+')"><i class="fas fa-pencil-alt"></i></div></td>'+
                        '</tr>');
                    });
                    
                    $.each(data.stops,function(key,val){
                        if(stop_id==val.id){
                            $("#stops_dropdown").append("<option value='"+val.id+"' selected>"+val.stopname+"</option>");
                            $("#stop_id").append("<option value='"+val.id+"' selected>"+val.stopname+"</option>");
                            $("#drop_stopid").append("<option value='"+val.id+"' selected>"+val.stopname+"</option>");
                        }else{
                            $("#stops_dropdown").append("<option value='"+val.id+"'>"+val.stopname+"</option>");
                            $("#stop_id").append("<option value='"+val.id+"'>"+val.stopname+"</option>");
                            $("#drop_stopid").append("<option value='"+val.id+"'>"+val.stopname+"</option>");
                        }
                    });
                    populateShipmentStops(data.stops);
                    if(stop_id.trim().length>0){
                        $("span.nav-link#stops").html("Stops #"+stop_id);
                    }
                    $(".overlay").hide();
                }else{
                    $(".overlay").hide();
                    alert(data.message);
                }
                //stops_dropdown
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment stops.");
            }
        });
    }

    function getShipmentRates(){
        var action = $("#shipment_form").attr("action");
        var action_parts = action.split("/");
        var id = (action_parts[action_parts.length - 1]).trim();
        $.ajax({
            url: '<?=base_url('shift/getShipmentRates')?>',
            type: "POST",
            data: {shift_id:id},
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
                $(".rates-table").find("tbody").html("");
            },
            success: function(data) {
                $(".overlay").hide();
                $.each(data.rates,function(key,val){
                    $(".rates-table").find("tbody").append('<tr>'+
                        '<td>'+val.category+'</td>'+
                        '<td>'+val.rate+'</td>'+
                        '<td><div class="btn btn-xs btn-primary" title="Edit" onClick="editRates('+val.id+')"><i class="fas fa-pencil-alt"></i></div></td>'+
                    '</tr>');
                });
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment rates.");
            }
        });
    }
    function editRates(rate_id){
        $.ajax({
            url: '<?=base_url('shift/editRate')?>',
            type: "POST",
            data: {rate_id:rate_id},
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                $("form#saveShipmentRate").show();
                populateRateData(data.rate);
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment rates.");
            }
        });
    }
    function populateRateData(rate){
        var form=$("form#saveShipmentRate");
        form.attr("action","<?php echo base_url('shift/saveShipmentRate');?>/"+rate.id);
        form.find("#category").val(rate.category);
        form.find("#rate").val(rate.rate);
    }
    function editStopDetails(stop_id){
        $.ajax({
            url: '<?=base_url('shift/editStopDetails')?>',
            type: "POST",
            data: {stop_id:stop_id},
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                $("form#stopDetailsForm").show();
                populateStopDetailData(data.stop);
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment stop.");
            }
        });
    }
    function editStop(stop_id){
        $.ajax({
            url: '<?=base_url('shift/editStop')?>',
            type: "POST",
            data: {stop_id:stop_id},
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                $("form#stopForm").show();
                populateStopData(data.stop);
            },
            error: function() {
                $(".overlay").hide();
                alert("Got some error while retreving shipment stop.");
            }
        });
    }
    function populateStopData(stop){
        var form=$(".stop_form");//dhanu
        form.attr("action","<?php echo base_url('shift/saveStop');?>/"+stop.id);
        form.find("#stoptype").val(stop.stoptype);
        form.find("#address").val(stop.address);
        form.find("#ordernumber").val(stop.ordernumber);
        form.find("#enddate").val(stop.enddate);
        form.find("#startdate").val(stop.startdate);
        form.find("#plat").val(stop.plat);
        form.find("#plng").val(stop.plng);
        form.find("#stopname").val(stop.stopname);
        form.find("#volume").val(stop.volume);
        form.find("#weight").val(stop.weight);
    }
    function populateStopDetailData(stop){
        var form=$(".stop_details_form");
        form.attr("action","<?php echo base_url('shift/emp_save');?>/"+stop.id);
        form.find("#empName").val(stop.name);
        form.find("#emp_id").val(stop.id);
        form.find("#assoc_id").val(stop.assoc_id);
        form.find("#shift_id").val(stop.shift_id);
        form.find("#shift_id").val(stop.shift_id);
        form.find("#customer_id").val(stop.customer_id);
        form.find("#carrier_id").val(stop.vendor_id);
        form.find("#phone").val(stop.phone);
        form.find("#pickup").val(stop.pickup);
        form.find("#pickup_datetime").val(stop.pickup_datetime);
        form.find("#plat").val(stop.plat);
        form.find("#plng").val(stop.plng);
        form.find("#drop").val(stop.drop);
        form.find("#drop_datetime").val(stop.drop_datetime);
        form.find("#dlat").val(stop.dlat);
        form.find("#dlng").val(stop.dlng);
        form.find("#capacity").val(stop.capacity);
        form.find("#shipment_weight").val(stop.shipment_weight);
        form.find("#shipment_volume").val(stop.shipment_volume);
        form.find("#ship_type").val(stop.ship_type);
        form.find("#stop_order").val(stop.stop_order);
        form.find("#order_id").val(stop.order_id);
        form.find("#material_id").val(stop.material_id);
        form.find("#emailid").val(stop.emailid);
        form.find("#information").val(stop.information);
        form.find("#address").val(stop.address);
        var carrier_type = $("select[name='carrier_type']").val();
        if(carrier_type == 0){
            $("form#stopDetailsForm").find("#carrier_id").attr("readonly",true);
        }else{
            $("form#stopDetailsForm").find("#carrier_id").removeAttr("readonly");
        }
    }

    //common functions
    function alert(message) {
        var message = '<div class="alert alert-warning alert-dismissible message-alert">' +
            '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>' +
            '<h4><i class="icon fa fa-warning"></i> Alert!</h4>' +
            message +
            '</div>';
        $(".callout_div").html(message);
        $(".message-alert").fadeTo(2000, 500).slideUp(500, function() {
            $(".message-alert").slideUp(500);
        });
    }

    function setUpNextItemsVisibility() {
        var action = $("#shipment_form").attr("action");
        var action_parts = action.split("/");
        var id = (action_parts[action_parts.length - 1]).trim();
        if (id == "") {
            $(".nav").find("#stops").removeClass("active");
            $(".nav").find("#stop_details").removeClass("active");
            $(".nav").find("#contacts").removeClass("active");
            $(".nav").find("#remarks").removeClass("active");
            $(".nav").find("#rates").removeClass("active");
            $(".nav").find("#stops").addClass("disabled");
            $(".nav").find("#stop_details").addClass("disabled");
            $(".nav").find("#contacts").addClass("disabled");
            $(".nav").find("#remarks").addClass("disabled");
            $(".nav").find("#rates").addClass("disabled");
        } else {
            $(".nav").find("#stops").removeClass("disabled");
            $(".nav").find("#stop_details").removeClass("disabled");
            $(".nav").find("#contacts").removeClass("disabled");
            $(".nav").find("#remarks").removeClass("disabled");
            $(".nav").find("#rates").removeClass("disabled");
        }
    }
</script>