<div id="map" style="height: 500px;"></div>
<div class="box-footer map-footer">
  <table style="color: #222d32;font-weight: 1000;-webkit-text-stroke: .25px #ffffff;background: linear-gradient(to right,#fff,#ffffff05 100%);width: auto;">
    <tbody>
      <tr>
        <td class="map_route_distance"></td>
      </tr>
      <tr>
        <td class="map_route_duration"></td>
      </tr>
    </tbody>
  </table>
</div>
<?php
$cntrylatlng['ulat'] = 20.5937;
$cntrylatlng['ulng'] = 78.9629;
if ($this->session->userdata("user_id") !== FALSE) {
  $lguid = $this->session->userdata("user_id");
  $cntrylatlng = getLogUserLatLng($lguid);
}
?>
<?php if (!empty($stops)): ?>
  <?php foreach ($stops as $index => $s): ?>
    <span class="shipstopopen"
      data-plat="<?php echo $s['plat']; ?>"
      data-plng="<?php echo $s['plng']; ?>"
      data-dlat="<?php echo $s['dlat']; ?>"
      data-dlng="<?php echo $s['dlng']; ?>"
      data-p_place="<?php echo $s['pickup_city']; ?>"
      data-d_place="<?php echo $s['delivery_city']; ?>"
      data-tmode="<?php echo $s['tmode']; ?>">
    </span>
  <?php endforeach; ?>
<?php endif; ?>


<script type="text/javascript">
  var ulglat = <?php echo $cntrylatlng['ulat']; ?>;
  var ulglng = <?php echo $cntrylatlng['ulng']; ?>;
  var points = [];
  var map;
  var directionsService;
  var directionsRenderer;
  var markers = [];
  var polylines = [];


  //  $(document).ready(function(){
  $(".shipstopopen").each(function(index) {
    var point = {
      "plat": $(this).data("plat"),
      "plng": $(this).data("plng"),
      "dlat": $(this).data("dlat"),
      "dlng": $(this).data("dlng"),
      "p_place": $(this).data("p_place"),
      "d_place": $(this).data("d_place"),
      'tmode': $(this).data('tmode')
    };

    points.push(point);

  });



  // });
  function initMap() {
    directionsService = new google.maps.DirectionsService;
    directionsRenderer = new google.maps.DirectionsRenderer({
      suppressMarkers: true,
      preserveViewport: true
    });
    map = new google.maps.Map(document.getElementById('map'), {
      zoom: 4,
      center: {
        lat: ulglat,
        lng: ulglng
      },
      disableDefaultUI: true,
      styles: [{
        featureType: "all",
        stylers: [{
          saturation: 0
        }, {
          hue: "#e7ecf0"
        }]
      }, {
        featureType: "road",
        stylers: [{
          saturation: -70
        }]
      }, {
        featureType: "transit",
        stylers: [{
          visibility: "off"
        }]
      }, {
        featureType: "poi",
        stylers: [{
          visibility: "off"
        }]
      }, {
        featureType: "water",
        stylers: [{
          visibility: "simplified"
        }, {
          saturation: -60
        }]
      }]
    });
    directionsRenderer.setMap(map);
    console.log("POINTS:",points)
    console.log("POINTS Length:"+points.length);
    if (points.length < 2) {
      console.log("f1");
      calculateAndDisplayRoute(directionsService, directionsRenderer, map);
    } else {
      console.log("f2");
      plotroute();
    }
  }

  function plotroute() {
    if (!points.length) return;

    clearPolylines();
    clearBranchMarkers();

    const bounds = new google.maps.LatLngBounds();


    // Draw paths between consecutive stops
    for (let i = 0; i < points.length; i++) {
      const start = new google.maps.LatLng(Number(points[i].plat), Number(points[i].plng));
      const end = new google.maps.LatLng(Number(points[i].dlat), Number(points[i].dlng));
      const tmode = points[i].tmode;

      if (tmode === "FTL" || tmode === "LTL" || tmode === "Test Transport 123") {
        const startMarker = new google.maps.Marker({
          position: start,
          map: map,
          title: points[i].p_place,
          icon: {
            url: "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>",
            scaledSize: new google.maps.Size(25, 25)
          }
        });
        markers.push(startMarker);

        const endMarker = new google.maps.Marker({
          position: end,
          map: map,
          title: points[i].d_place,
          icon: {
            url: "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
            scaledSize: new google.maps.Size(25, 25)
          }
        });
        markers.push(endMarker);
        // Road transport (Driving)
        const request = {
          origin: start,
          destination: end,
          travelMode: google.maps.TravelMode.DRIVING
        };

        directionsService.route(request, function(result, status) {
          if (status === google.maps.DirectionsStatus.OK) {
            let segmentRenderer = new google.maps.DirectionsRenderer({
              suppressMarkers: true,
              preserveViewport: true,
            });
            segmentRenderer.setMap(map);
            segmentRenderer.setDirections(result);
            polylines.push(segmentRenderer); // keep track so you can clear later
            fitBoundsZoom(start, end);
          } else {
            alert("Unable to plot road route.");
          }
        });

      } else if (tmode === "RAIL") {

        const railStartMarker = new google.maps.Marker({
          position: start,
          map: map,
          title: "Railway Station",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/train.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });
        markers.push(railStartMarker);

        const railEndMarker = new google.maps.Marker({
          position: end,
          map: map,
          title: "Railway Station",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/train.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });
        markers.push(railEndMarker);

        const railPath = new google.maps.Polyline({
          path: [start, end],
          geodesic: true,
          strokeColor: "#007400",
          strokeOpacity: 0,
          strokeWeight: 3,
          icons: [{
            icon: {
              path: "M 0,-1 0,1",
              strokeOpacity: 1,
              scale: 4
            },
            offset: "0",
            repeat: "20px"
          }],
          map: map
        });

        polylines.push(railPath);

        let count = 0;
        window.setInterval(() => {
          count = (count + 1) % 200;

          const icons = railPath.get('icons');
          icons[0].offset = (count / 2) + '%';
          railPath.set('icons', icons);
        }, 100);
      } else if (tmode === "AIR") {

        const AirStartMarker = new google.maps.Marker({
          position: start,
          map: map,
          title: "Pickup Airport",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });

        markers.push(AirStartMarker);

        const AirEndMarker = new google.maps.Marker({
          position: end,
          map: map,
          title: "Drop Airport",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });

        markers.push(AirEndMarker);


        var airPath = new google.maps.Polyline({
          path: [start, end],
          geodesic: true,
          strokeColor: "#7b1c1cff",
          strokeOpacity: 0,
          strokeWeight: 1,
          icons: [{
            icon: {
              path: "M 0,-1 0,1",
              strokeOpacity: 1,
              scale: 4
            },
            offset: "0",
            repeat: "20px"
          }],
          map: map
        });
        polylines.push(airPath);

        var count = 0;
        window.setInterval(() => {
          count = (count + 1) % 200;
          const icons = airPath.get("icons");
          icons[0].offset = (count / 2) + "%";
          airPath.set("icons", icons);
        }, 100);
        fitBoundsZoom(map, start, end, 6);
      }
    }


    // Fit all points
    map.fitBounds(bounds);
  }




  // Utility: returns marker icon based on mode & position
  function getMarkerIcon(tmode, position) {
    if (tmode === "FTL" || tmode === "LTL" || tmode === "Test Transport 123") {
      return {
        url: position === "start" ?
          "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>" : "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
        scaledSize: new google.maps.Size(25, 25)
      };
    } else if (tmode === "RAIL") {
      return {
        url: "https://img.icons8.com/ios-filled/50/train.png",
        scaledSize: new google.maps.Size(25, 25)
      };
    } else if (tmode === "AIR") {
      return {
        url: position === "start" ?
          "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png" : "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
        scaledSize: new google.maps.Size(25, 25)
      };
    }
  }


  function clearPolylines() {
    if (polylines && polylines.length) {
      polylines.forEach(p => p.setMap(null)); // remove from map
    }
    polylines = [];
  }

  function clearBranchMarkers() {
    markers.forEach(marker => marker.setMap(null));
    markers.length = 0;
  }

  function fitBoundsZoom(start, end) {
    const bounds = new google.maps.LatLngBounds();
    bounds.extend(start);
    bounds.extend(end);

    map.fitBounds(bounds);

    const listener = google.maps.event.addListener(map, "bounds_changed", function() {
      if (map.getZoom() > 15) {
        map.setZoom(15);
      }
      google.maps.event.removeListener(listener);
    });
  }

  function calculateAndDisplayRoute(directionsService, directionsRenderer, map) {
      /*alert(points[0].tmode +"_"+points[0].plat+"_"+points[0].plng +"_"+points[0].dlat+"_"+points[0].dlng);*/
    var tmode = points[0].tmode;
    var startLat = points[0].plat;
    var startLng = points[0].plng;
    var endLat = points[0].dlat;
    var endLng = points[0].dlng;
    console.log(startLat, startLng, endLat, endLng);
    if (directionsRenderer) {
      directionsRenderer.setMap(null);
    }
    directionsRenderer = new google.maps.DirectionsRenderer({
      suppressMarkers: true
    });

    directionsRenderer.setMap(map);

    clearPolylines();
    clearBranchMarkers();


    const start = new google.maps.LatLng(startLat, startLng);
    const end = new google.maps.LatLng(endLat, endLng);


    if (tmode === "FTL" || tmode === "LTL" || tmode === "Test Transport 123") {
      const startMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "Pickup Location",
        icon: {
          url: "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>",
          scaledSize: new google.maps.Size(25, 25)
        }
      });
      markers.push(startMarker);

      const endMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "Delivery Location",
        icon: {
          url: "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
          scaledSize: new google.maps.Size(25, 25)
        }
      });
      markers.push(endMarker);
      // Road transport (Driving)
      const request = {
        origin: start,
        destination: end,
        travelMode: google.maps.TravelMode.DRIVING
      };

      directionsService.route(request, function(result, status) {
        if (status === google.maps.DirectionsStatus.OK) {
          directionsRenderer.setDirections(result);
          fitBoundsZoom(start, end);
        } else {
          alert("Unable to plot road route.");
        }
      });

    } else if (tmode === "RAIL") {

        const railStartMarker = new google.maps.Marker({
          position: start,
          map: map,
          title: "Railway Station",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/train.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });
        markers.push(railStartMarker);

        const railEndMarker = new google.maps.Marker({
          position: end,
          map: map,
          title: "Railway Station",
          icon: {
            url: "https://img.icons8.com/ios-filled/50/train.png",
            scaledSize: new google.maps.Size(33, 33)
          }
        });
        markers.push(railEndMarker);

        const railPath = new google.maps.Polyline({
          path: [start, end],
          geodesic: true,
          strokeColor: "#007400",
          strokeOpacity: 0,
          strokeWeight: 3,
          icons: [{
            icon: {
              path: "M 0,-1 0,1",
              strokeOpacity: 1,
              scale: 4
            },
            offset: "0",
            repeat: "20px"
          }],
          map: map
        });

        polylines.push(railPath);

        let count = 0;
        window.setInterval(() => {
          count = (count + 1) % 200;

          const icons = railPath.get('icons');
          icons[0].offset = (count / 2) + '%';
          railPath.set('icons', icons);
        }, 100);
      } else if (tmode === "AIR") {

      const airStartMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "AIRPORT",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
          scaledSize: new google.maps.Size(25, 25)
        }
      });

      markers.push(airStartMarker);

      const airEndMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "AIRPORT",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
          scaledSize: new google.maps.Size(25, 25)
        }
      });

      markers.push(airEndMarker);

      const airPath = new google.maps.Polyline({
        path: [end, start],
        geodesic: true,
        strokeColor: "#7b1c1cff",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: map
      });
      polylines.push(airPath);

      var count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;

        const icons = airPath.get('icons');
        icons[0].offset = (count / 2) + '%'; // shift dots
        airPath.set('icons', icons);
      }, 100); // adjust speed here
    }
  }

  initMap();
</script>
</body>

</html>