<div id="map" style="height: 250px;"></div>
<div class="box-footer map-footer">
    <table style="color: #222d32;font-weight: 1000;-webkit-text-stroke: .25px #ffffff;background: linear-gradient(to right,#fff,#ffffff05 100%);width: auto;">
        <tbody>
            <tr>
                <td class="map_route_distance"></td>
            </tr>
            <tr>
                <td class="map_route_duration"></td>
            </tr>
        </tbody>
    </table>
</div>
<?php
$cntrylatlng['ulat'] = 20.5937;
$cntrylatlng['ulng'] = 78.9629;
if ($this->session->userdata("user_id") !== false) {
    $lguid = $this->session->userdata("user_id");
    $cntrylatlng = getLogUserLatLng($lguid);
}
?>
<?php if (count($stops) > 0) {
    foreach ($stops as $s) {?>
<span class="shipstopopen" data-lat="<?php echo $s['plat']; ?>" data-lng="<?php echo $s['plng']; ?>" data-place="<?php echo $s['stopname']; ?>"></span>
<?php }}?>
<script type="text/javascript">
    var ulglat = <?php echo $cntrylatlng['ulat']; ?>;
    var ulglng = <?php echo $cntrylatlng['ulng']; ?>;
    var points = [];
    var waypointNamesArr = ["A", "B", "C", "D", "E", "F", "G"];
    
    $(document).ready(function() {
        $(".shipstopopen").each(function() {
            points.push({
                "lat": $(this).data("lat"),
                "lng": $(this).data("lng"),
                "place": $(this).data("place")
            });
        });
    });

    var map;
    var markers = [];
    var group;

    function hasProperty(obj, key) {
        return obj.hasOwnProperty(key);
    }
    
    function initMap() {
        var CHINA_HERE_MAP_API_ID='<?=CHINA_HERE_MAP_API_ID;?>';
        var CHINA_HERE_MAP_API_CODE='<?=CHINA_HERE_MAP_API_CODE;?>';
        var platform = new H.service.Platform({
            app_id  : CHINA_HERE_MAP_API_ID,
            app_code: CHINA_HERE_MAP_API_CODE,
            useHTTPS: true
        });
     
        var defaultLayers = platform.createDefaultLayers();
        map = new H.Map(document.getElementById('map'),
        defaultLayers.normal.map,{center: {lat:ulglat, lng:ulglng},
            zoom: 4,
            pixelRatio: window.devicePixelRatio || 1
        });
        
        map.getViewPort().setPadding(50, 50, 50, 50)
        window.addEventListener('resize', () => map.getViewPort().resize());
        var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
        switchMapLanguage(map , platform,defaultLayers);

        var waypts = [];
        if (points.length >= 2) {
            var routeRequestParams = {
                mode: 'fastest;car',
                representation: 'display',
                routeattributes : 'waypoints,summary,shape,legs',
                maneuverattributes: 'direction,action'
            };
            for (var i = 0; i < points.length; i++) {
                    var point = points[i].lat + "," + points[i].lng;
                    routeRequestParams["waypoint"+i] = point;
            }
            var router = platform.getRoutingService();
            router.calculateRoute(routeRequestParams,function(result) {
                var route,linestring;

                if(hasProperty(result.response, "route") && result.response.route) {
                    route = result.response.route[0];
                    linestring = new H.geo.LineString();
                      for (i = 0;  i < route.waypoint.length; i += 1) {
                          var v= waypointNamesArr[i];
                          
                            var svgMarkup ='<svg xmlns="http://www.w3.org/2000/svg"  fill="red" width="34" height="34" viewBox="0 0 24 24"><path d="M12 0c-5.522 0-10 4.395-10 9.815 0 5.505 4.375 9.268 10 14.185 5.625-4.917 10-8.68 10-14.185 0-5.42-4.478-9.815-10-9.815zm0 18c-4.419 0-8-3.582-8-8s3.581-8 8-8 8 3.582 8 8-3.581 8-8 8z"/><text x="13" y="16" font-size="12pt" ' +'font-family="Arial" font-weight="bold" text-anchor="middle" ' + 'fill="red">'+v+'</text></svg>';
                            var icon = new H.map.Icon(svgMarkup);
                        var marker =  new H.map.Marker({
                           
                            
                            lat: route.waypoint[i].mappedPosition.latitude,
                            lng: route.waypoint[i].mappedPosition.longitude},{icon:icon});
                        map.addObject(marker);
                      }
                    route.shape.forEach(function(point) {
                        var parts = point.split(',');
                        linestring.pushLatLngAlt(parts[0], parts[1]);
                    });
                    var routeLine = new H.map.Polyline(linestring, {
                        style: { strokeColor: '#669DF6', lineWidth: 5,strokeOpacity: 0.5  }
                    });
                    map.addObjects([routeLine]);
                    var distance = 0;
                    var duration = 0;
                    distance = result.response.route[0].summary.distance
                    duration = result.response.route[0].summary.trafficTime

                    $(".map_route_duration").html((duration / 3600).toFixed(0) + " Hr " + ((duration % 3600) / 60).toFixed(0) + " Mins " + ((duration % 3600) % 60).toFixed(0) + " Sec (" + duration + " Sec)");
                    $(".map_route_distance").html((distance / 1000).toFixed(2) + " Kilo Meters (" + distance + " Meters)");

                    map.setViewBounds(routeLine.getBounds());
                }else{
                    $(".map_route_distance").html("Route not found!");
                }
            }, function(error) {
                
                $(".map_route_distance").html("Route not found!");
            });
        }

    }

    initMap();
    

</script>
</body>

</html>