<div id="map" style="height: 250px;"></div>
<div class="box-footer map-footer">
    <table style="color: #222d32;font-weight: 1000;-webkit-text-stroke: .25px #ffffff;background: linear-gradient(to right,#fff,#ffffff05 100%);width: auto;">
        <tbody>
            <tr>
                <td class="map_route_distance"></td>
            </tr>
            <tr>
                <td class="map_route_duration"></td>
            </tr>
        </tbody>
    </table>
</div>
<?php
$cntrylatlng['ulat'] = 20.5937;
$cntrylatlng['ulng'] = 78.9629;
if ($this->session->userdata("user_id") !== false) {
    $lguid = $this->session->userdata("user_id");
    $cntrylatlng = getLogUserLatLng($lguid);
}
?>
<?php if (count($stops) > 0) {
    foreach ($stops as $s) {?>
<span class="shipstopopen" data-lat="<?php echo $s['plat']; ?>" data-lng="<?php echo $s['plng']; ?>" data-place="<?php echo $s['stopname']; ?>"></span>
<?php }}?>
<script type="text/javascript">
    var ulglat = <?php echo $cntrylatlng['ulat']; ?>;
    var ulglng = <?php echo $cntrylatlng['ulng']; ?>;
    var points = [];
    
    $(document).ready(function() {
        $(".shipstopopen").each(function() {
            points.push({
                "lat": $(this).data("lat"),
                "lng": $(this).data("lng"),
                "place": $(this).data("place")
            });
        });
    });

    function hasProperty(obj, key) {
        return obj.hasOwnProperty(key);
    }

    function initMap() {
        // Initialize the platform object:
        var platform = new H.service.Platform({
            apikey: apiKey
        });
        var defaultLayers = platform.createDefaultLayers();
        
        //Step 2: initialize a map - this map is centered over Europe
        var map = new H.Map(document.getElementById('map'),
            defaultLayers.vector.normal.map,{
            center: {lat:ulglat, lng:ulglng},
            zoom: 4,
            pixelRatio: window.devicePixelRatio || 1
        });
        map.getViewPort().setPadding(50, 50, 50, 50)
        // add a resize listener to make sure that the map occupies the whole container
        window.addEventListener('resize', () => map.getViewPort().resize());
        
        //Step 3: make the map interactive
        // MapEvents enables the event system
        // Behavior implements default interactions for pan/zoom (also on mobile touch environments)
        var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
        
        // Create the default UI components
        var ui = H.ui.UI.createDefault(map, defaultLayers);
        

        var waypts = [];
        if (points.length >= 2) {
            var routeRequestParams = {
                mode: 'fastest;car',
                representation: 'display',
                routeattributes : 'waypoints,summary,shape,legs',
                maneuverattributes: 'direction,action'
            };
            for (var i = 0; i < points.length; i++) {
                    var point = points[i].lat + "," + points[i].lng;
                    routeRequestParams["waypoint"+i] = point;
            }
            var router = platform.getRoutingService();
            router.calculateRoute(routeRequestParams,function(result) {
                var route,linestring;
                
                if(hasProperty(result.response, "route") && result.response.route) {
                    route = result.response.route[0];
                    linestring = new H.geo.LineString();
                      // Add a marker for each maneuver
                      for (i = 0;  i < route.waypoint.length; i += 1) {
                        var marker =  new H.map.Marker({
                            lat: route.waypoint[i].mappedPosition.latitude,
                            lng: route.waypoint[i].mappedPosition.longitude});
                        map.addObject(marker);
                      }
                    route.shape.forEach(function(point) {
                        var parts = point.split(',');
                        linestring.pushLatLngAlt(parts[0], parts[1]);
                    });
                    var routeLine = new H.map.Polyline(linestring, {
                        style: { strokeColor: '#669DF6', lineWidth: 5,strokeOpacity: 0.5  }
                    });
                    map.addObjects([routeLine]);
                    // distance and duration calculated from here
                    var distance = 0;
                    var duration = 0;
                    // $.each(result.response.route[0].leg, function(index, value) {
                    //     distance += value.distance.value;
                    //     duration += value.duration.value;
                    // });
                    distance = result.response.route[0].summary.distance
                    duration = result.response.route[0].summary.trafficTime

                    $(".map_route_duration").html((duration / 3600).toFixed(0) + " Hr " + ((duration % 3600) / 60).toFixed(0) + " Mins " + ((duration % 3600) % 60).toFixed(0) + " Sec (" + duration + " Sec)");
                    $(".map_route_distance").html((distance / 1000).toFixed(2) + " Kilo Meters (" + distance + " Meters)");
                    map.getViewModel().setLookAtData({
                        bounds: routeLine.getBoundingBox()
                    });
                }else{
                    $(".map_route_distance").html("Route not found!");
                }
            }, function(error) {
                console.log(error.message);
                $(".map_route_distance").html("Route not found!");
            });
        }

    }
//# sourceURL=mapview_eu.js
    initMap();
</script>
</body>

</html>