<section class="content-header">
	<h1>
	<?php echo $page_title?>
	<small><?php echo $sub_title?></small>
	</h1>
	<ol class="breadcrumb">
		<li><a href="#"><i class="fa fa-home"></i> Home</a></li>
		<li><a href="#"><?php echo $page_title?></a></li>
		<li class="active"><?php echo $sub_title?></li>
	</ol>
</section>
<!-- Main content -->
<section class="content" style="display: none">
	<!-- Default box -->
	<div class="box planscreen">
		<form action="" method="POST">
			<div class="box-body">
				<div class="row">
					<div class="col-md-7" style="padding-right: 2px;">
						<ul class="nav nav-tabs" id="myTab" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="total-orders-tab" data-toggle="tab" href="#total-orders" role="tab" aria-controls="total-orders" aria-selected="true">Total Orders</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="customer-orders-tab" data-toggle="tab" href="#customer-orders" role="tab" aria-controls="customer-orders" aria-selected="true">By Customer Orders</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-orders-tab" data-toggle="tab" href="#range-orders" role="tab" aria-controls="range-orders" aria-selected="false">By Range Orders</a>
						    </li>
						</ul>
						<div class="tab-content" id="orders_tab" style="height: 270px;overflow-y: auto;">
					    	<table class="table head-table controls_table" style="margin-bottom:0px">
					    		<tbody>
									<tr>
										<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
											<i class="fa fa-edit" onclick="editorder(this)"></i>
											<i class="fa fa-trash"></i>
										</th>
										<td align="right"><b style="color: #112e53;text-decoration: underline;">ORDERS</b></td>
									</tr>
								</tbody>
							</table>
							<table class="table table-striped table-bordered table-hover order-clickable-table data_table" id="table-draggable1">
								<thead>
									<tr>
			                            <th></th>
			                            <th onclick="sortTable(this,1)">Order ID <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,2)">Source <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,3)">Destination <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,4)">Pickup Time <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,5)">Weight <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,6)">Volume <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,7)">Quantity <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,8)">Mode <i class="fa fa-fw fa-sort"></i></th>
			                        </tr>
			                    </thead>
		                        <tbody class="connectedSortable " id="connectedSortable">
		                    	</tbody>
							</table>
					    </div>
						
					</div>	
					<div class="col-md-5 shipmnet_plan_map" style="border: 2px solid #dcdcdc; border-radius: 10px; padding-left: 5px; padding-right: 5px;">
						<div class="box-header" style="background-color: #f9f9f9;padding: 4px;">
						    <h3 class="box-title" style="font-size: 14px;font-weight: bold;">Shipment Route</h3>
						</div>
						<span id="main" style="text-align: center;position: absolute;top: 50%;left: 50%;z-index: 1000;font-size: 34px;color: #112e53;font-weight: 600;" class=""></span>
						<div class="box-body" id="map_route" style="padding: 2px;">	
                        </div>
					</div>
			    </div>
			    <div class="row">
					<div class="col-md-12">
						<ul class="nav nav-tabs active" id="myTab1" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="total-shipments-tab" data-toggle="tab" href="#total-shipments" role="tab" aria-controls="total-shipments" aria-selected="false">Total Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="customer-shipments-tab" data-toggle="tab" href="#customer-shipments" role="tab" aria-controls="customer-shipments" aria-selected="true">By Customer Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-shipments-tab" data-toggle="tab" href="#range-shipments" role="tab" aria-controls="range-shipments" aria-selected="false">By Range Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-total-shipments-tab" data-toggle="tab" href="#intransit-total-shipments" role="tab" aria-controls="intransit-total-shipments" aria-selected="false">Total In-Transit Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-customer-shipments-tab" data-toggle="tab" href="#intransit-customer-shipments" role="tab" aria-controls="intransit-customer-shipments" aria-selected="true">By Customer In-Transit Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-range-shipments-tab" data-toggle="tab" href="#intransit-range-shipments" role="tab" aria-controls="intransit-range-shipments" aria-selected="false">By Range In-Transit Shipments</a>
						    </li>
						</ul>
						<div class="tab-content" id="new_tab" style="height: 270px;overflow-y: auto;">
							<table class="table head-table controls_table" style="margin-bottom:0px">
								<tr>
									<th colspan="11">
										<i class="fa fa-plus-square" onclick="return addshipment();"></i>
										<i class="fa fa-edit" onclick="return editShipment(this);"></i>
										<i class="fa fa-trash"></i>
									</th>
								</tr>
							</table>
							<table class="table table-striped table-bordered table-hover clickable-table data_table" id="shipmentstable">
								<thead>
									<tr>
										<th></th>
			                            <th onclick="sortTable(this,1)">Shipment ID <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,2)">Start Date <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,3)">End Date <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,4)">Source <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,5)">Destination <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,6)">Vehicle Type <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,7)">Mode <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,8)">Weight <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,9)">Volume <i class="fa fa-fw fa-sort"></i></th>
			                            <th onclick="sortTable(this,10)">Units <i class="fa fa-fw fa-sort"></i></th>
			                        </tr>
		                        </thead>
		                        <tbody class="connectedSortable">
		                    	</tbody>
							</table>
						</div>
					</div>
			    </div>
			</div>
		</form>
		<!-- /.box-body -->
	</div>
</section>
<div class="filters" style="display: none">
	<select class="cust_filter">
		<?php
		foreach($customers->result() as $row){
			echo "<option value='".$row->id."'>".$row->name."</option>";
		}
		?>
	</select>
	<select class="range_filter">
	    <option value="1">1</option>
	    <option value="2">2</option>
	    <option value="5">5</option>
	    <option value="10">10</option>
	    <option value="20">20</option>
	    <option value="50">50</option>
	    <option value="100">100</option>
	    <option value="200">200</option>
	    <option value="500">500</option>
	</select>
</div>
<div class="modal containerModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-weight: bold;">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Modal body text goes here.</p>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/jstree/jstree.min.css');?>">
<script type="text/javascript" src="<?php echo base_url('assets/jstree/jstree.min.js');?>"></script>
<script type="text/javascript">
	var cust_filter;
	var range_filter;
	var shipments_table;
	$(document).ready(function(){
	    
		/*$("body").addClass("sidebar-collapse");*/
		$(".content").show();
		//shipments_table = $(".clickable-table").DataTable();
	  	cust_filter = $(".filters").find(".cust_filter");
	  	range_filter = $(".filters").find(".range_filter");
		$("#total-orders-tab").click(function(){
			var head = $("#orders_tab").find(".controls_table th");
			var data_table = $("#orders_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			populateOrders(data_table,{});
		});
		$("#customer-orders-tab").click(function(){
			var head = $("#orders_tab").find(".controls_table th");
			var data_table = $("#orders_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(cust_filter.clone());
			head.find(".cust_filter").on("change",function(){
				populateOrders(data_table,{customer_id:$(this).val()});
			});
			head.find(".cust_filter").trigger("change");
		});
		$("#range-orders-tab").click(function(){
			var head = $("#orders_tab").find(".controls_table th");
			var data_table = $("#orders_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(range_filter.clone());
			head.find(".range_filter").on("change",function(){
				var shipment_id = getSelectedShipmentId();
				populateOrders(data_table,{range:$(this).val(),shipment_id:shipment_id});
			});
			head.find(".range_filter").trigger("change");
		});
		$("#total-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			head.find(".cust_filter,.range_filter").remove();
			var data_table = $("#new_tab").find(".data_table tbody");
			populateShipments(data_table,{});
		});
		$("#customer-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			var data_table = $("#new_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(cust_filter.clone());
			head.find(".cust_filter").on("change",function(){
				populateShipments(data_table,{customer_id:$(this).val()});
			});
			head.find(".cust_filter").trigger("change");
		});
		$("#range-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			var data_table = $("#new_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(range_filter.clone());
			head.find(".range_filter").on("change",function(){
				var order_id = getSelectedOrderId();
				populateShipments(data_table,{range:$(this).val(),order_id:order_id});
			});
			head.find(".range_filter").trigger("change");
		});
		$("#intransit-total-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			var data_table = $("#new_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			populateIntransitShipments(data_table,{});
		});
		$("#intransit-customer-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			var data_table = $("#new_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(cust_filter.clone());
			head.find(".cust_filter").on("change",function(){
				populateIntransitShipments(data_table,{customer_id:$(this).val()});
			});
			head.find(".cust_filter").trigger("change");
		});
		$("#intransit-range-shipments-tab").click(function(){
			var head = $("#new_tab").find(".controls_table th");
			var data_table = $("#new_tab").find(".data_table tbody");
			head.find(".cust_filter,.range_filter").remove();
			head.append(range_filter.clone());
			head.find(".range_filter").on("change",function(){
				var order_id = getSelectedOrderId();
				populateIntransitShipments(data_table,{range:$(this).val(),order_id:order_id});
			});
			head.find(".range_filter").trigger("change");
		});
	  	$("#total-orders-tab").trigger("click");
		$("#total-shipments-tab").trigger("click");
	});
	function getSelectedShipmentId() {
		var shipmentid = "";
		$("#new_tab").find(".data_table tbody tr.custom--success").each(function(){
			shipmentid =  $(this).data("shipmentid");
		});
		return shipmentid;
	}
	function getSelectedOrderId() {
		var orderid = "";
		$("#orders_tab").find(".data_table tbody tr.custom--success").each(function(){
			orderid =  $(this).data("orderid");
		});
		return orderid;
	}
	function populateOrders(data_table,data) {
		$.ajax({
			url:"<?php echo base_url('shipmentplan/filterOrders');?>",
			type:"POST",
			data:data,
			dataType:"JSON",
			beforeSend:function(){
				data_table.html("<tr><td colspan='8'><center><progress></center></td></tr>");
			},
			success:function(data){
				data_table.html("");
				$.each(data,function(index,or){
					data_table.append("<tr data-orderid='"+or['id']+"' class='order_row'>"+
						'<td onclick="return getorderdetail(this,\''+or['id']+'\');" style="color:#002b55;cursor: pointer;"><i class="fa fa-plus-square"></i></td>'+
	                    "<td>"+or['order_id']+"</td>"+
	                    "<td>"+or['pickup_city']+"</td>"+
	                    "<td>"+or['delivery_city']+"</td>"+
	                    "<td>"+or['pickup_datetime']+"</td>"+
	                    "<td>"+or['weight'] +"KGS</td>"+
	                    "<td>"+or['volume'] +"CUFT</td>"+
	                    "<td>"+or['quantity']+"</td>"+
	                    "<td>"+or['transport_mode']+"</td>"+
	                    "</tr>")
				});
			},
			complete:function(){
				onCreateRows();
			}
		});
	}
	function populateShipments(data_table,data) {
		$.ajax({
			url:"<?php echo base_url('shipmentplan/filterShipments');?>",
			type:"POST",
			data:data,
			dataType:"JSON",
			beforeSend:function(){
				data_table.html("<tr><td colspan='8'><center><progress></center></td></tr>");
			},
			success:function(data){
				data_table.html("");
				$.each(data,function(index,sh){
					data_table.append('<tr id="'+sh['id']+'_shipments" class="table-draggable2 shipment_row" data-shipmentid="'+sh['id']+'">'+
                        '<td onclick="return getshipmentdetail(this,\''+sh['id']+'\');" style="color:#002b55;cursor: pointer;"><i class="fa fa-plus-square"></i></td>'+
                        '<td onclick="return getshipmentroute(\''+sh['id']+'\');" style="color:#002b55;cursor: pointer;">'+sh['shipmentid']+'</td>'+
                        '<td>'+sh['startdate']+'</td>'+
                        '<td>'+sh['enddate']+'</td>'+
                        '<td>'+sh['splace']+'</td>'+
                        '<td>'+sh['eplace']+'</td>'+
                        '<td>'+sh['vehicle_type']+'</td>'+
                        '<td>'+sh['transport_mode']+'</td>'+
                        '<td>'+sh['weight']+' KGS</td>'+
                        '<td>'+sh['volume']+' CUFT</td>'+
                        '<td>'+sh['units']+'</td>'+
                	'</tr>');
				});
			},
			complete:function(){
				onCreateRows();
			}
		});
	}
	function populateIntransitShipments(data_table,data) {
		$.ajax({
			url:"<?php echo base_url('shipmentplan/filterIntransitShipments');?>",
			type:"POST",
			data:data,
			dataType:"JSON",
			beforeSend:function(){
				data_table.html("<tr><td colspan='8'><center><progress></center></td></tr>");
			},
			success:function(data){
				data_table.html("");
				$.each(data,function(index,sh){
					if(sh['capacity'] >= 100){ sh['capacity'] = 100; }
					data_table.append('<tr id="'+sh['id']+'_shipments" class="table-draggable2 shipment_row" data-shipmentid="'+sh['id']+'">'+
                        '<td onclick="return getshipmentdetail(this,\''+sh['id']+'\');" style="color:#002b55;cursor: pointer;"><i class="fa fa-plus-square"></i></td>'+
                        '<td onclick="return getshipmentroute(\''+sh['id']+'\');" style="color:#002b55;cursor: pointer;">'+sh['shipmentid']+'</td>'+
                        '<td>'+sh['startdate']+'</td>'+
                        '<td>'+sh['enddate']+'</td>'+
                        '<td>'+sh['splace']+'</td>'+
                        '<td>'+sh['eplace']+'</td>'+
                        '<td>'+sh['transport_mode']+' ('+sh['capacity']+'%)<progress value="'+sh['capacity']+'" max="100" style="height: 0.8rem;"></progress></td>'+
                        '<td>'+sh['transport_mode']+'</td>'+
                        '<td>'+sh['weight']+' KGS</td>'+
                        '<td>'+sh['volume']+' CUFT</td>'+
                        '<td>'+sh['units']+'</td>'+
                	'</tr>');
				});
			},
			complete:function(){
				onCreateRows();
			}
		});
	}
	function onCreateRows() {
		$('.order-clickable-table > tbody >tr, .order-range-clickable-table > tbody >tr, .clickable-table > tbody >tr').on('click', function (ele) {
		    $('.custom--success').removeClass('custom--success');
		    $(this).addClass('custom--success');
		});
		var $tabs = $('.table-draggable2')
	  	$("tbody#connectedSortable").sortable({
			connectWith: ".connectedSortable",
			appendTo: $tabs,
			helper: "clone",
			zIndex: 999990
	    });
	    /*.disableSelection();*/
	  	$($tabs).droppable({
		    accept: ".connectedSortable tr",
		    hoverClass: "hovered",
		    drop: function(event, ui) {
	 			var sid = $(this).data('shipmentid');
	 			var ordid = ui.draggable.data('orderid');
	 			$.ajax({
					 method: "POST",
					 url: baseurl+"shipmentplan/orderintoshipment",
					 data:{'ship_id': sid,'ordid': ordid}, 
				}).done(function( data ) {
					if(data=="1" || data=="0"){
						 var result = $.parseJSON(data);
						 console.log(result);
						 ui.draggable.html("");
					}else if(data == ""){
						$(".containerModal").modal("show");
		                $(".containerModal").find(".modal-title").html("Assign lines to Shipment");
		                $(".containerModal").find(".modal-body").html("<center>Some problem occured!</center>");
		                event.stopPropagation();
					}else{
						$(".containerModal").modal("show");
		                $(".containerModal").find(".modal-title").html("Assign lines to Shipment");
		                $(".containerModal").find(".modal-body").html(data);
					}
				});
		      	return false;
		    }
	  	});
	}
	function editShipment(ele) {
		var table = $(ele).closest("table").next(".clickable-table");
		if(table.find(".custom--success").length>0){
			var shipment_id = table.find(".custom--success").data("shipmentid");

			$.ajax({
	            url:"<?=base_url('shipmentplan/editShipment')?>",
	            data:{"shipment_id":shipment_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Shipment::"+shipment_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}
	function editorder(ele){
		var table = $(ele).closest("table").next(".order-clickable-table");
		if(table.find(".custom--success").length>0){
			var order_id = table.find(".custom--success").data("orderid");
			$.ajax({
	            url:"<?=base_url('shipmentplan/createorder')?>",
	            data:{"order_id":order_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Order::"+order_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}
	function getshipmentroute(sid){
		$.ajax({
			url:baseurl+"shipmentplan/maproute",
			type:"POST",
			data:{"shipment_id":sid},
			beforeSend:function(){
				$('#main').addClass('fa fa-refresh fa-spin');
			},
			success:function(data){
				$('#bar').val(100); 
				$('#main').removeClass("fa fa-refresh fa-spin");
				$('#map_route').html(data);
				$("#orders_tab").css("max-height",250);
	            $("#new_tab").css("max-height",250);
			}
		});
	}
	function getshipmentdetail(ele,sid) {
		if($(ele).find(".fa").hasClass("fa-plus-square")){
			$.ajax({
				url:baseurl+"shipmentplan/stopdetail",
				type:"POST",
				data:{"shipment_id":sid},
				beforeSend:function(){
					$(".shipment_row").each(function(){
						$(this).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
					});
					$(ele).find(".fa-plus-square").removeClass("fa-plus-square").addClass("fa-minus-square");
					$(".stop_row,.detail_row").each(function(){
						$(this).remove();
						$(this).remove();
					});
					$('#main').addClass('fa fa-refresh fa-spin');
				},
				success:function(data){
					$(ele).closest("tr").after(data);
				}
			});
		}else{
			$(ele).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
			$(".stop_row,.detail_row").each(function(){
				$(this).remove();
				$(this).remove();
			});
		}
		
	}
	function getorderdetail(ele,sid) {
		if($(ele).find(".fa").hasClass("fa-plus-square")){
			$.ajax({
				url:baseurl+"shipmentplan/getorderdetail",
				type:"POST",
				data:{"order_id":sid},
				beforeSend:function(){
					$(".order_row").each(function(){
						$(this).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
					});
					$(ele).find(".fa-plus-square").removeClass("fa-plus-square").addClass("fa-minus-square");
					$(".order_data_row").each(function(){
						$(this).remove();
					});
					$('#main').addClass('fa fa-refresh fa-spin');
				},
				success:function(data){
					$(ele).closest("tr").after(data);
				}
			});
		}else{
			$(ele).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
			$(".order_data_row").each(function(){
				$(this).remove();
			});
		}
		
	}

	function addshipment(){
		$.ajax({
            url:"<?=base_url('shipmentplan/addshipment')?>",
            data:{},
            type:"POST",
            beforeSend:function(){
            	$(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("New Shipment");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
            	$(".buffer").hide();
            	$(".containerModal").find(".modal-body").html(data);
            }
        });
	}
	getshipmentroute();
	function sortTable(ele,n) {
		$(".shipment_row").each(function(){
			$(this).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
		});
		$(".stop_row,.detail_row").each(function(){
			$(this).remove();
			$(this).remove();
		});
	  var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
	  table = document.getElementById($(ele).closest("table").attr("id"));
	  switching = true;
	  // Set the sorting direction to ascending:
	  dir = "asc"; 
	  /* Make a loop that will continue until
	  no switching has been done: */
	  while (switching) {
	    // Start by saying: no switching is done:
	    switching = false;
	    rows = table.rows;
	    /* Loop through all table rows (except the
	    first, which contains table headers): */
	    for (i = 1; i < (rows.length - 1); i++) {
	      // Start by saying there should be no switching:
	      shouldSwitch = false;
	      /* Get the two elements you want to compare,
	      one from current row and one from the next: */
	      x = rows[i].getElementsByTagName("TD")[n];
	      y = rows[i + 1].getElementsByTagName("TD")[n];
	      /* Check if the two rows should switch place,
	      based on the direction, asc or desc: */
	      if (dir == "asc") {
	        if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
	          // If so, mark as a switch and break the loop:
	          shouldSwitch = true;
	          break;
	        }
	      } else if (dir == "desc") {
	        if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
	          // If so, mark as a switch and break the loop:
	          shouldSwitch = true;
	          break;
	        }
	      }
	    }
	    if (shouldSwitch) {
	      /* If a switch has been marked, make the switch
	      and mark that a switch has been done: */
	      rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
	      switching = true;
	      // Each time a switch is done, increase this count by 1:
	      switchcount ++; 
	    } else {
	      /* If no switching has been done AND the direction is "asc",
	      set the direction to "desc" and run the while loop again. */
	      if (switchcount == 0 && dir == "asc") {
	        dir = "desc";
	        switching = true;
	      }
	    }
	  }
	}
</script>
<style type="text/css">
	.planscreen{
		font-size: 10px;
	}
	.planscreen table tr th{
		font-weight: bold;
	}
	.planscreen table tr th i{
		padding: 2px;
	}
	.table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
		padding: 2px !important;
	}
	/*.loader {
	  	border: 2px solid #f3f3f3;
	    border-radius: 50%;
	    border-top: 2px solid blue;
	    border-right: 2px solid green;
	    border-bottom: 2px solid red;
	    border-left: 2px solid pink;
	    width: 40px;
	    height: 40px;
	  	-webkit-animation: spin 2s linear infinite;
	  	animation: spin 2s linear infinite;
	}
	@-webkit-keyframes spin {
	  0% { -webkit-transform: rotate(0deg); }
	  100% { -webkit-transform: rotate(360deg); }
	}
	@keyframes spin {
	  0% { transform: rotate(0deg); }
	  100% { transform: rotate(360deg); }
	}*/
	#connectedSortable tr{
		cursor: move;
	}
	#shipmentstable th,#table-draggable1 th{
		cursor: pointer;
	}
.nav-tabs>li.active>a, .nav-tabs>li.active>a:hover, .nav-tabs>li.active>a:focus {
    color: #053754;
    background-color: #fff;
    border: 1px solid #ddd;
    border-bottom-color: transparent;
    cursor: default;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
}
.nav-tabs>li>a {
    margin-right: 2px;
    line-height: 1.42857143;
    border: 1px solid transparent;
    border-radius: 4px 4px 0 0;
    padding: 4px 8px;
    color: #617079;
	border-color: #eee #eee #ddd;
	background: #f7f7f7;
}
.nav-tabs>li>a::after{
    -webkit-transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    -webkit-transform-origin: 0 0;
}
.map-footer{
	position: absolute;
	bottom: 0;
}
.shipment_row:nth-child(odd) > td{
	background-color: #f5f5f5;
}
.small_txt{
	font-size: 8px;
}
.stop_row:hover>td,.detail_row:hover>td{
	background: #fff !important;
}
tr.custom--success td,tr.custom--success:hover > td,tr.hovered td,tr.hovered:hover > td {
  background: #b5b5b5 !important; /*custom color here add !important if you don't want the hover color*/
}
.head-table .fa{
	cursor: pointer;
}
.nav-item a{
	font-weight: bold;
	text-transform: uppercase;
}
.fa{
	color: #122e58;
}
</style>