<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/select2/select2.min.css">
<script src="<?php echo base_url();?>assets/plugins/select2/select2.min.js"></script>
<script src="<?php echo base_url();?>assets/newtheme/js/bootstable.js"></script>

<!-- Include Required Prerequisites -->
<script type="text/javascript" src="<?php echo base_url();?>assets/js/moment.min.js"></script>
<!-- Include Date Range Picker -->
<script type="text/javascript" src="<?php echo base_url();?>assets/plugins/daterangepicker/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/plugins/daterangepicker/daterangepicker.css" />

<!-- DataTables -->
<script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/newtheme/plugins/datatables/jquery.dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/newtheme/plugins/datatables/jquery.dataTables.min.css">
<script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/dataTables.buttons.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/newtheme/plugins/datatables/buttons.dataTables.min.css">
<script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/vfs_fonts.js"></script>
<script src="<?php echo base_url();?>assets/plugins/chartjs/Chart.bundle.js"></script>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        <?= $this->lang->line('menu_speedometergraph'); ?>
        <small><?= $this->lang->line('general_view'); ?></small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="./"><i class="fa fa-home"></i> <?= $this->lang->line('general_home'); ?></a></li>
        <li><a href="#">Speedometer</a></li>
        <li class="active">index</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><?= $this->lang->line('menu_speedometergraph'); ?></h3>
        </div>
        <div class="box-body">
            <div class="row">
                <form onsubmit="return submitForm();" id="form" autocomplete="off">
                    <div class="col-xs-3">
					<div class="form-group">
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-truck"></i></div>
							<select class="form-control" data-placeholder="Select carrier" name="carrier">
								<option value="-1"> <?= $this->lang->line('all_carriers'); ?></option>
								<?php
			                    foreach($carriers->result() as $s){
			                      echo "<option value='".$s->id."'>".$s->name."</option>";
			                    }
			                    ?>
							</select>
						</div>
					</div>
				</div>
				<div class="col-xs-3">
					<div class="form-group">
						<div class="input-group">
							<div class="input-group-addon">
									<i class="fa fa-truck"></i>
								</div>
							<select class="form-control" data-placeholder="Select driver" name="driver" required>
								<?php
                        foreach($drivers->result() as $s){
                          echo "<option value='".$s->imei."'>".$s->name." - ".$s->register_number."</option>";
                        }
                        ?>
							</select>
						</div>
					</div>
				</div>
                <div class="col-xs-4">
					<div class="form-group">
						<div class="input-group">
							<div class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</div>
							<input type="text" class="form-control pull-right" id="reservation" name="daterangepicker" required>
						</div>
						<!-- /.input group -->
					</div>
				</div>
				<div class="col-xs-2">
					<button type="submit" class="btn btn-primary"><?= $this->lang->line('general_submit'); ?></button>
				</div>
                </form>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="play_ground">
                        <canvas id="canvas"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="overlay" style="display: none">
            <i class="fa fa-refresh fa-spin"></i>
        </div>
    </div>
</section>

<script type="text/javascript">
    var base_url = "<?=base_url()?>";
    $(document).ready(function(){
	var drivers = <?=json_encode($drivers->result_array())?>;
    $("select[name='carrier']").on("change", function(e) {
        var id = $(this).val();
        $("select[name='driver']").empty();
        for (var i = 0; i < drivers.length; i++) {
            if (drivers[i].carrier_id == id || id == -1) {
                $("select[name='driver']").append("<option value='" + drivers[i].id + "_"+drivers[i].register_number+"'>" + drivers[i].name + "- "+drivers[i].register_number+"</option>");
            }
        }
    });
	$('#reservation').daterangepicker({
		timePicker: true,
		timePickerIncrement: 5,
		locale: {
			format: 'MM/DD/YYYY h:mm A'
		}
	});
	var ctx = document.getElementById('canvas').getContext('2d');
    window.myLine = new Chart(ctx, config);
});


function submitForm() {
    if ($(".select2").val() != "-1") {
        $.ajax({
            url: "<?=base_url('etmreport/getSpeedData')?>",
            data: $("#form").serializeArray(),
            type: "POST",
            dataType: "JSON",
            beforeSend: function() {
                $(".overlay").show();
            },
            success: function(data) {
                $(".overlay").hide();
                config.data={
                    labels: data.avgtime,
                    datasets: [{
                        label: data.mobileimei,
                        backgroundColor: "#A7D058",
                        borderColor: "#A7D058",
                        data: data.max_speed,
                        fill: false,
                        locations:data.latitude,
                        receivedon:data.timestamp

                    }]
                };
                window.myLine.update();
            }
        })
    }
    return false;
}
var config = {
    type: 'line',
    data: [],
    options: {
        responsive: true,
        title: {
            display: true,
            text: 'Speedometer Graph'
        },
        tooltips: {
            callbacks: {
                title:function(tooltipItem, data) {
                    return data.datasets.label;
                },
                beforeBody:function(tooltipItem, data) {
                    return "Time : "+data.datasets[0].receivedon[tooltipItem[0].index];
                },
                beforeLabel:function(tooltipItem, data) {
                    return "Location : "+data.datasets[0].locations[tooltipItem.index];
                },
                label: function(tooltipItem, data) {
                    return "Speed : "+data.datasets[0].data[tooltipItem.index]+" KMPH";
                }
            },
            titleFontSize: 16,
            bodyFontSize: 14,
            displayColors: false
        },
        hover: {
            mode: 'nearest',
            intersect: true
        },
        scales: {
            xAxes: [{
                display: true,
                scaleLabel: {
                    display: true,
                    labelString: 'Hours/Minutes'
                },
                ticks: {
                    min :0
                }
            }],
            yAxes: [{
                display: true,
                scaleLabel: {
                    display: true,
                    labelString: 'Speed'
                },
                ticks: {
                    min :0
                }
            }]
        }
    }
};
</script>
<style type="text/css">
    .logo {
        height: 50px;
    }

    .select2-container--default .select2-selection--single .select2-selection__choice {
        background-color: #a7d058 !important;
    }

    .select2-container--default .select2-selection--single {
        border: solid #d2d6de 1px;
        outline: 0;
        border-radius: 0px;
        min-height: 34px;
    }

    .select2-container--default.select2-container--focus .select2-selection--single {
        border: solid #a7d058 1px;
        outline: 0;
        border-radius: 0px;
        min-height: 34px;
    }

    .btn-success {
        background-color: #a7d058;
        border-color: #88af3f;
        border-radius: 0px;
        /*width: 100%;*/
    }

    .btn-success:focus,
    .btn-success:active,
    .btn-success:active:hover,
    .btn-success:hover {
        color: #fff;
        background-color: #88af3f;
        border-color: #56731d;
    }

    .select2-container--default .select2-selection--single .select2-selection__choice {
        background-color: #e4e4e4;
        border: 1px solid #aaa;
        border-radius: 0px;
        cursor: default;
        float: left;
        margin-right: 5px;
        margin-top: 5px;
        padding: 0 5px;
    }

    .form-group {
        margin-bottom: 5px;
    }

    .show_less,
    .show_more {
        width: 100%;
        text-align: center;
        cursor: pointer;
    }
</style>
