<?php
$displayDeliveryNote = checkAccessConditions('DISPLAY_DQ_IN_BY_MILESTONE',$this->session->userdata('company_code'));
if (!empty($stopDetails)): ?>
    <table width="100%" class="table table-striped stopstable<?= $shiftId?>" style="margin-bottom: 0px;">
        <thead>
        <tr>
            <th><?= $this->lang->line('general_actions') ?></th>
            <th><?= $this->lang->line('sno') ?></th>
            <th><?= $this->lang->line('order_id') ?></th>
            <?php if ($displayDeliveryNote) : ?>
            <th><?= $this->lang->line('qbook_deliverynote') ?></th>
            <?php endif; ?>
            <?php
            if ($companyCode == 'AUKN' || $companyCode == 'UKKN'):
                echo "<th>" . $this->lang->line('container_num') . "</th>";
            endif; ?>
            <th><?= $this->lang->line('general_location') ?></th>
            <th><?= $this->lang->line('general_address') ?></th>
            <th><?= $this->lang->line('general_type') ?></th>
            <th><?= $this->lang->line('start_dt') ?></th>
            <th><?= $this->lang->line('end_dt') ?></th>
            <th><?= $this->lang->line('general_weight') ?></th>
            <th><?= $this->lang->line('general_volume') ?></th>
            <th><?= $this->lang->line('general_status') ?></th>
            <th><?= $this->lang->line('total_units') ?></th>
            <th><?= $this->lang->line('updated_units') ?></th>
        </tr>
        </thead>
        <?php
        $stops = $stopDetails['stops'] ?? [];
        foreach ($stops as $index => $stop):
            echo "<tr>";
            if ($stop["act_ship_units"] != $stop["ship_units"] && strlen($stop["ship_units"]) > 0):
                $ship_units_class = "tr-red";
            endif;
            echo '<tr class="pointer ' . $ship_units_class . ' stop' . $stop["id"] . "_" . $shiftId . '" onclick="openPickupandDrops(this,\'' . $stop["id"] . '\',\'' . $shiftId . '\')">'; ?>
            <td>
                <div class="btn btn-xs btn-default" title="History" onclick="openHistory('<?= $shiftId ?>','<?= $stop["id"] ?>','')">Status History</div>
            </td>
            <td><?= ($index + 1) ?></td>
            <?php
            if ($stop['id'] > 0) :
                $oids = @getOrderIds($stop["id"]);
                echo "<td title='" . $oids . "' class='unwrap'>" . $oids . "</td>";
            else:
                echo "<td></td>";
            endif;
            if ($companyCode == 'AUKN' || $companyCode == 'UKKN'):
                echo "<td>" . ($stop['container_no']) . "</td>";
            endif;
            ?>
            <?php
            if ($displayDeliveryNote) :
                if ($stop['id'] > 0) :
                    $deliveryNote = @getDeliveryNotes($stop["id"]);
                    echo "<td title='" . $deliveryNote . "' class='unwrap'>" . $deliveryNote . "</td>";
                else:
                    echo "<td></td>";
                endif;
            endif;
            ?>
            <td><?= (substr($stop["stopname"], 0, 10)) ?></td>
            <td><?= (substr($stop["address"], 0, 10)) ?></td>
            <td><?= $stop["stoptype"] ?></td>
            <td><?= (date("d M, h:i A", strtotime($stop["startdate"]))) ?></td>
            <td><?= (date("d M, h:i A", strtotime($stop["enddate"]))) ?></td>
            <td><?= uom_string($stop["weight"], 'kg') ?></td>
            <td><?= uom_string($stop["volume"], 'cbm') ?></td>
            <?php
            $status = "";
            if ($stop["stopstatus"] == 0): $status = 'New';
            elseif ($stop["stopstatus"] == 1): $status = 'In-Transit';
            else:
                if ($stop["stoptype"] == "D"): $status = 'Delivered';
                else: $status = "Picked up";
                endif;
            endif; ?>
            <td> <?= $status ?></td>;
            <td><?= $stop["act_ship_units"] ?></td>;
            <td><?= $stop["ship_units"] ?></td>;
            <?php
            echo "</tr><tr class='excluded'></tr>"; endforeach; ?>
    </table>
<?php
endif;
?>
