<?php
$checkOrdersPickup = $drop_count = 0;
$stops_array = $result[0]['records'] ?? [];
$shipmentData = $result[0]["shipment_data"] ?? [];
foreach ($stops_array as $i => $eachstop) {
    if ($eachstop['stoptype'] == 'D') {
        $drop_count++;
    }
}
if ($drop_count == 1) {
    $stops_array = $this->CustomerOrder->sortAssociativeArrayByKey($stops_array, "stoptype", "DESC");
}
?>
<div id="map_wrapper_<?= $result[0]['order_id'] ?>">
    <?php
    if (isset($stops_array)) {
        foreach ($stops_array as $i => $eachlocation) {
            if ($drop_count == 1) {
                if ($result[0]['plat'] == $eachlocation['plat'] && $result[0]['plng'] == $eachlocation['plng'] && $eachlocation['stoptype'] == 'P') {
                    $checkOrdersPickup = 1;
                }
                if ($checkOrdersPickup > 0) {
    ?>
                    <span class="shipstoploc" data-tmode="<?php echo $eachlocation['transport_mode']; ?>" data-lat="<?php echo $eachlocation['plat']; ?>" data-lng="<?php echo $eachlocation['plng']; ?>"></span>
                <?php if ($result[0]['dlat'] == $eachlocation['plat'] && $result[0]['dlng'] == $eachlocation['plng']) {
                        break;
                    }
                }
            } else { ?>
                <span class="shipstoploc" data-tmode="<?php echo $eachlocation['transport_mode']; ?>" data-lat="<?php echo $eachlocation['plat']; ?>" data-lng="<?php echo $eachlocation['plng']; ?>"></span>
    <?php if ($result[0]['dlat'] == $eachlocation['plat'] && $result[0]['dlng'] == $eachlocation['plng']) {
                    break;
                }
            }
        }
    }

    ?>
</div>
<div class="clearfix">
    <div class="row sub-header ng-star-inserted">
        <div class="col-12 col-md-6 col-lg-4 col-xl-3">
            <div class="track-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="33.833" height="30.5" viewBox="0 0 33.833 30.5">
                    <g id="noun_tracking_3481004" transform="translate(-15.75 -39.75)">
                        <path id="Path_168" data-name="Path 168" d="M80,151.222a.556.556,0,0,0,.556.556h6.667a.556.556,0,0,0,.556-.556v-6.667a.556.556,0,0,0-.556-.556H80.556a.556.556,0,0,0-.556.556Zm1.111-.556v-3.333h1.111V149a.556.556,0,0,0,.948.393l.718-.718.718.718a.556.556,0,0,0,.948-.393v-1.667h1.111v3.333Zm2.222-5.556h1.111v2.548l-.163-.163a.556.556,0,0,0-.786,0l-.163.163Zm3.333,1.111H85.556v-1.111h1.111Zm-4.444-1.111v1.111H81.111v-1.111Z" transform="translate(-59.556 -96.778)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_169" data-name="Path 169" d="M240,114.552a1.667,1.667,0,1,0,2.222-1.571v-1.3a1.667,1.667,0,0,0,0-3.142v-1.3a1.667,1.667,0,1,0-1.111,0v1.3a1.667,1.667,0,0,0,0,3.142v1.3A1.669,1.669,0,0,0,240,114.552Zm1.667.556a.556.556,0,1,1,.556-.556A.556.556,0,0,1,241.665,115.108Zm0-10a.556.556,0,1,1-.556.556A.556.556,0,0,1,241.665,105.108Zm0,4.444a.556.556,0,1,1-.556.556A.556.556,0,0,1,241.665,109.552Z" transform="translate(-208.442 -59.552)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_170" data-name="Path 170" d="M304.556,121.111h5.556a.556.556,0,1,0,0-1.111h-5.556a.556.556,0,0,0,0,1.111Z" transform="translate(-268 -74.444)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_171" data-name="Path 171" d="M416.556,121.111h1.111a.556.556,0,0,0,0-1.111h-1.111a.556.556,0,0,0,0,1.111Z" transform="translate(-372.222 -74.444)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_172" data-name="Path 172" d="M304.556,185.111h5.556a.556.556,0,1,0,0-1.111h-5.556a.556.556,0,0,0,0,1.111Z" transform="translate(-268 -134)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_173" data-name="Path 173" d="M416.556,185.111h1.111a.556.556,0,0,0,0-1.111h-1.111a.556.556,0,0,0,0,1.111Z" transform="translate(-372.222 -134)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_174" data-name="Path 174" d="M304.556,249.111h5.556a.556.556,0,1,0,0-1.111h-5.556a.556.556,0,0,0,0,1.111Z" transform="translate(-268 -193.556)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_175" data-name="Path 175" d="M416.556,249.111h1.111a.556.556,0,0,0,0-1.111h-1.111a.556.556,0,0,0,0,1.111Z" transform="translate(-372.222 -193.556)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <path id="Path_176" data-name="Path 176" d="M46.555,40H18.778A2.781,2.781,0,0,0,16,42.778V61.667a2.781,2.781,0,0,0,2.778,2.778h8.767l-.978,4.891a.556.556,0,0,0,.545.665H38.222a.556.556,0,0,0,.545-.665l-.978-4.891h8.767a2.781,2.781,0,0,0,2.778-2.778V42.778A2.781,2.781,0,0,0,46.555,40ZM18.778,41.111H46.555a1.669,1.669,0,0,1,1.667,1.667V58.889H17.111V42.778A1.669,1.669,0,0,1,18.778,41.111ZM37.544,68.889H27.789l.889-4.444h7.978Zm9.011-5.556H18.778a1.669,1.669,0,0,1-1.667-1.667V60H48.222v1.667a1.669,1.669,0,0,1-1.667,1.667Z" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                        <circle id="Ellipse_1" data-name="Ellipse 1" cx="0.588" cy="0.588" r="0.588" transform="translate(19.137 42.059)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </circle>
                        <circle id="Ellipse_2" data-name="Ellipse 2" cx="0.588" cy="0.588" r="0.588" transform="translate(21.49 42.059)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </circle>
                        <circle id="Ellipse_3" data-name="Ellipse 3" cx="0.588" cy="0.588" r="0.588" transform="translate(23.843 42.059)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </circle>
                        <path id="Path_177" data-name="Path 177" d="M241.667,344h-1.111a.556.556,0,1,0,0,1.111h1.111a.556.556,0,1,0,0-1.111Z" transform="translate(-208.444 -282.889)" fill="#152d54" stroke="#152d54" stroke-width="0.5">
                        </path>
                    </g>
                </svg>
            </div>
            <div class="icon-info">
                <p style="font-weight:600"><?= $this->lang->line('tracking_reference') ?></p>
                <h4>ORD - <?= (isset($result[0]['order_id']) ? $result[0]['order_id'] : '') ?></h4>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3">
            <div class="track-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="30.572" height="24.736" viewBox="0 0 30.572 24.736">
                    <g id="noun_delivery_1672158" transform="translate(-0.398 -2.615)">
                        <path id="Path_178" data-name="Path 178" d="M30.942,16.157a.776.776,0,0,0-.069-.241c-.009-.017,0-.037-.016-.054l-2.365-3.953a2.185,2.185,0,0,0-1.867-1.054H21.912v-.647A3.558,3.558,0,0,0,18.354,6.65h-6.2a6.051,6.051,0,1,0-7.614,7.758v9.533a.791.791,0,0,0,.791.791H7.516a3.384,3.384,0,0,0,6.588,0h8.258a3.381,3.381,0,0,0,6.588,0H30.18a.791.791,0,0,0,.791-.791V16.288a.759.759,0,0,0-.029-.132ZM1.982,8.683a4.48,4.48,0,1,1,4.48,4.48,4.48,4.48,0,0,1-4.48-4.48ZM12.617,23.968a1.808,1.808,0,1,1,0-.042v.021Zm7.715-12.341V23.158H14.1a3.385,3.385,0,0,0-6.588,0H6.123v-8.44c.116.007.225.034.343.034a6.072,6.072,0,0,0,6.061-6.061c0-.155-.034-.3-.046-.455h5.866a1.977,1.977,0,0,1,1.977,1.977Zm1.581.809h4.709a.6.6,0,0,1,.51.291l1.647,2.749H21.912Zm3.734,13.328a1.813,1.813,0,1,1,1.813-1.814,1.813,1.813,0,0,1-1.813,1.814Zm3.742-2.6h-.437a3.394,3.394,0,0,0-6.6,0h-.434v-6.1h7.473ZM8.137,9.983H6.263a.791.791,0,0,1-.791-.791V6.9a.791.791,0,1,1,1.581,0V8.41H8.13a.791.791,0,0,1,0,1.581Z" transform="translate(0 0)" fill="#152d54">
                        </path>
                    </g>
                </svg>
            </div>
            <div class="icon-info">
                <p style="font-weight:600"><?= $this->lang->line('estimate_delivery_date'); ?></p>
                <h4><?= $result[0]['delivery_datetime'] ?></h4>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3">
            <div class="track-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="25.646" height="26.927" viewBox="0 0 25.646 26.927">
                    <g id="noun_order_2794302" transform="translate(-45.867 -22.712)">
                        <g id="Group_10" data-name="Group 10" transform="translate(45.867 22.712)">
                            <g id="Group_3" data-name="Group 3" transform="translate(0 6.176)">
                                <g id="Group_2" data-name="Group 2">
                                    <path id="Path_179" data-name="Path 179" d="M59.244,265.94l-1.164-.613-2.795-1.477q-1.7-.9-3.394-1.793l-2.924-1.543c-.473-.25-.943-.512-1.422-.751l-.019-.011.545.949V249.852c0-.5.011-1,0-1.5v-.019l-1.656.949,1.164.616,2.795,1.477,3.394,1.793,2.924,1.546c.473.25.943.512,1.422.751l.019.011-.545-.949v10.837c0,.5-.008,1,0,1.5v.019a1.1,1.1,0,1,0,2.2,0V256.046c0-.5.008-1,0-1.5v-.019a1.1,1.1,0,0,0-.545-.949l-1.164-.616-2.795-1.477-3.394-1.793-2.924-1.546c-.473-.25-.946-.506-1.422-.751l-.019-.011a1.12,1.12,0,0,0-1.111,0,1.1,1.1,0,0,0-.545.949v10.848c0,.5-.008,1,0,1.5v.019a1.1,1.1,0,0,0,.545.949l1.164.613,2.795,1.477q1.7.9,3.394,1.793l2.924,1.543c.473.25.946.506,1.422.751l.019.011a1.152,1.152,0,0,0,.847.11,1.1,1.1,0,0,0,.264-2.008Z" transform="translate(-45.867 -247.234)" fill="#152d54">
                                    </path>
                                </g>
                            </g>
                            <g id="Group_5" data-name="Group 5" transform="translate(11.72 6.181)">
                                <g id="Group_4" data-name="Group 4">
                                    <path id="Path_180" data-name="Path 180" d="M484.233,259.946l-1.163.613-2.795,1.477q-1.7.9-3.394,1.793l-2.924,1.543c-.473.25-.954.492-1.422.751l-.019.011,1.656.949V256.246c0-.5.011-1,0-1.5v-.019l-.545.949,1.164-.616,2.795-1.477,3.394-1.793,2.924-1.546c.473-.25.954-.492,1.422-.751l.019-.011-1.656-.949v10.848c0,.5-.008,1,0,1.5v.019a1.1,1.1,0,0,0,2.2,0V250.052c0-.5.008-1,0-1.5v-.019a1.1,1.1,0,0,0-.545-.949,1.12,1.12,0,0,0-1.111,0l-1.163.616-2.795,1.477-3.394,1.793-2.924,1.546c-.473.25-.954.492-1.422.751l-.019.011a1.1,1.1,0,0,0-.545.949v10.837c0,.5-.008,1,0,1.5v.019a1.1,1.1,0,0,0,.545.949,1.12,1.12,0,0,0,1.111,0l1.164-.613,2.795-1.477q1.7-.9,3.394-1.793l2.924-1.543c.473-.25.954-.49,1.422-.751l.019-.011a1.111,1.111,0,0,0,.4-1.5A1.13,1.13,0,0,0,484.233,259.946Z" transform="translate(-471.967 -247.434)" fill="#152d54">
                                    </path>
                                </g>
                            </g>
                            <g id="Group_7" data-name="Group 7" transform="translate(0.008)">
                                <g id="Group_6" data-name="Group 6">
                                    <path id="Path_181" data-name="Path 181" d="M70.141,29.038l-1.164.616-2.795,1.477-3.394,1.793-2.924,1.546c-.473.25-.954.492-1.422.751l-.019.011h1.111l-1.164-.616L55.576,33.14l-3.394-1.793L49.258,29.8c-.473-.25-.943-.512-1.422-.751l-.019-.011v1.9l1.164-.613,2.795-1.477,3.394-1.793q1.461-.772,2.924-1.546c.473-.25.954-.492,1.422-.751l.019-.011H58.423l1.164.613,2.795,1.477,3.394,1.793q1.461.772,2.924,1.546c.473.25.946.506,1.422.751l.019.011a1.152,1.152,0,0,0,.847.11,1.1,1.1,0,0,0,.261-2.011l-1.18-.622q-1.4-.739-2.8-1.48l-3.408-1.8L60.945,23.6c-.468-.248-.932-.5-1.4-.74a1.193,1.193,0,0,0-1.142,0c-.052.028-.1.055-.154.08l-.726.382q-1.324.7-2.652,1.4-1.683.891-3.375,1.785-1.527.8-3.05,1.612-.833.441-1.667.88l-.077.041a1.109,1.109,0,0,0,0,1.9l1.18.624,2.8,1.483,3.408,1.8L57,36.388c.468.248.932.5,1.4.743a1.193,1.193,0,0,0,1.142,0c.052-.028.1-.055.154-.08l.726-.382,2.652-1.4,3.378-1.785q1.527-.8,3.05-1.612l1.667-.883.077-.041a1.1,1.1,0,0,0-1.111-1.906Z" transform="translate(-46.162 -22.712)" fill="#152d54">
                                    </path>
                                </g>
                            </g>
                            <g id="Group_9" data-name="Group 9" transform="translate(5.862 3.092)">
                                <g id="Group_8" data-name="Group 8">
                                    <path id="Path_182" data-name="Path 182" d="M260.651,143.367l1.164-.616,2.795-1.477L268,139.48l2.924-1.546c.473-.25.954-.492,1.422-.751l.019-.011a1.111,1.111,0,0,0,.4-1.5,1.127,1.127,0,0,0-1.5-.4l-1.163.616-2.795,1.477-3.394,1.793-2.924,1.546c-.473.25-.954.492-1.422.751l-.019.011a1.1,1.1,0,1,0,1.108,1.9Z" transform="translate(-258.998 -135.132)" fill="#152d54">
                                    </path>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
            </div>
            <div class="icon-info">
                <p style="font-weight:600"><?= $this->lang->line('order_type'); ?></p>
                <h4>Normal</h4>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3">
            <div class="track-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="22.1" height="22.156" viewBox="0 0 22.1 22.156">
                    <g id="noun_gate_929092" transform="translate(-379.9 -280)">
                        <g id="Group_11" data-name="Group 11" transform="translate(379.9 280)">
                            <path id="Path_183" data-name="Path 183" d="M401.174,292.621a.7.7,0,0,0,.716-.716v-5.842a1.953,1.953,0,0,0-1.929-1.929H399.3v-2.59A1.507,1.507,0,0,0,397.757,280h-3.472a1.577,1.577,0,0,0-1.543,1.543v2.59H389.1v-2.59A1.507,1.507,0,0,0,387.561,280h-3.527a1.577,1.577,0,0,0-1.543,1.543v2.59h-.661a1.953,1.953,0,0,0-1.929,1.929v14.164a1.953,1.953,0,0,0,1.929,1.929h18.242A1.953,1.953,0,0,0,402,300.227V298.3a.728.728,0,0,0-.716-.716.7.7,0,0,0-.716.716v1.929a.474.474,0,0,1-.441.441H381.884a.474.474,0,0,1-.441-.441V289.039h19.069v2.921C400.457,292.235,400.843,292.621,401.174,292.621Zm-6.944-11.078c0-.055,0-.055.055-.055h3.527l.055.055v2.59h-3.637v-2.59Zm-10.251,0c0-.055,0-.055.055-.055h3.527l.055.055v2.59h-3.637v-2.59Zm-2.59,5.952v-1.488a.474.474,0,0,1,.441-.441h18.243a.474.474,0,0,1,.441.441V287.5Z" transform="translate(-379.9 -280)" fill="#152d54">
                            </path>
                        </g>
                        <g id="Group_12" data-name="Group 12" transform="translate(387.506 290.299)">
                            <path id="Path_184" data-name="Path 184" d="M406.1,303.82l-3.8,3.8a.6.6,0,0,1-.5.22.537.537,0,0,1-.5-.22.766.766,0,0,1,0-1.047l2.59-2.59h-9.48a.728.728,0,0,1-.716-.716.666.666,0,0,1,.716-.716h9.369l-2.59-2.59a.766.766,0,0,1,0-1.047.716.716,0,0,1,1.047,0l3.8,3.8A.785.785,0,0,1,406.1,303.82Z" transform="translate(-393.7 -298.687)" fill="#152d54">
                            </path>
                        </g>
                    </g>
                </svg>
            </div>
            <div class="icon-info">
                <p style="font-weight:600"><?= $this->lang->line('gate_out'); ?></p>
                <h4><?= $result[0]['gate_out'] ?></h4>
            </div>
        </div>
    </div>
</div>
<?php
if (isset($result) && count($result) > 0) { ?>
    <div class="routing-block">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12 col-md-8 col-lg-8 p-0">
                    <?php if ($this->session->userdata('company_code') == "CNKN") { ?>
                        <div class="location-map" id="map_<?= $result[0]['order_id']; ?>" style="overflow: scroll;">

                        </div>
                    <?php } else { ?>
                        <div class="location-map" id="googleMap_<?= $result[0]['order_id']; ?>" style="overflow: scroll;">

                        </div>
                    <?php } ?>
                </div>
                <div class="col-12 col-md-4 col-lg-4 p-0">
                    <div class="shipment-overview-block">
                        <div class="shiment-title">
                            <h5><?= $this->lang->line("vehicle_path") ?></h5>
                        </div>
                        <div class="list-details-box custom-scroll">
                            <ul class="list-group">
                                <?php
                                if (isset($result) && count($result) > 0) {
                                    $checkOrdersPickup = 0;
                                    if (isset($stops_array)) {
                                        foreach ($stops_array as $i => $row) {
                                            if ($drop_count == 1) {
                                                if ($result[0]['plat'] == $row['plat'] && $result[0]['plng'] == $row['plng'] && $row['stoptype'] == 'P') {
                                                    $checkOrdersPickup = 1;
                                                }
                                                if ($checkOrdersPickup > 0) {
                                ?>
                                                    <li class="list-item">
                                                        <div class="shiment-icon"><span class="pic-icon">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="19.333" height="14.5" viewBox="0 0 19.333 14.5">
                                                                    <defs>
                                                                        <style>
                                                                            .a {
                                                                                fill: #152d54;
                                                                                fill-rule: evenodd;
                                                                            }
                                                                        </style>
                                                                    </defs>
                                                                    <path d="M0,.6A.6.6,0,0,1,.6,0H13.9a.6.6,0,0,1,.6.6V2.417h1.813a.6.6,0,0,1,.525.3L19.254,6.95a.6.6,0,0,1,.08.3v4.229a.6.6,0,0,1-.6.6H16.21a1.813,1.813,0,1,1-3.419,0H5.334a1.813,1.813,0,1,1-3.419,0H.6a.6.6,0,0,1-.6-.6ZM3.625,10.875h9.667V1.208H1.208v9.667Zm0,1.208a.6.6,0,1,0,.605.6.6.6,0,0,0-.605-.6h0Zm14.5-4.673v3.465H14.5V3.625h1.462ZM13.9,12.688a.6.6,0,1,1,.6.6A.6.6,0,0,1,13.9,12.688Z" class="a"></path>
                                                                </svg></span>
                                                            <h6><?= @$row['stopname'] ?>,<?= @$row['stopcity'] ?><span>
                                                                    <?= @$row['address'] ?></span>
                                                            </h6>
                                                        </div>
                                                    </li>
                                                <?php
                                                    if ($result[0]['dlat'] == $row['plat'] && $result[0]['dlng'] == $row['plng']) {
                                                        break;
                                                    }
                                                }
                                            } else { ?>
                                                <li class="list-item">
                                                    <div class="shiment-icon"><span class="pic-icon">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="19.333" height="14.5" viewBox="0 0 19.333 14.5">
                                                                <defs>
                                                                    <style>
                                                                        .a {
                                                                            fill: #152d54;
                                                                            fill-rule: evenodd;
                                                                        }
                                                                    </style>
                                                                </defs>
                                                                <path d="M0,.6A.6.6,0,0,1,.6,0H13.9a.6.6,0,0,1,.6.6V2.417h1.813a.6.6,0,0,1,.525.3L19.254,6.95a.6.6,0,0,1,.08.3v4.229a.6.6,0,0,1-.6.6H16.21a1.813,1.813,0,1,1-3.419,0H5.334a1.813,1.813,0,1,1-3.419,0H.6a.6.6,0,0,1-.6-.6ZM3.625,10.875h9.667V1.208H1.208v9.667Zm0,1.208a.6.6,0,1,0,.605.6.6.6,0,0,0-.605-.6h0Zm14.5-4.673v3.465H14.5V3.625h1.462ZM13.9,12.688a.6.6,0,1,1,.6.6A.6.6,0,0,1,13.9,12.688Z" class="a"></path>
                                                            </svg></span>
                                                        <h6><?= @$row['stopname'] ?>,<?= @$row['stopcity'] ?><span>
                                                                <?= @$row['address'] ?></span>
                                                        </h6>
                                                    </div>
                                                </li>
                                        <?php
                                                if ($result[0]['dlat'] == $row['plat'] && $result[0]['dlng'] == $row['plng']) {
                                                    break;
                                                }
                                            }
                                        }
                                    } else { ?>
                                        <li class="text-center">No Data Found</li>
                                <?php
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="vehicleInformation">
        <div class="col-sm-12">
            <h2 class="title"><?= $this->lang->line('shipments') ?></h2>
            <div class="table-responsive tableBlock vehicle-info-block">
                <table class="table cardTable table-hover">
                    <thead>
                        <tr>
                            <th><?= $this->lang->line('id') ?>#</th>
                            <th><?= $this->lang->line('carrier') ?></th>
                            <th><?= $this->lang->line('origin') ?></th>
                            <th><?= $this->lang->line('general_destination') ?></th>
                            <th><?= $this->lang->line('cargo') ?></th>
                            <th><?= $this->lang->line('progress') ?>
                                <span>(<?= $this->lang->line('clcik_view') ?>)</span>
                            </th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (isset($result[0]["shipment_data"]) && $result[0]["shipment_data_count"] > 0) {
                            $width = "width: 100%;";
                            $result_array = $result[0]["shipment_data"];
                            $assign_temp = "";
                            for ($i = 0, $iMax = count($result_array); $i < $iMax; $i++) {
                                if (in_array(strtolower($result_array[$i]->transport_mode), ['air-lcl', 'air-fcl', 'sea-fcl', 'sea-lcl'])) {
                                    $enableSeaMap = 1;
                                }
                                if ($result_array[$i]->progress == "COMPLETED") {
                                    $width = "width: 100%;";
                                } else if ($result_array[$i]->progress == "CLOSED") {
                                    $width = "width: 100%;";
                                } else if ($result_array[$i]->progress == "IN TRANSIT") {
                                    $width = "width: 50%;";
                                } else {
                                    $width = "width: 25%;";
                                }
                        ?>
                                <tr>
                                    <td>#<?= $result_array[$i]->leg_id ?></td>
                                    <td> <?php if (!empty($this->session->userdata('cust_id'))) {
                                                echo ($result[0]["show_carrier"] == 1) ? $result_array[$i]->transport_mode : "-";
                                            } else {
                                                echo $result_array[$i]->transport_mode;
                                            } ?></td>
                                    <td><?= $result_array[$i]->source ?></td>
                                    <td>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="21" viewBox="0 0 28 21">
                                                <defs>
                                                    <style>
                                                        .a {
                                                            fill: #13b4e5;
                                                            fill-rule: evenodd;
                                                        }
                                                    </style>
                                                </defs>
                                                <path d="M0,.875A.875.875,0,0,1,.875,0h19.25A.875.875,0,0,1,21,.875V3.5h2.625a.875.875,0,0,1,.76.441l3.5,6.125A.874.874,0,0,1,28,10.5v6.125a.875.875,0,0,1-.875.875H23.476a2.625,2.625,0,1,1-4.951,0H7.726a2.625,2.625,0,1,1-4.951,0H.875A.875.875,0,0,1,0,16.625ZM5.25,15.75h14v-14H1.75v14Zm0,1.75a.875.875,0,1,0,.876.875.875.875,0,0,0-.876-.875h0Zm21-6.768V15.75H21V5.25h2.117Zm-6.125,7.643A.875.875,0,1,1,21,19.25.875.875,0,0,1,20.125,18.375Z" class="a">

                                                </path>
                                            </svg>
                                        </span><?= $result_array[$i]->desitination ?>
                                    </td>
                                    <td><?= $result_array[$i]->units ?> X <?= $result_array[$i]->weight ?></td>
                                    <td>
                                        <div class="icons_progress-dates">
                                            <ul>
                                                <li>
                                                    <span><?= $result_array[$i]->startdate ?></span>
                                                </li>
                                                <li>
                                                    <span class="text-right"><?= $result_array[$i]->enddate ?></span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="icons_progress">
                                            <ul>
                                                <li>
                                                    <span>
                                                        <img src="http://myscmlog.com/assets/images/map-1.png">
                                                    </span>
                                                </li>
                                                <li>
                                                    <span>
                                                        <img src="http://myscmlog.com/assets/images/map-2.png">
                                                    </span>
                                                </li>
                                                <li>
                                                    <span>
                                                        <img src="http://myscmlog.com/assets/images/map-3.png">
                                                    </span>
                                                </li>
                                                <li>
                                                    <span>
                                                        <img src="http://myscmlog.com/assets/images/map-4.png">
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="<?= $width ?>"></div>
                                        </div>
                                        <p class="text-right text-success"><?= $result_array[$i]->status_name ?></p>
                                    </td>
                                    <td></td>
                                </tr>


                            <?php }
                        } else {  ?>
                            <tr>
                                <td colspan="7" class="text-center"> No Data Found</td>
                            </tr>
                        <?php  } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php } else { ?>
    <div class="ent-toolbar-div" style="height:100px;">
        <div class="row">
            <p style="text-align: center;
            font-size: 16px;
            font-weight: 700;">
                No Data Available
            </p>
        </div>
    </div>
<?php }
if ($this->session->userdata('company_code') === "CNKN") {
?>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>assets/here_map_china/china_css/mapsjs-ui.css" />
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/here_map_china/china_js/mapsjs-core.js"></script>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/here_map_china/china_js/mapsjs-service.js"></script>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/here_map_china/china_js/mapsjs-ui.js"></script>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/here_map_china/china_js/mapsjs-mapevents.js"></script>
<?php } ?>
<script>
    <?php
    $this->load->helper('home');
    $this->load->helper('user');
    if ($this->session->userdata('company_code') === "CNKN") {
        $finalsts = "a";
        if (count($result[0]['trip']) > 0) {
            if ($result[0]['trip']['status'] == "0") {
                $finalsts = "b";
            }
        }
        $cntrylatlng['ulat'] = 50;
        $cntrylatlng['ulng'] = 5;
        if (isset($result[0]['user_id'])) {
            $cntrylatlng = getLogUserLatLng($result[0]['user_id']);
        }
        if (isset($result) && count($result) > 0) {
    ?>

            var trip_id = '<?php echo $result[0]['trip_id']; ?>';
            var q = [];
            var map;
            var vehicle;
            var nextTimeStamp = "";
            var trackerFrequency = 10000;
            var angle = 0;
            var tokBox = null;
            var trafficLayer;
            var trafficFlag = false;
            var isSimBased = false;
            var actualBounds;
            var id = '<?php echo $result[0]['id']; ?>';
            var order_id = '<?php echo $result[0]['order_id']; ?>';
            var mph = 13.8889;
            var tripClose = false;
            var directionsService;
            var directionsDisplay;
            var allBounds;
            var showAllBounds = false;
            var platform;
            var currentPosLat = <?php echo $cntrylatlng["ulat"]; ?>;
            var currentPosLng = <?php echo $cntrylatlng["ulng"]; ?>;
            var isPickUpDone = '<?php echo $result[0]['status']['isPickUpDone']; ?>';
            var isOrderDelivered = '<?php echo $result[0]['status']['isOrderDelivered']; ?>';
            <?php
            echo "var firstLat = '" . $result[0]['plat'] . "';";
            echo "var firstLng = '" . $result[0]['plng'] . "';";
            if (!empty($result[0]['triprecord']['latitude']) && $result[0]['status']['isOrderHasIntransitPoint'] == 'Yes') {
                echo "var curLat = '" . $result[0]['triprecord']['latitude'] . "';";
                echo "var curLng = '" . $result[0]['triprecord']['longitude'] . "';";
            } else {
                echo "var curLat = '" . $result[0]['plat'] . "';";
                echo "var curLng = '" . $result[0]['plng'] . "';";
            }
            echo "var lastLat = '" . $result[0]['dlat'] . "';";
            echo "var lastLng = '" . $result[0]['dlng'] . "';";
            echo "var tripStatus = '" . $result[0]['trip_sts'] . "';";
            ?>

            function switchMapLanguage(map, platform, defaultLayers) {
                var mapTileService = platform.getMapTileService({
                        type: 'base'
                    }),
                    chineseMapLayer = mapTileService.createTileLayer(
                        'maptile',
                        'normal.day',
                        256,
                        'png8', {
                            lg: 'ENG'
                        }
                    );
                map.setBaseLayer(chineseMapLayer);
                var ui = H.ui.UI.createDefault(map, defaultLayers, 'en-US');
                ui.removeControl('mapsettings');
            }
            $(document).ready(function() {
                allBounds = [];
                <?php
                $etime = $tstatus = "";
                if (count($result[0]['trip']) > 0) {
                    $tstatus = $result[0]['trip']['status'];
                    if ($result[0]['trip']['status'] == "0") {
                        echo "tripClose = true;";
                    }
                    $etime = $result[0]['trip']['etime'];
                }
                ?>
                if (tripClose) {
                    $(".cards-eta").html('<?php echo $result[0]['trip']['etime']; ?>');
                }
                $(".tt_box").css("width", (window.outerWidth / 5) - 16)

                if (window.top !== window.self) {
                    $("footer.main-footer").remove();
                    $(".main-header").remove();
                    $(".tracking-list").css("height", "auto");
                    $(".rightBottom").css("margin-bottom", "0px");
                }
                var drh = $(".details-row").outerHeight();
                var crh = $(".cards-row").outerHeight();
                var th = $(".details-row").closest("body").outerHeight() - drh - crh - 45;
                var CHINA_HERE_MAP_API_ID = '<?= CHINA_HERE_MAP_API_ID; ?>';
                var CHINA_HERE_MAP_API_CODE = '<?= CHINA_HERE_MAP_API_CODE; ?>';
                platform = new H.service.Platform({
                    app_id: CHINA_HERE_MAP_API_ID,
                    app_code: CHINA_HERE_MAP_API_CODE,
                    useHTTPS: true
                });
                var defaultLayers = platform.createDefaultLayers();
                map = new H.Map(document.getElementById('map_<?= $result[0]['order_id']; ?>'),
                    defaultLayers.normal.map, {
                        center: {
                            lat: currentPosLat,
                            lng: currentPosLng
                        },
                        zoom: 4,
                        pixelRatio: window.devicePixelRatio || 1,
                        styles: [{
                            featureType: "all",
                            stylers: [{
                                saturation: 0
                            }, {
                                hue: "#e7ecf0"
                            }]
                        }, {
                            featureType: "road",
                            stylers: [{
                                saturation: -70
                            }]
                        }, {
                            featureType: "transit",
                            stylers: [{
                                visibility: "off"
                            }]
                        }, {
                            featureType: "poi",
                            stylers: [{
                                visibility: "off"
                            }]
                        }, {
                            featureType: "water",
                            stylers: [{
                                visibility: "simplified"
                            }, {
                                saturation: -60
                            }]
                        }]
                    });
                map.getViewPort().setPadding(50, 50, 50, 50);
                window.addEventListener('resize', () => map.getViewPort().resize());
                var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
                switchMapLanguage(map, platform, defaultLayers);
                setTimeout(function() {
                    $("#map_<?= $result[0]['order_id']; ?>").css("height", "calc(100% - 93px)");
                }, 1000);
                isSimBased = <?php echo $result[0]['isSimBased']; ?>;
                var trip_closed = '<?php echo $result[0]['trip']['status']; ?>';
                var iconn = getIconByAngle(0);
                var pos = {
                    lat: <?php echo $cntrylatlng['ulat']; ?>,
                    lng: <?php echo $cntrylatlng['ulng']; ?>
                };
                actualBounds = [];
                vehicle = new H.map.Marker(pos, {
                    icon: iconn
                });
                var coords = [];
                var routeRequestParams = {
                    mode: 'fastest;car',
                    representation: 'display',
                    routeattributes: 'waypoints,summary,shape,legs',
                    maneuverattributes: 'direction,action'
                };
                routeRequestParams["waypoint0"] = curLat + "," + curLng;
                routeRequestParams["waypoint1"] = lastLat + "," + lastLng;
                var router = platform.getRoutingService();
                var driverToDropETA = "";
                var driverToDropDist = "0 KM";
                var pickupToDropETA = "";
                var pickupToDropDist = "";
                $(".cards-distance").text('');
                if (routeRequestParams["waypoint0"] != routeRequestParams["waypoint1"] && tripStatus != 1) {
                    router.calculateRoute(routeRequestParams, function(result) {
                            var route, linestring;
                            if (result.response) {
                                route = result.response.route[0];
                                var hour = Math.floor(route.summary.travelTime / 3600);
                                var days = Math.floor(hour / 16);
                                hour = hour + (days * 8);
                                var minutes = Math.floor(route.summary.travelTime % 3600 / 60);
                                var distance = (route.summary.distance / 1000).toFixed(2);
                                driverToDropETA = hour + " Hr " + minutes + " Min";
                                driverToDropDist = distance + " KM";
                            }
                        },
                        function(error) {
                            console.log(error.message);
                        });
                } else {

                }

                setTimeout(function() {
                    routeRequestParams["waypoint0"] = firstLat + "," + firstLng;
                    routeRequestParams["waypoint1"] = lastLat + "," + lastLng;
                    var router = platform.getRoutingService();
                    router.calculateRoute(routeRequestParams, function(result) {
                            var route, linestring;
                            if (result.response) {
                                route = result.response.route[0];
                                var hour = Math.floor(route.summary.travelTime / 3600);
                                var days = Math.floor(hour / 16);
                                hour = hour + (days * 8);
                                var minutes = Math.floor(route.summary.travelTime % 3600 / 60);
                                var distance = (route.summary.distance / 1000).toFixed(2);
                                pickupToDropETA = hour + " Hr " + minutes + " Min";
                                pickupToDropDist = distance + " KM";
                            }
                        },
                        function(error) {
                            console.log(error.message);
                        });
                }, 1000);

                function getString(value) {
                    if (value) {
                        return value
                    } else {
                        return "-";
                    }
                }

                function getNumber(value) {
                    if (value) {
                        return value
                    } else {
                        return 0;
                    }
                }

                function getFaclityAddress(address) {
                    var str = "";
                    if (address.streetNumber) {
                        str = str + address.streetNumber;
                    }
                    if (address.street) {
                        if (str.length > 0) {
                            str = str + ", " + address.street;
                        } else {
                            str = address.street;
                        }
                    }
                    if (address.city) {
                        if (str.length > 0) {
                            str = str + ", " + address.city;
                        } else {
                            str = address.city;
                        }
                    }
                    if (address.region) {
                        if (str.length > 0) {
                            str = str + ", " + address.region;
                        } else {
                            str = address.region;
                        }
                    }
                    if (address.country) {
                        if (str.length > 0) {
                            str = str + ", " + address.country;
                        } else {
                            str = address.country;
                        }
                    }
                    if (address.postalCode) {
                        if (str.length > 0) {
                            str = str + ", " + address.postalCode;
                        } else {
                            str = address.postalCode;
                        }
                    }
                    return str
                }
                //getAddress();
                $(".switch_map_view").click(function() {
                    if (showAllBounds == false) {
                        showAllBounds = true;
                        var group = new H.map.Group();
                        group.addObjects(actualBounds);
                        map.addObject(group);

                        $(this).html("View All");
                    } else {
                        showAllBounds = false;
                        var group = new H.map.Group();
                        group.addObjects(allBounds);
                        map.addObject(group);
                        $(this).html("View Vehicle");
                    }
                });
            });

            function getTripLocation(isSimBased, timestamp) {
                $.ajax({
                    url: "<?= base_url() ?>livetrack/getTripLocation/<?php echo $result[0]['trip']['id']; ?>/" + timestamp,
                    data: {
                        'timezone': '<?php echo $result[0]['timezone']; ?>'
                    },
                    type: "POST",
                    dataType: "JSON",
                    success: function(data) {
                        $.each(data.data, function(i, v) {
                            q.push(v);
                        });
                        if (q.length > 0) {
                            var lastPoint = {
                                lat: q[q.length - 1].lat,
                                lng: q[q.length - 1].lng
                            };
                            var d = q.shift();
                            var pos = {
                                lat: d.lat,
                                lng: d.lng
                            };
                            if (timestamp != "") {
                                $(".speed").html(d.speed);
                                $(".timestamp").html(d.receivedon);
                                startQueueProcessing();

                                if (showAllBounds) {
                                    var group = new H.map.Group();
                                    group.addObjects(allBounds);
                                    map.addObject(group);
                                    map.getViewModel().setLookAtData({
                                        bounds: group.getBoundingBox()
                                    });
                                }
                            } else {
                                vehicle.setGeometry(pos);
                            }
                            $(".cards-battery").html(parseFloat(d.battery).toFixed(0) + " %");
                            $(".cards-speed").html(d.speed);
                        }

                        if (data.data.length != 0) {
                            nextTimeStamp = data.data[data.data.length - 1].timestamp;
                        }
                        setTimeout(function() {
                            getTripLocation(isSimBased, nextTimeStamp);
                        }, trackerFrequency);
                    }
                });
            }

            function getTravelTime() {
                var routeRequestParams = {
                    mode: 'fastest;car',
                    representation: 'display',
                    routeattributes: 'waypoints,summary,shape,legs',
                    maneuverattributes: 'direction,action'
                };
                routeRequestParams["waypoint0"] = currentPosLat + "," + currentPosLng;
                var router = platform.getRoutingService();
                router.calculateRoute(routeRequestParams, function(result) {
                        var route, linestring;
                        if (result.response) {
                            route = result.response.route[0];
                            var h = Math.floor(route.summary.travelTime / 3600);
                            var days = Math.floor(h / 16);
                            h = h + (days * 8);
                            var m = Math.floor(route.summary.travelTime % 3600 / 60);

                        }
                    },
                    function(error) {
                        console.log(error.message);
                    });
            }

            function startQueueProcessing() {
                queueFunction();
                setInterval(function() {
                    queueFunction();
                }, trackerFrequency);
            }

            function queueFunction() {
                var data = q.shift();
                if (data != null && vehicle != null) {
                    $(".speed").html(data.speed);
                    $(".timestamp").html(data.receivedon);
                    angle = Math.round(data.course / 10);
                    vehicle.setIcon(getIconByAngle(angle));

                    var newPosition = {
                        lat: data.lat,
                        lng: data.lng
                    };
                    var oldPosition = {
                        lat: vehicle.b.lat,
                        lng: vehicle.b.lng
                    };
                    actualBounds = [];
                    actualBounds.push(vehicle);
                    allBounds.push(vehicle);

                    if (!showAllBounds) {
                        vehicle.animateTo(map, newPosition, {
                            duration: trackerFrequency,
                            drawRoute: "draw"
                        });
                    } else {
                        vehicle.animateTo(map, newPosition, {
                            duration: trackerFrequency,
                            dragMap: "no-stick",
                            drawRoute: "draw"
                        });
                    }
                }
            }

            function secondsTimeSpanToHMS(s) {
                var h = Math.floor(s / 3600);
                s -= h * 3600;
                var m = Math.floor(s / 60);
                s -= (m * 60).toFixed(0);
                return h + ":" + (m < 10 ? '0' + m : m) + ":" + (s < 10 ? '0' + s.toFixed(0) : s.toFixed(0));
            }

            function calcRoute() {
                var routeRequestParams = {
                    mode: 'fastest;car',
                    representation: 'display',
                    routeattributes: 'waypoints,summary,shape,legs',
                    maneuverattributes: 'direction,action'
                };
                var i = 1;
                $(".points").each(function(index, ele) {
                    var point = $(this).data("lat") + "," + $(this).data("lng");
                    var status_id = $(this).data("status_id");

                    if (status_id == 4) {
                        Lastwaypoit = point;
                        routeRequestParams["waypoint" + i] = point;
                        i++;
                    }
                });
                routeRequestParams["waypoint0"] = firstLat + "," + firstLng;
                routeRequestParams["waypoint" + i] = lastLat + "," + lastLng;
                var router = platform.getRoutingService();
                router.calculateRoute(routeRequestParams, function(result) {
                        var route, linestring;
                        if (result.response) {
                            route = result.response.route[0];
                            linestring = new H.geo.LineString();
                            var intransitIndex = 1;
                            var routepoint = '';
                            var lastIntransitLat = lastIntransitLng = '';

                            for (i = 0; i < route.waypoint.length; i++) {
                                var markerIconColor = "red";
                                if (i == 0) {
                                    routepoint = 'A';
                                    if (isPickUpDone === 'Yes') {
                                        markerIconColor = "green";
                                    }
                                } else if (i == route.waypoint.length - 1) {
                                    routepoint = 'B';
                                    if (isOrderDelivered === 'Yes') {
                                        markerIconColor = "green";
                                    }

                                } else {
                                    markerIconColor = "red";
                                    routepoint = intransitIndex;
                                    lastIntransitLat = route.waypoint[i].mappedPosition.latitude;
                                    lastIntransitLng = route.waypoint[i].mappedPosition.longitude;
                                    intransitIndex++;
                                }
                                var svgMarkup = '<svg xmlns="http://www.w3.org/2000/svg" width="28px" height="36px"><path d="M 19 31 C 19 32.7 16.3 34 13 34 C 9.7 34 7 32.7 7 31 C 7 29.3 9.7 28 13 28 C 16.3 28 19 29.3 19 31 Z" fill="#000" fill-opacity=".2"/><path d="M 13 0 C 9.5 0 6.3 1.3 3.8 3.8 C 1.4 7.8 0 9.4 0 12.8 C 0 16.3 1.4 19.5 3.8 21.9 L 13 31 L 22.2 21.9 C 24.6 19.5 25.9 16.3 25.9 12.8 C 25.9 9.4 24.6 6.1 22.1 3.8 C 19.7 1.3 16.5 0 13 0 Z" fill="#fff"/><path d="M 13 2.2 C 6 2.2 2.3 7.2 2.1 12.8 C 2.1 16.1 3.1 18.4 5.2 20.5 L 13 28.2 L 20.8 20.5 C 22.9 18.4 23.8 16.2 23.8 12.8 C 23.6 7.07 20 2.2 13 2.2 Z" fill="' + markerIconColor + '"/><text x="13" y="19" font-size="12pt" font-weight="bold" text-anchor="middle" fill="#fff">' + routepoint + '</text></svg>';
                                var icon = new H.map.Icon(svgMarkup);
                                var marker = new H.map.Marker({
                                    lat: route.waypoint[i].mappedPosition.latitude,
                                    lng: route.waypoint[i].mappedPosition.longitude
                                }, {
                                    icon: icon
                                });
                                map.addObject(marker);
                            }
                            route.shape.forEach(function(point) {
                                var parts = point.split(',');
                                linestring.pushLatLngAlt(parts[0], parts[1]);
                            });
                            var polyline = new H.map.Polyline(linestring, {
                                style: {
                                    strokeColor: '#669DF6',
                                    lineWidth: 5,
                                    strokeOpacity: 0.5
                                }
                            });

                            map.addObject(polyline);
                            map.setViewBounds(polyline.getBounds(), true);
                        }

                    },
                    function(error) {
                        console.log(error.message);
                    }
                );
            }

            function getIconByAngle(angle) {

                return new H.map.Icon("<?= base_url() ?>assets/vehicle/vehicle copy " + angle + ".png");
            }

            function reloadLocation(ele) {
                getAddress();
            }

            function getAddress() {
                var geocoder = platform.getGeocodingService();
                reverseGeocodingParameters = {
                    prox: vehicle.b.lat + ',' + vehicle.b.lng,
                    mode: 'retrieveAddresses',
                    maxresults: '1',
                    jsonattributes: 1
                };
                geocoder.reverseGeocode(reverseGeocodingParameters, function(result) {
                    if (result.response.view.length > 0) {
                        var locations = result.response.view[0].result;
                        for (i = 0; i < locations.length; i += 1) {
                            address = locations[i].location.address;
                            content = address.label;
                            $(".locationName").html(content + " <div class='btn btn-xs btn-default' onclick='reloadLocation(this)'><i class='fa fa-fa fa-refresh'></i></div>");
                        }
                    }
                }, function(e) {
                    console.log(e);
                });
            }

            var zoomLevel = 19;
            H.map.Marker.prototype.animateTo = function(map = null, newPosition, options) {
                defaultOptions = {
                    duration: 1000,
                    easing: 'linear',
                    dragMap: 'stick',
                    complete: null,
                    drawRoute: 'no'
                }
                options = options || {};

                for (key in defaultOptions) {
                    options[key] = options[key] || defaultOptions[key];
                }

                if (options.easing != 'linear') {
                    if (typeof jQuery == 'undefined' || !jQuery.easing[options.easing]) {
                        throw '"' + options.easing + '" easing function doesn\'t exist. Include jQuery and/or the jQuery easing plugin and use the right function name.';
                        return;
                    }
                }

                window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
                window.cancelAnimationFrame = window.cancelAnimationFrame || window.mozCancelAnimationFrame;

                this.AT_startPosition_lat = this.b.lat;
                this.AT_startPosition_lng = this.b.lng;
                var newPosition_lat = newPosition.lat;
                var newPosition_lng = newPosition.lng;

                if (Math.abs(newPosition_lng - this.AT_startPosition_lng) > 180) {
                    if (newPosition_lng > this.AT_startPosition_lng) {
                        newPosition_lng -= 360;
                    } else {
                        newPosition_lng += 360;
                    }
                }
                var animateStep = function(marker, startTime) {
                    var ellapsedTime = (new Date()).getTime() - startTime;
                    var durationRatio = ellapsedTime / options.duration;
                    var easingDurationRatio = durationRatio;
                    if (options.easing !== 'linear') {
                        easingDurationRatio = jQuery.easing[options.easing](durationRatio, ellapsedTime, 0, 1, options.duration);
                    }
                    if (durationRatio < 1) {
                        var deltaPosition = {
                            lat: marker.AT_startPosition_lat + (newPosition_lat - marker.AT_startPosition_lat) * easingDurationRatio,
                            lng: marker.AT_startPosition_lng + (newPosition_lng - marker.AT_startPosition_lng) * easingDurationRatio
                        };
                        if (map != null && options.dragMap == 'stick') {
                            map.setCenter(deltaPosition);
                            map.setZoom(zoomLevel);
                        }
                        if (map != null && options.drawRoute == 'draw') {
                            var coords = [];
                            coords.push(marker.b);
                            coords.push(deltaPosition);

                            var lineString = new H.geo.LineString();
                            $.each(coords, function(i, val) {
                                lineString.pushPoint(val);
                            });
                            var line = new H.map.Polyline(lineString, {
                                style: {
                                    lineWidth: 9,
                                    strokeColor: "#244062",
                                    strokeOpacity: 0.8
                                }
                            })
                            map.addObject(line);
                        }
                        marker.setGeometry(deltaPosition);
                        if (window.requestAnimationFrame) {
                            marker.AT_animationHandler = window.requestAnimationFrame(function() {
                                animateStep(marker, startTime)
                            });
                        } else {
                            marker.AT_animationHandler = setTimeout(function() {
                                animateStep(marker, startTime)
                            }, 17);
                        }

                    } else {
                        marker.setGeometry(newPosition);
                        if (typeof options.complete === 'function') {
                            options.complete();
                        }
                    }
                }

                if (window.cancelAnimationFrame) {
                    window.cancelAnimationFrame(this.AT_animationHandler);
                } else {
                    clearTimeout(this.AT_animationHandler);
                }
                animateStep(this, (new Date()).getTime());
            }
        <?php }
    } else {
        if (isset($result) && count($result) > 0) {
            $finalsts = "a";
            if (count($result[0]['trip']) > 0) {
                if ($result[0]['trip']['status'] == "0") {
                    $finalsts = "b";
                }
            }
            $cntrylatlng['ulat'] = 20.5937;
            $cntrylatlng['ulng'] = 78.9629;
            if (isset($result[0]['user_id'])) {
                $cntrylatlng = getLogUserLatLng($result[0]['user_id']);
            }
            $mapLatLngs['ulat'] = $result[0]['plat'] ?? $cntrylatlng['ulat'];
            $mapLatLngs['ulng'] = $result[0]['plng'] ?? $cntrylatlng['ulng'];
            $orderDlat = $result[0]['dlat'] ?? "0";
            $orderDlng = $result[0]['dlng'] ?? "0";
        ?>
            var enableSeaMap = <?= $enableSeaMap ?? 0 ?>;
            var fnsts = "<?php echo $finalsts; ?>";
            var ulglat = <?php echo $mapLatLngs['ulat']; ?>;
            var ulglng = <?php echo $mapLatLngs['ulng']; ?>;
            var trip_id = '<?php echo $result[0]['trip_id']; ?>';
            var q = [];
            var googleMap;
            var markers = [];
            var polylines = [];
            var vehicle;
            var nextTimeStamp = "";
            var trackerFrequency = 20000;
            var angle = 0;
            var tokBox = null;
            var trafficLayer;
            var trafficFlag = false;
            var isSimBased = false;
            var bounds;
            var id = '<?php echo $result[0]['id']; ?>';
            var order_id = '<?php echo $result[0]['order_id']; ?>';
            var mph = 13.8889;
            var tripClose = false;
            var directionsService;
            var directionsDisplay;
            var level1Bounds;
            var showRoute = false;
            var orderDlat = '<?php echo $orderDlat; ?>';
            var orderDlng = '<?php echo $orderDlng; ?>';
            $(document).ready(function() {
                level1Bounds = new google.maps.LatLngBounds();
                <?php
                $etime = $tstatus = "";
                if (isset($result[0]['trip']) && count($result[0]['trip']) > 0) {
                    $tstatus = $result[0]['trip']['status'];
                    if ($tstatus == "0") { ?>
                        tripClose = true;
                <?php }
                    $etime = $result[0]['trip']['etime'];
                }
                ?>
                if (tripClose) {
                    $(".cards-eta").html('<?php echo $etime; ?>');
                }
                $(".tt_box").css("width", (window.outerWidth / 5) - 16);
                initmap();
                if (window.top !== window.self) {
                    $("footer.main-footer").remove();
                    $(".main-header").remove();
                    $(".tracking-list").css("height", "auto");
                    $(".rightBottom").css("margin-bottom", "0px");
                }
                var drh = $(".details-row").outerHeight();
                var crh = $(".cards-row").outerHeight();
                var th = $(".details-row").closest("body").outerHeight() - drh - crh - 45;
                /*$("#googleMap").css("height", th+"px");*/
                $("#googleMap_<?= $result[0]['order_id']; ?>").css("height", th + "px");
                if (enableSeaMap > 0) {
                    var markers = [];
                    const map = new google.maps.Map(document.getElementById("googleMap_<?= $result[0]['order_id']; ?>"), {
                        zoom: 3,
                        center: {
                            lat: ulglat,
                            lng: ulglng
                        },
                        styles: [{
                            featureType: "all",
                            stylers: [{
                                saturation: 0
                            }, {
                                hue: "#e7ecf0"
                            }]
                        }, {
                            featureType: "road",
                            stylers: [{
                                saturation: -70
                            }]
                        }, {
                            featureType: "transit",
                            stylers: [{
                                visibility: "off"
                            }]
                        }, {
                            featureType: "poi",
                            stylers: [{
                                visibility: "off"
                            }]
                        }, {
                            featureType: "water",
                            stylers: [{
                                visibility: "simplified"
                            }, {
                                saturation: -60
                            }]
                        }]
                    });
                    bounds = new google.maps.LatLngBounds();
                    var pos = new google.maps.LatLng(ulglat, ulglng);
                    bounds.extend(pos);
                    directionsService = new google.maps.DirectionsService();
                    directionsService1 = new google.maps.DirectionsService();
                    <?php
                    foreach ($shipmentData as $eachStop) {
                        $transportMode = $eachStop->transport_mode;
                        if (in_array(strtolower($transportMode), ['air-lcl', 'air-fcl', 'sea-lcl', 'sea-fcl'])) { ?>
                            var origin = new google.maps.LatLng(<?= $eachStop->plat ?>, <?= $eachStop->plng ?>)
                            var destination = new google.maps.LatLng(<?= $eachStop->dlat ?>, <?= $eachStop->dlng ?>)
                            var symbolTwo = {
                                path: "M11.5,39.2l1.7-1.7l-0.8-5.8l10.3-10.3L33,40l2.4-2.4l-5.9-22.9L39.1,5C39.7,4.4,40,3.7,40,2.9s-0.3-1.5-0.9-2.1C38.6,0.3,37.9,0,37.1,0c-0.8,0-1.5,0.3-2.1,0.9l-9.7,9.7L2.4,4.7L0,7l18.7,10.2L8.3,27.6l-5.8-0.8l-1.7,1.7l6.9,3.8L11.5,39.2z",
                                scale: 0.5,
                                strokeColor: "#333",
                                strokeOpacity: 1.0,
                                strokeWeight: 2,
                                rotation: 60,
                            };
                            var originMarker = new google.maps.Marker({
                                map,
                                draggable: true,
                                position: origin,
                                rotation: 45
                            });
                            var destinationMarker = new google.maps.Marker({
                                map,
                                draggable: true,
                                position: destination,
                            });

                            var geodesicPoly = new google.maps.Polyline({
                                path: [origin, destination],
                                strokeColor: "#1967d2",
                                strokeOpacity: 1.0,
                                strokeWeight: 3,
                                geodesic: true,
                                map: map,

                            });
                            markers.push([originMarker, destinationMarker])
                        <?php } else { ?>
                            var rendererOptions = {
                                map: map,
                                suppressMarkers: true,
                            };

                            directionsRenderer = new google.maps.DirectionsRenderer(rendererOptions);
                            calculateAndDisplayRoadMap(directionsService, directionsRenderer, <?= $eachStop->plat ?>, <?= $eachStop->plng ?>, <?= $eachStop->dlat ?>, <?= $eachStop->dlng ?>)
                            directionsRenderer.setMap(map);
                    <?php }
                    }
                    ?>

                    function calculateAndDisplayRoadMap(directionsService, directionsRenderer, plat, plng, dlat, dlng) {

                        var start = new google.maps.LatLng(plat, plng);
                        var end = new google.maps.LatLng(dlat, dlng);
                        var request = {
                            origin: start,
                            destination: end,
                            travelMode: google.maps.TravelMode.DRIVING
                        };
                        const selectedMode = "DRIVING";
                        directionsService.route(request, function(response, status) {
                            if (status == google.maps.DirectionsStatus.OK) {
                                directionsRenderer.setDirections(response);
                                directionsRenderer.setMap(map);
                                var route = response.routes[0].legs[0];
                                var legs = response.routes[0].overview_path;
                                var length = parseInt(legs.length / 2);
                                var midlat = legs[length].lat()
                                var midlng = legs[length].lng()
                                var middle = new google.maps.LatLng(midlat, midlng);
                                addMarker(start);
                                addMarker(end);

                            } else {
                                alert("Directions Request from " + start.toUrlValue(6) + " to " + end.toUrlValue(6) + " failed: " + status);
                            }
                        });
                    }

                    function addMarker(position) {
                        var marker = new google.maps.Marker({
                            position: position,
                            map: map,
                        });

                    }
                } else {
                    var iconn = getIconByAngle(0);
                    trafficLayer = new google.maps.TrafficLayer();
                    var centerControlDiv = document.createElement('div');
                    var centerControl = new CenterControl(centerControlDiv, googleMap);
                    centerControlDiv.index = 1;
                    googleMap.controls[google.maps.ControlPosition.TOP_CENTER].push(centerControlDiv);
                    var pos = new google.maps.LatLng(ulglat, ulglng);
                    bounds = new google.maps.LatLngBounds();
                    // vehicle = new google.maps.Marker({
                    //     position: pos,
                    //     map: googleMap,
                    //     icon: iconn
                    // });
                    var coords = [];
                    var coords1 = [];
                    var timestamp = "";
                    $timezone = "";

                    <?php
                    $trip_id = 0;
                    $order_id = $result[0]["order_id"];
                    for ($res_cnt = 0, $res_cntMax = count($result); $res_cnt < $res_cntMax; $res_cnt++) {
                        $timezone = $result[0]["timezone"];
                        $trip_id  = isset($result[$res_cnt]["trip_id"]) ? $result[$res_cnt]["trip_id"] : '';
                        if ($result[$res_cnt]['pings'] > 0 && $trip_id != '') {
                            $records_array = $result[$res_cnt]['actual_records'];
                            if (!empty($records_array)) {
                                foreach ($records_array->result() as $i => $row) {
                                    $lat1 = "";
                                    $lng1 = "";
                                    if ($row->latitude == "") {
                                        $data = getlatlngsbyplace($row->address);
                                        $lat1 = @$data[0];
                                        $lng1 = @$data[1];
                                    } else {
                                        $lat1 = @$row->latitude;
                                        $lng1 = @$row->longitude;
                                    }
                                    if ($i == 0) {
                    ?>
                                        pos = new google.maps.LatLng(<?php echo $lat1 ?>, <?php echo $lng1 ?>);
                                        var marker = new google.maps.Marker({
                                            position: pos,
                                            map: googleMap
                                        });
                                        marker.setIcon('http://maps.google.com/mapfiles/ms/icons/green-dot.png');
                                    <?php
                                    }
                                    if ($i <= $result[$res_cnt]['pings']) {
                                    ?>
                                        pos = new google.maps.LatLng(<?php echo $lat1 ?>, <?php echo $lng1 ?>);
                                        coords.push(pos);
                                        bounds.extend(pos);
                                        level1Bounds.extend(pos);
                            <?php }
                                }
                            }
                        } else { ?>
                            var position = new google.maps.LatLng(ulglat, ulglng);
                            bounds.extend(position);
                            level1Bounds.extend(position);
                            position = new google.maps.LatLng(orderDlat, orderDlng);
                            bounds.extend(position);
                            level1Bounds.extend(position);
                        <?php } ?>
                        if (coords.length > 0) {
                            vehicle.setPosition(pos);
                            var line = new google.maps.Polyline({
                                path: coords,
                                strokeColor: "#C32148",
                                strokeOpacity: 0.7,
                                strokeWeight: 8
                            });
                            line.setMap(googleMap);
                        }
                        getTripLocation(isSimBased, timestamp);
                        getAddress();
                    <?php }
                    ?>
                    $(".switch_map_view").click(function() {
                        if (showRoute == false) {
                            googleMap.fitBounds(level1Bounds);
                            showRoute = true;
                            $(this).html("View All");
                        } else {
                            googleMap.fitBounds(bounds);
                            showRoute = false;
                            $(this).html("View Vehicle");
                        }
                    });
                }
            });

            function getTripLocation(isSimBased, timestamp) {
                if (timestamp == "") {
                    /*console.clear();*/
                }
                $.ajax({
                    url: "<?= base_url() ?>livetrack/getTripLocation/<?php echo $result[0]["trip_id"]; ?>/" + timestamp,
                    data: {
                        'timezone': '<?php echo $result[0]["timezone"]; ?>'
                    },
                    type: "POST",
                    dataType: "JSON",
                    success: function(data) {
                        $.each(data.data, function(i, v) {
                            q.push(v);
                        });
                        if (q.length > 0) {
                            if (q.status == 1) {
                                var lastPoint = new google.maps.LatLng(q[q.length - 1].lat, q[q.length - 1].lng);
                                var d = q.shift();
                                var pos = new google.maps.LatLng(d.lat, d.lng);
                                if (timestamp != "") {
                                    startQueueProcessing();
                                    if (showRoute) {
                                        googleMap.fitBounds(level1Bounds);
                                    }
                                } else {
                                    vehicle.setPosition(pos);
                                }
                            }
                        }
                        if (data.data.length != 0) {
                            nextTimeStamp = data.data[data.data.length - 1].timestamp;
                        }
                        if (fnsts == "a") {
                            setTimeout(function() {
                                getTripLocation(isSimBased, nextTimeStamp);
                            }, trackerFrequency);
                        }
                    }
                });
            }

            function startQueueProcessing() {
                queueFunction();
                setInterval(function() {
                    queueFunction();
                }, trackerFrequency);
            }

            function queueFunction() {
                var data = q.shift();
                if (data != null && vehicle != null) {
                    angle = Math.round(data.course / 10);
                    vehicle.setIcon(getIconByAngle(angle));
                    var newPosition = new google.maps.LatLng(data.lat, data.lng);
                    var oldPosition = new google.maps.LatLng(vehicle.position.lat(), vehicle.position.lng());
                    bounds = new google.maps.LatLngBounds();
                    bounds.extend(vehicle.position);
                    bounds.extend(newPosition);
                    if (!showRoute) {
                        vehicle.animateTo(googleMap, newPosition, {
                            duration: trackerFrequency,
                            drawRoute: "draw"
                        });
                    } else {
                        vehicle.animateTo(googleMap, newPosition, {
                            duration: trackerFrequency,
                            dragMap: "no-stick",
                            drawRoute: "draw"
                        });
                    }
                }
            }

            function CenterControl(controlDiv, map) {
                var controlUI = document.createElement('div');
                controlUI.style.backgroundColor = '#fff';
                controlUI.style.boxShadow = 'rgba(0, 0, 0, 0.3) 0px 0px 6px';
                controlUI.style.cursor = 'pointer';
                controlUI.style.marginTop = '10px';
                controlUI.style.marginLeft = '-10px';
                controlUI.style.textAlign = 'center';
                controlUI.title = 'Click to view traffic in the map';
                controlDiv.appendChild(controlUI);

                var controlText = document.createElement('div');
                controlText.style.color = 'rgb(86, 86, 86)';
                controlText.style.fontFamily = 'Roboto,Arial,sans-serif';
                controlText.style.fontSize = '18px';
                controlText.style.lineHeight = '40px';
                controlText.style.paddingLeft = '17px';
                controlText.style.paddingRight = '17px';
                controlText.innerHTML = 'Traffic';
                controlUI.appendChild(controlText);

                controlUI.addEventListener('click', function() {
                    if (trafficFlag) {
                        trafficLayer.setMap(null);
                        trafficFlag = false;
                        controlText.style.color = 'rgb(86, 86, 86)';
                    } else {
                        trafficLayer.setMap(map);
                        trafficFlag = true;
                        controlText.style.color = 'black';
                    }
                });
            }

            // function calcRoute() {
            //     directionsService = new google.maps.DirectionsService();
            //     directionsDisplay = new google.maps.DirectionsRenderer();
            //     var start;
            //     var end;
            //     var waypts = [];
            //     var points = [];
            //     $("#map_wrapper_<?= $result[0]['order_id'] ?> .shipstoploc").each(function() {
            //         points.push({
            //             "lat": $(this).data("lat"),
            //             "lng": $(this).data("lng"),
            //             "tmode":$(this).data("tmode")
            //         });
            //     });
            //     if (points.length >= 2) {
            //         for (var i = 1; i < points.length - 1; i++) {
            //             if (i != 0) {
            //                 waypts.push({
            //                     location: new google.maps.LatLng(points[i].lat, points[i].lng),
            //                     stopover: true
            //                 });
            //             }
            //         }
            //         if (enableSeaMap > 0) {} else {
            //             var request = {
            //                 origin: new google.maps.LatLng(points[0].lat, points[0].lng),
            //                 destination: new google.maps.LatLng(points[points.length - 1].lat, points[points.length - 1].lng),
            //                 waypoints: waypts,
            //                 travelMode: google.maps.TravelMode.DRIVING
            //             };
            //             directionsService.route(request, function(response, status) {
            //                 if (status == google.maps.DirectionsStatus.OK) {
            //                     directionsDisplay.setDirections(response);
            //                     directionsDisplay.setMap(googleMap);
            //                 } else {
            //                     //console.log("Directions Request from " + start.toUrlValue(6) + " to " + end.toUrlValue(6) + " failed: " + status);
            //                 }
            //                 var bounds = new google.maps.LatLngBounds();
            //                 bounds.extend(new google.maps.LatLng(points[0].lat, points[0].lng));
            //                 bounds.extend(new google.maps.LatLng(points[points.length - 1].lat, points[points.length - 1].lng));
            //                 setTimeout(function() {
            //                     googleMap.fitBounds(bounds);
            //                 }, 1000);
            //             });

            //         }
            //     }
            // }

            googleMap = new google.maps.Map(document.getElementById("googleMap_<?= $result[0]['order_id']; ?>"), {
                center: {
                    lat: ulglat,
                    lng: ulglng
                },
                mapTypeControl: true,
                mapTypeControlOptions: {
                    style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                    position: google.maps.ControlPosition.TOP_CENTER
                },
                scaleControl: true,
                streetViewControl: true,
                streetViewControlOptions: {
                    position: google.maps.ControlPosition.TOP_CENTER,
                },
                zoom: 1,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                styles: [{
                    featureType: "all",
                    stylers: [{
                        saturation: 0
                    }, {
                        hue: "#e7ecf0"
                    }]
                }, {
                    featureType: "road",
                    stylers: [{
                        saturation: -70
                    }]
                }, {
                    featureType: "transit",
                    stylers: [{
                        visibility: "off"
                    }]
                }, {
                    featureType: "poi",
                    stylers: [{
                        visibility: "off"
                    }]
                }, {
                    featureType: "water",
                    stylers: [{
                        visibility: "simplified"
                    }, {
                        saturation: -60
                    }]
                }]
            });

            function initmap() {
                googleMap = new google.maps.Map(document.getElementById("googleMap_<?= $result[0]['order_id']; ?>"), {
                    center: {
                        lat: ulglat,
                        lng: ulglng
                    },
                    mapTypeControl: true,
                    mapTypeControlOptions: {
                        style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                        position: google.maps.ControlPosition.TOP_CENTER
                    },
                    scaleControl: true,
                    streetViewControl: true,
                    streetViewControlOptions: {
                        position: google.maps.ControlPosition.TOP_CENTER,
                    },
                    zoom: 1,
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    styles: [{
                        featureType: "all",
                        stylers: [{
                            saturation: 0
                        }, {
                            hue: "#e7ecf0"
                        }]
                    }, {
                        featureType: "road",
                        stylers: [{
                            saturation: -70
                        }]
                    }, {
                        featureType: "transit",
                        stylers: [{
                            visibility: "off"
                        }]
                    }, {
                        featureType: "poi",
                        stylers: [{
                            visibility: "off"
                        }]
                    }, {
                        featureType: "water",
                        stylers: [{
                            visibility: "simplified"
                        }, {
                            saturation: -60
                        }]
                    }]
                });

                calcRoute();
            }

            function calcRoute() {

                var directionsService = new google.maps.DirectionsService();
                var points = [];

                $("#map_wrapper_<?= $result[0]['order_id'] ?> .shipstoploc").each(function() {
                    points.push({
                        lat: parseFloat($(this).data("lat")),
                        lng: parseFloat($(this).data("lng")),
                        tmode: ($(this).data("tmode") || "").toUpperCase()
                    });
                });

                console.log("Points:", points);
                if (points.length < 2) return;

                const bounds = new google.maps.LatLngBounds();

                // Loop through each segment
                for (let i = 0; i < points.length - 1; i++) {
                    let start = new google.maps.LatLng(points[i].lat, points[i].lng);
                    let end = new google.maps.LatLng(points[i + 1].lat, points[i + 1].lng);
                    let mode = points[i + 1].tmode;

                    bounds.extend(start);
                    bounds.extend(end);

                    if (mode === "AIR") {
                        // airplane markers
                        const airStartMarker = new google.maps.Marker({
                            position: start,
                            map: googleMap,
                            title: "AIRPORT",
                            icon: {
                                url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
                                scaledSize: new google.maps.Size(30, 30)
                            }
                        });

                        markers.push(airStartMarker);

                        const airEndMarker = new google.maps.Marker({
                            position: end,
                            map: googleMap,
                            title: "AIRPORT",
                            icon: {
                                url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
                                scaledSize: new google.maps.Size(30, 30)
                            }
                        });

                        markers.push(airEndMarker);

                        const airPath = new google.maps.Polyline({
                            path: [start,end],
                            geodesic: true,
                            strokeColor: "#7b1c1cff",
                            strokeOpacity: 0,
                            strokeWeight: 3,
                            icons: [{
                                icon: {
                                    path: "M 0,-1 0,1",
                                    strokeOpacity: 1,
                                    scale: 4
                                },
                                offset: "0",
                                repeat: "20px"
                            }],
                            map: googleMap
                        });
                        polylines.push(airPath);

                        let count = 0;
                        window.setInterval(() => {
                            count = (count + 1) % 200;

                            const icons = airPath.get('icons');
                            icons[0].offset = (count / 2) + '%'; // shift dots
                            airPath.set('icons', icons);
                        }, 100); // adjust speed here
                        fitBoundsZoom(googleMap, start, end);

                    } else if (mode === "RAIL") {
                        let railRenderer = new google.maps.DirectionsRenderer({
                            suppressMarkers: true,
                            preserveViewport: true,
                            polylineOptions: {
                                strokeColor: "#007400", // red
                                strokeOpacity: 0.8, // transparency
                                strokeWeight: 6 // thickness
                            }
                        });
                        railRenderer.setMap(googleMap);
                        // transit request
                        const railStartMarker = new google.maps.Marker({
                            position: start,
                            map: googleMap,
                            title: "Railway Station",
                            icon: {
                                url: "https://img.icons8.com/ios-filled/50/train.png",
                                scaledSize: new google.maps.Size(25, 25)
                            }
                        });

                        markers.push(railStartMarker);

                        const railEndMarker = new google.maps.Marker({
                            position: end,
                            map: googleMap,
                            title: "Railway Station",
                            icon: {
                                url: "https://img.icons8.com/ios-filled/50/train.png",
                                scaledSize: new google.maps.Size(25, 25)
                            }
                        });

                        markers.push(railEndMarker);

                        const request = {
                            origin: start,
                            destination: end,
                            travelMode: google.maps.TravelMode.TRANSIT,
                            transitOptions: {
                                modes: ['RAIL']
                            }
                        };


                        directionsService.route(request, function(result, status) {
                            if (status === google.maps.DirectionsStatus.OK) {
                                railRenderer.setDirections(result);
                                fitBoundsZoom(googleMap, start, end);
                            } else {
                                alert("Unable to plot road route.");
                            }
                        });

                    } else {
                        let roadRenderer = new google.maps.DirectionsRenderer({
                            suppressMarkers: true,
                            preserveViewport: true
                        });
                        roadRenderer.setMap(googleMap);
                        // road fallback
                        const startMarker = new google.maps.Marker({
                            position: start,
                            map: googleMap,
                            title: "Pickup Location",
                            icon: {
                                url: "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>",
                                scaledSize: new google.maps.Size(25, 25)
                            }
                        });
                        markers.push(startMarker);

                        const endMarker = new google.maps.Marker({
                            position: end,
                            map: googleMap,
                            title: "Delivery Location",
                            icon: {
                                url: "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
                                scaledSize: new google.maps.Size(25, 25)
                            }
                        });
                        markers.push(endMarker);
                        // Road transport (Driving)
                        const request = {
                            origin: start,
                            destination: end,
                            travelMode: google.maps.TravelMode.DRIVING
                        };

                        directionsService.route(request, function(result, status) {
                            if (status === google.maps.DirectionsStatus.OK) {
                                roadRenderer.setDirections(result);
                                fitBoundsZoom(googleMap, start, end);
                            } else {
                                alert("Unable to plot road route.");
                            }
                        });
                    }
                }

                // finally adjust map to all points
                googleMap.fitBounds(bounds);
            }

            function clearPolylines() {
                if (polylines && polylines.length) {
                    polylines.forEach(p => p.setMap(null)); // remove from map
                }
                polylines = [];
            }

            function fitBoundsZoom(googleMap, start, end) {
                const bounds = new google.maps.LatLngBounds();
                bounds.extend(start);
                bounds.extend(end);

                googleMap.fitBounds(bounds);

                const listener = google.maps.event.addListener(googleMap, "bounds_changed", function() {
                    if (googleMap.getZoom() > 15) {
                        googleMap.setZoom(15);
                    }
                    google.maps.event.removeListener(listener);
                });
            }

            function clearBranchMarkers() {
                markers.forEach(marker => marker.setMap(null));
                markers.length = 0;
            }


            function getIconByAngle(angle) {
                return "<?= base_url() ?>assets/tracking/images/map_marker_2.svg";
            }

            function reloadLocation(ele) {
                getAddress();
            }

            function getAddress() {
                var latlng = vehicle.position
                // This is making the Geocode request
                var geocoder = new google.maps.Geocoder();
                geocoder.geocode({
                    'latLng': latlng
                }, function(results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        var address = (results[0].formatted_address);
                        $(".locationName").html(address + " <div class='btn btn-xs btn-default' onclick='reloadLocation(this)'><i class='fa fa-fa fa-refresh'></i></div>");
                    }
                });
            }

    <?php }
    } ?>
    $("#cover-spin").hide();
</script>
<!-- Init js -->
<style type="text/css">
    @keyframes glowing {
        0% {
            background-color: #0A5797;
            box-shadow: 0 0 3px #0A5797;
        }

        50% {
            background-color: #0A5797;
            box-shadow: 0 0 10px #0A5797;
        }

        100% {
            background-color: #0A5797;
            box-shadow: 0 0 3px #0A5797;
        }
    }

    .liveships {
        animation: glowing 1500ms infinite;
    }

    .btn-success {
        background-color: #0a5797 !important;
        border-color: #0a5797 !important;
    }

    @media only screen and (max-width: 768px) {
        .visible-sm-block {
            display: block !important
        }
    }

    @media only screen and (max-width: 600px) {
        .visible-sm-block {
            display: block !important
        }
    }

    @media only screen and (min-width: 768px) {
        .visible-sm-block {
            display: none !important;
        }
    }

    #map {
        height: 100%;
        width: 100%;
    }

    .search-panel {
        border-radius: 0;
        margin-bottom: 8px;
    }
</style>
<style type="text/css">
    .tt_box {
        padding: 0px;
        border: 1px solid #dcdcdc;
        background: white;
        margin: 8px;
        border-radius: 4px;
        box-shadow: 0px 0px 8px 4px #dcdcdc;
    }

    .tt_box1 {
        padding: 0px;
        border: 1px solid #dcdcdc;
        background: white;
        margin: 8px;
        border-radius: 4px;
        box-shadow: 0px 0px 8px 4px #dcdcdc;
    }

    .tt_box_title {
        padding: 4px;
        text-align: center;
        background: #808080e3;
        /*#dcdcdc;*/
        color: white;
    }

    .tt_box_body {
        padding: 8px;
    }

    .tt_card {
        padding: 0px 20px;
    }

    .tt_card_value {
        text-align: right;
        font-size: 12px;
        font-weight: 400;
        overflow: hidden;
        max-height: 20px;
    }

    .tt_card_title {
        text-align: right;
        font-size: 12px;
        padding: 8px 0px;
    }

    .tt_card_row i {
        color: #244062;
        font-size: 32px;
        padding: 0px 0px;
    }

    .tt_card_row img {
        color: #244062;
        padding: 5px 0px;
    }

    .tt_card_row {
        background: #ffffff;
        border: 1px solid gainsboro;
        border-radius: 8px;
        padding: 8px;
        box-shadow: 0px 0px 8px 4px #dcdcdc;
    }

    .tt_bottom_pane {
        margin: 0px;
        padding: 16px 0px;
        height: calc(100vh - 180px);
    }

    .tt_dd_value {
        font-size: 16px;
        font-weight: 600;
        text-align: right;
    }

    .tt_dd_label {
        font-size: 12px;
        color: gray;
        text-align: right;
    }

    .tt_os_received_time {
        font-size: 12px;
        color: gray;
        text-align: center;
    }

    .tt_os_location i {
        color: #3C969F;
        margin-right: 8px;
    }

    .tt_os_title {
        font-size: 12px;
        text-align: center;
    }

    .tt_os_location {
        text-align: center;
        overflow: hidden;
    }

    .tt_ld_date {
        font-size: 12px;
        color: gray;
        margin-left: 24px;
    }

    .tt_ld_address {
        display: block;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
    }

    .tt_ld_address i {
        color: #65b3f1;
        margin-right: 8px;
    }

    .tt_value {
        font-size: 16px;
        overflow: auto;
    }

    .tt_head {
        font-size: 12px;
        color: gray;
        margin-top: 8px;
    }

    .hide {
        display: none;
    }

    #googleMap {
        border: 1px solid #dcdcdc;
        box-shadow: 0px 0px 8px 4px #dcdcdc;
        border-radius: 4px;
    }

    .rt-tab-pane {
        display: block;
        max-height: calc(100vh - 226px);
        overflow-y: auto;
        padding: 8px;
        overflow-x: hidden;
    }

    .table-bordered.custom-blue-color>thead>tr>th,
    .table-bordered.custom-blue-color>tbody>tr>th,
    .table-bordered.custom-blue-color>tfoot>tr>th,
    .table-bordered.custom-blue-color>thead>tr>td,
    .table-bordered.custom-blue-color>tbody>tr>td,
    .table-bordered.custom-blue-color>tfoot>tr>td {
        border: 1px solid #cecbcb;
    }

    .custom-blue-color th {
        background: rgb(36, 64, 98);
        color: white;
    }

    .nav-tabs>li>a {
        margin-right: 2px;
        line-height: 1.42857143;
        border: 1px solid transparent;
        border-radius: 4px 4px 0 0;
        padding: 2px 8px;
    }

    .no-padding {
        padding-left: 2px;
        padding-right: 2px;
    }

    .tt_click {
        cursor: pointer;
    }

    .shiment-title h5 {
        margin: 0px;
    }

    .tt_click:hover {
        background: #fbf9f9;
    }

    .visualization_tab .progress {
        height: 12px;
        margin-bottom: 6px;
    }

    .list-details-box {
        overflow-y: scroll;
    }
</style>