<?php

$switches = $quickbookData['quickbookSwitches'] ?? [];
$documentTypes = $quickbookData['documentTypes'] ?? [];
$countryMaster = $quickbookData['countryMaster'] ?? [];
$orderStops = $quickbookData['stops'] ?? [];
$transport = $quickbookData['transport'] ?? [];
$service = $quickbookData['service'] ?? [];
$orderTypes = $quickbookData['orderTypes'] ?? [];
$vasMasterData = $quickbookData['vasMasterData'] ?? [];
$customerRowId = $customerRowId ?? $this->session->userdata('cust_id');
$companyCode = $companyCode ?? $this->session->userdata('company_code');

$orderRowId = $orderDetails['orderRowId'] ?? 0;
$orderTotalVolume = $orderDetails['orderTotalVolume'] ?? 0;
$orderTotalWeight = $orderDetails['orderTotalWeight'] ?? 0;
$ordersTableData = $orderDetails['ordersTableData'] ?? [];
$orderDgDetails = $orderDetails['orderDgDetails'] ?? [];
$orderDetailsTableData = $orderDetails['orderDetailsTableData'] ?? [];
$orderAddons = $orderDetails['orderAddons'] ?? [];
$orderCargos = $orderDetails['orderCargos'] ?? [];
$orderPartyDetails = $orderDetails['orderPartyDetails'] ?? [];
$orderReferences = $orderDetails['orderReferences'] ?? [];
$orderCharges = $orderDetails['orderCharges'] ?? [];
$orderDocuments = $orderDetails['orderDocuments'] ?? [];
$orderPartyIds = $orderDetails['orderPartyIds'] ?? [];
$shipperRowId = $orderPartyIds['shipper']['rowId'] ?? 0;
$consigneeRowId = $orderPartyIds['shipper']['rowId'] ?? 0;
$pickupRowId = $orderPartyIds['pickup']['rowId'] ?? $shipperRowId;
$deliveryRowId = $orderPartyIds['delivery']['rowId'] ?? $consigneeRowId;

?>
<form method="POST" action="<?= base_url() ?>svkCustomer/CustomerOrders/saveQuickbook" onsubmit="return validateQuickbook();" id="quickbookForm">
    <div class="popUploadRowIdsDevTag"></div>
    <div class="cargoRowIdsDevTag">
        <?php
        foreach ($orderCargos as $eachCargo): ?>
            <input type='checkbox' form='quickbookForm' name='cargoRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='cargoRowIds_<?= $eachCargo['cargoRowId'] ?>' value='<?= $eachCargo['cargoRowId'] ?>' style='display: none;' checked>
        <?php
        endforeach;
        foreach ($orderDgDetails as $eachInput):
            echo $eachInput;
        endforeach;
        ?>
    </div>
    <div class="dgGoodsRowIdsDevTag"></div>
    <input type="hidden" name="customerRowId" id="customerRowId" value="<?= $customerRowId ?>">
    <input type="hidden" name="orderRowId" id="orderRowId" value="<?= $orderRowId ?>">
</form>
<div class="card-box">
    <div class="row">
        <div class="col-lg-9 col-md-12 col-sm-12">
            <div class="row">
                <div class="col-sm-12">
                    <h1 class="main_title">Booking Details</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 lineRight">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/pickup.svg">
                                </div>
                                <p>Pickup address</p>
                                <p><span id="shipperNameInfo">
                                        <?php
                                        if ($orderRowId > 0): ?>
                                            <?= $ordersTableData['pickup_company'] ?? "" ?>
                                        <?php
                                        endif; ?>
                                    </span></p>
                                <p id="shipperAddressInfo">
                                    <?php
                                    if ($orderRowId > 0):
                                        $pickupCity = $ordersTableData['pickup_city'] ?? "";
                                        $pickupCountry = $ordersTableData['pickup_country'] ?? "";
                                        ?>
                                        <?= $pickupCity . "," . $pickupCountry ?>
                                    <?php
                                    endif; ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/delivery.svg">
                                </div>
                                <p>Delivery address</p>
                                <p><span id="consigneeNameInfo">
                                        <?php
                                        if ($orderRowId > 0): ?>
                                            <?= $ordersTableData['delivery_company'] ?? "" ?>
                                        <?php
                                        endif; ?>
                                    </span></p>
                                <p id="consigneeAddressInfo">
                                    <?php
                                    if ($orderRowId > 0):
                                        $deliveryCity = $ordersTableData['delivery_city'] ?? "";
                                        $deliveryCountry = $ordersTableData['delivery_country'] ?? "";
                                        ?>
                                        <?= $deliveryCity . "," . $deliveryCountry ?>
                                    <?php
                                    endif; ?>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20 colum-p">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/weight.svg">
                                </div>
                                <p>Weight</p>
                                <input type="hidden" name="totalWeightInput" class="customerQuickbookDropDown" id="totalWeightInput" value="0">
                                <p><span id="totalWeight"><?= $orderTotalWeight ?? 0 ?></span></p>
                                <div class="mt-2">
                                    <p>Actual Volume</p>
                                    <input type="hidden" name="totalVolumeInput" class="customerQuickbookDropDown" id="totalVolumeInput" value="<?= $orderTotalWeight ?? 0 ?>">
                                    <input type="hidden" name="totalQuantityInput" class="customerQuickbookDropDown" id="totalQuantityInput" value="<?= $orderTotalVolume ?? 0 ?>">
                                    <p><span id="totalVolume"><?= $orderTotalVolume ?? 0 ?></span></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="colum  ptd-20 lineRight">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/weight.svg">
                                </div>
                                <p>Distance</p>
                                <p><span id="distanceIcon"></span></p>
                                <?php
                                if (in_array('Show Map', $switches, true)): ?>
                                    <div class="mt-2 map-icon">
                                        <p><a href="#" class="mapTaggle" onclick="toggleMap()"><i class="fa fa-map-marker-alt"></i>Map</a></p>
                                    </div>
                                <?php
                                endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="showMap" style="display: none">
            <button type="button" class="close showMapClose" onclick="closeMapPopup()">&times;</button>
            <div id="map">
            </div>
        </div>

        <div class="col-lg-3 col-md-12 col-sm-12">
            <?php
            if (in_array('Show Quotes', $switches, true)): ?>
                <div class="colum  ptd-20 blueActiveBg colortext" style="height: 80px;">
                    <div class="ptd">
                        <div class="iconBox">
                            <img src="<?= base_url() ?>assets/svkCustomer/images/total.svg">
                        </div>
                        <p>Indicative Price</p>
                        <p><span id="totalCharges"></span></p>
                        <p><small>(Taxes will be Applicable)</small></p>
                    </div>
                </div>
            <?php
            endif; ?>
        </div>
    </div>
    <hr>
    <!-- end row -->
    <div class="row inputMainHeight">
        <div class="col-lg-6 col-md-12 col-sm-12 pd-left lineRight">
            <form>
                <div class="row">
                    <div class="col-md-12">
                        <h1 class="main_title">Pick Up</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="shipperCode" class="form-label">Shipper ID </label>
                            <?php
                            $pickupCode = $orderPartyDetails[$pickupRowId]['code'] ?? "" ?>
                            <br><span><?= $pickupCode ?></span>
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperRowId" name="shipperRowId" value="<?= $pickupRowId ?? 0 ?>">
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperLatitude" name="shipperLatitude" value="<?= $ordersTableData['plat'] ?? "" ?>">
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperLongitude" name="shipperLongitude" value="<?= $ordersTableData['plng'] ?? "" ?>">
                        </div>
                    </div>
                    <!-- Modal -->

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="ShipperName" class="form-label">Shipper Name </label>
                            <br><span><?= $ordersTableData['pickup_company'] ?? "" ?> </span>
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="contactperson" class="form-label">Contact person</label>
                            <br><span><?= $ordersTableData['pickup_company'] ?? "" ?></span>
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Date" class="form-label">Estimated Pickup Date </label>
                            <br><span><?= $ordersTableData['pickup_datetime'] ?? "" ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="findAddress" class="form-label">Shipper Address</label>
                            <?php
                            $pickupCity = $ordersTableData['pickup_city'] ?? "";
                            $pickupState = $ordersTableData['pickup_address2'] ?? "";
                            $pickupCountry = $ordersTableData['pickup_country'] ?? "";
                            $pickupAddress = $pickupCity . " , " . $pickupState . " , " . $pickupCountry;
                            ?>
                            <br><span><?php
                                if ($orderRowId > 0): echo $pickupAddress; endif; ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="customerAccount" class="form-label">Country</label>
                            <br><span><?= $pickupCountry ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Street" class="form-label">Street</label>
                            <br><span><?= $ordersTableData['pickup_address1'] ?? "" ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Suburb" class="form-label">Suburb</label>
                            <br><span><?= $pickupState ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="cityTown" class="form-label">City / Town</label>
                                    <br><span><?= $pickupCity ?></span>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="postalCode" class="form-label">Postal Code</label>
                                    <br><span><?= $ordersTableData['pickup_pincode'] ?? "" ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Phone" class="form-label">Phone</label>
                            <?php
                            $pickupPhone = $orderPartyDetails[$pickupRowId]['mobile'] ?? "" ?>
                            <br><span><?= $pickupPhone ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Email" class="form-label">Email</label>
                            <?php
                            $pickupEmail = $orderPartyDetails[$pickupRowId]['email'] ?? "" ?>
                            <br><span><?= $pickupEmail ?></span>
                        </div>
                    </div>
                </div>

            </form>
        </div>
        <div class="col-lg-6 col-md-12 col-sm-12 pd-right">
            <form>
                <div class="row">
                    <div class="col-md-12">
                        <h1 class="main_title">Delivery</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="consigneeCode" class="form-label">Consignee ID </label>
                            <?php
                            $deliveryCode = $orderPartyDetails[$deliveryRowId]['code'] ?? "" ?>
                            <br><span><?= $deliveryCode ?></span>
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeRowId" name="consigneeRowId" value="<?= $deliveryRowId ?? 0 ?>">
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeLatitude" name="consigneeLatitude" value="<?= $ordersTableData['dlat'] ?? "" ?>">
                            <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeLongitude" name="consigneeLongitude" value="<?= $ordersTableData['dlng'] ?? "" ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="companyName" class="form-label">Consignee Name</label>
                                    <br><span><?= $ordersTableData['delivery_company'] ?? "" ?></span>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="contactperson" class="form-label">Contact person</label>
                            <br><span><?= $ordersTableData['delivery_company'] ?? "" ?></span>
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Date" class="form-label">Estimated Delivery Date </label>
                            <br><span><?= $ordersTableData['delivery_datetime'] ?? "" ?></span>
                        </div>
                    </div>
                    <?php
                    $deliveryCity = $ordersTableData['delivery_city'] ?? "";
                    $deliveryState = $ordersTableData['delivery_address2'] ?? "";
                    $deliveryCountry = $ordersTableData['delivery_country'] ?? "";
                    $deliveryAddress = $deliveryCity . " , " . $deliveryState . " , " . $deliveryCountry;
                    ?>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="findAddress" class="form-label">Consignee Address</label>
                            <br><span><?php
                                if ($orderRowId > 0): echo $deliveryAddress; endif; ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="customerAccount" class="form-label">Country</label>
                            <br><span><?= $deliveryCountry ?></span>
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Street" class="form-label">Street</label>
                            <br><span><?= $ordersTableData['delivery_address1'] ?? "" ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Suburb" class="form-label">Suburb</label>
                            <br><span><?= $deliveryState ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="cityTown" class="form-label">City / Town</label>
                                    <br><span><?= $deliveryCity ?></span>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="postalCode" class="form-label">Postal Code</label>
                                    <br><span><?= $ordersTableData['delivery_pincode'] ?? "" ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Phone" class="form-label">Phone</label>
                            <?php
                            $deliveryPhone = $orderPartyDetails[$deliveryRowId]['mobile'] ?? "" ?>
                            <br><span><?= $deliveryPhone ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Email" class="form-label">Email</label>
                            <?php
                            $deliveryemail = $orderPartyDetails[$deliveryRowId]['email'] ?? "" ?>
                            <br><span><?= $deliveryemail ?></span>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- end row -->
    <div class="row additionalServicesCards">
        <div class="col-lg-5 col-md-12 col-sm-12">
            <div class="card-box1 as-minHeightCard  card-box-heading">
                <div class="row">
                    <div class="col-lg-6 borderrightorder">
                        <h2>Order Attributes</h2>
                        <div class="paddingCol1">
                            <div class="referencesBlockCard paddRight">
                                <div class="form-group">
                                    <i class="fa fa-inbox icon_Order" aria-hidden="true"></i>
                                    <label class="form-label">Order Type</label>
                                    <br>
                                    <?php
                                    $ordersOrderType = $orderDetailsTableData['order_type'] ?? 0;
                                    foreach ($orderTypes

                                    as $eachType): ?>
                                    <span> <?php
                                        if ($ordersOrderType === $eachType['type_id']) : echo $eachType['type_name']; endif; ?><span>
                                        <?php
                                        endforeach;
                                        ?>
                                </div>

                                <div class="form-group">
                                    <i class="fa fa-snowflake-o icon_Order" aria-hidden="true"></i>
                                    <label class="form-label">Service</label>
                                    <br>
                                    <?php
                                    $ordersServiceType = $orderDetailsTableData['service'] ?? 0;
                                    foreach ($service

                                    as $eachType): ?>
                                    <span> <?php
                                        if ($ordersServiceType === $eachType['row_id']) : echo $eachType['id'] . "-" . $eachType['name']; endif; ?><span>
                                        <?php
                                        endforeach;
                                        ?>
                                </div>
                                <div class="form-group">
                                    <i class="icon tru-icon-truck-emp icon_Order" aria-hidden="true"></i>
                                    <label class="form-label">Mode Of Transport</label>
                                    <br>
                                    <?php
                                    $ordersTransportMode = $ordersTableData['transport_mode'] ?? "";
                                    foreach ($transport as $eachType): ?>
                                        <span><?php
                                            if ($ordersTransportMode === $eachType['code']) : echo $eachType['name']; endif; ?></span>
                                    <?php
                                    endforeach;
                                    ?>
                                </div>
                                <div class="form-group">
                                    <i class="fa fa-comment icon_Order_References" aria-hidden="true"></i>
                                    <label class="form-label">Pickup Instructions</label>
                                    <br>
                                    <span><?= $orderReferences['ORD_PIKINST'] ?? "" ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 pd-References">
                        <h2>References</h2>
                        <div class="paddingCol2">
                            <div class="referencesBlockCard paddLeft">
                                <div class="form-group mb-3">
                                    <i class="fa fa-file-text icon_References" aria-hidden="true"></i>
                                    <label class="form-label">DQ/Customer reference</label>
                                    <br>
                                    <span><?= $orderReferences['DQ'] ?? "" ?></span>
                                </div>

                                <div class="form-group mb-3">
                                    <i class="fa fa-file-text icon_References" aria-hidden="true"></i>
                                    <label class="form-label">Purchase Order</label>
                                    <br>
                                    <span><?= $orderReferences['PO'] ?? "" ?></span>
                                </div>
                                <div class="form-group">
                                    <i class="fa fa-comment icon_Order_References" aria-hidden="true"></i>
                                    <label class="form-label">Delivery Instructions</label>
                                    <br>
                                    <span><?= $orderReferences['ORD_DLVINST'] ?? "" ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if (in_array('Show Services', $switches, true)):
            ?>
            <div class="col-lg-3 col-md-12 col-sm-12">
                <div class="card-box1 as-minHeightCard card-box-heading">
                    <h2>Additional Services</h2>
                    <?php
                    if (empty($orderAddons)):
                        $servicesStyle = "text-align:center;";
                        $noData = "<img src='" . base_url() . "/assets/svkCustomer/images/nodata.png'><p>No Data Available</p>";
                    endif;?>
                    <div class="paddingCol" style="<?= $servicesStyle ?? ''?>">
                        <?php
                       echo $noData ?? "";
                        foreach ($vasMasterData as $eachLine): ?>
                            <div class="">
                                <span><?php
                                    if (in_array($eachLine['rowId'], $orderAddons, true)) : echo $eachLine['vasId'] . " - " . $eachLine['vasName']; endif; ?></span>
                            </div>
                        <?php
                        endforeach;
                        ?>
                    </div>
                </div>
            </div>
        <?php
        endif; ?>
        <?php
        if (in_array('Show Quotes', $switches, true)):
            $emptyChargesStyle = "height: 175px;overflow: auto";
            $chargesDataStyle = "display: none;height: 175px;overflow: auto";
            if (!empty($orderCharges)):
                $emptyChargesStyle = "display: none;height: 175px;overflow: auto";
                $chargesDataStyle = "height: 175px;overflow: auto";
            endif;
            ?>
            <div class="col-lg-4 col-md-12 col-sm-12">
                <div class="card-box1 as-minHeightCard  card-box-heading">
                    <h2> Charges</h2>
                    <div class="table-responsive quickbookTables" id="orderChargesTableDivTag" style="<?= $chargesDataStyle ?>">
                        <table class="table additionalServicesTable">
                            <thead>
                            <tr>
                                <th>Rate ID</th>
                                <th>Vas ID</th>
                                <th>Charge ID</th>
                                <th>Amount</th>
                            </tr>
                            </thead>
                            <tbody id="chargesBodyTable">
                            <?php
                            foreach ($orderCharges as $eachChargeLine): ?>
                                <tr>
                                    <td><?= $eachChargeLine['rate_id'] ?></td>
                                    <td></td>
                                    <td><?= $eachChargeLine['charge_code'] ?></td>
                                    <td><?= $eachChargeLine['amount'] . " " . $eachChargeLine['currency'] ?></td>
                                </tr>
                            <?php
                            endforeach;
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="table-responsive quickbookTables" id="emptyChargesTableDivTag" style="<?= $emptyChargesStyle ?>">
                        <table class="table additionalServicesTable">
                            <thead>
                            <tr>
                                <th>Rate ID</th>
                                <th>Vas ID</th>
                                <th>Charge ID</th>
                                <th>Amount</th>
                            </tr>
                            </thead>
                            <tbody class="text-center">
                            <tr>
                                <td colspan="4"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                    <p>No Data Available</p>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php
        endif; ?>
        <?php
        if (!in_array('Show Quotes', $switches, true) && !in_array('Show Services', $switches, true)) : ?>
            <div class="col-lg-7 col-md-12 col-sm-12" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Services And Show Quote Switches Disabled.</p>
            </div>
        <?php
        endif; ?>
        <?php
        if (!in_array('Show Quotes', $switches, true) && in_array('Show Services', $switches, true)) : ?>
            <div class="card-box1 as-minHeightCard  card-box-heading" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Quote Switch is Disabled.</p>
            </div>
        <?php
        endif; ?>

        <?php
        if (in_array('Show Quotes', $switches, true) && !in_array('Show Services', $switches, true)) : ?>
            <div class="card-box1 as-minHeightCard  card-box-heading" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Services Switch is Disabled.</p>
            </div>
        <?php
        endif; ?>
    </div>


    <!-- end bgGrey -->
    <div class="row cargoDetails_main">

        <div class="col-md-8">
            <div class="borderLine">
                <div class="bgGrey mb-15 mt-15">
                    <div class="row ">
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <h2 class="main_title">Cargo Details</h2>
                        </div>
                    </div>
                </div>
                <?php
                $cargosMasterData = $quickbookData['cargosMasterData'] ?? []; ?>
                <?php
                $emptyCargosStyle = "";
                $cargosDataStyle = "display: none;";
                if (!empty($orderCargos)):
                    $emptyCargosStyle = "display: none";
                    $cargosDataStyle = "";
                endif;
                ?>
                <div class="row cargoDetails_table" id="orderCargosTableDivTag" style="<?= $cargosDataStyle ?>">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="table-responsive quickbookTables">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Package Type</th>
                                    <th>Quantity</th>
                                    <th>Weight (Kg)</th>
                                    <th>Actual Volume (cbm)</th>
                                    <th>Dimensions (cm)</th>
                                </tr>
                                </thead>
                                <tbody id="orderCargoTableBody">
                                <?php
                                foreach ($orderCargos as $eachCargo):
                                    ?>
                                    <tr class="cargoRow_<?= $eachCargo['cargoRowId'] ?> newCargos">
                                        <td><?= $eachCargo['quantityType'] ?></td>
                                        <td><?= $eachCargo['cargoContent'] ?></td>
                                        <td><?= $eachCargo['quantity'] ?></td>
                                        <td><?= $eachCargo['weight'] ?></td>
                                        <td><?= $eachCargo['volume'] ?>
                                            <span class="cargoCheckBoxValues" id="cargoStackableValue_<?= $eachCargo['cargoRowId'] ?>">_<?= $eachCargo['stackable'] > 0 ? 'true' : 'false' ?></span>
                                            <span class="cargoCheckBoxValues" id="cargoGroundedValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['grounded'] > 0 ? 'true' : 'false' ?></span>
                                            <span class="cargoCheckBoxValues" id="cargoSplittableValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['splittable'] > 0 ? 'true' : 'false' ?></span>
                                            <span class="cargoCheckBoxValues" id="cargoDgValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['dgGoods'] > 0 ? 'true' : 'false' ?></span>
                                        </td>
                                        <td><?= $eachCargo['length'] . " x " . $eachCargo['width'] . " x " . $eachCargo['height'] ?></td>
                                    </tr>
                                <?php
                                endforeach;
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
                <!-- end cargo Details table -->
                <div class="row cargoDetails_table" id="emptyCargoTableDivTag" style="<?= $emptyCargosStyle ?>">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="table-responsive quickbookTables">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Package Type</th>
                                    <th>Quantity</th>
                                    <th>Weight (Kg)</th>
                                    <th>Actual Volume (cbm)</th>
                                    <th>Dimensions (cm)</th>
                                </tr>
                                </thead>
                                <tbody class="text-center">
                                <tr>
                                    <td colspan="6"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                        <p>No Data Available</p>
                                    </td>

                                </tr>


                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-md-4 ">
            <div class="borderLine">

                <div class="bgGrey mb-15 mt-15">
                    <div class="row ">
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <h2 class="main_title">Documents</h2>
                        </div>
                    </div>
                </div>
                <?php
                $emptyDocumentStyle = "";
                $documentDataStyle = "display: none";
                if (!empty($orderDocuments)):
                    $emptyDocumentStyle = "display: none";
                    $documentDataStyle = "";
                endif;
                ?>
                <div class="row pd-101">
                    <div class="col-lg-12 col-md-12 col-sm-12" id="orderPodUploadsTableDivTag" style="<?= $documentDataStyle ?>">
                        <div class="table-responsive quickbookTables">
                            <table class="table documents_main">
                                <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Document Name</th>
                                    <th>Date</th>
                                </tr>
                                </thead>
                                <tbody id="orderPodUploadsTableBody">
                                <?php
                                foreach ($orderDocuments as $eachRow): ?>
                                    <tr>
                                        <td><?= $eachRow['typeName'] ?></td>
                                        <td><?= $eachRow['path'] ?></td>
                                        <td><?= Date('Y-m-d', strtotime($eachRow['date'])) ?></td>
                                    </tr>
                                <?php
                                endforeach;
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12" id="emptyPodUploadsDivTag" style="<?= $emptyDocumentStyle ?>">
                        <div class="table-responsive quickbookTables">
                            <table class="table documents_main">
                                <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Document Name</th>
                                    <th>Date</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td colspan="4" align="center"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                        <p>No Data Available</p>
                                    </td>

                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal -->
        </div>
        <!-- end cargo Details -->
        <!-- Modal -->
        <div class="dgModal_main custModal" style="display: none">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close dgModal_mainClose" onclick="closeDgModalPopup()">&times;</button>
                        <h4 class="modal-title">Dg Goods </h4>
                    </div>
                    <div class="modal-body">
                        <div class="dg_goods_pd">
                            <form method="POST" action="<?= base_url() ?>svkCustomer/CustomerOrders/saveDangerousGoodsForCargo" id="saveDangerousGoods">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group  mb-3">
                                            <label class="form-label">UN Code</label>
                                            <div class="input-group">
                                                <input type="hidden" form="saveDangerousGoods" name="dgorderRowId" id="dgorderRowId" value="<?= $orderRowId ?>">
                                                <input type="text" form="saveDangerousGoods" name="dgUnCode" id="dgUnCode" class="form-control dgPopupFields" readonly>
                                                <div onclick="displayDgUncodeModal()" class="myModal_lookup input-group-addon" style="cursor:pointer;"><span class="icon  tru-icon-action-setting"></span></div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Name</label>
                                            <input type="text" form="saveDangerousGoods" name="dgUnCodeName" id="dgUnCodeName" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Class</label>
                                            <input type="text" form="saveDangerousGoods" name="dgUnCodeClass" id="dgUnCodeClass" class="form-control dgPopupFields">
                                            <input type="hidden" form="saveDangerousGoods" name="dgRowId" id="dgRowId" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Packing Group</label>
                                            <input type="text" form="saveDangerousGoods" id="dgUnCodePackingGroup" name="dgUnCodePackingGroup" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">N.O.S</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNos" id="dgNos" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Tunnel Code</label>
                                            <input type="text" form="saveDangerousGoods" name="dgTunnelCode" id="dgTunnelCode" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Number of Packages</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNoOfPackages" id="dgNoOfPackages" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Package Type</label>
                                            <input type="text" form="saveDangerousGoods" name="dgPackageType" id="dgPackageType" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Gross Weight (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgGrossWeight" id="dgGrossWeight" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Net Weight (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNetWeight" id="dgNetWeight" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Net Explosive Mass (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNetExplosiveMass" id="dgNetExplosiveMass" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Liters</label>
                                            <input type="text" form="saveDangerousGoods" name="dgLiters" id="dgLiters" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Limited Quantity</label>
                                            <input type="text" form="saveDangerousGoods" name="dgLimitedQuantity" id="dgLimitedQuantity" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Expected Quantity</label>
                                            <input type="text" form="saveDangerousGoods" name="dgExpectedQuantity" id="dgExpectedQuantity" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Environmentally</label>
                                            <input type="text" form="saveDangerousGoods" name="dgEnvironmentally" id="dgEnvironmentally" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Fireworks Information</label>
                                            <input type="text" form="saveDangerousGoods" name="dgFireworks" id="dgFireworks" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Technical Name</label>
                                            <input type="text" form="saveDangerousGoods" name="dgTechinalName" id="dgTechinalName" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary dgModal_mainClose" onclick="closeDgModalPopup()">Cancel</button>
                    </div>
                </div>

            </div>
        </div>
        <!--Modal-->

        <div class="row cargoDetails_btns">
            <div class="col-md-12 text-right">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <?php
                if (in_array('Show Quotes', $switches, true)):
                    if (in_array('Show All Rates', $switches, true)): ?>
                        <input type="hidden" id="showAllRates" name="showAllRates" form="quickbookForm" value="1">
                        <input type="hidden" id="rateCustomerProfileId" class="customerQuickbookDropDown" name="rateCustomerProfileId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateLaneRowId" class="customerQuickbookDropDown" name="rateLaneRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateServiceRowId" class="customerQuickbookDropDown" name="rateServiceRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateOfferingRowId" class="customerQuickbookDropDown" name="rateOfferingRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateRecordRowId" class="customerQuickbookDropDown" name="rateRecordRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="sessionCurrency" name="sessionCurrency" form="quickbookForm" value="<?= $sessionCurrency ?? '' ?>">
                    <?php
                    endif; ?>
                <?php
                endif; ?>
            </div>


        </div>
        <!-- end cargo Details table -->
        <!-- Modal -->
    </div>
</div>


<script>
    function getCargoMasterData() {
        const itemId = $('#itemId').val();
        if (itemId > 0) {
            let itemMasterData = <?php echo json_encode($cargosMasterData); ?>;
            const selectedCargoDetails = itemMasterData[itemId];
            const itemName = selectedCargoDetails.itemName;
            let option = "<option value='0'>Select</option>";
            option += "<option value='" + itemName + "'>" + itemName + "</option>";
            $('#packageType').html(option);
            const cargoType = selectedCargoDetails.itemId;
            $('#cargoType').val(cargoType);
            const length = selectedCargoDetails.length;
            $('#length').val(length);
            const width = selectedCargoDetails.width;
            $('#width').val(width);
            const height = selectedCargoDetails.height;
            $('#height').val(height);
            const weight = selectedCargoDetails.weight;
            $('#weight').val(weight);
            const volume = selectedCargoDetails.volume;
            $('#volume').val(volume);
            $('#quantity').val('1');
            $('#packageType option[value="' + itemName + '"]').prop("selected", true);
        }
    }

    function editCargoDetails(but, rowId, itemRowId) {
        const $row = $(but).closest('tr');
        const packageType = $row.find("td:eq(2)").text().trim();
        const quantity = $row.find("td:eq(3)").text().trim();
        const weight = $row.find("td:eq(4)").text().trim();
        const volumeTag = $row.find("td:eq(5)").text().trim();
        const volumeArray = volumeTag.split('_');
        const volume = volumeArray[0];
        const dimensions = $row.find("td:eq(6)").text().trim();
        const dimensionsArray = dimensions.split('x');
        const length = dimensionsArray[0];
        const width = dimensionsArray[1];
        const height = dimensionsArray[2];

        $('#itemId option[value="' + itemRowId + '"]').prop("selected", true);
        let itemMasterData = <?php echo json_encode($cargosMasterData); ?>;
        const selectedCargoDetails = itemMasterData[itemRowId];
        const itemName = selectedCargoDetails.itemName;
        let option = "<option value='0'>Select</option>";
        option += "<option value='" + itemName + "'>" + itemName + "</option>";
        $('#packageType').html(option);
        $('#packageType option[value="' + packageType + '"]').prop("selected", true);
        const cargoType = $('#itemId').find(":selected").text();
        $('#cargoType').val(cargoType);
        $('#quantity').val(quantity);
        $('#weight').val(weight);
        $('#volume').val(volume);
        $('#length').val(length);
        $('#width').val(width);
        $('#height').val(height);
        $('#cargoRowId').val(rowId);
        const totalVolume = parseFloat($('#totalVolumeInput').val()) - parseFloat(volume);
        $('#totalVolumeInput').val(totalVolume);
        const totalQuantity = parseFloat($('#totalQuantityInput').val()) - parseFloat(quantity);
        $('#totalQuantityInput').val(totalQuantity);
        const totalWeight = parseFloat($('#totalWeightInput').val()) - parseFloat(weight);
        $('#totalWeightInput').val(totalWeight);
        if ($('#cargoStackableValue_' + rowId).text() == "_true") {
            $('#cargoStackable').prop('checked', true);
        }
        if ($('#cargoGroundedValue_' + rowId).text() == "true") {
            $('#cargoGrounded').prop('checked', true);
        }
        if ($('#cargoSplittableValue_' + rowId).text() == "true") {
            $('#cargoSplittable').prop('checked', true);
        }
        if ($('#cargoDgValue_' + rowId).text() == "true") {
            const dgRowId = $('#dgWithCargo_' + rowId).val();
            $('#orderDgGoodsRow').val(dgRowId);
            alert(dgRowId);
            $('#cargoDg').prop('checked', true);
            $('#dgRowId').val($('#dgRowIds' + dgRowId).val());
            $('#dgUnCode').val($('#dgRowIds' + dgRowId).attr('data-unCode'));
            alert($('#dgRowIds' + dgRowId).attr('data-unCode'));
            $('#dgUnCodeName').val($('#dgRowIds' + dgRowId).attr('data-unCodeName'));
            $('#dgUnCodeClass').val($('#dgRowIds' + dgRowId).attr('data-unCodeClass'));
            $('#dgUnCodePackingGroup').val($('#dgRowIds' + dgRowId).attr('data-packagingGroup'));
            $('#dgNos').val($('#dgRowIds' + dgRowId).attr('data-nos'));
            $('#dgTunnelCode').val($('#dgRowIds' + dgRowId).attr('data-tunnelCode'));
            $('#dgNoOfPackages').val($('#dgRowIds' + dgRowId).attr('data-packages'));
            $('#dgPackageType').val($('#dgRowIds' + dgRowId).attr('data-packageType'));
            $('#dgGrossWeight').val($('#dgRowIds' + dgRowId).attr('data-gorssWeight'));
            $('#dgNetWeight').val($('#dgRowIds' + dgRowId).attr('data-netWeight'));
            $('#dgNetExplosiveMass').val($('#dgRowIds' + dgRowId).attr('data-explosiveMass'));
            $('#dgLiters').val($('#dgRowIds' + dgRowId).attr('data-liters'));
            $('#dgLimitedQuantity').val($('#dgRowIds' + dgRowId).attr('data-ltdQuantity'));
            $('#dgExpectedQuantity').val($('#dgRowIds' + dgRowId).attr('data-expQuantity'));
            $('#dgEnvironmentally').val($('#dgRowIds' + dgRowId).attr('data-environmentally'));
            $('#dgTechinalName').val($('#dgRowIds' + dgRowId).attr('data-techinalName'));
            $('#dgFireworks').val($('#dgRowIds' + dgRowId).attr('data-fireWorks'));
        }
    }

</script>
