
<div class="ref-conent">
    <style type="text/css">
        #map {
            height: 100%;
            width: 100%;
        }
        .text-box{
            width: 25%;
            height: 26px;
            padding: 5px 12px;
            font-size: 14px;
            line-height: 1.42857143;
            color: #555;
            background-color: #fff;
            background-image: none;
            border: 1px solid #ccc;
        }
        .box-header{
            color: #fff;
            background-color: #244062;
            padding: 6px;
        }
        .box-tools{
            top: 3px;
        }
        .white{
            color:#ffffff;
        }
    </style>
    <section class="content-header">
        <h1>
            <?php echo $page_title;?>
            <form method="POST" name="dashboardfrm" id="dashboardfrm" action="" style="padding-left: 18%;margin-top: -25px;">
                <input type="text" placeholder="Shipment ID/Order ID" name="shipment_id" id="shipment_id" value="<?php echo $this->input->post('shipment_id');?>" class="text-box"/>
                <div name="dbform" class="btn btn-success btn-xs" style="padding: 3px;" onclick="loadMapAjax()"><?=$this->lang->line('general_search')?></div>
            </form>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>visibility/dashboard"><i class="fa fa-home"></i> <?=$this->lang->line('general_home')?></a></li>
            <li><a href="<?php echo base_url();?>visibility/fleetview"><?=$this->lang->line('menu_visibility')?></a></li>
            <li class="active"><?=$this->lang->line('shipment')?></li>
        </ol>
    </section>
    <style type="text/css">
        .users-list>li {
            width: 12% !important;
        }

        .leaflet-label {
            padding: 0px !important;
            font-size: smaller !important;
        }

        .leaflet-right {
            right: 0;
            display: none;
        }
       
    </style>
    <section class="content">

        <div class="row">
            <!-- Left col -->
            <div class="col-md-8">
                <!-- MAP & BOX PANE -->
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title white"><?=$this->lang->line('live_shipment')?></h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body no-padding">
                        <div class="row">
                            <div class="col-md-12" style="/*padding-right: 0px;*/height: 360px;">
                                <!-- Map will be created here -->
                                <div id="world-map-markers" style="height: 100%;">
                                    <div id="searchlocationpopup" style="display:none;"></div>
                                    <div id="addtrippopup" style="display:none;"></div>
                                    <div id="geopopup" style="display:none;"><span id="ui-id-2" class="ui-dialog-title"></span></div>
                                    <div id="vehiclesList" style="display:none;overflow:visible"></div>
                                    <input type="hidden" id="hiddenuserid" value="<?php echo $this->session->userdata('user_id');?>">
                                    <input type="hidden" id="imei" value=""> <input type="hidden" id="groupid" value="">

                                    <div id="message"></div>
                                    <div id="radiuspop"></div>
                                    <div id="messagedevices"></div>
                                    <div id="map"></div>
                                </div>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
            <!-- /.col -->

            <div class="col-md-4">
                <!-- /.info-box -->
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title white"><?=$this->lang->line('intransit_shipments')?></h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body" id="shipments" style="height: 360px;overflow-y: auto;">
                    </div>
                    <!-- /.box-body -->

                    <!-- /.footer -->
                </div>
            </div>
            <!-- /.col -->
        </div>

    </section>

</div>
<?php 
    $cntrylatlng['ulat'] = 20.5937; 
    $cntrylatlng['ulng'] = 78.9629;
    if($this->session->userdata("user_id") !== FALSE){ 
        $lguid = $this->session->userdata("user_id");
        $cntrylatlng = getLogUserLatLng($lguid);
    }
?>
<script type="text/javascript">
    var ulglat = <?php echo $cntrylatlng['ulat'];?>;
    var ulglng = <?php echo $cntrylatlng['ulng'];?>;
    function getactivetrips(id=null){
        $.ajax({
            url:"<?php echo base_url();?>visibility/getActiveTrips",
            type:"POST",
            dataType:"JSON",
            data:{'shipment_id':id},
            beforeSend:function(){
                $("#shipments").html("<table width='100%' height='100%'><tr><td id='table1' style='width:100%;padding:10px' valign='top' style=''> <table class='table trips_table table-striped'><thead></thead><tbody><tr><td><center><progress></progress></center></td></tr></tbody></table></td><td id='table2' style='width:0%' class='trip_view'></td></tr></table>");
            },
            success:function(data){
                $(".trips_table tbody").html("");
                $.each(data,function(key,value){
                    $(".trips_table tbody").append("<tr><td>"+value.name+"</td></tr>");
                });
            }
        });
    }
    var currentValue = 1;
    var a = 0;
    var oTable;
    var trackerFrequency = 60000;
    $(document).ready(function() {
        $('.select_date').datepicker({
            format: "yyyy-mm-dd"
        });
        'use strict';
        initMap();
        /*getactivetrips();*/
    });

    function openTripMap(trip_id,name) {
    	$("#liveModal").modal("show");
        $("#liveModal .modal-dialog").css("width", "90%");
        $("#liveModal .modal-title").html(name);
        var h = $("#liveModal .modal-body").css("height");
        url = "<?php echo base_url();?>/visibility/tripMap/" + trip_id;
        $("#liveModal .modal-body").html("<iframe width='100%' frameBorder='0' src='" + url + "' style='height: 80vh;width:100%' id='print_modal' onload=\"ifrhgh()\"></iframe>");
        $("#liveModal .modal-body").css("overflow-y","hidden");
    }

    function checkdate(evt) {
        var keyCode = (evt.which) ? evt.which : evt.keyCode
        if (keyCode == 8 || keyCode == 73) {
            $(this).val('');
        }
        return false;
    }
    function ifrhgh(){
        var iframehght =  $("#print_frame").contents().height();
        $("#print_frame").height(iframehght);
    }
    var cw = $('.profile_pic').width(); $('.profile_pic').css({
        'height': cw + 'px'
    });

    function loadMapAjax() {
        var shipment_id = $("#shipment_id").val();
        getactivetrips(shipment_id);
        $.ajax({
            url:"<?php echo base_url();?>shift/loadMapVehicles",
            type:"POST",
            data:{shipment_id:shipment_id},
            dataType:"JSON",
            success:function(data){
                //removeAllMarkers();
                setMarkers(data);
            }
        });
    }

    //map code

    var map;
    var markers = [];

    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            zoom: 6,
            center: {
                lat: ulglat,
                lng: ulglng
            },
            styles:[{featureType:"all",stylers:[{saturation:0},{hue:"#e7ecf0"}]},{featureType:"road",stylers:[{saturation:-70}]},{featureType:"transit",stylers:[{visibility:"off"}]},{featureType:"poi",stylers:[{visibility:"off"}]},{featureType:"water",stylers:[{visibility:"simplified"},{saturation:-60}]}]
        });

        var centerControlDiv = document.createElement('div');
        var centerControl = new CenterControl(centerControlDiv, map);

        centerControlDiv.index = 1;
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(centerControlDiv);
        loadMapAjax();
        
    }
    function removeAllMarkers() {
        for (var i = 0; i < markers.length; i++) {
            markers[i].setMap(null);
        }
        markers = [];
    }
    function CenterControl(controlDiv, map) {

        // Set CSS for the control border.
        var controlUI = document.createElement('div');
        controlUI.style.backgroundColor = '#fff';
        controlUI.style.border = '2px solid #fff';
        controlUI.style.borderRadius = '3px';
        controlUI.style.boxShadow = '0 2px 6px rgba(0,0,0,.3)';
        controlUI.style.cursor = 'pointer';
        controlUI.style.margin = '10px';
        controlUI.style.textAlign = 'center';
        controlUI.title = 'Refresh';
        controlDiv.appendChild(controlUI);

        // Set CSS for the control interior.
        var controlText = document.createElement('div');
        controlText.style.color = 'rgb(25,25,25)';
        controlText.style.fontFamily = 'Roboto,Arial,sans-serif';
        controlText.style.fontSize = '16px';
        controlText.style.lineHeight = '38px';
        controlText.style.paddingLeft = '5px';
        controlText.style.paddingRight = '5px';
        controlText.innerHTML = '<i class="fas fa-refresh"></i>';
        controlUI.appendChild(controlText);

        // Setup the click event listeners: simply set the map to Chicago.
        controlUI.addEventListener('click', function() {
          loadMapAjax();
        });

    }
    function setMarkers(data) {
        data = data.data;
        var image;
        var bounds = new google.maps.LatLngBounds();
        for (var i = 0; i < data.length; i++) {
            var beach = data[i];
            if (beach[3] =="") {
                image = {
                    url: baseurl+'assets/images/icons/Red_Truck.png',
                    size: new google.maps.Size(30, 20),
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(0, 32)
                };
            } else {
                image = {
                    url: baseurl+'assets/images/icons/Blu_Truck.png',
                    size: new google.maps.Size(30, 20),
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(0, 32)
                };
            }
        var cont = "<span>"+beach[2]+"</span>";
        var pos = $(cont).find("#position").val();
        var imei = $(cont).find("#imei").val();
        var fuel = $(cont).find("#fuel").val();
        var bearing_value = $(cont).find("#bearing").val();
        var bearing ="";
        if(bearing_value!='true' && bearing_value!=0){
            bearing = bearing_value;
        }
        var trip_id = $(cont).find("#trip_id").val();
        var next_stop = $(cont).find("#next_stop").val();
        var azimuth_value = $(cont).find("#azimuth").val();
        var azimuth ="";
        if(azimuth_value == 0 || azimuth_value == 360){
            azimuth = 'North';
        }else if(azimuth_value > 0 && azimuth_value < 90){
            azimuth='North East';
        }else if(azimuth_value == 90){
            azimuth='East';
        }else if(azimuth_value > 90 && azimuth_value < 180){
            azimuth='East South';
        }else if(azimuth_value==180){
            azimuth='South';
        }else if(azimuth_value > 180 && azimuth_value < 270){
            azimuth='South West';
        }else if(azimuth_value==270){
            azimuth='West';
        }else if(azimuth_value > 270 && azimuth_value < 360){
            azimuth='West North';
        }
        var key_exist_value = $(cont).find("#key_exist").val();
        var key_exist ="";
        if(key_exist_value=='true'){
             key_exist='Switch on';
        }else {
            key_exist='Switch off';
        }
        var inouts = $(cont).find("#inouts").val();
        var shipid = $(cont).find("#shipid").val();
        var truck_number = $(cont).find("#truck_number").val();
        var trailer_imei = $(cont).find("#trailer_imei").val();
        var parts = pos.split(',');
        var vehnumber ="";
        if(beach[1] == truck_number) {
            vehnumber = "Truck Number";
        } else {
           vehnumber =  "Register Number";
        }
        var infowindow = "";
            if(shipid!=""){
             infowindow = new google.maps.InfoWindow({
                content: "<table style='font-size:10px;'>" + "<tr>" + "<th>"+vehnumber+"</th><th><button class='badge bg-green' onclick=\"openInPopup('"+imei+"','"+beach[1]+"')\">" + beach[1] + "</span></button>" + "</tr><tr>" + "<th>Trip No</th><td>:" + shipid + "</td>" + "</tr><tr>" + "<th>Current Shipment</th><td>:" + beach[5] + "</td>" + "</tr><tr>" + "<th>Speed</th><td>:" + beach[3] + "</td>" + "</tr><!--<tr>" + "<th>Azimuth</th><td>:" + azimuth + "</td>" + "</tr>--><tr>" + "<th>Counter KM</th><td>:" + bearing + "</td>" + "</tr><tr>" + "<th>Ignition</th><td>:" + key_exist + "</td>" + "</tr><!--<tr>" + "<th>Inouts</th><td>:" + inouts + "</td>" + "</tr>--><tr>" + "<th>Battery</th><td>:" + beach[4] + "</td>" + "</tr><tr>" + "<th>Fuel</th><td>:" + fuel + "</td>" + "</tr><tr>" + "<th>Driver</th><td>:" + beach[0] + "</td>" + "</tr><tr>" + "<th>Place</th><td>:" + beach[2] + "</td>" + "</tr><tr>" + "<th>Last Received Time</th><td>:" + beach[6] + "</td>" + "</tr>" +"<tr><th>Next Stop </th><td>:"+next_stop+"</td></tr><tr><td colspan='2'><button class='badge bg-blue' onclick=\"openInVideoPopup('"+imei+"')\">Video</button> | <button class='badge bg-yellow' onclick=\"openScreenInPopup('"+imei+"')\">Screen</button></td></tr>"+ "</table>"
                   });
            }else{
                infowindow = new google.maps.InfoWindow({
                    content: "<table style='font-size:10px;'>" + "<tr>" + "<th>"+vehnumber+"</th><th><button class='badge bg-green' onclick=\"openInPopup('"+imei+"','"+beach[1]+"')\">" + beach[1] + "</span></button>" + "</tr><tr>" + "<th>Current Shipment</th><td>:" + beach[5] + "</td>" + "</tr><tr>" + "<th>Speed</th><td>:" + beach[3] + "</td>" + "</tr><!--<tr>" + "<th>Azimuth</th><td>:" + azimuth + "</td>" + "</tr>--><tr>" + "<th>Counter KM</th><td>:" + bearing + "</td>" + "</tr><tr>" + "<th>Ignition</th><td>:" + key_exist + "</td>" + "</tr><!--<tr>" + "<th>Inouts</th><td>:" + inouts + "</td>" + "</tr>--><tr>" + "<th>Battery</th><td>:" + beach[4] + "</td>" + "</tr><tr>" + "<th>Fuel</th><td>:" + fuel + "</td>" + "</tr><tr>" + "<th>Driver</th><td>:" + beach[0] + "</td>" + "</tr><tr>" + "<th>Place</th><td>:" + beach[2] + "</td>" + "</tr><tr>" + "<th>Last Received Time</th><td>:" + beach[6] + "</td>" + "</tr>" +"<tr><th>Next Stop </th><td>:"+next_stop+"</td></tr><tr><td colspan='2'><button class='badge bg-blue' onclick=\"openInVideoPopup('"+imei+"')\">Video</button> | <button class='badge bg-yellow' onclick=\"openScreenInPopup('"+imei+"')\">Screen</button></td></tr>"+ "</table>"
                });
            }
            if(parts[0]!="" && parts[1]!=""){
                var newPosition = {lat: parseFloat(parts[0]),lng: parseFloat(parts[1])};
                if(markers.length<=data.length){
                    var marker = new google.maps.Marker({
                        position: newPosition,
                        map: map,
                        icon: image,
                        infowindow: infowindow
                    });
                    markers.push(marker);
                }else{
                    if(imei=="0" || imei==""){
                        var marker = new google.maps.Marker({
                            position: newPosition,
                            map: map,
                            icon: image,
                            infowindow: infowindow
                        });
                        markers[i] = marker;
                    } else{
                        var marker = markers[i];
                        newPosition = new google.maps.LatLng(parseFloat(parts[0]), parseFloat(parts[1]));
                        marker.animateTo(map,newPosition, { duration: trackerFrequency });
                    }
                }
                //
                bounds.extend(marker.position);
                google.maps.event.addListener(marker, 'click', function() {
                    this.infowindow.open(map, this);
                });
            }
        }
        map.fitBounds(bounds);
    }
    function openInPopup(url, veh) {
        url = "<?=base_url('visibility/opensinglemap/')?>?imei=" + url+"&veh="+veh;
        $("#liveModal").modal("show");
        $("#liveModal .modal-title").html(veh);
        $("#liveModal .modal-body").css("padding", "0px");
        $("#liveModal .modal-body").css("height", "80vh");
        $("#liveModal .modal-dialog").css("margin-top", "5vh");
        $("#liveModal .modal-body").css("overflow", "auto");
        $("#liveModal .modal-dialog").css("width", "70%");
        $("#liveModal .modal-body").html("<iframe width='100%' frameBorder='0' src='" + url + "' style='height: 100%;'></iframe>");
    }
google.maps.Marker.prototype.animateTo = function(googleMap=null,newPosition, options) {
  defaultOptions = {
    duration: 1000,
    easing: 'linear',
    complete: null
  }
  options = options || {};

  // complete missing options
  for (key in defaultOptions) {
    options[key] = options[key] || defaultOptions[key];
  }

  // throw exception if easing function doesn't exist
  if (options.easing != 'linear') {            
    if (typeof jQuery == 'undefined' || !jQuery.easing[options.easing]) {
      throw '"' + options.easing + '" easing function doesn\'t exist. Include jQuery and/or the jQuery easing plugin and use the right function name.';
      return;
    }
  }
  
  window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
  window.cancelAnimationFrame = window.cancelAnimationFrame || window.mozCancelAnimationFrame;

  // save current position. prefixed to avoid name collisions. separate for lat/lng to avoid calling lat()/lng() in every frame
  this.AT_startPosition_lat = this.getPosition().lat();
  this.AT_startPosition_lng = this.getPosition().lng();
  var newPosition_lat = newPosition.lat();
  var newPosition_lng = newPosition.lng();

  // crossing the 180Â° meridian and going the long way around the earth?
  if (Math.abs(newPosition_lng - this.AT_startPosition_lng) > 180) {
    if (newPosition_lng > this.AT_startPosition_lng) {      
      newPosition_lng -= 360;      
    } else {
      newPosition_lng += 360;
    }
  }

  var animateStep = function(marker, startTime) {            
    var ellapsedTime = (new Date()).getTime() - startTime;
    var durationRatio = ellapsedTime / options.duration; // 0 - 1
    var easingDurationRatio = durationRatio;

    // use jQuery easing if it's not linear
    if (options.easing !== 'linear') {
      easingDurationRatio = jQuery.easing[options.easing](durationRatio, ellapsedTime, 0, 1, options.duration);
    }
    
    if (durationRatio < 1) {
      var deltaPosition = new google.maps.LatLng( marker.AT_startPosition_lat + (newPosition_lat - marker.AT_startPosition_lat)*easingDurationRatio,
                                                  marker.AT_startPosition_lng + (newPosition_lng - marker.AT_startPosition_lng)*easingDurationRatio);
      // if(googleMap!=null){
      //   googleMap.panTo(deltaPosition);
      //   googleMap.setZoom(19);
      // }
      marker.setPosition(deltaPosition);

      // use requestAnimationFrame if it exists on this browser. If not, use setTimeout with ~60 fps
      if (window.requestAnimationFrame) {
        marker.AT_animationHandler = window.requestAnimationFrame(function() {animateStep(marker, startTime)});                
      } else {
        marker.AT_animationHandler = setTimeout(function() {animateStep(marker, startTime)}, 17); 
      }

    } else {
      
      marker.setPosition(newPosition);

      if (typeof options.complete === 'function') {
        options.complete();
      }

    }            
  }

  // stop possibly running animation
  if (window.cancelAnimationFrame) {
    window.cancelAnimationFrame(this.AT_animationHandler);
  } else {
    clearTimeout(this.AT_animationHandler); 
  }
  
  animateStep(this, (new Date()).getTime());
}
</script>
<!-- Modal -->
<div id="liveModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Modal Header</h4>
            </div>
            <div class="modal-body">
                <center class="center-div"><progress></progress></center>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.datatables.net/1.10.15/js/jquery.dataTables.min.js" integrity="<?=SHA_JQUERY_DATATABLES_MIN_JS_V10_15?>" crossorigin="anonymous"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.15/css/jquery.dataTables.min.css">